/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class HttpdConfParser {
    private final Log log = LogFactory.getLog(HttpdConfParser.class);
    private Set<String> vhosts = new HashSet<String>();
    private boolean modJkInstalled;
    private String workerPropertiesFile;
    private String uriWorkerLocation;
    private String mainServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(String confPath) {
        File file = new File(confPath);
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            this.log.warn((Object)("Config file " + confPath + " is not readable, mod_jk can not be detected"));
            return false;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String tmp = this.getValueFrom2ndArg(line);
                if (line.startsWith("LoadModule") && line.contains("jk_module")) {
                    this.modJkInstalled = true;
                    continue;
                }
                if (line.startsWith("JkWorkersFile")) {
                    if (tmp == null) continue;
                    this.workerPropertiesFile = tmp;
                    continue;
                }
                if (line.startsWith("<VirtualHost")) {
                    if (tmp == null) continue;
                    this.vhosts.add(tmp);
                    continue;
                }
                if (line.startsWith("JkMountFile")) {
                    if (tmp == null) continue;
                    this.uriWorkerLocation = tmp;
                    continue;
                }
                if (line.startsWith("JkMount") && !line.startsWith("JkMountFile") || !line.startsWith("Listen") || tmp == null) continue;
                this.mainServer = tmp;
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Can't process " + confPath + " :" + ioe.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    @Nullable
    private String getValueFrom2ndArg(String input) {
        if (input == null) {
            return null;
        }
        String ret = null;
        String[] tokens = input.split("\\s");
        if (tokens.length > 1) {
            ret = tokens[1];
        }
        return ret;
    }

    public Set<String> getVhosts() {
        return this.vhosts;
    }

    public String getWorkerPropertiesFile() {
        return this.workerPropertiesFile;
    }

    public boolean isModJkInstalled() {
        return this.modJkInstalled;
    }

    public String getUriWorkerLocation() {
        return this.uriWorkerLocation;
    }

    public String getMainServer() {
        return this.mainServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpdConfParser");
        sb.append("{listen=").append(this.mainServer);
        sb.append(", vhosts=").append(this.vhosts);
        sb.append(", modJkInstalled=").append(this.modJkInstalled);
        sb.append(", workerPropertiesFile='").append(this.workerPropertiesFile).append('\'');
        sb.append(", uriWorkerLocation='").append(this.uriWorkerLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

