/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageFinder {
    private List<File> jarLocations;

    public PackageFinder(List<File> jarLocations) {
        this.jarLocations = new ArrayList<File>(jarLocations);
    }

    public Set<String> findPackages(String packageRoot) throws IOException {
        HashSet<String> found = new HashSet<String>();
        ArrayList<File> jars = new ArrayList<File>();
        for (File loc : this.jarLocations) {
            if (!loc.exists()) continue;
            jars.addAll(Arrays.asList(loc.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            })));
        }
        jars.addAll(this.loadResourcesFromClassPath(packageRoot, "jar:file:"));
        for (File jar : jars) {
            this.findPackagesInJar(packageRoot, found, jar);
        }
        List<File> dirs = this.loadResourcesFromClassPath(packageRoot, "file:");
        for (File d : dirs) {
            this.findPackagesInDirectory(packageRoot, found, d);
        }
        return found;
    }

    private List<File> loadResourcesFromClassPath(String pkgRoot, String prefix) throws IOException {
        ArrayList<File> jarFiles = new ArrayList<File>();
        String pkgPath = pkgRoot.replaceAll("\\.", "/");
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(pkgPath);
        URL resource = null;
        while (resources.hasMoreElements()) {
            resource = resources.nextElement();
            if (!resource.toString().startsWith(prefix)) continue;
            String jarFilePath = this.getFilePath(resource, prefix);
            jarFiles.add(new File(jarFilePath));
        }
        return jarFiles;
    }

    private String getFilePath(URL resource, String prefix) {
        int startIndex = prefix.length();
        String string = resource.toString().substring(startIndex);
        int endIndex = string.indexOf("!");
        if (endIndex < 0) {
            endIndex = string.length();
        }
        return string.substring(0, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPackagesInJar(String packageRoot, Set<String> list, File jar) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        JarFile jf = null;
        try {
            jf = new JarFile(jar);
            String packagePath = packageRoot.replaceAll("\\.", "/");
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(packagePath)) continue;
                String match = entry.getName().substring(0, entry.getName().lastIndexOf("/"));
                paths.add(match.replaceAll("/", "\\."));
            }
            list.addAll(paths);
        }
        finally {
            try {
                if (jf != null) {
                    jf.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void findPackagesInDirectory(String packageRoot, Set<String> list, File dir) throws IOException {
        File[] subDirs;
        for (File s : subDirs = dir.listFiles()) {
            if (!s.isDirectory()) continue;
            String packageName = packageRoot + "." + s.getName();
            list.add(packageName);
            this.findPackagesInDirectory(packageName, list, s);
        }
    }
}

