/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jboss.on.common.jbossas.JBossASDiscoveryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.pluginapi.util.JavaCommandLine;
import org.rhq.core.pluginapi.util.ServerStartScriptDiscoveryUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jbossas5.InProcessJBossASDiscovery;
import org.rhq.plugins.jbossas5.helper.JBossInstallationInfo;
import org.rhq.plugins.jbossas5.helper.JBossInstanceInfo;
import org.rhq.plugins.jbossas5.helper.JBossProductType;
import org.rhq.plugins.jbossas5.util.JnpConfig;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

public class ApplicationServerDiscoveryComponent
implements ResourceDiscoveryComponent,
ClassLoaderFacet,
ManualAddFacet {
    private static final String JBOSS_SERVICE_XML = "conf" + File.separator + "jboss-service.xml";
    private static final String JBOSS_NAMING_SERVICE_XML = "deploy" + File.separator + "naming-service.xml";
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private static final Map<JBossProductType, ComparableVersion> MINIMUM_PRODUCT_VERSIONS = new HashMap<JBossProductType, ComparableVersion>(4);
    private static final String[] CLIENT_JAR_URLS;
    private static final Set<String> START_SCRIPT_ENV_VAR_NAMES;
    private static final Set<CommandLineOption> START_SCRIPT_OPTION_EXCLUDES;
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) {
        this.log.trace((Object)"Discovering JBoss AS 5.x and 6.x Resources...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        DiscoveredResourceDetails inProcessJBossAS = this.discoverInProcessJBossAS(discoveryContext);
        if (inProcessJBossAS != null) {
            resources.add(inProcessJBossAS);
        } else {
            resources.addAll(this.discoverExternalJBossAsProcesses(discoveryContext));
        }
        this.log.trace((Object)("Discovered " + resources.size() + " JBossAS 5.x and 6.x Resources."));
        return resources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        JBossInstallationInfo installInfo;
        ProcessInfo processInfo = null;
        String jbossHomeDir = pluginConfig.getSimple("homeDir").getStringValue();
        try {
            installInfo = new JBossInstallationInfo(new File(jbossHomeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, installInfo);
        return resourceDetails;
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext context, DiscoveredResourceDetails details) throws Exception {
        Configuration pluginConfig = details.getPluginConfiguration();
        this.setValuesForUnsetClientJarUrlProperties(pluginConfig);
        ArrayList<URL> clientJarUrls = new ArrayList<URL>();
        for (String clientJarUrlString : CLIENT_JAR_URLS) {
            URL clientJarUrl = new URL(clientJarUrlString = ResourceComponentUtils.replacePropertyExpressionsInTemplate(clientJarUrlString, pluginConfig));
            if (this.isReadable(clientJarUrl)) {
                clientJarUrls.add(clientJarUrl);
                continue;
            }
            this.log.warn((Object)("Client JAR [" + clientJarUrl + "] does not exist or is not readable (note, this JAR " + " may not be required for some app server versions)."));
        }
        return clientJarUrls;
    }

    private boolean isReadable(URL url) {
        try {
            InputStream inputStream = url.openStream();
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to close input stream for URL [" + url + "]."), (Throwable)e);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void setValuesForUnsetClientJarUrlProperties(Configuration pluginConfig) throws MalformedURLException {
        String commonLibUrlString;
        String libUrlString;
        String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
        URL homeUrl = new File(homeDir).toURI().toURL();
        String clientUrlString = pluginConfig.getSimpleValue("clientUrl", null);
        if (clientUrlString == null) {
            URL clientUrl = new URL(homeUrl, "client");
            pluginConfig.put((Property)new PropertySimple("clientUrl", (Object)clientUrl));
        }
        if ((libUrlString = pluginConfig.getSimpleValue("libUrl", null)) == null) {
            URL libUrl = new URL(homeUrl, "lib");
            pluginConfig.put((Property)new PropertySimple("libUrl", (Object)libUrl));
        }
        if ((commonLibUrlString = pluginConfig.getSimpleValue("commonLibUrl", null)) == null) {
            URL commonLibUrl = new URL(homeUrl, "common/lib");
            pluginConfig.put((Property)new PropertySimple("commonLibUrl", (Object)commonLibUrl));
        }
    }

    private Set<DiscoveredResourceDetails> discoverExternalJBossAsProcesses(ResourceDiscoveryContext discoveryContext) {
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            String javaHome;
            File configDir;
            File installHome;
            JBossInstallationInfo installInfo;
            JBossInstanceInfo jbossInstanceInfo;
            ProcessInfo processInfo;
            block10: {
                processInfo = autoDiscoveryResult.getProcessInfo();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Discovered JBoss AS process: " + processInfo));
                }
                try {
                    jbossInstanceInfo = new JBossInstanceInfo(processInfo);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to process JBoss AS command line: " + Arrays.asList(processInfo.getCommandLine())), (Throwable)e);
                    continue;
                }
                installInfo = jbossInstanceInfo.getInstallInfo();
                if (!this.isSupportedProduct(installInfo)) continue;
                installHome = new File(jbossInstanceInfo.getSystemProperties().getProperty("jboss.home.dir"));
                configDir = new File(jbossInstanceInfo.getSystemProperties().getProperty("jboss.server.home.dir"));
                try {
                    if (!configDir.getCanonicalFile().isDirectory()) {
                        this.log.warn((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' does not exist or is not a directory."));
                    }
                    break block10;
                }
                catch (IOException e) {
                    this.log.error((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' could not be canonicalized."), (Throwable)e);
                }
                continue;
            }
            Configuration pluginConfiguration = discoveryContext.getDefaultPluginConfiguration();
            String jnpURL = this.getJnpURL(jbossInstanceInfo, installHome, configDir);
            PropertySimple namingUrlProp = new PropertySimple("namingURL", (Object)jnpURL);
            if (jnpURL == null) {
                namingUrlProp.setErrorMessage("RHQ failed to discover the naming provider URL.");
            }
            pluginConfiguration.put((Property)namingUrlProp);
            pluginConfiguration.put((Property)new PropertySimple("homeDir", (Object)installHome.getAbsolutePath()));
            pluginConfiguration.put((Property)new PropertySimple("serverHomeDir", (Object)configDir));
            pluginConfiguration.put((Property)new PropertySimple("serverName", (Object)jbossInstanceInfo.getSystemProperties().getProperty("jboss.server.name")));
            pluginConfiguration.put((Property)new PropertySimple("bindAddress", (Object)jbossInstanceInfo.getSystemProperties().getProperty("jboss.bind.address")));
            JBossASDiscoveryUtils.UserInfo userInfo = JBossASDiscoveryUtils.getJmxInvokerUserInfo((File)configDir);
            if (userInfo != null) {
                pluginConfiguration.put((Property)new PropertySimple("principal", (Object)userInfo.getUsername()));
                pluginConfiguration.put((Property)new PropertySimple("credentials", (Object)userInfo.getPassword()));
            }
            if ((javaHome = processInfo.getEnvironmentVariable(JAVA_HOME_ENV_VAR)) == null && this.log.isDebugEnabled()) {
                this.log.warn((Object)"Unable to determine the JAVA_HOME environment variable for the JBoss AS process -  the Agent is probably running as a user that does not have access to the AS process's  environment.");
            }
            pluginConfiguration.put((Property)new PropertySimple("javaHome", (Object)javaHome));
            this.initLogEventSourcesConfigProp(configDir, pluginConfiguration);
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfiguration, processInfo, installInfo);
            resources.add(resourceDetails);
        }
        return resources;
    }

    @Nullable
    private DiscoveredResourceDetails discoverInProcessJBossAS(ResourceDiscoveryContext discoveryContext) {
        try {
            return new InProcessJBossASDiscovery().discoverInProcessJBossAS(discoveryContext);
        }
        catch (Throwable t) {
            this.log.debug((Object)"In-process JBoss AS discovery failed - we are probably not running embedded within JBoss AS.", t);
            return null;
        }
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig, @Nullable ProcessInfo processInfo, JBossInstallationInfo installInfo) {
        boolean isRhqServer;
        URI uri;
        String serverHomeDir = pluginConfig.getSimple("serverHomeDir").getStringValue();
        File absoluteConfigPath = ApplicationServerDiscoveryComponent.resolvePathRelativeToHomeDir(pluginConfig, serverHomeDir);
        String key = FileUtils.getCanonicalPath((String)absoluteConfigPath.getPath());
        String bindAddress = pluginConfig.getSimple("bindAddress").getStringValue();
        String namingUrl = pluginConfig.getSimple("namingURL").getStringValue();
        String namingPort = null;
        if (namingUrl != null && (uri = URI.create(namingUrl)).getPort() != -1) {
            namingPort = String.valueOf(uri.getPort());
        }
        JBossProductType productType = installInfo.getProductType();
        String description = productType.DESCRIPTION + " " + installInfo.getMajorVersion();
        File deployDir = new File(absoluteConfigPath, "deploy");
        File rhqInstallerWar = new File(deployDir, "rhq-installer.war");
        File rhqInstallerWarUndeployed = new File(deployDir, "rhq-installer.war.rej");
        boolean bl = isRhqServer = rhqInstallerWar.exists() || rhqInstallerWarUndeployed.exists();
        if (isRhqServer) {
            description = description + " hosting the RHQ Server";
            this.configureEventSourceForServerLogFile(pluginConfig);
        }
        String PRODUCT_PREFIX = productType.name() + " ";
        String name = PRODUCT_PREFIX + this.formatServerName(bindAddress, namingPort, discoveryContext.getSystemInformation().getHostname(), absoluteConfigPath.getName(), isRhqServer);
        if (processInfo != null) {
            this.setStartScriptPluginConfigProps(processInfo, new JavaCommandLine(processInfo.getCommandLine()), pluginConfig);
        }
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, PRODUCT_PREFIX + installInfo.getVersion(), description, pluginConfig, processInfo);
    }

    private void setStartScriptPluginConfigProps(ProcessInfo process, JavaCommandLine commandLine, Configuration pluginConfig) {
        StartScriptConfiguration startScriptConfig = new StartScriptConfiguration(pluginConfig);
        ProcessInfo parentProcess = process.getParentProcess();
        File startScript = ServerStartScriptDiscoveryUtility.getStartScript((ProcessInfo)parentProcess);
        if (startScript != null) {
            boolean exists = startScript.exists();
            if (!exists && !startScript.isAbsolute()) {
                File homeDir = new File(pluginConfig.getSimpleValue("homeDir"));
                File startScriptAbsolute = new File(homeDir, startScript.getPath());
                exists = startScriptAbsolute.exists();
            }
            if (!exists) {
                this.log.warn((Object)("Discovered startScriptFile [" + startScript + "] but failed to find it on disk. The start script may not be correct. The command line used for discovery is [" + commandLine + "]"));
            }
            startScriptConfig.setStartScript(startScript);
        }
        Map startScriptEnv = ServerStartScriptDiscoveryUtility.getStartScriptEnv((ProcessInfo)process, (ProcessInfo)parentProcess, START_SCRIPT_ENV_VAR_NAMES);
        startScriptConfig.setStartScriptEnv(startScriptEnv);
        List startScriptArgs = ServerStartScriptDiscoveryUtility.getStartScriptArgs((ProcessInfo)parentProcess, (List)commandLine.getClassArguments(), START_SCRIPT_OPTION_EXCLUDES);
        startScriptConfig.setStartScriptArgs(startScriptArgs);
    }

    public String formatServerName(String bindingAddress, String jnpPort, String hostname, String configurationName, boolean isRhq) {
        if (isRhq) {
            return hostname + " RHQ Server";
        }
        String hostnameToUse = hostname;
        if (bindingAddress != null) {
            try {
                InetAddress bindAddr = InetAddress.getByName(bindingAddress);
                if (!bindAddr.isAnyLocalAddress()) {
                    hostnameToUse = bindAddr.getHostName();
                }
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)("Unknown hostname passed in as the binding address for JBoss AS server discovery: " + bindingAddress));
            }
        }
        if (jnpPort != null) {
            hostnameToUse = hostnameToUse + ":" + jnpPort;
        }
        return hostnameToUse + " " + configurationName;
    }

    private void configureEventSourceForServerLogFile(Configuration pluginConfig) {
        File rhqLogFile = ApplicationServerDiscoveryComponent.resolvePathRelativeToHomeDir(pluginConfig, "../logs/rhq-server-log4j.log");
        if (rhqLogFile.exists() && !rhqLogFile.isDirectory()) {
            try {
                PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
                serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)rhqLogFile.getCanonicalPath()));
                serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
                serverLogEventSource.put((Property)new PropertySimple("minimumSeverity", (Object)"info"));
                PropertyList logEventSources = pluginConfig.getList("logEventSources");
                logEventSources.add((Property)serverLogEventSource);
            }
            catch (IOException e) {
                this.log.warn((Object)"Unable to setup RHQ Server log file monitoring.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJnpURL(JBossInstanceInfo cmdLine, File installHome, File configDir) {
        Integer jnpPort;
        File jnpServiceUrlFile = new File(configDir, "data/jnp-service.url");
        if (jnpServiceUrlFile.exists() && jnpServiceUrlFile.canRead()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(jnpServiceUrlFile));
                String jnpUrl = br.readLine();
                if (jnpUrl != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Read JNP URL from jnp-service.url file: " + jnpUrl));
                    }
                    String string = jnpUrl;
                    return string;
                }
            }
            catch (IOException ioe) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.log.warn((Object)("Failed to read JNP URL from '" + jnpServiceUrlFile + "'."));
        JnpConfig jnpConfig = ApplicationServerDiscoveryComponent.getJnpConfig(installHome, configDir, cmdLine.getSystemProperties());
        String jnpAddress = jnpConfig.getJnpAddress() != null ? jnpConfig.getJnpAddress() : null;
        Integer n = jnpPort = jnpConfig.getJnpPort() != null ? jnpConfig.getJnpPort() : null;
        if (jnpAddress == null || jnpPort == null) {
            this.log.warn((Object)("Failed to discover JNP URL for JBoss instance with configuration directory [" + configDir + "]."));
            return null;
        }
        if (ANY_ADDRESS.equals(jnpAddress)) {
            jnpAddress = LOCALHOST;
        }
        return "jnp://" + jnpAddress + ":" + jnpPort;
    }

    private static JnpConfig getJnpConfig(File installHome, File configDir, Properties props) {
        File namingServiceFile;
        File serviceXML = new File(configDir, JBOSS_SERVICE_XML);
        JnpConfig config = JnpConfig.getConfig(serviceXML, props);
        if ((config == null || config.getJnpPort() == null) && (namingServiceFile = new File(configDir, JBOSS_NAMING_SERVICE_XML)).exists()) {
            config = JnpConfig.getConfig(namingServiceFile, props);
        }
        return config;
    }

    private void initLogEventSourcesConfigProp(File configDir, Configuration pluginConfig) {
        File logDir = new File(configDir, "log");
        File serverLogFile = new File(logDir, "server.log");
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            PropertyList logEventSources = pluginConfig.getList("logEventSources");
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private boolean isSupportedProduct(JBossInstallationInfo installInfo) {
        boolean supported;
        ComparableVersion version = new ComparableVersion(installInfo.getVersion());
        JBossProductType productType = installInfo.getProductType();
        ComparableVersion minimumVersion = MINIMUM_PRODUCT_VERSIONS.get((Object)productType);
        if (minimumVersion != null) {
            boolean bl = supported = version.compareTo((Object)minimumVersion) >= 0;
            if (!supported) {
                this.log.debug((Object)((Object)((Object)productType) + " version " + version + " is not supported by this plugin (minimum " + (Object)((Object)productType) + " version is " + minimumVersion + ") - skipping..."));
            }
        } else {
            supported = true;
        }
        return supported;
    }

    @NotNull
    private static File resolvePathRelativeToHomeDir(Configuration pluginConfig, @NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
            configDir = new File(homeDir, path);
        }
        return configDir;
    }

    static {
        MINIMUM_PRODUCT_VERSIONS.put(JBossProductType.AS, new ComparableVersion("5.2.0.Beta1"));
        MINIMUM_PRODUCT_VERSIONS.put(JBossProductType.EAP, new ComparableVersion("5.0.0.Beta"));
        MINIMUM_PRODUCT_VERSIONS.put(JBossProductType.EWP, new ComparableVersion("5.0.0.CR1"));
        MINIMUM_PRODUCT_VERSIONS.put(JBossProductType.SOA, new ComparableVersion("5.0.0.Beta"));
        CLIENT_JAR_URLS = new String[]{"%clientUrl%/jbossall-client.jar", "%clientUrl%/trove.jar", "%clientUrl%/javassist.jar", "%commonLibUrl%/jboss-security-aspects.jar", "%libUrl%/jboss-managed.jar", "%libUrl%/jboss-metatype.jar", "%libUrl%/jboss-dependency.jar", "%libUrl%/jboss-reflect.jar", "%libUrl%/jboss-classpool.jar", "%libUrl%/jboss-classpool-scoped.jar", "%commonLibUrl%/jboss-as-profileservice.jar", "%libUrl%/jboss-profileservice-spi.jar"};
        START_SCRIPT_ENV_VAR_NAMES = new LinkedHashSet<String>();
        START_SCRIPT_OPTION_EXCLUDES = new HashSet<CommandLineOption>();
        START_SCRIPT_ENV_VAR_NAMES.addAll(Arrays.asList(JAVA_HOME_ENV_VAR, "JAVA", "JAVAC_JAR", "JBOSS_HOME", "JBOSS_BASE_DIR", "JBOSS_LOG_DIR", "JBOSS_CONFIG_DIR", "RUN_CONF", "MAX_FD", "PROFILER"));
        if (File.separatorChar == '\\') {
            START_SCRIPT_ENV_VAR_NAMES.add("ECHO");
            START_SCRIPT_ENV_VAR_NAMES.add("NOPAUSE");
        }
    }
}

