/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.plugins.jbossas5.helper.JBossProductType;

public class JBossInstallationInfo {
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST_ADDRESS = "127.0.0.1";
    private static final String SOA_IMPL_VERSION_PREFIX = "SOA-";
    private static final String EAP_IMPL_VERSION_PREFIX = "EAP-";
    private static final String EPP_IMPL_VERSION_PREFIX = "JBoss-EPP";
    private static final ComparableVersion VERSION_4_2 = new ComparableVersion("4.2");
    private JBossProductType productType;
    private String version;
    private String defaultBindAddress;
    private boolean isEap;
    private String majorVersion;

    public JBossInstallationInfo(File installationDir) throws IOException {
        File binDir = new File(installationDir, "bin");
        File runJar = new File(binDir, "run.jar");
        if (!runJar.exists()) {
            throw new RuntimeException(runJar + " does not exist - " + installationDir + " does not appear to be a JBoss installation/home directory.");
        }
        Attributes jarManifestAttributes = JBossInstallationInfo.loadManifestAttributesFromJar(runJar);
        this.productType = JBossProductType.determineJBossProductType(jarManifestAttributes);
        this.version = JBossInstallationInfo.getVersion(jarManifestAttributes);
        int majorVersionIndex = this.version.indexOf(46);
        if (-1 == majorVersionIndex) {
            throw new RuntimeException("Unexpected run.jar implementation version, can't parse: " + this.version);
        }
        this.fixProductTypeAndVersion(jarManifestAttributes, installationDir);
        this.defaultBindAddress = JBossInstallationInfo.getDefaultServerName(this.version);
        this.isEap = JBossInstallationInfo.determineEap(jarManifestAttributes);
        this.majorVersion = this.version.substring(0, this.version.indexOf(46));
    }

    private void fixProductTypeAndVersion(Attributes jarManifestAttributes, File installationDir) {
        File client;
        if (this.productType == JBossProductType.EWP && this.version.startsWith("5.1") && (client = new File(installationDir, "client")).exists() && client.isDirectory()) {
            boolean containsBrmsJars = false;
            for (String file : client.list()) {
                if (!file.endsWith("BRMS.jar")) continue;
                containsBrmsJars = true;
                break;
            }
            if (containsBrmsJars) {
                this.productType = JBossProductType.BRMS;
                if ("5.1.1".equals(this.version)) {
                    this.version = "5.2.0";
                }
            }
        }
    }

    public JBossProductType getProductType() {
        return this.productType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultBindAddress() {
        return this.defaultBindAddress;
    }

    public boolean isEap() {
        return this.isEap;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    private static Attributes loadManifestAttributesFromJar(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Attributes mainAttributes = jar.getManifest().getMainAttributes();
        jar.close();
        return mainAttributes;
    }

    private static String getVersion(Attributes jarManifestAttributes) {
        int spaceIndex;
        String version;
        String implementationVersion = jarManifestAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (implementationVersion.startsWith(EPP_IMPL_VERSION_PREFIX)) {
            implementationVersion = implementationVersion.substring(EPP_IMPL_VERSION_PREFIX.length()).trim();
        }
        if ((version = implementationVersion.substring(0, spaceIndex = JBossInstallationInfo.validateImplementationVersion(implementationVersion))).startsWith(SOA_IMPL_VERSION_PREFIX)) {
            version = version.substring(SOA_IMPL_VERSION_PREFIX.length());
        }
        if (version.startsWith(EAP_IMPL_VERSION_PREFIX)) {
            version = version.substring(EAP_IMPL_VERSION_PREFIX.length());
        }
        return version;
    }

    private static boolean determineEap(Attributes jarManifestAttributes) {
        String implementationTitle = jarManifestAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        return implementationTitle.contains("[EAP]");
    }

    private static int validateImplementationVersion(String implementationVersion) {
        if (implementationVersion == null) {
            throw new IllegalStateException("'" + Attributes.Name.IMPLEMENTATION_VERSION + "' MANIFEST.MF attribute not found.");
        }
        int spaceIndex = implementationVersion.indexOf(32);
        if (spaceIndex == -1) {
            throw new IllegalStateException("'" + Attributes.Name.IMPLEMENTATION_VERSION + "' MANIFEST.MF attribute has an invalid value: " + implementationVersion);
        }
        return spaceIndex;
    }

    private static String getDefaultServerName(String serverVersion) {
        ComparableVersion comparableVersion = new ComparableVersion(serverVersion);
        return comparableVersion.compareTo((Object)VERSION_4_2) >= 0 ? LOCALHOST_ADDRESS : ANY_ADDRESS;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[productType=" + (Object)((Object)this.productType) + ", version=" + this.version + ", defaultBindAddress=" + this.defaultBindAddress + "]";
    }
}

