/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.serviceBinding;

import java.util.HashSet;
import java.util.Set;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.serviceBinding.ManagerComponent;
import org.rhq.plugins.jbossas5.serviceBinding.Util;

public class SetDiscoveryComponent
implements ResourceDiscoveryComponent<ManagerComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ManagerComponent> context) throws InvalidPluginConfigurationException, Exception {
        ResourceType resourceType = context.getResourceType();
        ManagerComponent managerResourceComponent = (ManagerComponent)context.getParentResourceComponent();
        managerResourceComponent.getConnection().getManagementView().load();
        ManagedComponent bindingManagerComponent = managerResourceComponent.getBindingManager();
        CollectionValue bindingSets = (CollectionValue)bindingManagerComponent.getProperty("bindingSets").getValue();
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(bindingSets.getSize());
        for (MetaValue m : bindingSets.getElements()) {
            CompositeValue bindingSet = (CompositeValue)m;
            String bindingSetName = Util.getValue(bindingSet, "name", String.class);
            String resourceKey = ((ManagerComponent)context.getParentResourceComponent()).getBindingSetResourceKey(bindingSetName);
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, bindingSetName, null, resourceType.getDescription(), context.getDefaultPluginConfiguration(), null);
            discoveredResources.add(resource);
        }
        return discoveredResources;
    }
}

