/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSubject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;

public class SubjectsSender
extends AlertSender {
    public SenderResult send(Alert alert) {
        List<Integer> subjectIds = this.getSubjectIdsFromConfiguration();
        if (subjectIds == null) {
            return SenderResult.getSimpleFailure((String)"No subjects defined");
        }
        List<String> names = this.getSubjectNames(subjectIds);
        List<String> emails = this.getSubjectEmails(subjectIds);
        try {
            HashSet<String> uniqueEmails = new HashSet<String>(emails);
            Collection badEmails = LookupUtil.getAlertManager().sendAlertNotificationEmails(alert, uniqueEmails);
            ArrayList<String> goodEmails = new ArrayList<String>(uniqueEmails);
            goodEmails.removeAll(badEmails);
            SenderResult result = new SenderResult();
            result.setSummary("Target subjects were: " + names);
            if (goodEmails.size() > 0) {
                result.addSuccessMessage("Successfully sent to: " + goodEmails);
            }
            if (badEmails.size() > 0) {
                result.addFailureMessage("Failed to send to: " + badEmails);
            }
            return result;
        }
        catch (Throwable t) {
            return SenderResult.getSimpleFailure((String)("Error sending subject notifications to " + names + ", cause: " + t.getMessage()));
        }
    }

    public String previewConfiguration() {
        List<Integer> subjectIds = this.getSubjectIdsFromConfiguration();
        if (subjectIds == null || subjectIds.size() == 0) {
            return "<empty>";
        }
        List<String> names = this.getSubjectNames(subjectIds);
        String nameString = names.toString();
        return nameString.substring(1, nameString.length() - 1);
    }

    private List<String> getSubjectNames(List<Integer> subjectIds) {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ArrayList<String> results = new ArrayList<String>();
        for (Integer nextSubjectId : subjectIds) {
            Subject nextSubject = subjectManager.getSubjectById(nextSubjectId.intValue());
            if (nextSubject == null) continue;
            results.add(nextSubject.getName());
        }
        return results;
    }

    private List<String> getSubjectEmails(List<Integer> subjectIds) {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ArrayList<String> results = new ArrayList<String>();
        for (Integer nextSubjectId : subjectIds) {
            String nextEmail;
            Subject nextSubject = subjectManager.getSubjectById(nextSubjectId.intValue());
            if (nextSubject == null || (nextEmail = nextSubject.getEmailAddress()) == null) continue;
            results.add(nextEmail);
        }
        return results;
    }

    private List<Integer> getSubjectIdsFromConfiguration() {
        PropertySimple subjectIdProperty = this.alertParameters.getSimple("subjectId");
        if (subjectIdProperty == null) {
            return null;
        }
        String subjectIdString = subjectIdProperty.getStringValue();
        if (subjectIdString == null || subjectIdString.trim().equals("")) {
            return null;
        }
        return AlertSender.unfence((String)subjectIdString, Integer.class);
    }
}

