/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

public class FileSystemComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(FileSystemComponent.class);
    private ResourceContext<PlatformComponent> resourceContext;

    public void start(ResourceContext<PlatformComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        FileSystemInfo fileSystemInfo = this.getFileSystemInfo();
        if (fileSystemInfo != null && fileSystemInfo.getFileSystem() != null) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        FileSystemInfo fileSystemInfo = this.getFileSystemInfo();
        for (MeasurementScheduleRequest request : requests) {
            try {
                switch (request.getDataType()) {
                    case TRAIT: {
                        Object object = ObjectUtil.lookupDeepAttributeProperty((Object)fileSystemInfo, (String)request.getName());
                        report.addData(new MeasurementDataTrait(request, String.valueOf(object)));
                        break;
                    }
                    case MEASUREMENT: {
                        Double value = ObjectUtil.lookupDeepNumericAttributeProperty((Object)fileSystemInfo, (String)request.getName());
                        report.addData(new MeasurementDataNumeric(request, value));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported metric type: " + request.getDataType());
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to collect metric [" + request.getName() + "] on filesystem resource [" + this.resourceContext.getResourceKey() + "]."), (Throwable)e);
            }
        }
    }

    private FileSystemInfo getFileSystemInfo() {
        SystemInfo systemInfo = this.resourceContext.getSystemInformation();
        return systemInfo.getFileSystem(this.resourceContext.getResourceKey());
    }
}

