/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;

public class YumProxy {
    private String yum = "/usr/bin/yum";
    private final Log log = LogFactory.getLog(YumProxy.class);
    private ResourceContext resourceContext;

    public void init(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
        ProcessExecution processExecution = new ProcessExecution("/usr/bin/which");
        processExecution.setArguments(new String[]{"yum"});
        processExecution.setCaptureOutput(true);
        ProcessExecutionResults executionResults = resourceContext.getSystemInformation().executeProcess(processExecution);
        String capturedOutput = executionResults.getCapturedOutput();
        this.yum = capturedOutput == null || "".equals(capturedOutput) ? null : capturedOutput.trim();
        this.log.info((Object)("Using (yum) found at: " + this.yum));
    }

    public String version() throws Exception {
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("--version");
        return this.execute(args);
    }

    public void install(Collection<String> packages) throws Exception {
        this.log.debug((Object)("install packages\n" + packages));
        ArrayList<String> args = new ArrayList<String>();
        args.add("install");
        args.add("-y");
        args.addAll(packages);
        this.execute(args);
    }

    public void remove(Collection<String> packages) throws Exception {
        this.log.debug((Object)("remove packages\n" + packages));
        ArrayList<String> args = new ArrayList<String>();
        args.add("remove");
        args.add("-y");
        args.addAll(packages);
        this.execute(args);
    }

    public void cleanMetadata() throws Exception {
        this.log.debug((Object)"clean metadata");
        ArrayList<String> args = new ArrayList<String>();
        args.add("clean");
        args.add("metadata");
        this.execute(args);
    }

    public void update() throws Exception {
        this.log.debug((Object)"update packages");
        ArrayList<String> args = new ArrayList<String>();
        args.add("update");
        args.add("-y");
        this.execute(args);
    }

    private String execute(List<String> args) throws Exception {
        if (this.yum == null) {
            String msg = "yum executable: not-found";
            this.log.error((Object)msg);
            throw new Exception(msg);
        }
        ProcessExecution installPackages = new ProcessExecution(this.yum);
        installPackages.setArguments(args);
        installPackages.setCaptureOutput(true);
        installPackages.setWaitForCompletion(1800000L);
        ProcessExecutionResults result = this.resourceContext.getSystemInformation().executeProcess(installPackages);
        String output = result.getCapturedOutput();
        Integer exitCode = result.getExitCode();
        this.log.info((Object)("yum result: " + exitCode + "\n" + output));
        if (output == null && (exitCode == null || result.getExitCode() != 0)) {
            throw new Exception(output);
        }
        return output;
    }
}

