/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.win;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.EventLog;
import org.hyperic.sigar.win32.EventLogRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventPoller;

public class Win32EventLogDelegate
implements EventPoller {
    private static final String EVENT_TYPE = "Event Log";
    private final Log log = LogFactory.getLog(Win32EventLogDelegate.class);
    private String[] logNames = EventLog.getLogNames();
    private EventLog[] eventLogs;
    private int[] lastCollectedEventId;
    private EventSeverity minimumSeverity;
    private Pattern regularExpression;
    private int eventsChecked;
    private int eventsFired;

    public Win32EventLogDelegate(Configuration config) {
        String minimumSeverityString = config.getSimpleValue("minimumSeverity", "Error");
        if ("Information".equals(minimumSeverityString)) {
            this.minimumSeverity = EventSeverity.INFO;
        } else if ("Warning".equals(minimumSeverityString)) {
            this.minimumSeverity = EventSeverity.WARN;
        } else if ("Error".equals(minimumSeverityString)) {
            this.minimumSeverity = EventSeverity.ERROR;
        }
        String regexString = config.getSimpleValue("regularExpression", null);
        try {
            if (regexString != null) {
                this.regularExpression = Pattern.compile(regexString);
            }
        }
        catch (PatternSyntaxException pse) {
            this.log.warn((Object)"Event tracking regular expression not valid, no filtering will take place", (Throwable)pse);
        }
        this.eventLogs = new EventLog[this.logNames.length];
        this.lastCollectedEventId = new int[this.logNames.length];
    }

    public void open() {
        for (int i = 0; i < this.eventLogs.length; ++i) {
            try {
                if (this.eventLogs[i] != null) continue;
                this.eventLogs[i] = new EventLog();
                this.eventLogs[i].open(this.logNames[i]);
                this.lastCollectedEventId[i] = this.eventLogs[i].getNewestRecord();
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to open Windows Event Log [" + this.logNames[i] + "]; will not collect its events"), (Throwable)e);
                this.eventLogs[i] = null;
            }
        }
    }

    public void close() {
        for (int i = 0; i < this.eventLogs.length; ++i) {
            try {
                if (this.eventLogs[i] == null) continue;
                this.eventLogs[i].close();
                this.eventLogs[i] = null;
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to close Windows Event Log [" + this.logNames[i] + "]"), (Throwable)e);
            }
        }
    }

    @Nullable
    public Set<Event> checkForNewEvents() {
        HashSet<Event> convertedEvents = null;
        for (int i = 0; i < this.eventLogs.length; ++i) {
            try {
                int newest;
                if (this.eventLogs[i] == null || (newest = this.eventLogs[i].getNewestRecord()) <= this.lastCollectedEventId[i]) continue;
                for (int eventId = this.lastCollectedEventId[i] + 1; eventId <= newest; ++eventId) {
                    ++this.eventsChecked;
                    EventLogRecord event = this.eventLogs[i].read(eventId);
                    Event convertedEvent = this.handleEvent(event);
                    if (null == convertedEvent) continue;
                    if (null == convertedEvents) {
                        convertedEvents = new HashSet<Event>();
                    }
                    convertedEvents.add(convertedEvent);
                }
                this.lastCollectedEventId[i] = newest;
                continue;
            }
            catch (Exception e) {
                this.log.info((Object)("An error occurred while reading the Windows Event Log [" + this.logNames[i] + "]"), (Throwable)e);
            }
        }
        return convertedEvents;
    }

    public Event handleEvent(EventLogRecord event) {
        if (this.regularExpression != null && !this.regularExpression.matcher(event.getMessage()).find()) {
            return null;
        }
        if (!this.convertSeverity(event.getEventType()).isAtLeastAsSevereAs(this.minimumSeverity)) {
            return null;
        }
        Event convertedEvent = new Event(EVENT_TYPE, event.getLogName(), event.getTimeGenerated() * 1000L, this.convertSeverity(event.getEventType()), event.getMessage());
        ++this.eventsFired;
        return convertedEvent;
    }

    private EventSeverity convertSeverity(short type) {
        switch (type) {
            case 4: {
                return EventSeverity.INFO;
            }
            case 2: {
                return EventSeverity.WARN;
            }
            case 1: {
                return EventSeverity.ERROR;
            }
        }
        return EventSeverity.DEBUG;
    }

    @NotNull
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Nullable
    public Set<Event> poll() {
        return this.checkForNewEvents();
    }

    public int getEventsChecked() {
        return this.eventsChecked;
    }

    public int getEventsFired() {
        return this.eventsFired;
    }
}

