/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.StringUtil;

public class PingNetServiceComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(PingNetServiceComponent.class);
    private static final int PING_TIMEOUT = 5000;
    private InetAddress address;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.address = PingNetServiceComponent.createComponentConfiguration(resourceContext.getPluginConfiguration());
    }

    static InetAddress createComponentConfiguration(Configuration pluginConfig) throws InvalidPluginConfigurationException {
        String addressString = pluginConfig.getSimpleValue("address", "");
        if (StringUtil.isBlank((String)addressString)) {
            throw new InvalidPluginConfigurationException("Address is not defined");
        }
        try {
            return InetAddress.getByName(addressString);
        }
        catch (UnknownHostException uhe) {
            throw new InvalidPluginConfigurationException((Throwable)uhe);
        }
    }

    public void stop() {
        this.address = null;
    }

    public AvailabilityType getAvailability() {
        try {
            return this.address.isReachable(5000) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(this.address.getHostAddress() + " not reachable"), (Throwable)e);
            }
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("ipAddress")) {
                report.addData(new MeasurementDataTrait(request, this.address.getHostAddress()));
                continue;
            }
            if (request.getName().equals("hostName")) {
                report.addData(new MeasurementDataTrait(request, this.address.getCanonicalHostName()));
                continue;
            }
            if (!request.getName().equals("responseTime")) continue;
            long start = System.currentTimeMillis();
            this.address.isReachable(5000);
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - start)));
        }
    }

    public static final class ConfigKeys {
        public static final String ADDRESS = "address";

        private ConfigKeys() {
        }
    }
}

