/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;

public class CustomTableRowDiscoveryComponent
implements ResourceDiscoveryComponent<DatabaseComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<DatabaseComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> hashSet;
        Statement statement = null;
        ResultSet resultSet = null;
        Configuration config = resourceDiscoveryContext.getDefaultPluginConfiguration();
        String table = config.getSimpleValue("table", null);
        String keyColumn = config.getSimpleValue("keyColumn", null);
        try {
            Connection conn = ((DatabaseComponent)resourceDiscoveryContext.getParentResourceComponent()).getConnection();
            String resourceName = config.getSimpleValue("name", null);
            String resourceDescription = config.getSimpleValue("description", "");
            if (resourceName == null) {
                throw new InvalidPluginConfigurationException("The 'name' connection property has to be specified.");
            }
            statement = conn.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
            while (resultSet.next()) {
                config = resourceDiscoveryContext.getDefaultPluginConfiguration();
                String key = resultSet.getString(keyColumn);
                config.put((Property)new PropertySimple("key", (Object)key));
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), key, CustomTableRowDiscoveryComponent.formatMessage(resourceName, key), null, CustomTableRowDiscoveryComponent.formatMessage(resourceDescription, key), config, null);
                found.add(details);
            }
            hashSet = found;
        }
        catch (SQLException e) {
            try {
                this.log.debug((Object)("table " + table + " column " + keyColumn), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(resultSet);
                JDBCUtil.safeClose(statement);
                throw throwable;
            }
            JDBCUtil.safeClose(resultSet);
            JDBCUtil.safeClose((Statement)statement);
            return Collections.emptySet();
        }
        JDBCUtil.safeClose((ResultSet)resultSet);
        JDBCUtil.safeClose((Statement)statement);
        return hashSet;
    }

    public static String formatMessage(String message, String key) {
        if (key == null) {
            return message;
        }
        key = Matcher.quoteReplacement(key);
        message = message.replaceAll("\\{key\\}", key);
        return message;
    }
}

