/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class SecurityDomainJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_SECURITY = "security";
    public static final String SECURITY_DOMAIN = "security-domain";
    public static final String CACHE_TYPE = "cache-type";
    public static final String AUTHENTICATION = "authentication";
    public static final String LOGIN_MODULES = "login-modules";
    public static final String CLASSIC = "classic";
    public static final String CODE = "code";
    public static final String FLAG = "flag";
    public static final String MODULE_OPTIONS = "module-options";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DS_JNDI_NAME = "dsJndiName";
    public static final String PRINCIPALS_QUERY = "principalsQuery";
    public static final String ROLES_QUERY = "rolesQuery";
    public static final String HASH_ALGORITHM = "hashAlgorithm";
    public static final String HASH_ENCODING = "hashEncoding";

    public SecurityDomainJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isSecurityDomain(String securityDomainName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY);
        return null != this.findNodeInList(addr, haystack = SECURITY_DOMAIN, securityDomainName);
    }

    public void createNewSecureIdentitySecurityDomain(String securityDomainName, String username, String password) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", addr.clone().add(AUTHENTICATION, CLASSIC));
        ModelNode loginModulesNode = addAuthNode.get(LOGIN_MODULES);
        ModelNode loginModule = new ModelNode();
        loginModule.get(CODE).set("SecureIdentity");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        moduleOptions.add(USERNAME, username);
        moduleOptions.add(PASSWORD, password);
        loginModulesNode.add(loginModule);
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public void updateSecureIdentitySecurityDomainCredentials(String securityDomainName, String username, String password) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName, AUTHENTICATION, CLASSIC);
        ModelNode loginModule = new ModelNode();
        loginModule.get(CODE).set("SecureIdentity");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        moduleOptions.add(USERNAME, username);
        moduleOptions.add(PASSWORD, password);
        ModelNode loginModuleList = new ModelNode();
        loginModuleList.setEmptyList();
        loginModuleList.add(loginModule);
        ModelNode op = SecurityDomainJBossASClient.createRequest("write-attribute", addr);
        op.get("name").set(LOGIN_MODULES);
        op.get("value").set(loginModuleList);
        ModelNode results = this.execute(op);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to update credentials for security domain [" + securityDomainName + "]");
        }
    }

    public ModelNode getSecureIdentitySecurityDomainModuleOptions(String securityDomainName) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName, AUTHENTICATION, CLASSIC);
        ModelNode authResource = this.readResource(addr);
        List loginModules = authResource.get(LOGIN_MODULES).asList();
        for (ModelNode loginModule : loginModules) {
            if (!"SecureIdentity".equals(loginModule.get(CODE).asString())) continue;
            ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
            return moduleOptions;
        }
        return null;
    }

    public void createNewDatabaseServerSecurityDomain(String securityDomainName, String dsJndiName, String principalsQuery, String rolesQuery, String hashAlgorithm, String hashEncoding) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", addr.clone().add(AUTHENTICATION, CLASSIC));
        ModelNode loginModulesNode = addAuthNode.get(LOGIN_MODULES);
        ModelNode loginModule = new ModelNode();
        loginModule.get(CODE).set("Database");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        moduleOptions.add(DS_JNDI_NAME, dsJndiName);
        moduleOptions.add(PRINCIPALS_QUERY, principalsQuery);
        moduleOptions.add(ROLES_QUERY, rolesQuery);
        moduleOptions.add(HASH_ALGORITHM, null == hashAlgorithm ? "MD5" : hashAlgorithm);
        moduleOptions.add(HASH_ENCODING, null == hashEncoding ? "base64" : hashEncoding);
        loginModulesNode.add(loginModule);
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public void removeSecurityDomain(String securityDomainName) throws Exception {
        if (!this.isSecurityDomain(securityDomainName)) {
            return;
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode removeSecurityDomainNode = SecurityDomainJBossASClient.createRequest("remove", addr);
        ModelNode results = this.execute(removeSecurityDomainNode);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to remove security domain [" + securityDomainName + "]");
        }
    }

    public void createNewSecurityDomain(String securityDomainName, LoginModuleRequest ... loginModules) throws Exception {
        if (this.isSecurityDomain(securityDomainName)) {
            this.removeSecurityDomain(securityDomainName);
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", addr.clone().add(AUTHENTICATION, CLASSIC));
        ModelNode loginModulesNode = addAuthNode.get(LOGIN_MODULES);
        ModelNode[] loginModuleNodes = new ModelNode[loginModules.length];
        int len = loginModules.length;
        for (int i = 0; i < len; ++i) {
            ModelNode loginModule = new ModelNode();
            loginModule.get(CODE).set(loginModules[i].getLoginModuleFQCN());
            loginModule.get(FLAG).set(loginModules[i].getFlagString());
            ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
            moduleOptions.setEmptyList();
            Map<String, String> moduleOptionProperties = loginModules[i].getModuleOptionProperties();
            if (null != moduleOptionProperties) {
                for (String key : moduleOptionProperties.keySet()) {
                    String value = moduleOptionProperties.get(key);
                    if (null == value) continue;
                    moduleOptions.add(key, value);
                }
            }
            loginModulesNode.add(loginModule);
        }
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public static class LoginModuleRequest {
        private AppConfigurationEntry entry;

        public LoginModuleRequest(String loginModuleFQCN, AppConfigurationEntry.LoginModuleControlFlag flag, Map<String, String> moduleOptionProperties) {
            this.entry = new AppConfigurationEntry(loginModuleFQCN, flag, moduleOptionProperties);
        }

        public String getLoginModuleFQCN() {
            return this.entry.getLoginModuleName();
        }

        public AppConfigurationEntry.LoginModuleControlFlag getFlag() {
            return this.entry.getControlFlag();
        }

        public String getFlagString() {
            if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(this.entry.getControlFlag())) {
                return "sufficient";
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(this.entry.getControlFlag())) {
                return "requisite";
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(this.entry.getControlFlag())) {
                return "required";
            }
            return "optional";
        }

        public Map<String, String> getModuleOptionProperties() {
            return this.entry.getOptions();
        }

        public String toString() {
            return "LoginModuleRequest [loginModuleFQCN=" + this.getLoginModuleFQCN() + ", flag=" + this.getFlag() + ", moduleOptionProperties=" + this.getModuleOptionProperties() + "]";
        }
    }
}

