/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.mysql.MySqlConnectionInfo;

class MySqlConnectionManager {
    private HashMap<MySqlConnectionInfo, Connection> connections;
    private static MySqlConnectionManager singleton;
    private Log logger = LogFactory.getLog(MySqlConnectionManager.class);

    private MySqlConnectionManager() {
        this.connections = new HashMap();
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unable to find com.mysql.jdbc.Driver");
        }
    }

    static MySqlConnectionManager getConnectionManager() {
        if (singleton == null) {
            singleton = new MySqlConnectionManager();
        }
        return singleton;
    }

    public void shutdown() {
        Driver driver = null;
        for (Connection conn : this.connections.values()) {
            try {
                if (driver == null) {
                    String driverName = conn.getMetaData().getDriverName();
                    driver = DriverManager.getDriver(driverName);
                }
                conn.close();
            }
            catch (SQLException e) {
                this.logger.info((Object)"Problem closing connection on Shutdown ignoring...");
            }
        }
        if (driver != null) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                this.logger.warn((Object)"Unable to deregister MySQL Driver on  shutdown");
            }
        }
    }

    void closeConnection(MySqlConnectionInfo info) {
        Connection conn = this.connections.get(info);
        if (conn != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing Connection to " + info.buildURL()));
                }
                conn.close();
            }
            catch (SQLException e) {
                this.logger.warn((Object)("Problem closing connection to " + info.buildURL() + " on close"));
            }
        }
        this.connections.remove(info);
    }

    Connection getConnection(MySqlConnectionInfo info) throws SQLException {
        Connection conn = this.connections.get(info);
        String url = info.buildURL();
        if (conn == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Attemping connection to " + url));
            }
            conn = DriverManager.getConnection(url, info.getUser(), info.getPassword());
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Successfully connected to " + url));
            }
            this.connections.put(info, conn);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Reusing existing connection to " + url));
        }
        if (!conn.isValid(0)) {
            conn.close();
            conn = DriverManager.getConnection(url, info.getUser(), info.getPassword());
            this.connections.put(info, conn);
            this.logger.info((Object)("Refreshed a connection to " + url));
        }
        return conn;
    }
}

