/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.mysql.MySqlConnectionInfo;
import org.rhq.plugins.mysql.MySqlConnectionManager;

public class MySqlDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final Log log = LogFactory.getLog(MySqlDiscoveryComponent.class);
    public static final String HOST_CONFIGURATION_PROPERTY = "host";
    public static final String PORT_CONFIGURATION_PROPERTY = "port";
    public static final String DB_CONFIGURATION_PROPERTY = "db";
    public static final String PRINCIPAL_CONFIGURATION_PROPERTY = "principal";
    public static final String CREDENTIALS_CONFIGURATION_PROPERTY = "credentials";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resource Discovery Started");
        }
        LinkedHashSet<DiscoveredResourceDetails> servers = new LinkedHashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult result : autoDiscoveryResults) {
            log.info((Object)("Discovered a mysql process: " + result));
            ProcessInfo procInfo = result.getProcessInfo();
            servers.add(MySqlDiscoveryComponent.createResourceDetails(context, context.getDefaultPluginConfiguration(), procInfo));
        }
        return servers;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        ProcessInfo processInfo = null;
        DiscoveredResourceDetails resourceDetails = MySqlDiscoveryComponent.createResourceDetails(resourceDiscoveryContext, pluginConfiguration, processInfo);
        return resourceDetails;
    }

    protected static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, ProcessInfo processInfo) throws InvalidPluginConfigurationException {
        MySqlConnectionInfo ci = MySqlDiscoveryComponent.buildConnectionInfo(pluginConfiguration);
        String version = "";
        try {
            Connection conn = MySqlConnectionManager.getConnectionManager().getConnection(ci);
            version = conn.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            // empty catch block
        }
        String key = "MySql:" + ci.getDb() + ":" + ci.getHost() + ":" + ci.getPort() + "-" + ci.getUser();
        String name = "MySql [" + ci.getDb() + "]";
        DiscoveredResourceDetails result = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, "MySql Server", pluginConfiguration, processInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Discovered Database Server for MySQL Database " + ci.buildURL()));
        }
        return result;
    }

    static MySqlConnectionInfo buildConnectionInfo(Configuration configuration) {
        String host = configuration.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue();
        String port = configuration.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue();
        String user = configuration.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String pass = configuration.getSimple(CREDENTIALS_CONFIGURATION_PROPERTY).getStringValue();
        String db = configuration.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
        return new MySqlConnectionInfo(host, port, db, user, pass);
    }
}

