/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.hudson.HudsonJSONUtility;
import org.rhq.plugins.hudson.HudsonServerComponent;

public class HudsonProjectComponent
implements ResourceComponent<HudsonServerComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(HudsonProjectComponent.class);
    private ResourceContext<HudsonServerComponent> resourceContext;

    public void start(ResourceContext<HudsonServerComponent> hudsonServerComponentResourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = hudsonServerComponentResourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            JSONArray healthArray = ((HudsonServerComponent)this.resourceContext.getParentResourceComponent()).getProjectHealth(this.resourceContext.getResourceKey());
            if (healthArray != null) {
                JSONObject healthReport = healthArray.getJSONObject(0);
                return healthReport.getInt("score") == 100 ? AvailabilityType.UP : AvailabilityType.DOWN;
            }
            return AvailabilityType.DOWN;
        }
        catch (JSONException e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        try {
            String path = this.resourceContext.getResourceKey();
            JSONObject job = HudsonJSONUtility.getData(path, 1);
            JSONObject lastSuccessfulBuild = job.getJSONObject("lastSuccessfulBuild");
            JSONObject lastBuild = job.getJSONObject("lastBuild");
            JSONArray healthArray = job.getJSONArray("healthReport");
            JSONObject healthReport = healthArray.getJSONObject(0);
            for (MeasurementScheduleRequest request : metrics) {
                try {
                    if (request.getName().equals("lastSuccessfulBuildNumber")) {
                        report.addData(new MeasurementDataTrait(request, lastSuccessfulBuild.getString("number")));
                        continue;
                    }
                    if (request.getName().equals("lastSuccessfulBuildTime")) {
                        report.addData(new MeasurementDataTrait(request, new Date(lastSuccessfulBuild.getLong("timestamp")).toString()));
                        continue;
                    }
                    if (request.getName().equals("lastBuildNumber")) {
                        report.addData(new MeasurementDataTrait(request, lastBuild.getString("number")));
                        continue;
                    }
                    if (request.getName().equals("lastBuildTime")) {
                        report.addData(new MeasurementDataTrait(request, new Date(lastBuild.getLong("timestamp")).toString()));
                        continue;
                    }
                    if (request.getName().equals("lastBuildResult")) {
                        report.addData(new MeasurementDataTrait(request, lastBuild.getString("result")));
                        continue;
                    }
                    if (request.getName().equals("healthScore")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(healthReport.getDouble("score") / 100.0)));
                        continue;
                    }
                    if (!request.getName().equals("lastBuildDuration")) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(lastBuild.getDouble("duration"))));
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }
}

