/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;

public class OracleAsmDiskGroupDiscoveryComponent
implements ResourceDiscoveryComponent<DatabaseComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<DatabaseComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> hashSet;
        Statement statement = null;
        ResultSet resultSet = null;
        String table = "V$ASM_DISKGROUP";
        String keyColumn = "GROUP_NUMBER";
        String nameColumn = "NAME";
        String description = "Oracle ASM Disk Groups";
        try {
            Connection conn = ((DatabaseComponent)resourceDiscoveryContext.getParentResourceComponent()).getConnection();
            statement = conn.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            Configuration config = null;
            HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
            while (resultSet.next()) {
                config = resourceDiscoveryContext.getDefaultPluginConfiguration();
                String key = resultSet.getString(keyColumn);
                String name = resultSet.getString(nameColumn);
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), key, name, null, description, config, null);
                found.add(details);
            }
            hashSet = found;
        }
        catch (SQLException e) {
            try {
                this.log.debug((Object)("table " + table + " column " + keyColumn), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(resultSet);
                JDBCUtil.safeClose(statement);
                throw throwable;
            }
            JDBCUtil.safeClose((ResultSet)resultSet);
            JDBCUtil.safeClose((Statement)statement);
            return Collections.emptySet();
        }
        JDBCUtil.safeClose((ResultSet)resultSet);
        JDBCUtil.safeClose((Statement)statement);
        return hashSet;
    }
}

