/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.AbstractDatabaseComponent;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

public class OracleUserComponent
extends AbstractDatabaseComponent
implements MeasurementFacet {
    private static final String SQL_USER = "SELECT COUNT(*) FROM DBA_USERS WHERE username = ?";
    private static final String SESSIONS = "SELECT SUM(DECODE(Status, 'ACTIVE', 1, 0)) active, COUNT(1) connections FROM V$SESSION where username = ?";
    private static Log log = LogFactory.getLog(OracleUserComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection().prepareStatement(SQL_USER);
            statement.setString(1, this.resourceContext.getResourceKey());
            resultSet = statement.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) == 1) {
                AvailabilityType availabilityType = AvailabilityType.UP;
                JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
                return availabilityType;
            }
            JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        }
        catch (SQLException e) {
            log.debug((Object)"unable to query", (Throwable)e);
        }
        finally {
            JDBCUtil.safeClose((Statement)statement, resultSet);
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = DatabaseQueryUtility.getNumericQueryValues((DatabaseComponent)this, (String)SESSIONS, (Object[])new Object[]{this.resourceContext.getResourceKey()});
        for (MeasurementScheduleRequest request : metrics) {
            Double d = (Double)values.get(request.getName().toUpperCase(Locale.US));
            if (d == null) continue;
            report.addData(new MeasurementDataNumeric(request, d));
        }
    }
}

