/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.client.RhqManager;
import org.rhq.bindings.util.InterfaceSimplifier;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.LocalClientProxy;
import org.rhq.enterprise.server.util.LookupUtil;

public class LocalClient
implements RhqFacade {
    private static final Log LOG = LogFactory.getLog(LocalClient.class);
    private Subject subject;
    private Map<RhqManager, Object> managers;

    public LocalClient(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Subject login(String user, String password) throws Exception {
        return this.subject;
    }

    public void logout() {
    }

    public boolean isLoggedIn() {
        return true;
    }

    public Map<RhqManager, Object> getScriptingAPI() {
        if (this.managers == null) {
            this.managers = new HashMap<RhqManager, Object>();
            for (final RhqManager manager : RhqManager.values()) {
                if (!manager.enabled()) continue;
                try {
                    Object proxy = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return LocalClient.this.getScriptingProxy(LocalClient.this.getLocalSLSB(manager), manager);
                        }
                    });
                    this.managers.put(manager, proxy);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Failed to load manager " + manager + " due to missing class."), e);
                }
            }
        }
        return this.managers;
    }

    public <T> T getProxy(final Class<T> remoteApiIface) {
        final RhqManager manager = RhqManager.forInterface(remoteApiIface);
        if (manager == null) {
            throw new IllegalArgumentException("Unknown remote interface " + remoteApiIface);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object localSLSB = LocalClient.this.getLocalSLSB(manager);
                Object proxy = Proxy.newProxyInstance(remoteApiIface.getClassLoader(), new Class[]{remoteApiIface}, (InvocationHandler)((Object)new LocalClientProxy(localSLSB, LocalClient.this, manager)));
                return remoteApiIface.cast(proxy);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getScriptingProxy(Object slsb, RhqManager manager) {
        Class iface = manager.remote();
        Class simplified = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(iface.getClassLoader());
            simplified = InterfaceSimplifier.simplify((Class)iface);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        Object proxy = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{simplified}, (InvocationHandler)((Object)new LocalClientProxy(slsb, this, manager)));
        return proxy;
    }

    private Object getLocalSLSB(RhqManager manager) {
        return LookupUtil.getEjb((String)manager.beanName(), (String)manager.localInterfaceClassName());
    }
}

