/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.EventValueExpression;
import org.ajax4jsf.component.JavaScriptParameter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.util.HtmlUtil;

public abstract class UIComponentControl
extends UIComponentBase
implements AjaxSupport {
    public static final String COMPONENT_TYPE = "org.richfaces.ComponentControl";
    public static final String COMPONENT_FAMILY = "org.richfaces.ComponentControl";
    private static final Log log = LogFactory.getLog(UIComponentControl.class);
    private boolean disableDefault = false;
    private boolean disableDefaultSet = false;

    public String getEventString() {
        String targetId = HtmlUtil.idsToIdSelector((String)this.getFor());
        targetId = HtmlUtil.expandIdSelector((String)targetId, (UIComponent)this, (FacesContext)FacesContext.getCurrentInstance());
        JSFunction invocation = new JSFunction("Richfaces.componentControl.performOperation", new Object[0]);
        invocation.addParameter((Object)new JSReference("event"));
        this.addOptions(invocation, this.getEvent(), targetId, this.getOperation());
        return invocation.toScript();
    }

    private static boolean isContextMenuEvent(String event) {
        return "contextmenu".equalsIgnoreCase(event) || "oncontextmenu".equalsIgnoreCase(event);
    }

    public void addOptions(JSFunction function, String event, String targetId, String operation) {
        function.addParameter((Object)event);
        function.addParameter((Object)targetId);
        function.addParameter((Object)operation);
        boolean parametersEncoded = false;
        String params = this.getEncodedParametersMap();
        if (params.length() != 0) {
            parametersEncoded = true;
            JSFunctionDefinition parametersFunction = new JSFunctionDefinition(new Object[0]).addToBody((Object)"return{").addToBody((Object)params).addToBody((Object)"}");
            function.addParameter((Object)parametersFunction);
        }
        boolean disableDefault = this.isDisableDefault();
        boolean isOnContextMenu = UIComponentControl.isContextMenuEvent(event);
        if (isOnContextMenu ^ disableDefault) {
            if (!parametersEncoded) {
                function.addParameter((Object)JSLiteral.EMPTY_HASH);
            }
            function.addParameter((Object)disableDefault);
        }
    }

    public String getEncodedParametersMap() {
        StringBuilder result = new StringBuilder();
        boolean shouldClose = false;
        String params = this.getParams();
        if (params != null && params.trim().length() != 0) {
            result.append(params);
            shouldClose = true;
        }
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            if (null == name) {
                FacesContext context = FacesContext.getCurrentInstance();
                throw new IllegalArgumentException(Messages.getMessage((String)"UNNAMED_PARAMETER_ERROR", (Object)this.getClientId(context)));
            }
            boolean escape = true;
            if (child instanceof JavaScriptParameter) {
                JavaScriptParameter actionParam = (JavaScriptParameter)child;
                boolean bl = escape = !actionParam.isNoEscape();
            }
            if (shouldClose) {
                result.append(", ");
            }
            ScriptUtils.addEncodedString((StringBuilder)result, (Object)name);
            result.append(": ");
            result.append(ScriptUtils.toScript((Object)(escape ? value : new JSReference(value.toString()))));
            shouldClose = true;
        }
        return result.toString();
    }

    public abstract String getEvent();

    public abstract void setEvent(String var1);

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract String getParams();

    public abstract void setParams(String var1);

    public abstract String getOperation();

    public abstract void setOperation(String var1);

    public abstract String getAttachTo();

    public abstract void setAttachTo(String var1);

    public boolean isDisableDefault() {
        if (this.disableDefaultSet) {
            return this.disableDefault;
        }
        ValueExpression ve = this.getValueExpression("disableDefault");
        if (ve != null) {
            Boolean value = null;
            try {
                value = (Boolean)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (null != value) {
                return value;
            }
        }
        return UIComponentControl.isContextMenuEvent(this.getEvent());
    }

    public void setDisableDefault(boolean disableDefault) {
        this.disableDefaultSet = true;
        this.disableDefault = disableDefault;
    }

    protected String replaceClientIds(FacesContext context, UIComponent component, String selector) {
        return HtmlUtil.expandIdSelector((String)selector, (UIComponent)component, (FacesContext)context);
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (parent != null && parent.getFamily() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"CALLED_SET_PARENT", (Object)parent.getClass().getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"DETECT_NEW_COMPONENT"));
            }
            this.setParentProperties(parent);
        }
    }

    public void setParentProperties(UIComponent parent) {
        String event = this.getEvent();
        if (event == null || event.length() == 0) {
            return;
        }
        String attachTo = this.getAttachTo();
        if (attachTo == null || attachTo.length() == 0) {
            parent.setValueExpression(event, (ValueExpression)new EventValueExpression((AjaxSupport)this));
        } else {
            ValueExpression vb = parent.getValueExpression(event);
            if (vb instanceof EventValueExpression) {
                parent.setValueExpression(event, null);
            }
        }
    }

    public abstract void setName(String var1);

    public abstract String getName();

    public abstract void setAttachTiming(String var1);

    public abstract String getAttachTiming();

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.disableDefault ? Boolean.TRUE : Boolean.FALSE, this.disableDefaultSet ? Boolean.TRUE : Boolean.FALSE};
        return state;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        Object[] state = (Object[])stateObject;
        super.restoreState(context, state[0]);
        this.disableDefault = (Boolean)state[1];
        this.disableDefaultSet = (Boolean)state[2];
    }
}

