/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertMicroblog;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class MicroblogServerPluginComponent
extends CustomAlertSenderBackingBean
implements ServerPluginComponent,
ControlFacet {
    private Twitter twitter;
    private RequestToken requestToken;
    private final Log log = LogFactory.getLog(MicroblogServerPluginComponent.class);
    private ServerPluginContext context;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        String consumerKey = this.context.getPluginConfiguration().getSimpleValue("consumerKey", "iXCqk1vR2vKksDHkulZQ");
        String consumerSecret = this.context.getPluginConfiguration().getSimpleValue("consumerSecret", "d2iwloVgHSghDfEmPWzjxAKdtp18TEvcBJsyaqBjst0");
        if (consumerKey == null || consumerSecret == null) {
            throw new TwitterException("consumerKey or consumerSecret missing. Please configure the Microblog plugin before.");
        }
        this.twitter = new TwitterFactory().getInstance();
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
        this.log.debug((Object)("Twitter using consumerKey [" + consumerKey + "] and consumerSecret: [" + consumerSecret + "]"));
    }

    private String getAuthorizationURL() throws TwitterException {
        RequestToken requestToken = this.twitter.getOAuthRequestToken();
        this.log.info((Object)("Open the following URL and grant access to your account: " + requestToken.getAuthorizationURL()));
        return requestToken.getAuthorizationURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String storeAccessToken(AccessToken token) throws IOException {
        String filePath = null;
        if (this.context.getDataDirectory().exists() || this.context.getDataDirectory().mkdir()) {
            filePath = this.context.getDataDirectory().getAbsolutePath() + "/OAuthAccessToken_" + token.getUserId() + ".ser";
            this.context.getPluginConfiguration().put((Property)new PropertySimple("accessTokenFilePath", (Object)filePath));
            this.persistConfiguration(this.context.getPluginConfiguration());
            FileOutputStream file = new FileOutputStream(filePath);
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            try {
                output.writeObject(token);
            }
            finally {
                output.close();
                this.log.info((Object)("AccessToken saved at " + filePath));
            }
        } else {
            throw new IOException("AccessToken not stored!");
        }
        return filePath;
    }

    public ControlResults invoke(String controlOperation, Configuration operationConfig) {
        ControlResults ctrlResult = new ControlResults();
        try {
            if (controlOperation.equals("GET_OAUTH_REQUEST_URL")) {
                ctrlResult.getComplexResults().put((Property)new PropertySimple("authorizationURL", (Object)this.getAuthorizationURL()));
            } else if (controlOperation.equals("GET_ACCESS_TOKEN")) {
                AccessToken accessToken = null;
                String pin = operationConfig.getSimpleValue("pin", null);
                this.log.debug((Object)("using PIN [" + pin + "]"));
                accessToken = pin != null && pin.length() > 0 ? this.twitter.getOAuthAccessToken(this.requestToken, pin) : this.twitter.getOAuthAccessToken();
                this.log.debug((Object)("ScreenName: " + this.twitter.getScreenName()));
                this.log.debug((Object)("TwitterId: [" + this.twitter.verifyCredentials().getId() + "]"));
                this.log.debug((Object)("token: [" + accessToken.getToken() + "]"));
                this.log.debug((Object)("tokenSecret: [" + accessToken.getTokenSecret() + "]"));
                String filePath = this.storeAccessToken(accessToken);
                ctrlResult.getComplexResults().put((Property)new PropertySimple("accessToken", (Object)("token[" + accessToken.getToken() + "] tokenSecret[" + accessToken.getTokenSecret() + "")));
                ctrlResult.getComplexResults().put((Property)new PropertySimple("twitterScreenName", (Object)this.twitter.getScreenName()));
                ctrlResult.getComplexResults().put((Property)new PropertySimple("accessTokenFilePath", (Object)filePath));
            } else {
                ctrlResult.setError("Invalid Operation! Please Select a valid one.");
            }
        }
        catch (TwitterException te) {
            this.log.error((Object)"Twitter Error: ", (Throwable)te);
            ctrlResult.setError((Throwable)te);
        }
        catch (IOException ioe) {
            this.log.error((Object)"Error storing AccessToken: ", (Throwable)ioe);
            ctrlResult.setError((Throwable)ioe);
        }
        return ctrlResult;
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }
}

