/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.Set;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

public class ModClusterDiscoveryComponent
extends MBeanResourceDiscoveryComponent {
    private static final String MOD_CLUSTER_CONFIG_FILE = "modclusterConfigFile";
    private static final String JBOSS_AS4_CONFIGURATION_FILE_RELATIVE_PATH = "/deploy/jboss-web.deployer/server.xml";
    private static final String JBOSS_AS5_CONFIGURATION_FILE_RELATIVE_PATH = "/deploy/mod_cluster.sar/META-INF/mod_cluster-jboss-beans.xml";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        Set tempSet = super.discoverResources(context);
        for (DiscoveredResourceDetails detail : tempSet) {
            String configurationFile = this.findConfigurationFile(context.getParentResourceComponent());
            detail.getPluginConfiguration().put((Property)new PropertySimple(MOD_CLUSTER_CONFIG_FILE, (Object)configurationFile));
        }
        return tempSet;
    }

    private String findConfigurationFile(ResourceComponent parentResourceComponent) {
        try {
            if (parentResourceComponent instanceof ApplicationServerComponent) {
                ApplicationServerComponent parentComponent = (ApplicationServerComponent)parentResourceComponent;
                return parentComponent.getResourceContext().getPluginConfiguration().getSimple("serverHomeDir").getStringValue() + JBOSS_AS5_CONFIGURATION_FILE_RELATIVE_PATH;
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            if (parentResourceComponent instanceof JBossASServerComponent) {
                JBossASServerComponent parentComponent = (JBossASServerComponent)parentResourceComponent;
                return parentComponent.getPluginConfiguration().getSimple("configurationPath").getStringValue() + JBOSS_AS4_CONFIGURATION_FILE_RELATIVE_PATH;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }
}

