/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;

public class TomcatConnectorDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatServerComponent<?>> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatServerComponent<?>> context) {
        ObjectNameQueryUtility queryUtility;
        Set resourceDetails = super.discoverResources(context, false);
        EmsConnection connection = ((TomcatServerComponent)context.getParentResourceComponent()).getEmsConnection();
        List grpBeans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility("Catalina:type=GlobalRequestProcessor,name=%name%")).getTranslatedQuery());
        if (grpBeans.size() != resourceDetails.size()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Connector discovery pending jboss.web:type=GlobalRequestProcessor,name=* deployment...");
            }
            return Collections.emptySet();
        }
        HashMap<String, ConfigInfo> configMap = new HashMap<String, ConfigInfo>(grpBeans.size());
        for (EmsBean bean : grpBeans) {
            ConfigInfo configInfo = new ConfigInfo(bean);
            if (null != configInfo.getPort()) {
                configMap.put(configInfo.port, configInfo);
                continue;
            }
            this.log.warn((Object)("Failed to parse ObjectName for GlobalRequestProcessor: " + configInfo.getName() + ": " + configInfo.getException()));
        }
        for (DiscoveredResourceDetails resource : resourceDetails) {
            String executorName;
            EmsBean connectorBean;
            EmsAttribute executorNameAttrib;
            Object executorNameValue;
            String connector;
            String address;
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String port = pluginConfiguration.getSimple("port").getStringValue();
            ConfigInfo configInfo = (ConfigInfo)configMap.get(port);
            String handler = null != configInfo ? configInfo.getHandler() : "?";
            pluginConfiguration.put((Property)new PropertySimple("handler", (Object)handler));
            String string = address = null != configInfo ? configInfo.getAddress() : null;
            if (null != address && !"".equals(address.trim())) {
                pluginConfiguration.put((Property)new PropertySimple("address", (Object)address));
            }
            String string2 = connector = null != configInfo ? configInfo.getConnector() : null;
            if (null != connector && !"".equals(connector.trim())) {
                pluginConfiguration.put((Property)new PropertySimple("connector", (Object)connector));
            }
            String name = null != configInfo ? configInfo.getName() : null;
            resource.setResourceName(resource.getResourceName().replace("{name}", name));
            pluginConfiguration.put((Property)new PropertySimple("name", (Object)name));
            String connectorON = pluginConfiguration.getSimpleValue("objectName", null);
            if (connectorON != null && (executorNameValue = (executorNameAttrib = (connectorBean = connection.getBean(connectorON)).getAttribute("executorName")).getValue()) != null && !(executorName = executorNameValue.toString()).isEmpty() && !executorName.equalsIgnoreCase("Internal")) {
                pluginConfiguration.put((Property)new PropertySimple("sharedExecutorName", (Object)executorName));
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Found a connector: " + handler + (null != configInfo ? "-" + configInfo.getAddress() : "") + "-" + port));
        }
        return resourceDetails;
    }

    private static class ConfigInfo {
        private String name = "";
        private String address = "";
        private String handler = "";
        private String connector = "";
        private String port = "";
        private Exception exception;

        public ConfigInfo(EmsBean bean) {
            EmsBeanName eName = bean.getBeanName();
            this.name = eName.getKeyProperty("name");
            try {
                if (this.name.startsWith("\"")) {
                    int firstDash = this.name.indexOf(45);
                    int lastDash = this.name.lastIndexOf(45);
                    this.handler = this.name.substring(1, firstDash);
                    this.port = this.name.substring(lastDash + 1, this.name.length() - 1);
                    Integer.valueOf(this.port);
                    String middle = this.name.substring(firstDash + 1, lastDash);
                    if (middle.indexOf(45) != -1) {
                        this.connector = middle.substring(0, middle.indexOf(45));
                        this.address = middle.substring(middle.indexOf(45) + 1);
                    } else {
                        this.connector = middle;
                    }
                } else {
                    int firstDash = this.name.indexOf(45);
                    int lastDash = this.name.lastIndexOf(45);
                    this.handler = this.name.substring(0, firstDash);
                    this.port = this.name.substring(lastDash + 1);
                    Integer.valueOf(this.port);
                    if (firstDash != lastDash) {
                        String rawAddress = this.name.substring(firstDash + 1, lastDash);
                        int delim = rawAddress.indexOf("%2F");
                        this.address = -1 == delim ? rawAddress : rawAddress.substring(0, delim);
                    }
                }
            }
            catch (Exception e) {
                this.name = null;
                this.port = null;
                this.address = null;
                this.connector = null;
                this.handler = null;
                this.exception = e;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getConnector() {
            return this.connector;
        }

        public String getHandler() {
            return this.handler;
        }

        public String getPort() {
            return this.port;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

