/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.jboss.on.plugins.tomcat.helper.CreateResourceHelper;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class TomcatUserDatabaseComponent
extends MBeanResourceComponent<TomcatServerComponent<?>>
implements CreateChildResourceFacet {
    public CreateResourceReport createResource(CreateResourceReport report) {
        String resourceTypeName = report.getResourceType().getName();
        String name = null;
        String objectName = null;
        String operation = null;
        try {
            if ("Tomcat Group".equals(resourceTypeName)) {
                name = report.getResourceConfiguration().getSimple("groupname").getStringValue();
                report.getResourceConfiguration().remove("roles");
                objectName = String.format("Users:type=Group,groupname=\"%s\",database=UserDatabase", name);
                operation = "createGroup";
            } else if ("Tomcat Role".equals(resourceTypeName)) {
                name = report.getResourceConfiguration().getSimple("rolename").getStringValue();
                objectName = String.format("Users:type=Role,rolename=%s,database=UserDatabase", name);
                operation = "createRole";
            } else if ("Tomcat User".equals(resourceTypeName)) {
                name = report.getResourceConfiguration().getSimple("username").getStringValue();
                report.getResourceConfiguration().remove("roles");
                report.getResourceConfiguration().remove("groups");
                objectName = String.format("Users:type=User,username=\"%s\",database=UserDatabase", name);
                operation = "createUser";
            } else {
                throw new UnsupportedOperationException("Unsupported Resource type: " + resourceTypeName);
            }
            report.setResourceKey(CreateResourceHelper.getCanonicalName(objectName));
            CreateResourceHelper.setResourceName(report, name);
            this.invokeOperation(operation, report.getResourceConfiguration());
            this.save();
            report.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (Exception e) {
            CreateResourceHelper.setErrorOnReport(report, e);
        }
        return report;
    }

    void save() throws Exception {
        this.invokeOperation("save", new Configuration());
    }
}

