/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataParser;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServerDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ServiceDescriptor;
import org.rhq.core.domain.resource.ClassLoaderType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;

public class PluginMetadataManager {
    public static final ResourceType TEST_PLATFORM_TYPE = new ResourceType("Anonymous", "test", ResourceCategory.PLATFORM, null);
    private Log log = LogFactory.getLog(PluginMetadataManager.class);
    private Map<ResourceCategory, LinkedHashSet<ResourceType>> typesByCategory = new HashMap<ResourceCategory, LinkedHashSet<ResourceType>>();
    private Set<ResourceType> types = new HashSet<ResourceType>();
    private Object typesLock = new Object();
    private Map<String, PluginMetadataParser> parsersByPlugin = new HashMap<String, PluginMetadataParser>();
    private Map<String, PluginDescriptor> descriptorsByPlugin = new HashMap<String, PluginDescriptor>();
    private List<String> disabledResourceTypesAsStrings = null;
    private Map<ResourceType, String> disabledResourceTypes = null;
    private String disabledDiscoveryComponentClassName = null;
    private String disabledResourceComponentClassName = null;

    public void storePluginDescriptor(PluginDescriptor descriptor) {
        this.descriptorsByPlugin.put(descriptor.getName(), descriptor);
    }

    public PluginDescriptor getPluginDescriptor(String pluginName) {
        PluginMetadataParser parser;
        PluginDescriptor descriptor = this.descriptorsByPlugin.get(pluginName);
        if (descriptor == null && (parser = this.parsersByPlugin.get(pluginName)) != null) {
            descriptor = parser.getDescriptor();
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType(ResourceType type) {
        ResourceCategory category = type.getCategory();
        Object object = this.typesLock;
        synchronized (object) {
            if (!this.typesByCategory.containsKey(category)) {
                this.typesByCategory.put(category, new LinkedHashSet());
            }
            this.typesByCategory.get(category).add(type);
            this.types.add(type);
        }
    }

    public ResourceType addTestPlatformType() {
        this.addType(TEST_PLATFORM_TYPE);
        return TEST_PLATFORM_TYPE;
    }

    public String getPluginLifecycleListenerClass(String pluginName) {
        PluginMetadataParser parser = this.parsersByPlugin.get(pluginName);
        return parser != null ? parser.getPluginLifecycleListenerClass() : null;
    }

    public String getDiscoveryClass(ResourceType resourceType) {
        if (this.isDisabledResourceType(resourceType)) {
            return this.disabledDiscoveryComponentClassName;
        }
        PluginMetadataParser parser = this.parsersByPlugin.get(resourceType.getPlugin());
        return parser != null ? parser.getDiscoveryComponentClass(resourceType) : null;
    }

    public String getComponentClass(ResourceType resourceType) {
        if (this.isDisabledResourceType(resourceType)) {
            return this.disabledResourceComponentClassName;
        }
        PluginMetadataParser parser = this.parsersByPlugin.get(resourceType.getPlugin());
        return parser != null ? parser.getComponentClass(resourceType) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<ResourceType> loadPlugin(PluginDescriptor pluginDescriptor) {
        try {
            Object object;
            PluginMetadataParser parser = new PluginMetadataParser(pluginDescriptor, this.parsersByPlugin);
            PluginMetadataParser oldParser = this.parsersByPlugin.get(pluginDescriptor.getName());
            if (oldParser != null) {
                object = this.typesLock;
                synchronized (object) {
                    for (ResourceType oldType : oldParser.getAllTypes()) {
                        this.typesByCategory.get(oldType.getCategory()).remove(oldType);
                        this.types.remove(oldType);
                    }
                }
            }
            this.parsersByPlugin.put(pluginDescriptor.getName(), parser);
            this.descriptorsByPlugin.remove(pluginDescriptor.getName());
            object = this.typesLock;
            synchronized (object) {
                for (ResourceType resourceType : parser.getAllTypes()) {
                    if (this.types.contains(resourceType)) {
                        throw new InvalidPluginDescriptorException("Type [" + resourceType + "] is duplicate for this plugin. This is illegal.");
                    }
                    this.addType(resourceType);
                }
            }
            this.findDisabledResourceTypesInAllPlugins();
            Set<ResourceType> rootTypes = parser.getRootResourceTypes();
            return rootTypes;
        }
        catch (InvalidPluginDescriptorException e) {
            this.log.error((Object)("Error transforming plugin descriptor [" + pluginDescriptor.getName() + "]."), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceType getType(String resourceTypeName, String pluginName) {
        ResourceType searchType = new ResourceType(resourceTypeName, pluginName, null, null);
        Object object = this.typesLock;
        synchronized (object) {
            for (ResourceType type : this.types) {
                if (!type.equals((Object)searchType)) continue;
                return type;
            }
        }
        return null;
    }

    @Nullable
    public ResourceType getType(ResourceType resourceType) {
        if (TEST_PLATFORM_TYPE.equals((Object)resourceType)) {
            return TEST_PLATFORM_TYPE;
        }
        return this.getType(resourceType.getName(), resourceType.getPlugin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceType> getTypesForCategory(ResourceCategory category) {
        Object object = this.typesLock;
        synchronized (object) {
            LinkedHashSet<ResourceType> types = this.typesByCategory.get(category);
            return types != null ? types : new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceType> getAllTypes() {
        Object object = this.typesLock;
        synchronized (object) {
            return new HashSet<ResourceType>(this.types);
        }
    }

    public Set<ResourceType> getRootTypes() {
        HashSet<ResourceType> rootTypes = new HashSet<ResourceType>();
        for (ResourceType type : this.getAllTypes()) {
            if (type.getParentResourceTypes().size() != 0) continue;
            rootTypes.add(type);
        }
        return rootTypes;
    }

    public Set<String> getPluginNames() {
        return this.parsersByPlugin.keySet();
    }

    public PluginDependencyGraph buildDependencyGraph() {
        PluginDependencyGraph dependencyGraph = new PluginDependencyGraph();
        for (PluginDescriptor descriptor : this.getAllKnownPluginDescriptors().values()) {
            AgentPluginDescriptorUtil.addPluginToDependencyGraph(dependencyGraph, descriptor);
        }
        return dependencyGraph;
    }

    public Map<String, PluginDescriptor> getEmbeddedExtensions(String parentPlugin) {
        Map<String, PluginDescriptor> allDescriptors = this.getAllKnownPluginDescriptors();
        HashMap<String, PluginDescriptor> map = new HashMap<String, PluginDescriptor>();
        for (PluginDescriptor descriptor : allDescriptors.values()) {
            String pluginName = descriptor.getName();
            if (parentPlugin.equals(pluginName)) continue;
            if (this.doServersExtendParent(descriptor.getServers(), parentPlugin)) {
                map.put(pluginName, descriptor);
                continue;
            }
            if (map.containsKey(pluginName) || !this.doServicesExtendParent(descriptor.getServices(), parentPlugin)) continue;
            map.put(pluginName, descriptor);
        }
        return map;
    }

    private Map<String, PluginDescriptor> getAllKnownPluginDescriptors() {
        HashMap<String, PluginDescriptor> allDescriptors = new HashMap<String, PluginDescriptor>();
        allDescriptors.putAll(this.descriptorsByPlugin);
        for (PluginMetadataParser parser : this.parsersByPlugin.values()) {
            allDescriptors.put(parser.getDescriptor().getName(), parser.getDescriptor());
        }
        return allDescriptors;
    }

    private boolean doServersExtendParent(List<ServerDescriptor> servers, String parentPlugin) {
        if (servers != null && !servers.isEmpty()) {
            for (ServerDescriptor serverDescriptor : servers) {
                if (this.doServersExtendParent(serverDescriptor.getServers(), parentPlugin)) {
                    return true;
                }
                if (this.doServicesExtendParent(serverDescriptor.getServices(), parentPlugin)) {
                    return true;
                }
                if (!parentPlugin.equals(serverDescriptor.getSourcePlugin())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doServicesExtendParent(List<ServiceDescriptor> services, String parentPlugin) {
        if (services != null && !services.isEmpty()) {
            for (ServiceDescriptor serviceDescriptor : services) {
                if (this.doServicesExtendParent(serviceDescriptor.getServices(), parentPlugin)) {
                    return true;
                }
                if (!parentPlugin.equals(serviceDescriptor.getSourcePlugin())) continue;
                return true;
            }
        }
        return false;
    }

    public void setDisabledResourceTypes(List<String> disabledTypesAsStrings, String disabledDiscoveryComponentClassName, String disabledResourceComponentClassName) {
        if (disabledTypesAsStrings != null && !disabledTypesAsStrings.isEmpty()) {
            this.disabledDiscoveryComponentClassName = disabledDiscoveryComponentClassName;
            this.disabledResourceComponentClassName = disabledResourceComponentClassName;
            this.disabledResourceTypesAsStrings = new ArrayList<String>(disabledTypesAsStrings);
            this.log.info((Object)("Will disable the following resource types: " + this.disabledResourceTypesAsStrings));
        } else {
            this.disabledDiscoveryComponentClassName = null;
            this.disabledResourceComponentClassName = null;
            this.disabledResourceTypesAsStrings = null;
        }
    }

    private boolean isDisabledResourceType(ResourceType resourceType) {
        if (this.disabledResourceTypes == null) {
            return false;
        }
        return this.disabledResourceTypes.containsKey(resourceType);
    }

    private void findDisabledResourceTypes(String parentHierarchy, ResourceType type, HashMap<ResourceType, String> disabledTypes) {
        Set childTypes;
        String typeHierarchy = parentHierarchy + '>' + type.getName();
        if (this.disabledResourceTypesAsStrings.contains(typeHierarchy)) {
            this.log.debug((Object)("Disabling resource type: " + type));
            disabledTypes.put(type, typeHierarchy);
        }
        if ((childTypes = type.getChildResourceTypes()) != null) {
            for (ResourceType childType : childTypes) {
                this.findDisabledResourceTypes(typeHierarchy, childType, disabledTypes);
            }
        }
    }

    private void findDisabledResourceTypesInAllPlugins() {
        if (this.disabledResourceTypesAsStrings != null) {
            int totalToBeDisabled = this.disabledResourceTypesAsStrings.size();
            HashMap<ResourceType, String> disabledTypes = new HashMap<ResourceType, String>();
            for (Map.Entry<String, PluginMetadataParser> entry : this.parsersByPlugin.entrySet()) {
                PluginMetadataParser parser = entry.getValue();
                PluginDescriptor pluginDescriptor = parser.getDescriptor();
                Set<ResourceType> rootTypes = parser.getRootResourceTypes();
                String hierarchyStart = pluginDescriptor.getName();
                for (ResourceType rootType : rootTypes) {
                    this.findDisabledResourceTypes(hierarchyStart, rootType, disabledTypes);
                }
                if (disabledTypes.size() != totalToBeDisabled) continue;
                break;
            }
            this.disabledResourceTypes = !disabledTypes.isEmpty() ? disabledTypes : null;
        }
    }

    static {
        TEST_PLATFORM_TYPE.setClassLoaderType(ClassLoaderType.SHARED);
    }
}

