/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.server.discovery;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.clientapi.server.discovery.StaleTypeException;
import org.rhq.core.communications.command.annotation.Asynchronous;
import org.rhq.core.communications.command.annotation.LimitedConcurrency;
import org.rhq.core.communications.command.annotation.Timeout;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;

public interface DiscoveryServerService {
    public static final String CONCURRENCY_LIMIT_INVENTORY_REPORT = "rhq.server.concurrency-limit.inventory-report";
    public static final String CONCURRENCY_LIMIT_AVAILABILITY_REPORT = "rhq.server.concurrency-limit.availability-report";
    public static final String CONCURRENCY_LIMIT_INVENTORY_SYNC = "rhq.server.concurrency-limit.inventory-sync";

    @LimitedConcurrency(value="rhq.server.concurrency-limit.inventory-report")
    @Timeout(value=0L)
    public ResourceSyncInfo mergeInventoryReport(InventoryReport var1) throws InvalidInventoryReportException, StaleTypeException;

    @LimitedConcurrency(value="rhq.server.concurrency-limit.availability-report")
    public boolean mergeAvailabilityReport(AvailabilityReport var1);

    @LimitedConcurrency(value="rhq.server.concurrency-limit.inventory-sync")
    public Set<Resource> getResources(Set<Integer> var1, boolean var2);

    @LimitedConcurrency(value="rhq.server.concurrency-limit.inventory-sync")
    public List<Resource> getResourcesAsList(Integer ... var1);

    @Asynchronous(guaranteedDelivery=true)
    public void setResourceEnablement(int var1, boolean var2);

    @Asynchronous(guaranteedDelivery=false)
    public void setResourceError(ResourceError var1);

    @Asynchronous(guaranteedDelivery=true)
    public void clearResourceConfigError(int var1);

    @LimitedConcurrency(value="rhq.server.concurrency-limit.inventory-sync")
    public Map<Integer, InventoryStatus> getInventoryStatus(int var1, boolean var2);

    public MergeResourceResponse addResource(Resource var1, int var2);

    public boolean updateResourceVersion(int var1, String var2);

    public Set<ResourceUpgradeResponse> upgradeResources(Set<ResourceUpgradeRequest> var1);

    @LimitedConcurrency(value="rhq.server.concurrency-limit.inventory-sync")
    public Set<ResourceMeasurementScheduleRequest> postProcessNewlyCommittedResources(Set<Integer> var1);
}

