/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.text.ParseException;
import org.rhq.core.clientapi.util.units.BinaryFormatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;

public class BytesFormatter
extends BinaryFormatter {
    @Override
    protected String getTagName() {
        return "B";
    }

    @Override
    protected UnitNumber parseTag(double number, String tag, int tagIdx, ParseSpecifics specifics) throws ParseException {
        ScaleConstants scale;
        if (tag.equalsIgnoreCase("b") || tag.equalsIgnoreCase("bytes")) {
            scale = ScaleConstants.SCALE_NONE;
        } else if (tag.equalsIgnoreCase("k") || tag.equalsIgnoreCase("kb")) {
            scale = ScaleConstants.SCALE_KILO;
        } else if (tag.equalsIgnoreCase("m") || tag.equalsIgnoreCase("mb")) {
            scale = ScaleConstants.SCALE_MEGA;
        } else if (tag.equalsIgnoreCase("g") || tag.equalsIgnoreCase("gb")) {
            scale = ScaleConstants.SCALE_GIGA;
        } else if (tag.equalsIgnoreCase("t") || tag.equalsIgnoreCase("tb")) {
            scale = ScaleConstants.SCALE_TERA;
        } else if (tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("pb")) {
            scale = ScaleConstants.SCALE_PETA;
        } else {
            throw new ParseException("Unknown byte type '" + tag + "'", tagIdx);
        }
        return new UnitNumber(number, UnitsConstants.UNIT_BYTES, scale);
    }
}

