/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.javascript;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptableObject;
import org.rhq.scripting.CodeCompletion;
import org.rhq.scripting.MetadataProvider;

public class JavascriptCompletor
implements CodeCompletion {
    private static final Log LOG = LogFactory.getLog(JavascriptCompletor.class);
    private ScriptContext context;
    private MetadataProvider metadataProvider;
    private String lastComplete;
    private int recomplete;
    private static final Set<String> IGNORED_METHODS = new HashSet<String>();

    public int complete(PrintWriter output, String s, int i, List list) {
        try {
            this.recomplete = this.lastComplete != null && this.lastComplete.equals(s) ? ++this.recomplete : 1;
            this.lastComplete = s;
            String base = s;
            int rootLength = 0;
            if (s.indexOf(61) > 0) {
                base = s.substring(s.indexOf("=") + 1).trim();
                rootLength = s.length() - base.length();
            }
            String[] call = base.split("\\.");
            if (base.endsWith(".")) {
                String[] argPadded = new String[call.length + 1];
                System.arraycopy(call, 0, argPadded, 0, call.length);
                argPadded[call.length] = "";
                call = argPadded;
            }
            if (call.length == 1) {
                Map<String, Object> matches = this.getContextMatches(call[0]);
                if (matches.size() == 1 && matches.containsKey(call[0]) && !s.endsWith(".")) {
                    list.add(".");
                    return rootLength + call[0].length() + 1;
                }
                list.addAll(matches.keySet());
            } else {
                Object rootObject = this.context.getAttribute(call[0]);
                if (rootObject != null) {
                    String theRest = base.substring(call[0].length() + 1, base.length());
                    int matchIndex = this.contextComplete(output, rootObject, theRest, i, list);
                    Collections.sort(list);
                    return rootLength + call[0].length() + 1 + matchIndex;
                }
            }
            Collections.sort(list);
            return list.size() == 0 ? -1 : rootLength;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    private int contextComplete(PrintWriter output, Object baseObject, String s, int i, List<String> list) {
        String temp = s.split("\\(", 2)[0];
        if (temp.contains(".")) {
            Map<String, List<Object>> matches;
            String[] call = temp.split("\\.", 2);
            String next = call[0];
            if (next.contains("(")) {
                next = next.substring(0, next.indexOf("("));
            }
            if (!(matches = this.getContextMatches(output, baseObject, next)).isEmpty()) {
                List<Object> nextList = matches.get(next);
                if (nextList == null || nextList.isEmpty()) {
                    return -1;
                }
                Class<?> rootObject = nextList.get(0);
                if (rootObject instanceof PropertyDescriptor && !(baseObject instanceof Class)) {
                    try {
                        Method readMethod = ((PropertyDescriptor)((Object)rootObject)).getReadMethod();
                        if (readMethod == null) {
                            return -1;
                        }
                        rootObject = JavascriptCompletor.invoke(baseObject, readMethod);
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Exception while reading a java bean property.", (Throwable)e);
                        }
                        return -1;
                    }
                } else if (rootObject instanceof Method) {
                    rootObject = ((Method)((Object)rootObject)).getReturnType();
                }
                return call[0].length() + 1 + this.contextComplete(output, rootObject, call[1], i, list);
            }
            return -1;
        }
        String[] call = s.split("\\(", 2);
        Map<String, List<Object>> matches = this.getContextMatches(output, baseObject, call[0]);
        if (call.length == 2 && matches.containsKey(call[0])) {
            int x = 0;
            for (String key : matches.keySet()) {
                List<Object> matchList = matches.get(key);
                if (this.recomplete == 2) {
                    ArrayList<Method> methods = new ArrayList<Method>();
                    for (Object match : matchList) {
                        if (!(match instanceof Method)) continue;
                        methods.add((Method)match);
                    }
                    this.displaySignatures(output, baseObject, methods.toArray(new Method[methods.size()]));
                    return -1;
                }
                for (Object match : matchList) {
                    int result;
                    if (!key.equals(call[0]) || !(match instanceof Method) || (result = this.completeParameters(baseObject, call[1], i, list, (Method)match)) <= 0) continue;
                    x = result;
                }
            }
            return call[0].length() + 1 + x;
        }
        if (matches.size() == 1 && matches.containsKey(call[0])) {
            Object obj = matches.get(call[0]).get(0);
            if (JavascriptCompletor.isMethod(obj)) {
                boolean close = obj instanceof Method && ((Method)obj).getParameterTypes().length == 0;
                list.add("(" + (close ? ")" : ""));
            }
            return call[0].length() + 1;
        }
        if (this.recomplete == 2) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (List<Object> matchList : matches.values()) {
                for (Object val : matchList) {
                    if (!(val instanceof Method)) continue;
                    methods.add((Method)val);
                }
            }
            this.displaySignatures(output, baseObject, methods.toArray(new Method[methods.size()]));
        } else if (matches.size() == 1 && matches.values().iterator().next().get(0) instanceof Method) {
            list.add(matches.keySet().iterator().next() + "(" + (((Method)matches.values().iterator().next().get(0)).getParameterTypes().length == 0 ? ")" : ""));
        } else {
            list.addAll(matches.keySet());
        }
        return 0;
    }

    private void displaySignatures(PrintWriter output, Object object, Method ... methods) {
        try {
            String[][] signatures = new String[methods.length][];
            int i = 0;
            for (Method m : methods) {
                signatures[i++] = this.getSignature(object, m).split(" ", 2);
            }
            int maxReturnLength = 0;
            for (String[] sig : signatures) {
                if (sig[0].length() <= maxReturnLength) continue;
                maxReturnLength = sig[0].length();
            }
            output.println();
            output.println();
            for (String[] sig : signatures) {
                for (i = 0; i < maxReturnLength - sig[0].length(); ++i) {
                    output.print(" ");
                }
                output.print(sig[0]);
                output.print(" ");
                output.print(sig[1]);
                output.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace(output);
        }
    }

    public int completeParameters(Object baseObject, String params, int i, List<String> list, Method method) {
        String[] paramList = params.split(",");
        Class<?>[] c = method.getParameterTypes();
        String lastParam = paramList[paramList.length - 1];
        int paramIndex = paramList.length - 1;
        if (params.trim().endsWith(",")) {
            lastParam = "";
            ++paramIndex;
        }
        int baseLength = 0;
        for (int x = 0; x < paramIndex; ++x) {
            Object paramFound = this.context.getAttribute(paramList[x]);
            if (paramFound != null && !c[x].isAssignableFrom(paramFound.getClass())) {
                return -1;
            }
            baseLength += paramList[x].length() + 1;
        }
        if (paramIndex >= c.length) {
            if (params.endsWith(")")) {
                return -1;
            }
            list.add(params + ")");
            return (params + ")").length();
        }
        if (baseObject instanceof Map && method.getName().equals("get") && method.getParameterTypes().length == 1) {
            for (Object key : ((Map)baseObject).keySet()) {
                String lookupChoice = "'" + String.valueOf(key) + "'";
                if (!lookupChoice.startsWith(lastParam)) continue;
                list.add(lookupChoice);
            }
            if (list.size() == 1) {
                list.set(0, list.get(0) + ")");
            }
        } else {
            Class<?> parameterType = c[paramIndex];
            Map<String, Object> matches = this.getContextMatches(lastParam, parameterType);
            if (matches.size() == 1 && matches.containsKey(lastParam)) {
                list.add(paramIndex == c.length - 1 ? ")" : ",");
                return baseLength + lastParam.length();
            }
            list.addAll(matches.keySet());
        }
        return baseLength;
    }

    private Map<String, Object> getContextMatches(String start) {
        HashMap<String, Object> found = new HashMap<String, Object>();
        if (this.context != null) {
            for (Integer scope : this.context.getScopes()) {
                Bindings bindings = this.context.getBindings(scope);
                for (String var : bindings.keySet()) {
                    if (!var.startsWith(start)) continue;
                    found.put(var, bindings.get(var));
                }
            }
        }
        return found;
    }

    private Map<String, Object> getContextMatches(String start, Class<?> typeFilter) {
        HashMap<String, Object> found = new HashMap<String, Object>();
        if (this.context != null) {
            for (int scope : this.context.getScopes()) {
                Bindings bindings = this.context.getBindings(scope);
                for (String var : bindings.keySet()) {
                    if (!var.startsWith(start) || (bindings.get(var) == null || !typeFilter.isAssignableFrom(bindings.get(var).getClass())) && this.recomplete != 3) continue;
                    found.put(var, bindings.get(var));
                }
            }
            if (typeFilter.isEnum()) {
                for (Object ec : typeFilter.getEnumConstants()) {
                    Enum e = (Enum)ec;
                    String code = typeFilter.getSimpleName() + "." + e.name();
                    if (!code.startsWith(start)) continue;
                    found.put(typeFilter.getSimpleName() + "." + e.name(), e);
                }
            }
        }
        return found;
    }

    private Map<String, List<Object>> getContextMatches(PrintWriter output, Object baseObject, String start) {
        HashMap<String, List<Object>> found = new HashMap<String, List<Object>>();
        Class<?> baseObjectClass = null;
        baseObjectClass = baseObject instanceof Class ? (Class<?>)baseObject : baseObject.getClass();
        try {
            if (baseObjectClass.equals(Void.TYPE)) {
                return found;
            }
            if (ScriptableObject.class.isAssignableFrom(baseObjectClass)) {
                return this.findJavascriptContextMatches((ScriptableObject)baseObject, start);
            }
            return this.findJavaBeanContextMatches(baseObject, baseObjectClass, start);
        }
        catch (Exception e) {
            LOG.info((Object)"Failure during code completion", (Throwable)e);
            e.printStackTrace(output);
            return found;
        }
    }

    private Map<String, List<Object>> findJavascriptContextMatches(ScriptableObject object, String start) {
        if (object instanceof NativeArray) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> ret = new HashMap<String, List<Object>>();
        for (Object o : object.getIds()) {
            String key = o.toString();
            if (start != null && !start.isEmpty() && !key.startsWith(start)) continue;
            Object target = object.get(key);
            ret.put(key, new ArrayList<Object>(Arrays.asList(target)));
        }
        return ret;
    }

    private Map<String, List<Object>> findJavaBeanContextMatches(Object baseObject, Class<?> baseObjectClass, String start) throws IntrospectionException {
        MethodDescriptor[] methods;
        PropertyDescriptor[] descriptors;
        HashMap<String, List<Object>> found = new HashMap<String, List<Object>>();
        BeanInfo info = null;
        info = baseObjectClass.isInterface() || baseObjectClass.equals(Object.class) ? Introspector.getBeanInfo(baseObjectClass) : Introspector.getBeanInfo(baseObjectClass, Object.class);
        HashSet<Method> methodsCovered = new HashSet<Method>();
        for (PropertyDescriptor desc : descriptors = info.getPropertyDescriptors()) {
            if (!desc.getName().startsWith(start) || IGNORED_METHODS.contains(desc.getName())) continue;
            ArrayList<PropertyDescriptor> list = (ArrayList<PropertyDescriptor>)found.get(desc.getName());
            if (list == null) {
                list = new ArrayList<PropertyDescriptor>();
                found.put(desc.getName(), list);
            }
            list.add(desc);
            methodsCovered.add(desc.getReadMethod());
            methodsCovered.add(desc.getWriteMethod());
        }
        for (MethodDescriptor desc : methods = info.getMethodDescriptors()) {
            if (!desc.getName().startsWith(start) || methodsCovered.contains(desc.getMethod()) || desc.getName().startsWith("_d") || IGNORED_METHODS.contains(desc.getName())) continue;
            Method m = desc.getMethod();
            ArrayList<Method> list = (ArrayList<Method>)found.get(desc.getName());
            if (list == null) {
                list = new ArrayList<Method>();
                found.put(desc.getName(), list);
            }
            list.add(m);
        }
        return found;
    }

    private String getSignature(Object object, Method m) {
        StringBuilder buf = new StringBuilder();
        Type[] params = m.getGenericParameterTypes();
        int i = 0;
        m = this.metadataProvider.getUnproxiedMethod(m);
        buf.append(this.metadataProvider.getTypeName(m.getGenericReturnType(), false));
        buf.append(" ");
        buf.append(m.getName());
        buf.append("(");
        boolean first = true;
        for (Type type : params) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            String name = this.metadataProvider.getTypeName(type, false);
            String paramName = this.metadataProvider.getParameterName(m, i);
            if (paramName != null) {
                name = name + " " + paramName;
            }
            buf.append(name);
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public void setScriptContext(ScriptContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invoke(Object o, Method m) throws IllegalAccessException, InvocationTargetException {
        boolean access = m.isAccessible();
        m.setAccessible(true);
        try {
            Object object = m.invoke(o, new Object[0]);
            return object;
        }
        finally {
            m.setAccessible(access);
        }
    }

    private static boolean isMethod(Object object) {
        return object != null && object instanceof Method || object instanceof Function;
    }

    static {
        IGNORED_METHODS.add("newProxyInstance");
        IGNORED_METHODS.add("hashCode");
        IGNORED_METHODS.add("equals");
        IGNORED_METHODS.add("getInvocationHandler");
        IGNORED_METHODS.add("setHandler");
        IGNORED_METHODS.add("isProxyClass");
        IGNORED_METHODS.add("newProxyInstance");
        IGNORED_METHODS.add("getProxyClass");
        IGNORED_METHODS.add("main");
        IGNORED_METHODS.add("handler");
        IGNORED_METHODS.add("init");
        IGNORED_METHODS.add("initChildren");
        IGNORED_METHODS.add("initMeasurements");
        IGNORED_METHODS.add("initOperations");
    }
}

