/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.javascript.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.rhq.scripting.javascript.engine.ExternalScriptable;
import org.rhq.scripting.javascript.engine.RhinoCompiledScript;
import org.rhq.scripting.javascript.engine.RhinoScriptEngineFactory;
import org.rhq.scripting.javascript.engine.util.ExtendedScriptException;
import org.rhq.scripting.javascript.engine.util.InterfaceImplementor;

public class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    public static final boolean DEBUG = false;
    private static final String TOPLEVEL_SCRIPT_NAME = "META-INF/toplevel.js";
    private TopLevelScope topLevel;
    private Map<?, ?> indexedProps;
    private ScriptEngineFactory factory;
    private InterfaceImplementor implementor;
    private RequireBuilder requireBuilder;
    private static final String printSource = "function print(str, newline) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }                                         \n    var out = context.getWriter();            \n    out.print(String(str));                   \n    if (newline) out.print('\\n');            \n    out.flush();                              \n}\nfunction println(str) {                       \n    print(str, true);                         \n}";

    public RhinoScriptEngine() {
        this(new UrlModuleSourceProvider(null, Arrays.asList(new File("./").toURI())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptEngine(ModuleSourceProvider moduleSourceProvider) {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            this.topLevel = new TopLevelScope(AccessController.getContext(), cx, System.getSecurityManager() != null);
            this.requireBuilder = new RequireBuilder();
            this.setModuleSourceProvider(moduleSourceProvider);
            this.requireBuilder.setSandboxed(false);
            new LazilyLoadedCtor(this.topLevel, "JSAdapter", "org.rhq.scripting.javascript.engine.JSAdapter", false);
            String[] names = new String[]{"bindings", "scope", "sync"};
            this.topLevel.defineFunctionProperties(names, RhinoScriptEngine.class, 2);
            this.processAllTopLevelScripts(cx);
        }
        finally {
            Context.exit();
        }
        this.indexedProps = new HashMap();
        this.implementor = new InterfaceImplementor(this){

            @Override
            protected Object convertResult(Method method, Object res) throws ScriptException {
                Class<?> desiredType = method.getReturnType();
                if (desiredType == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava(res, desiredType);
            }
        };
    }

    public void setModuleSourceProvider(ModuleSourceProvider provider) {
        this.requireBuilder.setModuleScriptProvider(new SoftCachingModuleScriptProvider(provider));
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            Scriptable scope = this.getRuntimeScope(ctxt);
            scope.put("context", scope, (Object)ctxt);
            String filename = null;
            if (ctxt != null && ctxt.getBindings(100) != null) {
                filename = (String)ctxt.getBindings(100).get("javax.script.filename");
            }
            if (filename == null) {
                filename = (String)this.get("javax.script.filename");
            }
            filename = filename == null ? "<Unknown source>" : filename;
            ret = cx.evaluateReader(scope, this.preProcessScriptSource(reader), filename, 1, null);
        }
        catch (JavaScriptException jse) {
            int line = jse.lineNumber();
            line = line == 0 ? -1 : line;
            Object value = jse.getValue();
            String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
            throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
        }
        catch (IOException ee) {
            throw new ScriptException(ee);
        }
        finally {
            Context.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        return this.eval((Reader)new StringReader(script), ctxt);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new RhinoScriptEngineFactory();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            if (name == null) {
                throw new NullPointerException("method name is null");
            }
            if (thiz != null && !(thiz instanceof Scriptable)) {
                thiz = Context.toObject(thiz, this.topLevel);
            }
            Scriptable engineScope = this.getRuntimeScope(this.context);
            Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
            Object obj = ScriptableObject.getProperty(localScope, name);
            if (!(obj instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + name);
            }
            Function func = (Function)obj;
            Scriptable scope = func.getParentScope();
            if (scope == null) {
                scope = engineScope;
            }
            Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
            Object object = this.unwrapReturnValue(result);
            return object;
        }
        catch (JavaScriptException jse) {
            int line = jse.lineNumber();
            line = line == 0 ? -1 : line;
            Object value = jse.getValue();
            String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
            throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        try {
            return this.implementor.getInterface(thiz, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Scriptable getRuntimeScope(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("null script context");
        }
        ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
        newScope.setPrototype(this.topLevel);
        newScope.put("context", (Scriptable)newScope, (Object)ctxt);
        Context cx = RhinoScriptEngine.enterContext();
        try {
            cx.evaluateString(newScope, printSource, "print", 1, null);
            this.requireBuilder.createRequire(cx, newScope).install(newScope);
        }
        finally {
            Context.exit();
        }
        return newScope;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            String filename = (String)this.get("javax.script.filename");
            if (filename == null) {
                filename = "<Unknown Source>";
            }
            Script scr = cx.compileReader(this.preProcessScriptSource(script), filename, 1, null);
            ret = new RhinoCompiledScript(this, scr);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    static Context enterContext() {
        return Context.enter();
    }

    void setEngineFactory(ScriptEngineFactory fac) {
        this.factory = fac;
    }

    Object[] wrapArguments(Object[] args) {
        if (args == null) {
            return Context.emptyArgs;
        }
        Object[] res = new Object[args.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Context.javaToJS(args[i], this.topLevel);
        }
        return res;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    protected Reader preProcessScriptSource(Reader reader) throws ScriptException {
        return reader;
    }

    protected void processAllTopLevelScripts(Context cx) {
        this.processTopLevelScript(TOPLEVEL_SCRIPT_NAME, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTopLevelScript(String scriptName, Context cx) {
        InputStream toplevelScript = this.getClass().getClassLoader().getResourceAsStream(scriptName);
        if (toplevelScript != null) {
            InputStreamReader reader = new InputStreamReader(toplevelScript);
            try {
                cx.evaluateReader(this.topLevel, reader, scriptName, 1, null);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    toplevelScript.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Object bindings(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ExternalScriptable) {
                ScriptContext ctx = ((ExternalScriptable)arg).getContext();
                Bindings bind = ctx.getBindings(100);
                return Context.javaToJS(bind, ScriptableObject.getTopLevelScope(thisObj));
            }
        }
        return Context.getUndefinedValue();
    }

    public static Object scope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof Bindings) {
                SimpleScriptContext ctx = new SimpleScriptContext();
                ctx.setBindings((Bindings)arg, 100);
                ExternalScriptable res = new ExternalScriptable(ctx);
                res.setPrototype(ScriptableObject.getObjectPrototype(thisObj));
                res.setParentScope(ScriptableObject.getTopLevelScope(thisObj));
                return res;
            }
        }
        return Context.getUndefinedValue();
    }

    public static Object sync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1 && args[0] instanceof Function) {
            return new Synchronizer((Function)args[0]);
        }
        throw Context.reportRuntimeError("wrong argument(s) for sync");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("No file specified");
            return;
        }
        InputStreamReader r = new InputStreamReader(new FileInputStream(args[0]));
        RhinoScriptEngine engine = new RhinoScriptEngine();
        SimpleScriptContext context = new SimpleScriptContext();
        engine.put("javax.script.filename", args[0]);
        engine.eval((Reader)r, (ScriptContext)context);
        context.getWriter().flush();
    }

    static {
        ContextFactory.initGlobal(new ContextFactory(){

            @Override
            protected Object doTopCall(final Callable callable, final Context cx, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
                AccessControlContext accCtxt = null;
                Scriptable global = ScriptableObject.getTopLevelScope(scope);
                Scriptable globalProto = global.getPrototype();
                if (globalProto instanceof TopLevelScope) {
                    accCtxt = ((TopLevelScope)globalProto).getAccessControlContext();
                }
                if (accCtxt != null) {
                    return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return this.superDoTopCall(callable, cx, scope, thisObj, args);
                        }
                    }, accCtxt);
                }
                return this.superDoTopCall(callable, cx, scope, thisObj, args);
            }

            @Override
            protected Context makeContext() {
                Context cx = super.makeContext();
                cx.setOptimizationLevel(-1);
                cx.setWrapFactory(new CustomWrapFactory());
                return cx;
            }

            private Object superDoTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return super.doTopCall(callable, cx, scope, thisObj, args);
            }
        });
    }

    private static class CustomWrapFactory
    extends WrapFactory {
        private CustomWrapFactory() {
        }

        @Override
        public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
            if (obj instanceof ConsString) {
                return obj;
            }
            return super.wrap(cx, scope, obj, staticType);
        }
    }

    private static class TopLevelScope
    extends ImporterTopLevel {
        private static final long serialVersionUID = 1L;
        private AccessControlContext acc;

        public TopLevelScope(AccessControlContext acc, Context cx, boolean sealed) {
            super(cx, sealed);
            this.acc = acc;
        }

        public AccessControlContext getAccessControlContext() {
            return this.acc;
        }
    }
}

