/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.mc4j.ems.connection.bean.parameter.EmsParameter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.JMXComponent;

public class MBeanResourceComponent<T extends JMXComponent<?>>
implements MeasurementFacet,
OperationFacet,
ConfigurationFacet,
JMXComponent<T> {
    protected static Log log = LogFactory.getLog(MBeanResourceComponent.class);
    public static final String OBJECT_NAME_PROP = "objectName";
    public static final String PROPERTY_TRANSFORM = "propertyTransform";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^\\{(?:\\{([^\\}]*)\\})?([^\\}]*)\\}$");
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("%([^%]+)%");
    protected EmsBean bean;
    protected ResourceContext<T> resourceContext;

    public void start(ResourceContext<T> context) {
        this.setResourceContext(context);
        this.setEmsBean(this.loadBean());
    }

    public void stop() {
        this.setResourceContext(null);
        this.setEmsBean(null);
    }

    public EmsBean getEmsBean() {
        EmsConnection currConn;
        EmsConnection beanConn = null != this.bean ? this.bean.getConnectionProvider().getExistingConnection() : null;
        EmsConnection emsConnection = currConn = null != this.bean ? this.getEmsConnection() : null;
        if (null == this.bean || !beanConn.equals(currConn)) {
            this.bean = this.loadBean();
            if (null == this.bean) {
                throw new IllegalStateException("EMS bean was null for Resource with type [" + this.resourceContext.getResourceType() + "] and key [" + this.resourceContext.getResourceKey() + "].");
            }
        }
        return this.bean;
    }

    protected void setEmsBean(EmsBean bean) {
        this.bean = bean;
    }

    public ResourceContext<T> getResourceContext() {
        return this.resourceContext;
    }

    protected void setResourceContext(ResourceContext<T> resourceContext) {
        this.resourceContext = resourceContext;
    }

    protected EmsBean loadBean() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String objectName = pluginConfig.getSimple(OBJECT_NAME_PROP).getStringValue();
        EmsBean loadedBean = this.loadBean(objectName);
        return loadedBean;
    }

    protected EmsBean loadBean(String objectName) {
        EmsConnection emsConnection = this.getEmsConnection();
        if (emsConnection != null) {
            EmsBean bean = emsConnection.getBean(objectName);
            if (bean == null) {
                emsConnection.queryBeans(objectName);
                bean = emsConnection.getBean(objectName);
            }
            return bean;
        }
        return null;
    }

    public AvailabilityType getAvailability() {
        try {
            if (this.isMBeanAvailable()) {
                return AvailabilityType.UP;
            }
            return AvailabilityType.DOWN;
        }
        catch (RuntimeException e) {
            if (this.bean != null) {
                this.bean = null;
                if (this.isMBeanAvailable()) {
                    return AvailabilityType.UP;
                }
                return AvailabilityType.DOWN;
            }
            throw e;
        }
    }

    private boolean isMBeanAvailable() {
        EmsBean emsBean = this.getEmsBean();
        boolean isAvailable = emsBean.isRegistered();
        if (!isAvailable) {
            String emsBeanName = emsBean.getBeanName().getCanonicalName();
            int size = emsBean.getConnectionProvider().getExistingConnection().queryBeans(emsBeanName).size();
            isAvailable = size == 1;
        }
        return isAvailable;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        this.getValues(report, requests, this.getEmsBean());
    }

    protected void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests, EmsBean bean) {
        HashSet<MeasurementScheduleRequest> defaultBeanRequests = new HashSet<MeasurementScheduleRequest>();
        HashMap<String, HashSet<MeasurementScheduleRequest>> beansMap = new HashMap<String, HashSet<MeasurementScheduleRequest>>();
        for (MeasurementScheduleRequest request : requests) {
            Matcher m = PROPERTY_PATTERN.matcher(request.getName());
            if (m.matches() && m.group(1) != null) {
                HashSet<MeasurementScheduleRequest> props = (HashSet<MeasurementScheduleRequest>)beansMap.get(m.group(1));
                if (props == null) {
                    props = new HashSet<MeasurementScheduleRequest>();
                    beansMap.put(m.group(1), props);
                }
                props.add(request);
                continue;
            }
            defaultBeanRequests.add(request);
        }
        this.getBeanProperties(report, bean, defaultBeanRequests);
        for (String beanNameTemplate : beansMap.keySet()) {
            String transformedbeanName = this.transformBeanName(beanNameTemplate);
            EmsBean otherBean = this.getEmsConnection().getBean(transformedbeanName);
            if (otherBean == null) {
                log.info((Object)("Unable to retrieve associated MBean: " + transformedbeanName));
                continue;
            }
            this.getBeanProperties(report, otherBean, (Set)beansMap.get(beanNameTemplate));
        }
    }

    protected String transformBeanName(String beanTemplate) {
        Matcher m = TEMPLATE_PATTERN.matcher(beanTemplate);
        while (m.find()) {
            String propName = m.group(1);
            String replacementValue = this.resourceContext.getPluginConfiguration().getSimpleValue(propName, null);
            beanTemplate = beanTemplate.replaceAll("%" + propName + "%", replacementValue);
            m = TEMPLATE_PATTERN.matcher(beanTemplate);
        }
        return beanTemplate;
    }

    protected void getBeanProperties(MeasurementReport report, EmsBean thisBean, Set<MeasurementScheduleRequest> requests) {
        ArrayList<String> props = new ArrayList<String>();
        for (MeasurementScheduleRequest request : requests) {
            Matcher m = PROPERTY_PATTERN.matcher(request.getName());
            if (m.matches()) {
                props.add(this.getAttributeName(m.group(2)));
                continue;
            }
            props.add(request.getName());
        }
        List refreshedAttributes = thisBean.refreshAttributes(props);
        for (MeasurementScheduleRequest request : requests) {
            String attributeName;
            Matcher m = PROPERTY_PATTERN.matcher(request.getName());
            String fullProperty = null;
            if (m.matches()) {
                fullProperty = m.group(2);
                attributeName = this.getAttributeName(fullProperty);
            } else {
                attributeName = request.getName();
            }
            EmsAttribute attribute = null;
            for (EmsAttribute refreshedAttribute : refreshedAttributes) {
                if (!attributeName.equals(refreshedAttribute.getName())) continue;
                attribute = refreshedAttribute;
            }
            if (attribute == null) {
                log.debug((Object)("Unable to collect measurement, attribute [" + request.getName() + "] not found on [" + this.resourceContext.getResourceKey() + "]"));
                continue;
            }
            Object value = attribute.getValue();
            if (value != null && fullProperty != null) {
                value = this.lookupAttributeProperty(value, fullProperty);
            }
            if (request.getDataType() == DataType.MEASUREMENT && value instanceof Number) {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)value).doubleValue())));
                continue;
            }
            if (request.getDataType() != DataType.TRAIT) continue;
            String displayValue = null;
            displayValue = value != null && value.getClass().isArray() ? Arrays.deepToString((Object[])value) : String.valueOf(value);
            report.addData(new MeasurementDataTrait(request, displayValue));
        }
    }

    protected Object lookupAttributeProperty(Object value, String property) {
        String[] ps = property.split("\\.", 2);
        String searchProperty = ps[0];
        Class<?>[] interfaces = value.getClass().getInterfaces();
        boolean isCompositeData = false;
        for (Class<?> intf : interfaces) {
            if (!intf.getName().equals(CompositeData.class.getName())) continue;
            isCompositeData = true;
        }
        if (value.getClass().getName().equals(CompositeData.class.getName()) || isCompositeData) {
            try {
                Method m = value.getClass().getMethod("get", String.class);
                value = m.invoke(value, ps[1]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                log.info((Object)("Unable to read attribute property [" + property + "] from composite data value"), (Throwable)e);
            }
        } else {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equals(searchProperty)) continue;
                    value = pd.getReadMethod().invoke(value, new Object[0]);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Unable to read property from measurement attribute [" + searchProperty + "] not found on [" + this.resourceContext.getResourceKey() + "]"));
            }
        }
        if (ps.length > 1) {
            value = this.lookupAttributeProperty(value, ps[1]);
        }
        return value;
    }

    protected String getAttributeName(String property) {
        return property.split("\\.", 2)[0];
    }

    protected String getAttributeProperty(String property) {
        if (property.startsWith("{")) {
            return property.substring(property.indexOf(46) + 1, property.length() - 1);
        }
        return null;
    }

    public Configuration loadResourceConfiguration() {
        Configuration configuration = new Configuration();
        ConfigurationDefinition configurationDefinition = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        for (PropertyDefinition property : configurationDefinition.getPropertyDefinitions().values()) {
            EmsAttribute attribute;
            if (!(property instanceof PropertyDefinitionSimple) || (attribute = this.getEmsBean().getAttribute(property.getName())) == null) continue;
            configuration.put((Property)new PropertySimple(property.getName(), attribute.refresh()));
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        this.updateResourceConfiguration(report, false);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report, boolean ignoreReadOnly) {
        ConfigurationDefinition configurationDefinition = this.getResourceContext().getResourceType().getResourceConfigurationDefinition();
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        for (String key : report.getConfiguration().getSimpleProperties().keySet()) {
            PropertySimple property = report.getConfiguration().getSimple(key);
            if (property == null) continue;
            EmsAttribute attribute = this.bean.getAttribute(key);
            try {
                PropertyDefinitionSimple def = configurationDefinition.getPropertyDefinitionSimple(property.getName());
                if (ignoreReadOnly && def.isReadOnly()) continue;
                switch (def.getType()) {
                    case INTEGER: {
                        attribute.setValue((Object)property.getIntegerValue());
                        break;
                    }
                    case LONG: {
                        attribute.setValue((Object)property.getLongValue());
                        break;
                    }
                    case BOOLEAN: {
                        attribute.setValue((Object)property.getBooleanValue());
                        break;
                    }
                    case FLOAT: {
                        attribute.setValue((Object)property.getFloatValue());
                        break;
                    }
                    case DOUBLE: {
                        attribute.setValue((Object)property.getDoubleValue());
                        break;
                    }
                    default: {
                        attribute.setValue((Object)property.getStringValue());
                    }
                }
            }
            catch (Exception e) {
                property.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                report.setErrorMessage("Failed setting resource configuration - see property error messages for details");
                log.info((Object)("Failure setting MBean Resource configuration value for " + key), (Throwable)e);
            }
        }
    }

    @Override
    public EmsConnection getEmsConnection() {
        return ((JMXComponent)this.resourceContext.getParentResourceComponent()).getEmsConnection();
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        return this.invokeOperation(name, parameters, this.getEmsBean());
    }

    public OperationResult invokeOperation(String name, Configuration parameters, EmsBean emsBean) throws Exception {
        OperationResult resultToReturn;
        boolean hasVoidReturnType;
        if (emsBean == null) {
            throw new Exception("Can not invoke operation [" + name + "], as we can't connect to the MBean - is it down?");
        }
        Map paramProps = parameters.getSimpleProperties();
        SortedSet emsOperations = emsBean.getOperations();
        EmsOperation operation = null;
        for (EmsOperation emsOperation : emsOperations) {
            if (!emsOperation.getName().equals(name) || emsOperation.getParameters().size() != paramProps.size()) continue;
            operation = emsOperation;
            break;
        }
        if (operation == null) {
            operation = emsBean.getOperation(name);
        }
        if (operation == null) {
            throw new Exception("Operation [" + name + "] not found on MBean [" + emsBean.getBeanName() + "].");
        }
        List emsParams = operation.getParameters();
        HashMap<String, Integer> emsParamIndexesByName = new HashMap<String, Integer>();
        int emsParamsSize = emsParams.size();
        for (int i = 0; i < emsParamsSize; ++i) {
            EmsParameter emsParam = (EmsParameter)emsParams.get(i);
            if (emsParam.getName() == null) continue;
            emsParamIndexesByName.put(emsParam.getName(), i);
        }
        Object[] paramValues = new Object[operation.getParameters().size()];
        for (String propName : paramProps.keySet()) {
            Object paramValue;
            Integer paramIndex;
            if (propName.matches("\\[\\d+\\]")) {
                paramIndex = Integer.valueOf(propName.substring(propName.indexOf(91) + 1, propName.indexOf(93)));
                if (paramIndex < 0 || paramIndex >= emsParams.size()) {
                    throw new IllegalStateException("Index [" + paramIndex + "] specified for parameter of operation [" + name + "] on MBean [" + emsBean.getBeanName() + "] is invalid. The MBean operation takes " + emsParams.size() + " parameters.");
                }
            } else {
                paramIndex = (Integer)emsParamIndexesByName.get(propName);
                if (paramIndex == null) {
                    throw new IllegalStateException("Name [" + propName + "] specified for parameter of operation [" + name + "] on MBean [" + emsBean.getBeanName() + "] is invalid. The MBean operation does not take a parameter by that name.");
                }
            }
            EmsParameter emsParam = (EmsParameter)emsParams.get(paramIndex);
            PropertySimple paramProp = (PropertySimple)paramProps.get(propName);
            String emsParamType = emsParam.getType();
            paramValues[paramIndex.intValue()] = paramValue = this.getPropertyValueAsType(paramProp, emsParamType);
        }
        ArrayList<Object> resultObject = operation.invoke(paramValues);
        boolean bl = hasVoidReturnType = operation.getReturnType() == null || Void.class.getName().equals(operation.getReturnType()) || Void.TYPE.getName().equals(operation.getReturnType());
        if (resultObject == null && hasVoidReturnType) {
            resultToReturn = null;
        } else {
            if (resultObject != null && resultObject.getClass().isArray()) {
                int len = Array.getLength(resultObject);
                ArrayList<Object> list = new ArrayList<Object>(len);
                for (int index = 0; index < len; ++index) {
                    list.add(Array.get(resultObject, index));
                }
                resultObject = list;
            }
            resultToReturn = resultObject instanceof OperationResult ? (OperationResult)resultObject : new OperationResult(String.valueOf(resultObject));
        }
        return resultToReturn;
    }

    protected Object getPropertyValueAsType(PropertySimple propSimple, String typeName) {
        Object value;
        if (typeName.equals(String.class.getName())) {
            value = propSimple == null ? null : propSimple.getStringValue();
        } else if (typeName.equals(Boolean.class.getName()) || typeName.equals(Boolean.TYPE.getName())) {
            value = propSimple == null ? null : propSimple.getBooleanValue();
        } else if (typeName.equals(Integer.class.getName()) || typeName.equals(Integer.TYPE.getName())) {
            value = propSimple == null ? null : propSimple.getIntegerValue();
        } else if (typeName.equals(Long.class.getName()) || typeName.equals(Long.TYPE.getName())) {
            value = propSimple == null ? null : propSimple.getLongValue();
        } else if (typeName.equals(Float.class.getName()) || typeName.equals(Float.TYPE.getName())) {
            value = propSimple == null ? null : propSimple.getFloatValue();
        } else if (typeName.equals(Double.class.getName()) || typeName.equals(Double.TYPE.getName())) {
            value = propSimple == null ? null : propSimple.getDoubleValue();
        } else {
            throw new IllegalStateException("Operation parameter maps to MBean parameter with an unsupported type (" + typeName + ").");
        }
        return value;
    }
}

