/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7.helper;

import java.io.File;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.modules.plugins.jbossas7.JBossProductType;

public class ServerPluginConfiguration {
    private Configuration pluginConfig;

    public ServerPluginConfiguration(Configuration pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public String getHostname() {
        return this.pluginConfig.getSimpleValue("hostname");
    }

    public void setHostname(String hostname) {
        this.pluginConfig.setSimpleValue("hostname", hostname);
    }

    public Integer getPort() {
        String stringValue = this.pluginConfig.getSimpleValue("port");
        return stringValue != null ? Integer.valueOf(stringValue) : null;
    }

    public void setPort(int port) {
        this.pluginConfig.setSimpleValue("port", String.valueOf(port));
    }

    public String getUser() {
        return this.pluginConfig.getSimpleValue("user");
    }

    public void setUser(String user) {
        this.pluginConfig.setSimpleValue("user", user);
    }

    public String getPassword() {
        return this.pluginConfig.getSimpleValue("password");
    }

    public void setPassword(String password) {
        this.pluginConfig.setSimpleValue("password", password);
    }

    public Long getManagementConnectionTimeout() {
        return this.pluginConfig.getSimple("managementConnectionTimeout").getLongValue();
    }

    public File getHomeDir() {
        String stringValue = this.pluginConfig.getSimpleValue("homeDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setHomeDir(File homeDir) {
        this.pluginConfig.setSimpleValue("homeDir", homeDir != null ? homeDir.toString() : null);
    }

    public File getBaseDir() {
        String stringValue = this.pluginConfig.getSimpleValue("baseDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setBaseDir(File homeDir) {
        this.pluginConfig.setSimpleValue("baseDir", homeDir != null ? homeDir.toString() : null);
    }

    public File getConfigDir() {
        String stringValue = this.pluginConfig.getSimpleValue("configDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setConfigDir(File configDir) {
        this.pluginConfig.setSimpleValue("configDir", configDir != null ? configDir.toString() : null);
    }

    public File getLogDir() {
        String stringValue = this.pluginConfig.getSimpleValue("logDir");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setLogDir(File logDir) {
        this.pluginConfig.setSimpleValue("logDir", logDir != null ? logDir.toString() : null);
    }

    public JBossProductType getProductType() {
        String stringValue = this.pluginConfig.getSimpleValue("productType");
        return stringValue != null && !stringValue.isEmpty() ? JBossProductType.valueOf(stringValue) : null;
    }

    public void setProductType(JBossProductType productType) {
        this.pluginConfig.setSimpleValue("productType", productType != null ? productType.name() : null);
    }

    public File getHostConfigFile() {
        String stringValue = this.pluginConfig.getSimpleValue("hostConfigFile");
        return stringValue != null && !stringValue.isEmpty() ? new File(stringValue) : null;
    }

    public void setHostConfigFile(File hostConfigFile) {
        this.pluginConfig.setSimpleValue("hostConfigFile", hostConfigFile != null ? hostConfigFile.toString() : null);
    }

    public abstract class Property {
        public static final String HOSTNAME = "hostname";
        public static final String PORT = "port";
        public static final String USER = "user";
        public static final String PASSWORD = "password";
        public static final String MANAGEMENT_CONNECTION_TIMEOUT = "managementConnectionTimeout";
        public static final String HOME_DIR = "homeDir";
        public static final String BASE_DIR = "baseDir";
        public static final String CONFIG_DIR = "configDir";
        public static final String LOG_DIR = "logDir";
        public static final String PRODUCT_TYPE = "productType";
        public static final String HOST_CONFIG_FILE = "hostConfigFile";
    }
}

