/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.StringUtil;
import org.rhq.plugins.netservices.PortNetServiceComponentConfiguration;

public class PortNetServiceComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(PortNetServiceComponent.class);
    private static final int CONNECTION_TIMEOUT = 2000;
    private PortNetServiceComponentConfiguration componentConfiguration;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException {
        this.componentConfiguration = PortNetServiceComponent.createComponentConfiguration(resourceContext.getPluginConfiguration());
    }

    static PortNetServiceComponentConfiguration createComponentConfiguration(Configuration pluginConfig) throws InvalidPluginConfigurationException {
        InetAddress address;
        int port;
        String addressString = pluginConfig.getSimpleValue("address", "");
        if (StringUtil.isBlank((String)addressString)) {
            throw new InvalidPluginConfigurationException("Address is not defined");
        }
        String portString = pluginConfig.getSimpleValue("port", "");
        if (StringUtil.isBlank((String)portString)) {
            throw new InvalidPluginConfigurationException("Port is not defined");
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new InvalidPluginConfigurationException("Invalid port number: " + portString);
        }
        try {
            address = InetAddress.getByName(addressString);
        }
        catch (UnknownHostException uhe) {
            throw new InvalidPluginConfigurationException((Throwable)uhe);
        }
        return new PortNetServiceComponentConfiguration(address, port);
    }

    public void stop() {
        this.componentConfiguration = null;
    }

    public AvailabilityType getAvailability() {
        return this.portReachable() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("ipAddress")) {
                report.addData(new MeasurementDataTrait(request, this.componentConfiguration.getAddress().getHostAddress()));
                continue;
            }
            if (request.getName().equals("hostName")) {
                report.addData(new MeasurementDataTrait(request, this.componentConfiguration.getAddress().getCanonicalHostName()));
                continue;
            }
            if (!request.getName().equals("connectTime")) continue;
            long start = System.currentTimeMillis();
            if (!this.portReachable()) continue;
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean portReachable() {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(this.componentConfiguration.getAddress(), this.componentConfiguration.getPort()), 2000);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unable to reach remote port: " + this.componentConfiguration.toString()), (Throwable)e);
            }
        }
        finally {
            if (socket != null) {
                this.closeQuietly(socket);
            }
        }
        return false;
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class ConfigKeys {
        public static final String ADDRESS = "address";
        public static final String PORT = "port";

        private ConfigKeys() {
        }
    }
}

