/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssJbnPatch;
import churchillobjects.rss4j.RssSyndication;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl091;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

class RssGeneratorImpl100
extends RssGeneratorImpl091 {
    private static final String XMLNS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected static final String XMLNS = "http://purl.org/rss/1.0/";
    protected static final String ROOT_ELEMENT = "RDF";
    private boolean usesSyndication = false;
    private boolean usesDublinCore = false;
    private boolean usesJbnPatch = false;
    private Vector imageElements;
    private Vector itemElements;
    private Vector textInputElements;

    RssGeneratorImpl100() throws RssGenerationException {
    }

    protected void setMaxLengths() {
    }

    protected void createRssDocument(RssDocument data) {
        this.checkExtensions(data);
        this.imageElements = new Vector();
        this.itemElements = new Vector();
        this.textInputElements = new Vector();
        this.doc = this.domImpl.createDocument(XMLNS, ROOT_ELEMENT, null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setPrefix("rdf");
        this.rootElement.setAttribute("xmlns:rdf", XMLNS_RDF);
        this.rootElement.setAttribute("xmlns", XMLNS);
        if (this.usesDublinCore) {
            this.rootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        }
        if (this.usesSyndication) {
            this.rootElement.setAttribute("xmlns:sy", "http://purl.org/rss/1.0/modules/syndication/");
        }
        if (this.usesJbnPatch) {
            this.rootElement.setAttribute("xmlns:jbn", "http://network.jboss.com/elements/1.0/");
        }
    }

    protected void handleChannel(RssChannel channel) throws RssGenerationException {
        Element channelElement = this.doc.createElement("channel");
        this.rootElement.appendChild(channelElement);
        String channelUri = channel.getChannelUri();
        if (channelUri == null) {
            throw new RssGenerationException("The channel URI is required for RSS 1.0.");
        }
        this.validateUri(channelUri);
        channelElement.setAttribute("rdf:about", channelUri);
        this.handleChannelTitle(channel, channelElement);
        this.handleChannelDescription(channel, channelElement);
        this.handleChannelLink(channel, channelElement);
        this.handleImage(channel, channelElement);
        this.handleItems(channel, channelElement);
        this.handleTextInput(channel, channelElement);
        this.handleDublinCore(channel.getDublinCore(), channelElement);
        this.handleSyndication(channel, channelElement);
    }

    protected void finishDocument() throws RssGenerationException {
        this.handleDocumentImages();
        this.handleDocumentItems();
        this.handleDocumentTextInputs();
    }

    protected void handleTextInput(RssChannel channel, Element channelElement) {
        RssChannelTextInput textInput = channel.getChannelTextInput();
        if (textInput != null) {
            this.textInputElements.addElement(textInput);
            Element textInputElement = this.doc.createElement("textinput");
            textInputElement.setAttribute("rdf:resource", textInput.getInputLink());
            channelElement.appendChild(textInputElement);
        }
    }

    protected void handleDocumentTextInputs() throws RssGenerationException {
        Enumeration enumeration = this.textInputElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelTextInput textInput = (RssChannelTextInput)enumeration.nextElement();
            if (textInput == null) continue;
            Element textInputElement = this.doc.createElement("textinput");
            textInputElement.setAttribute("rdf:about", textInput.getInputLink());
            this.handleTextInputTitle(textInput, textInputElement);
            this.handleTextInputDescription(textInput, textInputElement);
            this.handleTextInputName(textInput, textInputElement);
            this.handleTextInputLink(textInput, textInputElement);
            this.handleDublinCore(textInput.getDublinCore(), textInputElement);
            this.rootElement.appendChild(textInputElement);
        }
    }

    protected void handleItems(RssChannel channel, Element channelElement) throws RssGenerationException {
        if (channel.getItemCount() == 0) {
            throw new RssGenerationException("Each channel must have at least one item");
        }
        Enumeration enumeration = channel.items();
        Element itemsElement = this.doc.createElement("items");
        channelElement.appendChild(itemsElement);
        Element itemsSequenceElement = this.doc.createElement("rdf:Seq");
        itemsElement.appendChild(itemsSequenceElement);
        while (enumeration.hasMoreElements()) {
            RssChannelItem item = (RssChannelItem)enumeration.nextElement();
            if (item == null) continue;
            this.itemElements.addElement(item);
            Element itemElement = this.doc.createElement("rdf:li");
            itemElement.setAttribute("rdf:resource", item.getItemLink());
            itemsSequenceElement.appendChild(itemElement);
        }
    }

    protected void handleDocumentItems() throws RssGenerationException {
        Enumeration enumeration = this.itemElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelItem item = (RssChannelItem)enumeration.nextElement();
            if (item == null) continue;
            Element itemElement = this.doc.createElement("item");
            itemElement.setAttribute("rdf:about", item.getItemLink());
            this.handleItemTitle(item, itemElement);
            this.handleItemLink(item, itemElement);
            this.handleItemDescription(item, itemElement);
            this.handleDublinCore(item.getDublinCore(), itemElement);
            this.handleJbnPatch(item.getJbnPatch(), itemElement);
            this.rootElement.appendChild(itemElement);
        }
    }

    protected void handleImage(RssChannel channel, Element channelElement) {
        RssChannelImage image = channel.getChannelImage();
        this.imageElements.addElement(image);
        if (image != null) {
            Element imageElement = this.doc.createElement("image");
            imageElement.setAttribute("rdf:resource", image.getImageUrl());
            channelElement.appendChild(imageElement);
        }
    }

    protected void handleDocumentImages() throws RssGenerationException {
        Enumeration enumeration = this.imageElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelImage image = (RssChannelImage)enumeration.nextElement();
            if (image == null) continue;
            Element imageElement = this.doc.createElement("image");
            imageElement.setAttribute("rdf:about", image.getImageUrl());
            this.handleImageTitle(image, imageElement);
            this.handleImageUrl(image, imageElement);
            this.handleImageLink(image, imageElement);
            this.handleDublinCore(image.getDublinCore(), imageElement);
            this.rootElement.appendChild(imageElement);
        }
    }

    protected void checkExtensions(RssDocument data) {
        Enumeration channels = data.channels();
        while (channels.hasMoreElements()) {
            RssChannel channel = (RssChannel)channels.nextElement();
            if (channel == null) continue;
            if (channel.getChannelSyndication() != null) {
                this.usesSyndication = true;
            }
            if (channel.getDublinCore() != null) {
                this.usesDublinCore = true;
            }
            Enumeration enumeration = channel.items();
            while (enumeration.hasMoreElements()) {
                RssChannelItem item = (RssChannelItem)enumeration.nextElement();
                if (item == null) continue;
                if (item.getDublinCore() != null) {
                    this.usesDublinCore = true;
                }
                if (item.getJbnPatch() == null) continue;
                this.usesJbnPatch = true;
            }
        }
    }

    protected void handleSyndication(RssChannel channel, Element channelElement) throws RssGenerationException {
        RssSyndication syn = channel.getChannelSyndication();
        if (syn != null) {
            if (syn.getUpdateBase() == null) {
                throw new RssGenerationException("An update base is required for syndication.");
            }
            this.add(channelElement, "sy:updatePeriod", syn.getUpdatePeriod());
            this.add(channelElement, "sy:updateFrequency", "" + syn.getUpdateFrequency());
            this.add(channelElement, "sy:updateBase", syn.getUpdateBase());
        }
    }

    protected void handleDublinCore(RssDublinCore dc, Element channelElement) {
        if (dc != null) {
            this.add(channelElement, "dc:title", dc.getTitle());
            this.add(channelElement, "dc:creator", dc.getCreator());
            this.add(channelElement, "dc:subject", dc.getSubject());
            this.add(channelElement, "dc:description", dc.getDescription());
            this.add(channelElement, "dc:publisher", dc.getPublisher());
            this.add(channelElement, "dc:contributor", dc.getContributor());
            this.add(channelElement, "dc:date", dc.getDateAs8601());
            this.add(channelElement, "dc:type", dc.getType());
            this.add(channelElement, "dc:format", dc.getFormat());
            this.add(channelElement, "dc:identifier", dc.getIdentifier());
            this.add(channelElement, "dc:source", dc.getSource());
            this.add(channelElement, "dc:language", dc.getLanguage());
            this.add(channelElement, "dc:relation", dc.getRelation());
            this.add(channelElement, "dc:coverage", dc.getCoverage());
            this.add(channelElement, "dc:rights", dc.getRights());
            this.add(channelElement, "dc:modified", dc.getModified());
        }
    }

    protected void handleJbnPatch(RssJbnPatch jbn, Element channelElement) {
        if (jbn != null) {
            this.add(channelElement, "jbn:creator", jbn.getCreator());
            this.add(channelElement, "jbn:distributionStatus", jbn.getDistributionStatus());
            this.add(channelElement, "jbn:licenseName", jbn.getLicenseName());
            this.add(channelElement, "jbn:licenseVersion", jbn.getLicenseVersion());
            this.add(channelElement, "jbn:type", jbn.getType());
            this.add(channelElement, "jbn:products", "jbn:product", jbn.getProducts());
            this.add(channelElement, "jbn:jira", jbn.getJira());
            this.add(channelElement, "jbn:caseId", jbn.getCaseId());
            this.add(channelElement, "jbn:md5", jbn.getMd5());
            this.add(channelElement, "jbn:sha256", jbn.getSha256());
            this.add(channelElement, "jbn:fileName", jbn.getFileName());
            this.add(channelElement, "jbn:fileSize", jbn.getFileSize());
            this.add(channelElement, "jbn:downloadUrl", jbn.getDownloadUrl());
            this.add(channelElement, "jbn:automatedDownloadUrl", jbn.getAutomatedDownloadUrl());
            this.add(channelElement, "jbn:instructionCompatibilityVersion", jbn.getInstructionCompatibilityVersion());
            this.add(channelElement, "jbn:longDescription", jbn.getLongDescription());
            this.add(channelElement, "jbn:shortDescription", jbn.getShortDescription());
            this.add(channelElement, "jbn:manualInstallation", jbn.getManualInstallation());
            this.add(channelElement, "jbn:automatedInstallation", jbn.getAutomatedInstallation());
            this.add(channelElement, "jbn:requires", "jbn:patch", "rdf:about", jbn.getRequires());
            this.add(channelElement, "jbn:isReplacedBy", "jbn:patch", "rdf:about", jbn.getReplacedBy());
            this.add(channelElement, "jbn:replaces", "jbn:patch", "rdf:about", jbn.getReplaces());
            this.add(channelElement, "jbn:compatibleWith", "jbn:patch", "rdf:about", jbn.getCompatibleWith());
            this.add(channelElement, "jbn:lastUpdated", jbn.getLastUpdatedAsString());
        }
    }
}

