/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postfix;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.augeas.AugeasConfigurationDiscoveryComponent;

public class PostfixServerDiscoveryComponent
extends AugeasConfigurationDiscoveryComponent {
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("[\\s]*myhostname[\\s]*=[\\s]*([^$].*)[\\s]*");

    public Set discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        Set resources = super.discoverResources(resourceDiscoveryContext);
        for (DiscoveredResourceDetails detail : resources) {
            String resourceName;
            Configuration config = detail.getPluginConfiguration();
            PropertySimple property = (PropertySimple)config.get("configurationFilesInclusionPatterns");
            String configFilePath = property.getStringValue();
            try {
                resourceName = this.findHostName(configFilePath);
            }
            catch (Exception e) {
                resourceName = resourceDiscoveryContext.getSystemInformation().getHostname();
            }
            detail.setResourceName(resourceName);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findHostName(String includeFile) throws Exception {
        try {
            File file = new File(includeFile);
            if (!file.exists()) throw new Exception("NetBios name was not found in configuration file " + includeFile);
            FileInputStream fstream = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            try {
                String glob;
                String strLine;
                Matcher m;
                do {
                    if ((strLine = br.readLine()) == null) throw new Exception("NetBios name was not found in configuration file " + includeFile);
                } while (!(m = HOSTNAME_PATTERN.matcher(strLine)).matches());
                String string = glob = m.group(1);
                return string;
            }
            finally {
                StreamUtil.safeClose((Closeable)br);
            }
        }
        catch (Exception e) {
            throw new Exception("NetBios name was not found in configuration file " + includeFile + " cause:", e);
        }
    }
}

