/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.util.StringUtil;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;

public class SnmpTrapSender
implements PDUFactory {
    public static final int DEFAULT = 0;
    private static final String UDP_TRANSPORT = "udp";
    private static final String TCP_TRANSPORT = "tcp";
    private Log log = LogFactory.getLog(SnmpTrapSender.class);
    private Target target;
    private OID authProtocol;
    private OID privProtocol;
    private OctetString privPassphrase;
    private OctetString authPassphrase;
    private OctetString community = new OctetString("public");
    private OctetString contextEngineID;
    private OctetString contextName = new OctetString();
    private OctetString securityName = new OctetString();
    private TimeTicks sysUpTime = new TimeTicks(0L);
    private OID trapOID = SnmpConstants.coldStart;
    private PDUv1 v1TrapPDU = new PDUv1();
    private int version = 3;
    private int retries = 1;
    private int timeout = 1000;
    private int pduType = -89;
    private int maxRepetitions = 10;
    private int nonRepeaters = 0;
    private List<VariableBinding> vbs = new ArrayList<VariableBinding>();
    private Address address;
    private int operation = 0;
    private boolean snmpEnabled;
    Configuration systemConfig;

    public SnmpTrapSender(Configuration preferences) {
        this.systemConfig = preferences;
        this.snmpEnabled = this.init();
    }

    private void checkTrapVariables(List<VariableBinding> vbs) {
        if (this.pduType == -90 || this.pduType == -89) {
            if (vbs.size() == 0 || vbs.size() >= 1 && !vbs.get(0).getOid().equals((Object)SnmpConstants.sysUpTime)) {
                vbs.add(0, new VariableBinding(SnmpConstants.sysUpTime, (Variable)this.sysUpTime));
            }
            if (vbs.size() == 1 || vbs.size() >= 2 && !vbs.get(1).getOid().equals((Object)SnmpConstants.snmpTrapOID)) {
                vbs.add(1, new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)this.trapOID));
            }
        }
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Snmp createSnmpSession() throws IOException {
        Object transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp((TransportMapping)transport);
        if (this.version == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            this.addUsmUser(snmp);
        }
        return snmp;
    }

    private Target createTarget() {
        if (this.version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDU send() throws IOException {
        Snmp snmp = this.createSnmpSession();
        try {
            this.target = this.createTarget();
            this.target.setVersion(this.version);
            this.target.setAddress(this.address);
            this.target.setRetries(this.retries);
            this.target.setTimeout((long)this.timeout);
            snmp.listen();
            PDU request = this.createPDU(this.target);
            if (request.getType() == -91) {
                request.setMaxRepetitions(this.maxRepetitions);
                request.setNonRepeaters(this.nonRepeaters);
            }
            for (VariableBinding vb : this.vbs) {
                request.add(vb);
            }
            PDU response = null;
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.send(request, this.target);
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Received response after " + (System.currentTimeMillis() - startTime) + " millis"));
                }
            }
            PDU pDU = response;
            return pDU;
        }
        finally {
            snmp.close();
        }
    }

    private void getVariableBindings(String args) {
        String oid = args;
        char type = 'i';
        String value = null;
        int equal = oid.indexOf("={");
        if (equal > 0) {
            oid = args.substring(0, equal);
            type = args.charAt(equal + 2);
            value = args.substring(args.indexOf(125) + 1);
        } else if (oid.indexOf(45) > 0) {
            StringTokenizer st = new StringTokenizer(oid, "-");
            if (st.countTokens() != 2) {
                throw new IllegalArgumentException("Illegal OID range specified: '" + oid);
            }
            oid = st.nextToken();
            VariableBinding vbLower = new VariableBinding(new OID(oid));
            this.vbs.add(vbLower);
            long last = Long.parseLong(st.nextToken());
            long first = vbLower.getOid().lastUnsigned();
            for (long k = first + 1L; k <= last; ++k) {
                OID nextOID = new OID(vbLower.getOid().getValue(), 0, vbLower.getOid().size() - 1);
                nextOID.appendUnsigned(k);
                VariableBinding next = new VariableBinding(nextOID);
                this.vbs.add(next);
            }
            return;
        }
        VariableBinding vb = new VariableBinding(new OID(oid));
        if (value != null) {
            Null variable;
            switch (type) {
                case 'i': {
                    variable = new Integer32(Integer.parseInt(value));
                    break;
                }
                case 'u': {
                    variable = new UnsignedInteger32(Long.parseLong(value));
                    break;
                }
                case 's': {
                    variable = new OctetString(value);
                    break;
                }
                case 'x': {
                    variable = OctetString.fromString((String)value, (char)':', (int)16);
                    break;
                }
                case 'd': {
                    variable = OctetString.fromString((String)value, (char)'.', (int)10);
                    break;
                }
                case 'b': {
                    variable = OctetString.fromString((String)value, (char)' ', (int)2);
                    break;
                }
                case 'n': {
                    variable = new Null();
                    break;
                }
                case 'o': {
                    variable = new OID(value);
                    break;
                }
                case 't': {
                    variable = new TimeTicks(Long.parseLong(value));
                    break;
                }
                case 'a': {
                    variable = new IpAddress(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Variable type " + type + " not supported");
                }
            }
            vb.setVariable((Variable)variable);
        }
        this.vbs.add(vb);
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString((String)s.substring(2), (char)':') : new OctetString(s);
        return octetString;
    }

    private static Address createAddress(Configuration properties) {
        String host = properties.getSimpleValue("host", null);
        String portS = properties.getSimpleValue("port", "162");
        Integer port = Integer.valueOf(portS);
        String transport = UDP_TRANSPORT;
        String address = host + "/" + port;
        if (UDP_TRANSPORT.equalsIgnoreCase(UDP_TRANSPORT)) {
            return new UdpAddress(address);
        }
        if (UDP_TRANSPORT.equalsIgnoreCase(TCP_TRANSPORT)) {
            return new TcpAddress(address);
        }
        throw new IllegalArgumentException("Unknown transport: udp");
    }

    protected String getVariableBindings(PDU response) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < response.size(); ++i) {
            VariableBinding vb = response.get(i);
            strBuf.append(vb.toString());
        }
        return strBuf.toString();
    }

    protected String getReport(PDU response) {
        if (response.size() < 1) {
            return "REPORT PDU does not contain a variable binding.";
        }
        VariableBinding vb = response.get(0);
        OID oid = vb.getOid();
        this.log.debug((Object)(" Current counter value is " + vb.getVariable() + "."));
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals((Object)oid)) {
            return "REPORT: Unsupported Security Level.";
        }
        if (SnmpConstants.usmStatsNotInTimeWindows.equals((Object)oid)) {
            return "REPORT: Message not within time window.";
        }
        if (SnmpConstants.usmStatsUnknownUserNames.equals((Object)oid)) {
            return "REPORT: Unknown user name.";
        }
        if (SnmpConstants.usmStatsUnknownEngineIDs.equals((Object)oid)) {
            return "REPORT: Unknown engine id.";
        }
        if (SnmpConstants.usmStatsWrongDigests.equals((Object)oid)) {
            return "REPORT: Wrong digest.";
        }
        if (SnmpConstants.usmStatsDecryptionErrors.equals((Object)oid)) {
            return "REPORT: Decryption error.";
        }
        if (SnmpConstants.snmpUnknownSecurityModels.equals((Object)oid)) {
            return "REPORT: Unknown security model.";
        }
        if (SnmpConstants.snmpInvalidMsgs.equals((Object)oid)) {
            return "REPORT: Invalid message.";
        }
        if (SnmpConstants.snmpUnknownPDUHandlers.equals((Object)oid)) {
            return "REPORT: Unknown PDU handler.";
        }
        if (SnmpConstants.snmpUnavailableContexts.equals((Object)oid)) {
            return "REPORT: Unavailable context.";
        }
        if (SnmpConstants.snmpUnknownContexts.equals((Object)oid)) {
            return "REPORT: Unknown context.";
        }
        return "REPORT contains unknown OID (" + oid.toString() + ").";
    }

    public synchronized void processPdu(CommandResponderEvent e) {
        PDU command = e.getPDU();
        if (command != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)command.toString());
            }
            if (command.getType() != -89 && command.getType() != -92 && command.getType() != -88 && command.getType() != -94) {
                command.setErrorIndex(0);
                command.setErrorStatus(0);
                command.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference ref = e.getStateReference();
                try {
                    e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), command, e.getMaxSizeResponsePDU(), ref, statusInformation);
                }
                catch (MessageException ex) {
                    this.log.error((Object)("Error while sending response: " + ex.getMessage()));
                }
            }
        }
    }

    public PDU createPDU(Target target) {
        ScopedPDU request;
        if (target.getVersion() == 3) {
            ScopedPDU scopedPDU = request = new ScopedPDU();
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else if (this.pduType == -92) {
            this.v1TrapPDU.setTimestamp(this.sysUpTime.toLong());
            request = this.v1TrapPDU;
        } else {
            request = new PDU();
        }
        request.setType(this.pduType);
        return request;
    }

    public String sendSnmpTrap(Alert alert, Configuration alertParameters, String platformName, String conditions, Date bootTime, String alertUrl, String hierarchy) {
        if (!this.snmpEnabled) {
            return "SNMP is not enabled.";
        }
        String variableBindingPrefix = alertParameters.getSimpleValue("oid", null);
        this.address = SnmpTrapSender.createAddress(alertParameters);
        this.getVariableBindings(variableBindingPrefix + ".1" + "={s}" + alert.getAlertDefinition().getName());
        this.getVariableBindings(variableBindingPrefix + ".2" + "={s}" + alert.getAlertDefinition().getResource().getName());
        this.getVariableBindings(variableBindingPrefix + ".3" + "={s}" + platformName);
        this.getVariableBindings(variableBindingPrefix + ".4" + "={s}" + conditions);
        this.getVariableBindings(variableBindingPrefix + ".5" + "={s}" + alert.getAlertDefinition().getPriority().toString().toLowerCase());
        this.getVariableBindings(variableBindingPrefix + ".6" + "={s}" + alertUrl);
        this.getVariableBindings(variableBindingPrefix + ".7" + "={s}" + hierarchy);
        this.setSysUpTimeFromBootTime(bootTime);
        this.setTrapOIDFromAlertParameters(alertParameters);
        this.checkTrapVariables(this.vbs);
        try {
            PDU response = this.send();
            if (this.getPduType() == -89 || this.getPduType() == -92) {
                return PDU.getTypeString((int)this.getPduType()) + " sent successfully";
            }
            if (response == null) {
                return "Request timed out.";
            }
            if (response.getType() == -88) {
                return this.getReport(response);
            }
            if (this.operation == 0) {
                return "Response received with requestID=" + response.getRequestID() + ", errorIndex=" + response.getErrorIndex() + ", " + "errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")" + "\n" + this.getVariableBindings(response);
            }
            return "Received something strange: requestID=" + response.getRequestID() + ", errorIndex=" + response.getErrorIndex() + ", " + "errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")" + "\n" + this.getVariableBindings(response);
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage());
            return "Error while trying to send request: " + ex.getMessage();
        }
        catch (IllegalArgumentException ex) {
            this.log.error((Object)ex.getMessage());
            return "SNMPAction configured incorrectly: " + ex.getMessage();
        }
    }

    private void setSysUpTimeFromBootTime(Date bootTime) {
        long now = System.currentTimeMillis();
        long delta = bootTime != null ? now - bootTime.getTime() : 0L;
        this.setSysUpTime(new TimeTicks(delta / 1000L));
    }

    private void setTrapOIDFromAlertParameters(Configuration alertParameters) {
        String trapOid = alertParameters.getSimpleValue("trapOid", null);
        if (StringUtil.isNotBlank((String)trapOid)) {
            this.setTrapOID(new OID(trapOid));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean init() {
        String snmpVersion = this.systemConfig.getSimpleValue("snmpVersion", null);
        if (snmpVersion == null || snmpVersion.length() <= 0) return false;
        if (snmpVersion.equals("1")) {
            this.version = 0;
            this.pduType = -92;
        } else if (snmpVersion.equals("2c")) {
            this.version = 1;
        } else {
            if (!snmpVersion.equals("3")) throw new IllegalStateException("SNMP version " + snmpVersion + " is not supported.");
            this.version = 3;
        }
        if (this.pduType == -92 && this.version != 0) {
            throw new IllegalStateException("V1TRAP PDU type is only available for SNMP version 1");
        }
        String tmp = this.systemConfig.getSimpleValue("authProtocol", "MD5");
        if (tmp != null && tmp.length() > 0) {
            if (tmp.equals("MD5")) {
                this.authProtocol = AuthMD5.ID;
            } else {
                if (!tmp.equals("SHA")) throw new IllegalStateException("SNMP authentication protocol unsupported: " + tmp);
                this.authProtocol = AuthSHA.ID;
            }
        }
        if ((tmp = this.systemConfig.getSimpleValue("authPassphrase", null)) != null && tmp.length() > 0) {
            this.authPassphrase = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("privacyPassphrase", null)) != null && tmp.length() > 0) {
            this.privPassphrase = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("community", null)) != null && tmp.length() > 0) {
            this.community = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("engineId", null)) != null && tmp.length() > 0) {
            this.contextEngineID = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("targetContext", null)) != null && tmp.length() > 0) {
            this.contextName = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("securityName", null)) != null && tmp.length() > 0) {
            this.securityName = SnmpTrapSender.createOctetString(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("trapOid", null)) != null && tmp.length() > 0) {
            this.trapOID = new OID(tmp);
        }
        if ((tmp = this.systemConfig.getSimpleValue("enterpriseOid", null)) != null && tmp.length() > 0) {
            this.v1TrapPDU.setEnterprise(new OID(tmp));
        }
        if ((tmp = this.systemConfig.getSimpleValue("genericId", null)) != null && tmp.length() > 0) {
            this.v1TrapPDU.setGenericTrap(Integer.parseInt(tmp));
        }
        if ((tmp = this.systemConfig.getSimpleValue("specificId", null)) != null && tmp.length() > 0) {
            this.v1TrapPDU.setSpecificTrap(Integer.parseInt(tmp));
        }
        if ((tmp = this.systemConfig.getSimpleValue("agentAddress", null)) != null && tmp.length() > 0) {
            this.v1TrapPDU.setAgentAddress(new IpAddress(tmp));
        }
        if ((tmp = this.systemConfig.getSimpleValue("privacyProtocol", "AES")) != null && tmp.length() > 0) {
            if (tmp.equals("DES")) {
                this.privProtocol = PrivDES.ID;
            } else if (tmp.equals("AES128") || tmp.equals("AES")) {
                this.privProtocol = PrivAES128.ID;
            } else if (tmp.equals("AES192")) {
                this.privProtocol = PrivAES192.ID;
            } else {
                if (!tmp.equals("AES256")) throw new IllegalArgumentException("Privacy protocol " + tmp + " not supported");
                this.privProtocol = PrivAES256.ID;
            }
        }
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        return true;
    }

    public OctetString getAuthPassphrase() {
        return this.authPassphrase;
    }

    public void setAuthPassphrase(OctetString authPassphrase) {
        this.authPassphrase = authPassphrase;
    }

    public OID getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(OID authProtocol) {
        this.authProtocol = authProtocol;
    }

    public OctetString getCommunity() {
        return this.community;
    }

    public void setCommunity(OctetString community) {
        this.community = community;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.contextEngineID = contextEngineID;
    }

    public void setContextName(OctetString contextName) {
        this.contextName = contextName;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public OctetString getPrivPassphrase() {
        return this.privPassphrase;
    }

    public void setPrivPassphrase(OctetString privPassphrase) {
        this.privPassphrase = privPassphrase;
    }

    public OID getPrivProtocol() {
        return this.privProtocol;
    }

    public void setPrivProtocol(OID privProtocol) {
        this.privProtocol = privProtocol;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public TimeTicks getSysUpTime() {
        return this.sysUpTime;
    }

    public void setSysUpTime(TimeTicks sysUpTime) {
        this.sysUpTime = sysUpTime;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OID getTrapOID() {
        return this.trapOID;
    }

    public void setTrapOID(OID trapOID) {
        this.trapOID = trapOID;
    }

    public List getVbs() {
        return this.vbs;
    }

    public void setVbs(ArrayList vbs) {
        this.vbs = vbs;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getPduType() {
        return this.pduType;
    }

    public void setPduType(int pduType) {
        this.pduType = pduType;
    }
}

