function RuntimeException_3(cause){
  $fillInStackTrace(this);
  this.detailMessage = !cause?null:$toString_0(cause);
  this.cause = cause;
}

defineSeed(6, 7, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), RuntimeException_3);
function $setDate(this$static, dayOfMonth){
  this$static.setDate(dayOfMonth);
  return this$static.getTime();
}

function $setHours(this$static, hours){
  this$static.setHours(hours);
  return this$static.getTime();
}

function $setMinutes(this$static, minutes){
  this$static.setMinutes(minutes);
  return this$static.getTime();
}

function $setSeconds(this$static, seconds){
  this$static.setSeconds(seconds);
  return this$static.getTime();
}

function $setTime(this$static, milliseconds){
  this$static.setTime(milliseconds);
  return this$static.getTime();
}

function create_1(year, month, dayOfMonth, hours, minutes, seconds, millis){
  return new Date(year, month, dayOfMonth, hours, minutes, seconds, millis);
}

function $flushPostEventPumpCommands(this$static){
  var oldDeferred;
  if (this$static.deferredCommands) {
    oldDeferred = this$static.deferredCommands;
    this$static.deferredCommands = null;
    !this$static.incrementalCommands && (this$static.incrementalCommands = []);
    runScheduledTasks(oldDeferred, this$static.incrementalCommands);
  }
  !!this$static.incrementalCommands && (this$static.incrementalCommands = runRepeatingTasks(this$static.incrementalCommands));
}

function $isWorkQueued(this$static){
  return !!this$static.deferredCommands || !!this$static.incrementalCommands;
}

function $maybeSchedulePostEventPumpCommands(this$static){
  if (!this$static.shouldBeRunning) {
    this$static.shouldBeRunning = true;
    !this$static.flusher && (this$static.flusher = new SchedulerImpl$Flusher_0(this$static));
    scheduleFixedDelayImpl(this$static.flusher, 1);
    !this$static.rescue && (this$static.rescue = new SchedulerImpl$Rescuer_0(this$static));
    scheduleFixedDelayImpl(this$static.rescue, 50);
  }
}

function $scheduleDeferred(this$static, cmd){
  this$static.deferredCommands = push(this$static.deferredCommands, [cmd, false]);
  $maybeSchedulePostEventPumpCommands(this$static);
}

function execute(cmd){
  return cmd.execute();
}

function runRepeatingTasks(tasks){
  var canceledSomeTasks, i, length_0, newTasks, start, t;
  length_0 = tasks.length;
  if (length_0 == 0) {
    return null;
  }
  canceledSomeTasks = false;
  start = currentTimeMillis();
  while (currentTimeMillis() - start < 100) {
    for (i = 0; i < length_0; ++i) {
      t = tasks[i];
      if (!t) {
        continue;
      }
      if (!t[0].execute()) {
        tasks[i] = null;
        canceledSomeTasks = true;
      }
    }
  }
  if (canceledSomeTasks) {
    newTasks = [];
    for (i = 0; i < length_0; ++i) {
      !!tasks[i] && (newTasks[newTasks.length] = tasks[i] , undefined);
    }
    return newTasks.length == 0?null:newTasks;
  }
   else {
    return tasks;
  }
}

function scheduleFixedDelayImpl(cmd, delayMs){
  $clinit_SchedulerImpl();
  $wnd.setTimeout(function(){
    var ret = $entry(execute)(cmd);
    ret && $wnd.setTimeout(arguments.callee, delayMs);
  }
  , delayMs);
}

function SchedulerImpl$Flusher_0(this$0){
  this.this$0 = this$0;
}

defineSeed(26, 1, {}, SchedulerImpl$Flusher_0);
_.execute = function execute_0(){
  this.this$0.flushRunning = true;
  $flushPostEventPumpCommands(this.this$0);
  this.this$0.flushRunning = false;
  return this.this$0.shouldBeRunning = $isWorkQueued(this.this$0);
}
;
_.this$0 = null;
function SchedulerImpl$Rescuer_0(this$0){
  this.this$0 = this$0;
}

defineSeed(27, 1, {}, SchedulerImpl$Rescuer_0);
_.execute = function execute_1(){
  this.this$0.flushRunning && scheduleFixedDelayImpl(this.this$0.flusher, 1);
  return this.this$0.shouldBeRunning;
}
;
_.this$0 = null;
function $getFirstChildElement(elem){
  var child = elem.firstChild;
  while (child && child.nodeType != 1)
    child = child.nextSibling;
  return child;
}

function valueOf_0(enumType, name_0){
  var enumValueOfFunc;
  enumValueOfFunc = enumType.enumValueOfFunc;
  if (!enumValueOfFunc) {
    throw new IllegalArgumentException_0;
  }
  return enumValueOfFunc(name_0);
}

function $doRemoveNow(this$static, type, source, handler){
  var l_0, removed, sourceMap;
  l_0 = $getHandlerList(this$static, type, source);
  removed = l_0.remove_0(handler);
  removed && l_0.isEmpty_0() && (sourceMap = dynamicCast(this$static.map_0.get_2(type), Q$Map) , dynamicCast(sourceMap.remove_3(source), Q$List) , sourceMap.isEmpty_0() && this$static.map_0.remove_3(type) , undefined);
}

function $doRemove(this$static, type, source, handler){
  this$static.firingDepth > 0?$defer(this$static, new SimpleEventBus$3_0(this$static, type, source, handler)):$doRemoveNow(this$static, type, source, handler);
}

function encode(decodedURL){
  throwIfNull('decodedURL', decodedURL);
  return encodeURI(decodedURL);
}

function $getDefaultNative(){
  return ['CZK', 'K\u010D', 2, 'K\u010D', 'K\u010D'];
}

function $getNumberConstants(this$static){
  !this$static.numberConstants && (this$static.numberConstants = new NumberConstantsImpl_cs_0);
  return this$static.numberConstants;
}

function $clinit_NumberFormat(){
  $clinit_NumberFormat = nullMethod;
  $getNumberConstants(($clinit_LocaleInfo() , $clinit_LocaleInfo() , instance_0));
}

function $addExponent(this$static, digits){
  var exponentDigits, i;
  $append_1(digits.data_0, 'E');
  if (this$static.exponent < 0) {
    this$static.exponent = -this$static.exponent;
    $append_1(digits.data_0, '-');
  }
  exponentDigits = '' + this$static.exponent;
  for (i = exponentDigits.length; i < this$static.minExponentDigits; ++i) {
    $appendNonNull(digits.data_0, '0');
  }
  $append_1(digits.data_0, exponentDigits);
}

function $addZeroAndDecimal(this$static, digits, decimalSeparator){
  if (this$static.digitsLength == 0) {
    $replace(digits.data_0, 0, 0, '0');
    ++this$static.decimalPosition;
    ++this$static.digitsLength;
  }
  if (this$static.decimalPosition < this$static.digitsLength || this$static.decimalSeparatorAlwaysShown) {
    $insert_0(digits, this$static.decimalPosition, String.fromCharCode(decimalSeparator));
    ++this$static.digitsLength;
  }
}

function $adjustFractionDigits(this$static, digits){
  var requiredDigits, toRemove;
  requiredDigits = this$static.decimalPosition + this$static.minimumFractionDigits;
  if (this$static.digitsLength < requiredDigits) {
    while (this$static.digitsLength < requiredDigits) {
      $appendNonNull(digits.data_0, '0');
      ++this$static.digitsLength;
    }
  }
   else {
    toRemove = this$static.decimalPosition + this$static.maximumFractionDigits;
    toRemove > this$static.digitsLength && (toRemove = this$static.digitsLength);
    while (toRemove > requiredDigits && $charAt($toString_1(digits.data_0), toRemove - 1) == 48) {
      --toRemove;
    }
    if (toRemove < this$static.digitsLength) {
      $delete_0(digits, toRemove, this$static.digitsLength);
      this$static.digitsLength = toRemove;
    }
  }
}

function $computeExponent(this$static, digits){
  var remainder, strip;
  strip = 0;
  while (strip < this$static.digitsLength - 1 && $charAt($toString_1(digits.data_0), strip) == 48) {
    ++strip;
  }
  if (strip > 0) {
    $replace(digits.data_0, 0, strip, '');
    this$static.digitsLength -= strip;
    this$static.exponent -= strip;
  }
  if (this$static.maximumIntegerDigits > this$static.minimumIntegerDigits && this$static.maximumIntegerDigits > 0) {
    this$static.exponent += this$static.decimalPosition - 1;
    remainder = this$static.exponent % this$static.maximumIntegerDigits;
    remainder < 0 && (remainder += this$static.maximumIntegerDigits);
    this$static.decimalPosition = remainder + 1;
    this$static.exponent -= remainder;
  }
   else {
    this$static.exponent += this$static.decimalPosition - this$static.minimumIntegerDigits;
    this$static.decimalPosition = this$static.minimumIntegerDigits;
  }
  if (this$static.digitsLength == 1 && $toString_1(digits.data_0).charCodeAt(0) == 48) {
    this$static.exponent = 0;
    this$static.decimalPosition = this$static.minimumIntegerDigits;
  }
}

function $format_0(this$static, number){
  var buf, isNegative, preRound, scale, useExponent, currentGroupingSize;
  if (isNaN(number)) {
    return 'NaN';
  }
  isNegative = number < 0 || number == 0 && 1 / number < 0;
  isNegative && (number = -number);
  buf = new StringBuilder_0;
  if (!isFinite(number)) {
    $append_12(buf, isNegative?this$static.negativePrefix:this$static.positivePrefix);
    $append_1(buf.data_0, '\u221E');
    $append_12(buf, isNegative?this$static.negativeSuffix:this$static.positiveSuffix);
    return $toString_1(buf.data_0);
  }
  number *= this$static.multiplier;
  scale = toScaledString(buf, number);
  preRound = $toString_1(buf.data_0).length + scale + this$static.maximumFractionDigits + 3;
  if (preRound > 0 && preRound < $toString_1(buf.data_0).length && $charAt($toString_1(buf.data_0), preRound) == 57) {
    $propagateCarry(this$static, buf, preRound - 1);
    scale += $toString_1(buf.data_0).length - preRound;
    $delete_0(buf, preRound, $toString_1(buf.data_0).length);
  }
  this$static.exponent = 0;
  this$static.digitsLength = $toString_1(buf.data_0).length;
  this$static.decimalPosition = this$static.digitsLength + scale;
  useExponent = this$static.useExponentialNotation;
  currentGroupingSize = this$static.groupingSize;
  this$static.decimalPosition > 1024 && (useExponent = true);
  useExponent && $computeExponent(this$static, buf);
  $processLeadingZeros(this$static, buf);
  $roundValue(this$static, buf);
  $insertGroupingSeparators(this$static, buf, 160, currentGroupingSize);
  $adjustFractionDigits(this$static, buf);
  $addZeroAndDecimal(this$static, buf, 44);
  useExponent && $addExponent(this$static, buf);
  $insert_0(buf, 0, isNegative?this$static.negativePrefix:this$static.positivePrefix);
  $append_12(buf, isNegative?this$static.negativeSuffix:this$static.positiveSuffix);
  return $toString_1(buf.data_0);
}

function $insertGroupingSeparators(this$static, digits, groupingSeparator, g){
  var i;
  if (g > 0) {
    for (i = g; i < this$static.decimalPosition; i += g + 1) {
      $insert_0(digits, this$static.decimalPosition - i, String.fromCharCode(groupingSeparator));
      ++this$static.decimalPosition;
      ++this$static.digitsLength;
    }
  }
}

function $parse(this$static, text){
  var pos, result;
  pos = initValues(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, [0]);
  result = $parse_0(this$static, text, pos);
  if (pos[0] == 0 || pos[0] != text.length) {
    throw new NumberFormatException_1(text);
  }
  return result;
}

function $parse_0(this$static, text, inOutPos){
  var gotNegative, gotNegativePrefix, gotNegativeSuffix, gotPositive, gotPositivePrefix, gotPositiveSuffix, ret, tempPos, valueOnly;
  gotPositivePrefix = $startsWith(text, this$static.positivePrefix, inOutPos[0]);
  gotNegativePrefix = $startsWith(text, this$static.negativePrefix, inOutPos[0]);
  gotPositiveSuffix = $endsWith(text, this$static.positiveSuffix);
  gotNegativeSuffix = $endsWith(text, this$static.negativeSuffix);
  gotPositive = gotPositivePrefix && gotPositiveSuffix;
  gotNegative = gotNegativePrefix && gotNegativeSuffix;
  if (gotPositive && gotNegative) {
    this$static.positivePrefix.length > this$static.negativePrefix.length?(gotNegative = false):this$static.positivePrefix.length < this$static.negativePrefix.length?(gotPositive = false):this$static.positiveSuffix.length > this$static.negativeSuffix.length?(gotNegative = false):this$static.positiveSuffix.length < this$static.negativeSuffix.length?(gotPositive = false):(gotNegative = false);
  }
   else if (!gotPositive && !gotNegative) {
    throw new NumberFormatException_1(text + ' does not have either positive or negative affixes');
  }
  if (gotPositive) {
    inOutPos[0] += this$static.positivePrefix.length;
    valueOnly = $substring_0(text, inOutPos[0], text.length - this$static.positiveSuffix.length);
  }
   else {
    inOutPos[0] += this$static.negativePrefix.length;
    valueOnly = $substring_0(text, inOutPos[0], text.length - this$static.negativeSuffix.length);
  }
  if ($equals_6(valueOnly, '\u221E')) {
    inOutPos[0] += 1;
    ret = Infinity;
  }
   else if ($equals_6(valueOnly, 'NaN')) {
    inOutPos[0] += 3;
    ret = NaN;
  }
   else {
    tempPos = initValues(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, [0]);
    ret = $parseNumber(this$static, valueOnly, tempPos);
    inOutPos[0] += tempPos[0];
  }
  gotPositive?(inOutPos[0] += this$static.positiveSuffix.length):gotNegative && (inOutPos[0] += this$static.negativeSuffix.length);
  gotNegative && (ret = -ret);
  return ret;
}

function $parseAffix(this$static, pattern, start, affix, inNegativePattern){
  var ch, inQuote, len, pos;
  $delete(affix, $toString_1(affix.data_0).length);
  inQuote = false;
  len = pattern.length;
  for (pos = start; pos < len; ++pos) {
    ch = pattern.charCodeAt(pos);
    if (ch == 39) {
      if (pos + 1 < len && pattern.charCodeAt(pos + 1) == 39) {
        ++pos;
        $append_1(affix.data_0, "'");
      }
       else {
        inQuote = !inQuote;
      }
      continue;
    }
    if (inQuote) {
      $appendNonNull(affix.data_0, String.fromCharCode(ch));
    }
     else {
      switch (ch) {
        case 35:
        case 48:
        case 44:
        case 46:
        case 59:
          return pos - start;
        case 164:
          this$static.isCurrencyFormat = true;
          if (pos + 1 < len && pattern.charCodeAt(pos + 1) == 164) {
            ++pos;
            if (pos < len - 3 && pattern.charCodeAt(pos + 1) == 164 && pattern.charCodeAt(pos + 2) == 164) {
              pos += 2;
              $append_5(affix, $getSimpleCurrencySymbol(this$static.currencyData));
            }
             else {
              $append_5(affix, this$static.currencyData[0]);
            }
          }
           else {
            $append_5(affix, this$static.currencyData[1]);
          }

          break;
        case 37:
          if (!inNegativePattern) {
            if (this$static.multiplier != 1) {
              throw new IllegalArgumentException_1('Too many percent/per mille characters in pattern "' + pattern + '"');
            }
            this$static.multiplier = 100;
          }

          $append_1(affix.data_0, '%');
          break;
        case 8240:
          if (!inNegativePattern) {
            if (this$static.multiplier != 1) {
              throw new IllegalArgumentException_1('Too many percent/per mille characters in pattern "' + pattern + '"');
            }
            this$static.multiplier = 1000;
          }

          $append_1(affix.data_0, '\u2030');
          break;
        case 45:
          $append_1(affix.data_0, '-');
          break;
        default:$appendNonNull(affix.data_0, String.fromCharCode(ch));
      }
    }
  }
  return len - start;
}

function $parseNumber(this$static, text, pos){
  var $e0, ch, decimal, digit, grouping, normalizedText, ret, sawDecimal, sawDigit, sawExponent, scale;
  sawDecimal = false;
  sawExponent = false;
  sawDigit = false;
  scale = 1;
  decimal = this$static.isCurrencyFormat?',':',';
  grouping = this$static.isCurrencyFormat?'\xA0':'\xA0';
  normalizedText = new StringBuffer_0;
  for (; pos[0] < text.length; ++pos[0]) {
    ch = text.charCodeAt(pos[0]);
    digit = 48 <= ch && ch <= 57?ch - 48:48 <= ch && ch <= 57?ch - 48:-1;
    if (digit >= 0 && digit <= 9) {
      $appendNonNull(normalizedText.data_0, String.fromCharCode(digit + 48 & 65535));
      sawDigit = true;
    }
     else if (ch == decimal.charCodeAt(0)) {
      if (sawDecimal || sawExponent) {
        break;
      }
      $appendNonNull(normalizedText.data_0, '.');
      sawDecimal = true;
    }
     else if (ch == grouping.charCodeAt(0)) {
      if (sawDecimal || sawExponent) {
        break;
      }
      continue;
    }
     else if (ch == 69) {
      if (sawExponent) {
        break;
      }
      $appendNonNull(normalizedText.data_0, 'E');
      sawExponent = true;
    }
     else if (ch == 43 || ch == 45) {
      $appendNonNull(normalizedText.data_0, String.fromCharCode(ch));
    }
     else if (ch == 37) {
      if (scale != 1) {
        break;
      }
      scale = 100;
      if (sawDigit) {
        ++pos[0];
        break;
      }
    }
     else if (ch == 8240) {
      if (scale != 1) {
        break;
      }
      scale = 1000;
      if (sawDigit) {
        ++pos[0];
        break;
      }
    }
     else {
      break;
    }
  }
  try {
    ret = __parseAndValidateDouble($toString_1(normalizedText.data_0));
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NumberFormatException)) {
      throw new NumberFormatException_1(text);
    }
     else 
      throw $e0;
  }
  ret = ret / scale;
  return ret;
}

function $parsePattern_0(this$static, pattern){
  var affix, pos;
  pos = 0;
  affix = new StringBuffer_0;
  pos += $parseAffix(this$static, pattern, 0, affix, false);
  this$static.positivePrefix = $toString_1(affix.data_0);
  pos += $parseTrunk(this$static, pattern, pos, false);
  pos += $parseAffix(this$static, pattern, pos, affix, false);
  this$static.positiveSuffix = $toString_1(affix.data_0);
  if (pos < pattern.length && pattern.charCodeAt(pos) == 59) {
    ++pos;
    pos += $parseAffix(this$static, pattern, pos, affix, true);
    this$static.negativePrefix = $toString_1(affix.data_0);
    pos += $parseTrunk(this$static, pattern, pos, true);
    pos += $parseAffix(this$static, pattern, pos, affix, true);
    this$static.negativeSuffix = $toString_1(affix.data_0);
  }
   else {
    this$static.negativePrefix = '-' + this$static.positivePrefix;
    this$static.negativeSuffix = this$static.positiveSuffix;
  }
}

function $parseTrunk(this$static, pattern, start, ignorePattern){
  var ch, decimalPos, digitLeftCount, digitRightCount, effectiveDecimalPos, groupingCount, len, loop, n, pos, totalDigits, zeroDigitCount;
  decimalPos = -1;
  digitLeftCount = 0;
  zeroDigitCount = 0;
  digitRightCount = 0;
  groupingCount = -1;
  len = pattern.length;
  pos = start;
  loop = true;
  for (; pos < len && loop; ++pos) {
    ch = pattern.charCodeAt(pos);
    switch (ch) {
      case 35:
        zeroDigitCount > 0?++digitRightCount:++digitLeftCount;
        groupingCount >= 0 && decimalPos < 0 && ++groupingCount;
        break;
      case 48:
        if (digitRightCount > 0) {
          throw new IllegalArgumentException_1("Unexpected '0' in pattern \"" + pattern + '"');
        }

        ++zeroDigitCount;
        groupingCount >= 0 && decimalPos < 0 && ++groupingCount;
        break;
      case 44:
        groupingCount = 0;
        break;
      case 46:
        if (decimalPos >= 0) {
          throw new IllegalArgumentException_1('Multiple decimal separators in pattern "' + pattern + '"');
        }

        decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
        break;
      case 69:
        if (!ignorePattern) {
          if (this$static.useExponentialNotation) {
            throw new IllegalArgumentException_1('Multiple exponential symbols in pattern "' + pattern + '"');
          }
          this$static.useExponentialNotation = true;
          this$static.minExponentDigits = 0;
        }

        while (pos + 1 < len && pattern.charCodeAt(pos + 1) == 48) {
          ++pos;
          ignorePattern || ++this$static.minExponentDigits;
        }

        if (!ignorePattern && digitLeftCount + zeroDigitCount < 1 || this$static.minExponentDigits < 1) {
          throw new IllegalArgumentException_1('Malformed exponential pattern "' + pattern + '"');
        }

        loop = false;
        break;
      default:--pos;
        loop = false;
    }
  }
  if (zeroDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
    n = decimalPos;
    decimalPos == 0 && ++n;
    digitRightCount = digitLeftCount - n;
    digitLeftCount = n - 1;
    zeroDigitCount = 1;
  }
  if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0) {
    throw new IllegalArgumentException_1('Malformed pattern "' + pattern + '"');
  }
  if (ignorePattern) {
    return pos - start;
  }
  totalDigits = digitLeftCount + zeroDigitCount + digitRightCount;
  this$static.maximumFractionDigits = decimalPos >= 0?totalDigits - decimalPos:0;
  if (decimalPos >= 0) {
    this$static.minimumFractionDigits = digitLeftCount + zeroDigitCount - decimalPos;
    this$static.minimumFractionDigits < 0 && (this$static.minimumFractionDigits = 0);
  }
  effectiveDecimalPos = decimalPos >= 0?decimalPos:totalDigits;
  this$static.minimumIntegerDigits = effectiveDecimalPos - digitLeftCount;
  if (this$static.useExponentialNotation) {
    this$static.maximumIntegerDigits = digitLeftCount + this$static.minimumIntegerDigits;
    this$static.maximumFractionDigits == 0 && this$static.minimumIntegerDigits == 0 && (this$static.minimumIntegerDigits = 1);
  }
  this$static.groupingSize = groupingCount > 0?groupingCount:0;
  this$static.decimalSeparatorAlwaysShown = decimalPos == 0 || decimalPos == totalDigits;
  return pos - start;
}

function $processLeadingZeros(this$static, digits){
  var i, prefix, strip;
  if (this$static.decimalPosition > this$static.digitsLength) {
    while (this$static.digitsLength < this$static.decimalPosition) {
      $appendNonNull(digits.data_0, '0');
      ++this$static.digitsLength;
    }
  }
  if (!this$static.useExponentialNotation) {
    if (this$static.decimalPosition < this$static.minimumIntegerDigits) {
      prefix = new StringBuilder_0;
      while (this$static.decimalPosition < this$static.minimumIntegerDigits) {
        $appendNonNull(prefix.data_0, '0');
        ++this$static.decimalPosition;
        ++this$static.digitsLength;
      }
      $insert_0(digits, 0, $toString_1(prefix.data_0));
    }
     else if (this$static.decimalPosition > this$static.minimumIntegerDigits) {
      strip = this$static.decimalPosition - this$static.minimumIntegerDigits;
      for (i = 0; i < strip; ++i) {
        if ($charAt($toString_1(digits.data_0), i) != 48) {
          strip = i;
          break;
        }
      }
      if (strip > 0) {
        $replace(digits.data_0, 0, strip, '');
        this$static.digitsLength -= strip;
        this$static.decimalPosition -= strip;
      }
    }
  }
}

function $propagateCarry(this$static, digits, i){
  var carry, digit;
  carry = true;
  while (carry && i >= 0) {
    digit = $charAt($toString_1(digits.data_0), i);
    if (digit == 57) {
      $setCharAt(digits, i--, 48);
    }
     else {
      $setCharAt(digits, i, digit + 1 & 65535);
      carry = false;
    }
  }
  if (carry) {
    $replace(digits.data_0, 0, 0, '1');
    ++this$static.decimalPosition;
    ++this$static.digitsLength;
  }
}

function $roundValue(this$static, digits){
  var i;
  if (this$static.digitsLength > this$static.decimalPosition + this$static.maximumFractionDigits && $charAt_0(digits, this$static.decimalPosition + this$static.maximumFractionDigits) >= 53) {
    i = this$static.decimalPosition + this$static.maximumFractionDigits - 1;
    $propagateCarry(this$static, digits, i);
  }
}

function NumberFormat_0(pattern, cdata, userSuppliedPattern){
  if (!cdata) {
    throw new IllegalArgumentException_1('Unknown currency code');
  }
  this.pattern = pattern;
  this.currencyData = cdata;
  $parsePattern_0(this, this.pattern);
  if (!userSuppliedPattern && this.isCurrencyFormat) {
    this.minimumFractionDigits = this.currencyData[2] & 7;
    this.maximumFractionDigits = this.minimumFractionDigits;
  }
}

function NumberFormat_1(pattern, cdata, userSuppliedPattern){
  $clinit_NumberFormat();
  NumberFormat_0.call(this, pattern, cdata, userSuppliedPattern);
}

function toScaledString(buf, val){
  var dot, expDigits, expIdx, scale, startLen;
  startLen = $toString_1(buf.data_0).length;
  $append_12(buf, val.toPrecision(20));
  scale = 0;
  expIdx = $indexOf_3($toString_1(buf.data_0), 'e', startLen);
  expIdx < 0 && (expIdx = $indexOf_3($toString_1(buf.data_0), 'E', startLen));
  if (expIdx >= 0) {
    expDigits = expIdx + 1;
    expDigits < $toString_1(buf.data_0).length && $charAt($toString_1(buf.data_0), expDigits) == 43 && ++expDigits;
    expDigits < $toString_1(buf.data_0).length && (scale = __parseAndValidateInt($substring($toString_1(buf.data_0), expDigits)));
    $delete_0(buf, expIdx, $toString_1(buf.data_0).length);
  }
  dot = $indexOf_3($toString_1(buf.data_0), '.', startLen);
  if (dot >= 0) {
    $replace(buf.data_0, dot, dot + 1, '');
    scale -= $toString_1(buf.data_0).length - dot;
  }
  return scale;
}

defineSeed(97, 1, {}, NumberFormat_1);
_.currencyData = null;
_.decimalPosition = 0;
_.decimalSeparatorAlwaysShown = false;
_.digitsLength = 0;
_.exponent = 0;
_.groupingSize = 3;
_.isCurrencyFormat = false;
_.maximumFractionDigits = 3;
_.maximumIntegerDigits = 40;
_.minExponentDigits = 0;
_.minimumFractionDigits = 0;
_.minimumIntegerDigits = 1;
_.multiplier = 1;
_.negativePrefix = '-';
_.negativeSuffix = '';
_.pattern = null;
_.positivePrefix = '';
_.positiveSuffix = '';
_.useExponentialNotation = false;
var cachedDecimalFormat = null;
function NumberConstantsImpl_cs_0(){
}

defineSeed(99, 1, {}, NumberConstantsImpl_cs_0);
function $getSimpleCurrencySymbol(this$static){
  return this$static[4] || this$static[1];
}

function $after(this$static, when){
  return gt(this$static.getTime_0(), when.getTime_0());
}

function $fixDaylightSavings(this$static, hours){
  var badHours, copy, day, newTime, timeDiff, timeDiffHours, timeDiffMinutes;
  if (this$static.jsdate.getHours() % 24 != hours % 24) {
    copy = create_0(this$static.jsdate.getTime());
    $setDate(copy, copy.getDate() + 1);
    timeDiff = this$static.jsdate.getTimezoneOffset() - copy.getTimezoneOffset();
    if (timeDiff > 0) {
      timeDiffHours = ~~(timeDiff / 60);
      timeDiffMinutes = timeDiff % 60;
      day = this$static.jsdate.getDate();
      badHours = this$static.jsdate.getHours();
      badHours + timeDiffHours >= 24 && ++day;
      newTime = create_1(this$static.jsdate.getFullYear(), this$static.jsdate.getMonth(), day, hours + timeDiffHours, this$static.jsdate.getMinutes() + timeDiffMinutes, this$static.jsdate.getSeconds(), this$static.jsdate.getMilliseconds());
      $setTime(this$static.jsdate, newTime.getTime());
    }
  }
}

function $setTime_0(this$static, time){
  $setTime(this$static.jsdate, toDouble(time));
}

defineSeed(106, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]));
_.setDate_0 = function setDate(date){
  var hours;
  hours = this.jsdate.getHours();
  $setDate(this.jsdate, date);
  $fixDaylightSavings(this, hours);
}
;
_.setHours_0 = function setHours(hours){
  $setHours(this.jsdate, hours);
  $fixDaylightSavings(this, hours);
}
;
_.setMinutes_0 = function setMinutes(minutes){
  var hours;
  hours = this.getHours_0() + ~~(minutes / 60);
  $setMinutes(this.jsdate, minutes);
  $fixDaylightSavings(this, hours);
}
;
_.setSeconds_0 = function setSeconds(seconds){
  var hours;
  hours = this.getHours_0() + ~~(seconds / 3600);
  $setSeconds(this.jsdate, seconds);
  $fixDaylightSavings(this, hours);
}
;
_.setTime_0 = function setTime(time){
  $setTime_0(this, time);
}
;
function DateRecord_0(){
  Date_1.call(this);
  this.era = -1;
  this.ambiguousYear = false;
  this.year = -2147483648;
  this.month = -1;
  this.dayOfMonth = -1;
  this.ampm = -1;
  this.hours = -1;
  this.minutes = -1;
  this.seconds = -1;
  this.milliseconds = -1;
  this.dayOfWeek = -1;
  this.tzOffset = -2147483648;
}

defineSeed(105, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), DateRecord_0);
_.setHours_0 = function setHours_0(hours){
  this.hours = hours;
}
;
_.setMinutes_0 = function setMinutes_0(minutes){
  this.minutes = minutes;
}
;
_.setSeconds_0 = function setSeconds_0(seconds){
  this.seconds = seconds;
}
;
_.ambiguousYear = false;
_.ampm = 0;
_.dayOfMonth = 0;
_.dayOfWeek = 0;
_.era = 0;
_.hours = 0;
_.milliseconds = 0;
_.minutes = 0;
_.month = 0;
_.seconds = 0;
_.tzOffset = 0;
_.year = 0;
function deserialize_1(streamReader, instance){
  setAmbiguousYear(instance, $readBoolean(streamReader));
  setAmpm(instance, $readInt(streamReader));
  setDayOfMonth(instance, $readInt(streamReader));
  setDayOfWeek(instance, $readInt(streamReader));
  setEra(instance, $readInt(streamReader));
  setHours_1(instance, $readInt(streamReader));
  setMilliseconds(instance, $readInt(streamReader));
  setMinutes_1(instance, $readInt(streamReader));
  setMonth(instance, $readInt(streamReader));
  setSeconds_1(instance, $readInt(streamReader));
  setTzOffset(instance, $readInt(streamReader));
  setYear(instance, $readInt(streamReader));
}

function instantiate_1(streamReader){
  return new DateRecord_0;
}

function serialize(streamWriter, instance){
  $writeBoolean(streamWriter, instance.ambiguousYear);
  $writeInt(streamWriter, instance.ampm);
  $writeInt(streamWriter, instance.dayOfMonth);
  $writeInt(streamWriter, instance.dayOfWeek);
  $writeInt(streamWriter, instance.era);
  $writeInt(streamWriter, instance.hours);
  $writeInt(streamWriter, instance.milliseconds);
  $writeInt(streamWriter, instance.minutes);
  $writeInt(streamWriter, instance.month);
  $writeInt(streamWriter, instance.seconds);
  $writeInt(streamWriter, instance.tzOffset);
  $writeInt(streamWriter, instance.year);
  $append_3(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function setAmbiguousYear(instance, value){
  instance.ambiguousYear = value;
}

function setAmpm(instance, value){
  instance.ampm = value;
}

function setDayOfMonth(instance, value){
  instance.dayOfMonth = value;
}

function setDayOfWeek(instance, value){
  instance.dayOfWeek = value;
}

function setEra(instance, value){
  instance.era = value;
}

function setHours_1(instance, value){
  instance.hours = value;
}

function setMilliseconds(instance, value){
  instance.milliseconds = value;
}

function setMinutes_1(instance, value){
  instance.minutes = value;
}

function setMonth(instance, value){
  instance.month = value;
}

function setSeconds_1(instance, value){
  instance.seconds = value;
}

function setTzOffset(instance, value){
  instance.tzOffset = value;
}

function setYear(instance, value){
  instance.year = value;
}

function appendChild(parent_0, child){
  $appendChild(parent_0, ($clinit_PotentialElement() , child.__gwt_resolve?child.__gwt_resolve():child));
}

function back_0(){
  $clinit_History();
  $wnd.history.back();
}

function $setEventListener(elem, listener){
  elem.__listener = listener;
}

function $sinkEvents(elem, bits){
  $maybeInitializeEventSystem();
  $sinkEventsImpl(elem, bits);
}

function $sinkEventsImpl(elem, bits){
  var chMask = (elem.__eventBits || 0) ^ bits;
  elem.__eventBits = bits;
  if (!chMask)
    return;
  chMask & 1 && (elem.onclick = bits & 1?dispatchEvent_1:null);
  chMask & 2 && (elem.ondblclick = bits & 2?dispatchEvent_1:null);
  chMask & 4 && (elem.onmousedown = bits & 4?dispatchEvent_1:null);
  chMask & 8 && (elem.onmouseup = bits & 8?dispatchEvent_1:null);
  chMask & 16 && (elem.onmouseover = bits & 16?dispatchEvent_1:null);
  chMask & 32 && (elem.onmouseout = bits & 32?dispatchEvent_1:null);
  chMask & 64 && (elem.onmousemove = bits & 64?dispatchEvent_1:null);
  chMask & 128 && (elem.onkeydown = bits & 128?dispatchEvent_1:null);
  chMask & 256 && (elem.onkeypress = bits & 256?dispatchEvent_1:null);
  chMask & 512 && (elem.onkeyup = bits & 512?dispatchEvent_1:null);
  chMask & 1024 && (elem.onchange = bits & 1024?dispatchEvent_1:null);
  chMask & 2048 && (elem.onfocus = bits & 2048?dispatchEvent_1:null);
  chMask & 4096 && (elem.onblur = bits & 4096?dispatchEvent_1:null);
  chMask & 8192 && (elem.onlosecapture = bits & 8192?dispatchEvent_1:null);
  chMask & 16384 && (elem.onscroll = bits & 16384?dispatchEvent_1:null);
  chMask & 32768 && (elem.onload = bits & 32768?dispatchUnhandledEvent:null);
  chMask & 65536 && (elem.onerror = bits & 65536?dispatchEvent_1:null);
  chMask & 131072 && (elem.onmousewheel = bits & 131072?dispatchEvent_1:null);
  chMask & 262144 && (elem.oncontextmenu = bits & 262144?dispatchEvent_1:null);
  chMask & 524288 && (elem.onpaste = bits & 524288?dispatchEvent_1:null);
  chMask & 1048576 && (elem.ontouchstart = bits & 1048576?dispatchEvent_1:null);
  chMask & 2097152 && (elem.ontouchmove = bits & 2097152?dispatchEvent_1:null);
  chMask & 4194304 && (elem.ontouchend = bits & 4194304?dispatchEvent_1:null);
  chMask & 8388608 && (elem.ontouchcancel = bits & 8388608?dispatchEvent_1:null);
  chMask & 16777216 && (elem.ongesturestart = bits & 16777216?dispatchEvent_1:null);
  chMask & 33554432 && (elem.ongesturechange = bits & 33554432?dispatchEvent_1:null);
  chMask & 67108864 && (elem.ongestureend = bits & 67108864?dispatchEvent_1:null);
}

function deserialize_35(streamReader, instance){
  var i, n;
  for (i = 0 , n = instance.length; i < n; ++i) {
    instance[i] = $getString(streamReader, $readInt(streamReader));
  }
}

function instantiate_34(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, size, 0);
}

function deserialize_44(streamReader, instance){
}

function instantiate_43(streamReader){
  return new Date_4($readLong(streamReader));
}

function serialize_15(streamWriter, instance){
  $append_3(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function deserialize_45(streamReader, instance){
}

function instantiate_44(streamReader){
  return new Time_0($readLong(streamReader));
}

function serialize_16(streamWriter, instance){
  $append_3(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
}

function deserialize_46(streamReader, instance){
  $setNanos(instance, $readInt(streamReader));
}

function instantiate_45(streamReader){
  return new Timestamp_0($readLong(streamReader));
}

function serialize_17(streamWriter, instance){
  $append_3(streamWriter, toBase64(fromDouble(instance.jsdate.getTime())));
  $writeInt(streamWriter, instance.nanos);
}

function deserialize_47(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_46(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_AbstractList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AbstractList, size, 0);
}

function deserialize_48(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_47(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_AbstractSequentialList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AbstractSequentialList, size, 0);
}

function deserialize_49(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_48(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_ArrayList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ArrayList, size, 0);
}

function deserialize_58(streamReader, instance){
}

function instantiate_56(streamReader){
  return new Date_2($readLong(streamReader));
}

function serialize_25(streamWriter, instance){
  $append_3(streamWriter, toBase64(instance.getTime_0()));
}

function deserialize_60(streamReader, instance){
  deserialize_69(streamReader, instance);
}

function instantiate_58(streamReader){
  var clazz, exemplar;
  exemplar = $readObject(streamReader);
  clazz = getClass__devirtual$(exemplar);
  return new EnumMap_0(clazz);
}

function deserialize_66(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_64(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_LinkedList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$LinkedList, size, 0);
}

function deserialize_68(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_66(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_List_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$List, size, 0);
}

function deserialize_71(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_68(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_Stack_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Stack, size, 0);
}

function deserialize_76(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_73(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Ljava_util_Vector_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Vector, size, 0);
}

function setStylePrimaryName(elem, style){
  if (!elem) {
    throw new RuntimeException_1('Null widget handle. If you are creating a composite, ensure that initWidget() has been called.');
  }
  style = $trim(style);
  if (style.length == 0) {
    throw new IllegalArgumentException_1('Style names cannot be empty');
  }
  updatePrimaryAndDependentStyleNames(elem, style);
}

function updatePrimaryAndDependentStyleNames(elem, newPrimaryStyle){
  var classes = elem.className.split(/\s+/);
  if (!classes) {
    return;
  }
  var oldPrimaryStyle = classes[0];
  var oldPrimaryStyleLen = oldPrimaryStyle.length;
  classes[0] = newPrimaryStyle;
  for (var i = 1, n = classes.length; i < n; i++) {
    var name_0 = classes[i];
    name_0.length > oldPrimaryStyleLen && name_0.charAt(oldPrimaryStyleLen) == '-' && name_0.indexOf(oldPrimaryStyle) == 0 && (classes[i] = newPrimaryStyle + name_0.substring(oldPrimaryStyleLen));
  }
  elem.className = classes.join(' ');
}

function $onAttach(this$static){
  var bitsToAdd;
  if (this$static.attached) {
    throw new IllegalStateException_1("Should only call onAttach when the widget is detached from the browser's document");
  }
  this$static.attached = true;
  $setEventListener(this$static.getElement(), this$static);
  bitsToAdd = this$static.eventsToSink;
  this$static.eventsToSink = -1;
  bitsToAdd > 0 && (this$static.eventsToSink == -1?$sinkEvents(this$static.getElement(), bitsToAdd | (this$static.getElement().__eventBits || 0)):(this$static.eventsToSink |= bitsToAdd));
  this$static.doAttachChildren();
}

function $onDetach(this$static){
  if (!this$static.attached) {
    throw new IllegalStateException_1("Should only call onDetach when the widget is attached to the browser's document");
  }
  try {
    this$static.doDetachChildren();
  }
   finally {
    this$static.getElement().__listener = null;
    this$static.attached = false;
  }
}

function $removeFromParent(this$static){
  if (!this$static.parent_0) {
    ($clinit_RootPanel() , $contains_2(widgetsToDetach, this$static)) && detachNow(this$static);
  }
   else if (this$static.parent_0) {
    $remove_1(this$static.parent_0, this$static);
  }
   else if (this$static.parent_0) {
    throw new IllegalStateException_1("This widget's parent does not implement HasWidgets");
  }
}

function $setParent_0(this$static, parent_0){
  var oldParent;
  oldParent = this$static.parent_0;
  if (!parent_0) {
    try {
      !!oldParent && oldParent.attached && $onDetach(this$static);
    }
     finally {
      this$static.parent_0 = null;
    }
  }
   else {
    if (oldParent) {
      throw new IllegalStateException_1('Cannot set a new parent without first clearing the old parent');
    }
    this$static.parent_0 = parent_0;
    parent_0.attached && this$static.onAttach();
  }
}

defineSeed(287, 288, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget]));
_.doAttachChildren = function doAttachChildren(){
}
;
_.doDetachChildren = function doDetachChildren(){
}
;
_.onAttach = function onAttach(){
  $onAttach(this);
}
;
defineSeed(286, 287, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.doAttachChildren = function doAttachChildren_0(){
  tryCommand(this, ($clinit_AttachDetachException() , attachCommand));
}
;
_.doDetachChildren = function doDetachChildren_0(){
  tryCommand(this, ($clinit_AttachDetachException() , detachCommand));
}
;
function $add_0(this$static, child, container){
  $removeFromParent(child);
  $add_4(this$static.children_0, child);
  appendChild(container, child.element);
  $setParent_0(child, this$static);
}

function $remove_0(this$static, w){
  var elem;
  if (w.parent_0 != this$static) {
    return false;
  }
  try {
    $setParent_0(w, null);
  }
   finally {
    elem = w.getElement();
    $removeChild($getParentElement(elem), elem);
    $remove_6(this$static.children_0, w);
  }
  return true;
}

defineSeed(285, 286, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.iterator = function iterator_1(){
  return new WidgetCollection$WidgetIterator_0(this.children_0);
}
;
_.remove = function remove_0(w){
  return $remove_0(this, w);
}
;
function $add_1(this$static, w){
  $add_0(this$static, w, this$static.element);
}

function $remove_1(this$static, w){
  var removed;
  removed = $remove_0(this$static, w);
  removed && changeToStaticPositioning(w.getElement());
  return removed;
}

function changeToStaticPositioning(elem){
  elem.style['left'] = '';
  elem.style['top'] = '';
  elem.style['position'] = '';
}

defineSeed(284, 285, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$Iterable]));
_.remove = function remove_1(w){
  return $remove_1(this, w);
}
;
function $clinit_AttachDetachException(){
  $clinit_AttachDetachException = nullMethod;
  attachCommand = new AttachDetachException$1_0;
  detachCommand = new AttachDetachException$2_0;
}

function AttachDetachException_0(causes){
  UmbrellaException_4.call(this, causes);
}

function tryCommand(hasWidgets, c){
  $clinit_AttachDetachException();
  var $e0, caught, e, w, w$iterator;
  caught = null;
  for (w$iterator = hasWidgets.iterator(); w$iterator.hasNext();) {
    w = dynamicCast(w$iterator.next_0(), Q$Widget);
    try {
      c.execute_0(w);
    }
     catch ($e0) {
      $e0 = caught_0($e0);
      if (instanceOf($e0, Q$Throwable)) {
        e = $e0;
        !caught && (caught = new HashSet_0);
        $add_6(caught, e);
      }
       else 
        throw $e0;
    }
  }
  if (caught) {
    throw new AttachDetachException_0(caught);
  }
}

defineSeed(289, 67, makeCastMap([Q$UmbrellaException, Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), AttachDetachException_0);
var attachCommand, detachCommand;
function AttachDetachException$1_0(){
}

defineSeed(290, 1, {}, AttachDetachException$1_0);
_.execute_0 = function execute_2(w){
  w.onAttach();
}
;
function AttachDetachException$2_0(){
}

defineSeed(291, 1, {}, AttachDetachException$2_0);
_.execute_0 = function execute_3(w){
  $onDetach(w);
}
;
function $removeAll(this$static, c){
  var changed, iter;
  iter = new AbstractList$IteratorImpl_0(this$static);
  changed = false;
  while (iter.i < iter.this$0_0.size_1()) {
    if ($indexOf_0(c, $next_0(iter), 0) != -1) {
      $remove_7(iter);
      changed = true;
    }
  }
  return changed;
}

defineSeed(295, 1, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection]));
_.remove_0 = function remove_2(o){
  return $remove_2(this, o);
}
;
defineSeed(294, 295, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List]));
_.set_0 = function set_0(index, o){
  throw new UnsupportedOperationException_1('Set not supported on this list');
}
;
_.subList = function subList(fromIndex, toIndex){
  return new AbstractList$SubList_0(this, fromIndex, toIndex);
}
;
function ArrayList_2(c){
  $$init(this);
  spliceArray(this.array, 0, 0, c.toArray());
  this.size_0 = this.array.length;
}

defineSeed(293, 294, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ArrayList_2);
_.remove_0 = function remove_5(o){
  return $remove_4(this, o);
}
;
_.set_0 = function set_1(index, o){
  return $set(this, index, o);
}
;
function ChangeListenerCollection_0(){
  $$init(this);
}

defineSeed(292, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ChangeListenerCollection_0);
function deserialize_83(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_80(streamReader){
  return new ChangeListenerCollection_0;
}

function ClickListenerCollection_0(){
  $$init(this);
}

defineSeed(297, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), ClickListenerCollection_0);
function deserialize_84(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_81(streamReader){
  return new ClickListenerCollection_0;
}

function FocusListenerCollection_0(){
  $$init(this);
}

defineSeed(300, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), FocusListenerCollection_0);
function deserialize_85(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_82(streamReader){
  return new FocusListenerCollection_0;
}

function $setHorizontalAlignment(this$static, align){
  this$static.autoHorizontalAlignment = align;
  $updateHorizontalAlignment(this$static);
}

function $setText(this$static, text){
  $setTextOrHtml(this$static.directionalTextHelper, text, false);
  $updateHorizontalAlignment(this$static);
}

function KeyboardListenerCollection_0(){
  $$init(this);
}

defineSeed(307, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess]), KeyboardListenerCollection_0);
function deserialize_86(streamReader, instance){
  deserialize_52(streamReader, instance);
}

function instantiate_83(streamReader){
  return new KeyboardListenerCollection_0;
}

function $clinit_PotentialElement(){
  $clinit_PotentialElement = nullMethod;
  declareShim();
}

function declareShim(){
  var shim = function(){
  }
  ;
  shim.prototype = {className:'', clientHeight:0, clientWidth:0, dir:'', getAttribute:function(name_0, value){
    return this[name_0];
  }
  , href:'', id:'', lang:'', nodeType:1, removeAttribute:function(name_0, value){
    this[name_0] = undefined;
  }
  , setAttribute:function(name_0, value){
    this[name_0] = value;
  }
  , src:'', style:{}, title:''};
  $wnd.GwtPotentialElementShim = shim;
}

function RootPanel_0(elem){
  this.children_0 = new WidgetCollection_0(this);
  this.element = elem;
  $onAttach(this);
}

function detachNow(widget){
  $clinit_RootPanel();
  try {
    $onDetach(widget);
  }
   finally {
    $remove_10(widgetsToDetach, widget);
  }
}

function detachWidgets(){
  $clinit_RootPanel();
  try {
    tryCommand(widgetsToDetach, maybeDetachCommand);
  }
   finally {
    widgetsToDetach.map_0.clear_0();
    rootPanels.clear_0();
  }
}

function get_1(id){
  $clinit_RootPanel();
  var elem, rp;
  rp = dynamicCast(rootPanels.get_2(id), Q$RootPanel);
  elem = null;
  if (id != null) {
    if (!(elem = $getElementById($doc, id))) {
      return null;
    }
  }
  if (rp) {
    if (!elem || rp.element == elem) {
      return rp;
    }
  }
  if (rootPanels.size_1() == 0) {
    addCloseHandler(new RootPanel$2_0);
    ($clinit_LocaleInfo() , false) && setDirectionOnElement($doc, ($clinit_HasDirection$Direction() , RTL));
  }
  !elem?(rp = new RootPanel$DefaultRootPanel_0):(rp = new RootPanel_0(elem));
  rootPanels.put(id, rp);
  $add_6(widgetsToDetach, rp);
  return rp;
}

defineSeed(310, 284, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$RootPanel, Q$UIObject, Q$Widget, Q$Iterable]), RootPanel_0);
defineSeed(311, 1, {});
_.execute_0 = function execute_4(w){
  w.attached && $onDetach(w);
}
;
function RootPanel$2_0(){
}

defineSeed(312, 1, makeCastMap([Q$CloseHandler, Q$EventHandler]), RootPanel$2_0);
_.onClose = function onClose_0(closeEvent){
  detachWidgets();
}
;
function RootPanel$DefaultRootPanel_0(){
  RootPanel_0.call(this, getBodyElement());
}

defineSeed(313, 310, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$RootPanel, Q$UIObject, Q$Widget, Q$Iterable]), RootPanel$DefaultRootPanel_0);
function $add_4(this$static, w){
  $insert(this$static, w, this$static.size_0);
}

function $indexOf_1(this$static, w){
  var i;
  for (i = 0; i < this$static.size_0; ++i) {
    if (this$static.array[i] == w) {
      return i;
    }
  }
  return -1;
}

function $insert(this$static, w, beforeIndex){
  var i, newArray;
  if (beforeIndex < 0 || beforeIndex > this$static.size_0) {
    throw new IndexOutOfBoundsException_0;
  }
  if (this$static.size_0 == this$static.array.length) {
    newArray = initDim(_3Lcom_google_gwt_user_client_ui_Widget_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Widget, this$static.array.length * 2, 0);
    for (i = 0; i < this$static.array.length; ++i) {
      setCheck(newArray, i, this$static.array[i]);
    }
    this$static.array = newArray;
  }
  ++this$static.size_0;
  for (i = this$static.size_0 - 1; i > beforeIndex; --i) {
    setCheck(this$static.array, i, this$static.array[i - 1]);
  }
  setCheck(this$static.array, beforeIndex, w);
}

function $remove_5(this$static, index){
  var i;
  if (index < 0 || index >= this$static.size_0) {
    throw new IndexOutOfBoundsException_0;
  }
  --this$static.size_0;
  for (i = index; i < this$static.size_0; ++i) {
    setCheck(this$static.array, i, this$static.array[i + 1]);
  }
  setCheck(this$static.array, this$static.size_0, null);
}

function $remove_6(this$static, w){
  var index;
  index = $indexOf_1(this$static, w);
  if (index == -1) {
    throw new NoSuchElementException_0;
  }
  $remove_5(this$static, index);
}

function WidgetCollection_0(parent_0){
  this.parent_0 = parent_0;
  this.array = initDim(_3Lcom_google_gwt_user_client_ui_Widget_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Widget, 4, 0);
}

defineSeed(314, 1, makeCastMap([Q$Iterable]), WidgetCollection_0);
_.iterator = function iterator_3(){
  return new WidgetCollection$WidgetIterator_0(this);
}
;
_.array = null;
_.parent_0 = null;
_.size_0 = 0;
function $next(this$static){
  if (this$static.index_0 >= this$static.this$0.size_0) {
    throw new NoSuchElementException_0;
  }
  return this$static.this$0.array[++this$static.index_0];
}

function WidgetCollection$WidgetIterator_0(this$0){
  this.this$0 = this$0;
}

defineSeed(315, 1, {}, WidgetCollection$WidgetIterator_0);
_.hasNext = function hasNext(){
  return this.index_0 < this.this$0.size_0 - 1;
}
;
_.next_0 = function next_0(){
  return $next(this);
}
;
_.remove_2 = function remove_6(){
  if (this.index_0 < 0 || this.index_0 >= this.this$0.size_0) {
    throw new IllegalStateException_0;
  }
  this.this$0.parent_0.remove(this.this$0.array[this.index_0--]);
}
;
_.index_0 = -1;
_.this$0 = null;
function $clinit_CalendarUtil(){
  $clinit_CalendarUtil = nullMethod;
  $getDateTimeFormatInfo(($clinit_LocaleInfo() , $clinit_LocaleInfo() , instance_0));
}

function addDaysToDate(date, days){
  $clinit_CalendarUtil();
  date.setDate_0(date.getDate_0() + days);
}

function copyDate(date){
  var newDate;
  if (!date) {
    return null;
  }
  newDate = new Date_1;
  newDate.setTime_0(date.getTime_0());
  return newDate;
}

function getDaysBetween(start, finish){
  $clinit_CalendarUtil();
  var aTime, adjust, bTime;
  start = copyDate(start);
  resetTime(start);
  finish = copyDate(finish);
  resetTime(finish);
  aTime = start.getTime_0();
  bTime = finish.getTime_0();
  adjust = P36ee80_longLit;
  adjust = gt(bTime, aTime)?adjust:neg(adjust);
  return toInt(div(add(sub(bTime, aTime), adjust), P5265c00_longLit));
}

function resetTime(date){
  var msec;
  msec = date.getTime_0();
  msec = mul(div(msec, P3e8_longLit), P3e8_longLit);
  date.setTime_0(msec);
  date.setHours_0(12);
  date.setMinutes_0(0);
  date.setSeconds_0(0);
}

function $removeHandler(this$static){
  $doRemove(this$static.this$0, this$static.val$type, this$static.val$source, this$static.val$handler);
}

function SimpleEventBus$3_0(this$0, val$type, val$source, val$handler){
  this.this$0 = this$0;
  this.val$type = val$type;
  this.val$source = val$source;
  this.val$handler = val$handler;
}

defineSeed(325, 1, makeCastMap([Q$SimpleEventBus$Command]), SimpleEventBus$3_0);
_.execute_1 = function execute_6(){
  $doRemoveNow(this.this$0, this.val$type, this.val$source, this.val$handler);
}
;
_.this$0 = null;
_.val$handler = null;
_.val$source = null;
_.val$type = null;
function $getAttributeAsJavaScriptObject(this$static, property){
  var ret;
  if (this$static.isCreated()) {
    var widget = this$static.getJsObj();
    ret = widget.getProperty(property);
  }
   else {
    var config = this$static.config;
    if (config[property] != undefined) {
      ret = config[property];
    }
     else {
      var scClassName = this$static.scClassName;
      ret = eval('($wnd.isc.' + scClassName + ".getInstanceProperty('" + property + "'))");
    }
  }
  return ret === undefined?null:ret;
}

function $setAttribute(this$static, value){
  var self_0;
  $isCreated(this$static)?$isCreated(this$static)?($getJsObj(this$static)['root'] = value , undefined):(self_0 = this$static.getJsObj() , self_0.setProperty('root', value) , undefined):(this$static.config['root'] = value , undefined);
}

function $setAttribute_0(this$static, attribute, value, allowPostCreate){
  $isCreated_0(this$static)?allowPostCreate?$setProperty(this$static, attribute, value.value_0):undefined:setAttribute_5(this$static.config, attribute, value);
}

function $setAttribute_1(this$static, attribute, value){
  $isCreated_0(this$static)?undefined:(this$static.config[attribute] = value , undefined);
}

function $setProperty(this$static, property, value){
  var self_0 = this$static.getJsObj();
  self_0.setProperty(property, value);
}

defineSeed(331, 1, makeCastMap([Q$JsObject]));
_.setJsObj = function setJsObj(jsObj){
  this.jsObj = jsObj;
}
;
function $getAttributeAsBoolean_0(this$static, property){
  return $clinit_Boolean() , getAttributeAsBoolean(this$static.jsObj, property)?TRUE:FALSE;
}

function $getAttributeAsDouble(this$static, property){
  return getAttributeAsDouble(this$static.jsObj, property);
}

function $getAttributeAsJavaScriptObject_0(this$static, property){
  return getAttributeAsJavaScriptObject(this$static.jsObj, property);
}

function $setAttribute_6(this$static, value){
  this$static.jsObj['optionDataSource'] = !value?null:$getOrCreateJsObj(value);
}

function $setAttribute_9(this$static, property, value){
  setAttribute_6(this$static.jsObj, property, value);
}

function $setAttribute_10(this$static, property, value){
  setAttribute_7(this$static.jsObj, property, value);
}

function $setAttribute_15(this$static, property, value){
  setAttribute_10(this$static.jsObj, property, value);
}

function $setAttribute_17(this$static, property, value){
  this$static.jsObj[property] = convertToJavaScriptArray(value);
}

function Criteria_0(){
  DataClass_0.call(this);
}

function Criteria_2(field, value){
  Criteria_0.call(this);
  this.jsObj[field] = value;
}

defineSeed(336, 330, makeCastMap([Q$DataClass, Q$JsObject]), Criteria_0, Criteria_2);
function $getCriteria(this$static){
  if (dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_9), getAttribute(this$static.jsObj, 'operationType')), Q$DSOperationType) == FETCH) {
    return !getAttributeAsJavaScriptObject(this$static.jsObj, 'data')?null:new Criteria_1(getAttributeAsJavaScriptObject(this$static.jsObj, 'data'));
  }
   else {
    throw new IllegalStateException_1('This method should only be called during FETCH operations');
  }
}

function $getSortBy(this$static){
  var self_0 = this$static.getJsObj();
  var sortBy = self_0.sortBy;
  if (sortBy == null || sortBy === undefined)
    return null;
  $wnd.isc.isA.Array(sortBy) && (sortBy = sortBy.join(','));
  return convertToArray(sortBy);
}

function $setAttribute_18(this$static, value){
  !value?(this$static.jsObj['parameters'] = null , undefined):(this$static.jsObj['parameters'] = value , undefined);
}

function $setEndRow(this$static, endRow){
  setAttribute_8(this$static.jsObj, 'endRow', endRow);
}

function $setStartRow(this$static, startRow){
  setAttribute_8(this$static.jsObj, 'startRow', startRow);
}

function DSRequest_0(){
  DataClass_0.call(this);
}

defineSeed(337, 338, makeCastMap([Q$DataClass, Q$JsObject]), DSRequest_0);
function $getData(this$static){
  var dataJS;
  dataJS = getAttributeAsJavaScriptObject(this$static.jsObj, 'data');
  return convertToRecordArray(dataJS);
}

function $getErrors(this$static){
  var jsObj, result;
  jsObj = getAttributeAsJavaScriptObject(this$static.jsObj, 'errors');
  isArray(jsObj) && (jsObj = (result = jsObj[0] , result == null || result === undefined?null:result));
  return convertToMap(jsObj);
}

function $setTotalRows(this$static, totalRows){
  setAttribute_8(this$static.jsObj, 'totalRows', totalRows);
}

function DSResponse_0(){
  DataClass_0.call(this);
}

defineSeed(339, 340, makeCastMap([Q$DataClass, Q$JsObject]), DSResponse_0);
function $fetchData(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $fetchData_0(this$static, criteria, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $getField(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getField(fieldName);
  if (ret == null || ret === undefined)
    return null;
  return new DataSourceField_0(ret);
}

function $getFieldNames(this$static, excludeHidden){
  var self_0 = this$static.getOrCreateJsObj();
  var value = self_0.getFieldNames(excludeHidden);
  if (value == null)
    return null;
  !isArray(value) && (value = [value]);
  return convertToJavaStringArray(value);
}

function $processResponse(this$static, requestId, responseProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var responsePropertiesJS = responseProperties == null?null:responseProperties.getJsObj();
  self_0.processResponse(requestId, responsePropertiesJS);
}

function $setCacheAllData(this$static, cacheAllData){
  $isCreated_0(this$static)?$setProperty(this$static, 'cacheAllData', cacheAllData.value_0):setAttribute_5(this$static.config, 'cacheAllData', cacheAllData);
}

function $setCanMultiSort(this$static, canMultiSort){
  $isCreated_0(this$static)?undefined:setAttribute_5(this$static.config, 'canMultiSort', canMultiSort);
}

function $setDropExtraFields(this$static, dropExtraFields){
  $isCreated_0(this$static)?undefined:setAttribute_5(this$static.config, 'dropExtraFields', dropExtraFields);
}

function DataSourceField_0(jsObj){
  this.jsObj = jsObj;
}

function DataSourceField_1(name_0, type){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
}

function DataSourceField_3(name_0, type, title, length_0){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
  this.jsObj['title'] = title;
  $setAttribute_11(this, 'length', valueOf_44(length_0));
}

function DataSourceField_4(name_0, type, title, length_0){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  $setAttribute_13(this, 'type', type.value_0);
  this.jsObj['title'] = title;
  $setAttribute_11(this, 'length', valueOf_44(length_0));
  $setAttribute_8(this, 'required', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

function getOrCreateRef_0(jsObj){
  if (!jsObj)
    return null;
  return new DataSourceField_0(jsObj);
}

defineSeed(342, 330, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceField_0);
function $getEndDate(this$static){
  if (this$static.endDate)
    return this$static.endDate;
  if (this$static.relativeEndDate)
    return getAbsoluteDate_0(this$static.relativeEndDate);
  return null;
}

function $getStartDate(this$static){
  if (this$static.startDate)
    return this$static.startDate;
  if (this$static.relativeStartDate)
    return getAbsoluteDate_0(this$static.relativeStartDate);
  return null;
}

function $isEmpty_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isEmpty();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

defineSeed(346, 330, makeCastMap([Q$DataClass, Q$JsObject, Q$RelativeDate]));
_.getValue_0 = function getValue(){
  return this.value_0;
}
;
function convertToArray(sortByString){
  var i, sortDirection, sortField, sortFields, sortSpecifiers;
  if (sortByString == null) {
    return initValues(_3Lcom_smartgwt_client_data_SortSpecifier_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SortSpecifier, []);
  }
  sortFields = $split(sortByString, ',', 0);
  sortSpecifiers = initDim(_3Lcom_smartgwt_client_data_SortSpecifier_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SortSpecifier, sortFields.length, 0);
  for (i = 0; i < sortFields.length; ++i) {
    sortField = sortFields[i];
    sortDirection = ($clinit_SortDirection() , ASCENDING);
    if (sortField.indexOf('-') == 0) {
      sortDirection = DESCENDING;
      sortField = $substring_0(sortField, 1, sortField.length);
    }
    sortSpecifiers[i] = new SortSpecifier_0(sortField, sortDirection);
  }
  return sortSpecifiers;
}

function DataSourceBooleanField_0(name_0){
  DataSourceField_1.call(this, name_0, ($clinit_FieldType() , BOOLEAN_0));
}

defineSeed(349, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceBooleanField_0);
function DataSourceDateTimeField_0(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , DATETIME), title);
}

defineSeed(350, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceDateTimeField_0);
function DataSourceImageField_0(){
  DataSourceField_1.call(this, 'category', ($clinit_FieldType() , IMAGE));
}

function DataSourceImageField_1(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , IMAGE), title);
}

function DataSourceImageField_2(name_0, title){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , IMAGE), title, 20);
}

defineSeed(351, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceImageField_0, DataSourceImageField_1, DataSourceImageField_2);
function DataSourceIntegerField_0(){
  DataSourceField_1.call(this, 'count', ($clinit_FieldType() , INTEGER));
}

function DataSourceIntegerField_1(name_0, title){
  DataSourceField_2.call(this, name_0, ($clinit_FieldType() , INTEGER), title);
}

function DataSourceIntegerField_2(name_0, title, length_0){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , INTEGER), title, length_0);
}

defineSeed(352, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceIntegerField_0, DataSourceIntegerField_1, DataSourceIntegerField_2);
function DataSourceLinkField_0(){
  DataSourceField_1.call(this, 'typeName', ($clinit_FieldType() , LINK));
}

function DataSourceLinkField_1(){
  DataSourceField_2.call(this, 'parent', ($clinit_FieldType() , LINK), 'Rodi\u010D');
}

defineSeed(353, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceLinkField_0, DataSourceLinkField_1);
function DataSourcePasswordField_0(name_0, title){
  DataSourceField_4.call(this, name_0, ($clinit_FieldType() , PASSWORD), title, 100);
}

defineSeed(354, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourcePasswordField_0);
function DataSourceTextField_0(name_0){
  DataSourceField_1.call(this, name_0, ($clinit_FieldType() , TEXT));
}

function DataSourceTextField_2(name_0, title, length_0){
  DataSourceField_3.call(this, name_0, ($clinit_FieldType() , TEXT), title, length_0);
}

function DataSourceTextField_3(name_0, title, length_0){
  DataSourceField_4.call(this, name_0, ($clinit_FieldType() , TEXT), title, length_0);
}

defineSeed(355, 342, makeCastMap([Q$DataClass, Q$JsObject, Q$DataSourceField]), DataSourceTextField_0, DataSourceTextField_2, DataSourceTextField_3);
function $clinit_AnimationEffect(){
  $clinit_AnimationEffect = nullMethod;
  SLIDE = new AnimationEffect_0('SLIDE', 0, 'slide');
  WIPE = new AnimationEffect_0('WIPE', 1, 'wipe');
  FADE = new AnimationEffect_0('FADE', 2, 'fade');
  FLY = new AnimationEffect_0('FLY', 3, 'fly');
  $VALUES_4 = initValues(_3Lcom_smartgwt_client_types_AnimationEffect_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AnimationEffect, [SLIDE, WIPE, FADE, FLY]);
}

function AnimationEffect_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_6(name_0){
  $clinit_AnimationEffect();
  return valueOf(($clinit_AnimationEffect$Map() , $MAP_4), name_0);
}

function values_5(){
  $clinit_AnimationEffect();
  return $VALUES_4;
}

defineSeed(360, 49, makeCastMap([Q$AnimationEffect, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), AnimationEffect_0);
_.getValue_0 = function getValue_1(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_4, FADE, FLY, SLIDE, WIPE;
function $clinit_AnimationEffect$Map(){
  $clinit_AnimationEffect$Map = nullMethod;
  $MAP_4 = createValueOfMap(($clinit_AnimationEffect() , $VALUES_4));
}

var $MAP_4;
function $clinit_AutoFitWidthApproach(){
  $clinit_AutoFitWidthApproach = nullMethod;
  VALUE = new AutoFitWidthApproach_0('VALUE', 0, 'value');
  TITLE = new AutoFitWidthApproach_0('TITLE', 1, 'title');
  BOTH = new AutoFitWidthApproach_0('BOTH', 2, 'both');
  $VALUES_5 = initValues(_3Lcom_smartgwt_client_types_AutoFitWidthApproach_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AutoFitWidthApproach, [VALUE, TITLE, BOTH]);
}

function AutoFitWidthApproach_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_7(name_0){
  $clinit_AutoFitWidthApproach();
  return valueOf(($clinit_AutoFitWidthApproach$Map() , $MAP_5), name_0);
}

function values_6(){
  $clinit_AutoFitWidthApproach();
  return $VALUES_5;
}

defineSeed(362, 49, makeCastMap([Q$AutoFitWidthApproach, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), AutoFitWidthApproach_0);
_.getValue_0 = function getValue_2(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_5, BOTH, TITLE, VALUE;
function $clinit_AutoFitWidthApproach$Map(){
  $clinit_AutoFitWidthApproach$Map = nullMethod;
  $MAP_5 = createValueOfMap(($clinit_AutoFitWidthApproach() , $VALUES_5));
}

var $MAP_5;
function $clinit_Autofit(){
  $clinit_Autofit = nullMethod;
  VERTICAL = new Autofit_0('VERTICAL', 0, 'vertical');
  HORIZONTAL = new Autofit_0('HORIZONTAL', 1, 'horizontal');
  BOTH_0 = new Autofit_0('BOTH', 2, 'both');
  $VALUES_6 = initValues(_3Lcom_smartgwt_client_types_Autofit_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Autofit, [VERTICAL, HORIZONTAL, BOTH_0]);
}

function Autofit_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_8(name_0){
  $clinit_Autofit();
  return valueOf(($clinit_Autofit$Map() , $MAP_6), name_0);
}

function values_7(){
  $clinit_Autofit();
  return $VALUES_6;
}

defineSeed(364, 49, makeCastMap([Q$Autofit, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Autofit_0);
_.getValue_0 = function getValue_3(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_6, BOTH_0, HORIZONTAL, VERTICAL;
function $clinit_Autofit$Map(){
  $clinit_Autofit$Map = nullMethod;
  $MAP_6 = createValueOfMap(($clinit_Autofit() , $VALUES_6));
}

var $MAP_6;
function $clinit_ContentsType(){
  $clinit_ContentsType = nullMethod;
  PAGE = new ContentsType_0('PAGE', 0, 'page');
  FRAGMENT = new ContentsType_0('FRAGMENT', 1, 'fragment');
  $VALUES_7 = initValues(_3Lcom_smartgwt_client_types_ContentsType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ContentsType, [PAGE, FRAGMENT]);
}

function ContentsType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_9(name_0){
  $clinit_ContentsType();
  return valueOf(($clinit_ContentsType$Map() , $MAP_7), name_0);
}

function values_8(){
  $clinit_ContentsType();
  return $VALUES_7;
}

defineSeed(366, 49, makeCastMap([Q$ContentsType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ContentsType_0);
_.getValue_0 = function getValue_4(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_7, FRAGMENT, PAGE;
function $clinit_ContentsType$Map(){
  $clinit_ContentsType$Map = nullMethod;
  $MAP_7 = createValueOfMap(($clinit_ContentsType() , $VALUES_7));
}

var $MAP_7;
function $clinit_DSDataFormat(){
  $clinit_DSDataFormat = nullMethod;
  ISCSERVER = new DSDataFormat_0('ISCSERVER', 0, 'iscServer');
  XML = new DSDataFormat_0('XML', 1, 'xml');
  JSON = new DSDataFormat_0('JSON', 2, 'json');
  CUSTOM = new DSDataFormat_0('CUSTOM', 3, 'custom');
  $VALUES_8 = initValues(_3Lcom_smartgwt_client_types_DSDataFormat_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSDataFormat, [ISCSERVER, XML, JSON, CUSTOM]);
}

function DSDataFormat_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_10(name_0){
  $clinit_DSDataFormat();
  return valueOf(($clinit_DSDataFormat$Map() , $MAP_8), name_0);
}

function values_9(){
  $clinit_DSDataFormat();
  return $VALUES_8;
}

defineSeed(368, 49, makeCastMap([Q$DSDataFormat, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSDataFormat_0);
_.getValue_0 = function getValue_5(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_8, CUSTOM, ISCSERVER, JSON, XML;
function $clinit_DSDataFormat$Map(){
  $clinit_DSDataFormat$Map = nullMethod;
  $MAP_8 = createValueOfMap(($clinit_DSDataFormat() , $VALUES_8));
}

var $MAP_8;
function $clinit_DSOperationType(){
  $clinit_DSOperationType = nullMethod;
  FETCH = new DSOperationType_0('FETCH', 0, 'fetch');
  ADD = new DSOperationType_0('ADD', 1, 'add');
  UPDATE = new DSOperationType_0('UPDATE', 2, 'update');
  REMOVE = new DSOperationType_0('REMOVE', 3, 'remove');
  VALIDATE = new DSOperationType_0('VALIDATE', 4, 'validate');
  CUSTOM_0 = new DSOperationType_0('CUSTOM', 5, 'custom');
  $VALUES_9 = initValues(_3Lcom_smartgwt_client_types_DSOperationType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSOperationType, [FETCH, ADD, UPDATE, REMOVE, VALIDATE, CUSTOM_0]);
}

function DSOperationType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_11(name_0){
  $clinit_DSOperationType();
  return valueOf(($clinit_DSOperationType$Map() , $MAP_9), name_0);
}

function values_10(){
  $clinit_DSOperationType();
  return $VALUES_9;
}

defineSeed(370, 49, makeCastMap([Q$DSOperationType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSOperationType_0);
_.getValue_0 = function getValue_6(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_9, ADD, CUSTOM_0, FETCH, REMOVE, UPDATE, VALIDATE;
function $clinit_DSOperationType$Map(){
  $clinit_DSOperationType$Map = nullMethod;
  $MAP_9 = createValueOfMap(($clinit_DSOperationType() , $VALUES_9));
}

var $MAP_9;
function $clinit_DSProtocol(){
  $clinit_DSProtocol = nullMethod;
  GETPARAMS = new DSProtocol_0('GETPARAMS', 0, 'getParams');
  POSTPARAMS = new DSProtocol_0('POSTPARAMS', 1, 'postParams');
  POSTXML = new DSProtocol_0('POSTXML', 2, 'postXML');
  SOAP = new DSProtocol_0('SOAP', 3, 'soap');
  POSTMESSAGE = new DSProtocol_0('POSTMESSAGE', 4, 'postMessage');
  CLIENTCUSTOM = new DSProtocol_0('CLIENTCUSTOM', 5, 'clientCustom');
  $VALUES_10 = initValues(_3Lcom_smartgwt_client_types_DSProtocol_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DSProtocol, [GETPARAMS, POSTPARAMS, POSTXML, SOAP, POSTMESSAGE, CLIENTCUSTOM]);
}

function DSProtocol_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_12(name_0){
  $clinit_DSProtocol();
  return valueOf(($clinit_DSProtocol$Map() , $MAP_10), name_0);
}

function values_11(){
  $clinit_DSProtocol();
  return $VALUES_10;
}

defineSeed(372, 49, makeCastMap([Q$DSProtocol, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DSProtocol_0);
_.getValue_0 = function getValue_7(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_10, CLIENTCUSTOM, GETPARAMS, POSTMESSAGE, POSTPARAMS, POSTXML, SOAP;
function $clinit_DSProtocol$Map(){
  $clinit_DSProtocol$Map = nullMethod;
  $MAP_10 = createValueOfMap(($clinit_DSProtocol() , $VALUES_10));
}

var $MAP_10;
function $clinit_DateDisplayFormat(){
  $clinit_DateDisplayFormat = nullMethod;
  TOSTRING = new DateDisplayFormat_0('TOSTRING', 0, 'toString');
  TOLOCALESTRING = new DateDisplayFormat_0('TOLOCALESTRING', 1, 'toLocaleString');
  TOUSSHORTDATE = new DateDisplayFormat_0('TOUSSHORTDATE', 2, 'toUSShortDate');
  TOUSSHORTDATETIME = new DateDisplayFormat_0('TOUSSHORTDATETIME', 3, 'toUSShortDatetime');
  TOEUROPEANSHORTDATE = new DateDisplayFormat_0('TOEUROPEANSHORTDATE', 4, 'toEuropeanShortDate');
  TOEUROPEANSHORTDATETIME = new DateDisplayFormat_0('TOEUROPEANSHORTDATETIME', 5, 'toEuropeanShortDatetime');
  TOJAPANSHORTDATE = new DateDisplayFormat_0('TOJAPANSHORTDATE', 6, 'toJapanShortDate');
  TOJAPANSHORTDATETIME = new DateDisplayFormat_0('TOJAPANSHORTDATETIME', 7, 'toJapanShortDatetime');
  TOSERIALIZEABLEDATE = new DateDisplayFormat_0('TOSERIALIZEABLEDATE', 8, 'toSerializeableDate');
  TODATESTAMP = new DateDisplayFormat_0('TODATESTAMP', 9, 'toDateStamp');
  $VALUES_11 = initValues(_3Lcom_smartgwt_client_types_DateDisplayFormat_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DateDisplayFormat, [TOSTRING, TOLOCALESTRING, TOUSSHORTDATE, TOUSSHORTDATETIME, TOEUROPEANSHORTDATE, TOEUROPEANSHORTDATETIME, TOJAPANSHORTDATE, TOJAPANSHORTDATETIME, TOSERIALIZEABLEDATE, TODATESTAMP]);
}

function DateDisplayFormat_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_13(name_0){
  $clinit_DateDisplayFormat();
  return valueOf(($clinit_DateDisplayFormat$Map() , $MAP_11), name_0);
}

function values_12(){
  $clinit_DateDisplayFormat();
  return $VALUES_11;
}

defineSeed(374, 49, makeCastMap([Q$DateDisplayFormat, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DateDisplayFormat_0);
_.getValue_0 = function getValue_8(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_11, TODATESTAMP, TOEUROPEANSHORTDATE, TOEUROPEANSHORTDATETIME, TOJAPANSHORTDATE, TOJAPANSHORTDATETIME, TOLOCALESTRING, TOSERIALIZEABLEDATE, TOSTRING, TOUSSHORTDATE, TOUSSHORTDATETIME;
function $clinit_DateDisplayFormat$Map(){
  $clinit_DateDisplayFormat$Map = nullMethod;
  $MAP_11 = createValueOfMap(($clinit_DateDisplayFormat() , $VALUES_11));
}

var $MAP_11;
function $clinit_DragAppearance(){
  $clinit_DragAppearance = nullMethod;
  NONE = new DragAppearance_0('NONE', 0, 'none');
  TRACKER = new DragAppearance_0('TRACKER', 1, 'tracker');
  TARGET = new DragAppearance_0('TARGET', 2, 'target');
  OUTLINE = new DragAppearance_0('OUTLINE', 3, 'outline');
  $VALUES_12 = initValues(_3Lcom_smartgwt_client_types_DragAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragAppearance, [NONE, TRACKER, TARGET, OUTLINE]);
}

function DragAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_14(name_0){
  $clinit_DragAppearance();
  return valueOf(($clinit_DragAppearance$Map() , $MAP_12), name_0);
}

function values_13(){
  $clinit_DragAppearance();
  return $VALUES_12;
}

defineSeed(376, 49, makeCastMap([Q$DragAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragAppearance_0);
_.getValue_0 = function getValue_9(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_12, NONE, OUTLINE, TARGET, TRACKER;
function $clinit_DragAppearance$Map(){
  $clinit_DragAppearance$Map = nullMethod;
  $MAP_12 = createValueOfMap(($clinit_DragAppearance() , $VALUES_12));
}

var $MAP_12;
function $clinit_DragDataAction(){
  $clinit_DragDataAction = nullMethod;
  NONE_0 = new DragDataAction_0('NONE', 0, 'none');
  COPY = new DragDataAction_0('COPY', 1, 'copy');
  MOVE = new DragDataAction_0('MOVE', 2, 'move');
  $VALUES_13 = initValues(_3Lcom_smartgwt_client_types_DragDataAction_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragDataAction, [NONE_0, COPY, MOVE]);
}

function DragDataAction_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_15(name_0){
  $clinit_DragDataAction();
  return valueOf(($clinit_DragDataAction$Map() , $MAP_13), name_0);
}

function values_14(){
  $clinit_DragDataAction();
  return $VALUES_13;
}

defineSeed(378, 49, makeCastMap([Q$DragDataAction, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragDataAction_0);
_.getValue_0 = function getValue_10(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_13, COPY, MOVE, NONE_0;
function $clinit_DragDataAction$Map(){
  $clinit_DragDataAction$Map = nullMethod;
  $MAP_13 = createValueOfMap(($clinit_DragDataAction() , $VALUES_13));
}

var $MAP_13;
function $clinit_DragTrackerMode(){
  $clinit_DragTrackerMode = nullMethod;
  NONE_1 = new DragTrackerMode_0('NONE', 0, 'none');
  ICON = new DragTrackerMode_0('ICON', 1, 'icon');
  TITLE_0 = new DragTrackerMode_0('TITLE', 2, 'title');
  RECORD = new DragTrackerMode_0('RECORD', 3, 'record');
  $VALUES_14 = initValues(_3Lcom_smartgwt_client_types_DragTrackerMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DragTrackerMode, [NONE_1, ICON, TITLE_0, RECORD]);
}

function DragTrackerMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_16(name_0){
  $clinit_DragTrackerMode();
  return valueOf(($clinit_DragTrackerMode$Map() , $MAP_14), name_0);
}

function values_15(){
  $clinit_DragTrackerMode();
  return $VALUES_14;
}

defineSeed(380, 49, makeCastMap([Q$DragTrackerMode, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), DragTrackerMode_0);
_.getValue_0 = function getValue_11(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_14, ICON, NONE_1, RECORD, TITLE_0;
function $clinit_DragTrackerMode$Map(){
  $clinit_DragTrackerMode$Map = nullMethod;
  $MAP_14 = createValueOfMap(($clinit_DragTrackerMode() , $VALUES_14));
}

var $MAP_14;
function $clinit_EmbeddedPosition(){
  $clinit_EmbeddedPosition = nullMethod;
  EXPAND = new EmbeddedPosition_0('EXPAND', 0, 'expand');
  WITHIN = new EmbeddedPosition_0('WITHIN', 1, 'within');
  $VALUES_15 = initValues(_3Lcom_smartgwt_client_types_EmbeddedPosition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$EmbeddedPosition, [EXPAND, WITHIN]);
}

function EmbeddedPosition_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_17(name_0){
  $clinit_EmbeddedPosition();
  return valueOf(($clinit_EmbeddedPosition$Map() , $MAP_15), name_0);
}

function values_16(){
  $clinit_EmbeddedPosition();
  return $VALUES_15;
}

defineSeed(382, 49, makeCastMap([Q$EmbeddedPosition, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), EmbeddedPosition_0);
_.getValue_0 = function getValue_12(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_15, EXPAND, WITHIN;
function $clinit_EmbeddedPosition$Map(){
  $clinit_EmbeddedPosition$Map = nullMethod;
  $MAP_15 = createValueOfMap(($clinit_EmbeddedPosition() , $VALUES_15));
}

var $MAP_15;
function $clinit_Encoding(){
  $clinit_Encoding = nullMethod;
  NORMAL = new Encoding_0('NORMAL', 0, 'normal');
  MULTIPART = new Encoding_0('MULTIPART', 1, 'multipart');
  $VALUES_16 = initValues(_3Lcom_smartgwt_client_types_Encoding_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Encoding, [NORMAL, MULTIPART]);
}

function Encoding_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_18(name_0){
  $clinit_Encoding();
  return valueOf(($clinit_Encoding$Map() , $MAP_16), name_0);
}

function values_17(){
  $clinit_Encoding();
  return $VALUES_16;
}

defineSeed(384, 49, makeCastMap([Q$Encoding, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Encoding_0);
_.getValue_0 = function getValue_13(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_16, MULTIPART, NORMAL;
function $clinit_Encoding$Map(){
  $clinit_Encoding$Map = nullMethod;
  $MAP_16 = createValueOfMap(($clinit_Encoding() , $VALUES_16));
}

var $MAP_16;
function $clinit_ExpansionMode(){
  $clinit_ExpansionMode = nullMethod;
  DETAIL_FIELD = new ExpansionMode_0('DETAIL_FIELD', 0, 'detailField');
  DETAILS = new ExpansionMode_0('DETAILS', 1, 'details');
  RELATED = new ExpansionMode_0('RELATED', 2, 'related');
  EDITOR = new ExpansionMode_0('EDITOR', 3, 'editor');
  DETAIL_RELATED = new ExpansionMode_0('DETAIL_RELATED', 4, 'detailRelated');
  $VALUES_17 = initValues(_3Lcom_smartgwt_client_types_ExpansionMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ExpansionMode, [DETAIL_FIELD, DETAILS, RELATED, EDITOR, DETAIL_RELATED]);
}

function ExpansionMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_19(name_0){
  $clinit_ExpansionMode();
  return valueOf(($clinit_ExpansionMode$Map() , $MAP_17), name_0);
}

function values_18(){
  $clinit_ExpansionMode();
  return $VALUES_17;
}

defineSeed(386, 49, makeCastMap([Q$ExpansionMode, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ExpansionMode_0);
_.getValue_0 = function getValue_14(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_17, DETAILS, DETAIL_FIELD, DETAIL_RELATED, EDITOR, RELATED;
function $clinit_ExpansionMode$Map(){
  $clinit_ExpansionMode$Map = nullMethod;
  $MAP_17 = createValueOfMap(($clinit_ExpansionMode() , $VALUES_17));
}

var $MAP_17;
function $clinit_HeaderControls(){
  $clinit_HeaderControls = nullMethod;
  HEADER_ICON = new HeaderControls_0('HEADER_ICON', 0, 'headerIcon');
  HEADER_LABEL = new HeaderControls_0('HEADER_LABEL', 1, 'headerLabel');
  MINIMIZE_BUTTON = new HeaderControls_0('MINIMIZE_BUTTON', 2, 'minimizeButton');
  MAXIMIZE_BUTTON = new HeaderControls_0('MAXIMIZE_BUTTON', 3, 'maximizeButton');
  CLOSE_BUTTON = new HeaderControls_0('CLOSE_BUTTON', 4, 'closeButton');
  $VALUES_20 = initValues(_3Lcom_smartgwt_client_types_HeaderControls_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$HeaderControls, [HEADER_ICON, HEADER_LABEL, MINIMIZE_BUTTON, MAXIMIZE_BUTTON, CLOSE_BUTTON]);
}

function HeaderControls_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_22(name_0){
  $clinit_HeaderControls();
  return valueOf(($clinit_HeaderControls$Map() , $MAP_20), name_0);
}

function values_21(){
  $clinit_HeaderControls();
  return $VALUES_20;
}

defineSeed(392, 49, makeCastMap([Q$HeaderControls, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), HeaderControls_0);
_.getValue_0 = function getValue_17(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_20, CLOSE_BUTTON, HEADER_ICON, HEADER_LABEL, MAXIMIZE_BUTTON, MINIMIZE_BUTTON;
function $clinit_HeaderControls$Map(){
  $clinit_HeaderControls$Map = nullMethod;
  $MAP_20 = createValueOfMap(($clinit_HeaderControls() , $VALUES_20));
}

var $MAP_20;
function $clinit_ImageStyle(){
  $clinit_ImageStyle = nullMethod;
  CENTER_1 = new ImageStyle_0('CENTER', 0, 'center');
  TILE = new ImageStyle_0('TILE', 1, 'tile');
  STRETCH = new ImageStyle_0('STRETCH', 2, 'stretch');
  NORMAL_0 = new ImageStyle_0('NORMAL', 3, 'normal');
  $VALUES_21 = initValues(_3Lcom_smartgwt_client_types_ImageStyle_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ImageStyle, [CENTER_1, TILE, STRETCH, NORMAL_0]);
}

function ImageStyle_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_23(name_0){
  $clinit_ImageStyle();
  return valueOf(($clinit_ImageStyle$Map() , $MAP_21), name_0);
}

function values_22(){
  $clinit_ImageStyle();
  return $VALUES_21;
}

defineSeed(394, 49, makeCastMap([Q$ImageStyle, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ImageStyle_0);
_.getValue_0 = function getValue_18(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_21, CENTER_1, NORMAL_0, STRETCH, TILE;
function $clinit_ImageStyle$Map(){
  $clinit_ImageStyle$Map = nullMethod;
  $MAP_21 = createValueOfMap(($clinit_ImageStyle() , $VALUES_21));
}

var $MAP_21;
function $clinit_LayoutPolicy(){
  $clinit_LayoutPolicy = nullMethod;
  NONE_2 = new LayoutPolicy_0('NONE', 0, 'none');
  FILL = new LayoutPolicy_0('FILL', 1, 'fill');
  $VALUES_22 = initValues(_3Lcom_smartgwt_client_types_LayoutPolicy_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$LayoutPolicy, [NONE_2, FILL]);
}

function LayoutPolicy_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_24(name_0){
  $clinit_LayoutPolicy();
  return valueOf(($clinit_LayoutPolicy$Map() , $MAP_22), name_0);
}

function values_23(){
  $clinit_LayoutPolicy();
  return $VALUES_22;
}

defineSeed(396, 49, makeCastMap([Q$LayoutPolicy, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), LayoutPolicy_0);
_.getValue_0 = function getValue_19(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_22, FILL, NONE_2;
function $clinit_LayoutPolicy$Map(){
  $clinit_LayoutPolicy$Map = nullMethod;
  $MAP_22 = createValueOfMap(($clinit_LayoutPolicy() , $VALUES_22));
}

var $MAP_22;
function $clinit_ListGridEditEvent(){
  $clinit_ListGridEditEvent = nullMethod;
  CLICK = new ListGridEditEvent_0('CLICK', 0, 'click');
  DOUBLECLICK = new ListGridEditEvent_0('DOUBLECLICK', 1, 'doubleClick');
  NONE_3 = new ListGridEditEvent_0('NONE', 2, 'none');
  $VALUES_23 = initValues(_3Lcom_smartgwt_client_types_ListGridEditEvent_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ListGridEditEvent, [CLICK, DOUBLECLICK, NONE_3]);
}

function ListGridEditEvent_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_25(name_0){
  $clinit_ListGridEditEvent();
  return valueOf(($clinit_ListGridEditEvent$Map() , $MAP_23), name_0);
}

function values_24(){
  $clinit_ListGridEditEvent();
  return $VALUES_23;
}

defineSeed(398, 49, makeCastMap([Q$ListGridEditEvent, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), ListGridEditEvent_0);
_.getValue_0 = function getValue_20(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_23, CLICK, DOUBLECLICK, NONE_3;
function $clinit_ListGridEditEvent$Map(){
  $clinit_ListGridEditEvent$Map = nullMethod;
  $MAP_23 = createValueOfMap(($clinit_ListGridEditEvent() , $VALUES_23));
}

var $MAP_23;
function $clinit_MultipleAppearance(){
  $clinit_MultipleAppearance = nullMethod;
  PICKLIST = new MultipleAppearance_0('PICKLIST', 0, 'picklist');
  GRID = new MultipleAppearance_0('GRID', 1, 'grid');
  $VALUES_25 = initValues(_3Lcom_smartgwt_client_types_MultipleAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$MultipleAppearance, [PICKLIST, GRID]);
}

function MultipleAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_27(name_0){
  $clinit_MultipleAppearance();
  return valueOf(($clinit_MultipleAppearance$Map() , $MAP_25), name_0);
}

function values_26(){
  $clinit_MultipleAppearance();
  return $VALUES_25;
}

defineSeed(402, 49, makeCastMap([Q$MultipleAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), MultipleAppearance_0);
_.getValue_0 = function getValue_22(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_25, GRID, PICKLIST;
function $clinit_MultipleAppearance$Map(){
  $clinit_MultipleAppearance$Map = nullMethod;
  $MAP_25 = createValueOfMap(($clinit_MultipleAppearance() , $VALUES_25));
}

var $MAP_25;
function $clinit_RelativeDateRangePosition(){
  $clinit_RelativeDateRangePosition = nullMethod;
  START = new RelativeDateRangePosition_0('START', 0, 'start');
  END = new RelativeDateRangePosition_0('END', 1, 'end');
  $VALUES_28 = initValues(_3Lcom_smartgwt_client_types_RelativeDateRangePosition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$RelativeDateRangePosition, [START, END]);
}

function RelativeDateRangePosition_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_30(name_0){
  $clinit_RelativeDateRangePosition();
  return valueOf(($clinit_RelativeDateRangePosition$Map() , $MAP_28), name_0);
}

function values_29(){
  $clinit_RelativeDateRangePosition();
  return $VALUES_28;
}

defineSeed(408, 49, makeCastMap([Q$RelativeDateRangePosition, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), RelativeDateRangePosition_0);
_.getValue_0 = function getValue_25(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_28, END, START;
function $clinit_RelativeDateRangePosition$Map(){
  $clinit_RelativeDateRangePosition$Map = nullMethod;
  $MAP_28 = createValueOfMap(($clinit_RelativeDateRangePosition() , $VALUES_28));
}

var $MAP_28;
function $clinit_SelectionAppearance(){
  $clinit_SelectionAppearance = nullMethod;
  ROW_STYLE = new SelectionAppearance_0('ROW_STYLE', 0, 'rowStyle');
  CHECKBOX = new SelectionAppearance_0('CHECKBOX', 1, 'checkbox');
  $VALUES_29 = initValues(_3Lcom_smartgwt_client_types_SelectionAppearance_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$SelectionAppearance, [ROW_STYLE, CHECKBOX]);
}

function SelectionAppearance_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_31(name_0){
  $clinit_SelectionAppearance();
  return valueOf(($clinit_SelectionAppearance$Map() , $MAP_29), name_0);
}

function values_30(){
  $clinit_SelectionAppearance();
  return $VALUES_29;
}

defineSeed(410, 49, makeCastMap([Q$SelectionAppearance, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), SelectionAppearance_0);
_.getValue_0 = function getValue_26(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_29, CHECKBOX, ROW_STYLE;
function $clinit_SelectionAppearance$Map(){
  $clinit_SelectionAppearance$Map = nullMethod;
  $MAP_29 = createValueOfMap(($clinit_SelectionAppearance() , $VALUES_29));
}

var $MAP_29;
function $clinit_SelectionType(){
  $clinit_SelectionType = nullMethod;
  BUTTON = new SelectionType_0('BUTTON', 0, 'button');
  CHECKBOX_0 = new SelectionType_0('CHECKBOX', 1, 'checkbox');
  RADIO = new SelectionType_0('RADIO', 2, 'radio');
  $VALUES_31 = initValues(_3Lcom_smartgwt_client_types_SelectionType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$SelectionType, [BUTTON, CHECKBOX_0, RADIO]);
}

function SelectionType_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_33(name_0){
  $clinit_SelectionType();
  return valueOf(($clinit_SelectionType$Map() , $MAP_31), name_0);
}

function values_32(){
  $clinit_SelectionType();
  return $VALUES_31;
}

defineSeed(414, 49, makeCastMap([Q$SelectionType, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), SelectionType_0);
_.getValue_0 = function getValue_28(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_31, BUTTON, CHECKBOX_0, RADIO;
function $clinit_SelectionType$Map(){
  $clinit_SelectionType$Map = nullMethod;
  $MAP_31 = createValueOfMap(($clinit_SelectionType() , $VALUES_31));
}

var $MAP_31;
function $clinit_Side(){
  $clinit_Side = nullMethod;
  LEFT_2 = new Side_0('LEFT', 0, 'left');
  RIGHT_2 = new Side_0('RIGHT', 1, 'right');
  TOP_0 = new Side_0('TOP', 2, 'top');
  BOTTOM_0 = new Side_0('BOTTOM', 3, 'bottom');
  $VALUES_32 = initValues(_3Lcom_smartgwt_client_types_Side_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Side, [LEFT_2, RIGHT_2, TOP_0, BOTTOM_0]);
}

function Side_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_34(name_0){
  $clinit_Side();
  return valueOf(($clinit_Side$Map() , $MAP_32), name_0);
}

function values_33(){
  $clinit_Side();
  return $VALUES_32;
}

defineSeed(416, 49, makeCastMap([Q$Side, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), Side_0);
_.getValue_0 = function getValue_29(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_32, BOTTOM_0, LEFT_2, RIGHT_2, TOP_0;
function $clinit_Side$Map(){
  $clinit_Side$Map = nullMethod;
  $MAP_32 = createValueOfMap(($clinit_Side() , $VALUES_32));
}

var $MAP_32;
function $clinit_TextMatchStyle(){
  $clinit_TextMatchStyle = nullMethod;
  EXACT = new TextMatchStyle_0('EXACT', 0, 'exact');
  SUBSTRING = new TextMatchStyle_0('SUBSTRING', 1, 'substring');
  STARTS_WITH = new TextMatchStyle_0('STARTS_WITH', 2, 'startsWith');
  $VALUES_34 = initValues(_3Lcom_smartgwt_client_types_TextMatchStyle_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TextMatchStyle, [EXACT, SUBSTRING, STARTS_WITH]);
}

function TextMatchStyle_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_36(name_0){
  $clinit_TextMatchStyle();
  return valueOf(($clinit_TextMatchStyle$Map() , $MAP_34), name_0);
}

function values_35(){
  $clinit_TextMatchStyle();
  return $VALUES_34;
}

defineSeed(420, 49, makeCastMap([Q$TextMatchStyle, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TextMatchStyle_0);
_.getValue_0 = function getValue_31(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_34, EXACT, STARTS_WITH, SUBSTRING;
function $clinit_TextMatchStyle$Map(){
  $clinit_TextMatchStyle$Map = nullMethod;
  $MAP_34 = createValueOfMap(($clinit_TextMatchStyle() , $VALUES_34));
}

var $MAP_34;
function $clinit_TitleOrientation(){
  $clinit_TitleOrientation = nullMethod;
  LEFT_3 = new TitleOrientation_0('LEFT', 0, 'left');
  TOP_1 = new TitleOrientation_0('TOP', 1, 'top');
  RIGHT_3 = new TitleOrientation_0('RIGHT', 2, 'right');
  $VALUES_36 = initValues(_3Lcom_smartgwt_client_types_TitleOrientation_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$TitleOrientation, [LEFT_3, TOP_1, RIGHT_3]);
}

function TitleOrientation_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_38(name_0){
  $clinit_TitleOrientation();
  return valueOf(($clinit_TitleOrientation$Map() , $MAP_36), name_0);
}

function values_37(){
  $clinit_TitleOrientation();
  return $VALUES_36;
}

defineSeed(424, 49, makeCastMap([Q$TitleOrientation, Q$ValueEnum, Q$Serializable, Q$Comparable, Q$Enum]), TitleOrientation_0);
_.getValue_0 = function getValue_33(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_36, LEFT_3, RIGHT_3, TOP_1;
function $clinit_TitleOrientation$Map(){
  $clinit_TitleOrientation$Map = nullMethod;
  $MAP_36 = createValueOfMap(($clinit_TitleOrientation() , $VALUES_36));
}

var $MAP_36;
function $clinit_VisibilityMode(){
  $clinit_VisibilityMode = nullMethod;
  MUTEX = new VisibilityMode_0('MUTEX', 0, 'mutex');
  MULTIPLE_0 = new VisibilityMode_0('MULTIPLE', 1, 'multiple');
  $VALUES_39 = initValues(_3Lcom_smartgwt_client_types_VisibilityMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$VisibilityMode, [MUTEX, MULTIPLE_0]);
}

function VisibilityMode_0(enum$name, enum$ordinal, value){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.value_0 = value;
}

function valueOf_41(name_0){
  $clinit_VisibilityMode();
  return valueOf(($clinit_VisibilityMode$Map() , $MAP_39), name_0);
}

function values_40(){
  $clinit_VisibilityMode();
  return $VALUES_39;
}

defineSeed(430, 49, makeCastMap([Q$ValueEnum, Q$VisibilityMode, Q$Serializable, Q$Comparable, Q$Enum]), VisibilityMode_0);
_.getValue_0 = function getValue_36(){
  return this.value_0;
}
;
_.value_0 = null;
var $VALUES_39, MULTIPLE_0, MUTEX;
function $clinit_VisibilityMode$Map(){
  $clinit_VisibilityMode$Map = nullMethod;
  $MAP_39 = createValueOfMap(($clinit_VisibilityMode() , $VALUES_39));
}

var $MAP_39;
function getAbsoluteDate(relativeDate, baseDate, position){
  relativeDate = relativeDate.getJsObj();
  baseDate != null && (baseDate = convertToJavaScriptDate(baseDate));
  position != null && (position = position.getValue_0());
  var jsDate = $wnd.isc.DateUtil.getAbsoluteDate(relativeDate, baseDate, position);
  if (jsDate == null)
    return null;
  return toDate(jsDate.getTime());
}

function getEnum(enums, value){
  var anEnum, anEnum$index, anEnum$max;
  if (value == null)
    return null;
  for (anEnum$index = 0 , anEnum$max = enums.length; anEnum$index < anEnum$max; ++anEnum$index) {
    anEnum = enums[anEnum$index];
    if ($equals_6(anEnum.getValue_0(), value)) {
      return anEnum;
    }
  }
  return null;
}

function getDragTarget(){
  var ret = $wnd.isc.EventHandler.getDragTarget();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef_0(ret);
  retVal == null && (retVal = new Canvas_2(ret));
  return retVal;
}

function apply_0(config, jsObj){
  for (var k in config) {
    jsObj[k] = config[k];
  }
}

function convertToJavaStringArray(array){
  var arr, i, length_0, result;
  if (!array)
    return initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, []);
  length_0 = array.length;
  arr = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, length_0, 0);
  for (i = 0; i < length_0; ++i) {
    arr[i] = (result = array[i] , result == null || result === undefined?null:result);
  }
  return arr;
}

function getAttributeAsBoolean(elem, attr){
  var ret = elem[attr];
  return ret == null || ret === undefined?false:ret;
}

function getAttributeAsDouble(elem, attr){
  var ret = elem[attr];
  if (ret === undefined || ret == null) {
    return null;
  }
   else {
    if (typeof ret == 'object') {
      return ret;
    }
     else {
      return new Double_0(ret);
    }
  }
}

function getAttributeAsIntArray(elem, attr){
  var hold, i, rtn;
  rtn = null;
  hold = getAttributeAsJavaScriptObject(elem, attr);
  if (hold) {
    rtn = initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, getJavaScriptObjectArraySize(hold), 1);
    for (i = 0; i < rtn.length; ++i) {
      rtn[i] = hold[i];
    }
  }
  return rtn;
}

function getAttributeAsStringArray(elem, attr){
  var hold, i, rtn;
  rtn = null;
  hold = getAttributeAsJavaScriptObject(elem, attr);
  if (hold) {
    rtn = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, getJavaScriptObjectArraySize(hold), 0);
    for (i = 0; i < rtn.length; ++i) {
      rtn[i] = hold[i];
    }
  }
  return rtn;
}

function getProperties(jsObj){
  var props = createJavaScriptArray();
  for (var k in jsObj) {
    props.push(k);
  }
  return convertToJavaStringArray(props);
}

function setAttribute_6(elem, attr, value){
  !value?setNullAttribute(elem, attr):(elem[attr] = value.value_0 , undefined);
}

function ask_0(title, message, callback){
  $wnd.isc.ask(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback.execute_3(valueJ);
  }
  , {title:title});
}

function askforValue(message, callback){
  $wnd.isc.askForValue(message, function(value){
    value === undefined && (value = null);
    callback.execute_4(value);
  }
  , {width:275});
}

function confirm_0(message, callback){
  $wnd.isc.confirm(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback.execute_3(valueJ);
  }
  );
}

function say(message){
  $wnd.isc.say(message);
}

function warn(message, callback){
  $wnd.isc.warn(message, function(value){
    var valueJ = value == null?null:toBoolean(value);
    callback != null && callback.execute_3(valueJ);
  }
  );
}

function $setAttribute_21(this$static, attribute, value){
  var valueJS;
  valueJS = value.configOnly?value.config_0:$getOrCreateJsObj_0(value);
  $isCreated_1(this$static)?($toString_4(value) , undefined):(this$static.config_0[attribute] = valueJS , undefined);
}

function $setAttribute_26(this$static, value){
  $isCreated_1(this$static)?undefined:(this$static.config_0['tabBarControls'] = convertToJavaScriptArray(value) , undefined);
}

function $addChild(this$static, newChild){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.addChild(newChild.getOrCreateJsObj());
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef_0(ret);
  retVal == null && (retVal = new Canvas_2(ret));
  return retVal;
}

function $addDragResizeStartHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_6 && (TYPE_6 = new GwtEvent$Type_0) , TYPE_6)) == 0 && $setupDragResizeStartEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_6 && (TYPE_6 = new GwtEvent$Type_0) , TYPE_6));
}

function $addDragResizeStopHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_7 && (TYPE_7 = new GwtEvent$Type_0) , TYPE_7)) == 0 && $setupDragResizeStopEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_7 && (TYPE_7 = new GwtEvent$Type_0) , TYPE_7));
}

function $addDropHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_9 && (TYPE_9 = new GwtEvent$Type_0) , TYPE_9)) == 0 && $setupDropEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_9 && (TYPE_9 = new GwtEvent$Type_0) , TYPE_9));
}

function $addKeyPressHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_10 && (TYPE_10 = new GwtEvent$Type_0) , TYPE_10)) == 0 && $setupKeyPressEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_10 && (TYPE_10 = new GwtEvent$Type_0) , TYPE_10));
}

function $addMouseOutHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_12 && (TYPE_12 = new GwtEvent$Type_0) , TYPE_12)) == 0 && $setupMouseOutEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_12 && (TYPE_12 = new GwtEvent$Type_0) , TYPE_12));
}

function $addMouseOverHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_13 && (TYPE_13 = new GwtEvent$Type_0) , TYPE_13)) == 0 && $setupMouseOverEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_13 && (TYPE_13 = new GwtEvent$Type_0) , TYPE_13));
}

function $addResizedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_14 && (TYPE_14 = new GwtEvent$Type_0) , TYPE_14)) == 0 && $setupResizedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_14 && (TYPE_14 = new GwtEvent$Type_0) , TYPE_14));
}

function $addVisibilityChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_17 && (TYPE_17 = new GwtEvent$Type_0) , TYPE_17)) == 0 && $setupVisibilityChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_17 && (TYPE_17 = new GwtEvent$Type_0) , TYPE_17));
}

function $animateHide(this$static, effect){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateHide(effectVal);
}

function $animateHide_0(this$static, effect, callback){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateHide(effectVal, $entry(function(earlyFinish){
    earlyFinish = earlyFinish === undefined?false:earlyFinish;
    callback != null && callback.execute_5(earlyFinish);
  }
  ));
}

function $animateRect(this$static, left, top_0, width, height, callback, duration){
  var self_0 = this$static.getOrCreateJsObj();
  var leftJS = left == null?null:left.intValue();
  var topJS = top_0 == null?null:top_0.intValue();
  var widthJS = width == null?null:width.intValue();
  var heightJS = height == null?null:height.intValue();
  self_0.animateRect(leftJS, topJS, widthJS, heightJS, $entry(function(earlyFinish){
    earlyFinish = earlyFinish === undefined?false:earlyFinish;
    callback != null && callback.execute_5(earlyFinish);
  }
  ), duration);
}

function $animateShow(this$static, effect){
  var effectVal = effect.getValue_0();
  var self_0 = this$static.getOrCreateJsObj();
  self_0.animateShow(effectVal);
}

function $getDisabled(this$static){
  var disabled;
  disabled = $getAttributeAsBoolean_1(this$static, 'disabled');
  return !!disabled && disabled.value_0;
}

function $getPageLeft(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getPageLeft();
}

function $getPageTop(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getPageTop();
}

function $isDisabled(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isDisabled();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $moveTo(this$static, left, top_0){
  var widget = this$static.getOrCreateJsObj();
  return widget.moveTo(left, top_0);
}

function $setBackgroundColor(this$static, backgroundColor){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'backgroundColor', backgroundColor):(this$static.config_0['backgroundColor'] = backgroundColor , undefined);
}

function $setBorder(this$static){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'border', null):(this$static.config_0['border'] = null , undefined);
}

function $setCanAcceptDrop(this$static, canAcceptDrop){
  $isCreated_1(this$static)?!canAcceptDrop?$setNullProperty(this$static, 'canAcceptDrop'):$setProperty_4(this$static, 'canAcceptDrop', canAcceptDrop.value_0):setAttribute_5(this$static.config_0, 'canAcceptDrop', canAcceptDrop);
}

function $setCanDrag(this$static, canDrag){
  $isCreated_1(this$static)?!canDrag?$setNullProperty(this$static, 'canDrag'):$setProperty_4(this$static, 'canDrag', canDrag.value_0):setAttribute_5(this$static.config_0, 'canDrag', canDrag);
}

function $setCanDragResize(this$static, canDragResize){
  $isCreated_1(this$static)?!canDragResize?$setNullProperty(this$static, 'canDragResize'):$setProperty_4(this$static, 'canDragResize', canDragResize.value_0):setAttribute_5(this$static.config_0, 'canDragResize', canDragResize);
}

function $setCanDrop(this$static, canDrop){
  $isCreated_1(this$static)?!canDrop?$setNullProperty(this$static, 'canDrop'):$setProperty_4(this$static, 'canDrop', canDrop.value_0):setAttribute_5(this$static.config_0, 'canDrop', canDrop);
}

function $setContextMenu(this$static, contextMenu){
  $setAttribute_20(this$static, 'contextMenu', !contextMenu?null:$getOrCreateJsObj_0(contextMenu), true);
}

function $setDragOpacity(this$static, dragOpacity){
  $isCreated_1(this$static)?!dragOpacity?$setNullProperty(this$static, 'dragOpacity'):$setProperty_1(this$static, 'dragOpacity', dragOpacity.value_0):setAttribute_8(this$static.config_0, 'dragOpacity', dragOpacity);
}

function $setEdgeMarginSize(this$static){
  $isCreated_1(this$static)?$setProperty_0(this$static, 'edgeMarginSize', 0):(this$static.config_0['edgeMarginSize'] = 0 , undefined);
}

function $setEdgeSize(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['edgeSize'] = 0 , undefined);
}

function $setExtraSpace(this$static, extraSpace){
  $isCreated_1(this$static)?undefined:(this$static.config_0['extraSpace'] = extraSpace , undefined);
}

function $setGroupTitle(this$static, groupTitle){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'groupTitle', groupTitle):(this$static.config_0['groupTitle'] = groupTitle , undefined);
}

function $setHoverWidth(this$static, hoverWidth){
  $isCreated_1(this$static)?!hoverWidth?$setNullProperty(this$static, 'hoverWidth'):$setProperty_1(this$static, 'hoverWidth', hoverWidth.value_0):setAttribute_8(this$static.config_0, 'hoverWidth', hoverWidth);
}

function $setHoverWrap(this$static, hoverWrap){
  $isCreated_1(this$static)?!hoverWrap?$setNullProperty(this$static, 'hoverWrap'):$setProperty_4(this$static, 'hoverWrap', hoverWrap.value_0):setAttribute_5(this$static.config_0, 'hoverWrap', hoverWrap);
}

function $setIsGroup(this$static, isGroup){
  $isCreated_1(this$static)?!isGroup?$setNullProperty(this$static, 'isGroup'):$setProperty_4(this$static, 'isGroup', isGroup.value_0):setAttribute_5(this$static.config_0, 'isGroup', isGroup);
}

function $setRedrawOnResize(this$static, redrawOnResize){
  $isCreated_1(this$static)?!redrawOnResize?$setNullProperty(this$static, 'redrawOnResize'):$setProperty_4(this$static, 'redrawOnResize', redrawOnResize.value_0):setAttribute_5(this$static.config_0, 'redrawOnResize', redrawOnResize);
}

function $setShowEdges(this$static, showEdges){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'showEdges', showEdges);
}

function $setShowResizeBar(this$static, showResizeBar){
  $isCreated_1(this$static)?!showResizeBar?$setNullProperty(this$static, 'showResizeBar'):$setProperty_4(this$static, 'showResizeBar', showResizeBar.value_0):setAttribute_5(this$static.config_0, 'showResizeBar', showResizeBar);
}

function $setShowShadow(this$static, showShadow){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'showShadow', showShadow);
}

function $setupDragResizeStartEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dragResizeStart:$debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStartEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dragResizeStart = $debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStartEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupDragResizeStopEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dragResizeStop:$debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStopEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dragResizeStop = $debox($entry(function(){
      var param = {};
      var event_0 = new DragResizeStopEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupDropEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onDrop:$debox($entry(function(){
      var param = {};
      var event_0 = new DropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onDrop = $debox($entry(function(){
      var param = {};
      var event_0 = new DropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupKeyPressEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({keyPress:$debox($entry(function(){
      var param = {};
      var event_0 = new KeyPressEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.keyPress = $debox($entry(function(){
      var param = {};
      var event_0 = new KeyPressEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupMouseOutEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({mouseOut:$debox($entry(function(){
      var param = {};
      var event_0 = new MouseOutEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.mouseOut = $debox($entry(function(){
      var param = {};
      var event_0 = new MouseOutEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupMouseOverEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({mouseOver:$debox($entry(function(){
      var param = {};
      var event_0 = new MouseOverEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.mouseOver = $debox($entry(function(){
      var param = {};
      var event_0 = new MouseOverEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupResizedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({resized:$entry(function(){
      var param = {};
      var event_0 = new ResizedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.resized = $entry(function(){
      var param = {};
      var event_0 = new ResizedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupVisibilityChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({visibilityChanged:$entry(function(){
      var param = {isVisible:arguments[0]};
      var event_0 = new VisibilityChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.visibilityChanged = $entry(function(){
      var param = {isVisible:arguments[0]};
      var event_0 = new VisibilityChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function getImgURL(URL){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.getImgURL(URL);
}

function imgHTML(src){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.imgHTML(src);
}

function imgHTML_0(src, width, height){
  $clinit_BaseWidget();
  return $wnd.isc.Canvas.imgHTML(src, width, height);
}

defineSeed(445, 442, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.hide_0 = function hide(){
  $hide(this);
}
;
_.redraw_0 = function redraw(){
  $redraw(this);
}
;
_.setContents = function setContents_0(contents){
  $isCreated_1(this)?$setProperty_3(this, 'contents', contents):(this.config_0['contents'] = contents , undefined);
}
;
_.setOverflow = function setOverflow(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, true);
}
;
function $setIcon(this$static, icon){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'icon', icon):(this$static.config_0['icon'] = icon , undefined);
}

function $setShowRollOver(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_4(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

function $setDisabled_0(this$static, disabled){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setDisabled(disabled);
}

function $setShowRollOver_0(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_4(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

function Button_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function Button_2(title){
  $clinit_BaseWidget();
  StatefulCanvas_0.call(this);
  $isCreated_1(this)?$setProperty_3(this, 'title', title):(this.config_0['title'] = title , undefined);
  this.scClassName = 'Button';
}

function getOrCreateRef_4(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$Button):new Button_1(jsObj);
}

defineSeed(443, 444, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Button, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), Button_1, Button_2);
_.setAutoFit = function setAutoFit(autoFit){
  $isCreated_1(this)?!autoFit?$setNullProperty(this, 'autoFit'):$setProperty_4(this, 'autoFit', autoFit.value_0):setAttribute_5(this.config_0, 'autoFit', autoFit);
}
;
function $getMember_0(this$static, memberID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getMember(memberID);
  return ret == null?null:getOrCreateRef_3(ret);
}

function $getMemberNumber(this$static, memberID){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getMemberNumber(memberID);
}

function $hasMember(this$static, canvas){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasMember(canvas.getOrCreateJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $setAnimateMemberTime(this$static, animateMemberTime){
  $isCreated_1(this$static)?!animateMemberTime?$setNullProperty(this$static, 'animateMemberTime'):$setProperty_1(this$static, 'animateMemberTime', animateMemberTime.value_0):setAttribute_8(this$static.config_0, 'animateMemberTime', animateMemberTime);
}

function $setAnimateMembers(this$static, animateMembers){
  $isCreated_1(this$static)?!animateMembers?$setNullProperty(this$static, 'animateMembers'):$setProperty_4(this$static, 'animateMembers', animateMembers.value_0):setAttribute_5(this$static.config_0, 'animateMembers', animateMembers);
}

function $setMembers(this$static, members){
  var member, member$index, member$max, membersToRemove;
  if ($isCreated_1(this$static)) {
    membersToRemove = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static, 'members'));
    for (member$index = 0 , member$max = membersToRemove.length; member$index < member$max; ++member$index) {
      member = membersToRemove[member$index];
      $removeMember(this$static, member);
    }
    for (member$index = 0 , member$max = members.length; member$index < member$max; ++member$index) {
      member = members[member$index];
      this$static.addMember_0(member);
    }
  }
   else {
    $isCreated_1(this$static)?$setProperty_2(this$static, 'members', convertToJavaScriptArray(members)):(this$static.config_0['members'] = convertToJavaScriptArray(members) , undefined);
  }
}

function $setShowDragPlaceHolder(this$static, showDragPlaceHolder){
  $isCreated_1(this$static)?!showDragPlaceHolder?$setNullProperty(this$static, 'showDragPlaceHolder'):$setProperty_4(this$static, 'showDragPlaceHolder', showDragPlaceHolder.value_0):setAttribute_5(this$static.config_0, 'showDragPlaceHolder', showDragPlaceHolder);
}

function $setVertical(this$static, vertical){
  $isCreated_1(this$static)?!vertical?$setNullProperty(this$static, 'vertical'):$setProperty_4(this$static, 'vertical', vertical.value_0):setAttribute_5(this$static.config_0, 'vertical', vertical);
}

function $setVisibleMember(this$static, member){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setVisibleMember(member.getOrCreateJsObj());
}

defineSeed(450, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]));
_.setOverflow = function setOverflow_0(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, false);
}
;
function VLayout_1(membersMargin){
  $clinit_BaseWidget();
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_0(this, 'membersMargin', membersMargin):(this.config_0['membersMargin'] = membersMargin , undefined);
  this.scClassName = 'VLayout';
}

defineSeed(449, 450, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), VLayout_1);
function $addMinimizeClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_11 && (TYPE_11 = new GwtEvent$Type_0) , TYPE_11)) == 0 && $setupMinimizeClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_11 && (TYPE_11 = new GwtEvent$Type_0) , TYPE_11));
}

function $addRestoreClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_15 && (TYPE_15 = new GwtEvent$Type_0) , TYPE_15)) == 0 && $setupRestoreClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_15 && (TYPE_15 = new GwtEvent$Type_0) , TYPE_15));
}

function $setAnimateMinimize(this$static, animateMinimize){
  $isCreated_1(this$static)?!animateMinimize?$setNullProperty(this$static, 'animateMinimize'):$setProperty_4(this$static, 'animateMinimize', animateMinimize.value_0):setAttribute_5(this$static.config_0, 'animateMinimize', animateMinimize);
}

function $setDismissOnOutsideClick(this$static, dismissOnOutsideClick){
  $isCreated_1(this$static)?!dismissOnOutsideClick?$setNullProperty(this$static, 'dismissOnOutsideClick'):$setProperty_4(this$static, 'dismissOnOutsideClick', dismissOnOutsideClick.value_0):setAttribute_5(this$static.config_0, 'dismissOnOutsideClick', dismissOnOutsideClick);
}

function $setHeaderControls(this$static, headerControls){
  $isCreated_1(this$static)?undefined:(this$static.config_0['headerControls'] = convertToJavaScriptArray(headerControls) , undefined);
}

function $setShowFooter(this$static, showFooter){
  $isCreated_1(this$static)?!showFooter?$setNullProperty(this$static, 'showFooter'):$setProperty_4(this$static, 'showFooter', showFooter.value_0):setAttribute_5(this$static.config_0, 'showFooter', showFooter);
}

function $setShowHeader(this$static, showHeader){
  $isCreated_1(this$static)?!showHeader?$setNullProperty(this$static, 'showHeader'):$setProperty_4(this$static, 'showHeader', showHeader.value_0):setAttribute_5(this$static.config_0, 'showHeader', showHeader);
}

function $setupMinimizeClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onMinimizeClick:$debox($entry(function(){
      var param = {};
      var event_0 = new MinimizeClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onMinimizeClick = $debox($entry(function(){
      var param = {};
      var event_0 = new MinimizeClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRestoreClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onRestoreClick:$debox($entry(function(){
      var param = {};
      var event_0 = new RestoreClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onRestoreClick = $debox($entry(function(){
      var param = {};
      var event_0 = new RestoreClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $clinit_Dialog(){
  $clinit_Dialog = nullMethod;
  $clinit_BaseWidget();
  new Button_2('OK');
  new Button_2('Apply');
  new Button_2('Yes');
  new Button_2('No');
  new Button_2('Cancel');
  new Button_2('Done');
}

defineSeed(447, 448, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]));
_.create_0 = function create_15(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setStyleName = function setStyleName_0(styleName){
  $isCreated_1(this)?$setProperty_3(this, 'styleName', styleName):(this.config_0['styleName'] = styleName , undefined);
}
;
function $setContents(this$static, contents){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'contents', contents):(this$static.config_0['contents'] = contents , undefined);
}

function $setContentsURL(this$static, contentsURL){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'contentsURL', contentsURL):(this$static.config_0['contentsURL'] = contentsURL , undefined);
}

defineSeed(451, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setContents = function setContents_1(contents){
  $setContents(this, contents);
}
;
function Img_0(){
  $clinit_BaseWidget();
  StatefulCanvas_0.call(this);
  this.scClassName = 'Img';
}

function $clinit_HeaderControl(){
  var imgType;
  $clinit_HeaderControl = nullMethod;
  $clinit_BaseWidget();
  IMG_TYPE = (imgType = $wnd.isc.headerImgType , imgType == null || imgType === undefined?'png':imgType);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_right.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/arrow_up.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/calculator.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/cart.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/cascade.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/clipboard.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/clock.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/close.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/comment.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/document.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_right.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/double_arrow_up.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/favourite.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/find.' + IMG_TYPE);
  HELP = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/help.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/home.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/mail.' + IMG_TYPE);
  MAXIMIZE = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/maximize.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/minimize.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/minus.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/person.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/pin_down.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/pin_left.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/plus.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/print.' + IMG_TYPE);
  REFRESH = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/refresh.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/refresh_thin.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/save.' + IMG_TYPE);
  SETTINGS = new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/settings.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/transfer.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/trash.' + IMG_TYPE);
  new HeaderControl$HeaderIcon_0('[SKIN]/headerIcons/zoom.' + IMG_TYPE);
}

function HeaderControl_0(icon){
  $clinit_HeaderControl();
  Img_0.call(this);
  $setSrc(this, icon.url);
  $isCreated_1(this)?$setProperty_0(this, 'width', 15):(this.config_0['width'] = 15 , undefined);
  $isCreated_1(this)?$setProperty_0(this, 'height', 15):(this.config_0['height'] = 15 , undefined);
  $setAttribute_24(this, 'layoutAlign', ($clinit_Alignment() , CENTER_0).value_0, false);
  $setShowRollOver(this, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

function HeaderControl_1(icon, clickHandler){
  $clinit_HeaderControl();
  HeaderControl_0.call(this, icon);
  $getHandlerCount_1(this, (!TYPE_3 && (TYPE_3 = new GwtEvent$Type_0) , TYPE_3)) == 0 && $setupClickEvent(this);
  $doAddHandler_0(this, clickHandler, (!TYPE_3 && (TYPE_3 = new GwtEvent$Type_0) , TYPE_3));
}

defineSeed(453, 454, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), HeaderControl_0, HeaderControl_1);
var HELP, IMG_TYPE, MAXIMIZE, REFRESH, SETTINGS;
function HeaderControl$HeaderIcon_0(url){
  this.url = url;
}

defineSeed(455, 1, {}, HeaderControl$HeaderIcon_0);
_.url = null;
function $setIcon_0(this$static, icon){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'icon', icon):(this$static.config_0['icon'] = icon , undefined);
}

function $setIconHeight(this$static, iconHeight){
  $isCreated_1(this$static)?undefined:setAttribute_8(this$static.config_0, 'iconHeight', iconHeight);
}

function $setIconOrientation(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['iconOrientation'] = 'left' , undefined);
}

function $setIconWidth(this$static, iconWidth){
  $isCreated_1(this$static)?undefined:setAttribute_8(this$static.config_0, 'iconWidth', iconWidth);
}

function $setShowTitle(this$static, showTitle){
  $isCreated_1(this$static)?!showTitle?$setNullProperty(this$static, 'showTitle'):$setProperty_4(this$static, 'showTitle', showTitle.value_0):setAttribute_5(this$static.config_0, 'showTitle', showTitle);
}

function $setTitle_0(this$static, title){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'title', title):(this$static.config_0['title'] = title , undefined);
}

function $setWrap(this$static, wrap){
  $isCreated_1(this$static)?!wrap?$setNullProperty(this$static, 'wrap'):$setProperty_4(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.config_0, 'wrap', wrap);
}

function IButton_0(){
  $clinit_BaseWidget();
  StretchImgButton_0.call(this);
  this.scClassName = 'IButton';
}

defineSeed(456, 457, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$IButton, Q$StatefulCanvas, Q$StretchImg, Q$StretchImgButton, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), IButton_0);
function $setDisabled_1(this$static, disabled){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setDisabled(disabled);
}

defineSeed(459, 454, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.create_0 = function create_22(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setSrc = function setSrc_0(src){
  $isCreated_1(this)?$setProperty_3(this, 'src', src):(this.config_0['src'] = src , undefined);
}
;
function ImgProperties_0(src){
  DataClass_0.call(this);
  this.jsObj['src'] = src;
  $setAttribute_11(this, 'width', valueOf_44(16));
  $setAttribute_11(this, 'height', valueOf_44(16));
}

defineSeed(460, 330, makeCastMap([Q$DataClass, Q$JsObject]), ImgProperties_0);
function $setAutoFit_0(this$static, autoFit){
  $isCreated_1(this$static)?!autoFit?$setNullProperty(this$static, 'autoFit'):$setProperty_4(this$static, 'autoFit', autoFit.value_0):setAttribute_5(this$static.config_0, 'autoFit', autoFit);
}

defineSeed(461, 443, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Button, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]));
_.setAutoFit = function setAutoFit_0(autoFit){
  $setAutoFit_0(this, autoFit);
}
;
_.setContents = function setContents_2(contents){
  $setContents_0(this, contents);
}
;
function $clinit_TransferImgButton(){
  var imgType;
  $clinit_TransferImgButton = nullMethod;
  $clinit_BaseWidget();
  IMG_TYPE_0 = (imgType = $wnd.isc.transferImgType , imgType == null || imgType === undefined?'png':imgType);
  LEFT_4 = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/left.' + IMG_TYPE_0);
  LEFT_ALL = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/left_all.' + IMG_TYPE_0);
  RIGHT_4 = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/right.' + IMG_TYPE_0);
  RIGHT_ALL = new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/right_all.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/up.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/up_first.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/down.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/down_last.' + IMG_TYPE_0);
  new TransferImgButton$TransferImg_0('[SKIN]/TransferIcons/delete.' + IMG_TYPE_0);
}

function TransferImgButton_0(transferImg){
  $clinit_TransferImgButton();
  $clinit_BaseWidget();
  Img_0.call(this);
  this.scClassName = 'ImgButton';
  $setAttribute_24(this, 'src', transferImg.url, true);
  $isCreated_1(this)?$setProperty_0(this, 'width', 24):(this.config_0['width'] = 24 , undefined);
  $isCreated_1(this)?$setProperty_0(this, 'height', 22):(this.config_0['height'] = 22 , undefined);
  $setAttribute_24(this, 'layoutAlign', ($clinit_Alignment() , CENTER_0).value_0, false);
  $setAttribute_22(this, 'showRollOver', ($clinit_Boolean() , $clinit_Boolean() , TRUE), true);
  $setAttribute_22(this, 'showDownIcon', FALSE, false);
  $setAttribute_22(this, 'showDown', FALSE, true);
}

defineSeed(462, 459, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), TransferImgButton_0);
var IMG_TYPE_0, LEFT_4, LEFT_ALL, RIGHT_4, RIGHT_ALL;
function TransferImgButton$TransferImg_0(url){
  this.url = url;
}

defineSeed(463, 1, {}, TransferImgButton$TransferImg_0);
_.url = null;
function WidgetCanvas_0(widget){
  $clinit_BaseWidget();
  var height, width;
  Canvas_1.call(this);
  this.widget = widget;
  $setRedrawOnResize(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setAttribute_22(this, '_redrawWithParent', FALSE, false);
  $setAttribute_22(this, '_clearWithRemoveChild', TRUE, false);
  $setAttribute_24(this, 'overflow', ($clinit_Overflow() , VISIBLE).value_0, true);
  width = widget.element.style['width'];
  height = widget.element.style['height'];
  width != null && !$equals_6(width, '') && ($isCreated_1(this)?$setProperty_3(this, 'width', width):(this.config_0['width'] = width , undefined));
  height != null && !$equals_6(height, '') && ($isCreated_1(this)?$setProperty_3(this, 'height', height):(this.config_0['height'] = height , undefined));
}

defineSeed(464, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), WidgetCanvas_0);
_.getInnerHTML_0 = function getInnerHTML_0(){
  this.widget.attached && $removeFromParent(this.widget);
  return "<DIV STYLE='width:100%;height:100%' ID=" + this.id_0 + '_widget><\/DIV>';
}
;
_.onDraw_0 = function onDraw_0(){
  var attached, height, rp, width;
  attached = this.widget.attached;
  if (!attached) {
    rp = get_1(this.id_0 + '_widget');
    $add_1(rp, this.widget);
    width = this.widget.element.style['width'];
    width != null && !$equals_6(width, '') && ($isCreated_1(this)?$setProperty_3(this, 'width', width):(this.config_0['width'] = width , undefined));
    height = this.widget.element.style['height'];
    height != null && !$equals_6(height, '') && ($isCreated_1(this)?$setProperty_3(this, 'height', height):(this.config_0['height'] = height , undefined));
  }
}
;
_.widget = null;
function $isRightButtonDown(){
  return $wnd.isc.EH.rightButtonDown();
}

function DragResizeStartEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(469, 465, {}, DragResizeStartEvent_0);
_.dispatch = function dispatch_6(handler){
  dynamicCast(dynamicCast(handler, Q$DragResizeStartHandler), Q$PortalLayout$2).this$0.dragResizeColumnCount = valueOf_44(0);
}
;
_.getAssociatedType = function getAssociatedType_6(){
  return TYPE_6;
}
;
_.isCancelled = function isCancelled_1(){
  return false;
}
;
var TYPE_6 = null;
function $dispatch_0(this$static, handler){
  $setHeight_3(handler.this$0.storedPortlet, $getAttributeAsInt_0(dynamicCast(this$static.source, Q$Canvas), 'height').value_0);
  $resize(handler.this$0.dashboardView.portalLayout);
  $save_3(handler.this$0.dashboardView);
}

function DragResizeStopEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(470, 465, {}, DragResizeStopEvent_0);
_.dispatch = function dispatch_7(handler){
  $dispatch_0(this, dynamicCast(handler, Q$DragResizeStopHandler));
}
;
_.getAssociatedType = function getAssociatedType_7(){
  return TYPE_7;
}
;
_.isCancelled = function isCancelled_2(){
  return false;
}
;
var TYPE_7 = null;
function DropEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(472, 465, {}, DropEvent_0);
_.dispatch = function dispatch_9(handler){
  $onDrop(dynamicCast(handler, Q$DropHandler));
}
;
_.getAssociatedType = function getAssociatedType_9(){
  return TYPE_9;
}
;
_.isCancelled = function isCancelled_3(){
  return false;
}
;
var TYPE_9 = null;
function $dispatch_1(handler){
  var keyName;
  $equals_6('Delete', (keyName = $wnd.isc.EventHandler.getKey() , keyName == undefined?null:keyName)) && $removeSelectedRows(handler.this$0);
}

function KeyPressEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(473, 465, {}, KeyPressEvent_0);
_.dispatch = function dispatch_10(handler){
  $dispatch_1(dynamicCast(handler, Q$KeyPressHandler));
}
;
_.getAssociatedType = function getAssociatedType_10(){
  return TYPE_10;
}
;
_.isCancelled = function isCancelled_4(){
  return false;
}
;
var TYPE_10 = null;
function MinimizeClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(474, 465, {}, MinimizeClickEvent_0);
_.dispatch = function dispatch_11(handler){
  $hide(dynamicCast(dynamicCast(handler, Q$MinimizeClickHandler), Q$PortletWindow$10).this$0.maximizeHeaderControl);
}
;
_.getAssociatedType = function getAssociatedType_11(){
  return TYPE_11;
}
;
_.isCancelled = function isCancelled_5(){
  return false;
}
;
var TYPE_11 = null;
function MouseOutEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(475, 465, {}, MouseOutEvent_0);
_.dispatch = function dispatch_12(handler){
  dynamicCast(handler, Q$MouseOutHandler).onMouseOut(this);
}
;
_.getAssociatedType = function getAssociatedType_12(){
  return TYPE_12;
}
;
_.isCancelled = function isCancelled_6(){
  return false;
}
;
var TYPE_12 = null;
function MouseOverEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(476, 465, {}, MouseOverEvent_0);
_.dispatch = function dispatch_13(handler){
  dynamicCast(handler, Q$MouseOverHandler).onMouseOver(this);
}
;
_.getAssociatedType = function getAssociatedType_13(){
  return TYPE_13;
}
;
_.isCancelled = function isCancelled_7(){
  return false;
}
;
var TYPE_13 = null;
function ResizedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(477, 465, {}, ResizedEvent_0);
_.dispatch = function dispatch_14(handler){
  $onResized(dynamicCast(handler, Q$ResizedHandler));
}
;
_.getAssociatedType = function getAssociatedType_14(){
  return TYPE_14;
}
;
var TYPE_14 = null;
function RestoreClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(478, 465, {}, RestoreClickEvent_0);
_.dispatch = function dispatch_15(handler){
  $show(dynamicCast(dynamicCast(handler, Q$RestoreClickHandler), Q$PortletWindow$11).this$0.maximizeHeaderControl);
}
;
_.getAssociatedType = function getAssociatedType_15(){
  return TYPE_15;
}
;
_.isCancelled = function isCancelled_8(){
  return false;
}
;
var TYPE_15 = null;
function $dispatch_3(this$static, handler){
  var jsObj;
  (jsObj = this$static.jsObj , jsObj.isVisible) || ask(($clinit_Enhanced() , 'P\u0159ejete si ulo\u017Eit zm\u011Bny na definici v\xFDstrahy?'), new SingleAlertDefinitionView$5$1_0(handler));
}

function VisibilityChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(480, 465, {}, VisibilityChangedEvent_0);
_.dispatch = function dispatch_17(handler){
  $dispatch_3(this, dynamicCast(handler, Q$VisibilityChangedHandler));
}
;
_.getAssociatedType = function getAssociatedType_17(){
  return TYPE_17;
}
;
var TYPE_17 = null;
function $addColorSelectedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_18 && (TYPE_18 = new GwtEvent$Type_0) , TYPE_18)) == 0 && $setupColorSelectedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_18 && (TYPE_18 = new GwtEvent$Type_0) , TYPE_18));
}

function $setupColorSelectedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({colorSelected:$entry(function(){
      var param = {color:arguments[0], opacity:arguments[1]};
      var event_0 = new ColorSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.colorSelected = $entry(function(){
      var param = {color:arguments[0], opacity:arguments[1]};
      var event_0 = new ColorSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function ColorPicker_0(){
  $clinit_BaseWidget();
  Window_1.call(this);
  this.scClassName = 'ColorPicker';
}

defineSeed(481, 448, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), ColorPicker_0);
_.create_0 = function create_24(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $addFormSubmitFailedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_19 && (TYPE_19 = new GwtEvent$Type_0) , TYPE_19)) == 0 && $setupFormSubmitFailedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_19 && (TYPE_19 = new GwtEvent$Type_0) , TYPE_19));
}

function $addItemChangeHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_20 && (TYPE_20 = new GwtEvent$Type_0) , TYPE_20)) == 0 && $setupItemChangeEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_20 && (TYPE_20 = new GwtEvent$Type_0) , TYPE_20));
}

function $addItemChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_21 && (TYPE_21 = new GwtEvent$Type_0) , TYPE_21)) == 0 && $setupItemChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_21 && (TYPE_21 = new GwtEvent$Type_0) , TYPE_21));
}

function $clearValue(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.clearValue(fieldName);
}

function $editRecord(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.editRecord(record.getJsObj());
}

function $fetchData_1(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $getField_0(this$static, name_0){
  var field, field$array, field$index, field$max, fieldJS;
  if (this$static.fields_0 != null) {
    for (field$array = this$static.fields_0 , field$index = 0 , field$max = field$array.length; field$index < field$max; ++field$index) {
      field = field$array[field$index];
      if ($equals_6(name_0, $isCreated_2(field)?$getPropertyAsString(field, 'name'):getAttribute(field.jsObj, 'name'))) {
        return field;
      }
    }
  }
   else {
    fieldJS = $getFieldJS(this$static, name_0);
    return fieldJS?getFormItem(fieldJS):null;
  }
  return null;
}

function $getValue(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  var val = self_0.getValue(fieldName);
  return val == null || val === undefined?null:$wnd.SmartGWT.convertToJavaType(val);
}

function $hideItem(this$static, itemName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.hideItem(itemName);
}

function $isNewRecord(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isNewRecord();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $resetValues(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.resetValues();
}

function $saveData(this$static, callback){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.saveData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $saveData_0(this$static, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.saveData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $setAction(this$static, action){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'action', action):(this$static.config_0['action'] = action , undefined);
}

function $setAutoFetchData(this$static, autoFetchData){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFetchData', autoFetchData);
}

function $setCanFocus(this$static, canFocus){
  $isCreated_1(this$static)?!canFocus?$setNullProperty(this$static, 'canFocus'):$setProperty_4(this$static, 'canFocus', canFocus.value_0):setAttribute_5(this$static.config_0, 'canFocus', canFocus);
}

function $setCellPadding(this$static){
  $isCreated_1(this$static)?$setProperty_0(this$static, 'cellPadding', 5):(this$static.config_0['cellPadding'] = 5 , undefined);
}

function $setColWidths(this$static, colWidths){
  $isCreated_1(this$static)?$setProperty_2(this$static, 'colWidths', convertToJavaScriptArray(colWidths)):(this$static.config_0['colWidths'] = convertToJavaScriptArray(colWidths) , undefined);
}

function $setErrors(this$static, errors, showErrors){
  var self_0 = this$static.getOrCreateJsObj();
  var errorsJS = convertMapToJavascriptObject(errors);
  return self_0.setErrors(errorsJS, showErrors);
}

function $setHiliteRequiredFields(this$static, hiliteRequiredFields){
  $isCreated_1(this$static)?!hiliteRequiredFields?$setNullProperty(this$static, 'hiliteRequiredFields'):$setProperty_4(this$static, 'hiliteRequiredFields', hiliteRequiredFields.value_0):setAttribute_5(this$static.config_0, 'hiliteRequiredFields', hiliteRequiredFields);
}

function $setShowInlineErrors(this$static, showInlineErrors){
  $isCreated_1(this$static)?!showInlineErrors?$setNullProperty(this$static, 'showInlineErrors'):$setProperty_4(this$static, 'showInlineErrors', showInlineErrors.value_0):setAttribute_5(this$static.config_0, 'showInlineErrors', showInlineErrors);
}

function $setStopOnError(this$static, stopOnError){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'stopOnError', stopOnError);
}

function $setTarget(this$static, target){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'target', target):(this$static.config_0['target'] = target , undefined);
}

function $setValidateOnChange(this$static, validateOnChange){
  $isCreated_1(this$static)?!validateOnChange?$setNullProperty(this$static, 'validateOnChange'):$setProperty_4(this$static, 'validateOnChange', validateOnChange.value_0):setAttribute_5(this$static.config_0, 'validateOnChange', validateOnChange);
}

function $setValue(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setValue(fieldName, value);
}

function $setValue_1(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setValue(fieldName, value);
}

function $setValue_2(this$static, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  var valueJS = convertToJavaScriptArray(value);
  self_0.setValue(fieldName, valueJS);
}

function $setupFormSubmitFailedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({formSubmitFailed:$entry(function(){
      var param = {};
      var event_0 = new FormSubmitFailedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.formSubmitFailed = $entry(function(){
      var param = {};
      var event_0 = new FormSubmitFailedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupItemChangeEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemChange:$debox($entry(function(){
      var param = {item:arguments[0], newValue:arguments[1], oldValue:arguments[2]};
      var event_0 = new ItemChangeEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemChange = $debox($entry(function(){
      var param = {item:arguments[0], newValue:arguments[1], oldValue:arguments[2]};
      var event_0 = new ItemChangeEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupItemChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemChanged:$entry(function(){
      var param = {item:arguments[0], newValue:arguments[1]};
      var event_0 = new ItemChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemChanged = $entry(function(){
      var param = {item:arguments[0], newValue:arguments[1]};
      var event_0 = new ItemChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $showItem(this$static, itemName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.showItem(itemName);
}

function $submitForm(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.submitForm();
}

function $validate_0(this$static, validateHiddenFields){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validate(validateHiddenFields);
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function DynamicForm_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function getOrCreateRef_5(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$DynamicForm):new DynamicForm_1(jsObj);
}

defineSeed(482, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$DynamicForm]), DynamicForm_1);
function $addMember_1(this$static, member){
  var self_0 = this$static.getOrCreateJsObj();
  var memberJS = member.getOrCreateJsObj();
  self_0.addMember(memberJS);
}

function $getErrors_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var value = self_0.getErrors();
  if (value == null)
    return null;
  var valueJ = convertToMap(value);
  return valueJ;
}

function $hasErrors(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasErrors();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $validate_1(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validate();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function ValuesManager_0(){
  BaseClass_0.call(this);
  this.scClassName = 'ValuesManager';
}

defineSeed(483, 329, makeCastMap([Q$HasHandlers, Q$BaseClass]), ValuesManager_0);
_.create_0 = function create_26(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  return $wnd.isc[scClassName].create(config);
}
;
function $getColor_0(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.color;
}

function ColorSelectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(484, 465, {}, ColorSelectedEvent_0);
_.dispatch = function dispatch_18(handler){
  dynamicCast(handler, Q$ColorSelectedHandler).onColorSelected(this);
}
;
_.getAssociatedType = function getAssociatedType_18(){
  return TYPE_18;
}
;
var TYPE_18 = null;
function FormSubmitFailedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(485, 465, {}, FormSubmitFailedEvent_0);
_.dispatch = function dispatch_19(handler){
  dynamicCast(handler, Q$FormSubmitFailedHandler).onFormSubmitFailed(this);
}
;
_.getAssociatedType = function getAssociatedType_19(){
  return TYPE_19;
}
;
var TYPE_19 = null;
function $dispatch_4(this$static, handler){
  $onItemChange(handler, this$static);
}

function $getNewValue(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.newValue);
}

function ItemChangeEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(486, 465, {}, ItemChangeEvent_0);
_.dispatch = function dispatch_20(handler){
  $dispatch_4(this, dynamicCast(handler, Q$ItemChangeHandler));
}
;
_.getAssociatedType = function getAssociatedType_20(){
  return TYPE_20;
}
;
_.isCancelled = function isCancelled_10(){
  return false;
}
;
var TYPE_20 = null;
function ItemChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(487, 465, {}, ItemChangedEvent_0);
_.dispatch = function dispatch_21(handler){
  dynamicCast(handler, Q$ItemChangedHandler).onItemChanged(this);
}
;
_.getAssociatedType = function getAssociatedType_21(){
  return TYPE_21;
}
;
var TYPE_21 = null;
function $addBlurHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_23 && (TYPE_23 = new GwtEvent$Type_0) , TYPE_23)) == 0 && $setupBlurEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_23 && (TYPE_23 = new GwtEvent$Type_0) , TYPE_23));
}

function $addChangeHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_24 && (TYPE_24 = new GwtEvent$Type_0) , TYPE_24)) == 0 && $setupChangeEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_24 && (TYPE_24 = new GwtEvent$Type_0) , TYPE_24));
}

function $addChangedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_25 && (TYPE_25 = new GwtEvent$Type_0) , TYPE_25)) == 0 && $setupChangedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_25 && (TYPE_25 = new GwtEvent$Type_0) , TYPE_25));
}

function $addFocusHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_28 && (TYPE_28 = new GwtEvent$Type_0) , TYPE_28)) == 0 && $setupFocusEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_28 && (TYPE_28 = new GwtEvent$Type_0) , TYPE_28));
}

function $addIconClickHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_30 && (TYPE_30 = new GwtEvent$Type_0) , TYPE_30)) == 0 && $setupIconClickEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_30 && (TYPE_30 = new GwtEvent$Type_0) , TYPE_30));
}

function $addItemHoverHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_31 && (TYPE_31 = new GwtEvent$Type_0) , TYPE_31)) == 0 && $setupItemHoverEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_31 && (TYPE_31 = new GwtEvent$Type_0) , TYPE_31));
}

function $doSetValue(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $getAttribute_0(this$static, attribute){
  return $isCreated_2(this$static)?$getPropertyAsString(this$static, attribute):getAttribute(this$static.jsObj, attribute);
}

function $getAttributeAsInt_1(this$static){
  var self_0, ret;
  return $isCreated_2(this$static)?(self_0 = this$static.getJsObj() , ret = self_0.getProperty('singleResourceId') , ret == null || ret === undefined?null:valueOf_44(ret)):getAttributeAsInt(this$static.jsObj, 'singleResourceId');
}

function $getConfig(this$static){
  var self_0 = this$static.getJsObj();
  var config = {};
  for (var k in self_0) {
    k != '__ref' && k != 'type' && k != 'editorType' && k != 'name' && (config[k] = self_0[k]);
  }
  self_0.transformInput && (config['transformInput'] = self_0.transformInput);
  return config;
}

function $getDisplayValue(this$static){
  var self_0 = this$static.getJsObj();
  if (self_0.setValue) {
    var val = self_0.getDisplayValue();
    return val == null?null:val.toString();
  }
   else {
    return '';
  }
}

function $getForm(this$static){
  var self_0 = this$static.getJsObj();
  if (self_0.form) {
    return getOrCreateRef_5(self_0.form);
  }
   else {
    return null;
  }
}

function $getIcon(this$static, name_0){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getIcon(name_0);
  if (ret == null || ret === undefined)
    return null;
  return new FormItemIcon_1(ret);
}

function $getPropertyAsBoolean(this$static, property){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getProperty(property);
  return ret == null || ret === undefined?null:toBoolean(ret);
}

function $isDisabled_0(this$static){
  var self_0 = this$static.getJsObj();
  var retVal = self_0.isDisabled();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $redraw_0(this$static){
  var self_0 = this$static.getJsObj();
  self_0.setValue && self_0.redraw();
}

function $setAttribute_29(this$static, attribute, value){
  $isCreated_2(this$static)?$setProperty_9(this$static, attribute, value.value_0):setAttribute_5(this$static.jsObj, attribute, value);
}

function $setCanFocus_0(this$static, canFocus){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'canFocus', canFocus.value_0):setAttribute_5(this$static.jsObj, 'canFocus', canFocus);
}

function $setColSpan_0(this$static, colSpan){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'colSpan', colSpan):(this$static.jsObj['colSpan'] = colSpan , undefined);
}

function $setDefaultValue(this$static, defaultValue){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'defaultValue', defaultValue.value_0):setAttribute_5(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setDefaultValue_0(this$static, defaultValue){
  setAttribute_8(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setDefaultValue_1(this$static, defaultValue){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'defaultValue', defaultValue):(this$static.jsObj['defaultValue'] = defaultValue , undefined);
}

function $setEmptyDisplayValue(this$static, emptyDisplayValue){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'emptyDisplayValue', emptyDisplayValue):(this$static.jsObj['emptyDisplayValue'] = emptyDisplayValue , undefined);
}

function $setEndRow_0(this$static, endRow){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'endRow', endRow.value_0):setAttribute_5(this$static.jsObj, 'endRow', endRow);
}

function $setErrorOrientation_0(this$static, errorOrientation){
  this$static.jsObj['errorOrientation'] = !errorOrientation?null:errorOrientation.value_0;
}

function $setHeight_1(this$static, height){
  $equals_6('100%', height) && (height = '*');
  $isCreated_2(this$static)?$setProperty_8(this$static, 'height', height):(this$static.jsObj['height'] = height , undefined);
}

function $setHint(this$static, hint){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'hint', hint):(this$static.jsObj['hint'] = hint , undefined);
}

function $setHoverWidth_0(this$static, hoverWidth){
  setAttribute_8(this$static.jsObj, 'hoverWidth', hoverWidth);
}

function $setIcons(this$static, icons){
  $isCreated_2(this$static)?$setProperty_7(this$static, 'icons', convertToJavaScriptArray(icons)):(this$static.jsObj['icons'] = convertToJavaScriptArray(icons) , undefined);
}

function $setPrompt_1(this$static, prompt_0){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'prompt', prompt_0):(this$static.jsObj['prompt'] = prompt_0 , undefined);
}

function $setRedrawOnChange(this$static){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'redrawOnChange', true):(this$static.jsObj['redrawOnChange'] = true , undefined);
}

function $setShowHint(this$static, showHint){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showHint', showHint.value_0):setAttribute_5(this$static.jsObj, 'showHint', showHint);
}

function $setShowIcons(this$static, showIcons){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showIcons', showIcons.value_0):setAttribute_5(this$static.jsObj, 'showIcons', showIcons);
}

function $setShowIfCondition(this$static, showIf){
  var self_0 = this$static.getJsObj();
  self_0.showIf = $debox($entry(function(item, value, form, values){
    var itemJ = getOrCreateRef_6(item);
    var valueJ = $wnd.SmartGWT.convertToJavaType(value);
    var formJ = getOrCreateRef_5(form);
    return showIf.execute_6(itemJ, valueJ, formJ);
  }
  ));
}

function $setShowPickerIcon(this$static, showPickerIcon){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showPickerIcon', showPickerIcon.value_0):setAttribute_5(this$static.jsObj, 'showPickerIcon', showPickerIcon);
}

function $setShowValueIconOnly(this$static, showValueIconOnly){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showValueIconOnly', showValueIconOnly.value_0):setAttribute_5(this$static.jsObj, 'showValueIconOnly', showValueIconOnly);
}

function $setStartRow_0(this$static, startRow){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'startRow', startRow.value_0):setAttribute_5(this$static.jsObj, 'startRow', startRow);
}

function $setTabIndex(this$static, tabIndex){
  setAttribute_8(this$static.jsObj, 'tabIndex', tabIndex);
}

function $setType(this$static, type){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'type', type):(this$static.jsObj['type'] = type , undefined);
}

function $setValidateOnChange_0(this$static, validateOnChange){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'validateOnChange', validateOnChange.value_0):setAttribute_5(this$static.jsObj, 'validateOnChange', validateOnChange);
}

function $setValidateOnExit_0(this$static, validateOnExit){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'validateOnExit', validateOnExit.value_0):setAttribute_5(this$static.jsObj, 'validateOnExit', validateOnExit);
}

function $setValue_3(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_4(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_5(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValue_6(this$static, value){
  value == null || instanceOf(value, Q$String)?this$static.setValue_4(dynamicCast(value, Q$String)):instanceOf(value, Q$Integer)?this$static.setValue_2(dynamicCast(value, Q$Integer).value_0):instanceOf(value, Q$Long)?this$static.setValue_2(toInt(dynamicCast(value, Q$Long).value_0)):instanceOf(value, Q$Double)?this$static.setValue_0(dynamicCast(value, Q$Double).value_0):instanceOf(value, Q$Float)?this$static.setValue_1(dynamicCast(value, Q$Float).value_0):instanceOf(value, Q$Boolean)?this$static.setValue_6(dynamicCast(value, Q$Boolean).value_0):instanceOf(value, Q$Date)?this$static.setValue_5(dynamicCast(value, Q$Date)):instanceOf(value, Q$RelativeDate)?this$static.setValue_4(dynamicCast(value, Q$RelativeDate).value_0):$doSetValue(this$static, value);
}

function $setValue_8(this$static, value){
  var self_0 = this$static.getJsObj();
  var valueJS = convertToJavaScriptDate(value);
  self_0.setValue?self_0.setValue(valueJS):(self_0.value = valueJS);
}

function $setValue_9(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValue?self_0.setValue(value):(self_0.value = value);
}

function $setValueIconHeight(this$static, valueIconHeight){
  setAttribute_8(this$static.jsObj, 'valueIconHeight', valueIconHeight);
}

function $setValueIconWidth(this$static, valueIconWidth){
  setAttribute_8(this$static.jsObj, 'valueIconWidth', valueIconWidth);
}

function $setValueIcons(this$static, valueIcons){
  $isCreated_2(this$static)?$setProperty_7(this$static, 'valueIcons', convertMapToJavascriptObject(valueIcons)):(this$static.jsObj['valueIcons'] = convertMapToJavascriptObject(valueIcons) , undefined);
}

function $setValueMap(this$static, valueMap){
  $isCreated_2(this$static)?$setValueMapMethod(this$static, convertMapToJavascriptObject(valueMap)):$isCreated_2(this$static)?$setProperty_7(this$static, 'valueMap', convertMapToJavascriptObject(valueMap)):(this$static.jsObj['valueMap'] = convertMapToJavascriptObject(valueMap) , undefined);
}

function $setValueMap_0(this$static, valueMap){
  $isCreated_2(this$static)?$setValueMapMethod(this$static, convertToJavaScriptArray(valueMap)):$isCreated_2(this$static)?$setProperty_7(this$static, 'valueMap', convertToJavaScriptArray(valueMap)):(this$static.jsObj['valueMap'] = convertToJavaScriptArray(valueMap) , undefined);
}

function $setValueMapMethod(this$static, value){
  var self_0 = this$static.getJsObj();
  self_0.setValueMap(value);
}

function $setupBlurEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.blur = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new BlurEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupChangeEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.change = $debox($entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], oldValue:arguments[3]};
    var event_0 = new ChangeEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function $setupFocusEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.focus = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new FocusEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupIconClickEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.iconClick = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], icon:arguments[2]};
    var event_0 = new IconClickEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupItemHoverEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.itemHover = $entry(function(){
    var param = {item:arguments[0], form:arguments[1]};
    var event_0 = new ItemHoverEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $validate_2(this$static){
  var self_0 = this$static.getJsObj();
  var retVal = self_0.validate();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

defineSeed(491, 335, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.addClickHandler = function addClickHandler(handler){
  return $addClickHandler_0(this, handler);
}
;
_.enable_0 = function enable(){
  $setDisabled_2(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
}
;
_.getPrompt = function getPrompt(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'prompt'):getAttribute(this.jsObj, 'prompt');
}
;
_.getShowTitle = function getShowTitle(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.getTitle = function getTitle(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'title'):getAttribute(this.jsObj, 'title');
}
;
_.setDefaultValue = function setDefaultValue(defaultValue){
  $setDefaultValue_0(this, defaultValue);
}
;
_.setDefaultValue_0 = function setDefaultValue_0(defaultValue){
  $setDefaultValue_1(this, defaultValue);
}
;
_.setEndRow = function setEndRow(endRow){
  $setEndRow_0(this, endRow);
}
;
_.setIconVAlign = function setIconVAlign(iconVAlign){
  $setAttribute_30(this, 'iconVAlign', iconVAlign.value_0);
}
;
_.setPrompt = function setPrompt(prompt_0){
  $setPrompt_1(this, prompt_0);
}
;
_.setStartRow = function setStartRow(startRow){
  $setStartRow_0(this, startRow);
}
;
_.setValidateOnChange = function setValidateOnChange(validateOnChange){
  $setValidateOnChange_0(this, validateOnChange);
}
;
_.setValidateOnExit = function setValidateOnExit(validateOnExit){
  $setValidateOnExit_0(this, validateOnExit);
}
;
_.setValue_0 = function setValue(value){
  $setValue_3(this, value);
}
;
_.setValue_1 = function setValue_0(value){
  $setValue_4(this, value);
}
;
_.setValue_2 = function setValue_1(value){
  $setValue_5(this, value);
}
;
_.setValue_3 = function setValue_2(value){
  $setValue_6(this, value);
}
;
_.setValue_4 = function setValue_3(value){
  $setValue_7(this, value);
}
;
_.setValue_5 = function setValue_4(value){
  $setValue_8(this, value);
}
;
_.setValue_6 = function setValue_5(value){
  $setValue_9(this, value);
}
;
_.setValueMap_0 = function setValueMap(valueMap){
  $setValueMap(this, valueMap);
}
;
_.setValueMap_1 = function setValueMap_0(valueMap){
  $setValueMap_0(this, valueMap);
}
;
_.validate_1 = function validate_0(){
  return $validate_2(this);
}
;
function $getValueAsString_0(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $setLength(this$static, length_0){
  setAttribute_8(this$static.jsObj, 'length', length_0);
}

function TextAreaItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

function TextAreaItem_1(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'recipeText'):(this.jsObj['name'] = 'recipeText' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

function TextAreaItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'TextAreaItem'):(this.jsObj['editorType'] = 'TextAreaItem' , undefined);
}

defineSeed(490, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextAreaItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), TextAreaItem_0, TextAreaItem_1, TextAreaItem_2);
_.setIconVAlign = function setIconVAlign_0(iconVAlign){
  $setAttribute_30(this, 'iconVAlign', iconVAlign.value_0);
}
;
_.setWidth = function setWidth_0(width){
  $isCreated_2(this)?$setProperty_6(this, 'width', width):(this.jsObj['width'] = width , undefined);
}
;
function AutoFitTextAreaItem_0(title){
  TextAreaItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'description'):(this.jsObj['name'] = 'description' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'AutoFitTextAreaItem'):(this.jsObj['editorType'] = 'AutoFitTextAreaItem' , undefined);
}

defineSeed(489, 490, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextAreaItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), AutoFitTextAreaItem_0);
function $setPrompt_2(this$static, prompt_0){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'prompt', prompt_0):(this$static.jsObj['prompt'] = prompt_0 , undefined);
}

function CanvasItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'CanvasItem'):(this.jsObj['editorType'] = 'CanvasItem' , undefined);
  $setupCanvasConstructor(this);
}

defineSeed(493, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), CanvasItem_1);
_.getCanvas = function getCanvas(){
  return getOrCreateRef_3($isCreated_2(this)?$getPropertyAsJSO(this, 'canvas'):getAttributeAsJavaScriptObject(this.jsObj, 'canvas'));
}
;
_.getPrompt = function getPrompt_0(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'prompt'):getAttribute(this.jsObj, 'prompt');
}
;
_.setPrompt = function setPrompt_0(prompt_0){
  $setPrompt_2(this, prompt_0);
}
;
function $addClickHandler_1(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26)) == 0 && $setupClickEvent_1(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26));
}

function $setAutoFit_1(this$static, autoFit){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'autoFit', autoFit.value_0):setAttribute_5(this$static.jsObj, 'autoFit', autoFit);
}

function $setEndRow_1(this$static, endRow){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'endRow', endRow.value_0):setAttribute_5(this$static.jsObj, 'endRow', endRow);
}

function $setIcon_2(this$static){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'icon', 'global/upload.png'):(this$static.jsObj['icon'] = 'global/upload.png' , undefined);
}

function $setStartRow_1(this$static, startRow){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'startRow', startRow.value_0):setAttribute_5(this$static.jsObj, 'startRow', startRow);
}

function $setupClickEvent_1(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.click = $entry(function(){
    var param = {form:arguments[0], item:arguments[1]};
    var event_0 = new ClickEvent_2(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function ButtonItem_0(){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'Upload'):(this.jsObj['name'] = 'Upload' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'ButtonItem'):(this.jsObj['editorType'] = 'ButtonItem' , undefined);
}

function ButtonItem_1(name_0, title){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  this.setTitle(title);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'ButtonItem'):(this.jsObj['editorType'] = 'ButtonItem' , undefined);
}

defineSeed(492, 493, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), ButtonItem_1);
_.addClickHandler = function addClickHandler_0(handler){
  return $addClickHandler_1(this, handler);
}
;
_.getCanvas = function getCanvas_0(){
  return getOrCreateRef_4($isCreated_2(this)?$getPropertyAsJSO(this, 'canvas'):getAttributeAsJavaScriptObject(this.jsObj, 'canvas'));
}
;
_.getShowTitle = function getShowTitle_0(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setEndRow = function setEndRow_0(endRow){
  $setEndRow_1(this, endRow);
}
;
_.setStartRow = function setStartRow_0(startRow){
  $setStartRow_1(this, startRow);
}
;
function $getValueAsBoolean(this$static){
  var origValue;
  origValue = dynamicCast($getValue_0(this$static), Q$Boolean);
  return $clinit_Boolean() , !(!($isCreated_2(this$static)?$getPropertyAsBoolean(this$static, 'allowEmptyValue'):getAttributeAsBoolean(this$static.jsObj, 'allowEmptyValue')?TRUE:FALSE).value_0 && !origValue) && origValue.value_0?TRUE:FALSE;
}

function $setLabelAsTitle(this$static, labelAsTitle){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'labelAsTitle', labelAsTitle.value_0):setAttribute_5(this$static.jsObj, 'labelAsTitle', labelAsTitle);
}

function $setShowLabel(this$static, showLabel){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showLabel', showLabel.value_0):setAttribute_5(this$static.jsObj, 'showLabel', showLabel);
}

function $setShowTitle_2(this$static, showTitle){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'showTitle', showTitle.value_0):setAttribute_5(this$static.jsObj, 'showTitle', showTitle);
}

function CheckboxItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

function CheckboxItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

function CheckboxItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'CheckboxItem'):(this.jsObj['editorType'] = 'CheckboxItem' , undefined);
}

defineSeed(494, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CheckboxItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), CheckboxItem_0, CheckboxItem_1, CheckboxItem_2);
_.getShowTitle = function getShowTitle_1(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setShowTitle = function setShowTitle_1(showTitle){
  $setShowTitle_2(this, showTitle);
}
;
function $getEnteredValue(this$static){
  var self_0 = this$static.getJsObj();
  return self_0.getEnteredValue();
}

function $setLength_0(this$static, length_0){
  setAttribute_8(this$static.jsObj, 'length', length_0);
}

function $setSelectOnFocus(this$static, selectOnFocus){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'selectOnFocus', selectOnFocus.value_0):setAttribute_5(this$static.jsObj, 'selectOnFocus', selectOnFocus);
}

defineSeed(496, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getEnteredValue_0 = function getEnteredValue(){
  return $getEnteredValue(this);
}
;
function $clinit_ComboBoxItem(){
  $clinit_ComboBoxItem = nullMethod;
  init_2();
}

function $addDataArrivedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_27 && (TYPE_27 = new GwtEvent$Type_0) , TYPE_27)) == 0 && $setupDataArrivedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_27 && (TYPE_27 = new GwtEvent$Type_0) , TYPE_27));
}

function $getEnteredValue_0(this$static){
  var self_0 = this$static.getJsObj();
  return self_0.getEnteredValue();
}

function $getSelectedRecord(this$static){
  var self_0 = this$static.getJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef(ret);
  retVal == null && (retVal = new ListGridRecord_1(ret));
  return retVal;
}

function $getValueAsString_2(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $setAddUnknownValues(this$static, addUnknownValues){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'addUnknownValues', addUnknownValues.value_0):setAttribute_5(this$static.jsObj, 'addUnknownValues', addUnknownValues);
}

function $setDefaultToFirstOption(this$static, defaultToFirstOption){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'defaultToFirstOption', defaultToFirstOption.value_0):setAttribute_5(this$static.jsObj, 'defaultToFirstOption', defaultToFirstOption);
}

function $setOptionDataSource(this$static, dataSource){
  this$static.jsObj['optionDataSource'] = !dataSource?null:$getOrCreateJsObj(dataSource);
}

function $setPickListWidth(this$static, pickListWidth){
  setAttribute_8(this$static.jsObj, 'pickListWidth', pickListWidth);
}

function $setupDataArrivedEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.dataArrived = $entry(function(){
    var param = {startRow:arguments[0], endRow:arguments[1], data:arguments[2]};
    var event_0 = new DataArrivedEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function ComboBoxItem_0(){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function ComboBoxItem_1(name_0){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function ComboBoxItem_2(name_0, title){
  $clinit_ComboBoxItem();
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'ComboBoxItem'):(this.jsObj['editorType'] = 'ComboBoxItem' , undefined);
}

function init_2(){
  if ($wnd.isc.ComboBoxItem.getPrototype().__getPickListFilterCriteria == null) {
    $wnd.isc.ComboBoxItem.getPrototype().__getPickListFilterCriteria = $wnd.isc.ComboBoxItem.getPrototype().getPickListFilterCriteria;
    $wnd.isc.ComboBoxItem.getPrototype().getPickListFilterCriteria = $entry(function(){
      var jObj = this.__ref;
      if (jObj && instanceOf(jObj, Q$ComboBoxItem)) {
        jObj.setJsObj(this);
        var critJ = jObj.getPickListFilterCriteria_0();
        return critJ == null?{}:critJ.getJsObj();
      }
       else {
        return this.__getPickListFilterCriteria();
      }
    }
    );
  }
}

defineSeed(495, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$ComboBoxItem, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), ComboBoxItem_0, ComboBoxItem_1);
_.getEnteredValue_0 = function getEnteredValue_0(){
  return $getEnteredValue_0(this);
}
;
_.getPickListFilterCriteria_0 = function getPickListFilterCriteria(){
  var self_0 = this.getJsObj();
  var critJS = self_0.__getPickListFilterCriteria();
  return critJS == null?null:new Criteria_1(critJS);
}
;
_.getValueAsString = function getValueAsString_0(){
  return $getValueAsString_2(this);
}
;
function $getValueAsDate(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null?null:toDate(ret.getTime());
}

function $setEndDate_0(this$static, endDate){
  $isCreated_2(this$static)?$setProperty_7(this$static, 'endDate', convertToJavaScriptDate(endDate)):setAttribute_9(this$static.jsObj, 'endDate', endDate);
}

function $setEnforceDate(this$static, enforceDate){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'enforceDate', enforceDate.value_0):setAttribute_5(this$static.jsObj, 'enforceDate', enforceDate);
}

function $setStartDate_0(this$static, startDate){
  $isCreated_2(this$static)?$setProperty_7(this$static, 'startDate', convertToJavaScriptDate(startDate)):setAttribute_9(this$static.jsObj, 'startDate', startDate);
}

function $setUseMask(this$static, useMask){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'useMask', useMask.value_0):setAttribute_5(this$static.jsObj, 'useMask', useMask);
}

function $setUseTextField(this$static, useTextField){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'useTextField', useTextField.value_0):setAttribute_5(this$static.jsObj, 'useTextField', useTextField);
}

function DateItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'DateItem'):(this.jsObj['editorType'] = 'DateItem' , undefined);
}

defineSeed(497, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
function $setUseTextField_0(this$static, useTextField){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'useTextField', useTextField.value_0):setAttribute_5(this$static.jsObj, 'useTextField', useTextField);
}

function DateTimeItem_0(name_0){
  DateItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'DateTimeItem'):(this.jsObj['editorType'] = 'DateTimeItem' , undefined);
}

function DateTimeItem_1(name_0, title){
  DateItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'DateTimeItem'):(this.jsObj['editorType'] = 'DateTimeItem' , undefined);
}

defineSeed(499, 497, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$DateTimeItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), DateTimeItem_0, DateTimeItem_1);
function FloatItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'type', 'float'):(this.jsObj['type'] = 'float' , undefined);
}

defineSeed(500, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), FloatItem_0);
function $addFormItemClickHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29)) == 0 && $setupFormItemClickEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_29 && (TYPE_29 = new GwtEvent$Type_0) , TYPE_29));
}

function $setHeight_2(this$static, height){
  setAttribute_8(this$static.jsObj, 'height', height);
}

function $setWidth_4(this$static, width){
  setAttribute_8(this$static.jsObj, 'width', width);
}

function $setupFormItemClickEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.click = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], icon:arguments[2]};
    var event_0 = new FormItemIconClickEvent_0(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function FormItemIcon_1(jsObj){
  this.jsObj = jsObj;
}

defineSeed(502, 330, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$FormItemIcon, Q$HasFormItemClickHandlers]), FormItemIcon_1);
function HeaderItem_1(title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'header'):(this.jsObj['name'] = 'header' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'HeaderItem'):(this.jsObj['editorType'] = 'HeaderItem' , undefined);
}

defineSeed(503, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), HeaderItem_1);
_.getShowTitle = function getShowTitle_2(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setDefaultValue_0 = function setDefaultValue_1(defaultValue){
  $isCreated_2(this)?$setProperty_8(this, 'defaultValue', defaultValue):(this.jsObj['defaultValue'] = defaultValue , undefined);
}
;
_.setEndRow = function setEndRow_1(endRow){
  $isCreated_2(this)?$setProperty_9(this, 'endRow', endRow.value_0):setAttribute_5(this.jsObj, 'endRow', endRow);
}
;
_.setStartRow = function setStartRow_1(startRow){
  $isCreated_2(this)?$setProperty_9(this, 'startRow', startRow.value_0):setAttribute_5(this.jsObj, 'startRow', startRow);
}
;
defineSeed(504, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getShowTitle = function getShowTitle_3(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
defineSeed(506, 493, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
function IPickTreeItem_0(title){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'PickTreeItem'):(this.jsObj['editorType'] = 'PickTreeItem' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'type'):(this.jsObj['name'] = 'type' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'IPickTreeItem'):(this.jsObj['editorType'] = 'IPickTreeItem' , undefined);
}

defineSeed(505, 506, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), IPickTreeItem_0);
function IntegerItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'type', 'integer'):(this.jsObj['type'] = 'integer' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'TextItem'):(this.jsObj['editorType'] = 'TextItem' , undefined);
}

function IntegerItem_1(title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'value'):(this.jsObj['name'] = 'value' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'type', 'integer'):(this.jsObj['type'] = 'integer' , undefined);
}

defineSeed(507, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$IntegerItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), IntegerItem_0, IntegerItem_1);
function $setEscapeHTML(this$static, escapeHTML){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'escapeHTML', escapeHTML.value_0):setAttribute_5(this$static.jsObj, 'escapeHTML', escapeHTML);
}

function $setTextBoxStyle(this$static){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'textBoxStyle', null):(this$static.jsObj['textBoxStyle'] = null , undefined);
}

function $setWrap_1(this$static, wrap){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.jsObj, 'wrap', wrap);
}

function StaticTextItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'StaticTextItem'):(this.jsObj['editorType'] = 'StaticTextItem' , undefined);
}

function StaticTextItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'StaticTextItem'):(this.jsObj['editorType'] = 'StaticTextItem' , undefined);
}

defineSeed(509, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$StaticTextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), StaticTextItem_0, StaticTextItem_1);
function $addClickHandler_2(this$static, handler){
  $isCreated_2(this$static)?$setProperty_8(this$static, 'target', 'javascript'):(this$static.jsObj['target'] = 'javascript' , undefined);
  return $getHandlerCount_0(this$static, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26)) == 0 && $setupClickEvent_0(this$static) , $doAddHandler(this$static, handler, (!TYPE_26 && (TYPE_26 = new GwtEvent$Type_0) , TYPE_26));
}

function LinkItem_0(){
  StaticTextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'LinkItem'):(this.jsObj['editorType'] = 'LinkItem' , undefined);
}

function LinkItem_1(name_0){
  StaticTextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'LinkItem'):(this.jsObj['editorType'] = 'LinkItem' , undefined);
}

defineSeed(508, 509, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$StaticTextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), LinkItem_0, LinkItem_1);
_.addClickHandler = function addClickHandler_1(handler){
  return $addClickHandler_2(this, handler);
}
;
function PasswordItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'PasswordItem'):(this.jsObj['editorType'] = 'PasswordItem' , undefined);
}

function PasswordItem_1(name_0){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'PasswordItem'):(this.jsObj['editorType'] = 'PasswordItem' , undefined);
}

defineSeed(510, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$PasswordItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), PasswordItem_0, PasswordItem_1);
function $getValueAsString_3(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $setVertical_0(this$static, vertical){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'vertical', vertical.value_0):setAttribute_5(this$static.jsObj, 'vertical', vertical);
}

function $setWrap_2(this$static, wrap){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'wrap', wrap.value_0):setAttribute_5(this$static.jsObj, 'wrap', wrap);
}

function RadioGroupItem_0(){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

function RadioGroupItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

function RadioGroupItem_2(name_0, title){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'RadioGroupItem'):(this.jsObj['editorType'] = 'RadioGroupItem' , undefined);
}

defineSeed(511, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$RadioGroupItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), RadioGroupItem_0, RadioGroupItem_1, RadioGroupItem_2);
function getAbsoluteDate_0(relativeDate){
  var retVal = $wnd.isc.RelativeDateItem.getAbsoluteDate(relativeDate.getValue_0());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toDate(retVal.getTime());
  }
}

function SpacerItem_1(name_0){
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SpacerItem'):(this.jsObj['editorType'] = 'SpacerItem' , undefined);
}

defineSeed(514, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpacerItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SpacerItem_1);
_.getShowTitle = function getShowTitle_4(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
defineSeed(513, 514, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpacerItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getShowTitle = function getShowTitle_5(){
  return $isCreated_2(this)?$getPropertyAsBoolean(this, 'showTitle'):($clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'showTitle')?TRUE:FALSE);
}
;
_.setEndRow = function setEndRow_2(endRow){
  $isCreated_2(this)?$setProperty_9(this, 'endRow', endRow.value_0):setAttribute_5(this.jsObj, 'endRow', endRow);
}
;
_.setStartRow = function setStartRow_2(startRow){
  $isCreated_2(this)?$setProperty_9(this, 'startRow', startRow.value_0):setAttribute_5(this.jsObj, 'startRow', startRow);
}
;
function SectionItem_0(name_0){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SectionItem'):(this.jsObj['editorType'] = 'SectionItem' , undefined);
}

defineSeed(515, 493, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SectionItem_0);
function $clinit_SelectItem(){
  $clinit_SelectItem = nullMethod;
  init_3();
}

function $fetchData_2(this$static){
  var self_0 = this$static.getJsObj();
  self_0.fetchData();
}

function $getValueAsString_4(this$static){
  var self_0 = this$static.getJsObj();
  var ret;
  self_0.setValue?(ret = self_0.getValue()):(ret = self_0.value);
  return ret == null || ret === undefined?null:ret.toString();
}

function $getValues(this$static){
  var self_0 = this$static.getJsObj();
  var value;
  self_0.getValue?(value = self_0.getValue()):(value = self_0.value);
  value == null?(value = []):!$wnd.isc.isA.Array(value) && (value = [value]);
  return convertToJavaStringArray(value);
}

function $setAllowEmptyValue(this$static, allowEmptyValue){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'allowEmptyValue', allowEmptyValue.value_0):setAttribute_5(this$static.jsObj, 'allowEmptyValue', allowEmptyValue);
}

function $setDefaultToFirstOption_0(this$static, defaultToFirstOption){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'defaultToFirstOption', defaultToFirstOption.value_0):setAttribute_5(this$static.jsObj, 'defaultToFirstOption', defaultToFirstOption);
}

function $setMultiple(this$static, multiple){
  $isCreated_2(this$static)?$setProperty_9(this$static, 'multiple', multiple.value_0):setAttribute_5(this$static.jsObj, 'multiple', multiple);
}

function $setOptionDataSource_0(this$static, dataSource){
  this$static.jsObj['optionDataSource'] = !dataSource?null:$getOrCreateJsObj(dataSource);
}

function $setValues(this$static, values){
  var self_0 = this$static.getJsObj();
  var valuesJS = convertToJavaScriptArray(values);
  self_0.setValue?self_0.setValue(valuesJS):(self_0.value = valuesJS);
}

function SelectItem_0(){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function SelectItem_1(name_0){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function SelectItem_2(name_0, title){
  $clinit_SelectItem();
  FormItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SelectItem'):(this.jsObj['editorType'] = 'SelectItem' , undefined);
}

function init_3(){
  if ($wnd.isc.SelectItem.getPrototype().__getPickListFilterCriteria == null) {
    $wnd.isc.SelectItem.getPrototype().__getPickListFilterCriteria = $wnd.isc.SelectItem.getPrototype().getPickListFilterCriteria;
    $wnd.isc.SelectItem.getPrototype().getPickListFilterCriteria = $entry(function(){
      var jObj = this.__ref;
      if (jObj && instanceOf(jObj, Q$SelectItem)) {
        jObj.setJsObj(this);
        var critJ = jObj.getPickListFilterCriteria_0();
        return critJ == null?{}:critJ.getJsObj();
      }
       else {
        return this.__getPickListFilterCriteria();
      }
    }
    );
  }
}

defineSeed(516, 491, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SelectItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SelectItem_0, SelectItem_1, SelectItem_2);
_.getPickListFilterCriteria_0 = function getPickListFilterCriteria_0(){
  var self_0 = this.getJsObj();
  var critJS = self_0.__getPickListFilterCriteria();
  return critJS == null?null:new Criteria_1(critJS);
}
;
_.setValues = function setValues(values){
  $setValues(this, values);
}
;
function SliderItem_0(){
  CanvasItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', 'exceptionItem'):(this.jsObj['name'] = 'exceptionItem' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', 'Exception Depth'):(this.jsObj['title'] = 'Exception Depth' , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SliderItem'):(this.jsObj['editorType'] = 'SliderItem' , undefined);
}

defineSeed(517, 493, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SliderItem_0);
function $setDefaultValue_2(this$static, defaultValue){
  setAttribute_8(this$static.jsObj, 'defaultValue', defaultValue);
}

function $setMax(this$static, max){
  setAttribute_8(this$static.jsObj, 'max', max);
}

function $setMin(this$static, min){
  setAttribute_8(this$static.jsObj, 'min', min);
}

function $setStep(this$static){
  $isCreated_2(this$static)?$setProperty_6(this$static, 'step', 1):(this$static.jsObj['step'] = 1 , undefined);
}

function SpinnerItem_0(){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SpinnerItem'):(this.jsObj['editorType'] = 'SpinnerItem' , undefined);
}

function SpinnerItem_1(name_0, title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'SpinnerItem'):(this.jsObj['editorType'] = 'SpinnerItem' , undefined);
}

defineSeed(518, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$SpinnerItem, Q$TextItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), SpinnerItem_0, SpinnerItem_1);
_.setDefaultValue = function setDefaultValue_2(defaultValue){
  $setDefaultValue_2(this, defaultValue);
}
;
defineSeed(519, 492, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$CanvasItem, Q$FormItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]));
_.getTitle = function getTitle_0(){
  return $isCreated_2(this)?$getPropertyAsString(this, 'title'):getAttribute(this.jsObj, 'title');
}
;
function UploadItem_0(name_0, title){
  TextItem_0.call(this);
  $isCreated_2(this)?$setProperty_8(this, 'name', name_0):(this.jsObj['name'] = name_0 , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'title', title):(this.jsObj['title'] = title , undefined);
  $isCreated_2(this)?$setProperty_8(this, 'editorType', 'UploadItem'):(this.jsObj['editorType'] = 'UploadItem' , undefined);
}

defineSeed(520, 496, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$FormItem, Q$TextItem, Q$UploadItem, Q$HasBlurHandlers, Q$HasChangeHandlers, Q$HasChangedHandlers, Q$HasClickHandlers_0, Q$HasDoubleClickHandlers_0, Q$HasFocusHandlers, Q$HasIconClickHandlers_0, Q$HasIconKeyPressHandlers, Q$HasItemHoverHandlers, Q$HasKeyDownHandlers_0, Q$HasKeyPressHandlers_0, Q$HasKeyUpHandlers, Q$HasTitleClickHandlers, Q$HasTitleDoubleClickHandlers, Q$HasTitleHoverHandlers]), UploadItem_0);
function $getItem(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_6(jsObj.item);
}

function BlurEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(521, 356, {}, BlurEvent_0);
_.dispatch = function dispatch_23(handler){
  dynamicCast(handler, Q$BlurHandler).onBlur(this);
}
;
_.getAssociatedType = function getAssociatedType_23(){
  return TYPE_23;
}
;
var TYPE_23 = null;
function $getValue_1(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangeEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(522, 356, {}, ChangeEvent_0);
_.dispatch = function dispatch_24(handler){
  dynamicCast(handler, Q$ChangeHandler).onChange(this);
}
;
_.getAssociatedType = function getAssociatedType_24(){
  return TYPE_24;
}
;
_.isCancelled = function isCancelled_11(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_24 = null;
function $getItem_0(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_6(jsObj.item);
}

function $getValue_2(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function DataArrivedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(525, 356, {}, DataArrivedEvent_0);
_.dispatch = function dispatch_27(handler){
  $onDataArrived(dynamicCast(handler, Q$DataArrivedHandler));
}
;
_.getAssociatedType = function getAssociatedType_27(){
  return TYPE_27;
}
;
var TYPE_27 = null;
function $dispatch_5(handler){
  $handleFocusChange(handler.this$0, handler.val$valueItem, handler.val$unsetItem);
}

function FocusEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(526, 356, {}, FocusEvent_0);
_.dispatch = function dispatch_28(handler){
  $dispatch_5(dynamicCast(handler, Q$FocusHandler));
}
;
_.getAssociatedType = function getAssociatedType_28(){
  return TYPE_28;
}
;
var TYPE_28 = null;
function FormItemIconClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(527, 356, {}, FormItemIconClickEvent_0);
_.dispatch = function dispatch_29(handler){
  dynamicCast(handler, Q$FormItemClickHandler).onFormItemClick(this);
}
;
_.getAssociatedType = function getAssociatedType_29(){
  return TYPE_29;
}
;
var TYPE_29 = null;
function $getIcon_0(this$static){
  var jsObj = this$static.jsObj;
  return new FormItemIcon_1(jsObj.icon);
}

function IconClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(528, 356, {}, IconClickEvent_0);
_.dispatch = function dispatch_30(handler){
  dynamicCast(handler, Q$IconClickHandler).onIconClick(this);
}
;
_.getAssociatedType = function getAssociatedType_30(){
  return TYPE_30;
}
;
var TYPE_30 = null;
function ItemHoverEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(529, 356, {}, ItemHoverEvent_0);
_.dispatch = function dispatch_31(handler){
  $onItemHover(dynamicCast(handler, Q$ItemHoverHandler));
}
;
_.getAssociatedType = function getAssociatedType_31(){
  return TYPE_31;
}
;
var TYPE_31 = null;
function $setup(this$static, jsObj){
  var self_0 = this$static;
  jsObj.condition = function(item, validator, value, record){
    var ref;
    if ($wnd.isc.isA.FormItem(item)) {
      self_0.formItem = getFormItem(item);
    }
     else {
      if (item.__ref && (ref = getAttributeAsObject(item, '__ref') , ref != null && instanceOf(ref, Q$DataSourceField))) {
        self_0.dataSourceField = getOrCreateRef_0(item);
      }
       else {
        var dataSourceField = $wnd.isc.addProperties({}, item);
        dataSourceField.__ref && delete dataSourceField.__ref;
        self_0.dataSourceField = new DataSourceField_0(dataSourceField);
      }
    }
    validator && (self_0.validatorProperties = convertToMap(validator));
    record != null && (self_0.record_0 = getOrCreateRef_1(record));
    var valueJ = $wnd.SmartGWT.convertToJavaType(value);
    var ret = self_0.condition_1(valueJ);
    var jsValidatorDefinition = self_0.getJsObj();
    var resultingValue = self_0.resultingValue_0;
    resultingValue != null && validator && (validator.resultingValue = $wnd.SmartGWT.convertToPrimitiveType(resultingValue));
    if (validator && validator != jsValidatorDefinition && jsValidatorDefinition.errorMessage != null) {
      validator.errorMessage = jsValidatorDefinition.errorMessage;
      jsValidatorDefinition.errorMessage = null;
    }
    self_0.reset_0();
    return ret;
  }
  ;
}

function CustomValidator_0(){
  Validator_0.call(this);
  this.validatorProperties = new HashMap_0;
  this.jsObj['type'] = 'custom';
  $setup(this, this.jsObj);
}

defineSeed(532, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]));
_.reset_0 = function reset(){
  this.formItem = null;
  this.dataSourceField = null;
  this.record_0 = null;
  this.validatorProperties.clear_0();
  this.resultingValue_0 = null;
}
;
_.dataSourceField = null;
_.formItem = null;
_.record_0 = null;
_.resultingValue_0 = null;
function FloatRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'floatRange';
}

defineSeed(534, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), FloatRangeValidator_0);
function IntegerRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'integerRange';
}

defineSeed(535, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IntegerRangeValidator_0);
function IsFloatValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'isFloat';
}

defineSeed(536, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IsFloatValidator_0);
function IsIntegerValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'isInteger';
}

defineSeed(537, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), IsIntegerValidator_0);
function $setMax_0(this$static, max){
  setAttribute_8(this$static.jsObj, 'max', max);
}

function $setMin_0(this$static, min){
  setAttribute_8(this$static.jsObj, 'min', min);
}

function LengthRangeValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'lengthRange';
}

defineSeed(538, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), LengthRangeValidator_0);
function MatchesFieldValidator_0(){
  Validator_0.call(this);
  this.jsObj['type'] = 'matchesField';
}

defineSeed(539, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), MatchesFieldValidator_0);
function RegExpValidator_1(expression){
  RegExpValidator_0.call(this);
  this.jsObj['expression'] = expression;
}

defineSeed(540, 533, makeCastMap([Q$DataClass, Q$JsObject, Q$Validator]), RegExpValidator_1);
function $addCellClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_34 && (TYPE_34 = new GwtEvent$Type_0) , TYPE_34)) == 0 && $setupCellClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_34 && (TYPE_34 = new GwtEvent$Type_0) , TYPE_34));
}

function $addData_0(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.addData(recordJS);
}

function $addFieldStateChangedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_38 && (TYPE_38 = new GwtEvent$Type_0) , TYPE_38)) == 0 && $setupFieldStateChangedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_38 && (TYPE_38 = new GwtEvent$Type_0) , TYPE_38));
}

function $addRecordCollapseHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_40 && (TYPE_40 = new GwtEvent$Type_0) , TYPE_40)) == 0 && $setupRecordCollapseEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_40 && (TYPE_40 = new GwtEvent$Type_0) , TYPE_40));
}

function $addRecordExpandHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_43 && (TYPE_43 = new GwtEvent$Type_0) , TYPE_43)) == 0 && $setupRecordExpandEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_43 && (TYPE_43 = new GwtEvent$Type_0) , TYPE_43));
}

function $addRowEditorExitHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_44 && (TYPE_44 = new GwtEvent$Type_0) , TYPE_44)) == 0 && $setupRowEditorExitEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_44 && (TYPE_44 = new GwtEvent$Type_0) , TYPE_44));
}

function $anySelected(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.anySelected();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $deselectRecord(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.deselectRecord(recordJS);
}

function $getCriteria_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getCriteria();
  if (ret == null || ret === undefined)
    return null;
  return new Criteria_1(ret);
}

function $getFieldName(this$static, colNum){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getFieldName(colNum);
}

function $getViewState(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getViewState();
}

function $hasErrors_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.hasErrors();
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isSelected(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isSelected(record.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $removeSelectedData(this$static, callback, requestProperties){
  var self_0 = this$static.getOrCreateJsObj();
  var requestPropertiesJS = requestProperties == null?null:requestProperties.getJsObj();
  self_0.removeSelectedData($entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ), requestPropertiesJS);
}

function $selectAllRecords(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.selectAllRecords();
}

function $setAutoFetchData_0(this$static, autoFetchData){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFetchData', autoFetchData);
}

function $setAutoFitFieldWidths(this$static, autoFitFieldWidths){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'autoFitFieldWidths', autoFitFieldWidths);
}

function $setCanEdit(this$static, canEdit){
  $isCreated_1(this$static)?!canEdit?$setNullProperty(this$static, 'canEdit'):$setProperty_4(this$static, 'canEdit', canEdit.value_0):setAttribute_5(this$static.config_0, 'canEdit', canEdit);
}

function $setCanExpandMultipleRecords(this$static, canExpandMultipleRecords){
  $isCreated_1(this$static)?!canExpandMultipleRecords?$setNullProperty(this$static, 'canExpandMultipleRecords'):$setProperty_4(this$static, 'canExpandMultipleRecords', canExpandMultipleRecords.value_0):setAttribute_5(this$static.config_0, 'canExpandMultipleRecords', canExpandMultipleRecords);
}

function $setCanExpandRecords(this$static, canExpandRecords){
  $isCreated_1(this$static)?!canExpandRecords?$setNullProperty(this$static, 'canExpandRecords'):$setProperty_4(this$static, 'canExpandRecords', canExpandRecords.value_0):setAttribute_5(this$static.config_0, 'canExpandRecords', canExpandRecords);
}

function $setCanHover(this$static, canHover){
  $isCreated_1(this$static)?!canHover?$setNullProperty(this$static, 'canHover'):$setProperty_4(this$static, 'canHover', canHover.value_0):setAttribute_5(this$static.config_0, 'canHover', canHover);
}

function $setEditByCell(this$static, editByCell){
  $isCreated_1(this$static)?!editByCell?$setNullProperty(this$static, 'editByCell'):$setProperty_4(this$static, 'editByCell', editByCell.value_0):setAttribute_5(this$static.config_0, 'editByCell', editByCell);
}

function $setEditValue(this$static, rowNum, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setEditValue(rowNum, fieldName, value);
}

function $setEditValue_0(this$static, rowNum, fieldName, value){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setEditValue(rowNum, fieldName, value);
}

function $setFields_1(this$static, fields){
  $isCreated_1(this$static)?$setProperty_2(this$static, 'fields', convertToJavaScriptArray(fields)):(this$static.config_0['fields'] = convertToJavaScriptArray(fields) , undefined);
}

function $setFixedRecordHeights(this$static, fixedRecordHeights){
  $isCreated_1(this$static)?!fixedRecordHeights?$setNullProperty(this$static, 'fixedRecordHeights'):$setProperty_4(this$static, 'fixedRecordHeights', fixedRecordHeights.value_0):setAttribute_5(this$static.config_0, 'fixedRecordHeights', fixedRecordHeights);
}

function $setHoverCustomizer(this$static, hoverCustomizer){
  var self_0;
  this$static.isCreated()?(self_0 = this$static.getJsObj()):(self_0 = this$static.getConfig());
  self_0.cellHoverHTML = $debox($entry(function(record, rowNum, colNum){
    var recordJ = getOrCreateRef_8(record);
    var valueJ = null;
    return hoverCustomizer.hoverHTML_0(valueJ, recordJ, rowNum, colNum);
  }
  ));
}

function $setLeaveScrollbarGap(this$static, leaveScrollbarGap){
  $isCreated_1(this$static)?!leaveScrollbarGap?$setNullProperty(this$static, 'leaveScrollbarGap'):$setProperty_4(this$static, 'leaveScrollbarGap', leaveScrollbarGap.value_0):setAttribute_5(this$static.config_0, 'leaveScrollbarGap', leaveScrollbarGap);
}

function $setLoadingDataMessage(this$static){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'loadingDataMessage', null):(this$static.config_0['loadingDataMessage'] = null , undefined);
}

function $setLoadingMessage(this$static, loadingMessage){
  $isCreated_1(this$static)?undefined:(this$static.config_0['loadingMessage'] = loadingMessage , undefined);
}

function $setRecords(this$static, records){
  $isCreated_1(this$static)?$setProperty_2(this$static, 'data', convertToJavaScriptArray(records)):(this$static.config_0['data'] = convertToJavaScriptArray(records) , undefined);
}

function $setResizeFieldsInRealTime(this$static, resizeFieldsInRealTime){
  $isCreated_1(this$static)?!resizeFieldsInRealTime?$setNullProperty(this$static, 'resizeFieldsInRealTime'):$setProperty_4(this$static, 'resizeFieldsInRealTime', resizeFieldsInRealTime.value_0):setAttribute_5(this$static.config_0, 'resizeFieldsInRealTime', resizeFieldsInRealTime);
}

function $setShowAllRecords(this$static, showAllRecords){
  $isCreated_1(this$static)?!showAllRecords?$setNullProperty(this$static, 'showAllRecords'):$setProperty_4(this$static, 'showAllRecords', showAllRecords.value_0):setAttribute_5(this$static.config_0, 'showAllRecords', showAllRecords);
}

function $setShowEmptyMessage(this$static, showEmptyMessage){
  $isCreated_1(this$static)?!showEmptyMessage?$setNullProperty(this$static, 'showEmptyMessage'):$setProperty_4(this$static, 'showEmptyMessage', showEmptyMessage.value_0):setAttribute_5(this$static.config_0, 'showEmptyMessage', showEmptyMessage);
}

function $setShowHover(this$static, showHover){
  $isCreated_1(this$static)?!showHover?$setNullProperty(this$static, 'showHover'):$setProperty_4(this$static, 'showHover', showHover.value_0):setAttribute_5(this$static.config_0, 'showHover', showHover);
}

function $setShowRecordComponents(this$static, showRecordComponents){
  $isCreated_1(this$static)?!showRecordComponents?$setNullProperty(this$static, 'showRecordComponents'):$setProperty_4(this$static, 'showRecordComponents', showRecordComponents.value_0):setAttribute_5(this$static.config_0, 'showRecordComponents', showRecordComponents);
}

function $setShowRecordComponentsByCell(this$static, showRecordComponentsByCell){
  $isCreated_1(this$static)?!showRecordComponentsByCell?$setNullProperty(this$static, 'showRecordComponentsByCell'):$setProperty_4(this$static, 'showRecordComponentsByCell', showRecordComponentsByCell.value_0):setAttribute_5(this$static.config_0, 'showRecordComponentsByCell', showRecordComponentsByCell);
  showRecordComponentsByCell.value_0 && $setAttribute_24(this$static, 'recordComponentPosition', ($clinit_EmbeddedPosition() , WITHIN).value_0, true);
}

function $setShowRollOver_2(this$static, showRollOver){
  $isCreated_1(this$static)?!showRollOver?$setNullProperty(this$static, 'showRollOver'):$setProperty_4(this$static, 'showRollOver', showRollOver.value_0):setAttribute_5(this$static.config_0, 'showRollOver', showRollOver);
}

function $setSort(this$static, sortSpecifiers){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setSort(convertToJavaScriptArray(sortSpecifiers));
}

function $setSortDirection(this$static, sortDirection){
  !sortDirection?$isCreated_1(this$static)?$setNullProperty(this$static, 'sortDirection'):setAttribute_5(this$static.config_0, 'sortDirection', null):$setAttribute_22(this$static, 'sortDirection', ($clinit_Boolean() , sortDirection == ($clinit_SortDirection() , ASCENDING)?TRUE:FALSE), true);
}

function $setSortField(this$static){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'sortField', 'name'):(this$static.config_0['sortField'] = 'name' , undefined);
}

function $setUseAllDataSourceFields(this$static, useAllDataSourceFields){
  $isCreated_1(this$static)?!useAllDataSourceFields?$setNullProperty(this$static, 'useAllDataSourceFields'):$setProperty_4(this$static, 'useAllDataSourceFields', useAllDataSourceFields.value_0):setAttribute_5(this$static.config_0, 'useAllDataSourceFields', useAllDataSourceFields);
}

function $setViewState(this$static, viewState){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setViewState(viewState);
}

function $setWrapCells(this$static, wrapCells){
  $isCreated_1(this$static)?!wrapCells?$setNullProperty(this$static, 'wrapCells'):$setProperty_4(this$static, 'wrapCells', wrapCells.value_0):setAttribute_5(this$static.config_0, 'wrapCells', wrapCells);
}

function $setupCellClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({cellClick:$debox($entry(function(){
      var param = {record:arguments[0], rowNum:arguments[1], colNum:arguments[2]};
      var event_0 = new CellClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.cellClick = $debox($entry(function(){
      var param = {record:arguments[0], rowNum:arguments[1], colNum:arguments[2]};
      var event_0 = new CellClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupFieldStateChangedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({fieldStateChanged:$entry(function(){
      var param = {};
      var event_0 = new FieldStateChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.fieldStateChanged = $entry(function(){
      var param = {};
      var event_0 = new FieldStateChangedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupRecordCollapseEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onCollapseRecord:$debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordCollapseEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onCollapseRecord = $debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordCollapseEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRecordDropEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onRecordDrop:$debox($entry(function(){
      var param = {dropRecords:arguments[0], targetRecord:arguments[1], index:arguments[2], sourceWidget:arguments[3]};
      var event_0 = new RecordDropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onRecordDrop = $debox($entry(function(){
      var param = {dropRecords:arguments[0], targetRecord:arguments[1], index:arguments[2], sourceWidget:arguments[3]};
      var event_0 = new RecordDropEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRecordExpandEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onExpandRecord:$debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordExpandEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onExpandRecord = $debox($entry(function(){
      var param = {record:arguments[0]};
      var event_0 = new RecordExpandEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupRowEditorExitEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({rowEditorExit:$debox($entry(function(){
      var param = {editCompletionEvent:arguments[0], record:arguments[1], newValues:arguments[2], rowNum:arguments[3]};
      var event_0 = new RowEditorExitEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.rowEditorExit = $debox($entry(function(){
      var param = {editCompletionEvent:arguments[0], record:arguments[1], newValues:arguments[2], rowNum:arguments[3]};
      var event_0 = new RowEditorExitEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $showField(this$static, fieldName){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.showField(fieldName);
}

function $sort(this$static, sortField, sortDirection){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.sort(sortField, sortDirection.getValue_0());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $updateData(this$static, record){
  var self_0 = this$static.getOrCreateJsObj();
  var recordJS = record.getJsObj();
  self_0.updateData(recordJS);
}

function $validateRow(this$static, rowNum){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.validateRow(rowNum);
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

defineSeed(542, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]));
_.addRecordDropHandler = function addRecordDropHandler(handler){
  $getHandlerCount_1(this, (!TYPE_42 && (TYPE_42 = new GwtEvent$Type_0) , TYPE_42)) == 0 && $setupRecordDropEvent(this);
  return $doAddHandler_0(this, handler, (!TYPE_42 && (TYPE_42 = new GwtEvent$Type_0) , TYPE_42));
}
;
_.getRecords = function getRecords(){
  return getOrCreateRef_13($getAttributeAsJavaScriptObject_1(this, 'groupTree'))?convertToListGridRecordArray($getAttributeAsJavaScriptObject_1(this, 'originalData')):convertToListGridRecordArray($getAttributeAsJavaScriptObject_1(this, 'data'));
}
;
_.getSelectedRecord_0 = function getSelectedRecord(){
  var self_0 = this.getOrCreateJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getRef(ret);
  retVal == null && (retVal = new ListGridRecord_1(ret));
  return retVal;
}
;
_.setCanAcceptDroppedRecords = function setCanAcceptDroppedRecords(canAcceptDroppedRecords){
  $isCreated_1(this)?!canAcceptDroppedRecords?$setNullProperty(this, 'canAcceptDroppedRecords'):$setProperty_4(this, 'canAcceptDroppedRecords', canAcceptDroppedRecords.value_0):setAttribute_5(this.config_0, 'canAcceptDroppedRecords', canAcceptDroppedRecords);
}
;
_.setCanDragRecordsOut = function setCanDragRecordsOut(canDragRecordsOut){
  $isCreated_1(this)?!canDragRecordsOut?$setNullProperty(this, 'canDragRecordsOut'):$setProperty_4(this, 'canDragRecordsOut', canDragRecordsOut.value_0):setAttribute_5(this.config_0, 'canDragRecordsOut', canDragRecordsOut);
}
;
_.setCanReorderRecords = function setCanReorderRecords(canReorderRecords){
  $isCreated_1(this)?!canReorderRecords?$setNullProperty(this, 'canReorderRecords'):$setProperty_4(this, 'canReorderRecords', canReorderRecords.value_0):setAttribute_5(this.config_0, 'canReorderRecords', canReorderRecords);
}
;
_.setData = function setData(data){
  $isCreated_1(this)?$setProperty_2(this, 'data', convertToJavaScriptArray(data)):(this.config_0['data'] = convertToJavaScriptArray(data) , undefined);
}
;
function $addChangeHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_35 && (TYPE_35 = new GwtEvent$Type_0) , TYPE_35)) == 0 && $setupChangeEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_35 && (TYPE_35 = new GwtEvent$Type_0) , TYPE_35));
}

function $addChangedHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_36 && (TYPE_36 = new GwtEvent$Type_0) , TYPE_36)) == 0 && $setupChangedEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_36 && (TYPE_36 = new GwtEvent$Type_0) , TYPE_36));
}

function $addRecordClickHandler_0(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_39 && (TYPE_39 = new GwtEvent$Type_0) , TYPE_39)) == 0 && $setupRecordClickEvent_0(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_39 && (TYPE_39 = new GwtEvent$Type_0) , TYPE_39));
}

function $setEditorType(this$static, editorType){
  var editorConfig, fiEditorType;
  if (!$equals_6(editorType.___clazz$.typeName, Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit.typeName)) {
    fiEditorType = $isCreated_2(editorType)?$getPropertyAsString(editorType, 'editorType'):getAttribute(editorType.jsObj, 'editorType');
    fiEditorType == null && (fiEditorType = $isCreated_2(editorType)?$getPropertyAsString(editorType, 'type'):getAttribute(editorType.jsObj, 'type'));
    fiEditorType != null && (this$static.jsObj['editorType'] = fiEditorType , undefined);
  }
  editorConfig = $getConfig(editorType);
  this$static.jsObj['editorProperties'] = editorConfig;
}

function $setFilterEditorType(this$static, filterEditorType){
  var editorConfig, type;
  type = $isCreated_2(filterEditorType)?$getPropertyAsString(filterEditorType, 'editorType'):getAttribute(filterEditorType.jsObj, 'editorType');
  type == null && (type = $isCreated_2(filterEditorType)?$getPropertyAsString(filterEditorType, 'type'):getAttribute(filterEditorType.jsObj, 'type'));
  this$static.jsObj['filterEditorType'] = type;
  editorConfig = $getConfig(filterEditorType);
  this$static.jsObj['filterEditorProperties'] = editorConfig;
}

function $setIconHeight_1(this$static, iconHeight){
  setAttribute_8(this$static.jsObj, 'iconHeight', iconHeight);
}

function $setIconWidth_1(this$static, iconWidth){
  setAttribute_8(this$static.jsObj, 'iconWidth', iconWidth);
}

function $setValueIconHeight_0(this$static, valueIconHeight){
  setAttribute_8(this$static.jsObj, 'valueIconHeight', valueIconHeight);
}

function $setValueIconSize(this$static, valueIconSize){
  setAttribute_8(this$static.jsObj, 'valueIconSize', valueIconSize);
}

function $setValueIconWidth_0(this$static, valueIconWidth){
  setAttribute_8(this$static.jsObj, 'valueIconWidth', valueIconWidth);
}

function $setupChangeEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.change = $debox($entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], oldValue:arguments[3], sourceJSO:this};
    var event_0 = new ChangeEvent_2(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function $setupChangedEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.changed = $entry(function(){
    var param = {form:arguments[0], item:arguments[1], value:arguments[2], sourceJSO:this};
    var event_0 = new ChangedEvent_2(param);
    selfJ.fireEvent(event_0);
  }
  );
}

function $setupRecordClickEvent_0(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.recordClick = $debox($entry(function(){
    var param = {viewer:arguments[0], record:arguments[1], recordNum:arguments[2], field:arguments[3], fieldNum:arguments[4], value:arguments[5], rawValue:arguments[6]};
    var event_0 = new RecordClickEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function ListGridField_2(name_0, width){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  this.jsObj['width'] = width;
}

function ListGridField_4(name_0, title, width){
  DataClass_0.call(this);
  this.jsObj['name'] = name_0;
  this.jsObj['title'] = title;
  this.jsObj['width'] = width;
}

defineSeed(543, 330, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$ListGridField, Q$HasCellSavedHandlers, Q$HasChangeHandlers_0, Q$HasChangedHandlers_0, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]), ListGridField_2, ListGridField_4);
function $setBackgroundComponent(this$static, backgroundComponent){
  $setAttribute_5(this$static, 'backgroundComponent', !backgroundComponent?null:$getOrCreateJsObj_0(backgroundComponent));
}

defineSeed(544, 344, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord]));
_.getEnabled = function getEnabled(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setEnabled = function setEnabled(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
function $getRecord(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.record == null)
    return null;
  var retVal = getRef(jsObj.record);
  retVal == null && (retVal = new ListGridRecord_1(jsObj.record));
  return retVal;
}

defineSeed(546, 465, {});
function CellClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(545, 546, {}, CellClickEvent_0);
_.dispatch = function dispatch_34(handler){
  dynamicCast(handler, Q$CellClickHandler).onCellClick(this);
}
;
_.getAssociatedType = function getAssociatedType_34(){
  return TYPE_34;
}
;
_.isCancelled = function isCancelled_14(){
  return false;
}
;
var TYPE_34 = null;
function $dispatch_6(this$static, handler){
  var rowNum;
  rowNum = $getRowNum(this$static);
  $getValue_3(this$static) == null || toString__devirtual$($getValue_3(this$static)).length == 0?$setEditValue_0(handler.val$memberValuesGrid, rowNum, 'memberValuesEditor-unsetField', true):$setEditValue_0(handler.val$memberValuesGrid, rowNum, 'memberValuesEditor-unsetField', false);
}

function $getRowNum(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.item) {
    return jsObj.item.rowNum;
  }
   else {
    var listGrid = jsObj.sourceJSO;
    return listGrid.getEventRow();
  }
}

function $getValue_3(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangeEvent_2(jsObj){
  this.jsObj = jsObj;
}

defineSeed(547, 356, {}, ChangeEvent_2);
_.dispatch = function dispatch_35(handler){
  $dispatch_6(this, dynamicCast(handler, Q$ChangeHandler_0));
}
;
_.getAssociatedType = function getAssociatedType_35(){
  return TYPE_35;
}
;
_.isCancelled = function isCancelled_15(){
  return false;
}
;
var TYPE_35 = null;
function $getRowNum_0(this$static){
  var jsObj = this$static.jsObj;
  if (jsObj.item) {
    return jsObj.item.rowNum;
  }
   else {
    var listGrid = jsObj.sourceJSO;
    return listGrid.getEventRow();
  }
}

function $getValue_4(this$static){
  var jsObj = this$static.jsObj;
  return $wnd.SmartGWT.convertToJavaType(jsObj.value);
}

function ChangedEvent_2(jsObj){
  this.jsObj = jsObj;
}

defineSeed(548, 356, {}, ChangedEvent_2);
_.dispatch = function dispatch_36(handler){
  dynamicCast(handler, Q$ChangedHandler_0).onChanged_0(this);
}
;
_.getAssociatedType = function getAssociatedType_36(){
  return TYPE_36;
}
;
var TYPE_36 = null;
function FieldStateChangedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(550, 465, {}, FieldStateChangedEvent_0);
_.dispatch = function dispatch_38(handler){
  dynamicCast(handler, Q$FieldStateChangedHandler).onFieldStateChanged(this);
}
;
_.getAssociatedType = function getAssociatedType_38(){
  return TYPE_38;
}
;
var TYPE_38 = null;
function $dispatch_7(this$static){
  var jsObj;
  (jsObj = this$static.jsObj , getOrCreateRef_1(jsObj.record)).jsObj['Expanded'] = false;
}

function RecordCollapseEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(552, 465, {}, RecordCollapseEvent_0);
_.dispatch = function dispatch_40(handler){
  $dispatch_7(this, dynamicCast(handler, Q$RecordCollapseHandler));
}
;
_.getAssociatedType = function getAssociatedType_40(){
  return TYPE_40;
}
;
_.isCancelled = function isCancelled_17(){
  return false;
}
;
var TYPE_40 = null;
function RecordDropEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(554, 465, {}, RecordDropEvent_0);
_.dispatch = function dispatch_42(handler){
  dynamicCast(handler, Q$RecordDropHandler).onRecordDrop_0(this);
}
;
_.getAssociatedType = function getAssociatedType_42(){
  return TYPE_42;
}
;
_.isCancelled = function isCancelled_18(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_42 = null;
function $dispatch_8(this$static){
  var jsObj;
  (jsObj = this$static.jsObj , getOrCreateRef_1(jsObj.record)).jsObj['Expanded'] = true;
}

function RecordExpandEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(555, 465, {}, RecordExpandEvent_0);
_.dispatch = function dispatch_43(handler){
  $dispatch_8(this, dynamicCast(handler, Q$RecordExpandHandler));
}
;
_.getAssociatedType = function getAssociatedType_43(){
  return TYPE_43;
}
;
_.isCancelled = function isCancelled_19(){
  return false;
}
;
var TYPE_43 = null;
function $dispatch_9(this$static, handler){
  var jsObj;
  $validateRow(handler.val$memberValuesGrid, (jsObj = this$static.jsObj , jsObj.rowNum));
  $hasErrors_0(handler.val$memberValuesGrid).value_0?$disable(handler.val$okButton):$enable(handler.val$okButton);
}

function RowEditorExitEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(556, 465, {}, RowEditorExitEvent_0);
_.dispatch = function dispatch_44(handler){
  $dispatch_9(this, dynamicCast(handler, Q$RowEditorExitHandler));
}
;
_.getAssociatedType = function getAssociatedType_44(){
  return TYPE_44;
}
;
_.isCancelled = function isCancelled_20(){
  return false;
}
;
var TYPE_44 = null;
function $getRecord_1(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_1(jsObj.record);
}

function $getState(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.state;
}

function HLayout_1(membersMargin){
  $clinit_BaseWidget();
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_0(this, 'membersMargin', membersMargin):(this.config_0['membersMargin'] = membersMargin , undefined);
  this.scClassName = 'HLayout';
}

defineSeed(558, 450, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]), HLayout_1);
function $addSection(this$static, section){
  var componentJS, container, config;
  componentJS = section.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addSection(componentJS) , undefined):(config = this$static.config_0 , !config.sections && (config.sections = createJavaScriptArray()) , config.sections.push(componentJS) , undefined);
  section.stack = this$static;
}

function $collapseSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.collapseSection(index);
}

function $collapseSection_0(this$static, sectionID){
  var container = this$static.getOrCreateJsObj();
  container.collapseSection(sectionID);
}

function $expandSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.expandSection(index);
}

function $expandSection_0(this$static, sectionID){
  var container = this$static.getOrCreateJsObj();
  container.expandSection(sectionID);
}

function $getSection(this$static, sectionID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSectionConfig(sectionID);
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_9(ret);
  return retVal;
}

function $getSections(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.sections;
  if (ret == null || ret === undefined)
    return null;
  var sectionsArr = createJavaScriptArray();
  for (var i = 0; i < ret.length; i++) {
    var jsSectionHeader = ret[i];
    sectionsArr[i] = jsSectionHeader.getSectionConfig?jsSectionHeader.getSectionConfig():jsSectionHeader;
  }
  return this$static.convertToSectionArray(sectionsArr);
}

function $setScrollSectionIntoView(this$static, scrollSectionIntoView){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'scrollSectionIntoView', scrollSectionIntoView);
}

function $setSectionTitle(this$static, sectionID, newTitle){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.setSectionTitle(sectionID, newTitle);
}

function $showSection(this$static, index){
  var container = this$static.getOrCreateJsObj();
  container.showSection(index);
}

function SectionStack_0(){
  $clinit_BaseWidget();
  VLayout_0.call(this);
  this.scClassName = 'SectionStack';
}

defineSeed(561, 449, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), SectionStack_0);
_.convertToSectionArray = function convertToSectionArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_layout_SectionStackSection_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SectionStackSection, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_layout_SectionStackSection_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$SectionStackSection, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = getOrCreateRef_9(componentJS);
    objects[i] = obj_0;
  }
  return objects;
}
;
_.create_0 = function create_31(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.setOverflow = function setOverflow_1(overflow){
  $setAttribute_24(this, 'overflow', overflow.value_0, false);
}
;
_.setStyleName = function setStyleName_3(styleName){
  $isCreated_1(this)?undefined:(this.config_0['styleName'] = styleName , undefined);
}
;
function $addItemJS(this$static, componentJS){
  var jsObj = this$static.getJsObj();
  !jsObj.items && (jsObj.items = createJavaScriptArray());
  jsObj.items.push(componentJS);
}

function $setExpanded(this$static, expanded){
  !this$static.stack || !$isDrawn(this$static.stack).value_0?setAttribute_5(this$static.jsObj, 'expanded', expanded):expanded.value_0?$expandSection_0(this$static.stack, getAttribute(this$static.jsObj, 'name')):$collapseSection_0(this$static.stack, getAttribute(this$static.jsObj, 'name'));
}

function $setItems(this$static, items){
  var item, item$index, item$max;
  for (item$index = 0 , item$max = items.length; item$index < item$max; ++item$index) {
    item = items[item$index];
    $addItemJS(this$static, $getOrCreateJsObj_0(item));
  }
}

function SectionStackSection_0(jsObj){
  RefDataClass_1.call(this, jsObj);
}

function SectionStackSection_1(title){
  RefDataClass_0.call(this);
  !this.stack || !$isDrawn(this.stack).value_0?(this.jsObj['title'] = title , undefined):$setSectionTitle(this.stack, getAttribute(this.jsObj, 'name'), title);
  $setAttribute_13(this, 'ID', generateID('SectionStackSection'));
}

function getOrCreateRef_9(jsObj){
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = getRef(jsObj);
  if (obj_0) {
    obj_0.jsObj = jsObj;
    return dynamicCast(obj_0, Q$SectionStackSection);
  }
   else {
    return new SectionStackSection_0(jsObj);
  }
}

defineSeed(562, 335, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$SectionStackSection]), SectionStackSection_0, SectionStackSection_1);
_.stack = null;
function VStack_0(){
  $clinit_BaseWidget();
  Layout_0.call(this);
  this.scClassName = 'VStack';
}

defineSeed(563, 450, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout]), VStack_0);
_.create_0 = function create_32(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $setShowMenuBelow(this$static, showMenuBelow){
  $isCreated_1(this$static)?!showMenuBelow?$setNullProperty(this$static, 'showMenuBelow'):$setProperty_4(this$static, 'showMenuBelow', showMenuBelow.value_0):setAttribute_5(this$static.config_0, 'showMenuBelow', showMenuBelow);
}

function IMenuButton_1(title, menu){
  $clinit_BaseWidget();
  StretchImgButton_0.call(this);
  $isCreated_1(this)?$setProperty_3(this, 'title', title):(this.config_0['title'] = title , undefined);
  $setAttribute_20(this, 'menu', !menu?null:$getOrCreateJsObj_0(menu), true);
  this.scClassName = 'IMenuButton';
}

defineSeed(564, 457, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$StatefulCanvas, Q$StretchImg, Q$StretchImgButton, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasIconClickHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers]), IMenuButton_1);
function $addItemClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_46 && (TYPE_46 = new GwtEvent$Type_0) , TYPE_46)) == 0 && $setupItemClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_46 && (TYPE_46 = new GwtEvent$Type_0) , TYPE_46));
}

function $getItemNum(this$static, item){
  var self_0 = this$static.getOrCreateJsObj();
  var itemJS = item.getJsObj();
  return self_0.getItemNum(itemJS);
}

function $setupItemClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({itemClick:$debox($entry(function(){
      var param = {item:arguments[0], colNum:arguments[1]};
      var event_0 = new ItemClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.itemClick = $debox($entry(function(){
      var param = {item:arguments[0], colNum:arguments[1]};
      var event_0 = new ItemClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function Menu_1(jsObj){
  Canvas_2.call(this, jsObj);
}

function getOrCreateRef_10(jsObj){
  $clinit_BaseWidget();
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = !jsObj?null:dynamicCast(getAttributeAsObject(jsObj, '__ref'), Q$BaseWidget);
  return obj_0?dynamicCast(obj_0, Q$Menu):new Menu_1(jsObj);
}

defineSeed(565, 542, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$Menu]), Menu_1);
_.setData = function setData_0(data){
  $isCreated_1(this)?$setProperty_2(this, 'data', convertToJavaScriptArray(data)):(this.config_0['data'] = convertToJavaScriptArray(data) , undefined);
}
;
defineSeed(566, 544, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord, Q$MenuItem, Q$HasClickHandlers_1]));
_.getEnabled = function getEnabled_0(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setEnabled = function setEnabled_0(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
function $dispatch_10(this$static, handler){
  var key, name_0;
  key = $getAttribute($getItem_1(this$static), 'portletKey');
  name_0 = $getAttributeAsString($getItem_1(this$static), 'title');
  $addPortlet_1(handler.this$0, key, name_0);
}

function $getItem_1(this$static){
  var jsObj = this$static.jsObj;
  var retVal = getOrCreateRef_11(jsObj.item);
  return retVal;
}

function ItemClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(568, 465, {}, ItemClickEvent_0);
_.dispatch = function dispatch_46(handler){
  $dispatch_10(this, dynamicCast(handler, Q$ItemClickHandler));
}
;
_.getAssociatedType = function getAssociatedType_46(){
  return TYPE_46;
}
;
_.isCancelled = function isCancelled_21(){
  return false;
}
;
var TYPE_46 = null;
function $getItem_2(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_11(jsObj.item);
}

function $addTabDeselectedHandler(this$static, handler){
  $getHandlerCount_0(this$static, (!TYPE_49 && (TYPE_49 = new GwtEvent$Type_0) , TYPE_49)) == 0 && $setupTabDeselectedEvent(this$static);
  return $doAddHandler(this$static, handler, (!TYPE_49 && (TYPE_49 = new GwtEvent$Type_0) , TYPE_49));
}

function $setID_1(this$static, ID){
  isValidID(ID);
  this$static.jsObj['ID'] = ID;
}

function $setIcon_3(this$static, icon){
  !this$static.tabSet || !$isDrawn(this$static.tabSet).value_0?(this$static.jsObj['icon'] = icon , undefined):$setTabIcon(this$static.tabSet, getAttribute(this$static.jsObj, 'ID'), icon);
}

function $setPane(this$static, pane){
  !this$static.tabSet || !$isCreated_1(this$static.tabSet)?$setAttribute_5(this$static, 'pane', $getOrCreateJsObj_0(pane)):$updateTab(this$static.tabSet, this$static, pane);
}

function $setTitle_2(this$static, title){
  !this$static.tabSet || !$isDrawn(this$static.tabSet).value_0?(this$static.jsObj['title'] = title , undefined):$setTabTitle(this$static.tabSet, this$static, title);
}

function $setupTabDeselectedEvent(this$static){
  var obj_0 = null;
  obj_0 = this$static.getJsObj();
  var selfJ = this$static;
  obj_0.tabDeselected = $debox($entry(function(){
    var param = {tabSet:arguments[0], tabNum:arguments[1], tabPane:arguments[2], ID:arguments[3], tab:arguments[4], newTab:arguments[5]};
    var event_0 = new TabDeselectedEvent_0(param);
    selfJ.fireEvent(event_0);
    var ret = event_0.isCancelled();
    return !ret;
  }
  ));
}

function Tab_0(jsObj){
  RefDataClass_1.call(this, jsObj);
}

function Tab_1(title){
  RefDataClass_0.call(this);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['title'] = title , undefined):$setTabTitle(this.tabSet, this, title);
  $setID_1(this, generateID(this.___clazz$.typeName));
}

function Tab_2(title, icon){
  RefDataClass_0.call(this);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['title'] = title , undefined):$setTabTitle(this.tabSet, this, title);
  !this.tabSet || !$isDrawn(this.tabSet).value_0?(this.jsObj['icon'] = icon , undefined):$setTabIcon(this.tabSet, getAttribute(this.jsObj, 'ID'), icon);
  $setID_1(this, generateID(this.___clazz$.typeName));
}

function getOrCreateRef_12(jsObj){
  var obj_0;
  if (!jsObj)
    return null;
  obj_0 = getRef(jsObj);
  if (obj_0) {
    obj_0.jsObj = jsObj;
    return dynamicCast(obj_0, Q$Tab);
  }
   else {
    return new Tab_0(jsObj);
  }
}

defineSeed(570, 335, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Tab, Q$HasTabDeselectedHandlers, Q$HasTabSelectedHandlers]), Tab_0, Tab_1, Tab_2);
_.getPane = function getPane(){
  return getOrCreateRef_3(getAttributeAsJavaScriptObject(this.jsObj, 'pane'));
}
;
_.getTabSet = function getTabSet(){
  return this.tabSet;
}
;
_.getTitle = function getTitle_1(){
  return !this.tabSet || !$isDrawn(this.tabSet).value_0?getAttribute(this.jsObj, 'title'):$getAttributeAsString($getTab(this.tabSet, getAttribute(this.jsObj, 'ID')), 'title');
}
;
_.tabSet = null;
function $addCloseClickHandler_0(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_48 && (TYPE_48 = new GwtEvent$Type_0) , TYPE_48)) == 0 && $setupCloseClickEvent_0(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_48 && (TYPE_48 = new GwtEvent$Type_0) , TYPE_48));
}

function $addTab(this$static, tab){
  var tabJS, container, config;
  tab.tabSet = this$static;
  tabJS = tab.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addTab(tabJS) , undefined):(config = this$static.config_0 , !config.tabs && (config.tabs = createJavaScriptArray()) , config.tabs.push(tabJS) , undefined);
}

function $addTab_0(this$static, tab, position){
  var tabJS, container, config;
  tabJS = tab.jsObj;
  $isCreated_1(this$static)?(container = this$static.getOrCreateJsObj() , container.addTab(tabJS, position) , undefined):(config = this$static.config_0 , !config.tabs && (config.tabs = createJavaScriptArray()) , config.tabs.splice(position, 0, tabJS) , undefined);
}

function $addTabSelectedHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_50 && (TYPE_50 = new GwtEvent$Type_0) , TYPE_50)) == 0 && $setupTabSelectedEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_50 && (TYPE_50 = new GwtEvent$Type_0) , TYPE_50));
}

function $getSelectedTab(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSelectedTab();
  return ret == null?null:getRef(ret);
}

function $getTab(this$static, ID){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getTabObject(ID);
  return ret == null?null:getRef(ret);
}

function $getTabNumber(this$static, ID){
  var self_0 = this$static.getOrCreateJsObj();
  return self_0.getTabNumber(ID);
}

function $removeTab(this$static, tab){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.removeTab(tabJS);
}

function $selectTab(this$static, tabIndex){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.selectTab(tabIndex);
}

function $selectTab_0(this$static, tab){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.selectTab(tabJS);
}

function $setDestroyPanes(this$static, destroyPanes){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'destroyPanes', destroyPanes);
}

function $setTabIcon(this$static, ID, iconURL){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.setTabIcon(ID, iconURL);
}

function $setTabTitle(this$static, tab, title){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  self_0.setTabTitle(tabJS, title);
}

function $setTabs(this$static, tabs){
  var tab, tab$index, tab$max;
  for (tab$index = 0 , tab$max = tabs.length; tab$index < tab$max; ++tab$index) {
    tab = tabs[tab$index];
    $addTab(this$static, tab);
  }
}

function $setupCloseClickEvent_0(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({onCloseClick:$debox($entry(function(){
      var liveTab = arguments[0];
      var tabObj = this.getTabObject(liveTab);
      var param = {tab:tabObj};
      var event_0 = new TabCloseClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.onCloseClick = $debox($entry(function(){
      var liveTab = arguments[0];
      var tabObj = this.getTabObject(liveTab);
      var param = {tab:tabObj};
      var event_0 = new TabCloseClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function $setupTabSelectedEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({tabSelected:$entry(function(){
      var param = {tabNum:arguments[0], tabPane:arguments[1], ID:arguments[2], tab:arguments[3]};
      var event_0 = new TabSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.tabSelected = $entry(function(){
      var param = {tabNum:arguments[0], tabPane:arguments[1], ID:arguments[2], tab:arguments[3]};
      var event_0 = new TabSelectedEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $updateTab(this$static, tab, pane){
  var self_0 = this$static.getOrCreateJsObj();
  var tabJS = tab.getJsObj();
  var paneJS = pane == null?null:pane.getOrCreateJsObj();
  self_0.updateTab(tabJS, paneJS);
}

function TabSet_0(){
  $clinit_BaseWidget();
  Canvas_1.call(this);
  this.scClassName = 'TabSet';
}

function convertToTabArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_tab_Tab_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Tab, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_tab_Tab_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Tab, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = dynamicCast(getRef(componentJS), Q$Tab);
    setCheck(objects, i, obj_0);
  }
  return objects;
}

defineSeed(571, 445, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$HasTabDeselectedHandlers, Q$HasTabSelectedHandlers]), TabSet_0);
_.create_0 = function create_35(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
function $dispatch_11(this$static, handler){
  var dashboardView;
  this$static.cancel = true;
  dashboardView = dynamicCast($getTab_0(this$static).getPane(), Q$DashboardView);
  ask(($clinit_Enhanced() , 'Jste si jisti, \u017Ee to chcete smazat') + ' [' + dashboardView.storedDashboard.name_0 + ']?', new DashboardsView$6$1_0(handler, this$static, dashboardView));
}

function $getTab_0(this$static){
  var jsObj = this$static.jsObj;
  var retVal = getOrCreateRef_12(jsObj.tab);
  retVal == null && (retVal = new Tab_0(jsObj.tab));
  return retVal;
}

function TabCloseClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(572, 465, {}, TabCloseClickEvent_0);
_.dispatch = function dispatch_48(handler){
  $dispatch_11(this, dynamicCast(handler, Q$CloseClickHandler_0));
}
;
_.getAssociatedType = function getAssociatedType_48(){
  return TYPE_48;
}
;
_.isCancelled = function isCancelled_22(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_48 = null;
function $dispatch_12(this$static, handler){
  $validate_3(handler.this$0.generalProperties) || (this$static.cancel = true);
}

function TabDeselectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(573, 465, {}, TabDeselectedEvent_0);
_.dispatch = function dispatch_49(handler){
  $dispatch_12(this, dynamicCast(handler, Q$TabDeselectedHandler));
}
;
_.getAssociatedType = function getAssociatedType_49(){
  return TYPE_49;
}
;
_.isCancelled = function isCancelled_23(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_49 = null;
function $getTabNum(this$static){
  var jsObj = this$static.jsObj;
  return jsObj.tabNum;
}

function TabSelectedEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(574, 465, {}, TabSelectedEvent_0);
_.dispatch = function dispatch_50(handler){
  dynamicCast(handler, Q$TabSelectedHandler).onTabSelected(this);
}
;
_.getAssociatedType = function getAssociatedType_50(){
  return TYPE_50;
}
;
var TYPE_50 = null;
function $addSpacer(this$static, toolStripSpacer){
  var canvas;
  canvas = new Canvas_1;
  $isCreated_1(canvas)?$setProperty_0(canvas, 'width', 1):(canvas.config_0['width'] = 1 , undefined);
  $isCreated_1(canvas)?$setProperty_0(canvas, 'height', 1):(canvas.config_0['height'] = 1 , undefined);
  $isCreated_1(canvas)?$setProperty_3(canvas, 'border', 'none'):(canvas.config_0['border'] = 'none' , undefined);
  $setExtraSpace(canvas, toolStripSpacer.space);
  $addMember(this$static, canvas);
}

function ToolStripSpacer_0(space){
  this.space = space;
}

defineSeed(577, 1, {}, ToolStripSpacer_0);
_.space = 0;
function $find(this$static, fieldNameOrPath, value){
  var self_0 = this$static.getOrCreateJsObj();
  var nodeJS = self_0.find(fieldNameOrPath, value);
  return nodeJS == null?null:getOrCreateRef_14(nodeJS);
}

function $getAttributeAsJavaScriptObject_2(this$static){
  return $isCreated(this$static)?getAttributeAsJavaScriptObject($getJsObj(this$static), 'root'):$getAttributeAsJavaScriptObject(this$static, 'root');
}

function $getChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getChildren(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getOpenList(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getOpenList(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getParent(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var parent_0 = self_0.getParent(node.getJsObj());
  if (parent_0 == null || parent_0 === undefined)
    return null;
  var parentJ = getOrCreateRef_14(parent_0);
  return parentJ;
}

function $getParents(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = self_0.getParents(node.getJsObj());
  return convertToTreeNodeArray(nodesJS);
}

function $getRoot(this$static){
  return getOrCreateRef_14($isCreated(this$static)?getAttributeAsJavaScriptObject($getJsObj(this$static), 'root'):$getAttributeAsJavaScriptObject(this$static, 'root'));
}

function $isOpen(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isOpen(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $isRoot(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  var retVal = self_0.isRoot(node.getJsObj());
  if (retVal == null || retVal === undefined) {
    return null;
  }
   else {
    return toBoolean(retVal);
  }
}

function $linkNodes(this$static, nodes){
  var self_0 = this$static.getOrCreateJsObj();
  var nodesJS = convertToJavaScriptArray(nodes);
  self_0.linkNodes(nodesJS);
}

function $openFolder(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.openFolder(node.getJsObj());
}

function $openFolders(this$static, nodeList){
  var self_0 = this$static.getOrCreateJsObj();
  var nodeListJS = convertToJavaScriptArray(nodeList);
  self_0.openFolders(nodeListJS);
}

function $reloadChildren(this$static, node){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.reloadChildren(node.getJsObj());
}

function Tree_0(){
  BaseClass_0.call(this);
  this.scClassName = 'Tree';
}

function convertToTreeNodeArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = getOrCreateRef_14(componentJS);
    setCheck(objects, i, obj_0);
  }
  return objects;
}

function convertToTreeNodeRecordArray(nativeArray){
  var componentJS, componentsj, i, obj_0, objects;
  if (!nativeArray) {
    return initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, []);
  }
  componentsj = toArray_3(nativeArray);
  objects = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, componentsj.length, 0);
  for (i = 0; i < componentsj.length; ++i) {
    componentJS = componentsj[i];
    obj_0 = dynamicCast(getRef(componentJS), Q$ListGridRecord);
    !obj_0 && (obj_0 = new TreeNode_1(componentJS));
    setCheck(objects, i, obj_0);
  }
  return objects;
}

defineSeed(578, 329, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$Tree]), Tree_0);
function $addDataArrivedHandler_1(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51)) == 0 && $setupDataArrivedEvent_1(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_51 && (TYPE_51 = new GwtEvent$Type_0) , TYPE_51));
}

function $addNodeClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_52 && (TYPE_52 = new GwtEvent$Type_0) , TYPE_52)) == 0 && $setupNodeClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_52 && (TYPE_52 = new GwtEvent$Type_0) , TYPE_52));
}

function $addNodeContextClickHandler(this$static, handler){
  $getHandlerCount_1(this$static, (!TYPE_53 && (TYPE_53 = new GwtEvent$Type_0) , TYPE_53)) == 0 && $setupNodeContextClickEvent(this$static);
  return $doAddHandler_0(this$static, handler, (!TYPE_53 && (TYPE_53 = new GwtEvent$Type_0) , TYPE_53));
}

function $fetchData_3(this$static, criteria){
  var self_0 = this$static.getOrCreateJsObj();
  self_0.fetchData(criteria == null?null:criteria.getJsObj());
}

function $fetchData_4(this$static, criteria, callback){
  var self_0 = this$static.getOrCreateJsObj();
  var critJS = criteria == null?null:criteria.getJsObj();
  self_0.fetchData(critJS, $entry(function(dsResponse, data, dsRequest){
    var responseJ = new DSResponse_1(dsResponse);
    var requestJ = new DSRequest_1(dsRequest);
    callback != null && callback.execute_2(responseJ, data, requestJ);
  }
  ));
}

function $getRecords(this$static){
  var i, node, nodes, records, root, tree, dataJS;
  tree = getOrCreateRef_13($getAttributeAsJavaScriptObject_1(this$static, 'data'));
  if ($isCreated_1(this$static)) {
    root = getOrCreateRef_14($getAttributeAsJavaScriptObject_2(tree));
    if (!root) {
      return null;
    }
     else {
      nodes = $getOpenList(tree, getOrCreateRef_14($getAttributeAsJavaScriptObject_2(tree)));
      records = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, nodes.length, 0);
      for (i = 0; i < nodes.length; ++i) {
        node = nodes[i];
        setCheck(records, i, new ListGridRecord_1(node.jsObj));
      }
      return records;
    }
  }
   else {
    return dataJS = $isCreated(tree)?getAttributeAsJavaScriptObject($getJsObj(tree), 'data'):$getAttributeAsJavaScriptObject(tree, 'data') , convertToTreeNodeRecordArray(dataJS);
  }
}

function $getSelectedRecord_0(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  var ret = self_0.getSelectedRecord();
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_14(ret);
  return retVal;
}

function $onInit_TreeGrid(this$static){
  var self_0 = this$static.getOrCreateJsObj();
  self_0._getNodeTitle = self_0.getNodeTitle;
  self_0.getNodeTitle = $debox($entry(function(node, recordNum, field){
    var jObj = this.__ref;
    var nodeJ = getOrCreateRef_1(node);
    var fieldJ = getOrCreateRef_7(field);
    return jObj.getNodeTitle_0(nodeJ, recordNum, fieldJ);
  }
  ));
  self_0._getIcon = self_0.getIcon;
  self_0.getIcon = $debox($entry(function(node, defaultState){
    defaultState = !!defaultState;
    $wnd.isc.isA.Number(node) && (node = this.data.get(node));
    var jObj = this.__ref;
    var nodeJ = getOrCreateRef_1(node);
    return jObj.getIcon_0(nodeJ, defaultState);
  }
  ));
}

function $setAnimateFolders(this$static, animateFolders){
  $isCreated_1(this$static)?!animateFolders?$setNullProperty(this$static, 'animateFolders'):$setProperty_4(this$static, 'animateFolders', animateFolders.value_0):setAttribute_5(this$static.config_0, 'animateFolders', animateFolders);
}

function $setData_0(this$static, data){
  $setAttribute_20(this$static, 'data', !data?null:$getOrCreateJsObj(data), true);
}

function $setFields_2(this$static, fields){
  $isCreated_1(this$static)?$setProperty_2(this$static, 'fields', convertToJavaScriptArray(fields)):(this$static.config_0['fields'] = convertToJavaScriptArray(fields) , undefined);
}

function $setFolderIcon(this$static){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'folderIcon', 'global/DiscoveryQueue_Platform_16.png'):(this$static.config_0['folderIcon'] = 'global/DiscoveryQueue_Platform_16.png' , undefined);
}

function $setLoadDataOnDemand(this$static, loadDataOnDemand){
  $isCreated_1(this$static)?!loadDataOnDemand?$setNullProperty(this$static, 'loadDataOnDemand'):$setProperty_4(this$static, 'loadDataOnDemand', loadDataOnDemand.value_0):setAttribute_5(this$static.config_0, 'loadDataOnDemand', loadDataOnDemand);
}

function $setNodeIcon(this$static, nodeIcon){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'nodeIcon', nodeIcon):(this$static.config_0['nodeIcon'] = nodeIcon , undefined);
}

function $setShowRoot(this$static, showRoot){
  $isCreated_1(this$static)?undefined:setAttribute_5(this$static.config_0, 'showRoot', showRoot);
}

function $setTreeFieldTitle(this$static){
  $isCreated_1(this$static)?undefined:(this$static.config_0['treeFieldTitle'] = 'Resource Name' , undefined);
}

function $setupDataArrivedEvent_1(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({dataArrived:$entry(function(){
      var param = {parentNode:arguments[0]};
      var event_0 = new DataArrivedEvent_4(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.dataArrived = $entry(function(){
      var param = {parentNode:arguments[0]};
      var event_0 = new DataArrivedEvent_4(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupNodeClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({nodeClick:$entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeClickEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    )});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.nodeClick = $entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeClickEvent_0(param);
      selfJ.fireEvent(event_0);
    }
    );
  }
}

function $setupNodeContextClickEvent(this$static){
  var obj_0 = null;
  var selfJ = this$static;
  if (this$static.isCreated()) {
    obj_0 = this$static.getJsObj();
    obj_0.addProperties({nodeContextClick:$debox($entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeContextClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ))});
  }
   else {
    obj_0 = this$static.getConfig();
    obj_0.nodeContextClick = $debox($entry(function(){
      var param = {viewer:arguments[0], node:arguments[1], recordNum:arguments[2]};
      var event_0 = new NodeContextClickEvent_0(param);
      selfJ.fireEvent(event_0);
      var ret = event_0.isCancelled();
      return !ret;
    }
    ));
  }
}

function TreeGrid_0(){
  $clinit_BaseWidget();
  ListGrid_0.call(this);
  $isCreated_1(this)?$setProperty_0(this, 'animateFolderSpeed', 3000):(this.config_0['animateFolderSpeed'] = 3000 , undefined);
  $setAlternateRecordStyles(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  this.scClassName = 'TreeGrid';
}

defineSeed(579, 542, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$TreeGrid]), TreeGrid_0);
_.addRecordDropHandler = function addRecordDropHandler_0(handler){
  throw new UnsupportedOperationException_1('This event inherited from ListGrid does not fire for a TreeGrid. Use TreeGrid.addFolgerDropHandler instead');
}
;
_.create_0 = function create_39(){
  var config = this.getConfig();
  var scClassName = this.scClassName;
  var widget = $wnd.isc[scClassName].create(config);
  this.doInit();
  return widget;
}
;
_.fetchData_0 = function fetchData_1(){
  var self_0 = this.getOrCreateJsObj();
  self_0.fetchData();
}
;
_.fetchData_1 = function fetchData_2(criteria){
  $fetchData_3(this, criteria);
}
;
_.getIcon_0 = function getIcon(node, defaultState){
  var self_0 = this.getOrCreateJsObj();
  return self_0._getIcon(node.getJsObj(), defaultState);
}
;
_.getNodeTitle_0 = function getNodeTitle(node, recordNum, field){
  var self_0 = this.getOrCreateJsObj();
  var title = self_0._getNodeTitle(node.getJsObj(), recordNum, field.getJsObj());
  return title == null?'':title.toString();
}
;
_.getRecord_0 = function getRecord_0(recordNum){
  var self_0 = this.getOrCreateJsObj();
  var ret = self_0.getRecord(recordNum);
  if (ret == null || ret === undefined)
    return null;
  var retVal = getOrCreateRef_14(ret);
  return retVal;
}
;
_.getRecords = function getRecords_0(){
  return $getRecords(this);
}
;
_.getSelectedRecord_0 = function getSelectedRecord_0(){
  return $getSelectedRecord_0(this);
}
;
_.onInit = function onInit_6(){
  $onInit(this);
  $onInit_ListGrid(this);
  $onInit_TreeGrid(this);
}
;
_.setCanAcceptDroppedRecords = function setCanAcceptDroppedRecords_0(canAcceptDroppedRecords){
  $isCreated_1(this)?!canAcceptDroppedRecords?$setNullProperty(this, 'canAcceptDroppedRecords'):$setProperty_4(this, 'canAcceptDroppedRecords', canAcceptDroppedRecords.value_0):setAttribute_5(this.config_0, 'canAcceptDroppedRecords', canAcceptDroppedRecords);
}
;
_.setCanDragRecordsOut = function setCanDragRecordsOut_0(canDragRecordsOut){
  $isCreated_1(this)?!canDragRecordsOut?$setNullProperty(this, 'canDragRecordsOut'):$setProperty_4(this, 'canDragRecordsOut', canDragRecordsOut.value_0):setAttribute_5(this.config_0, 'canDragRecordsOut', canDragRecordsOut);
}
;
_.setCanReorderRecords = function setCanReorderRecords_0(canReorderRecords){
  $isCreated_1(this)?!canReorderRecords?$setNullProperty(this, 'canReorderRecords'):$setProperty_4(this, 'canReorderRecords', canReorderRecords.value_0):setAttribute_5(this.config_0, 'canReorderRecords', canReorderRecords);
}
;
_.willAcceptDrop_0 = function willAcceptDrop_1(){
  return $willAcceptDrop(this);
}
;
function TreeGridField_0(name_0){
  ListGridField_1.call(this, name_0);
}

function TreeGridField_1(name_0, title){
  ListGridField_3.call(this, name_0, title);
}

function TreeGridField_2(name_0, title, width){
  ListGridField_4.call(this, name_0, title, width);
}

defineSeed(580, 543, makeCastMap([Q$HasHandlers, Q$DataClass, Q$JsObject, Q$ListGridField, Q$HasCellSavedHandlers, Q$HasChangeHandlers_0, Q$HasChangedHandlers_0, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers, Q$TreeGridField]), TreeGridField_0, TreeGridField_1, TreeGridField_2);
function TreeNode_0(){
  ListGridRecord_0.call(this);
}

function TreeNode_2(name_0){
  ListGridRecord_0.call(this);
  this.setName(name_0);
}

defineSeed(581, 544, makeCastMap([Q$DataClass, Q$JsObject, Q$RefDataClass, Q$Record, Q$ListGridRecord, Q$TreeNode]), TreeNode_0, TreeNode_2);
_.getEnabled = function getEnabled_1(){
  return $clinit_Boolean() , getAttributeAsBoolean(this.jsObj, 'enabled')?TRUE:FALSE;
}
;
_.setEnabled = function setEnabled_1(enabled){
  setAttribute_5(this.jsObj, 'enabled', enabled);
}
;
_.setID = function setID_1(id){
  this.jsObj['id'] = id;
}
;
_.setName = function setName(name_0){
  this.jsObj['name'] = name_0;
}
;
_.setParentID = function setParentID(parentID){
  this.jsObj['parentId'] = parentID;
}
;
function $dispatch_13(this$static, handler){
  var parent_0, jsObj;
  handler.this$0.selectedNodeId == null && $updateSelection(handler.this$0, false);
  parent_0 = (jsObj = this$static.jsObj , getOrCreateRef_14(jsObj.parentNode));
  instanceOf(parent_0, Q$EnhancedTreeNode) && $equals_6($getAttribute(dynamicCast(parent_0, Q$EnhancedTreeNode), 'id'), handler.this$0.selectedNodeId) && $updateSelection(handler.this$0, false);
}

function DataArrivedEvent_4(jsObj){
  this.jsObj = jsObj;
}

defineSeed(582, 465, {}, DataArrivedEvent_4);
_.dispatch = function dispatch_51(handler){
  $dispatch_13(this, dynamicCast(handler, Q$DataArrivedHandler_1));
}
;
_.getAssociatedType = function getAssociatedType_51(){
  return TYPE_51;
}
;
var TYPE_51 = null;
function $getNode(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_14(jsObj.node);
}

function NodeClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(583, 465, {}, NodeClickEvent_0);
_.dispatch = function dispatch_52(handler){
  dynamicCast(handler, Q$NodeClickHandler).onNodeClick(this);
}
;
_.getAssociatedType = function getAssociatedType_52(){
  return TYPE_52;
}
;
var TYPE_52 = null;
function $getNode_0(this$static){
  var jsObj = this$static.jsObj;
  return getOrCreateRef_14(jsObj.node);
}

function NodeContextClickEvent_0(jsObj){
  this.jsObj = jsObj;
}

defineSeed(584, 465, {}, NodeContextClickEvent_0);
_.dispatch = function dispatch_53(handler){
  dynamicCast(handler, Q$NodeContextClickHandler).onNodeContextClick(this);
}
;
_.getAssociatedType = function getAssociatedType_53(){
  return TYPE_53;
}
;
_.isCancelled = function isCancelled_24(){
  return this.cancel;
}
;
_.cancel = false;
var TYPE_53 = null;
function __parseAndValidateDouble(s){
  var toReturn;
  toReturn = __parseDouble(s);
  if (isNaN(toReturn)) {
    throw new NumberFormatException_1('For input string: "' + s + '"');
  }
  return toReturn;
}

function __parseDouble(str){
  var floatRegex = floatRegex_0;
  !floatRegex && (floatRegex = floatRegex_0 = /^\s*[+-]?((\d+\.?\d*)|(\.\d+))([eE][+-]?\d+)?[dDfF]?\s*$/i);
  if (floatRegex.test(str)) {
    return parseFloat(str);
  }
   else {
    return Number.NaN;
  }
}

var floatRegex_0 = null;
defineSeed(594, 595, makeCastMap([Q$Serializable, Q$Byte, Q$Comparable, Q$Number]));
_.intValue = function intValue_0(){
  return this.value_0;
}
;
_.longValue = function longValue_0(){
  return fromInt(this.value_0);
}
;
defineSeed(601, 595, makeCastMap([Q$Serializable, Q$Comparable, Q$Double, Q$Number]));
_.intValue = function intValue_1(){
  return round_int(this.value_0);
}
;
_.longValue = function longValue_1(){
  return fromDouble(this.value_0);
}
;
function parseFloat_0(s){
  var doubleValue;
  doubleValue = __parseAndValidateDouble(s);
  if (doubleValue > 3.4028234663852886E38) {
    return Infinity;
  }
   else if (doubleValue < -3.4028234663852886E38) {
    return -Infinity;
  }
  return doubleValue;
}

defineSeed(602, 595, makeCastMap([Q$Serializable, Q$Comparable, Q$Float, Q$Number]));
_.intValue = function intValue_2(){
  return round_int(this.value_0);
}
;
_.longValue = function longValue_2(){
  return fromDouble(this.value_0);
}
;
function Integer_1(s){
  this.value_0 = __parseAndValidateInt(s);
}

defineSeed(605, 595, makeCastMap([Q$Serializable, Q$Comparable, Q$Integer, Q$Number]), Integer_1);
_.longValue = function longValue_3(){
  return fromInt(this.value_0);
}
;
defineSeed(607, 595, makeCastMap([Q$Serializable, Q$Comparable, Q$Long, Q$Number]));
_.intValue = function intValue_4(){
  return toInt(this.value_0);
}
;
_.longValue = function longValue_4(){
  return this.value_0;
}
;
function abs(x){
  return x <= 0?0 - x:x;
}

function max_0(x, y){
  return x > y?x:y;
}

function min_1(x, y){
  return x < y?x:y;
}

defineSeed(616, 595, makeCastMap([Q$Serializable, Q$Comparable, Q$Number, Q$Short]));
_.intValue = function intValue_5(){
  return this.value_0;
}
;
_.longValue = function longValue_5(){
  return fromInt(this.value_0);
}
;
function $replace_0(this$static, from, to){
  var regex;
  if (from < 256) {
    regex = toPowerOfTwoString(from);
    regex = '\\x' + '00'.substring(regex.length) + regex;
  }
   else {
    regex = String.fromCharCode(from);
  }
  return this$static.replace(RegExp(regex, 'g'), String.fromCharCode(to));
}

function $replace_1(this$static, from, to){
  var regex, replacement;
  regex = $replaceAll(from, '([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])', '\\\\$1');
  replacement = $replaceAll($replaceAll(to, '\\\\', '\\\\\\\\'), '\\$', '\\\\$');
  return $replaceAll(this$static, regex, replacement);
}

function $startsWith(this$static, prefix, toffset){
  return !(toffset < 0 || toffset >= this$static.length) && this$static.indexOf(prefix, toffset) == toffset;
}

function $delete(this$static, end){
  return $replace(this$static.data_0, 0, end, '') , this$static;
}

function $replace_2(this$static, start, toInsert){
  $replace(this$static.data_0, start, 9, toInsert);
  return this$static;
}

function $append_14(this$static, x){
  $appendNonNull(this$static.data_0, valueOf_48(x));
  return this$static;
}

function $charAt_0(this$static, index){
  return $charAt($toString_1(this$static.data_0), index);
}

function $delete_0(this$static, start, end){
  return $replace(this$static.data_0, start, end, '') , this$static;
}

function $insert_0(this$static, index, x){
  return $replace(this$static.data_0, index, index, x) , this$static;
}

function $replace_3(this$static, start, end, toInsert){
  $replace(this$static.data_0, start, end, toInsert);
  return this$static;
}

function $setCharAt(this$static, index, x){
  $replace_3(this$static, index, index + 1, String.fromCharCode(x));
}

function $setLength_1(this$static, newLength){
  var oldLength;
  oldLength = $toString_1(this$static.data_0).length;
  newLength < oldLength?($replace(this$static.data_0, newLength, oldLength, '') , this$static):newLength > oldLength && $append_14(this$static, initDim(_3C_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, newLength - oldLength, 1));
}

function $substring_1(this$static, end){
  return $substring_0($toString_1(this$static.data_0), 0, end);
}

function Date_4(date){
  Date_2.call(this, date);
}

defineSeed(630, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), Date_4);
_.getHours_0 = function getHours_0(){
  throw new IllegalArgumentException_0;
}
;
_.getMinutes_0 = function getMinutes_0(){
  throw new IllegalArgumentException_0;
}
;
_.getSeconds_0 = function getSeconds_0(){
  throw new IllegalArgumentException_0;
}
;
_.setHours_0 = function setHours_2(i){
  throw new IllegalArgumentException_0;
}
;
_.setMinutes_0 = function setMinutes_2(i){
  throw new IllegalArgumentException_0;
}
;
_.setSeconds_0 = function setSeconds_2(i){
  throw new IllegalArgumentException_0;
}
;
_.toString$ = function toString_25(){
  return '' + (1900 + (this.jsdate.getFullYear() - 1900)) + '-' + padTwo(this.jsdate.getMonth() + 1) + '-' + padTwo(this.jsdate.getDate());
}
;
function Time_0(time){
  Date_2.call(this, time);
}

defineSeed(631, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Date]), Time_0);
_.getDate_0 = function getDate_0(){
  throw new IllegalArgumentException_0;
}
;
_.getDay_0 = function getDay_0(){
  throw new IllegalArgumentException_0;
}
;
_.getMonth_0 = function getMonth_0(){
  throw new IllegalArgumentException_0;
}
;
_.getYear = function getYear_0(){
  throw new IllegalArgumentException_0;
}
;
_.setDate_0 = function setDate_0(i){
  throw new IllegalArgumentException_0;
}
;
_.toString$ = function toString_26(){
  return padTwo(this.jsdate.getHours()) + ':' + padTwo(this.jsdate.getMinutes()) + ':' + padTwo(this.jsdate.getSeconds());
}
;
function $compareTo_8(this$static, o){
  var sign;
  sign = signum(sub(fromDouble(this$static.jsdate.getTime()), fromDouble(o.jsdate.getTime())));
  return sign == 0?this$static.nanos - o.nanos:sign;
}

function $equals_7(this$static, ts){
  return eq(fromDouble(this$static.jsdate.getTime()), fromDouble(ts.jsdate.getTime())) && this$static.nanos == ts.nanos;
}

function $setNanos(this$static, n){
  if (n < 0 || n > 999999999) {
    throw new IllegalArgumentException_1('nanos out of range ' + n);
  }
  this$static.nanos = n;
  $setTime_0(this$static, add(mul(div(fromDouble(this$static.jsdate.getTime()), P3e8_longLit), P3e8_longLit), fromInt(~~(this$static.nanos / 1000000))));
}

function Timestamp_0(time){
  Date_2.call(this, time);
  this.nanos = toInt(mod(time, P3e8_longLit)) * 1000000;
}

function padNine(value){
  var asString, toReturn;
  toReturn = new StringBuffer_2('000000000');
  asString = '' + value;
  toReturn = $replace_2(toReturn, 9 - asString.length, asString);
  return $toString_1(toReturn.data_0);
}

defineSeed(632, 106, makeCastMap([Q$Serializable, Q$Cloneable, Q$Comparable, Q$Timestamp, Q$Date]), Timestamp_0);
_.compareTo = function compareTo_12(o){
  return instanceOf(o, Q$Timestamp)?$compareTo_8(this, dynamicCast(o, Q$Timestamp)):$compareTo_8(this, new Timestamp_0(o.getTime_0()));
}
;
_.equals$ = function equals_14(ts){
  return instanceOf(ts, Q$Timestamp) && $equals_7(this, dynamicCast(ts, Q$Timestamp));
}
;
_.getTime_0 = function getTime_0(){
  return fromDouble(this.jsdate.getTime());
}
;
_.hashCode$ = function hashCode_16(){
  return $hashCode(this);
}
;
_.setTime_0 = function setTime_0(time){
  $setTime(this.jsdate, toDouble(time));
  this.nanos = toInt(mod(time, P3e8_longLit)) * 1000000;
}
;
_.toString$ = function toString_27(){
  return '' + (1900 + (this.jsdate.getFullYear() - 1900)) + '-' + padTwo(1 + this.jsdate.getMonth()) + '-' + padTwo(this.jsdate.getDate()) + ' ' + padTwo(this.jsdate.getHours()) + ':' + padTwo(this.jsdate.getMinutes()) + ':' + padTwo(this.jsdate.getSeconds()) + '.' + padNine(this.nanos);
}
;
_.nanos = 0;
function $putAll(this$static, t){
  var e, iter;
  for (iter = t.entrySet().iterator(); iter.hasNext();) {
    e = dynamicCast(iter.next_0(), Q$Map$Entry);
    this$static.put(e.getKey_0(), e.getValue_1());
  }
}

function $values(this$static){
  var entrySet;
  entrySet = this$static.entrySet();
  return new AbstractMap$2_0(this$static, entrySet);
}

defineSeed(634, 1, makeCastMap([Q$Map]));
_.clear_0 = function clear_2(){
  this.entrySet().clear_0();
}
;
_.containsValue = function containsValue(value){
  var entry, iter, v;
  for (iter = this.entrySet().iterator(); iter.hasNext();) {
    entry = dynamicCast(iter.next_0(), Q$Map$Entry);
    v = entry.getValue_1();
    if (value == null?v == null:equals__devirtual$(value, v)) {
      return true;
    }
  }
  return false;
}
;
_.putAll = function putAll(t){
  $putAll(this, t);
}
;
_.remove_3 = function remove_7(key){
  var entry;
  entry = $implFindEntry(this, key, true);
  return !entry?null:entry.getValue_1();
}
;
_.values_0 = function values_41(){
  return $values(this);
}
;
function $containsHashValue(this$static, value){
  var hashCodeMap = this$static.hashCodeMap;
  for (var hashCode in hashCodeMap) {
    var hashCodeInt = parseInt(hashCode, 10);
    if (hashCode == hashCodeInt) {
      var array = hashCodeMap[hashCodeInt];
      for (var i = 0, c = array.length; i < c; ++i) {
        var entry = array[i];
        var entryValue = entry.getValue_1();
        if (this$static.equalsBridge(value, entryValue)) {
          return true;
        }
      }
    }
  }
  return false;
}

function $containsStringValue(this$static, value){
  var stringMap = this$static.stringMap;
  for (var key in stringMap) {
    if (key.charCodeAt(0) == 58) {
      var entryValue = stringMap[key];
      if (this$static.equalsBridge(value, entryValue)) {
        return true;
      }
    }
  }
  return false;
}

defineSeed(633, 634, makeCastMap([Q$Map]));
_.containsValue = function containsValue_0(value){
  if (this.nullSlotLive && this.equals(this.nullSlot, value)) {
    return true;
  }
   else if ($containsStringValue(this, value)) {
    return true;
  }
   else if ($containsHashValue(this, value)) {
    return true;
  }
  return false;
}
;
function $removeAll_0(this$static, c){
  var iter, o, size;
  size = this$static.map_0.size_1();
  if (size < c.val$entrySet.size_1()) {
    for (iter = $iterator($keySet(this$static.map_0)); iter.val$outerIter.hasNext();) {
      o = $next_1(iter);
      c.this$0.containsKey(o) && iter.val$outerIter.remove_2();
    }
  }
   else {
    for (iter = $iterator(c); iter.val$outerIter.hasNext();) {
      o = $next_1(iter);
      this$static.map_0.remove_3(o) != null;
    }
  }
  return size != this$static.map_0.size_1();
}

defineSeed(635, 636, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.remove_0 = function remove_9(entry){
  var key;
  if ($contains(this, entry)) {
    key = dynamicCast(entry, Q$Map$Entry).getKey_0();
    this.this$0.remove_3(key);
    return true;
  }
  return false;
}
;
defineSeed(643, 294, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List]));
_.set_0 = function set_2(index, element){
  checkIndex(index, this.size_0);
  return this.wrapped.set_0(this.fromIndex + index, element);
}
;
function $iterator_0(this$static){
  var outerIter;
  outerIter = this$static.val$entrySet.iterator();
  return new AbstractMap$2$1_0(outerIter);
}

function AbstractMap$2_0(this$0, val$entrySet){
  this.this$0 = this$0;
  this.val$entrySet = val$entrySet;
}

defineSeed(646, 295, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection]), AbstractMap$2_0);
_.contains_0 = function contains_3(value){
  return this.this$0.containsValue(value);
}
;
_.iterator = function iterator_6(){
  return $iterator_0(this);
}
;
_.size_1 = function size_6(){
  return this.val$entrySet.size_1();
}
;
_.this$0 = null;
_.val$entrySet = null;
function $next_2(this$static){
  var value;
  value = dynamicCast(this$static.val$outerIter.next_0(), Q$Map$Entry).getValue_1();
  return value;
}

function AbstractMap$2$1_0(val$outerIter){
  this.val$outerIter = val$outerIter;
}

defineSeed(647, 1, {}, AbstractMap$2$1_0);
_.hasNext = function hasNext_3(){
  return this.val$outerIter.hasNext();
}
;
_.next_0 = function next_4(){
  return $next_2(this);
}
;
_.remove_2 = function remove_14(){
  this.val$outerIter.remove_2();
}
;
_.val$outerIter = null;
defineSeed(648, 294, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$AbstractSequentialList, Q$Collection, Q$List]));
_.set_0 = function set_3(index, element){
  var $e0, iter, old;
  iter = $listIterator(this, index);
  try {
    old = $next_5(iter);
    $verifyCurrentElement(iter);
    iter.lastNode.value_0 = element;
    return old;
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NoSuchElementException)) {
      throw new IndexOutOfBoundsException_1("Can't set element " + index);
    }
     else 
      throw $e0;
  }
}
;
function fill(a, toIndex){
  var i;
  for (i = 0; i < toIndex; ++i) {
    a[i] = 0;
  }
}

function insertionSort(array, low, high, comp){
  var i, j, t;
  for (i = low + 1; i < high; ++i) {
    for (j = i; j > low && comp.compare(array[j - 1], array[j]) > 0; --j) {
      t = array[j];
      setCheck(array, j, array[j - 1]);
      setCheck(array, j - 1, t);
    }
  }
}

function merge(src, srcLow, srcMid, srcHigh, dest, destLow, destHigh, comp){
  var topIdx;
  topIdx = srcMid;
  while (destLow < destHigh) {
    topIdx >= srcHigh || srcLow < srcMid && comp.compare(src[srcLow], src[topIdx]) <= 0?setCheck(dest, destLow++, src[srcLow++]):setCheck(dest, destLow++, src[topIdx++]);
  }
}

function mergeSort(x, fromIndex, toIndex, comp){
  var temp;
  temp = cloneSubrange(x, fromIndex, toIndex);
  mergeSort_0(temp, x, fromIndex, toIndex, -fromIndex, comp);
}

function mergeSort_0(temp, array, low, high, ofs, comp){
  var length_0, tempHigh, tempLow, tempMid;
  length_0 = high - low;
  if (length_0 < 7) {
    insertionSort(array, low, high, comp);
    return;
  }
  tempLow = low + ofs;
  tempHigh = high + ofs;
  tempMid = tempLow + (tempHigh - tempLow >> 1);
  mergeSort_0(array, temp, tempLow, tempMid, -ofs, comp);
  mergeSort_0(array, temp, tempMid, tempHigh, -ofs, comp);
  if (comp.compare(temp[tempMid - 1], temp[tempMid]) <= 0) {
    while (low < high) {
      setCheck(array, low++, temp[tempLow++]);
    }
    return;
  }
  merge(temp, tempLow, tempMid, tempHigh, array, low, high, comp);
}

function toString_30(a){
  var b, i;
  if (a == null) {
    return 'null';
  }
  b = new StringBuffer_2('[');
  for (i = 0; i < a.length; ++i) {
    i != 0 && ($append_1(b.data_0, ', ') , b);
    $append_1(b.data_0, '' + a[i]);
  }
  $append_1(b.data_0, ']');
  return $toString_1(b.data_0);
}

function toString_31(x){
  if (x == null) {
    return 'null';
  }
  return $toString_3(new Arrays$ArrayList_0(x));
}

defineSeed(650, 294, makeCastMap([Q$Serializable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List, Q$RandomAccess]));
_.set_0 = function set_4(index, value){
  var was;
  checkIndex(index, this.array.length);
  was = this.array[index];
  setCheck(this.array, index, value);
  return was;
}
;
function replaceContents(target, x){
  var i, size;
  size = target.size_1();
  for (i = 0; i < size; ++i) {
    target.set_0(i, x[i]);
  }
}

function sort_0(target){
  $clinit_Collections();
  var x;
  x = cloneSubrange(target.array, 0, target.size_0);
  mergeSort(x, 0, x.length, ($clinit_Comparators() , $clinit_Comparators() , NATURAL));
  replaceContents(target, x);
}

function sort_1(target, c){
  $clinit_Collections();
  var x;
  x = target.toArray();
  mergeSort(x, 0, x.length, c?c:($clinit_Comparators() , $clinit_Comparators() , NATURAL));
  replaceContents(target, x);
}

defineSeed(653, 634, makeCastMap([Q$Serializable, Q$Map]));
_.containsValue = function containsValue_1(value){
  return false;
}
;
_.values_0 = function values_42(){
  return $clinit_Collections() , EMPTY_LIST;
}
;
function $clinit_Comparators(){
  $clinit_Comparators = nullMethod;
  NATURAL = new Comparators$1_0;
}

var NATURAL;
function Comparators$1_0(){
}

defineSeed(658, 1, makeCastMap([Q$Comparator]), Comparators$1_0);
_.compare = function compare_0(o1, o2){
  return dynamicCast(o1, Q$Comparable).compareTo$(o2);
}
;
defineSeed(662, 634, makeCastMap([Q$Map]));
_.clear_0 = function clear_5(){
  $clear_4(this);
}
;
_.containsValue = function containsValue_2(value){
  var key, key$iterator;
  for (key$iterator = new EnumSet$EnumSetImpl$IteratorImpl_0(this.keySet); key$iterator.i < key$iterator.this$1.all.length;) {
    key = $next_3(key$iterator);
    if (equalsWithNullCheck(value, this.values[key.ordinal])) {
      return true;
    }
  }
  return false;
}
;
_.remove_3 = function remove_17(key){
  return $remove_8(this, key);
}
;
defineSeed(663, 636, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.remove_0 = function remove_18(entry){
  var key;
  if ($contains_0(this, entry)) {
    key = dynamicCast(entry, Q$Map$Entry).getKey_0();
    $remove_8(this.this$0, key);
    return true;
  }
  return false;
}
;
function allOf(elementType){
  var all, set;
  all = dynamicCast($getEnumConstants(elementType), Q$Enum_$1);
  set = dynamicCast(cloneSubrange(all, 0, all.length), Q$Enum_$1);
  return new EnumSet$EnumSetImpl_0(all, set, all.length);
}

function complementOf(other){
  var all, c, i, newSet, oldSet;
  all = other.all;
  oldSet = other.set;
  newSet = dynamicCast(createFrom(oldSet, oldSet.length), Q$Enum_$1);
  for (i = 0 , c = oldSet.length; i < c; ++i) {
    !oldSet[i] && setCheck(newSet, i, all[i]);
  }
  return new EnumSet$EnumSetImpl_0(all, newSet, all.length - other.size_0);
}

function of(first){
  var all, set;
  all = dynamicCast($getEnumConstants($getDeclaringClass(first)), Q$Enum_$1);
  set = dynamicCast(createFrom(all, all.length), Q$Enum_$1);
  setCheck(set, first.ordinal, first);
  return new EnumSet$EnumSetImpl_0(all, set, 1);
}

function of_0(first, rest){
  var all, e, e$index, e$max, ordinal, set, size;
  all = dynamicCast($getEnumConstants($getDeclaringClass(first)), Q$Enum_$1);
  set = dynamicCast(createFrom(all, all.length), Q$Enum_$1);
  setCheck(set, first.ordinal, first);
  size = 1;
  for (e$index = 0 , e$max = rest.length; e$index < e$max; ++e$index) {
    e = rest[e$index];
    ordinal = e.ordinal;
    if (!set[ordinal]) {
      setCheck(set, ordinal, e);
      ++size;
    }
  }
  return new EnumSet$EnumSetImpl_0(all, set, size);
}

defineSeed(667, 666, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$EnumSet, Q$Set]));
_.remove_0 = function remove_20(o){
  return $remove_9(this, o);
}
;
defineSeed(669, 1, {});
function HashSet_1(initialCapacity){
  this.map_0 = new HashMap_1(initialCapacity);
}

defineSeed(671, 636, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]), HashSet_1);
_.remove_0 = function remove_22(o){
  return $remove_10(this, o);
}
;
function LinkedHashMap_1(ignored){
  HashMap_1.call(this, ignored);
  $$init_4(this);
}

function LinkedHashMap_4(toBeCopied){
  $clearImpl(this);
  $$init_4(this);
  $putAll(this, toBeCopied);
}

defineSeed(673, 670, makeCastMap([Q$Serializable, Q$Cloneable, Q$HashMap, Q$Map]), LinkedHashMap_1, LinkedHashMap_4);
_.containsValue = function containsValue_3(value){
  var node;
  node = this.head.next;
  while (node != this.head) {
    if (equalsWithNullCheck(node.value_0, value)) {
      return true;
    }
    node = node.next;
  }
  return false;
}
;
function MissingResourceException_0(s){
  RuntimeException_1.call(this, s);
}

defineSeed(682, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable, Q$MissingResourceException]), MissingResourceException_0);
defineSeed(685, 294, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$Collection, Q$List, Q$RandomAccess, Q$Vector]));
_.set_0 = function set_5(index, elem){
  return $set(this.arrayList, index, elem);
}
;
_.subList = function subList_0(fromIndex, toIndex){
  return new AbstractList$SubList_0(this.arrayList, fromIndex, toIndex);
}
;
defineSeed(687, 634, makeCastMap([Q$Serializable, Q$Map]));
_.clear_0 = function clear_12(){
  $clear_7(this);
}
;
_.remove_3 = function remove_27(keyObj){
  return $remove_15(this, keyObj);
}
;
defineSeed(690, 636, makeCastMap([Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.remove_0 = function remove_29(o){
  var entry, state;
  if (!instanceOf(o, Q$Map$Entry)) {
    return false;
  }
  entry = dynamicCast(o, Q$Map$Entry);
  state = new TreeMap$State_0;
  state.matchValue = true;
  state.value_0 = entry.getValue_1();
  return $removeWithState(this.this$0, entry.getKey_0(), state);
}
;
defineSeed(698, 636, makeCastMap([Q$Serializable, Q$Iterable, Q$AbstractCollection, Q$Collection, Q$Set]));
_.remove_0 = function remove_30(o){
  return $remove_15(this.map_0, o) != null;
}
;
function $setCategory(this$static, category){
  this$static.category = category;
}

function $setComparator(this$static, comparator){
  this$static.comparator = comparator;
}

function $setMeasurementDefinition(this$static, measurementDefinition){
  this$static.measurementDefinition = measurementDefinition;
}

function $setName_1(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setOption(this$static, option){
  this$static.option = option;
}

function $setThreshold(this$static, threshold){
  this$static.threshold = threshold;
}

function $setTriggerId(this$static, triggerId){
  this$static.triggerId = triggerId;
}

function AlertCondition_1(cond){
  $$init_5(this);
  this.category = cond.category;
  this.measurementDefinition = cond.measurementDefinition;
  this.name_0 = cond.name_0;
  this.comparator = cond.comparator;
  this.threshold = cond.threshold;
  this.option = cond.option;
  this.triggerId = cond.triggerId;
}

defineSeed(721, 1, makeCastMap([Q$Serializable, Q$AlertCondition]), AlertCondition_1);
function $clinit_AlertConditionOperator(){
  $clinit_AlertConditionOperator = nullMethod;
  LESS_THAN_OR_EQUAL_TO = new AlertConditionOperator_0('LESS_THAN_OR_EQUAL_TO', 0);
  LESS_THAN = new AlertConditionOperator_0('LESS_THAN', 1);
  EQUALS = new AlertConditionOperator_0('EQUALS', 2);
  REGEX = new AlertConditionOperator_0('REGEX', 3);
  GREATER_THAN = new AlertConditionOperator_0('GREATER_THAN', 4);
  GREATER_THAN_OR_EQUAL_TO = new AlertConditionOperator_0('GREATER_THAN_OR_EQUAL_TO', 5);
  CHANGES = new AlertConditionOperator_0('CHANGES', 6);
  CHANGES_TO = new AlertConditionOperator_0('CHANGES_TO', 7);
  CHANGES_FROM = new AlertConditionOperator_0('CHANGES_FROM', 8);
  AVAIL_GOES_DOWN = new AlertConditionOperator_0('AVAIL_GOES_DOWN', 9);
  AVAIL_GOES_DISABLED = new AlertConditionOperator_0('AVAIL_GOES_DISABLED', 10);
  AVAIL_GOES_UNKNOWN = new AlertConditionOperator_0('AVAIL_GOES_UNKNOWN', 11);
  AVAIL_GOES_NOT_UP = new AlertConditionOperator_0('AVAIL_GOES_NOT_UP', 12);
  AVAIL_GOES_UP = new AlertConditionOperator_0('AVAIL_GOES_UP', 13);
  AVAIL_DURATION_DOWN = new AlertConditionOperator_0('AVAIL_DURATION_DOWN', 14);
  AVAIL_DURATION_NOT_UP = new AlertConditionOperator_0('AVAIL_DURATION_NOT_UP', 15);
  $VALUES_42 = initValues(_3Lorg_rhq_core_domain_alert_AlertConditionOperator_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$AlertConditionOperator, [LESS_THAN_OR_EQUAL_TO, LESS_THAN, EQUALS, REGEX, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, CHANGES, CHANGES_TO, CHANGES_FROM, AVAIL_GOES_DOWN, AVAIL_GOES_DISABLED, AVAIL_GOES_UNKNOWN, AVAIL_GOES_NOT_UP, AVAIL_GOES_UP, AVAIL_DURATION_DOWN, AVAIL_DURATION_NOT_UP]);
}

function AlertConditionOperator_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_51(name_0){
  $clinit_AlertConditionOperator();
  return valueOf(($clinit_AlertConditionOperator$Map() , $MAP_42), name_0);
}

function values_45(){
  $clinit_AlertConditionOperator();
  return $VALUES_42;
}

defineSeed(727, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$AlertConditionOperator]), AlertConditionOperator_0);
var $VALUES_42, AVAIL_DURATION_DOWN, AVAIL_DURATION_NOT_UP, AVAIL_GOES_DISABLED, AVAIL_GOES_DOWN, AVAIL_GOES_NOT_UP, AVAIL_GOES_UNKNOWN, AVAIL_GOES_UP, CHANGES, CHANGES_FROM, CHANGES_TO, EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO, REGEX;
function $clinit_AlertConditionOperator$Map(){
  $clinit_AlertConditionOperator$Map = nullMethod;
  $MAP_42 = createValueOfMap(($clinit_AlertConditionOperator() , $VALUES_42));
}

var $MAP_42;
function $setPeriod(this$static, period){
  this$static.period = period;
}

function $setPeriodUnits(this$static, periodUnits){
  this$static.periodUnits = periodUnits;
}

function $setValue_11(this$static, value){
  this$static.value_0 = value;
}

function AlertDampening_1(category){
  $$init_6(this);
  this.category = category;
}

defineSeed(731, 1, makeCastMap([Q$Serializable, Q$AlertDampening]), AlertDampening_1);
function $removeAllConditions(this$static){
  var condition, condition$iterator;
  for (condition$iterator = this$static.conditions.iterator(); condition$iterator.hasNext();) {
    condition = dynamicCast(condition$iterator.next_0(), Q$AlertCondition);
    condition.alertDefinition = null;
  }
  this$static.conditions.clear_0();
}

function $setAlertDampening(this$static, alertDampening){
  this$static.alertDampening = alertDampening;
}

function $setAlertNotifications(this$static, alertNotifications){
  !alertNotifications && (alertNotifications = new ArrayList_0);
  this$static.alertNotifications = alertNotifications;
}

function $setConditionExpression(this$static, conditionExpression){
  this$static.conditionExpression = conditionExpression;
}

function $setConditions(this$static, conditions){
  var condition, condition$iterator;
  $removeAllConditions(this$static);
  if (conditions) {
    for (condition$iterator = $iterator($keySet(conditions.map_0)); condition$iterator.val$outerIter.hasNext();) {
      condition = dynamicCast($next_1(condition$iterator), Q$AlertCondition);
      this$static.conditions.add(condition);
      condition.alertDefinition = this$static;
    }
  }
}

function $setDescription(this$static, description){
  this$static.description = description;
}

function $setEnabled(this$static, enabled){
  this$static.enabled = enabled;
}

function $setGroup(this$static, group){
  this$static.group = group;
}

function $setId(this$static, id){
  this$static.id = id;
}

function $setName_2(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setParentId(this$static, parentId){
  this$static.parentId = parentId;
}

function $setPriority(this$static, priority){
  this$static.priority = priority;
}

function $setReadOnly(this$static, readOnly){
  this$static.readOnly = readOnly;
}

function $setRecoveryId(this$static, actOnTriggerId){
  if (this$static.willRecover && actOnTriggerId.value_0 != 0) {
    throw new IllegalStateException_1('An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.');
  }
  this$static.recoveryId = actOnTriggerId;
}

function $setResource(this$static, resource){
  this$static.resource = resource;
  !!this$static.resource && $getAlertDefinitions(this$static.resource).add(this$static);
}

function $setResourceType(this$static, resourceType){
  this$static.resourceType = resourceType;
}

function $setWillRecover(this$static, willRecover){
  if (willRecover && this$static.recoveryId.value_0 != 0) {
    throw new IllegalStateException_1('An alert definition can either be a recovery definition or a definition to-be-recovered, but not both.');
  }
  this$static.willRecover = willRecover;
}

function serialize_47(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $setAlertDefinition(this$static, alertDefinition){
  if (!alertDefinition) {
    throw new IllegalArgumentException_1('alertDefinition must be non-null.');
  }
  this$static.alertDefinition = alertDefinition;
}

function $setConfiguration(this$static, configuration){
  if (!configuration) {
    throw new IllegalArgumentException_1('configuration must be non-null');
  }
  this$static.configuration = configuration;
}

function $setExtraConfiguration(this$static, extraConfiguration){
  this$static.extraConfiguration = extraConfiguration;
}

function AlertNotification_1(sender){
  this.senderName = sender;
}

defineSeed(754, 1, makeCastMap([Q$Serializable, Q$AlertNotification]), AlertNotification_1);
function $setFactive(this$static, factive){
  this$static.factive = factive;
}

function $setFsystem(this$static, fsystem){
  this$static.fsystem = fsystem;
}

function $setId_0(this$static, id){
  this$static.id = id;
}

function $setRoles(this$static, roles){
  this$static.roles = roles;
}

function $addPermission(this$static, permission){
  this$static.permissions.add(permission);
}

function $setDescription_0(this$static, description){
  this$static.description = description;
}

function $setId_1(this$static, id){
  this$static.id = id;
}

function $setName_4(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setResourceGroups(this$static, resourceGroups){
  var resourceGroup, resourceGroup$iterator;
  if (!resourceGroups) {
    this$static.resourceGroups = new HashSet_0;
  }
   else {
    this$static.resourceGroups = resourceGroups;
    for (resourceGroup$iterator = this$static.resourceGroups.iterator(); resourceGroup$iterator.hasNext();) {
      resourceGroup = dynamicCast(resourceGroup$iterator.next_0(), Q$ResourceGroup);
      (!resourceGroup.roles && (resourceGroup.roles = new HashSet_0) , resourceGroup.roles).add(this$static);
      this$static.resourceGroups.add(resourceGroup);
    }
  }
}

function $setSubjects(this$static, subjects){
  var subject, subject$iterator;
  if (!subjects) {
    this$static.subjects = new HashSet_0;
  }
   else {
    this$static.subjects = subjects;
    for (subject$iterator = $iterator($keySet(subjects.map_0)); subject$iterator.val$outerIter.hasNext();) {
      subject = dynamicCast($next_1(subject$iterator), Q$Subject);
      !subject.roles && (subject.roles = new HashSet_0);
      subject.roles.add(this$static);
      this$static.subjects.add(subject);
    }
  }
}

function $setBundleVersion(this$static, bundleVersion){
  this$static.bundleVersion = bundleVersion;
}

function $setResourceDeployments(this$static, resourceDeployments){
  this$static.resourceDeployments = resourceDeployments;
}

function $setDeployDir(this$static, deployDir){
  this$static.deployDir = deployDir;
}

function $setDescription_1(this$static, description){
  this$static.description = description;
}

function $setDestinationBaseDirectoryName(this$static, destinationBaseDirectoryName){
  this$static.destinationBaseDirectoryName = destinationBaseDirectoryName;
}

function $setName_5(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setBundle(this$static, bundle){
  this$static.bundle = bundle;
}

function $getBundleDestinationBaseDirectories(this$static){
  var bdbd, description, list, listItem, listItem$iterator, map, name_0, propertyList, retVal, valueContext, valueName;
  if (!this$static.bundleConfiguration) {
    return null;
  }
  propertyList = $getList(this$static.bundleConfiguration, 'bundleDestBaseDirsList');
  if (!propertyList) {
    return null;
  }
  list = (!propertyList.list && (propertyList.list = new ArrayList_0) , propertyList.list);
  if (list.size_1() == 0) {
    return null;
  }
  retVal = new HashSet_1(list.size_1());
  for (listItem$iterator = list.iterator(); listItem$iterator.hasNext();) {
    listItem = dynamicCast(listItem$iterator.next_0(), Q$Property);
    map = dynamicCast(listItem, Q$PropertyMap);
    name_0 = $getSimpleValue_0(map, 'name', null);
    valueContext = $getSimpleValue_0(map, 'valueContext', null);
    valueName = $getSimpleValue_0(map, 'valueName', null);
    description = $getSimpleValue_0(map, 'description', null);
    bdbd = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0(name_0, valueContext, valueName, description);
    $add_6(retVal, bdbd);
  }
  return retVal;
}

function ResourceTypeBundleConfiguration_0(){
  this.bundleConfiguration = null;
}

defineSeed(804, 1, makeCastMap([Q$Serializable, Q$ResourceTypeBundleConfiguration]), ResourceTypeBundleConfiguration_0);
function ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0(name_0, valueContext, valueName, description){
  if (name_0 == null) {
    throw new NullPointerException_1('name == null');
  }
  this.name_0 = name_0;
  this.valueContext = ($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context() , dynamicCast(valueOf(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map() , $MAP_54), valueContext), Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context));
  this.valueName = valueName;
  this.description = description;
}

defineSeed(805, 1, makeCastMap([Q$Serializable, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory]), ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory_0);
_.equals$ = function equals_38(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory);
  return $equals_6(this.name_0, other.name_0);
}
;
_.hashCode$ = function hashCode_38(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_60(){
  var builder;
  builder = new StringBuilder_0;
  $append_12($append_12($append_12($append_12($append_12($append_11($append_12($append_12(($append_1(builder.data_0, 'BundleDestinationBaseDirectory [name=') , builder), this.name_0), ', valueContext='), this.valueContext), ', valueName='), this.valueName), ', description='), this.description), ']');
  return $toString_1(builder.data_0);
}
;
_.description = null;
_.name_0 = null;
_.valueContext = null;
_.valueName = null;
function $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context = nullMethod;
  pluginConfiguration_0 = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('pluginConfiguration', 0);
  resourceConfiguration_0 = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('resourceConfiguration', 1);
  measurementTrait = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('measurementTrait', 2);
  fileSystem = new ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0('fileSystem', 3);
  $VALUES_54 = initValues(_3Lorg_rhq_core_domain_bundle_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context, [pluginConfiguration_0, resourceConfiguration_0, measurementTrait, fileSystem]);
}

function ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_63(name_0){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context();
  return valueOf(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map() , $MAP_54), name_0);
}

function values_57(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context();
  return $VALUES_54;
}

defineSeed(806, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context]), ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context_0);
var $VALUES_54, fileSystem, measurementTrait, pluginConfiguration_0, resourceConfiguration_0;
function $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map(){
  $clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context$Map = nullMethod;
  $MAP_54 = createValueOfMap(($clinit_ResourceTypeBundleConfiguration$BundleDestinationBaseDirectory$Context() , $VALUES_54));
}

var $MAP_54;
function deserialize_128(streamReader, instance){
  setBundleConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
}

function instantiate_125(streamReader){
  return new ResourceTypeBundleConfiguration_0;
}

function setBundleConfiguration(instance, value){
  instance.bundleConfiguration = value;
}

function BundleWithLatestVersionComposite_0(){
}

defineSeed(809, 1, makeCastMap([Q$Serializable, Q$BundleWithLatestVersionComposite]), BundleWithLatestVersionComposite_0);
_.toString$ = function toString_61(){
  var builder;
  builder = new StringBuilder_0;
  $append_11(($append_1(builder.data_0, 'BundleWithLatestVersionComposite [bundleId=') , builder), this.bundleId);
  $append_12(($append_1(builder.data_0, ', bundleName=') , builder), this.bundleName);
  $append_12(($append_1(builder.data_0, ', bundleDescription=') , builder), this.bundleDescription);
  $append_12(($append_1(builder.data_0, ', latestVersion=') , builder), this.latestVersion);
  $append_11(($append_1(builder.data_0, ', versionsCount=') , builder), this.versionsCount);
  $append_1(builder.data_0, ']');
  return $toString_1(builder.data_0);
}
;
_.bundleDescription = null;
_.bundleId = null;
_.bundleName = null;
_.latestVersion = null;
_.versionsCount = null;
function deserialize_129(streamReader, instance){
  setBundleDescription(instance, $getString(streamReader, $readInt(streamReader)));
  setBundleId(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setBundleName(instance, $getString(streamReader, $readInt(streamReader)));
  setLatestVersion(instance, $getString(streamReader, $readInt(streamReader)));
  setVersionsCount(instance, dynamicCast($readObject(streamReader), Q$Long));
}

function instantiate_126(streamReader){
  return new BundleWithLatestVersionComposite_0;
}

function setBundleDescription(instance, value){
  instance.bundleDescription = value;
}

function setBundleId(instance, value){
  instance.bundleId = value;
}

function setBundleName(instance, value){
  instance.bundleName = value;
}

function setLatestVersion(instance, value){
  instance.latestVersion = value;
}

function setVersionsCount(instance, value){
  instance.versionsCount = value;
}

function $setName_6(this$static, name_0){
  this$static.name_0 = name_0;
}

function AffinityGroup_1(name_0){
  $$init_7(this);
  this.name_0 = name_0;
}

defineSeed(811, 1, makeCastMap([Q$Serializable, Q$AffinityGroup]), AffinityGroup_1);
function $equals_16(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$FailoverList)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$FailoverList);
  if (this$static.agentId != other.agentId) {
    return false;
  }
  if (neq(this$static.ctime, other.ctime)) {
    return false;
  }
  return true;
}

function FailoverList_0(){
  this.serverList = new ArrayList_0;
}

defineSeed(813, 1, makeCastMap([Q$Serializable, Q$FailoverList]), FailoverList_0);
_.equals$ = function equals_40(obj_0){
  return $equals_16(this, obj_0);
}
;
_.hashCode$ = function hashCode_40(){
  var result;
  result = 31 + this.agentId;
  result = 31 * result + toInt(xor(this.ctime, shru(this.ctime, 32)));
  return result;
}
;
_.agentId = 0;
_.ctime = P0_longLit;
_.id = 0;
function FailoverListDetails_0(){
}

defineSeed(814, 1, makeCastMap([Q$Serializable, Q$FailoverListDetails]), FailoverListDetails_0);
_.equals$ = function equals_41(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$FailoverListDetails)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$FailoverListDetails);
  if (!this.failoverList) {
    if (other.failoverList) {
      return false;
    }
  }
   else if (!$equals_16(this.failoverList, other.failoverList)) {
    return false;
  }
  if (this.ordinal != other.ordinal) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_41(){
  var result;
  result = 31 + this.serverId;
  return result;
}
;
_.failoverList = null;
_.id = 0;
_.ordinal = 0;
_.server = null;
_.serverId = 0;
function deserialize_131(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_128(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_FailoverListDetails_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FailoverListDetails, size, 0);
}

function deserialize_132(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.failoverList = dynamicCast($readObject(streamReader), Q$FailoverList);
  setId_17(instance, $readInt(streamReader));
  setOrdinal(instance, $readInt(streamReader));
  instance.server = dynamicCast($readObject(streamReader), Q$Server);
  setServerId(instance, $readInt(streamReader));
}

function instantiate_129(streamReader){
  return new FailoverListDetails_0;
}

function setId_17(instance, value){
  instance.id = value;
}

function setOrdinal(instance, value){
  instance.ordinal = value;
}

function setServerId(instance, value){
  instance.serverId = value;
}

function deserialize_133(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_130(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_FailoverList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FailoverList, size, 0);
}

function deserialize_134(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  dynamicCast($readObject(streamReader), Q$Agent);
  setAgentId(instance, $readInt(streamReader));
  setCtime_5(instance, $readLong(streamReader));
  setId_18(instance, $readInt(streamReader));
  dynamicCast($readObject(streamReader), Q$PartitionEvent);
  setServerList(instance, dynamicCast($readObject(streamReader), Q$List));
}

function instantiate_131(streamReader){
  return new FailoverList_0;
}

function setAgentId(instance, value){
  instance.agentId = value;
}

function setCtime_5(instance, value){
  instance.ctime = value;
}

function setId_18(instance, value){
  instance.id = value;
}

function setServerList(instance, value){
  instance.serverList = value;
}

function $equals_17(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$PartitionEvent)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PartitionEvent);
  if (neq(this$static.ctime, other.ctime)) {
    return false;
  }
  if (this$static.subjectName == null) {
    if (other.subjectName != null) {
      return false;
    }
  }
   else if (!$equals_6(this$static.subjectName, other.subjectName)) {
    return false;
  }
  return true;
}

function $hashCode_6(this$static){
  var result;
  result = 31 + toInt(xor(this$static.ctime, shru(this$static.ctime, 32)));
  result = 31 * result + (this$static.subjectName == null?0:getHashCode_0(this$static.subjectName));
  return result;
}

function PartitionEvent_0(){
  this.partitionDetails = new ArrayList_0;
  this.serverLists = new ArrayList_0;
}

defineSeed(819, 1, makeCastMap([Q$Serializable, Q$PartitionEvent]), PartitionEvent_0);
_.equals$ = function equals_42(obj_0){
  return $equals_17(this, obj_0);
}
;
_.hashCode$ = function hashCode_42(){
  return $hashCode_6(this);
}
;
_.ctime = P0_longLit;
_.eventDetail = null;
_.eventType = null;
_.executionStatus = null;
_.id = 0;
_.subjectName = null;
function $clinit_PartitionEvent$ExecutionStatus(){
  $clinit_PartitionEvent$ExecutionStatus = nullMethod;
  AUDIT = new PartitionEvent$ExecutionStatus_0('AUDIT', 0);
  COMPLETED = new PartitionEvent$ExecutionStatus_0('COMPLETED', 1);
  IMMEDIATE = new PartitionEvent$ExecutionStatus_0('IMMEDIATE', 2);
  REQUESTED = new PartitionEvent$ExecutionStatus_0('REQUESTED', 3);
  $VALUES_55 = initValues(_3Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEvent$ExecutionStatus_$1]), Q$PartitionEvent$ExecutionStatus, [AUDIT, COMPLETED, IMMEDIATE, REQUESTED]);
}

function PartitionEvent$ExecutionStatus_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_64(name_0){
  $clinit_PartitionEvent$ExecutionStatus();
  return valueOf(($clinit_PartitionEvent$ExecutionStatus$Map() , $MAP_55), name_0);
}

function values_58(){
  $clinit_PartitionEvent$ExecutionStatus();
  return $VALUES_55;
}

defineSeed(820, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PartitionEvent$ExecutionStatus]), PartitionEvent$ExecutionStatus_0);
var $VALUES_55, AUDIT, COMPLETED, IMMEDIATE, REQUESTED;
function $clinit_PartitionEvent$ExecutionStatus$Map(){
  $clinit_PartitionEvent$ExecutionStatus$Map = nullMethod;
  $MAP_55 = createValueOfMap(($clinit_PartitionEvent$ExecutionStatus() , $VALUES_55));
}

var $MAP_55;
function PartitionEventDetails_0(){
}

defineSeed(822, 1, makeCastMap([Q$Serializable, Q$PartitionEventDetails]), PartitionEventDetails_0);
_.equals$ = function equals_43(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$PartitionEventDetails)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PartitionEventDetails);
  if (this.agentName == null) {
    if (other.agentName != null) {
      return false;
    }
  }
   else if (!$equals_6(this.agentName, other.agentName)) {
    return false;
  }
  if (this.serverName == null) {
    if (other.serverName != null) {
      return false;
    }
  }
   else if (!$equals_6(this.serverName, other.serverName)) {
    return false;
  }
  if (!this.partitionEvent) {
    if (other.partitionEvent) {
      return false;
    }
  }
   else if (!$equals_17(this.partitionEvent, other.partitionEvent)) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_43(){
  var result;
  result = 31 + (this.agentName == null?0:getHashCode_0(this.agentName));
  result = 31 * result + (!this.partitionEvent?0:$hashCode_6(this.partitionEvent));
  result = 31 * result + (this.serverName == null?0:getHashCode_0(this.serverName));
  return result;
}
;
_.agentName = null;
_.id = 0;
_.partitionEvent = null;
_.serverName = null;
function deserialize_135(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_132(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEventDetails_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PartitionEventDetails, size, 0);
}

function deserialize_136(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.agentName = $getString(streamReader, $readInt(streamReader));
  setId_19(instance, $readInt(streamReader));
  instance.partitionEvent = dynamicCast($readObject(streamReader), Q$PartitionEvent);
  instance.serverName = $getString(streamReader, $readInt(streamReader));
}

function instantiate_133(streamReader){
  return new PartitionEventDetails_0;
}

function setId_19(instance, value){
  instance.id = value;
}

function $clinit_PartitionEventType(){
  $clinit_PartitionEventType = nullMethod;
  AGENT_REGISTRATION = new PartitionEventType_0('AGENT_REGISTRATION', 0);
  AGENT_CONNECT = new PartitionEventType_0('AGENT_CONNECT', 1);
  AGENT_SHUTDOWN = new PartitionEventType_0('AGENT_SHUTDOWN', 2);
  AGENT_LEAVE = new PartitionEventType_0('AGENT_LEAVE', 3);
  SERVER_DELETION = new PartitionEventType_0('SERVER_DELETION', 4);
  SERVER_COMPUTE_POWER_CHANGE = new PartitionEventType_0('SERVER_COMPUTE_POWER_CHANGE', 5);
  OPERATION_MODE_CHANGE = new PartitionEventType_0('OPERATION_MODE_CHANGE', 6);
  AGENT_AFFINITY_GROUP_ASSIGN = new PartitionEventType_0('AGENT_AFFINITY_GROUP_ASSIGN', 7);
  AGENT_AFFINITY_GROUP_REMOVE = new PartitionEventType_0('AGENT_AFFINITY_GROUP_REMOVE', 8);
  SERVER_AFFINITY_GROUP_ASSIGN = new PartitionEventType_0('SERVER_AFFINITY_GROUP_ASSIGN', 9);
  SERVER_AFFINITY_GROUP_REMOVE = new PartitionEventType_0('SERVER_AFFINITY_GROUP_REMOVE', 10);
  AFFINITY_GROUP_CHANGE = new PartitionEventType_0('AFFINITY_GROUP_CHANGE', 11);
  AFFINITY_GROUP_DELETE = new PartitionEventType_0('AFFINITY_GROUP_DELETE', 12);
  ADMIN_INITIATED_PARTITION = new PartitionEventType_0('ADMIN_INITIATED_PARTITION', 13);
  SYSTEM_INITIATED_PARTITION = new PartitionEventType_0('SYSTEM_INITIATED_PARTITION', 14);
  $VALUES_56 = initValues(_3Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEventType_$1]), Q$PartitionEventType, [AGENT_REGISTRATION, AGENT_CONNECT, AGENT_SHUTDOWN, AGENT_LEAVE, SERVER_DELETION, SERVER_COMPUTE_POWER_CHANGE, OPERATION_MODE_CHANGE, AGENT_AFFINITY_GROUP_ASSIGN, AGENT_AFFINITY_GROUP_REMOVE, SERVER_AFFINITY_GROUP_ASSIGN, SERVER_AFFINITY_GROUP_REMOVE, AFFINITY_GROUP_CHANGE, AFFINITY_GROUP_DELETE, ADMIN_INITIATED_PARTITION, SYSTEM_INITIATED_PARTITION]);
}

function PartitionEventType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_65(name_0){
  $clinit_PartitionEventType();
  return valueOf(($clinit_PartitionEventType$Map() , $MAP_56), name_0);
}

function values_59(){
  $clinit_PartitionEventType();
  return $VALUES_56;
}

defineSeed(825, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PartitionEventType]), PartitionEventType_0);
var $VALUES_56, ADMIN_INITIATED_PARTITION, AFFINITY_GROUP_CHANGE, AFFINITY_GROUP_DELETE, AGENT_AFFINITY_GROUP_ASSIGN, AGENT_AFFINITY_GROUP_REMOVE, AGENT_CONNECT, AGENT_LEAVE, AGENT_REGISTRATION, AGENT_SHUTDOWN, OPERATION_MODE_CHANGE, SERVER_AFFINITY_GROUP_ASSIGN, SERVER_AFFINITY_GROUP_REMOVE, SERVER_COMPUTE_POWER_CHANGE, SERVER_DELETION, SYSTEM_INITIATED_PARTITION;
function $clinit_PartitionEventType$Map(){
  $clinit_PartitionEventType$Map = nullMethod;
  $MAP_56 = createValueOfMap(($clinit_PartitionEventType() , $VALUES_56));
}

var $MAP_56;
function serialize_78(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_137(streamReader, instance){
}

function instantiate_134(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PartitionEventType() , $clinit_PartitionEventType() , $VALUES_56);
  return values[ordinal];
}

function serialize_79(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function serialize_80(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_138(streamReader, instance){
}

function instantiate_135(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PartitionEvent$ExecutionStatus() , $clinit_PartitionEvent$ExecutionStatus() , $VALUES_55);
  return values[ordinal];
}

function serialize_81(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_139(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCtime_6(instance, $readLong(streamReader));
  setEventDetail(instance, $getString(streamReader, $readInt(streamReader)));
  setEventType_0(instance, dynamicCast($readObject(streamReader), Q$PartitionEventType));
  setExecutionStatus(instance, dynamicCast($readObject(streamReader), Q$PartitionEvent$ExecutionStatus));
  setId_20(instance, $readInt(streamReader));
  setPartitionDetails(instance, dynamicCast($readObject(streamReader), Q$List));
  setServerLists(instance, dynamicCast($readObject(streamReader), Q$List));
  instance.subjectName = $getString(streamReader, $readInt(streamReader));
}

function instantiate_136(streamReader){
  return new PartitionEvent_0;
}

function setCtime_6(instance, value){
  instance.ctime = value;
}

function setEventDetail(instance, value){
  instance.eventDetail = value;
}

function setEventType_0(instance, value){
  instance.eventType = value;
}

function setExecutionStatus(instance, value){
  instance.executionStatus = value;
}

function setId_20(instance, value){
  instance.id = value;
}

function setPartitionDetails(instance, value){
  instance.partitionDetails = value;
}

function setServerLists(instance, value){
  instance.serverLists = value;
}

function $setAddress(this$static, address){
  this$static.address = address;
}

function $setOperationMode(this$static, operationMode){
  this$static.operationMode = operationMode;
}

function $setPort(this$static, port){
  this$static.port = port;
}

function $setSecurePort(this$static, securePort){
  this$static.securePort = securePort;
}

function serialize_84(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function AffinityGroupCountComposite_0(){
}

defineSeed(839, 1, makeCastMap([Q$Serializable, Q$AffinityGroupCountComposite]), AffinityGroupCountComposite_0);
_.affinityGroup = null;
_.agentCount = 0;
_.serverCount = 0;
function deserialize_143(streamReader, instance){
  setAffinityGroup_0(instance, dynamicCast($readObject(streamReader), Q$AffinityGroup));
  setAgentCount(instance, $readInt(streamReader));
  setServerCount(instance, $readInt(streamReader));
}

function instantiate_140(streamReader){
  return new AffinityGroupCountComposite_0;
}

function setAffinityGroup_0(instance, value){
  instance.affinityGroup = value;
}

function setAgentCount(instance, value){
  instance.agentCount = value;
}

function setServerCount(instance, value){
  instance.serverCount = value;
}

function ServerWithAgentCountComposite_0(){
}

defineSeed(841, 1, makeCastMap([Q$Serializable, Q$ServerWithAgentCountComposite]), ServerWithAgentCountComposite_0);
_.agentCount = 0;
_.server = null;
function deserialize_144(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_141(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_cloud_composite_ServerWithAgentCountComposite_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ServerWithAgentCountComposite, size, 0);
}

function deserialize_145(streamReader, instance){
  setAgentCount_0(instance, $readInt(streamReader));
  setServer(instance, dynamicCast($readObject(streamReader), Q$Server));
}

function instantiate_142(streamReader){
  return new ServerWithAgentCountComposite_0;
}

function setAgentCount_0(instance, value){
  instance.agentCount = value;
}

function setServer(instance, value){
  instance.server = value;
}

function $isAutoCluster(this$static){
  return ($clinit_EntityContext$Type() , ResourceGroup) == this$static.type_0 && this$static.isAutoCluster;
}

function $isAutoGroup(this$static){
  return ($clinit_EntityContext$Type() , ResourceGroup) == this$static.type_0 && this$static.isAutoGroup;
}

function $toShortString(this$static){
  switch (this$static.type_0.ordinal) {
    case 0:
      return 'resource[id=' + this$static.resourceId + ']';
    case 2:
      return 'resourceGroup[groupId=' + this$static.resourceId + ']';
    case 3:
      return 'autoGroup[parent=' + this$static.parentResourceId + ',type=' + this$static.resourceTypeId + ']';
    case 1:
      return 'template[type=' + this$static.resourceTypeId + ']';
    default:return 'EntityContext[category=' + this$static.type_0 + ',resourceId=' + this$static.resourceId + ',groupId=' + this$static.groupId + ',parent=' + this$static.parentResourceId + ',type=' + this$static.resourceTypeId + ']';
  }
}

function forGroup(groupId, isAutoCluster, isAutoGroup){
  var context;
  context = new EntityContext_0(null, valueOf_44(groupId), null);
  context.isAutoCluster = isAutoCluster;
  context.isAutoGroup = isAutoGroup;
  return context;
}

function serialize_86(streamWriter, instance){
  $writeInt(streamWriter, instance.groupId);
  $writeBoolean(streamWriter, instance.isAutoCluster);
  $writeBoolean(streamWriter, instance.isAutoGroup);
  $writeInt(streamWriter, instance.parentResourceId);
  $writeInt(streamWriter, instance.resourceId);
  $writeInt(streamWriter, instance.resourceTypeId);
  $writeObject(streamWriter, instance.type_0);
}

function serialize_87(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function JobTrigger_0(){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , NONE_6), null);
}

function JobTrigger_1(repeatInterval, repeatCount){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.repeatInterval = valueOf_45(repeatInterval);
  this.repeatCount = valueOf_44(repeatCount);
}

function JobTrigger_2(repeatInterval, endDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , DATETIME_0));
  this.repeatInterval = valueOf_45(repeatInterval);
  this.endDate = endDate;
}

function JobTrigger_3(cronExpression){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , NOW), ($clinit_JobTrigger$RecurrenceType() , CRON_EXPRESSION), ($clinit_JobTrigger$EndType() , NEVER));
  this.cronExpression = cronExpression;
}

function JobTrigger_4(startDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , NONE_6), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.startDate = startDate;
  this.repeatCount = valueOf_44(1);
}

function JobTrigger_5(startDate, repeatInterval, repeatCount){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , REPEAT_COUNT));
  this.startDate = startDate;
  this.repeatInterval = valueOf_45(repeatInterval);
  this.repeatCount = valueOf_44(repeatCount);
}

function JobTrigger_6(startDate, repeatInterval, endDate){
  JobTrigger_7.call(this, ($clinit_JobTrigger$StartType() , DATETIME_1), ($clinit_JobTrigger$RecurrenceType() , REPEAT_INTERVAL), ($clinit_JobTrigger$EndType() , DATETIME_0));
  this.startDate = startDate;
  this.repeatInterval = valueOf_45(repeatInterval);
  this.endDate = endDate;
}

function JobTrigger_7(startType, recurrenceType, endType){
  this.startType = startType;
  this.recurrenceType = recurrenceType;
  this.endType = endType;
}

defineSeed(849, 1, makeCastMap([Q$Serializable, Q$JobTrigger]), JobTrigger_0, JobTrigger_1, JobTrigger_2, JobTrigger_3, JobTrigger_4, JobTrigger_5, JobTrigger_6);
_.toString$ = function toString_64(){
  var sb;
  sb = new StringBuilder_0;
  $append_1(sb.data_0, 'Trigger');
  $append_7($append_12(($append_1(sb.data_0, "[cronExpression='") , sb), this.cronExpression), 39);
  $append_11(($append_1(sb.data_0, ', startType=') , sb), this.startType);
  $append_11(($append_1(sb.data_0, ', recurrenceType=') , sb), this.recurrenceType);
  $append_11(($append_1(sb.data_0, ', endType=') , sb), this.endType);
  $append_11(($append_1(sb.data_0, ', startDate=') , sb), this.startDate);
  $append_11(($append_1(sb.data_0, ', repeatInterval=') , sb), this.repeatInterval);
  $append_11(($append_1(sb.data_0, ', endDate=') , sb), this.endDate);
  $append_11(($append_1(sb.data_0, ', repeatCount=') , sb), this.repeatCount);
  $appendNonNull(sb.data_0, ']');
  return $toString_1(sb.data_0);
}
;
_.cronExpression = null;
_.endDate = null;
_.endType = null;
_.recurrenceType = null;
_.repeatCount = null;
_.repeatInterval = null;
_.startDate = null;
_.startType = null;
function $clinit_JobTrigger$EndType(){
  $clinit_JobTrigger$EndType = nullMethod;
  NEVER = new JobTrigger$EndType_0('NEVER', 0);
  DATETIME_0 = new JobTrigger$EndType_0('DATETIME', 1);
  REPEAT_COUNT = new JobTrigger$EndType_0('REPEAT_COUNT', 2);
  $VALUES_59 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$EndType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$EndType, [NEVER, DATETIME_0, REPEAT_COUNT]);
}

function JobTrigger$EndType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_68(name_0){
  $clinit_JobTrigger$EndType();
  return valueOf(($clinit_JobTrigger$EndType$Map() , $MAP_59), name_0);
}

function values_62(){
  $clinit_JobTrigger$EndType();
  return $VALUES_59;
}

defineSeed(850, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$EndType]), JobTrigger$EndType_0);
var $VALUES_59, DATETIME_0, NEVER, REPEAT_COUNT;
function $clinit_JobTrigger$EndType$Map(){
  $clinit_JobTrigger$EndType$Map = nullMethod;
  $MAP_59 = createValueOfMap(($clinit_JobTrigger$EndType() , $VALUES_59));
}

var $MAP_59;
function $clinit_JobTrigger$RecurrenceType(){
  $clinit_JobTrigger$RecurrenceType = nullMethod;
  NONE_6 = new JobTrigger$RecurrenceType_0('NONE', 0);
  REPEAT_INTERVAL = new JobTrigger$RecurrenceType_0('REPEAT_INTERVAL', 1);
  CRON_EXPRESSION = new JobTrigger$RecurrenceType_0('CRON_EXPRESSION', 2);
  $VALUES_60 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$RecurrenceType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$RecurrenceType, [NONE_6, REPEAT_INTERVAL, CRON_EXPRESSION]);
}

function JobTrigger$RecurrenceType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_69(name_0){
  $clinit_JobTrigger$RecurrenceType();
  return valueOf(($clinit_JobTrigger$RecurrenceType$Map() , $MAP_60), name_0);
}

function values_63(){
  $clinit_JobTrigger$RecurrenceType();
  return $VALUES_60;
}

defineSeed(852, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$RecurrenceType]), JobTrigger$RecurrenceType_0);
var $VALUES_60, CRON_EXPRESSION, NONE_6, REPEAT_INTERVAL;
function $clinit_JobTrigger$RecurrenceType$Map(){
  $clinit_JobTrigger$RecurrenceType$Map = nullMethod;
  $MAP_60 = createValueOfMap(($clinit_JobTrigger$RecurrenceType() , $VALUES_60));
}

var $MAP_60;
function $clinit_JobTrigger$StartType(){
  $clinit_JobTrigger$StartType = nullMethod;
  NOW = new JobTrigger$StartType_0('NOW', 0);
  DATETIME_1 = new JobTrigger$StartType_0('DATETIME', 1);
  $VALUES_61 = initValues(_3Lorg_rhq_core_domain_common_JobTrigger$StartType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$JobTrigger$StartType, [NOW, DATETIME_1]);
}

function JobTrigger$StartType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_70(name_0){
  $clinit_JobTrigger$StartType();
  return valueOf(($clinit_JobTrigger$StartType$Map() , $MAP_61), name_0);
}

function values_64(){
  $clinit_JobTrigger$StartType();
  return $VALUES_61;
}

defineSeed(854, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$JobTrigger$StartType]), JobTrigger$StartType_0);
var $VALUES_61, DATETIME_1, NOW;
function $clinit_JobTrigger$StartType$Map(){
  $clinit_JobTrigger$StartType$Map = nullMethod;
  $MAP_61 = createValueOfMap(($clinit_JobTrigger$StartType() , $VALUES_61));
}

var $MAP_61;
function deserialize_146(streamReader, instance){
}

function instantiate_143(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$EndType() , $clinit_JobTrigger$EndType() , $VALUES_59);
  return values[ordinal];
}

function serialize_88(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_147(streamReader, instance){
  setCronExpression(instance, $getString(streamReader, $readInt(streamReader)));
  setEndDate_0(instance, dynamicCast($readObject(streamReader), Q$Date));
  setEndType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$EndType));
  setRecurrenceType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$RecurrenceType));
  setRepeatCount(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setRepeatInterval(instance, dynamicCast($readObject(streamReader), Q$Long));
  setStartDate_0(instance, dynamicCast($readObject(streamReader), Q$Date));
  setStartType(instance, dynamicCast($readObject(streamReader), Q$JobTrigger$StartType));
}

function instantiate_144(streamReader){
  return new JobTrigger_0;
}

function serialize_89(streamWriter, instance){
  $writeString(streamWriter, instance.cronExpression);
  $writeObject(streamWriter, instance.endDate);
  $writeObject(streamWriter, instance.endType);
  $writeObject(streamWriter, instance.recurrenceType);
  $writeObject(streamWriter, instance.repeatCount);
  $writeObject(streamWriter, instance.repeatInterval);
  $writeObject(streamWriter, instance.startDate);
  $writeObject(streamWriter, instance.startType);
}

function setCronExpression(instance, value){
  instance.cronExpression = value;
}

function setEndDate_0(instance, value){
  instance.endDate = value;
}

function setEndType(instance, value){
  instance.endType = value;
}

function setRecurrenceType(instance, value){
  instance.recurrenceType = value;
}

function setRepeatCount(instance, value){
  instance.repeatCount = value;
}

function setRepeatInterval(instance, value){
  instance.repeatInterval = value;
}

function setStartDate_0(instance, value){
  instance.startDate = value;
}

function setStartType(instance, value){
  instance.startType = value;
}

function deserialize_148(streamReader, instance){
}

function instantiate_145(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$RecurrenceType() , $clinit_JobTrigger$RecurrenceType() , $VALUES_60);
  return values[ordinal];
}

function serialize_90(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function deserialize_149(streamReader, instance){
}

function instantiate_146(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_JobTrigger$StartType() , $clinit_JobTrigger$StartType() , $VALUES_61);
  return values[ordinal];
}

function serialize_91(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function getByInternalName(internalName){
  $clinit_SystemSetting();
  var p, p$array, p$index, p$max;
  for (p$array = $VALUES_63 , p$index = 0 , p$max = p$array.length; p$index < p$max; ++p$index) {
    p = p$array[p$index];
    if ($equals_6(p.internalName, internalName)) {
      return p;
    }
  }
  return null;
}

function fromMap(properties){
  var e, e$iterator, p, ret;
  ret = new SystemSettings_0;
  for (e$iterator = properties.entrySet().iterator(); e$iterator.hasNext();) {
    e = dynamicCast(e$iterator.next_0(), Q$Map$Entry);
    p = getByInternalName(dynamicCast(e.getKey_0(), Q$String));
    if (!p) {
      throw new IllegalArgumentException_1("'" + dynamicCast(e.getKey_0(), Q$String) + "' is not a system property.");
    }
    $put_3(ret, p, dynamicCast(e.getValue_1(), Q$String));
  }
  return ret;
}

defineSeed(870, 670, makeCastMap([Q$Serializable, Q$Cloneable, Q$HashMap, Q$Map, Q$SystemSettings]));
_.putAll = function putAll_0(m_0){
  var e, e$iterator;
  for (e$iterator = m_0.entrySet().iterator(); e$iterator.hasNext();) {
    e = dynamicCast(e$iterator.next_0(), Q$Map$Entry);
    $put_3(this, dynamicCast(e.getKey_0(), Q$SystemSetting), dynamicCast(e.getValue_1(), Q$String));
  }
}
;
function $addRawConfiguration(this$static, rawConfiguration){
  rawConfiguration.configuration = this$static;
  this$static.rawConfigurations.add(rawConfiguration);
}

function $createDeepCopyOfProperties(this$static, copy, keepId){
  var property, property$iterator;
  for (property$iterator = this$static.properties.values_0().iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $put_4(copy, property.deepCopy(keepId));
  }
}

function $createDeepCopyOfRawConfigs(this$static, copy, keepId){
  var rawConfig, rawConfig$iterator, copy_0;
  for (rawConfig$iterator = this$static.rawConfigurations.iterator(); rawConfig$iterator.hasNext();) {
    rawConfig = dynamicCast(rawConfig$iterator.next_0(), Q$RawConfiguration);
    $addRawConfiguration(copy, (copy_0 = new RawConfiguration_0 , keepId && (copy_0.id = rawConfig.id) , copy_0.path = rawConfig.path , rawConfig.contents_0 != null && $setContents_1(copy_0, rawConfig.contents_0, rawConfig.sha256) , copy_0.errorMessage_0 = rawConfig.errorMessage_0 , copy_0));
  }
}

function $deepCopy(this$static, keepIds){
  var copy;
  copy = new Configuration_0;
  keepIds && (copy.id = this$static.id);
  copy.notes = this$static.notes;
  copy.version_0 = this$static.version_0;
  $createDeepCopyOfProperties(this$static, copy, keepIds);
  $createDeepCopyOfRawConfigs(this$static, copy, keepIds);
  return copy;
}

function $deepCopyWithoutProxies(this$static){
  var copy;
  copy = new Configuration_0;
  copy.notes = this$static.notes;
  copy.version_0 = this$static.version_0;
  $createDeepCopyOfProperties(this$static, copy, false);
  $createDeepCopyOfRawConfigs(this$static, copy, false);
  return copy;
}

function $get_6(this$static, name_0){
  return dynamicCast(this$static.properties.get_2(name_0), Q$Property);
}

function $getSimple(this$static, name_0){
  return dynamicCast(this$static.properties.get_2(name_0), Q$PropertySimple);
}

function $getSimpleProperties(this$static){
  var map, prop, prop$iterator;
  map = new LinkedHashMap_0;
  for (prop$iterator = (!this$static.propertiesProxy && (this$static.propertiesProxy = new Configuration$PropertiesProxy_0(this$static)) , this$static.propertiesProxy.this$0.properties.values_0().iterator()); prop$iterator.hasNext();) {
    prop = dynamicCast(prop$iterator.next_0(), Q$Property);
    instanceOf(prop, Q$PropertySimple) && $put_1(map, prop.name_0, dynamicCast(prop, Q$PropertySimple));
  }
  return map;
}

function $remove_16(this$static, name_0){
  return dynamicCast(this$static.properties.remove_3(name_0), Q$Property);
}

defineSeed(876, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$AbstractPropertyMap, Q$Configuration]));
_.get_3 = function get_16(name_0){
  return $get_6(this, name_0);
}
;
_.getList = function getList(name_0){
  return $getList(this, name_0);
}
;
_.getMap = function getMap(){
  return this.properties;
}
;
_.getMap_0 = function getMap_0(name_0){
  return $getMap(this, name_0);
}
;
_.getSimple = function getSimple(name_0){
  return $getSimple(this, name_0);
}
;
_.put_0 = function put_5(value){
  $put_4(this, value);
}
;
function $add_9(this$static, e){
  $put_4(this$static.this$0, e);
  return true;
}

function Configuration$PropertiesProxy_0(this$0){
  this.this$0 = this$0;
}

defineSeed(877, 1, makeCastMap([Q$Iterable, Q$Collection]), Configuration$PropertiesProxy_0);
_.add = function add_13(e){
  return $add_9(this, dynamicCast(e, Q$Property));
}
;
_.equals$ = function equals_47(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$Collection)) {
    return false;
  }
  return this.this$0.properties.values_0().equals$(obj_0);
}
;
_.hashCode$ = function hashCode_47(){
  return this.this$0.properties.values_0().hashCode$();
}
;
_.iterator = function iterator_16(){
  return this.this$0.properties.values_0().iterator();
}
;
_.size_1 = function size_23(){
  return this.this$0.properties.size_1();
}
;
_.toArray = function toArray_8(){
  return this.this$0.properties.values_0().toArray();
}
;
_.toString$ = function toString_67(){
  return this.this$0.properties.values_0().toString$();
}
;
_.this$0 = null;
function serialize_96(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function normalizeConfiguration(configuration, configurationDefinition){
  var childPropertyDefinition, childPropertyDefinition$iterator, childPropertyDefinitions;
  if (!configuration) {
    throw new IllegalArgumentException_1('Configuration parameter is null.');
  }
  if (configurationDefinition) {
    childPropertyDefinitions = (!configurationDefinition.propertyDefinitions && (configurationDefinition.propertyDefinitions = new LinkedHashMap_0) , configurationDefinition.propertyDefinitions);
    for (childPropertyDefinition$iterator = childPropertyDefinitions.values_0().iterator(); childPropertyDefinition$iterator.hasNext();) {
      childPropertyDefinition = dynamicCast(childPropertyDefinition$iterator.next_0(), Q$PropertyDefinition);
      normalizeProperty(childPropertyDefinition, configuration, true);
    }
  }
}

function normalizeProperty(propertyDefinition, parentPropertyMap, normalizeRequiredDefaults){
  var listMemberPropertyDefinition, property, property$iterator, propertyDefinitionList, propertyDefinitionMap, propertyList, propertyMap, propertySimple, value;
  if (parentPropertyMap.getMap().keySet_0().contains_0(propertyDefinition.name_0)) {
    if (instanceOf(propertyDefinition, Q$PropertyDefinitionSimple)) {
      propertySimple = parentPropertyMap.getSimple(propertyDefinition.name_0);
      value = propertySimple.stringValue;
      value != null && ($equals_6(value, '')?$setValue_12(propertySimple, null):value.length > 2000 && $setValue_12(propertySimple, value.substr(0, 2000 - 0)));
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionMap)) {
      propertyMap = parentPropertyMap.getMap_0(propertyDefinition.name_0);
      propertyDefinitionMap = dynamicCast(propertyDefinition, Q$PropertyDefinitionMap);
      normalizePropertyMap(propertyMap, propertyDefinitionMap);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionList)) {
      propertyDefinitionList = dynamicCast(propertyDefinition, Q$PropertyDefinitionList);
      listMemberPropertyDefinition = propertyDefinitionList.memberDefinition;
      if (instanceOf(listMemberPropertyDefinition, Q$PropertyDefinitionMap)) {
        propertyDefinitionMap = dynamicCast(listMemberPropertyDefinition, Q$PropertyDefinitionMap);
        propertyList = parentPropertyMap.getList(propertyDefinition.name_0);
        for (property$iterator = (!propertyList.list && (propertyList.list = new ArrayList_0) , propertyList.list).iterator(); property$iterator.hasNext();) {
          property = dynamicCast(property$iterator.next_0(), Q$Property);
          propertyMap = dynamicCast(property, Q$PropertyMap);
          normalizePropertyMap(propertyMap, propertyDefinitionMap);
        }
      }
    }
  }
   else {
    if (instanceOf(propertyDefinition, Q$PropertyDefinitionSimple)) {
      value = null;
      normalizeRequiredDefaults && propertyDefinition.required && (value = dynamicCast(propertyDefinition, Q$PropertyDefinitionSimple).defaultValue);
      property = new PropertySimple_1(propertyDefinition.name_0, value);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionMap)) {
      property = new PropertyMap_1(propertyDefinition.name_0);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionList)) {
      property = new PropertyList_1(propertyDefinition.name_0);
    }
     else if (instanceOf(propertyDefinition, Q$PropertyDefinitionDynamic)) {
      property = new PropertySimple_1(propertyDefinition.name_0, null);
    }
     else {
      throw new IllegalStateException_1('Unsupported PropertyDefinition subclass: ' + propertyDefinition.___clazz$.typeName);
    }
    parentPropertyMap.put_0(property);
  }
}

function normalizePropertyMap(propertyMap, propertyDefinitionMap){
  var childPropertyDefinition, childPropertyDefinition$iterator, childPropertyDefinitions;
  childPropertyDefinitions = (!propertyDefinitionMap.map_0 && (propertyDefinitionMap.map_0 = new HashMap_0) , propertyDefinitionMap.map_0);
  for (childPropertyDefinition$iterator = childPropertyDefinitions.values_0().iterator(); childPropertyDefinition$iterator.hasNext();) {
    childPropertyDefinition = dynamicCast(childPropertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    normalizeProperty(childPropertyDefinition, propertyMap, false);
  }
}

function $setErrorMessage(this$static, errorMessage){
  this$static.errorMessage_0 = errorMessage != null?$trim(errorMessage):null;
}

function Property_1(original, keepId){
  keepId && (this.id = original.id);
  this.errorMessage_0 = original.errorMessage_0;
  this.name_0 = original.name_0;
}

defineSeed(886, 1, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property]));
_.deepCopy = function deepCopy(keepId){
  return null;
}
;
function $getIntegerValue(this$static){
  return this$static.stringValue == null?null:valueOf_44(__parseAndValidateInt(this$static.stringValue));
}

function $setOverride(this$static, override){
  this$static.override = override;
}

function PropertySimple_2(original, keepId){
  Property_1.call(this, original, keepId);
  this.stringValue = original.stringValue;
  this.override = original.override;
}

defineSeed(885, 886, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property, Q$PropertySimple]), PropertySimple_2);
_.deepCopy = function deepCopy_0(keepId){
  return this.deepCopy_0(keepId);
}
;
_.deepCopy_0 = function deepCopy_1(keepId){
  return new PropertySimple_2(this, keepId);
}
;
function ObfuscatedPropertySimple_1(original, keepId){
  PropertySimple_2.call(this, original, keepId);
}

defineSeed(884, 885, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$ObfuscatedPropertySimple, Q$Property, Q$PropertySimple]), ObfuscatedPropertySimple_1);
_.deepCopy_0 = function deepCopy_2(keepId){
  return new ObfuscatedPropertySimple_1(this, keepId);
}
;
defineSeed(889, 874, makeCastMap([Q$Serializable, Q$AbstractConfigurationUpdate, Q$AbstractResourceConfigurationUpdate, Q$PluginConfigurationUpdate]));
_.getAbstractGroupConfigurationUpdate = function getAbstractGroupConfigurationUpdate(){
  return this.groupConfigurationUpdate;
}
;
_.getResource = function getResource(){
  return this.resource;
}
;
function $setConfigurationDefinition(this$static, configurationDefinition){
  this$static.configurationDefinition = configurationDefinition;
}

function $setDisplayName(this$static, displayName){
  this$static.displayName = displayName;
}

function $setOrder(this$static, order){
  this$static.order = order;
}

function $setReadOnly_0(this$static, readOnly){
  this$static.readOnly = readOnly;
}

function PropertyDefinition_1(name_0, description, required){
  this.name_0 = name_0;
  this.description = description;
  this.required = required;
}

function $add_10(this$static, property){
  this$static.memberPropertyName == null && (this$static.memberPropertyName = property.name_0);
  if (!$equals_6(property.name_0, this$static.memberPropertyName)) {
    throw new IllegalStateException_1('All properties in a PropertyList (id=[' + this$static.id + '], name=[' + this$static.name_0 + ']) must have the same name: [' + property.name_0 + '] != [' + this$static.memberPropertyName + ']');
  }
  (!this$static.list && (this$static.list = new ArrayList_0) , this$static.list).add(property);
  property.parentList = this$static;
}

function $deepCopy_0(this$static, keepId){
  var copy, property, property$iterator;
  copy = new PropertyList_3(this$static, keepId);
  for (property$iterator = this$static.list.iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $add_10(copy, property.deepCopy(false));
  }
  return copy;
}

function $getList_0(this$static){
  !this$static.list && (this$static.list = new ArrayList_0);
  return this$static.list;
}

function PropertyList_1(name_0){
  $$init_8(this);
  this.name_0 = name_0;
}

function PropertyList_2(name_0, startingList){
  var property, property$index, property$max;
  PropertyList_1.call(this, name_0);
  for (property$index = 0 , property$max = startingList.length; property$index < property$max; ++property$index) {
    property = startingList[property$index];
    $add_10(this, property);
  }
}

function PropertyList_3(original, keepId){
  Property_1.call(this, original, keepId);
  $$init_8(this);
}

defineSeed(898, 886, makeCastMap([Q$Serializable, Q$Comparable, Q$DeepCopyable, Q$Property, Q$PropertyList]), PropertyList_1, PropertyList_2, PropertyList_3);
_.deepCopy = function deepCopy_3(keepId){
  return $deepCopy_0(this, keepId);
}
;
function $deepCopy_1(this$static, keepId){
  var copy, property, property$iterator;
  copy = new PropertyMap_2(this$static, keepId);
  for (property$iterator = this$static.map_0.values_0().iterator(); property$iterator.hasNext();) {
    property = dynamicCast(property$iterator.next_0(), Q$Property);
    $put_5(copy, property.deepCopy(keepId));
  }
  return copy;
}

function $get_7(this$static, name_0){
  return dynamicCast((!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).get_2(name_0), Q$Property);
}

function $getSimple_0(this$static, name_0){
  return dynamicCast(dynamicCast((!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).get_2(name_0), Q$Property), Q$PropertySimple);
}

function $put_5(this$static, property){
  (!this$static.map_0 && (this$static.map_0 = new LinkedHashMap_0) , this$static.map_0).put(property.name_0, property);
  property.parentMap = this$static;
}

function PropertyMap_1(name_0){
  $$init_9(this);
  this.name_0 = name_0;
}

function PropertyMap_2(original, keepId){
  Property_1.call(this, original, keepId);
  $$init_9(this);
}

defineSeed(900, 886, makeCastMap([Q$Serializable, Q$Comparable, Q$AbstractPropertyMap, Q$DeepCopyable, Q$Property, Q$PropertyMap]), PropertyMap_1, PropertyMap_2);
_.deepCopy = function deepCopy_4(keepId){
  return $deepCopy_1(this, keepId);
}
;
_.get_3 = function get_17(name_0){
  return $get_7(this, name_0);
}
;
_.getList = function getList_0(name_0){
  return dynamicCast(dynamicCast((!this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0).get_2(name_0), Q$Property), Q$PropertyList);
}
;
_.getMap = function getMap_1(){
  return !this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0;
}
;
_.getMap_0 = function getMap_2(name_0){
  return dynamicCast(dynamicCast((!this.map_0 && (this.map_0 = new LinkedHashMap_0) , this.map_0).get_2(name_0), Q$Property), Q$PropertyMap);
}
;
_.getSimple = function getSimple_0(name_0){
  return $getSimple_0(this, name_0);
}
;
_.put_0 = function put_6(property){
  $put_5(this, property);
}
;
function $setContents_1(this$static, contents, sha256){
  this$static.contents_0 = contents;
  this$static.errorMessage_0 = null;
  this$static.sha256 = sha256;
}

defineSeed(908, 874, makeCastMap([Q$Serializable, Q$AbstractConfigurationUpdate, Q$AbstractResourceConfigurationUpdate, Q$ResourceConfigurationUpdate]));
_.getAbstractGroupConfigurationUpdate = function getAbstractGroupConfigurationUpdate_0(){
  return this.groupConfigurationUpdate;
}
;
_.getResource = function getResource_0(){
  return this.resource;
}
;
function ResourceConfigurationComposite_0(resourceId, configuration){
  this.resourceId = resourceId;
  this.configuration = configuration;
}

defineSeed(911, 1, makeCastMap([Q$Serializable]), ResourceConfigurationComposite_0);
_.configuration = null;
_.resourceId = 0;
function serialize_114(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function serialize_115(streamWriter, instance){
  $writeObject(streamWriter, instance.configuration);
  $writeInt(streamWriter, instance.resourceId);
}

function $get_8(this$static, name_0){
  return dynamicCast(this$static.propertyDefinitions.get_2(name_0), Q$PropertyDefinition);
}

function $getConfigurationFormat(this$static){
  !this$static.configurationFormat && (this$static.configurationFormat = ($clinit_ConfigurationFormat() , STRUCTURED));
  return this$static.configurationFormat;
}

function $getDefaultTemplate(this$static){
  return dynamicCast((!this$static.templates && (this$static.templates = new LinkedHashMap_0) , this$static.templates).get_2('default'), Q$ConfigurationTemplate);
}

function $getGroupDefinitions(this$static){
  var group, group$iterator, groupSet, groups, propertyDefinition, propertyDefinition$iterator;
  groupSet = new HashSet_0;
  for (propertyDefinition$iterator = (!this$static.propertyDefinitions && (this$static.propertyDefinitions = new LinkedHashMap_0) , this$static.propertyDefinitions).values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    !!propertyDefinition.propertyGroupDefinition && $add_6(groupSet, propertyDefinition.propertyGroupDefinition);
  }
  groups = new ArrayList_1(groupSet.map_0.size_1());
  for (group$iterator = $iterator($keySet(groupSet.map_0)); group$iterator.val$outerIter.hasNext();) {
    group = dynamicCast($next_1(group$iterator), Q$PropertyGroupDefinition);
    setCheck(groups.array, groups.size_0++, group);
  }
  sort_1(groups, new ConfigurationDefinition$GroupComparator_0);
  return groups;
}

function $getNonGroupedProperties(this$static){
  var propertyDefinition, propertyDefinition$iterator, propertyDefinitions;
  propertyDefinitions = new ArrayList_0;
  for (propertyDefinition$iterator = this$static.propertyDefinitions.values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    !propertyDefinition.propertyGroupDefinition && (setCheck(propertyDefinitions.array, propertyDefinitions.size_0++, propertyDefinition) , true);
  }
  sort_1(propertyDefinitions, new ConfigurationDefinition$PropertyDefinitionComparator_0);
  return propertyDefinitions;
}

function $getPropertiesInGroup(this$static, groupName){
  var group, propertyDefinition, propertyDefinition$iterator, propertyDefinitions;
  propertyDefinitions = new ArrayList_0;
  for (propertyDefinition$iterator = this$static.propertyDefinitions.values_0().iterator(); propertyDefinition$iterator.hasNext();) {
    propertyDefinition = dynamicCast(propertyDefinition$iterator.next_0(), Q$PropertyDefinition);
    group = propertyDefinition.propertyGroupDefinition;
    !!group && $equals_6(group.name_0, groupName) && (setCheck(propertyDefinitions.array, propertyDefinitions.size_0++, propertyDefinition) , true);
  }
  sort_1(propertyDefinitions, new ConfigurationDefinition$PropertyDefinitionComparator_0);
  return propertyDefinitions;
}

function $put_6(this$static, propertyDefinition){
  !this$static.propertyDefinitions && (this$static.propertyDefinitions = new LinkedHashMap_0);
  this$static.propertyDefinitions.put(propertyDefinition.name_0, propertyDefinition);
  propertyDefinition.configurationDefinition = this$static;
}

function $setConfigurationFormat(this$static, configurationFormat){
  this$static.configurationFormat = configurationFormat;
}

function ConfigurationDefinition_1(name_0, description){
  $$init_10(this);
  this.name_0 = name_0;
  this.description = description;
}

defineSeed(917, 1, makeCastMap([Q$Serializable, Q$ConfigurationDefinition]), ConfigurationDefinition_1);
function $compare_0(group1, group2){
  return group1.order == group2.order?compareTo_11(group1.name_0, group2.name_0):$compareTo_5(valueOf_44(group1.order), valueOf_44(group2.order));
}

function ConfigurationDefinition$GroupComparator_0(){
}

defineSeed(918, 1, makeCastMap([Q$Comparator]), ConfigurationDefinition$GroupComparator_0);
_.compare = function compare_2(group1, group2){
  return $compare_0(dynamicCast(group1, Q$PropertyGroupDefinition), dynamicCast(group2, Q$PropertyGroupDefinition));
}
;
function $compare_1(propDef1, propDef2){
  return propDef1.order == propDef2.order?compareTo_11(propDef1.name_0, propDef2.name_0):$compareTo_5(valueOf_44(propDef1.order), valueOf_44(propDef2.order));
}

function ConfigurationDefinition$PropertyDefinitionComparator_0(){
}

defineSeed(919, 1, makeCastMap([Q$Comparator]), ConfigurationDefinition$PropertyDefinitionComparator_0);
_.compare = function compare_3(propDef1, propDef2){
  return $compare_1(dynamicCast(propDef1, Q$PropertyDefinition), dynamicCast(propDef2, Q$PropertyDefinition));
}
;
function ConfigurationTemplate_1(){
  this.name_0 = 'default';
  this.description = 'default template';
}

defineSeed(924, 1, makeCastMap([Q$Serializable, Q$ConfigurationTemplate]), ConfigurationTemplate_1);
function $setOrderIndex(this$static, orderIndex){
  this$static.orderIndex = orderIndex;
}

function PropertyDefinitionEnumeration_1(name_0, value){
  this.name_0 = name_0;
  this.value_0 = value;
}

defineSeed(926, 1, makeCastMap([Q$Serializable, Q$PropertyDefinitionEnumeration]), PropertyDefinitionEnumeration_1);
function $setMax_1(this$static, max){
  this$static.max_0 = max;
}

function $setMin_1(this$static, min){
  this$static.min_0 = min;
}

function PropertyDefinitionList_1(name_0, description, required, memberDefinition){
  PropertyDefinition_1.call(this, name_0, description, required);
  this.memberDefinition = memberDefinition;
  !!memberDefinition && (this.memberDefinition.parentPropertyListDefinition = this , undefined);
}

defineSeed(929, 893, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionList]), PropertyDefinitionList_1);
function $get_9(this$static, name_0){
  return dynamicCast((!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0).get_2(name_0), Q$PropertyDefinition);
}

function $getPropertyDefinitions(this$static){
  var key, key$iterator, map, orderComparator, result;
  map = (!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0);
  if (map.size_1() <= 1) {
    return map;
  }
  orderComparator = new PropertyDefinitionMap$1_0(this$static);
  result = new TreeMap_1(orderComparator);
  for (key$iterator = map.keySet_0().iterator(); key$iterator.hasNext();) {
    key = dynamicCast(key$iterator.next_0(), Q$String);
    $put_2(result, key, dynamicCast(map.get_2(key), Q$PropertyDefinition));
  }
  return result;
}

function $put_7(this$static, propertyDefinition){
  var map, order, p, p$iterator, size;
  map = (!this$static.map_0 && (this$static.map_0 = new HashMap_0) , this$static.map_0);
  if (map.isEmpty_0()) {
    propertyDefinition.order = 0;
  }
   else {
    order = propertyDefinition.order;
    size = map.size_1();
    if (order <= 0 || order >= size) {
      propertyDefinition.order = size;
    }
     else {
      for (p$iterator = map.values_0().iterator(); p$iterator.hasNext();) {
        p = dynamicCast(p$iterator.next_0(), Q$PropertyDefinition);
        p.order >= order && $setOrder(p, p.order + 1);
      }
    }
  }
  map.put(propertyDefinition.name_0, propertyDefinition);
  propertyDefinition.parentPropertyMapDefinition = this$static;
}

function PropertyDefinitionMap_1(name_0, description, required, properties){
  var property, property$index, property$max;
  PropertyDefinition_1.call(this, name_0, description, required);
  if (properties != null) {
    for (property$index = 0 , property$max = properties.length; property$index < property$max; ++property$index) {
      property = properties[property$index];
      $put_7(this, property);
    }
  }
}

defineSeed(931, 893, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionMap]), PropertyDefinitionMap_1);
function $compare_2(this$static, o1, o2){
  return $compareTo_5(valueOf_44($get_9(this$static.this$0, o1).order), valueOf_44($get_9(this$static.this$0, o2).order));
}

function PropertyDefinitionMap$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(932, 1, makeCastMap([Q$Comparator]), PropertyDefinitionMap$1_0);
_.compare = function compare_4(o1, o2){
  return $compare_2(this, dynamicCast(o1, Q$String), dynamicCast(o2, Q$String));
}
;
_.this$0 = null;
function $addConstraints(this$static, constraintsToAdd){
  var constraint, constraint$index, constraint$max;
  for (constraint$index = 0 , constraint$max = constraintsToAdd.length; constraint$index < constraint$max; ++constraint$index) {
    constraint = constraintsToAdd[constraint$index];
    this$static.constraints.add(constraint);
    constraint.propertyDefinitionSimple = this$static;
  }
}

function $addEnumeratedValues(this$static, enumerations){
  var enumeration, enumeration$index, enumeration$max;
  for (enumeration$index = 0 , enumeration$max = enumerations.length; enumeration$index < enumeration$max; ++enumeration$index) {
    enumeration = enumerations[enumeration$index];
    enumeration.propertyDefinitionSimple = this$static;
    this$static.enumeratedValues.add(enumeration);
  }
  $ensureOrdering(this$static);
}

function $ensureOrdering(this$static){
  var i, size;
  if (!this$static.enumeratedValues) {
    return;
  }
  for (i = 0 , size = this$static.enumeratedValues.size_1(); i < size; ++i) {
    $setOrderIndex(dynamicCast(this$static.enumeratedValues.get_0(i), Q$PropertyDefinitionEnumeration), i);
  }
}

function $setDefaultValue_3(this$static, defaultValue){
  this$static.defaultValue = defaultValue;
}

function $setEnumeratedValues(this$static, enumeratedValues){
  $addEnumeratedValues(this$static, dynamicCast($toArray_1(enumeratedValues, initDim(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinitionEnumeration_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$PropertyDefinitionEnumeration_$1]), Q$PropertyDefinitionEnumeration, enumeratedValues.size_0, 0)), Q$PropertyDefinitionEnumeration_$1));
  this$static.allowCustomEnumeratedValue = false;
  $ensureOrdering(this$static);
}

function PropertyDefinitionSimple_1(name_0, description, required, type){
  PropertyDefinition_1.call(this, name_0, description, required);
  $$init_11(this);
  this.type_0 = type;
}

defineSeed(934, 893, makeCastMap([Q$Serializable, Q$PropertyDefinition, Q$PropertyDefinitionSimple]), PropertyDefinitionSimple_1);
function $setDefaultHidden(this$static, defaultHidden){
  this$static.defaultHidden = defaultHidden;
}

function $setDisplayName_0(this$static, displayName){
  this$static.displayName = displayName;
}

function PropertyGroupDefinition_1(name_0){
  this.name_0 = name_0;
}

defineSeed(937, 1, makeCastMap([Q$Serializable, Q$PropertyGroupDefinition]), PropertyGroupDefinition_1);
function IntegerRangeConstraint_1(minimum, maximum){
  var min, max;
  this.minimum = minimum;
  this.maximum = maximum;
  min = !this.minimum?'*':'' + toString_8(this.minimum.value_0);
  max = !this.maximum?'*':'' + toString_8(this.maximum.value_0);
  this.details = min + '#' + max;
}

defineSeed(952, 948, makeCastMap([Q$Serializable, Q$Constraint, Q$IntegerRangeConstraint]), IntegerRangeConstraint_1);
function deserialize_202(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_195(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_content_Architecture_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Architecture, size, 0);
}

function PackageVersionFormatDescription_0(){
}

defineSeed(1023, 1, makeCastMap([Q$Serializable, Q$PackageVersionFormatDescription]), PackageVersionFormatDescription_0);
_.fullFormatRegex = null;
_.osgiVersionExtractionRegex = null;
_.osgiVersionGroupIndex = 0;
_.textualDesctiption = null;
function deserialize_226(streamReader, instance){
  setFullFormatRegex(instance, $getString(streamReader, $readInt(streamReader)));
  setOsgiVersionExtractionRegex(instance, $getString(streamReader, $readInt(streamReader)));
  setOsgiVersionGroupIndex(instance, $readInt(streamReader));
  setTextualDesctiption(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_219(streamReader){
  return new PackageVersionFormatDescription_0;
}

function setFullFormatRegex(instance, value){
  instance.fullFormatRegex = value;
}

function setOsgiVersionExtractionRegex(instance, value){
  instance.osgiVersionExtractionRegex = value;
}

function setOsgiVersionGroupIndex(instance, value){
  instance.osgiVersionGroupIndex = value;
}

function setTextualDesctiption(instance, value){
  instance.textualDesctiption = value;
}

function PackageAndLatestVersionComposite_0(){
}

defineSeed(1058, 1, makeCastMap([Q$Serializable, Q$PackageAndLatestVersionComposite]), PackageAndLatestVersionComposite_0);
_.generalPackage = null;
_.latestPackageVersion = null;
function deserialize_246(streamReader, instance){
  setGeneralPackage_0(instance, dynamicCast($readObject(streamReader), Q$Package));
  setLatestPackageVersion(instance, dynamicCast($readObject(streamReader), Q$PackageVersion));
}

function instantiate_239(streamReader){
  return new PackageAndLatestVersionComposite_0;
}

function setGeneralPackage_0(instance, value){
  instance.generalPackage = value;
}

function setLatestPackageVersion(instance, value){
  instance.latestPackageVersion = value;
}

function PackageTypeAndVersionFormatComposite_0(){
}

defineSeed(1060, 1, makeCastMap([Q$Serializable, Q$PackageTypeAndVersionFormatComposite]), PackageTypeAndVersionFormatComposite_0);
_.packageType = null;
_.versionFormat = null;
function deserialize_247(streamReader, instance){
  setPackageType_1(instance, dynamicCast($readObject(streamReader), Q$PackageType));
  setVersionFormat(instance, dynamicCast($readObject(streamReader), Q$PackageVersionFormatDescription));
}

function instantiate_240(streamReader){
  return new PackageTypeAndVersionFormatComposite_0;
}

function setPackageType_1(instance, value){
  instance.packageType = value;
}

function setVersionFormat(instance, value){
  instance.versionFormat = value;
}

function $addRequiredPermissions(this$static, requiredPermissions){
  this$static.requiredPermissions = new Arrays$ArrayList_0(requiredPermissions);
}

function $getAlias(this$static){
  var className, classSimpleName;
  if (this$static.alias == null) {
    className = this$static.getPersistentClass().typeName;
    classSimpleName = $substring(className, className.lastIndexOf('.') + 1);
    this$static.alias = classSimpleName.toLowerCase();
  }
  return this$static.alias;
}

function $setRestriction(this$static, restriction){
  this$static.restriction = restriction;
}

function $setSearchExpression(this$static, searchExpression){
  this$static.searchExpression = searchExpression;
}

defineSeed(1066, 1, makeCastMap([Q$Serializable, Q$Criteria]));
_.getPageControlOverrides = function getPageControlOverrides(){
  return this.pageControlOverrides;
}
;
_.setPageControl = function setPageControl(pageControl){
  this.pageControlOverrides = pageControl;
}
;
function $addFilterEndTime(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterStartTime(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function $addSortStatus(this$static, sortStatus){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(115)) + 'tatus');
  this$static.sortStatus = sortStatus;
}

function AbstractConfigurationUpdateCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('startTime', 'createdTime >= ?');
  this.filterOverrides.put('endTime', 'createdTime <= ?');
  this.filterOverrides.put('statuses', 'status IN ( ? )');
}

defineSeed(1065, 1066, makeCastMap([Q$Serializable, Q$Criteria]));
_.fetchConfiguration = false;
_.filterEndTime = null;
_.filterStartTime = null;
_.filterStatus = null;
_.filterStatuses = null;
_.sortCreatedTime = null;
_.sortStatus = null;
function serialize_187(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.filterStatus);
  $writeObject(streamWriter, instance.filterStatuses);
  $writeObject(streamWriter, instance.sortCreatedTime);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_200(streamWriter, instance);
}

function $addFilterResourceGroupIds(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = filterResourceGroupIds;
}

function AbstractGroupConfigurationUpdateCriteria_0(){
  AbstractConfigurationUpdateCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
}

defineSeed(1068, 1065, makeCastMap([Q$Serializable, Q$Criteria]));
_.fetchConfigurationUpdates = false;
_.filterResourceGroupIds = null;
function serialize_188(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfigurationUpdates);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_187(streamWriter, instance);
}

function AbstractResourceConfigurationUpdateCriteria_0(){
  AbstractConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1070, 1065, makeCastMap([Q$Serializable, Q$Criteria]));
function $addFilterAddress(this$static, filterAddress){
  this$static.filterAddress = filterAddress;
}

function $addFilterAffinityGroupId(this$static, filterAffinityGroupId){
  this$static.filterAffinityGroupId = filterAffinityGroupId;
}

function $addFilterAgenttoken(this$static, filterAgenttoken){
  this$static.filterAgenttoken = filterAgenttoken;
}

function $addFilterName(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPort(this$static, filterPort){
  this$static.filterPort = filterPort;
}

function $addFilterServerId(this$static, filterServerId){
  this$static.filterServerId = filterServerId;
}

function AgentCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('serverId', 'server.id = ?');
  this.filterOverrides.put('affinityGroupId', 'affinityGroup.id = ?');
}

defineSeed(1071, 1066, makeCastMap([Q$Serializable, Q$AgentCriteria, Q$Criteria]), AgentCriteria_0);
_.getPersistentClass = function getPersistentClass(){
  return Lorg_rhq_core_domain_resource_Agent_2_classLit;
}
;
_.fetchAffinityGroup = false;
_.fetchServer = false;
_.filterAddress = null;
_.filterAffinityGroupId = null;
_.filterAgenttoken = null;
_.filterName = null;
_.filterPort = null;
_.filterServerId = null;
_.sortCtime = null;
_.sortName = null;
function serialize_189(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAffinityGroup);
  $writeBoolean(streamWriter, instance.fetchServer);
  $writeString(streamWriter, instance.filterAddress);
  $writeObject(streamWriter, instance.filterAffinityGroupId);
  $writeString(streamWriter, instance.filterAgenttoken);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPort);
  $writeObject(streamWriter, instance.filterServerId);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterEndTime_0(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterEntityContext(this$static, filterEntityContext){
  filterEntityContext.type_0 == ($clinit_EntityContext$Type() , Resource)?$addFilterResourceIds(this$static, initValues(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, [valueOf_44(filterEntityContext.resourceId)])):filterEntityContext.type_0 == ResourceGroup && $addFilterResourceGroupIds_0(this$static, initValues(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, [valueOf_44(filterEntityContext.groupId)]));
}

function $addFilterResourceGroupIds_0(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = getListIgnoringNulls(filterResourceGroupIds);
}

function $addFilterResourceIds(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterStartTime_0(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function AlertCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('triggeredOperationName', 'triggeredOperation like ?');
  this.filterOverrides.put('startTime', 'ctime >= ?');
  this.filterOverrides.put('endTime', 'ctime <= ?');
  this.filterOverrides.put('name', 'alertDefinition.name like ?');
  this.filterOverrides.put('description', 'alertDefinition.description like ?');
  this.filterOverrides.put('priorities', 'alertDefinition.priority IN ( ? )');
  this.filterOverrides.put('resourceTypeId', 'alertDefinition.resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'alertDefinition.resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'alertDefinition.resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'alertDefinition.resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.filterOverrides.put('alertDefinitionIds', 'alertDefinition.id IN ( ? )');
  this.filterOverrides.put('groupAlertDefinitionIds', 'alertDefinition.groupAlertDefinition.id IN ( ? )');
  this.sortOverrides.put('name', 'alertDefinition.name');
  this.sortOverrides.put('priority', 'alertDefinition.priority');
  this.sortOverrides.put('resourceId', 'alertDefinition.resource.id');
  this.sortOverrides.put('resourceName', 'alertDefinition.resource.name');
  this.fetchConditionLogs = true;
}

defineSeed(1073, 1066, makeCastMap([Q$Serializable, Q$AlertCriteria, Q$Criteria]), AlertCriteria_0);
_.getPersistentClass = function getPersistentClass_0(){
  return Lorg_rhq_core_domain_alert_Alert_2_classLit;
}
;
_.fetchAlertDefinition = false;
_.fetchConditionLogs = false;
_.fetchNotificationLogs = false;
_.fetchRecoveryAlertDefinition = false;
_.filterAcknowledgingSubject = null;
_.filterAlertDefinitionIds = null;
_.filterDescription = null;
_.filterEndTime = null;
_.filterGroupAlertDefinitionIds = null;
_.filterName = null;
_.filterPriorities = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.filterStartTime = null;
_.filterTriggeredOperationName = null;
_.sortCtime = null;
_.sortName = null;
_.sortPriority = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_190(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAlertDefinition);
  $writeBoolean(streamWriter, instance.fetchConditionLogs);
  $writeBoolean(streamWriter, instance.fetchNotificationLogs);
  $writeBoolean(streamWriter, instance.fetchRecoveryAlertDefinition);
  $writeString(streamWriter, instance.filterAcknowledgingSubject);
  $writeObject(streamWriter, instance.filterAlertDefinitionIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionIds);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPriorities);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeString(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeString(streamWriter, instance.filterTriggeredOperationName);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortPriority);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_200(streamWriter, instance);
}

function $addFilterAlertTemplateResourceTypeId(this$static, filterAlertTemplateResourceTypeId){
  this$static.filterAlertTemplateResourceTypeId = filterAlertTemplateResourceTypeId;
}

function $addFilterResourceGroupIds_1(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function $addFilterResourceIds_0(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function AlertDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterDeleted = ($clinit_Boolean() , $clinit_Boolean() , FALSE);
  this.filterOverrides.put('alertTemplateOnly', 'resourceType IS NOT NULL');
  this.filterOverrides.put('alertTemplateParentId', 'parentId = ?');
  this.filterOverrides.put('alertTemplateResourceTypeId', 'resourceType.id = ?');
  this.filterOverrides.put('alertTemplateResourceTypeName', 'resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
  this.filterOverrides.put('groupAlertDefinitionId', 'groupAlertDefinition.id = ?');
  this.filterOverrides.put('groupAlertDefinitionGroupId', 'groupAlertDefinition.group.id = ?');
  this.filterOverrides.put('resourceOnly', 'resource IS NOT NULL');
  this.filterOverrides.put('notificationSenderNames', 'id IN (SELECT notif.alertDefinition.id FROM AlertNotification notif WHERE notif.senderName IN ( ? ))');
  this.sortOverrides.put('resourceId', 'resource.id');
  this.sortOverrides.put('resourceName', 'resource.name');
  this.fetchGroupAlertDefinition = true;
}

defineSeed(1075, 1066, makeCastMap([Q$Serializable, Q$AlertDefinitionCriteria, Q$Criteria]), AlertDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_1(){
  return Lorg_rhq_core_domain_alert_AlertDefinition_2_classLit;
}
;
_.fetchAlertNotifications = false;
_.fetchAlerts = false;
_.fetchConditions = false;
_.fetchGroupAlertDefinition = false;
_.fetchResource = false;
_.fetchResourceType = false;
_.filterAlertTemplateOnly = null;
_.filterAlertTemplateParentId = null;
_.filterAlertTemplateResourceTypeId = null;
_.filterAlertTemplateResourceTypeName = null;
_.filterDescription = null;
_.filterEnabled = null;
_.filterGroupAlertDefinitionGroupId = null;
_.filterGroupAlertDefinitionId = null;
_.filterName = null;
_.filterNotificationSenderNames = null;
_.filterPriority = null;
_.filterReadOnly = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceOnly = null;
_.sortName = null;
_.sortPriority = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_191(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAlertNotifications);
  $writeBoolean(streamWriter, instance.fetchAlerts);
  $writeBoolean(streamWriter, instance.fetchConditions);
  $writeBoolean(streamWriter, instance.fetchGroupAlertDefinition);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeObject(streamWriter, instance.filterAlertTemplateOnly);
  $writeObject(streamWriter, instance.filterAlertTemplateParentId);
  $writeObject(streamWriter, instance.filterAlertTemplateResourceTypeId);
  $writeString(streamWriter, instance.filterAlertTemplateResourceTypeName);
  $writeObject(streamWriter, instance.filterDeleted);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterEnabled);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionGroupId);
  $writeObject(streamWriter, instance.filterGroupAlertDefinitionId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterNotificationSenderNames);
  $writeObject(streamWriter, instance.filterPriority);
  $writeObject(streamWriter, instance.filterReadOnly);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceOnly);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortPriority);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_200(streamWriter, instance);
}

function $addFilterInitialAvailability(this$static, initialAvailability){
  if (this$static.filterStartTime) {
    throw new IllegalStateException_1('This filter is mutually exclusive with filterInterval, which has already been set.');
  }
  this$static.filterStartTime = valueOf_45(initialAvailability.value_0?P0_longLit:P1_longLit);
  this$static.filterOverrides.put('startTime', 'startTime >= ?');
}

function $addFilterResourceId(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function AvailabilityCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceId', 'resource.id = ?');
}

defineSeed(1077, 1066, makeCastMap([Q$Serializable, Q$AvailabilityCriteria, Q$Criteria]), AvailabilityCriteria_0);
_.getPersistentClass = function getPersistentClass_2(){
  return Lorg_rhq_core_domain_measurement_Availability_2_classLit;
}
;
_.fetchResource = false;
_.filterAvailabilityTypes = null;
_.filterResourceId = null;
_.filterStartTime = null;
_.sortStartTime = null;
function serialize_192(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterAvailabilityTypes);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.sortStartTime);
  serialize_200(streamWriter, instance);
}

function $addFilterTagName(this$static, filterTagName){
  if (filterTagName == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setName_12(this$static.filterTag, filterTagName);
}

function $addFilterTagNamespace(this$static, filterTagNamespace){
  if (filterTagNamespace == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setNamespace(this$static.filterTag, filterTagNamespace);
}

function $addFilterTagSemantic(this$static, filterTagSemantic){
  if (filterTagSemantic == null) {
    return;
  }
  !this$static.filterTag && (this$static.filterTag = new Tag_0);
  $setSemantic(this$static.filterTag, filterTagSemantic);
}

function $addFilterBundleTypeId(this$static, filterBundleTypeId){
  this$static.filterBundleTypeId = filterBundleTypeId;
}

function $addFilterName_0(this$static, filterName){
  this$static.filterName = filterName;
}

function BundleCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleVersionIds', 'id IN ( SELECT bv.bundle.id           FROM BundleVersion bv          WHERE bv.id IN ( ? ) )');
  this.filterOverrides.put('bundleTypeId', 'bundleType.id = ?');
  this.filterOverrides.put('bundleTypeName', 'bundleType.name like ?');
  this.filterOverrides.put('destinationIds', 'id IN ( SELECT bd.bundle.id           FROM BundleDestination bd          WHERE bd.id IN ( ? ) )');
  this.filterOverrides.put('packageTypeId', 'packageType.id = ?');
  this.filterOverrides.put('packageTypeName', 'packageType.name like ?');
}

defineSeed(1079, 1080, makeCastMap([Q$Serializable, Q$BundleCriteria, Q$Criteria]), BundleCriteria_0);
_.getPersistentClass = function getPersistentClass_3(){
  return Lorg_rhq_core_domain_bundle_Bundle_2_classLit;
}
;
_.fetchBundleVersions = false;
_.fetchDestinations = false;
_.fetchPackageType = false;
_.fetchRepo = false;
_.filterBundleTypeId = null;
_.filterBundleTypeName = null;
_.filterBundleVersionIds = null;
_.filterDescription = null;
_.filterDestinationIds = null;
_.filterName = null;
_.filterPackageTypeId = null;
_.filterPackageTypeName = null;
_.sortDescription = null;
_.sortName = null;
function serialize_193(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleVersions);
  $writeBoolean(streamWriter, instance.fetchDestinations);
  $writeBoolean(streamWriter, instance.fetchPackageType);
  $writeBoolean(streamWriter, instance.fetchRepo);
  $writeObject(streamWriter, instance.filterBundleTypeId);
  $writeString(streamWriter, instance.filterBundleTypeName);
  $writeObject(streamWriter, instance.filterBundleVersionIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterDestinationIds);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPackageTypeId);
  $writeString(streamWriter, instance.filterPackageTypeName);
  $writeObject(streamWriter, instance.sortDescription);
  $writeObject(streamWriter, instance.sortName);
  serialize_235(streamWriter, instance);
}

function $addFilterBundleId(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function $addFilterBundleVersionId(this$static, filterBundleVersionId){
  this$static.filterBundleVersionId = filterBundleVersionId;
}

function $addFilterDestinationId(this$static, filterDestinationId){
  this$static.filterDestinationId = filterDestinationId;
}

function $addFilterIsLive(this$static, filterIsLive){
  this$static.filterIsLive = filterIsLive;
}

function $addSortStatus_0(this$static, sortStatus){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(115)) + 'ort');
  this$static.sortStatus = sortStatus;
}

function BundleDeploymentCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundleVersion.bundle.id = ?');
  this.filterOverrides.put('bundleVersionId', 'bundleVersion.id = ?');
  this.filterOverrides.put('destinationId', 'destination.id = ?');
  this.filterOverrides.put('destinationName', 'destination.name like ?');
}

defineSeed(1082, 1080, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), BundleDeploymentCriteria_0);
_.getPersistentClass = function getPersistentClass_4(){
  return Lorg_rhq_core_domain_bundle_BundleDeployment_2_classLit;
}
;
_.fetchBundleVersion = false;
_.fetchConfiguration = false;
_.fetchDestination = false;
_.fetchResourceDeployments = false;
_.filterBundleId = null;
_.filterBundleVersionId = null;
_.filterDescription = null;
_.filterDestinationId = null;
_.filterDestinationName = null;
_.filterIsLive = null;
_.filterName = null;
_.filterStatus = null;
_.filterSubjectName = null;
_.sortStatus = null;
function serialize_194(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleVersion);
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeBoolean(streamWriter, instance.fetchDestination);
  $writeBoolean(streamWriter, instance.fetchResourceDeployments);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterDestinationId);
  $writeString(streamWriter, instance.filterDestinationName);
  $writeObject(streamWriter, instance.filterIsLive);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterStatus);
  $writeString(streamWriter, instance.filterSubjectName);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_235(streamWriter, instance);
}

function $addFilterBundleId_0(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function BundleDestinationCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundle.id = ?');
  this.filterOverrides.put('bundleVersionId', 'deployments.bundleVersion.id = ?');
  this.filterOverrides.put('status', 'deployment.status like ?');
  this.filterOverrides.put('groupId', 'group.id = ?');
}

defineSeed(1084, 1080, makeCastMap([Q$Serializable, Q$BundleDestinationCriteria, Q$Criteria]), BundleDestinationCriteria_0);
_.getPersistentClass = function getPersistentClass_5(){
  return Lorg_rhq_core_domain_bundle_BundleDestination_2_classLit;
}
;
_.fetchBundle = false;
_.fetchDeployments = false;
_.fetchGroup = false;
_.filterBundleId = null;
_.filterBundleVersionId = null;
_.filterDeployDir = null;
_.filterDescription = null;
_.filterGroupId = null;
_.filterName = null;
_.filterStatus = null;
function serialize_195(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundle);
  $writeBoolean(streamWriter, instance.fetchDeployments);
  $writeBoolean(streamWriter, instance.fetchGroup);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeString(streamWriter, instance.filterDeployDir);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterStatus);
  serialize_235(streamWriter, instance);
}

function $addFilterBundleVersionId_0(this$static, filterBundleVersionId){
  this$static.filterBundleVersionId = filterBundleVersionId;
}

function BundleFileCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('bundleVersionId', 'bundleVersion.id = ?');
  this.filterOverrides.put('packageVersionId', 'packageVersion.id = ?');
}

defineSeed(1086, 1066, makeCastMap([Q$Serializable, Q$Criteria]), BundleFileCriteria_0);
_.getPersistentClass = function getPersistentClass_6(){
  return Lorg_rhq_core_domain_bundle_BundleFile_2_classLit;
}
;
_.fetchBundleVersion = false;
_.fetchPackageVersion = false;
_.filterBundleVersionId = null;
_.filterPackageVersionId = null;
function serialize_196(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleVersion);
  $writeBoolean(streamWriter, instance.fetchPackageVersion);
  $writeObject(streamWriter, instance.filterBundleVersionId);
  $writeObject(streamWriter, instance.filterPackageVersionId);
  serialize_200(streamWriter, instance);
}

function $addFilterBundleDeploymentId(this$static, filterBundleDeploymentId){
  this$static.filterBundleDeploymentId = filterBundleDeploymentId;
}

function BundleResourceDeploymentCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('bundleDeploymentId', 'bundleDeployment.id = ?');
  this.filterOverrides.put('bundleDeploymentName', 'bundleDeployment.name like ?');
  this.filterOverrides.put('resourceId', 'resource.id = ?');
  this.filterOverrides.put('resourceName', 'resource.name like ?');
}

defineSeed(1088, 1066, makeCastMap([Q$Serializable, Q$Criteria]), BundleResourceDeploymentCriteria_0);
_.getPersistentClass = function getPersistentClass_7(){
  return Lorg_rhq_core_domain_bundle_BundleResourceDeployment_2_classLit;
}
;
_.fetchBundleDeployment = false;
_.fetchHistories = false;
_.fetchResource = false;
_.filterBundleDeploymentId = null;
_.filterBundleDeploymentName = null;
_.filterResourceId = null;
_.filterResourceName = null;
_.filterStatus = null;
function serialize_197(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundleDeployment);
  $writeBoolean(streamWriter, instance.fetchHistories);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterBundleDeploymentId);
  $writeString(streamWriter, instance.filterBundleDeploymentName);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeString(streamWriter, instance.filterResourceName);
  $writeObject(streamWriter, instance.filterStatus);
  serialize_200(streamWriter, instance);
}

function $addFilterBundleId_1(this$static, filterBundleId){
  this$static.filterBundleId = filterBundleId;
}

function BundleVersionCriteria_0(){
  TaggedCriteria_0.call(this);
  this.filterOverrides.put('bundleId', 'bundle.id = ?');
  this.filterOverrides.put('bundleName', 'bundle.name like ?');
}

defineSeed(1090, 1080, makeCastMap([Q$Serializable, Q$BundleVersionCriteria, Q$Criteria]), BundleVersionCriteria_0);
_.getPersistentClass = function getPersistentClass_8(){
  return Lorg_rhq_core_domain_bundle_BundleVersion_2_classLit;
}
;
_.fetchBundle = false;
_.fetchBundleDeployments = false;
_.fetchBundleFiles = false;
_.fetchConfigurationDefinition = false;
_.filterBundleId = null;
_.filterBundleName = null;
_.filterDescription = null;
_.filterName = null;
_.filterVersion = null;
function serialize_198(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBundle);
  $writeBoolean(streamWriter, instance.fetchBundleDeployments);
  $writeBoolean(streamWriter, instance.fetchBundleFiles);
  $writeBoolean(streamWriter, instance.fetchConfigurationDefinition);
  $writeObject(streamWriter, instance.filterBundleId);
  $writeString(streamWriter, instance.filterBundleName);
  $writeString(streamWriter, instance.filterDescription);
  $writeString(streamWriter, instance.filterName);
  $writeString(streamWriter, instance.filterVersion);
  serialize_235(streamWriter, instance);
}

function $addFilterBeginTime(this$static, filterBeginTime){
  this$static.filterBeginTime = filterBeginTime;
}

function $addFilterEndTime_1(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function CallTimeDataCriteria_0(){
  Criteria_4.call(this);
  this.filterDataType = ($clinit_DataType() , CALLTIME);
  this.filterOverrides.put('resourceId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData    WHERE callData.key.schedule.resource.id = ? )');
  this.filterOverrides.put('resourceGroupId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res     JOIN res.implicitGroups ig    WHERE callData.key.schedule.resource.id = res.id      AND ig.id = ? ) ');
  this.filterOverrides.put('autoGroupResourceTypeId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res    WHERE callData.key.schedule.resource.id = res.id      AND res.resourceType.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'id IN ( SELECT callData.id     FROM CallTimeDataValue callData, Resource res    WHERE callData.key.schedule.resource.id = res.id      AND res.parentResource.id = ? )');
  this.filterOverrides.put('beginTime', 'beginTime > ?');
  this.filterOverrides.put('endTime', 'endTime < ?');
  this.filterOverrides.put('destination', 'key.callDestination like ?');
  this.filterOverrides.put('dataType', 'key.schedule.definition.dataType = ?');
  this.sortOverrides.put('minimum', 'MIN(' + $getAlias(this) + '.minimum)');
  this.sortOverrides.put('maximum', 'MAX(' + $getAlias(this) + '.maximum)');
  this.sortOverrides.put('average', '(SUM(' + $getAlias(this) + '.total) / SUM(' + $getAlias(this) + '.count))');
  this.sortOverrides.put('total', 'SUM(' + $getAlias(this) + '.total)');
  this.sortOverrides.put('count', 'SUM(' + $getAlias(this) + '.count)');
}

defineSeed(1092, 1066, makeCastMap([Q$Serializable, Q$CallTimeDataCriteria, Q$Criteria]), CallTimeDataCriteria_0);
_.getPersistentClass = function getPersistentClass_9(){
  return Lorg_rhq_core_domain_measurement_calltime_CallTimeDataValue_2_classLit;
}
;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterBeginTime = null;
_.filterCount = null;
_.filterDestination = null;
_.filterEndTime = null;
_.filterMaximum = null;
_.filterMinimum = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterTotal = null;
_.sortAverage = null;
_.sortCount = null;
_.sortMaximum = null;
_.sortMinimum = null;
_.sortTotal = null;
function serialize_199(streamWriter, instance){
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeObject(streamWriter, instance.filterBeginTime);
  $writeObject(streamWriter, instance.filterCount);
  $writeObject(streamWriter, instance.filterDataType);
  $writeString(streamWriter, instance.filterDestination);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterMaximum);
  $writeObject(streamWriter, instance.filterMinimum);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterTotal);
  $writeObject(streamWriter, instance.sortAverage);
  $writeObject(streamWriter, instance.sortCount);
  $writeObject(streamWriter, instance.sortMaximum);
  $writeObject(streamWriter, instance.sortMinimum);
  $writeObject(streamWriter, instance.sortTotal);
  serialize_200(streamWriter, instance);
}

function $addFilterCategory(this$static, category){
  this$static.filterCategory = category;
}

function $addFilterGroupId(this$static, filterGroupId){
  this$static.filterGroupId = filterGroupId;
}

function $addFilterResourceId_0(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addSortName(this$static, sortName){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function DashboardCriteria_0(){
  Criteria_4.call(this);
  this.filterCategory = ($clinit_DashboardCategory() , INVENTORY);
  this.filterOverrides.put('groupId', 'group.id = ?');
  this.filterOverrides.put('ownerId', 'owner.id = ?');
  this.filterOverrides.put('resourceId', 'resource.id = ?');
}

defineSeed(1101, 1066, makeCastMap([Q$Serializable, Q$Criteria]), DashboardCriteria_0);
_.getPersistentClass = function getPersistentClass_10(){
  return Lorg_rhq_core_domain_dashboard_Dashboard_2_classLit;
}
;
_.fetchConfiguration = false;
_.fetchOwner = false;
_.filterGroupId = null;
_.filterName = null;
_.filterOwnerId = null;
_.filterResourceId = null;
_.filterShared = null;
_.sortName = null;
function serialize_203(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchConfiguration);
  $writeBoolean(streamWriter, instance.fetchOwner);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOwnerId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterShared);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterResourceIds_1(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterTemplateId(this$static, filterTemplateId){
  this$static.filterTemplateId = filterTemplateId;
}

function $fetchConfiguration(this$static, fetchConfiguration){
  this$static.fetchConfiguration = fetchConfiguration;
}

function $fetchResource(this$static, fetchResource){
  this$static.fetchResource = fetchResource;
}

function $fetchTemplate(this$static, fetchTemplate){
  this$static.fetchTemplate = fetchTemplate;
}

function DriftDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('templateId', 'template.id = ?');
}

defineSeed(1103, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$DriftDefinitionCriteria]), DriftDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_11(){
  return Lorg_rhq_core_domain_drift_DriftDefinition_2_classLit;
}
;
_.fetchConfiguration = null;
_.fetchResource = null;
_.fetchTemplate = null;
_.filterName = null;
_.filterResourceIds = null;
_.filterTemplateId = null;
_.sortName = null;
function serialize_204(streamWriter, instance){
  $writeObject(streamWriter, instance.fetchConfiguration);
  $writeObject(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.fetchTemplate);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterTemplateId);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterResourceTypeId(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function DriftDefinitionTemplateCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceTypeId', 'resourceType.id = ?');
}

defineSeed(1105, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$DriftDefinitionTemplateCriteria]), DriftDefinitionTemplateCriteria_0);
_.getPersistentClass = function getPersistentClass_12(){
  return Lorg_rhq_core_domain_drift_DriftDefinitionTemplate_2_classLit;
}
;
_.fetchDriftDefinitions = false;
_.fetchResourceType = false;
_.filterName = null;
_.filterResourceTypeId = null;
function serialize_205(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchDriftDefinitions);
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  serialize_200(streamWriter, instance);
}

function $addFilterAutoGroupParentResourceId(this$static, filterAutoGroupParentResourceId){
  this$static.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
}

function $addFilterAutoGroupResourceTypeId(this$static, filterAutoGroupResourceTypeId){
  this$static.filterAutoGroupResourceTypeId = filterAutoGroupResourceTypeId;
}

function $addFilterDetail(this$static, filterDetail){
  this$static.filterDetail = filterDetail;
}

function $addFilterEndTime_2(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterEntityContext_0(this$static, filterEntityContext){
  if (filterEntityContext.type_0 == ($clinit_EntityContext$Type() , Resource)) {
    $addFilterResourceId_1(this$static, valueOf_44(filterEntityContext.resourceId));
  }
   else if (filterEntityContext.type_0 == ResourceGroup) {
    $addFilterResourceGroupId(this$static, valueOf_44(filterEntityContext.groupId));
  }
   else if (filterEntityContext.type_0 == AutoGroup) {
    $addFilterAutoGroupParentResourceId(this$static, valueOf_44(filterEntityContext.parentResourceId));
    $addFilterAutoGroupResourceTypeId(this$static, valueOf_44(filterEntityContext.resourceTypeId));
  }
}

function $addFilterResourceGroupId(this$static, filterResourceGroupId){
  this$static.filterResourceGroupId = filterResourceGroupId;
}

function $addFilterResourceId_1(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addFilterSourceName(this$static, filterSourceName){
  this$static.filterSourceName = filterSourceName;
}

function $addFilterStartTime_1(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function EventCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('sourceName', 'source.location like ?');
  this.filterOverrides.put('sourceId', 'source.id = ?');
  this.filterOverrides.put('startTime', 'timestamp >= ?');
  this.filterOverrides.put('endTime', 'timestamp <= ?');
  this.filterOverrides.put('resourceId', 'source.resourceId = ?');
  this.filterOverrides.put('resourceGroupId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.implicitGroups ig    WHERE ig.id = ? )');
  this.filterOverrides.put('autoGroupResourceTypeId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'source.resourceId IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )');
  this.filterOverrides.put('severities', 'severity IN ( ? )');
}

defineSeed(1107, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$EventCriteria]), EventCriteria_0);
_.getPersistentClass = function getPersistentClass_13(){
  return Lorg_rhq_core_domain_event_Event_2_classLit;
}
;
_.fetchSource = false;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterDetail = null;
_.filterEndTime = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterSeverities = null;
_.filterSourceId = null;
_.filterSourceName = null;
_.filterStartTime = null;
_.sortSeverity = null;
_.sortTimestamp = null;
function serialize_206(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchSource);
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeString(streamWriter, instance.filterDetail);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterSeverities);
  $writeObject(streamWriter, instance.filterSourceId);
  $writeString(streamWriter, instance.filterSourceName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.sortSeverity);
  $writeObject(streamWriter, instance.sortTimestamp);
  serialize_200(streamWriter, instance);
}

function $addFilterDriftDefinitionId(this$static, filterDriftDefId){
  this$static.filterDriftDefId = filterDriftDefId;
}

function $addSortVersion(this$static, sortVersion){
  this$static.sortVersion = sortVersion;
}

function GenericDriftChangeSetCriteria_0(){
}

defineSeed(1109, 1, makeCastMap([Q$Serializable, Q$GenericDriftChangeSetCriteria]), GenericDriftChangeSetCriteria_0);
_.getPageControlOverrides = function getPageControlOverrides_0(){
  return this.pageControl;
}
;
_.setPageControl = function setPageControl_0(pageControl){
  this.pageControl = pageControl;
}
;
_.fetchDrifts = false;
_.filterCategory = null;
_.filterCreatedAfter = null;
_.filterCreatedBefore = null;
_.filterDriftCategories = null;
_.filterDriftDefId = null;
_.filterDriftDirectory = null;
_.filterDriftPath = null;
_.filterEndVersion = null;
_.filterId = null;
_.filterResourceId = null;
_.filterStartVersion = null;
_.filterVersion = null;
_.pageControl = null;
_.sortId = null;
_.sortVersion = null;
_.strict = false;
function serialize_207(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchDrifts);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterCreatedAfter);
  $writeObject(streamWriter, instance.filterCreatedBefore);
  $writeObject(streamWriter, instance.filterDriftCategories);
  $writeObject(streamWriter, instance.filterDriftDefId);
  $writeString(streamWriter, instance.filterDriftDirectory);
  $writeString(streamWriter, instance.filterDriftPath);
  $writeString(streamWriter, instance.filterEndVersion);
  $writeString(streamWriter, instance.filterId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeString(streamWriter, instance.filterStartVersion);
  $writeString(streamWriter, instance.filterVersion);
  $writeObject(streamWriter, instance.pageControl);
  $writeObject(streamWriter, instance.sortId);
  $writeObject(streamWriter, instance.sortVersion);
  $writeBoolean(streamWriter, instance.strict);
}

function $addFilterChangeSetId(this$static, filterChangeSetId){
  this$static.filterChangeSetId = filterChangeSetId;
}

function $addFilterChangeSetStartVersion(this$static, filterChangeSetStartVersion){
  this$static.filterChangeSetStartVersion = filterChangeSetStartVersion;
}

function $addFilterDriftHandlingModes(this$static, filterDriftHandlingModes){
  this$static.filterDriftHandlingModes = getListIgnoringNulls(filterDriftHandlingModes);
}

function $addFilterEndTime_3(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterResourceIds_2(this$static, filterResourceIds){
  this$static.filterResourceIds = getListIgnoringNulls(filterResourceIds);
}

function $addFilterStartTime_2(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function GenericDriftCriteria_0(){
  this.filterCategories = new ArrayList_0;
  this.filterDriftHandlingModes = new ArrayList_0;
  this.filterResourceIds = new ArrayList_0;
}

defineSeed(1111, 1, makeCastMap([Q$Serializable, Q$GenericDriftCriteria]), GenericDriftCriteria_0);
_.getPageControlOverrides = function getPageControlOverrides_1(){
  return this.pageControl;
}
;
_.setPageControl = function setPageControl_1(pageControl){
  this.pageControl = pageControl;
}
;
_.fetchChangeSet = false;
_.filterChangeSetEndVersion = null;
_.filterChangeSetId = null;
_.filterChangeSetStartVersion = null;
_.filterDirectory = null;
_.filterDriftDefinitionId = null;
_.filterEndTime = null;
_.filterId = null;
_.filterPath = null;
_.filterStartTime = null;
_.pageControl = null;
_.sortCtime = null;
_.sortId = null;
_.strict = false;
function serialize_208(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchChangeSet);
  $writeObject(streamWriter, instance.filterCategories);
  $writeObject(streamWriter, instance.filterChangeSetEndVersion);
  $writeString(streamWriter, instance.filterChangeSetId);
  $writeObject(streamWriter, instance.filterChangeSetStartVersion);
  $writeString(streamWriter, instance.filterDirectory);
  $writeObject(streamWriter, instance.filterDriftDefinitionId);
  $writeObject(streamWriter, instance.filterDriftHandlingModes);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeString(streamWriter, instance.filterId);
  $writeString(streamWriter, instance.filterPath);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.pageControl);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortId);
  $writeBoolean(streamWriter, instance.strict);
}

function $addFilterResourceGroupIds_2(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function GroupBundleDeploymentCriteria_0(){
  BundleDeploymentCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'destination.group.id IN ( SELECT rg.id     FROM ResourceGroup rg     JOIN rg.bundleDestinations bds    WHERE rg.id = ? )');
}

defineSeed(1113, 1082, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), GroupBundleDeploymentCriteria_0);
_.filterResourceGroupIds = null;
function serialize_209(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_194(streamWriter, instance);
}

function $addFilterEndTime_4(this$static, filterEndTime){
  this$static.filterEndTime = filterEndTime;
}

function $addFilterStartTime_3(this$static, filterStartTime){
  this$static.filterStartTime = filterStartTime;
}

function OperationHistoryCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('operationDefinitionId', 'operationDefinition.id = ?');
  this.filterOverrides.put('operationName', 'operationDefinition.name like ?');
  this.filterOverrides.put('startTime', 'startedTime >= ?');
  this.filterOverrides.put('endTime', 'modifiedTime <= ?');
  this.filterOverrides.put('resourceIds', 'id IN  ( SELECT roh.id      FROM ResourceOperationHistory roh     WHERE roh.resource.id IN ( ? ) ) ');
  this.filterOverrides.put('statuses', 'status IN ( ? )');
  this.sortOverrides.put('startTime', 'startedTime');
  this.sortOverrides.put('endTime', 'modifiedTime');
  this.sortOverrides.put('operationName', 'operationDefinition.name');
}

defineSeed(1116, 1066, makeCastMap([Q$Serializable, Q$Criteria]));
_.getPersistentClass = function getPersistentClass_14(){
  return Lorg_rhq_core_domain_operation_OperationHistory_2_classLit;
}
;
_.fetchOperationDefinition = false;
_.fetchParameters = false;
_.filterEndTime = null;
_.filterErrorMessage = null;
_.filterJobGroup = null;
_.filterJobName = null;
_.filterOperationDefinitionId = null;
_.filterOperationName = null;
_.filterStartTime = null;
_.filterStatus = null;
_.filterStatuses = null;
_.sortEndTime = null;
_.sortOperationName = null;
_.sortStartTime = null;
_.sortStatus = null;
function $addFilterResourceGroupIds_3(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = filterResourceGroupIds;
}

function GroupOperationHistoryCriteria_0(){
  OperationHistoryCriteria_0.call(this);
  this.filterOverrides.put('resourceGroupIds', 'group.id IN ( ? )');
}

defineSeed(1115, 1116, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupOperationHistoryCriteria]), GroupOperationHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_15(){
  return Lorg_rhq_core_domain_operation_GroupOperationHistory_2_classLit;
}
;
_.filterResourceGroupIds = null;
function serialize_210(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  serialize_217(streamWriter, instance);
}

function GroupPluginConfigurationUpdateCriteria_0(){
  AbstractGroupConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1118, 1068, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupPluginConfigurationUpdateCriteria]), GroupPluginConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_16(){
  return Lorg_rhq_core_domain_configuration_group_GroupPluginConfigurationUpdate_2_classLit;
}
;
function serialize_211(streamWriter, instance){
  serialize_188(streamWriter, instance);
}

function GroupResourceConfigurationUpdateCriteria_0(){
  AbstractGroupConfigurationUpdateCriteria_0.call(this);
}

defineSeed(1120, 1068, makeCastMap([Q$Serializable, Q$Criteria, Q$GroupResourceConfigurationUpdateCriteria]), GroupResourceConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_17(){
  return Lorg_rhq_core_domain_configuration_group_GroupResourceConfigurationUpdate_2_classLit;
}
;
function serialize_212(streamWriter, instance){
  serialize_188(streamWriter, instance);
}

function $addFilterResourceGroupIds_4(this$static, filterResourceGroupIds){
  this$static.filterResourceGroupIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function $addFilterResourceId_2(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function $addSortStatus_1(this$static, sortStatus){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(115)) + 'ort');
  this$static.sortStatus = sortStatus;
}

function InstalledPackageHistoryCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('installationTimeMinimum', 'installationDate >= ?');
  this.filterOverrides.put('installationTimeMaximum', 'installationDate <= ?');
  this.filterOverrides.put('packageVersionId', 'packageVersion.id = ? ');
  this.filterOverrides.put('resourceId', 'resource.id = ? ');
  this.filterOverrides.put('groupId', 'resource.explicitGroups.id = ? ');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.filterOverrides.put('userId', 'user.id = ? ');
}

defineSeed(1122, 1066, makeCastMap([Q$Serializable, Q$Criteria]), InstalledPackageHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_18(){
  return Lorg_rhq_core_domain_content_InstalledPackageHistory_2_classLit;
}
;
_.fetchPackageVersion = false;
_.fetchResource = false;
_.fetchUser = false;
_.filterInstallationTimeMaximum = null;
_.filterInstallationTimeMinimum = null;
_.filterPackageVersionId = null;
_.filterResourceGroupIds = null;
_.filterResourceId = null;
_.filterUserId = null;
_.sortInstallationDate = null;
_.sortStatus = null;
function serialize_213(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchPackageVersion);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeBoolean(streamWriter, instance.fetchUser);
  $writeObject(streamWriter, instance.filterInstallationTimeMaximum);
  $writeObject(streamWriter, instance.filterInstallationTimeMinimum);
  $writeObject(streamWriter, instance.filterPackageVersionId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterUserId);
  $writeObject(streamWriter, instance.sortInstallationDate);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_200(streamWriter, instance);
}

function $addFilterGroupId_0(this$static, filterGroupId){
  if (this$static.filterResourceId) {
    throw new IllegalArgumentException_1('This criteria cannot be filtered by both a Resource id and a group id.');
  }
  this$static.filterGroupId = filterGroupId;
}

function $addFilterResourceId_3(this$static, filterResourceId){
  if (this$static.filterGroupId) {
    throw new IllegalArgumentException_1('This criteria cannot be filtered by both a Resource id and a group id.');
  }
  this$static.filterResourceId = filterResourceId;
}

function MeasurementDataTraitCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('scheduleId', 'id.scheduleId = ?');
  this.filterOverrides.put('resourceId', 'schedule.resource.id = ?');
  this.filterOverrides.put('groupId', 'schedule.resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.explicitGroups grp    WHERE grp.id = ? )');
  this.filterOverrides.put('definitionId', 'schedule.definition.id = ?');
  this.filterOverrides.put('maxTimestamp', 'id.timestamp = ( SELECT MAX(mdt.id.timestamp)     FROM MeasurementDataTrait mdt    WHERE mdt.id.scheduleId = ' + $getAlias(this) + '.id.scheduleId )      AND 1 = ?');
  this.sortOverrides.put('timestamp', 'id.timestamp');
  this.sortOverrides.put('displayName', 'schedule.definition.displayName');
  this.sortOverrides.put('resourceName', 'schedule.resource.name');
}

defineSeed(1124, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$MeasurementDataTraitCriteria]), MeasurementDataTraitCriteria_0);
_.getPersistentClass = function getPersistentClass_19(){
  return Lorg_rhq_core_domain_measurement_MeasurementDataTrait_2_classLit;
}
;
_.fetchSchedule = false;
_.filterDefinitionId = null;
_.filterGroupId = null;
_.filterMaxTimestamp = null;
_.filterResourceId = null;
_.filterScheduleId = null;
_.sortDisplayName = null;
_.sortResourceName = null;
_.sortTimestamp = null;
function serialize_214(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchSchedule);
  $writeObject(streamWriter, instance.filterDefinitionId);
  $writeObject(streamWriter, instance.filterGroupId);
  $writeObject(streamWriter, instance.filterMaxTimestamp);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterScheduleId);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortResourceName);
  $writeObject(streamWriter, instance.sortTimestamp);
  serialize_200(streamWriter, instance);
}

function MeasurementDefinitionCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceTypeName', 'resourceType.name like ?');
  this.filterOverrides.put('resourceTypeId', 'resourceType.id = ?');
  this.sortOverrides.put('resourceTypeName', 'resourceType.name');
}

defineSeed(1126, 1066, makeCastMap([Q$Serializable, Q$Criteria]), MeasurementDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_20(){
  return Lorg_rhq_core_domain_measurement_MeasurementDefinition_2_classLit;
}
;
_.fetchResourceType = false;
_.filterCategory = null;
_.filterDataType = null;
_.filterDefaultInterval = null;
_.filterDefaultOn = null;
_.filterDescription = null;
_.filterDisplayName = null;
_.filterDisplayType = null;
_.filterName = null;
_.filterNumericType = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.filterUnits = null;
_.sortCategory = null;
_.sortDataType = null;
_.sortDefaultInterval = null;
_.sortDefaultOn = null;
_.sortDisplayName = null;
_.sortDisplayType = null;
_.sortName = null;
_.sortNumericType = null;
_.sortResourceTypeName = null;
_.sortUnits = null;
function serialize_215(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResourceType);
  $writeObject(streamWriter, instance.filterCategory);
  $writeObject(streamWriter, instance.filterDataType);
  $writeObject(streamWriter, instance.filterDefaultInterval);
  $writeObject(streamWriter, instance.filterDefaultOn);
  $writeString(streamWriter, instance.filterDescription);
  $writeString(streamWriter, instance.filterDisplayName);
  $writeObject(streamWriter, instance.filterDisplayType);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterNumericType);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.filterUnits);
  $writeObject(streamWriter, instance.sortCategory);
  $writeObject(streamWriter, instance.sortDataType);
  $writeObject(streamWriter, instance.sortDefaultInterval);
  $writeObject(streamWriter, instance.sortDefaultOn);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortDisplayType);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortNumericType);
  $writeObject(streamWriter, instance.sortResourceTypeName);
  $writeObject(streamWriter, instance.sortUnits);
  serialize_200(streamWriter, instance);
}

function $addFilterResourceGroupId_0(this$static, filterResourceGroupId){
  this$static.filterResourceGroupId = filterResourceGroupId;
}

function $addFilterResourceId_4(this$static, filterResourceId){
  this$static.filterResourceId = filterResourceId;
}

function MeasurementScheduleCriteria_0(){
  var defaults;
  Criteria_4.call(this);
  this.filterOverrides.put('definitionIds', 'definition.id IN ( ? )');
  this.filterOverrides.put('resourceId', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.explicitGroups eg    WHERE eg.id = ? )');
  this.filterOverrides.put('resourceInventoryStatuses', 'resource.inventoryStatus IN ( ? )');
  this.filterOverrides.put('autoGroupResourceTypeId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )');
  this.filterOverrides.put('autoGroupParentResourceId', 'resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )');
  this.filterOverrides.put('resourceTypeId', 'resource.type.id = ?');
  this.sortOverrides.put('name', 'definition.name');
  this.sortOverrides.put('displayName', 'definition.displayName');
  this.sortOverrides.put('dataType', 'definition.dataType');
  defaults = new ArrayList_1(1);
  $add_3(defaults, ($clinit_InventoryStatus() , COMMITTED));
  this.filterResourceInventoryStatuses = defaults;
}

defineSeed(1128, 1066, makeCastMap([Q$Serializable, Q$Criteria]), MeasurementScheduleCriteria_0);
_.getPersistentClass = function getPersistentClass_21(){
  return Lorg_rhq_core_domain_measurement_MeasurementSchedule_2_classLit;
}
;
_.fetchBaseline = false;
_.fetchDefinition = false;
_.fetchResource = false;
_.filterAutoGroupParentResourceId = null;
_.filterAutoGroupResourceTypeId = null;
_.filterDefinitionIds = null;
_.filterEnabled = null;
_.filterResourceGroupId = null;
_.filterResourceId = null;
_.filterResourceInventoryStatuses = null;
_.filterResourceTypeId = null;
_.sortDataType = null;
_.sortDisplayName = null;
_.sortName = null;
function serialize_216(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchBaseline);
  $writeBoolean(streamWriter, instance.fetchDefinition);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterAutoGroupParentResourceId);
  $writeObject(streamWriter, instance.filterAutoGroupResourceTypeId);
  $writeObject(streamWriter, instance.filterDefinitionIds);
  $writeObject(streamWriter, instance.filterEnabled);
  $writeObject(streamWriter, instance.filterResourceGroupId);
  $writeObject(streamWriter, instance.filterResourceId);
  $writeObject(streamWriter, instance.filterResourceInventoryStatuses);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeObject(streamWriter, instance.sortDataType);
  $writeObject(streamWriter, instance.sortDisplayName);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function serialize_217(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchOperationDefinition);
  $writeBoolean(streamWriter, instance.fetchParameters);
  $writeObject(streamWriter, instance.filterEndTime);
  $writeString(streamWriter, instance.filterErrorMessage);
  $writeString(streamWriter, instance.filterJobGroup);
  $writeString(streamWriter, instance.filterJobName);
  $writeObject(streamWriter, instance.filterOperationDefinitionId);
  $writeString(streamWriter, instance.filterOperationName);
  $writeObject(streamWriter, instance.filterStartTime);
  $writeObject(streamWriter, instance.filterStatus);
  $writeObject(streamWriter, instance.filterStatuses);
  $writeObject(streamWriter, instance.sortEndTime);
  $writeObject(streamWriter, instance.sortOperationName);
  $writeObject(streamWriter, instance.sortStartTime);
  $writeObject(streamWriter, instance.sortStatus);
  serialize_200(streamWriter, instance);
}

function $addFilterPackageTypeId(this$static, packageTypeId){
  this$static.filterPackageTypeId = packageTypeId;
}

function $addFilterRepoId(this$static, repoId){
  this$static.filterRepoId = repoId;
}

function PackageCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('packageTypeId', 'packageType.id = ? ');
  this.filterOverrides.put('repoId', 'id IN (SELECT rpv.packageVersion.generalPackage.id FROM RepoPackageVersion rpv WHERE rpv.repo.id = ?)');
}

defineSeed(1131, 1066, makeCastMap([Q$Serializable, Q$Criteria]), PackageCriteria_0);
_.getPersistentClass = function getPersistentClass_22(){
  return Lorg_rhq_core_domain_content_Package_2_classLit;
}
;
_.fetchVersions = false;
_.filterClassification = null;
_.filterName = null;
_.filterPackageTypeId = null;
_.filterRepoId = null;
_.sortName = null;
function serialize_218(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchVersions);
  $writeString(streamWriter, instance.filterClassification);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterPackageTypeId);
  $writeObject(streamWriter, instance.filterRepoId);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function serialize_219(streamWriter, instance){
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeBoolean(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  $writeString(streamWriter, instance.nullField);
  $writeObject(streamWriter, instance.nullField);
  serialize_200(streamWriter, instance);
}

function $addFilterEventDetail(this$static, eventDetail){
  this$static.filterEventDetail = eventDetail;
}

function PartitionEventCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('eventType', 'eventType IN ( ? )');
  this.filterOverrides.put('executionStatus', 'executionStatus IN ( ? )');
}

defineSeed(1134, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$PartitionEventCriteria]), PartitionEventCriteria_0);
_.getPersistentClass = function getPersistentClass_23(){
  return Lorg_rhq_core_domain_cloud_PartitionEvent_2_classLit;
}
;
_.filterEventDetail = null;
_.filterEventType = null;
_.filterExecutionStatus = null;
_.sortCtime = null;
function serialize_220(streamWriter, instance){
  $writeString(streamWriter, instance.filterEventDetail);
  $writeObject(streamWriter, instance.filterEventType);
  $writeObject(streamWriter, instance.filterExecutionStatus);
  $writeObject(streamWriter, instance.sortCtime);
  serialize_200(streamWriter, instance);
}

function $addFilterGroupConfigurationUpdateId(this$static, filterGroupConfigurationUpdateId){
  this$static.filterGroupConfigurationUpdateId = filterGroupConfigurationUpdateId;
}

function PluginConfigurationUpdateCriteria_0(){
  AbstractResourceConfigurationUpdateCriteria_0.call(this);
  this.filterOverrides.put('groupConfigurationUpdateId', 'groupConfigurationUpdate.id = ?');
  this.filterOverrides.put('resourceTypeId', 'resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.sortOverrides.put('name', 'resource.name');
  this.sortOverrides.put('resourceId', 'resource.id');
}

defineSeed(1136, 1070, makeCastMap([Q$Serializable, Q$Criteria, Q$PluginConfigurationUpdateCriteria]), PluginConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_24(){
  return Lorg_rhq_core_domain_configuration_PluginConfigurationUpdate_2_classLit;
}
;
_.fetchGroupConfigurationUpdate = false;
_.fetchResource = false;
_.filterGroupConfigurationUpdateId = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.sortName = null;
_.sortResourceId = null;
function serialize_221(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchGroupConfigurationUpdate);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterGroupConfigurationUpdateId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortResourceId);
  serialize_187(streamWriter, instance);
}

function RepoCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('resourceIds', 'resourceRepos.resource.id IN ( ? )');
  this.filterOverrides.put('contentSourceIds', 'id IN ( SELECT innerRepo           FROM Repo innerRepo           JOIN innerRepo.repoContentSources rcs          WHERE rcs.contentSource.id IN ( ? ))');
  this.filterOverrides.put('ownerId', 'owner.id = ?');
}

defineSeed(1138, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$RepoCriteria]), RepoCriteria_0);
_.getPersistentClass = function getPersistentClass_25(){
  return Lorg_rhq_core_domain_content_Repo_2_classLit;
}
;
_.fetchRepoContentSources = false;
_.fetchRepoPackageVersions = false;
_.fetchRepoRepoGroups = false;
_.fetchRepoRepoRelationships = false;
_.fetchResourceRepos = false;
_.filterCandidate = null;
_.filterContentSourceIds = null;
_.filterDescription = null;
_.filterIsPrivate = null;
_.filterName = null;
_.filterOwnerId = null;
_.filterResourceIds = null;
_.sortName = null;
function serialize_222(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchRepoContentSources);
  $writeBoolean(streamWriter, instance.fetchRepoPackageVersions);
  $writeBoolean(streamWriter, instance.fetchRepoRepoGroups);
  $writeBoolean(streamWriter, instance.fetchRepoRepoRelationships);
  $writeBoolean(streamWriter, instance.fetchResourceRepos);
  $writeObject(streamWriter, instance.filterCandidate);
  $writeObject(streamWriter, instance.filterContentSourceIds);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterIsPrivate);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOwnerId);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterResourceIds_3(this$static, filterResourceGroupIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceGroupIds);
}

function ResourceBundleDeploymentCriteria_0(){
  BundleDeploymentCriteria_0.call(this);
  this.filterOverrides.put('resourceIds', 'id IN ( SELECT ibd.id     FROM BundleDeployment ibd     JOIN ibd.resourceDeployments resourceDeployment    WHERE resourceDeployment.resource.id IN ( ? ) )');
}

defineSeed(1140, 1082, makeCastMap([Q$Serializable, Q$BundleDeploymentCriteria, Q$Criteria]), ResourceBundleDeploymentCriteria_0);
_.filterResourceIds = null;
function serialize_223(streamWriter, instance){
  $writeObject(streamWriter, instance.filterResourceIds);
  serialize_194(streamWriter, instance);
}

function $addFilterGroupConfigurationUpdateId_0(this$static, filterGroupConfigurationUpdateId){
  this$static.filterGroupConfigurationUpdateId = filterGroupConfigurationUpdateId;
}

function $addFilterResourceIds_4(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function ResourceConfigurationUpdateCriteria_0(){
  AbstractResourceConfigurationUpdateCriteria_0.call(this);
  $addRequiredPermissions(this, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , CONFIGURE_READ)]));
  this.filterOverrides.put('groupConfigurationUpdateId', 'groupConfigurationUpdate.id = ?');
  this.filterOverrides.put('resourceTypeId', 'resource.resourceType.id = ?');
  this.filterOverrides.put('resourceTypeName', 'resource.resourceType.name like ?');
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('resourceGroupIds', 'resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )');
  this.sortOverrides.put('resourceName', 'resource.name');
  this.sortOverrides.put('resourceId', 'resource.id');
}

defineSeed(1142, 1070, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceConfigurationUpdateCriteria]), ResourceConfigurationUpdateCriteria_0);
_.getPersistentClass = function getPersistentClass_26(){
  return Lorg_rhq_core_domain_configuration_ResourceConfigurationUpdate_2_classLit;
}
;
_.fetchGroupConfigurationUpdate = false;
_.fetchResource = false;
_.filterGroupConfigurationUpdateId = null;
_.filterResourceGroupIds = null;
_.filterResourceIds = null;
_.filterResourceTypeId = null;
_.filterResourceTypeName = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_224(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchGroupConfigurationUpdate);
  $writeBoolean(streamWriter, instance.fetchResource);
  $writeObject(streamWriter, instance.filterGroupConfigurationUpdateId);
  $writeObject(streamWriter, instance.filterResourceGroupIds);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.filterResourceTypeId);
  $writeString(streamWriter, instance.filterResourceTypeName);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_187(streamWriter, instance);
}

function $addFilterCurrentAvailability(this$static, filterCurrentAvailability){
  this$static.filterCurrentAvailability = filterCurrentAvailability;
}

function $addFilterExplicitGroupIds(this$static, filterExplicitGroupIds){
  this$static.filterExplicitGroupIds = getListIgnoringNulls(filterExplicitGroupIds);
}

function $addFilterImplicitGroupIds(this$static, filterImplicitGroupIds){
  this$static.filterImplicitGroupIds = getListIgnoringNulls(filterImplicitGroupIds);
}

function $addFilterName_1(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterParentResourceCategory(this$static, filterParentResourceCategory){
  this$static.filterParentResourceCategory = filterParentResourceCategory;
}

function $addFilterParentResourceId(this$static, filterParentResourceId){
  this$static.filterParentResourceId = filterParentResourceId;
}

function $addFilterPluginName(this$static, filterPluginName){
  this$static.filterPluginName = filterPluginName;
}

function $addFilterResourceCategories(this$static, filterResourceCategories){
  this$static.filterResourceCategories = getListIgnoringNulls(filterResourceCategories);
}

function $addFilterResourceTypeId_0(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function $addFilterVersion(this$static, filterVersion){
  this$static.filterVersion = filterVersion;
}

function $addSortName_0(this$static, sortName){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function $addFilterAutoGroupParentResourceId_0(this$static, filterAutoGroupParentResourceId){
  this$static.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
}

function $addFilterDownMemberCount(this$static, filterDownMemberCount){
  this$static.filterDownMemberCount = filterDownMemberCount;
}

function $addFilterExplicitResourceIds(this$static, filterExplicitResourceIds){
  this$static.filterExplicitResourceIds = getListIgnoringNulls(filterExplicitResourceIds);
}

function $addFilterGroupCategory(this$static, filterGroupCategory){
  this$static.filterGroupCategory = filterGroupCategory;
}

function $addFilterGroupDefinitionId(this$static, filterGroupDefinitionId){
  this$static.filterGroupDefinitionId = filterGroupDefinitionId;
}

function $addFilterName_2(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPrivate(this$static, filterPrivate){
  this$static.filterPrivate = filterPrivate;
}

function $addFilterResourceTypeId_1(this$static, filterResourceTypeId){
  this$static.filterResourceTypeId = filterResourceTypeId;
}

function $addFilterVisible(this$static, filterVisible){
  if (!filterVisible) {
    throw new IllegalArgumentException_1('A single fetch may be for visible or invisible groups, but not both.');
  }
  this$static.filterVisible = filterVisible;
}

function ResourceGroupDefinitionCriteria_0(){
  Criteria_4.call(this);
}

defineSeed(1148, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceGroupDefinitionCriteria]), ResourceGroupDefinitionCriteria_0);
_.getPersistentClass = function getPersistentClass_29(){
  return Lorg_rhq_core_domain_resource_group_GroupDefinition_2_classLit;
}
;
_.fetchManagedResourceGroups = false;
_.filterDescription = null;
_.filterExpression = null;
_.filterName = null;
_.filterRecursive = null;
_.sortDescription = null;
_.sortExpression = null;
_.sortName = null;
_.sortRecursive = null;
function $addFilterGroupOperationHistoryId(this$static, groupOperationHistoryId){
  this$static.filterGroupOperationHistoryId = groupOperationHistoryId;
}

function $addFilterResourceIds_5(this$static, filterResourceIds){
  this$static.filterResourceIds = new Arrays$ArrayList_0(filterResourceIds);
}

function ResourceOperationHistoryCriteria_0(){
  OperationHistoryCriteria_0.call(this);
  this.filterOverrides.put('resourceIds', 'resource.id IN ( ? )');
  this.filterOverrides.put('groupOperationHistoryId', 'groupOperationHistory.id = ?');
  this.sortOverrides.put('resourceName', 'resource.id');
  this.sortOverrides.put('resourceName', 'resource.name');
}

defineSeed(1150, 1116, makeCastMap([Q$Serializable, Q$Criteria, Q$ResourceOperationHistoryCriteria]), ResourceOperationHistoryCriteria_0);
_.getPersistentClass = function getPersistentClass_30(){
  return Lorg_rhq_core_domain_operation_ResourceOperationHistory_2_classLit;
}
;
_.fetchResults = false;
_.filterGroupOperationHistoryId = null;
_.filterResourceIds = null;
_.sortResourceId = null;
_.sortResourceName = null;
function serialize_228(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchResults);
  $writeObject(streamWriter, instance.filterGroupOperationHistoryId);
  $writeObject(streamWriter, instance.filterResourceIds);
  $writeObject(streamWriter, instance.sortResourceId);
  $writeObject(streamWriter, instance.sortResourceName);
  serialize_217(streamWriter, instance);
}

function $addFilterIgnored(this$static, ignored){
  this$static.filterIgnored = ignored;
}

function RoleCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('subjectId', 'id IN ( SELECT innerRole.id           FROM Role innerRole           JOIN innerRole.subjects innerSubject          WHERE innerSubject.id = ? )');
  this.filterOverrides.put('ldapSubjectId', 'id IN ( SELECT innerRole.id           FROM Role innerRole           JOIN innerRole.ldapSubjects innerSubject          WHERE innerSubject.id = ? )');
}

defineSeed(1154, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$RoleCriteria]), RoleCriteria_0);
_.getPersistentClass = function getPersistentClass_32(){
  return Lorg_rhq_core_domain_authz_Role_2_classLit;
}
;
_.fetchLdapGroups = false;
_.fetchPermissions = false;
_.fetchResourceGroups = false;
_.fetchRoleNotifications = false;
_.fetchSubjects = false;
_.filterDescription = null;
_.filterLdapSubjectId = null;
_.filterName = null;
_.filterSubjectId = null;
_.sortName = null;
function serialize_230(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchLdapGroups);
  $writeBoolean(streamWriter, instance.fetchPermissions);
  $writeBoolean(streamWriter, instance.fetchResourceGroups);
  $writeBoolean(streamWriter, instance.fetchRoleNotifications);
  $writeBoolean(streamWriter, instance.fetchSubjects);
  $writeString(streamWriter, instance.filterDescription);
  $writeObject(streamWriter, instance.filterLdapSubjectId);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterSubjectId);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterAddress_0(this$static, filterAddress){
  this$static.filterAddress = filterAddress;
}

function $addFilterAffinityGroupId_0(this$static, filterAffinityGroupId){
  this$static.filterAffinityGroupId = filterAffinityGroupId;
}

function $addFilterComputePower(this$static, filterComputePower){
  this$static.filterComputePower = filterComputePower;
}

function $addFilterName_3(this$static, filterName){
  this$static.filterName = filterName;
}

function $addFilterPort_0(this$static, filterPort){
  this$static.filterPort = filterPort;
}

function $addFilterSecurePort(this$static, filterSecurePort){
  this$static.filterSecurePort = filterSecurePort;
}

function ServerCriteria_0(){
  Criteria_4.call(this);
  this.filterOverrides.put('operationMode', 'operationMode IN ( ? )');
  this.filterOverrides.put('affinityGroupId', 'affinityGroup.id = ?');
}

defineSeed(1158, 1066, makeCastMap([Q$Serializable, Q$Criteria, Q$ServerCriteria]), ServerCriteria_0);
_.getPersistentClass = function getPersistentClass_34(){
  return Lorg_rhq_core_domain_cloud_Server_2_classLit;
}
;
_.fetchAffinityGroup = false;
_.fetchAgents = false;
_.filterAddress = null;
_.filterAffinityGroupId = null;
_.filterComputePower = null;
_.filterName = null;
_.filterOperationMode = null;
_.filterPort = null;
_.filterSecurePort = null;
_.sortComputePower = null;
_.sortCtime = null;
_.sortName = null;
function serialize_232(streamWriter, instance){
  $writeBoolean(streamWriter, instance.fetchAffinityGroup);
  $writeBoolean(streamWriter, instance.fetchAgents);
  $writeString(streamWriter, instance.filterAddress);
  $writeObject(streamWriter, instance.filterAffinityGroupId);
  $writeObject(streamWriter, instance.filterComputePower);
  $writeString(streamWriter, instance.filterName);
  $writeObject(streamWriter, instance.filterOperationMode);
  $writeObject(streamWriter, instance.filterPort);
  $writeObject(streamWriter, instance.filterSecurePort);
  $writeObject(streamWriter, instance.sortComputePower);
  $writeObject(streamWriter, instance.sortCtime);
  $writeObject(streamWriter, instance.sortName);
  serialize_200(streamWriter, instance);
}

function $addFilterFsystem(this$static, filterFsystem){
  this$static.filterFsystem = filterFsystem;
}

function $addSortName_2(this$static, sortName){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(110)) + 'ame');
  this$static.sortName = sortName;
}

function $addSortNamespace(this$static, sortNamespace){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(110)) + 'amespace');
  this$static.sortNamespace = sortNamespace;
}

function $addSortSemantic(this$static, sortSemantic){
  $add_3(this$static.orderingFieldNames, 'sort' + charToString(toUpperCase(115)) + 'emantic');
  this$static.sortSemantic = sortSemantic;
}

function TagCriteria_0(){
  Criteria_4.call(this);
}

defineSeed(1162, 1066, makeCastMap([Q$Serializable, Q$Criteria]), TagCriteria_0);
_.getPersistentClass = function getPersistentClass_36(){
  return Lorg_rhq_core_domain_tagging_Tag_2_classLit;
}
;
_.filterName = null;
_.filterNamespace = null;
_.filterSemantic = null;
_.sortName = null;
_.sortNamespace = null;
_.sortSemantic = null;
function serialize_234(streamWriter, instance){
  $writeString(streamWriter, instance.filterName);
  $writeString(streamWriter, instance.filterNamespace);
  $writeString(streamWriter, instance.filterSemantic);
  $writeObject(streamWriter, instance.sortName);
  $writeObject(streamWriter, instance.sortNamespace);
  $writeObject(streamWriter, instance.sortSemantic);
  serialize_200(streamWriter, instance);
}

function $addPortlet(this$static, storedPortlet){
  var bestColumn, column, columnCounts, dashboardPortlet, dashboardPortlet$iterator, minPortlets;
  columnCounts = initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, valueOf_44(__parseAndValidateInt($getSimpleValue(this$static.configuration, 'columns', '1'))).value_0, 1);
  fill(columnCounts, columnCounts.length);
  for (dashboardPortlet$iterator = this$static.portlets.iterator(); dashboardPortlet$iterator.hasNext();) {
    dashboardPortlet = dynamicCast(dashboardPortlet$iterator.next_0(), Q$DashboardPortlet);
    ++columnCounts[dashboardPortlet.column];
  }
  bestColumn = -1;
  minPortlets = 2147483647;
  for (column = 0; column < columnCounts.length; ++column) {
    if (columnCounts[column] < minPortlets) {
      bestColumn = column;
      minPortlets = columnCounts[column];
    }
  }
  $addPortlet_0(this$static, storedPortlet, bestColumn, minPortlets);
}

function $addPortlet_0(this$static, storedPortlet, column, index){
  storedPortlet.column = column;
  storedPortlet.index_0 = index;
  storedPortlet.dashboard = this$static;
  this$static.portlets.add(storedPortlet);
}

function $getPortlets(this$static, column){
  var columnPortlets, p, p$iterator;
  columnPortlets = new ArrayList_0;
  for (p$iterator = this$static.portlets.iterator(); p$iterator.hasNext();) {
    p = dynamicCast(p$iterator.next_0(), Q$DashboardPortlet);
    p.column == column && (setCheck(columnPortlets.array, columnPortlets.size_0++, p) , true);
  }
  sort_1(columnPortlets, new Dashboard$1_0);
  return columnPortlets;
}

function $removePortlet(this$static, storedPortlet){
  var col, i, index, next;
  if (!this$static.portlets.contains_0(storedPortlet)) {
    return false;
  }
  col = storedPortlet.column;
  index = storedPortlet.index_0;
  this$static.portlets.remove_0(storedPortlet);
  for (i = this$static.portlets.iterator(); i.hasNext();) {
    next = dynamicCast(i.next_0(), Q$DashboardPortlet);
    col == next.column && index < next.index_0 && $setIndex(next, next.index_0 - 1);
  }
  return true;
}

function $setCategory_0(this$static, category){
  this$static.category = category;
}

function $setColumnWidths(this$static, columnWidths){
  var i, sb;
  if (null == columnWidths || columnWidths.length == 0) {
    return;
  }
  sb = new StringBuilder_0;
  $append_1(sb.data_0, columnWidths[0]);
  for (i = 1; i < columnWidths.length; ++i) {
    $append_1(sb.data_0, ',');
    $append_1(sb.data_0, columnWidths[i]);
  }
  $put_4(this$static.configuration, new PropertySimple_1('widths', sb));
}

function $setColumns(this$static, columns){
  $put_4(this$static.configuration, new PropertySimple_1('columns', valueOf_44(columns)));
}

function $setName_7(this$static, name_0){
  this$static.name_0 = name_0;
}

function $compare_4(o1, o2){
  return o1.index_0 < o2.index_0?-1:o1.index_0 == o2.index_0?0:1;
}

function Dashboard$1_0(){
}

defineSeed(1166, 1, makeCastMap([Q$Comparator]), Dashboard$1_0);
_.compare = function compare_6(o1, o2){
  return $compare_4(dynamicCast(o1, Q$DashboardPortlet), dynamicCast(o2, Q$DashboardPortlet));
}
;
function $setColumn(this$static, column){
  this$static.column = column;
}

function $setConfiguration_0(this$static, configuration){
  this$static.configuration = configuration;
}

function $setHeight_3(this$static, height){
  this$static.height = height;
}

function $setIndex(this$static, index){
  this$static.index_0 = index;
}

function DashboardPortlet_1(name_0, portletKey, height){
  $$init_12(this);
  this.name_0 = name_0;
  this.portletKey = portletKey;
  this.height = height;
}

defineSeed(1170, 1, makeCastMap([Q$Serializable, Q$DashboardPortlet]), DashboardPortlet_1);
defineSeed(1174, 1, makeCastMap([Q$Serializable]));
_.dataSize = null;
function $clinit_DriftCategory(){
  $clinit_DriftCategory = nullMethod;
  FILE_ADDED = new DriftCategory_0('FILE_ADDED', 0);
  FILE_CHANGED = new DriftCategory_0('FILE_CHANGED', 1);
  FILE_REMOVED = new DriftCategory_0('FILE_REMOVED', 2);
  $VALUES_80 = initValues(_3Lorg_rhq_core_domain_drift_DriftCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$DriftCategory_$1]), Q$DriftCategory, [FILE_ADDED, FILE_CHANGED, FILE_REMOVED]);
}

function DriftCategory_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_89(name_0){
  $clinit_DriftCategory();
  return valueOf(($clinit_DriftCategory$Map() , $MAP_80), name_0);
}

function values_83(){
  $clinit_DriftCategory();
  return $VALUES_80;
}

defineSeed(1176, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftCategory]), DriftCategory_0);
var $VALUES_80, FILE_ADDED, FILE_CHANGED, FILE_REMOVED;
function $clinit_DriftCategory$Map(){
  $clinit_DriftCategory$Map = nullMethod;
  $MAP_80 = createValueOfMap(($clinit_DriftCategory() , $VALUES_80));
}

var $MAP_80;
function serialize_240(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function deserialize_253(streamReader, instance){
}

function instantiate_246(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftCategory() , $clinit_DriftCategory() , $VALUES_80);
  return values[ordinal];
}

function serialize_241(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function $clinit_DriftChangeSetCategory(){
  $clinit_DriftChangeSetCategory = nullMethod;
  COVERAGE = new DriftChangeSetCategory_0('COVERAGE', 0);
  DRIFT_0 = new DriftChangeSetCategory_0('DRIFT', 1);
  $VALUES_81 = initValues(_3Lorg_rhq_core_domain_drift_DriftChangeSetCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DriftChangeSetCategory, [COVERAGE, DRIFT_0]);
}

function DriftChangeSetCategory_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_90(name_0){
  $clinit_DriftChangeSetCategory();
  return valueOf(($clinit_DriftChangeSetCategory$Map() , $MAP_81), name_0);
}

function values_84(){
  $clinit_DriftChangeSetCategory();
  return $VALUES_81;
}

defineSeed(1180, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftChangeSetCategory]), DriftChangeSetCategory_0);
var $VALUES_81, COVERAGE, DRIFT_0;
function $clinit_DriftChangeSetCategory$Map(){
  $clinit_DriftChangeSetCategory$Map = nullMethod;
  $MAP_81 = createValueOfMap(($clinit_DriftChangeSetCategory() , $VALUES_81));
}

var $MAP_81;
function deserialize_254(streamReader, instance){
}

function instantiate_247(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftChangeSetCategory() , $clinit_DriftChangeSetCategory() , $VALUES_81);
  return values[ordinal];
}

function serialize_242(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function fromCode(code){
  $clinit_DriftComplianceStatus();
  switch (code) {
    case 0:
      return IN_COMPLIANCE;
    case 1:
      return OUT_OF_COMPLIANCE_NO_BASEDIR;
    case 2:
      return OUT_OF_COMPLIANCE_DRIFT;
    default:throw new IllegalArgumentException_1(code + ' is not a DriftComplianceStatus code');
  }
}

function DriftComposite_0(){
}

defineSeed(1186, 1, makeCastMap([Q$Serializable, Q$DriftComposite]), DriftComposite_0);
_.drift = null;
_.driftDefName = null;
_.resource = null;
function deserialize_256(streamReader, instance){
  setDrift(instance, dynamicCast($readObject(streamReader), Q$Drift));
  setDriftDefName(instance, $getString(streamReader, $readInt(streamReader)));
  setResource_8(instance, dynamicCast($readObject(streamReader), Q$Resource));
}

function instantiate_249(streamReader){
  return new DriftComposite_0;
}

function setDrift(instance, value){
  instance.drift = value;
}

function setDriftDefName(instance, value){
  instance.driftDefName = value;
}

function setResource_8(instance, value){
  instance.resource = value;
}

function $clinit_DriftConfigurationDefinition(){
  $clinit_DriftConfigurationDefinition = nullMethod;
  DEFAULT_DRIFT_HANDLING_MODE = ($clinit_DriftConfigurationDefinition$DriftHandlingMode() , normal);
  INSTANCE_0 = new ConfigurationDefinition_1('GLOBAL_DRIFT_CONFIG_DEF', 'The drift detection definition');
  INSTANCE_FOR_EXISTING_CONFIGS = new ConfigurationDefinition_1('GLOBAL_DRIFT_CONFIG_DEF', 'The drift detection definition');
  NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE = new ConfigurationDefinition_1('NEW_RESOURCE_DRIFT_DEF_BY_PINNED_TEMPLATE', 'A new resource drift definition created from a pinned template');
  EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE = new ConfigurationDefinition_1('EXISTING_RESOURCE_DRIFT_DEF_BY_PINNED_TEMPLATE', 'An existing resource drift definition created from a pinned template');
  NEW_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('NEW_TEMPLATE_DRIFT_CONFIG_DEF', 'A new template drift definition');
  EXISTING_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('EXISTING_TEMPLATE_DRIFT_CONFIG_DEF', 'An existing template drift definition');
  NEW_PINNED_TEMPLATE_INSTANCE = new ConfigurationDefinition_1('NEW_PINNED_TEMPLATE_DRIFT_CONFIG_DEF', 'A new pinned template drift definition');
  $setConfigurationFormat(INSTANCE_0, ($clinit_ConfigurationFormat() , STRUCTURED));
  $put_6(INSTANCE_0, createName(INSTANCE_0, false));
  $put_6(INSTANCE_0, createDescription(INSTANCE_0));
  $put_6(INSTANCE_0, createEnabled(INSTANCE_0));
  $put_6(INSTANCE_0, createDriftHandlingMode(INSTANCE_0));
  $put_6(INSTANCE_0, createInterval_0(INSTANCE_0));
  $put_6(INSTANCE_0, createBasedir(INSTANCE_0, false));
  $put_6(INSTANCE_0, createIncludes(INSTANCE_0, false));
  $put_6(INSTANCE_0, createExcludes(INSTANCE_0, false));
  $put_6(INSTANCE_0, createPinned(INSTANCE_0, false));
  $put_6(INSTANCE_0, createAttached(INSTANCE_0, false));
  $setConfigurationFormat(INSTANCE_FOR_EXISTING_CONFIGS, STRUCTURED);
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createName(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createDescription(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createEnabled(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createDriftHandlingMode(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createInterval_0(INSTANCE_FOR_EXISTING_CONFIGS));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createBasedir(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createIncludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createExcludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createExcludes(INSTANCE_FOR_EXISTING_CONFIGS, true));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createAttached(INSTANCE_FOR_EXISTING_CONFIGS, false));
  $put_6(INSTANCE_FOR_EXISTING_CONFIGS, createPinned(INSTANCE_FOR_EXISTING_CONFIGS, false));
  $setConfigurationFormat(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, STRUCTURED);
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createName(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, false));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDescription(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createInterval_0(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createEnabled(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDriftHandlingMode(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createBasedir(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createIncludes(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createExcludes(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createPinned(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createAttached(NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $setConfigurationFormat(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, STRUCTURED);
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createName(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDescription(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createInterval_0(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createEnabled(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createDriftHandlingMode(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createBasedir(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createIncludes(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createExcludes(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createPinned(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $put_6(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, createAttached(EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, true));
  $setConfigurationFormat(NEW_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(NEW_TEMPLATE_INSTANCE, createName(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createDescription(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createInterval_0(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createEnabled(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createDriftHandlingMode(NEW_TEMPLATE_INSTANCE));
  $put_6(NEW_TEMPLATE_INSTANCE, createBasedir(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createIncludes(NEW_TEMPLATE_INSTANCE, false));
  $put_6(NEW_TEMPLATE_INSTANCE, createExcludes(NEW_TEMPLATE_INSTANCE, false));
  $setConfigurationFormat(EXISTING_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(EXISTING_TEMPLATE_INSTANCE, createName(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createDescription(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createInterval_0(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createEnabled(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createDriftHandlingMode(EXISTING_TEMPLATE_INSTANCE));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createBasedir(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createIncludes(EXISTING_TEMPLATE_INSTANCE, true));
  $put_6(EXISTING_TEMPLATE_INSTANCE, createExcludes(EXISTING_TEMPLATE_INSTANCE, true));
  $setConfigurationFormat(NEW_PINNED_TEMPLATE_INSTANCE, STRUCTURED);
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createName(NEW_PINNED_TEMPLATE_INSTANCE, false));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createDescription(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createInterval_0(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createEnabled(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createDriftHandlingMode(NEW_PINNED_TEMPLATE_INSTANCE));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createBasedir(NEW_PINNED_TEMPLATE_INSTANCE, true));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createIncludes(NEW_PINNED_TEMPLATE_INSTANCE, true));
  $put_6(NEW_PINNED_TEMPLATE_INSTANCE, createExcludes(NEW_PINNED_TEMPLATE_INSTANCE, true));
}

function createAttached(configDef, readOnly){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('attached', 'A flag that indicates whether or not the definition is attached to the template from which it is created. When a template is updated, the changes will be propagated to any attached definitions. Furthermore, if you pin an existing template to a snapshot, then attached definitions will become pinned as well. Finally, if you delete a template, attached definitions will also be deleted.', true, type);
  pd.displayName = 'Attached to Template';
  pd.defaultValue = 'true';
  pd.order = 3;
  pd.readOnly = readOnly;
  pd.configurationDefinition = configDef;
  return pd;
}

function createBasedir(configDef, readOnly){
  var pd, valueContext, valueName, type, pd_0, pcEnum, rcEnum, mtEnum, fsEnum, pdEnums, type_0, pd_1, constraint;
  valueContext = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('valueContext', 'Identifies where the named value can be found.', true, type) , pd_0.displayName = 'Value Context' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pcEnum = new PropertyDefinitionEnumeration_1(($clinit_DriftConfigurationDefinition$BaseDirValueContext() , pluginConfiguration_1).name_0, pluginConfiguration_1.name_0) , pcEnum.orderIndex = 0 , rcEnum = new PropertyDefinitionEnumeration_1(resourceConfiguration_1.name_0, resourceConfiguration_1.name_0) , rcEnum.orderIndex = 1 , mtEnum = new PropertyDefinitionEnumeration_1(measurementTrait_0.name_0, measurementTrait_0.name_0) , mtEnum.orderIndex = 2 , fsEnum = new PropertyDefinitionEnumeration_1(fileSystem_0.name_0, fileSystem_0.name_0) , fsEnum.orderIndex = 3 , pdEnums = new ArrayList_1(4) , setCheck(pdEnums.array, pdEnums.size_0++, pcEnum) , setCheck(pdEnums.array, pdEnums.size_0++, rcEnum) , setCheck(pdEnums.array, pdEnums.size_0++, mtEnum) , setCheck(pdEnums.array, pdEnums.size_0++, fsEnum) , $setEnumeratedValues(pd_0, pdEnums) , pd_0);
  valueName = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('valueName', 'The name of the value as found in the context.', true, type_0) , pd_1.displayName = 'Value Name' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , constraint = new RegexConstraint_0 , constraint.details = '[ \\.\\-\\(\\)\\w/\\:\\\\]+' , $addConstraints(pd_1, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint])) , pd_1);
  pd = new PropertyDefinitionMap_1('basedir', 'The root directory from which snapshots will be generated during drift monitoring.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [valueContext, valueName]));
  pd.displayName = 'Base Directory';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 7;
  pd.configurationDefinition = configDef;
  return pd;
}

function createDescription(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('description', 'A description of the drift detection definition or template', false, type);
  pd.displayName = 'Drift Definition Description';
  pd.summary = true;
  pd.order = 1;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  return pd;
}

function createDriftHandlingMode(configDef){
  var normalEnum, pd, pdEnums, plannedEnum, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('driftHandlingMode', "Specifies the way in which drift instances will be handled when reported. Normal handling implies the reported drift is unexpected and as such can trigger alerts, will be present in recent drift reports, etc.  Setting to 'Planned Changes' implies that the reported drift is happening at a time when drift is expected due to planned changes in the monitored environment, such as an application deployment, a configuration change, or something similar.  With this setting drift is only reported  for inspection, in drift snapshot views.", true, type);
  pd.displayName = 'Drift Handling Mode';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 4;
  pd.configurationDefinition = configDef;
  normalEnum = new PropertyDefinitionEnumeration_1(($clinit_DriftConfigurationDefinition$DriftHandlingMode() , normal).name_0, normal.name_0);
  normalEnum.orderIndex = 0;
  plannedEnum = new PropertyDefinitionEnumeration_1(plannedChanges.name_0, plannedChanges.name_0);
  plannedEnum.orderIndex = 1;
  pdEnums = new ArrayList_1(2);
  setCheck(pdEnums.array, pdEnums.size_0++, normalEnum);
  setCheck(pdEnums.array, pdEnums.size_0++, plannedEnum);
  $setEnumeratedValues(pd, pdEnums);
  $setDefaultValue_3(pd, DEFAULT_DRIFT_HANDLING_MODE.name_0);
  return pd;
}

function createEnabled(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('enabled', 'Enables or disables the drift definition', true, type);
  pd.displayName = 'Enabled';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 2;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  pd.defaultValue = 'true';
  return pd;
}

function createExcludes(configDef, readOnly){
  var map, pd, path, type, pd_0, pattern, type_0, pd_1, pd_2;
  map = (path = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('path', "A file system directory path that is relative to (a sub-directory of) the base directory of the drift definition. The default is '.', the base directory itself.  Note that '/' and './' will be normalized to '.' for consistent handling.", true, type) , pd_0.displayName = 'Path' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pd_0.allowCustomEnumeratedValue = false , pd_0) , pattern = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('pattern', 'Pathname pattern that must match for the items in the directory path to be excluded.', false, type_0) , pd_1.displayName = 'Pattern' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , pd_1) , pd_2 = new PropertyDefinitionMap_1('exclude', 'A pattern that specifies a file or directory to exclude.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [path, pattern])) , pd_2.displayName = 'Exclude' , pd_2.readOnly = readOnly , pd_2.summary = true , pd_2.order = 0 , pd_2);
  pd = new PropertyDefinitionList_1('excludes', 'A set of patterns that specify files and/or directories to exclude.', false, map);
  pd.displayName = 'Excludes';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 9;
  pd.configurationDefinition = configDef;
  return pd;
}

function createIncludes(configDef, readOnly){
  var map, pd, path, type, pd_0, constraint, pattern, type_0, pd_1, constraint_0, pd_2;
  map = (path = (type = ($clinit_PropertySimpleType() , STRING_0) , pd_0 = new PropertyDefinitionSimple_1('path', "A file system directory path that is relative to (a sub-directory of) the base directory of the drift definition. The default is '.', the base directory itself.  Note that '/' and './' will be normalized to '.' for consistent handling.", false, type) , pd_0.displayName = 'Path' , pd_0.readOnly = readOnly , pd_0.summary = true , pd_0.order = 0 , pd_0.allowCustomEnumeratedValue = false , pd_0.defaultValue = '.' , constraint = new RegexConstraint_0 , constraint.details = '[ \\.\\-\\(\\)\\w/\\\\]+' , $addConstraints(pd_0, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint])) , pd_0) , pattern = (type_0 = STRING_0 , pd_1 = new PropertyDefinitionSimple_1('pattern', "Pathname pattern that must match for the items in the directory path to be included. '*' matches zero or more characters, '?' matches one character. For example, '*.txt' (no quotes) will match text files in the filter's path directory.  '**/*.txt' will match text files in any subdirectory below the filter's path directory.", false, type_0) , pd_1.displayName = 'Pattern' , pd_1.readOnly = readOnly , pd_1.summary = true , pd_1.order = 1 , pd_1.allowCustomEnumeratedValue = false , constraint_0 = new RegexConstraint_0 , constraint_0.details = '[ \\.\\-\\(\\)\\w/\\\\\\?\\*]+' , $addConstraints(pd_1, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint_0])) , pd_1) , pd_2 = new PropertyDefinitionMap_1('include', 'A pattern that specifies a file or directory to include.', true, initValues(_3Lorg_rhq_core_domain_configuration_definition_PropertyDefinition_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PropertyDefinition, [path, pattern])) , pd_2.displayName = 'Include' , pd_2.readOnly = readOnly , pd_2.summary = true , pd_2.order = 0 , pd_2);
  pd = new PropertyDefinitionList_1('includes', 'A set of patterns that specify files and/or directories to include.', false, map);
  pd.displayName = 'Includes';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 8;
  pd.configurationDefinition = configDef;
  return pd;
}

function createInterval_0(configDef){
  var pd, type;
  type = ($clinit_PropertySimpleType() , LONG_0);
  pd = new PropertyDefinitionSimple_1('interval', 'The frequency in seconds in which drift detection should run. Defaults to 1800 seconds (i.e. 30 minutes)', false, type);
  pd.displayName = 'Interval';
  pd.readOnly = false;
  pd.summary = true;
  pd.order = 6;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  pd.defaultValue = '1800';
  return pd;
}

function createName(configDef, readOnly){
  var constraint, pd, type;
  type = ($clinit_PropertySimpleType() , STRING_0);
  pd = new PropertyDefinitionSimple_1('name', 'The drift detection definition name', true, type);
  pd.displayName = 'Drift Definition Name';
  pd.readOnly = readOnly;
  pd.summary = true;
  pd.order = 0;
  pd.allowCustomEnumeratedValue = false;
  pd.configurationDefinition = configDef;
  constraint = new RegexConstraint_0;
  constraint.details = '[ \\.\\-\\w]+';
  $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [constraint]));
  return pd;
}

function createPinned(configDef, readOnly){
  var pd, type;
  type = ($clinit_PropertySimpleType() , BOOLEAN_2);
  pd = new PropertyDefinitionSimple_1('pinned', 'If set, pins the snapshot that the agent uses for comparing files during drift detection. Normally, the agent compares those files being monitored for drift against the latest snapshot. If you pin a snapshot, the agent will use that pinned version to compare against files being monitored for drift', true, type);
  pd.displayName = 'Pinned';
  pd.defaultValue = 'false';
  pd.order = 5;
  pd.readOnly = readOnly;
  pd.configurationDefinition = configDef;
  return pd;
}

var DEFAULT_DRIFT_HANDLING_MODE, EXISTING_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, EXISTING_TEMPLATE_INSTANCE, INSTANCE_0, INSTANCE_FOR_EXISTING_CONFIGS, NEW_PINNED_TEMPLATE_INSTANCE, NEW_RESOURCE_INSTANCE_BY_PINNED_TEMPLATE, NEW_TEMPLATE_INSTANCE;
function serialize_244(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function $addExclude(this$static, filter){
  var filterMap, filtersList;
  filtersList = $getList(this$static.configuration, 'excludes');
  if (!filtersList) {
    filtersList = new PropertyList_1('excludes');
    $put_4(this$static.configuration, filtersList);
  }
  filterMap = new PropertyMap_1('exclude');
  $put_5(filterMap, new PropertySimple_1('path', useForwardSlash(filter.path)));
  $put_5(filterMap, new PropertySimple_1('pattern', filter.pattern));
  $add_10(filtersList, filterMap);
}

function $addInclude(this$static, filter){
  var filterMap, filtersList;
  filtersList = $getList(this$static.configuration, 'includes');
  if (!filtersList) {
    filtersList = new PropertyList_1('includes');
    $put_4(this$static.configuration, filtersList);
  }
  filterMap = new PropertyMap_1('include');
  $put_5(filterMap, new PropertySimple_1('path', useForwardSlash(filter.path)));
  $put_5(filterMap, new PropertySimple_1('pattern', filter.pattern));
  $add_10(filtersList, filterMap);
}

function $setAttached(this$static, attached){
  this$static.attached = attached.value_0;
  $setAttachedProperty(this$static, attached.value_0);
}

function $setAttachedProperty(this$static, attached){
  $put_4(this$static.configuration, new PropertySimple_1('attached', '' + attached));
}

function $setBasedir(this$static, basedir){
  var basedirMap, valueContext, valueName;
  if (!basedir) {
    throw new NullPointerException_1('basedir is null');
  }
  if (!basedir.context) {
    throw new NullPointerException_1('valueContext is null');
  }
  if (basedir.name_0 == null) {
    throw new NullPointerException_1('valueName is null');
  }
  valueContext = basedir.context.name_0;
  valueName = basedir.name_0;
  basedirMap = new PropertyMap_1('basedir');
  $put_5(basedirMap, new PropertySimple_1('valueContext', valueContext));
  $put_5(basedirMap, new PropertySimple_1('valueName', ($clinit_StringUtils() , null != valueName?$replace_0(valueName, 92, 47):null)));
  $put_4(this$static.configuration, basedirMap);
}

function $setExcludes(this$static, excludesFilters){
  var filter, filter$iterator;
  $remove_16(this$static.configuration, 'excludes');
  if (excludesFilters) {
    for (filter$iterator = excludesFilters.iterator(); filter$iterator.hasNext();) {
      filter = dynamicCast(filter$iterator.next_0(), Q$Filter);
      $addExclude(this$static, filter);
    }
  }
}

function $setIncludes(this$static, includesFilters){
  var filter, filter$iterator;
  $remove_16(this$static.configuration, 'includes');
  if (includesFilters) {
    for (filter$iterator = includesFilters.iterator(); filter$iterator.hasNext();) {
      filter = dynamicCast(filter$iterator.next_0(), Q$Filter);
      $addInclude(this$static, filter);
    }
  }
}

function $setPinned(this$static, isPinned){
  this$static.isPinned = isPinned;
  $put_4(this$static.configuration, new PropertySimple_1('pinned', ($clinit_Boolean() , isPinned?TRUE:FALSE)));
}

function $setTemplate(this$static, template){
  this$static.template = template;
}

function DriftDefinition_1(c){
  var baseDir;
  $$init_13(this);
  this.configuration = c;
  baseDir = $getBasedir(this);
  !!baseDir && $setBasedir(this, baseDir);
  $setIncludes(this, $getFilters(this, 'includes'));
  $setExcludes(this, $getFilters(this, 'excludes'));
  this.name_0 = $getSimpleValue(this.configuration, 'name', null);
  this.description = $getSimpleValue(this.configuration, 'description', null);
  this.isEnabled = $equals_6($getSimpleValue(this.configuration, 'enabled', 'true'), 'true');
  this.interval = valueOf_45(__parseAndValidateLong($getSimpleValue(this.configuration, 'interval', '1800'))).value_0;
  this.driftHandlingMode = valueOf_93($getSimpleValue(this.configuration, 'driftHandlingMode', ($clinit_DriftConfigurationDefinition() , DEFAULT_DRIFT_HANDLING_MODE).name_0));
  this.isPinned = ($clinit_Boolean() , $equalsIgnoreCase('true', $getSimpleValue(this.configuration, 'pinned', 'false'))?TRUE:FALSE).value_0;
  this.attached = $equals_6($getSimpleValue(this.configuration, 'attached', 'true'), 'true');
}

defineSeed(1195, 1, makeCastMap([Q$Serializable, Q$DriftDefinition]), DriftDefinition_1);
function $compare_5(this$static, dc1, dc2){
  var filters1, filters2, hash1, hash2, results;
  if (this$static.compareMode != 1) {
    if (dc1.name_0 != null) {
      if (dc2.name_0 != null) {
        results = compareTo_11(dc1.name_0, dc2.name_0);
        if (results != 0) {
          return results;
        }
      }
       else {
        return 1;
      }
    }
     else if (dc2.name_0 != null) {
      return -1;
    }
    if (dc1.description != null) {
      if (dc2.description != null) {
        results = compareTo_11(dc1.description, dc2.description);
        if (results != 0) {
          return results;
        }
      }
       else {
        return 1;
      }
    }
     else if (dc2.description != null) {
      return -1;
    }
    if (neq(dc1.interval, dc2.interval)) {
      return lt(dc1.interval, dc2.interval)?-1:1;
    }
    if (dc1.driftHandlingMode != dc2.driftHandlingMode) {
      return dc1.driftHandlingMode.ordinal < dc2.driftHandlingMode.ordinal?-1:1;
    }
    if (dc1.isEnabled != dc2.isEnabled) {
      return dc1.isEnabled?1:-1;
    }
    if (dc1.attached != dc2.attached) {
      return dc1.attached?1:-1;
    }
    if (dc1.isPinned != dc2.isPinned) {
      return dc1.isPinned?1:-1;
    }
  }
  if (this$static.compareMode != 0) {
    if ($getBasedir(dc1)) {
      if (!$equals_32($getBasedir(dc1), $getBasedir(dc2))) {
        hash1 = $hashCode_20($getBasedir(dc1));
        hash2 = $getBasedir(dc2)?$hashCode_20($getBasedir(dc2)):0;
        return hash1 < hash2?-1:1;
      }
    }
     else if ($getBasedir(dc2)) {
      return -1;
    }
    filters1 = $getFilters(dc1, 'includes');
    filters2 = $getFilters(dc2, 'includes');
    results = $compareFilters(filters1, filters2);
    if (results != 0) {
      return results;
    }
    filters1 = $getFilters(dc1, 'excludes');
    filters2 = $getFilters(dc2, 'excludes');
    results = $compareFilters(filters1, filters2);
    if (results != 0) {
      return results;
    }
  }
  return 0;
}

function $compareFilters(filters1, filters2){
  if (!filters1) {
    return !filters2?0:-1;
  }
   else if (!filters2) {
    return 1;
  }
  if (filters1.size_1() != filters2.size_1()) {
    return filters1.size_1() < filters2.size_1()?-1:1;
  }
  if (!filters1.containsAll(filters2)) {
    return -1;
  }
  return 0;
}

function DriftDefinitionComparator_0(){
  this.compareMode = 1;
}

defineSeed(1197, 1, makeCastMap([Q$Comparator]), DriftDefinitionComparator_0);
_.compare = function compare_7(dc1, dc2){
  return $compare_5(this, dynamicCast(dc1, Q$DriftDefinition), dynamicCast(dc2, Q$DriftDefinition));
}
;
_.compareMode = 0;
function DriftDefinitionComposite_0(){
}

defineSeed(1198, 1, makeCastMap([Q$Serializable, Q$DriftDefinitionComposite]), DriftDefinitionComposite_0);
_.driftDefinition = null;
_.mostRecentChangeset = null;
function deserialize_258(streamReader, instance){
  setDriftDefinition(instance, dynamicCast($readObject(streamReader), Q$DriftDefinition));
  setMostRecentChangeset(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSet));
}

function instantiate_251(streamReader){
  return new DriftDefinitionComposite_0;
}

function setDriftDefinition(instance, value){
  instance.driftDefinition = value;
}

function setMostRecentChangeset(instance, value){
  instance.mostRecentChangeset = value;
}

function $setTemplateDefinition(this$static, templateDefinition){
  this$static.configuration = $deepCopyWithoutProxies(templateDefinition.configuration);
  this$static.name_0 = templateDefinition.name_0;
  this$static.description = templateDefinition.description;
}

function DriftDetails_0(){
}

defineSeed(1203, 1, makeCastMap([Q$Serializable, Q$DriftDetails]), DriftDetails_0);
_.drift = null;
_.isBinary = false;
_.newFileStatus = null;
_.oldFileStatus = null;
_.previousChangeSet = null;
function deserialize_261(streamReader, instance){
  setDrift_0(instance, dynamicCast($readObject(streamReader), Q$Drift));
  setIsBinary(instance, $readBoolean(streamReader));
  setNewFileStatus(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
  setOldFileStatus(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
  setPreviousChangeSet(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSet));
}

function instantiate_254(streamReader){
  return new DriftDetails_0;
}

function setDrift_0(instance, value){
  instance.drift = value;
}

function setIsBinary(instance, value){
  instance.isBinary = value;
}

function setNewFileStatus(instance, value){
  instance.newFileStatus = value;
}

function setOldFileStatus(instance, value){
  instance.oldFileStatus = value;
}

function setPreviousChangeSet(instance, value){
  instance.previousChangeSet = value;
}

function $clinit_DriftFileStatus(){
  $clinit_DriftFileStatus = nullMethod;
  EMPTY = new DriftFileStatus_0('EMPTY', 0);
  REQUESTED_0 = new DriftFileStatus_0('REQUESTED', 1);
  LOADED = new DriftFileStatus_0('LOADED', 2);
  $VALUES_85 = initValues(_3Lorg_rhq_core_domain_drift_DriftFileStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$DriftFileStatus, [EMPTY, REQUESTED_0, LOADED]);
}

function DriftFileStatus_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_94(name_0){
  $clinit_DriftFileStatus();
  return valueOf(($clinit_DriftFileStatus$Map() , $MAP_85), name_0);
}

function values_88(){
  $clinit_DriftFileStatus();
  return $VALUES_85;
}

defineSeed(1205, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$DriftFileStatus]), DriftFileStatus_0);
var $VALUES_85, EMPTY, LOADED, REQUESTED_0;
function $clinit_DriftFileStatus$Map(){
  $clinit_DriftFileStatus$Map = nullMethod;
  $MAP_85 = createValueOfMap(($clinit_DriftFileStatus() , $VALUES_85));
}

var $MAP_85;
function deserialize_262(streamReader, instance){
}

function instantiate_255(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_DriftFileStatus() , $clinit_DriftFileStatus() , $VALUES_85);
  return values[ordinal];
}

function serialize_248(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function $getDriftDirectories(this$static){
  if (!this$static.directoryMap) {
    return null;
  }
  return this$static.directoryMap.values_0();
}

function $getDriftInstances(this$static){
  if (!this$static.driftMap) {
    return null;
  }
  return this$static.driftMap.values_0();
}

function DriftSnapshot_0(){
}

defineSeed(1208, 1, makeCastMap([Q$Serializable, Q$DriftSnapshot]), DriftSnapshot_0);
_.directoryMap = null;
_.driftMap = null;
_.request = null;
_.version_0 = -1;
function DriftSnapshot$DriftSnapshotDirectory_0(){
}

defineSeed(1209, 1, makeCastMap([Q$Serializable, Q$DriftSnapshot$DriftSnapshotDirectory]), DriftSnapshot$DriftSnapshotDirectory_0);
_.added = 0;
_.changed_0 = 0;
_.directoryPath = null;
_.files = 0;
_.removed = 0;
function DriftSnapshotRequest_0(){
}

function DriftSnapshotRequest_1(driftDefinitionId, version, directory, includeDriftDirectories, includeDriftInstances){
  this.driftDefinitionId = valueOf_44(driftDefinitionId);
  this.version_0 = !!version && version.value_0 >= 0?version:null;
  this.startVersion = valueOf_44(0);
  if (null != directory) {
    directory = $trim(directory);
    this.directory = $equals_6('', directory)?'./':directory;
  }
  this.includeDriftDirectories = includeDriftDirectories;
  this.includeDriftInstances = includeDriftInstances;
}

function DriftSnapshotRequest_2(templateChangesetIdString, directory, includeDriftDirectories, includeDriftInstances){
  this.templateChangeSetId = templateChangesetIdString;
  if (null != directory) {
    directory = $trim(directory);
    this.directory = $equals_6('', directory)?'./':directory;
  }
  this.includeDriftDirectories = includeDriftDirectories;
  this.includeDriftInstances = includeDriftInstances;
  this.driftDefinitionId = null;
  this.version_0 = valueOf_44(0);
  this.startVersion = valueOf_44(0);
}

defineSeed(1210, 1, makeCastMap([Q$Serializable, Q$DriftSnapshotRequest]), DriftSnapshotRequest_0, DriftSnapshotRequest_1, DriftSnapshotRequest_2);
_.toString$ = function toString_115(){
  return 'DriftSnapshotRequest [directory=' + this.directory + ', driftDefinitionId=' + this.driftDefinitionId + ', includeDriftDirectories=' + this.includeDriftDirectories + ', includeDriftInstances=' + this.includeDriftInstances + ', startVersion=' + this.startVersion + ', templateChangeSetId=' + this.templateChangeSetId + ', version=' + this.version_0 + ']';
}
;
_.directory = null;
_.driftDefinitionId = null;
_.includeDriftDirectories = false;
_.includeDriftInstances = false;
_.startVersion = null;
_.templateChangeSetId = null;
_.version_0 = null;
function deserialize_263(streamReader, instance){
  setDirectory(instance, $getString(streamReader, $readInt(streamReader)));
  setDriftDefinitionId(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setIncludeDriftDirectories(instance, $readBoolean(streamReader));
  setIncludeDriftInstances(instance, $readBoolean(streamReader));
  setStartVersion(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setTemplateChangeSetId(instance, $getString(streamReader, $readInt(streamReader)));
  setVersion_4(instance, dynamicCast($readObject(streamReader), Q$Integer));
}

function instantiate_256(streamReader){
  return new DriftSnapshotRequest_0;
}

function serialize_249(streamWriter, instance){
  $writeString(streamWriter, instance.directory);
  $writeObject(streamWriter, instance.driftDefinitionId);
  $writeBoolean(streamWriter, instance.includeDriftDirectories);
  $writeBoolean(streamWriter, instance.includeDriftInstances);
  $writeObject(streamWriter, instance.startVersion);
  $writeString(streamWriter, instance.templateChangeSetId);
  $writeObject(streamWriter, instance.version_0);
}

function setDirectory(instance, value){
  instance.directory = value;
}

function setDriftDefinitionId(instance, value){
  instance.driftDefinitionId = value;
}

function setIncludeDriftDirectories(instance, value){
  instance.includeDriftDirectories = value;
}

function setIncludeDriftInstances(instance, value){
  instance.includeDriftInstances = value;
}

function setStartVersion(instance, value){
  instance.startVersion = value;
}

function setTemplateChangeSetId(instance, value){
  instance.templateChangeSetId = value;
}

function setVersion_4(instance, value){
  instance.version_0 = value;
}

function deserialize_264(streamReader, instance){
  setAdded(instance, $readInt(streamReader));
  setChanged(instance, $readInt(streamReader));
  setDirectoryPath(instance, $getString(streamReader, $readInt(streamReader)));
  setFiles(instance, $readInt(streamReader));
  setRemoved(instance, $readInt(streamReader));
}

function instantiate_257(streamReader){
  return new DriftSnapshot$DriftSnapshotDirectory_0;
}

function setAdded(instance, value){
  instance.added = value;
}

function setChanged(instance, value){
  instance.changed_0 = value;
}

function setDirectoryPath(instance, value){
  instance.directoryPath = value;
}

function setFiles(instance, value){
  instance.files = value;
}

function setRemoved(instance, value){
  instance.removed = value;
}

function deserialize_265(streamReader, instance){
  setDirectoryMap(instance, dynamicCast($readObject(streamReader), Q$Map));
  setDriftMap(instance, dynamicCast($readObject(streamReader), Q$Map));
  setRequest(instance, dynamicCast($readObject(streamReader), Q$DriftSnapshotRequest));
  setVersion_5(instance, $readInt(streamReader));
}

function instantiate_258(streamReader){
  return new DriftSnapshot_0;
}

function setDirectoryMap(instance, value){
  instance.directoryMap = value;
}

function setDriftMap(instance, value){
  instance.driftMap = value;
}

function setRequest(instance, value){
  instance.request = value;
}

function setVersion_5(instance, value){
  instance.version_0 = value;
}

function FileDiffReport_0(){
}

defineSeed(1214, 1, makeCastMap([Q$Serializable, Q$FileDiffReport]), FileDiffReport_0);
_.changes = 0;
_.diff = null;
function deserialize_266(streamReader, instance){
  setChanges(instance, $readInt(streamReader));
  instance.diff = dynamicCast($readObject(streamReader), Q$List);
}

function instantiate_259(streamReader){
  return new FileDiffReport_0;
}

function setChanges(instance, value){
  instance.changes = value;
}

function JPADrift_0(){
  this.ctime = valueOf_45(N1_longLit);
}

defineSeed(1217, 1, makeCastMap([Q$Serializable, Q$Drift]), JPADrift_0);
_.getCategory = function getCategory(){
  return this.category;
}
;
_.getChangeSet = function getChangeSet(){
  return this.changeSet;
}
;
_.getCtime = function getCtime(){
  return this.ctime;
}
;
_.getId = function getId(){
  return '' + this.id;
}
;
_.getNewDriftFile = function getNewDriftFile(){
  return this.newDriftFile;
}
;
_.getOldDriftFile = function getOldDriftFile(){
  return this.oldDriftFile;
}
;
_.getPath = function getPath(){
  return this.path;
}
;
_.toString$ = function toString_117(){
  var $e0, sb;
  sb = new StringBuilder_1('JPADrift [');
  $append_12($append_12($append_12(sb, 'id=' + this.id), ', category=' + this.category), ', path=' + this.path);
  try {
    $append_12(sb, ', changeSet=' + this.changeSet);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (!instanceOf($e0, Q$Exception))
      throw $e0;
  }
  $append_1(sb.data_0, ']');
  return $toString_1(sb.data_0);
}
;
_.category = null;
_.changeSet = null;
_.directory = null;
_.id = 0;
_.newDriftFile = null;
_.oldDriftFile = null;
_.path = null;
function JPADriftChangeSet_0(){
  this.ctime = valueOf_45(N1_longLit);
  this.drifts = new LinkedHashSet_0;
}

defineSeed(1218, 1, makeCastMap([Q$Serializable, Q$DriftChangeSet, Q$JPADriftChangeSet]), JPADriftChangeSet_0);
_.getCategory_0 = function getCategory_0(){
  return this.category;
}
;
_.getCtime = function getCtime_0(){
  return this.ctime;
}
;
_.getDriftDefinitionId = function getDriftDefinitionId(){
  if (!this.driftDefinition) {
    return 0;
  }
  return this.driftDefinition.id;
}
;
_.getDriftHandlingMode = function getDriftHandlingMode(){
  return this.driftHandlingMode;
}
;
_.getId = function getId_0(){
  return '' + this.id;
}
;
_.getVersion = function getVersion(){
  return this.version_0;
}
;
_.toString$ = function toString_118(){
  return 'JPADriftChangeSet [id=' + this.id + ', resource=' + this.resource + ', version=' + this.version_0 + ']';
}
;
_.category = null;
_.driftDefinition = null;
_.driftHandlingMode = null;
_.id = 0;
_.initialDriftSet = null;
_.resource = null;
_.version_0 = 0;
function deserialize_267(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCategory_4(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetCategory));
  setCtime_14(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDriftDefinition_0(instance, dynamicCast($readObject(streamReader), Q$DriftDefinition));
  setDriftHandlingMode_0(instance, dynamicCast($readObject(streamReader), Q$DriftConfigurationDefinition$DriftHandlingMode));
  setDrifts(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_62(instance, $readInt(streamReader));
  setInitialDriftSet(instance, dynamicCast($readObject(streamReader), Q$JPADriftSet));
  setResource_10(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setVersion_6(instance, $readInt(streamReader));
}

function instantiate_260(streamReader){
  return new JPADriftChangeSet_0;
}

function serialize_250(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.ctime);
  $writeObject(streamWriter, instance.driftDefinition);
  $writeObject(streamWriter, instance.driftHandlingMode);
  $writeObject(streamWriter, instance.drifts);
  $writeInt(streamWriter, instance.id);
  $writeObject(streamWriter, instance.initialDriftSet);
  $writeObject(streamWriter, instance.resource);
  $writeInt(streamWriter, instance.version_0);
}

function setCategory_4(instance, value){
  instance.category = value;
}

function setCtime_14(instance, value){
  instance.ctime = value;
}

function setDriftDefinition_0(instance, value){
  instance.driftDefinition = value;
}

function setDriftHandlingMode_0(instance, value){
  instance.driftHandlingMode = value;
}

function setDrifts(instance, value){
  instance.drifts = value;
}

function setId_62(instance, value){
  instance.id = value;
}

function setInitialDriftSet(instance, value){
  instance.initialDriftSet = value;
}

function setResource_10(instance, value){
  instance.resource = value;
}

function setVersion_6(instance, value){
  instance.version_0 = value;
}

function JPADriftFile_0(){
  this.ctime = valueOf_45(N1_longLit);
  this.status_0 = ($clinit_DriftFileStatus() , EMPTY);
}

defineSeed(1220, 1174, makeCastMap([Q$Serializable, Q$JPADriftFile]), JPADriftFile_0);
_.getHashId = function getHashId(){
  return this.hashId;
}
;
_.toString$ = function toString_119(){
  return 'JPADriftFile [hashId=' + this.hashId + ', status=' + this.status_0 + ']';
}
;
_.hashId = null;
function deserialize_268(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setHashId(instance, $getString(streamReader, $readInt(streamReader)));
  instance.ctime = dynamicCast($readObject(streamReader), Q$Long);
  instance.dataSize = dynamicCast($readObject(streamReader), Q$Long);
  instance.status_0 = dynamicCast($readObject(streamReader), Q$DriftFileStatus);
}

function instantiate_261(streamReader){
  return new JPADriftFile_0;
}

function serialize_251(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-2'), Q$String));
  $writeString(streamWriter, instance.hashId);
  $writeObject(streamWriter, instance.ctime);
  $writeObject(streamWriter, instance.dataSize);
  $writeObject(streamWriter, instance.status_0);
}

function setHashId(instance, value){
  instance.hashId = value;
}

function JPADriftSet_0(){
  this.drifts = new LinkedHashSet_0;
}

defineSeed(1222, 1, makeCastMap([Q$Serializable, Q$JPADriftSet]), JPADriftSet_0);
_.id = 0;
function deserialize_269(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setDrifts_0(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_63(instance, $readInt(streamReader));
}

function instantiate_262(streamReader){
  return new JPADriftSet_0;
}

function serialize_252(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.drifts);
  $writeInt(streamWriter, instance.id);
}

function setDrifts_0(instance, value){
  instance.drifts = value;
}

function setId_63(instance, value){
  instance.id = value;
}

function deserialize_270(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setCategory_5(instance, dynamicCast($readObject(streamReader), Q$DriftCategory));
  setChangeSet(instance, dynamicCast($readObject(streamReader), Q$JPADriftChangeSet));
  setCtime_15(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDirectory_0(instance, $getString(streamReader, $readInt(streamReader)));
  setId_64(instance, $readInt(streamReader));
  setNewDriftFile(instance, dynamicCast($readObject(streamReader), Q$JPADriftFile));
  setOldDriftFile(instance, dynamicCast($readObject(streamReader), Q$JPADriftFile));
  setPath_0(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_263(streamReader){
  return new JPADrift_0;
}

function serialize_253(streamWriter, instance){
  $writeString(streamWriter, dynamicCast(get(instance, 'server-enhanced-data-1'), Q$String));
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.changeSet);
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.directory);
  $writeInt(streamWriter, instance.id);
  $writeObject(streamWriter, instance.newDriftFile);
  $writeObject(streamWriter, instance.oldDriftFile);
  $writeString(streamWriter, instance.path);
}

function setCategory_5(instance, value){
  instance.category = value;
}

function setChangeSet(instance, value){
  instance.changeSet = value;
}

function setCtime_15(instance, value){
  instance.ctime = value;
}

function setDirectory_0(instance, value){
  instance.directory = value;
}

function setId_64(instance, value){
  instance.id = value;
}

function setNewDriftFile(instance, value){
  instance.newDriftFile = value;
}

function setOldDriftFile(instance, value){
  instance.oldDriftFile = value;
}

function setPath_0(instance, value){
  instance.path = value;
}

function DriftChangeSetDTO_0(){
  this.drifts = new HashSet_0;
}

defineSeed(1225, 1, makeCastMap([Q$Serializable, Q$DriftChangeSet, Q$DriftChangeSetDTO]), DriftChangeSetDTO_0);
_.getCategory_0 = function getCategory_1(){
  return this.category;
}
;
_.getCtime = function getCtime_1(){
  return this.ctime;
}
;
_.getDriftDefinitionId = function getDriftDefinitionId_0(){
  return this.driftDefId;
}
;
_.getDriftHandlingMode = function getDriftHandlingMode_0(){
  return this.driftHandlingMode;
}
;
_.getId = function getId_1(){
  return this.id;
}
;
_.getVersion = function getVersion_0(){
  return this.version_0;
}
;
_.category = null;
_.ctime = null;
_.driftDefId = 0;
_.driftHandlingMode = null;
_.id = null;
_.resourceId = 0;
_.version_0 = 0;
function deserialize_271(streamReader, instance){
  setCategory_6(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetCategory));
  setCtime_16(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDriftDefId(instance, $readInt(streamReader));
  setDriftHandlingMode_1(instance, dynamicCast($readObject(streamReader), Q$DriftConfigurationDefinition$DriftHandlingMode));
  setDrifts_1(instance, dynamicCast($readObject(streamReader), Q$Set));
  setId_65(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId(instance, $readInt(streamReader));
  setVersion_7(instance, $readInt(streamReader));
}

function instantiate_264(streamReader){
  return new DriftChangeSetDTO_0;
}

function serialize_254(streamWriter, instance){
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.ctime);
  $writeInt(streamWriter, instance.driftDefId);
  $writeObject(streamWriter, instance.driftHandlingMode);
  $writeObject(streamWriter, instance.drifts);
  $writeString(streamWriter, instance.id);
  $writeInt(streamWriter, instance.resourceId);
  $writeInt(streamWriter, instance.version_0);
}

function setCategory_6(instance, value){
  instance.category = value;
}

function setCtime_16(instance, value){
  instance.ctime = value;
}

function setDriftDefId(instance, value){
  instance.driftDefId = value;
}

function setDriftHandlingMode_1(instance, value){
  instance.driftHandlingMode = value;
}

function setDrifts_1(instance, value){
  instance.drifts = value;
}

function setId_65(instance, value){
  instance.id = value;
}

function setResourceId(instance, value){
  instance.resourceId = value;
}

function setVersion_7(instance, value){
  instance.version_0 = value;
}

function DriftDTO_0(){
}

defineSeed(1227, 1, makeCastMap([Q$Serializable, Q$Drift]), DriftDTO_0);
_.getCategory = function getCategory_2(){
  return this.category;
}
;
_.getChangeSet = function getChangeSet_0(){
  return this.changeSet;
}
;
_.getCtime = function getCtime_2(){
  return this.ctime;
}
;
_.getId = function getId_2(){
  return this.id;
}
;
_.getNewDriftFile = function getNewDriftFile_0(){
  return this.newDriftFile;
}
;
_.getOldDriftFile = function getOldDriftFile_0(){
  return this.oldDriftFile;
}
;
_.getPath = function getPath_0(){
  return this.path;
}
;
_.category = null;
_.changeSet = null;
_.ctime = null;
_.directory = null;
_.id = null;
_.newDriftFile = null;
_.oldDriftFile = null;
_.path = null;
function deserialize_272(streamReader, instance){
  setCategory_7(instance, dynamicCast($readObject(streamReader), Q$DriftCategory));
  setChangeSet_0(instance, dynamicCast($readObject(streamReader), Q$DriftChangeSetDTO));
  setCtime_17(instance, dynamicCast($readObject(streamReader), Q$Long));
  setDirectory_1(instance, $getString(streamReader, $readInt(streamReader)));
  setId_66(instance, $getString(streamReader, $readInt(streamReader)));
  setNewDriftFile_0(instance, dynamicCast($readObject(streamReader), Q$DriftFileDTO));
  setOldDriftFile_0(instance, dynamicCast($readObject(streamReader), Q$DriftFileDTO));
  setPath_1(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_265(streamReader){
  return new DriftDTO_0;
}

function serialize_255(streamWriter, instance){
  $writeObject(streamWriter, instance.category);
  $writeObject(streamWriter, instance.changeSet);
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.directory);
  $writeString(streamWriter, instance.id);
  $writeObject(streamWriter, instance.newDriftFile);
  $writeObject(streamWriter, instance.oldDriftFile);
  $writeString(streamWriter, instance.path);
}

function setCategory_7(instance, value){
  instance.category = value;
}

function setChangeSet_0(instance, value){
  instance.changeSet = value;
}

function setCtime_17(instance, value){
  instance.ctime = value;
}

function setDirectory_1(instance, value){
  instance.directory = value;
}

function setId_66(instance, value){
  instance.id = value;
}

function setNewDriftFile_0(instance, value){
  instance.newDriftFile = value;
}

function setOldDriftFile_0(instance, value){
  instance.oldDriftFile = value;
}

function setPath_1(instance, value){
  instance.path = value;
}

function DriftFileDTO_0(){
}

defineSeed(1229, 1, makeCastMap([Q$Serializable, Q$DriftFileDTO]), DriftFileDTO_0);
_.getHashId = function getHashId_0(){
  return this.hash_0;
}
;
_.ctime = null;
_.hash_0 = null;
_.size_0 = null;
_.status_0 = null;
function deserialize_273(streamReader, instance){
  setCtime_18(instance, dynamicCast($readObject(streamReader), Q$Long));
  setHash(instance, $getString(streamReader, $readInt(streamReader)));
  setSize(instance, dynamicCast($readObject(streamReader), Q$Long));
  setStatus_5(instance, dynamicCast($readObject(streamReader), Q$DriftFileStatus));
}

function instantiate_266(streamReader){
  return new DriftFileDTO_0;
}

function serialize_256(streamWriter, instance){
  $writeObject(streamWriter, instance.ctime);
  $writeString(streamWriter, instance.hash_0);
  $writeObject(streamWriter, instance.size_0);
  $writeObject(streamWriter, instance.status_0);
}

function setCtime_18(instance, value){
  instance.ctime = value;
}

function setHash(instance, value){
  instance.hash_0 = value;
}

function setSize(instance, value){
  instance.size_0 = value;
}

function setStatus_5(instance, value){
  instance.status_0 = value;
}

function deserialize_275(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_268(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_event_EventSeverity_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$EventSeverity_$1]), Q$EventSeverity, size, 0);
}

function serialize_258(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function EventComposite_0(){
}

defineSeed(1241, 1, makeCastMap([Q$Serializable, Q$EventComposite]), EventComposite_0);
_.eventDetail = null;
_.eventId = 0;
_.resourceAncestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
_.severity = null;
_.sourceLocation = null;
_.timestamp = N1_longLit;
function deserialize_279(streamReader, instance){
  setEventDetail_0(instance, $getString(streamReader, $readInt(streamReader)));
  setEventId(instance, $readInt(streamReader));
  setResourceAncestry(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_1(instance, $readInt(streamReader));
  setResourceName(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_0(instance, $readInt(streamReader));
  setSeverity_1(instance, dynamicCast($readObject(streamReader), Q$EventSeverity));
  setSourceLocation(instance, $getString(streamReader, $readInt(streamReader)));
  setTimestamp_1(instance, $readLong(streamReader));
}

function instantiate_272(streamReader){
  return new EventComposite_0;
}

function setEventDetail_0(instance, value){
  instance.eventDetail = value;
}

function setEventId(instance, value){
  instance.eventId = value;
}

function setResourceAncestry(instance, value){
  instance.resourceAncestry = value;
}

function setResourceId_1(instance, value){
  instance.resourceId = value;
}

function setResourceName(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_0(instance, value){
  instance.resourceTypeId = value;
}

function setSeverity_1(instance, value){
  instance.severity = value;
}

function setSourceLocation(instance, value){
  instance.sourceLocation = value;
}

function setTimestamp_1(instance, value){
  instance.timestamp = value;
}

function AgentInstallInfo_0(){
  this.steps = new ArrayList_0;
}

defineSeed(1243, 1, makeCastMap([Q$Serializable, Q$AgentInstallInfo]), AgentInstallInfo_0);
_.agentAddress = null;
_.owner = null;
_.path = null;
_.serverAddress = null;
_.version_0 = null;
function deserialize_280(streamReader, instance){
  setAgentAddress(instance, $getString(streamReader, $readInt(streamReader)));
  setOwner_1(instance, $getString(streamReader, $readInt(streamReader)));
  setPath_2(instance, $getString(streamReader, $readInt(streamReader)));
  setServerAddress(instance, $getString(streamReader, $readInt(streamReader)));
  instance.steps = dynamicCast($readObject(streamReader), Q$List);
  setVersion_8(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_273(streamReader){
  return new AgentInstallInfo_0;
}

function setAgentAddress(instance, value){
  instance.agentAddress = value;
}

function setOwner_1(instance, value){
  instance.owner = value;
}

function setPath_2(instance, value){
  instance.path = value;
}

function setServerAddress(instance, value){
  instance.serverAddress = value;
}

function setVersion_8(instance, value){
  instance.version_0 = value;
}

function AgentInstallStep_0(){
}

defineSeed(1245, 1, makeCastMap([Q$Serializable, Q$AgentInstallStep]), AgentInstallStep_0);
_.toString$ = function toString_124(){
  var builder;
  builder = new StringBuilder_0;
  $append_12($append_10($append_12($append_9($append_12($append_12($append_12($append_12(($append_1(builder.data_0, 'AgentInstallStep [description=') , builder), this.description), ', result='), this.result), ', resultCode='), this.resultCode), ', duration='), this.duration_0), ']');
  return $toString_1(builder.data_0);
}
;
_.command = null;
_.description = null;
_.duration_0 = P0_longLit;
_.result = null;
_.resultCode = 0;
function deserialize_281(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_274(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_install_remote_AgentInstallStep_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$AgentInstallStep, size, 0);
}

function deserialize_282(streamReader, instance){
  setCommand(instance, $getString(streamReader, $readInt(streamReader)));
  setDescription_22(instance, $getString(streamReader, $readInt(streamReader)));
  setDuration(instance, $readLong(streamReader));
  setResult_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResultCode(instance, $readInt(streamReader));
}

function instantiate_275(streamReader){
  return new AgentInstallStep_0;
}

function setCommand(instance, value){
  instance.command = value;
}

function setDescription_22(instance, value){
  instance.description = value;
}

function setDuration(instance, value){
  instance.duration_0 = value;
}

function setResult_0(instance, value){
  instance.result = value;
}

function setResultCode(instance, value){
  instance.resultCode = value;
}

function RemoteAccessInfo_0(host, port, user, password){
  this.host_0 = host;
  this.port = port;
  this.user = user;
  this.password = password;
}

defineSeed(1248, 1, makeCastMap([Q$Serializable]), RemoteAccessInfo_0);
_.host_0 = null;
_.key = null;
_.password = null;
_.port = 22;
_.user = null;
function serialize_262(streamWriter, instance){
  $writeString(streamWriter, instance.host_0);
  $writeObject(streamWriter, instance.key);
  $writeString(streamWriter, instance.password);
  $writeInt(streamWriter, instance.port);
  $writeString(streamWriter, instance.user);
}

function serialize_263(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function MeasurementData_0(){
  MeasurementData_1.call(this, new MeasurementDataPK_1(fromDouble(currentTimeMillis0())));
}

function MeasurementData_1(pk){
  if (!pk) {
    throw new NullPointerException_1('pk==null');
  }
  this.id = pk;
}

defineSeed(1268, 1, makeCastMap([Q$Serializable, Q$MeasurementData]));
_.equals$ = function equals_89(o){
  var that;
  if (this === o) {
    return true;
  }
  if (o == null || !instanceOf(o, Q$MeasurementData)) {
    return false;
  }
  that = dynamicCast(o, Q$MeasurementData);
  if (!$equals_34(this.id, that.id)) {
    return false;
  }
  if (this.name_0 != null?!$equals_6(this.name_0, that.name_0):that.name_0 != null) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_89(){
  var result;
  result = $hashCode_22(this.id);
  result = 31 * result + (this.name_0 != null?getHashCode_0(this.name_0):0);
  return result;
}
;
_.toString$ = function toString_128(){
  return 'MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.id = null;
_.name_0 = null;
_.schedule = null;
function MeasurementDataNumeric_0(){
  MeasurementData_0.call(this);
}

defineSeed(1269, 1268, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric_0);
_.getValue_1 = function getValue_43(){
  return this.value_0;
}
;
_.toString$ = function toString_129(){
  return 'MeasurementDataNumeric[name=' + this.name_0 + ', value=' + this.value_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.value_0 = null;
function MeasurementDataNumeric1D_0(){
  MeasurementData_0.call(this);
}

defineSeed(1270, 1268, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric1D_0);
_.getValue_1 = function getValue_44(){
  return this.value_0;
}
;
_.toString$ = function toString_130(){
  return 'MeasurementDataNumeric1D[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_290(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_0(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_0(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_14(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_297(streamReader, instance);
}

function instantiate_283(streamReader){
  return new MeasurementDataNumeric1D_0;
}

function setMax_0(instance, value){
  instance.max_0 = value;
}

function setMin_0(instance, value){
  instance.min_0 = value;
}

function setValue_14(instance, value){
  instance.value_0 = value;
}

function MeasurementDataNumeric1H_0(){
  MeasurementData_0.call(this);
}

defineSeed(1272, 1268, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric1H_0);
_.getValue_1 = function getValue_45(){
  return this.value_0;
}
;
_.toString$ = function toString_131(){
  return 'MeasurementDataNumeric1H[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_291(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_1(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_1(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_15(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_297(streamReader, instance);
}

function instantiate_284(streamReader){
  return new MeasurementDataNumeric1H_0;
}

function setMax_1(instance, value){
  instance.max_0 = value;
}

function setMin_1(instance, value){
  instance.min_0 = value;
}

function setValue_15(instance, value){
  instance.value_0 = value;
}

function MeasurementDataNumeric6H_0(){
  MeasurementData_0.call(this);
}

defineSeed(1274, 1268, makeCastMap([Q$Serializable, Q$MeasurementData]), MeasurementDataNumeric6H_0);
_.getValue_1 = function getValue_46(){
  return this.value_0;
}
;
_.toString$ = function toString_132(){
  return 'MeasurementDataNumeric6H[average=[' + this.value_0 + '], MeasurementData[name=' + this.name_0 + ', scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']]';
}
;
_.max_0 = null;
_.min_0 = null;
_.value_0 = null;
function deserialize_292(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setMax_2(instance, dynamicCast($readObject(streamReader), Q$Double));
  setMin_2(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValue_16(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_297(streamReader, instance);
}

function instantiate_285(streamReader){
  return new MeasurementDataNumeric6H_0;
}

function setMax_2(instance, value){
  instance.max_0 = value;
}

function setMin_2(instance, value){
  instance.min_0 = value;
}

function setValue_16(instance, value){
  instance.value_0 = value;
}

function deserialize_293(streamReader, instance){
  setValue_17(instance, dynamicCast($readObject(streamReader), Q$Double));
  deserialize_297(streamReader, instance);
}

function instantiate_286(streamReader){
  return new MeasurementDataNumeric_0;
}

function setValue_17(instance, value){
  instance.value_0 = value;
}

function $equals_34(this$static, obj_0){
  var other;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null) {
    return false;
  }
  if (!instanceOf(obj_0, Q$MeasurementDataPK)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$MeasurementDataPK);
  if (this$static.scheduleId != other.scheduleId) {
    return false;
  }
  if (neq(this$static.timestamp, other.timestamp)) {
    return false;
  }
  return true;
}

function $hashCode_22(this$static){
  var result;
  result = 31 + this$static.scheduleId;
  result = 31 * result + toInt(xor(this$static.timestamp, shru(this$static.timestamp, 32)));
  return result;
}

function MeasurementDataPK_0(){
}

function MeasurementDataPK_1(timestamp){
  this.timestamp = timestamp;
  this.scheduleId = 0;
}

defineSeed(1277, 1, makeCastMap([Q$Serializable, Q$MeasurementDataPK]), MeasurementDataPK_0, MeasurementDataPK_1);
_.equals$ = function equals_90(obj_0){
  return $equals_34(this, obj_0);
}
;
_.hashCode$ = function hashCode_90(){
  return $hashCode_22(this);
}
;
_.toString$ = function toString_133(){
  return 'MeasurementDataPK: timestamp=[' + (new Date_2(this.timestamp)).toString$() + '], scheduleId=[' + this.scheduleId + ']';
}
;
_.scheduleId = 0;
_.timestamp = P0_longLit;
function deserialize_294(streamReader, instance){
  instance.scheduleId = $readInt(streamReader);
  instance.timestamp = $readLong(streamReader);
}

function instantiate_287(streamReader){
  return new MeasurementDataPK_0;
}

function MeasurementDataTrait_0(){
  MeasurementData_0.call(this);
}

defineSeed(1279, 1268, makeCastMap([Q$Serializable, Q$MeasurementData, Q$MeasurementDataTrait]), MeasurementDataTrait_0);
_.getValue_1 = function getValue_47(){
  return this.value_0;
}
;
_.toString$ = function toString_134(){
  return 'MeasurementDataTrait[name=' + this.name_0 + ', value="' + this.value_0 + '", scheduleId=' + this.id.scheduleId + ', timestamp=' + toString_8(this.id.timestamp) + ']';
}
;
_.value_0 = null;
function deserialize_295(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_288(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_measurement_MeasurementDataTrait_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$MeasurementDataTrait, size, 0);
}

function deserialize_296(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setValue_18(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_297(streamReader, instance);
}

function instantiate_289(streamReader){
  return new MeasurementDataTrait_0;
}

function setValue_18(instance, value){
  instance.value_0 = value;
}

function deserialize_297(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  instance.id = dynamicCast($readObject(streamReader), Q$MeasurementDataPK);
  setName_33(instance, $getString(streamReader, $readInt(streamReader)));
  instance.schedule = dynamicCast($readObject(streamReader), Q$MeasurementSchedule);
}

function setName_33(instance, value){
  instance.name_0 = value;
}

function calculateOffset(first, second){
  $clinit_MeasurementUnits();
  if (first.family != second.family) {
    throw new MeasurementConversionException_0('Can not convert ' + first.name_0 + ' to ' + second.name_0);
  }
  return calculateOffset_0(first.scale_0, second.scale_0);
}

function getUsingDisplayUnits(displayUnits, family){
  $clinit_MeasurementUnits();
  var units, units$array, units$index, units$max;
  for (units$array = $VALUES_91 , units$index = 0 , units$max = units$array.length; units$index < units$max; ++units$index) {
    units = units$array[units$index];
    if (units.family == family && $equalsIgnoreCase(units.displayUnits, displayUnits)) {
      return units;
    }
  }
  return null;
}

function scaleDown(value, units){
  $clinit_MeasurementUnits();
  if (!units || ($clinit_MeasurementUnits$Family() , RELATIVE_0) != units.family) {
    return value;
  }
  return scaleDown_0(value, units.scale_0);
}

function scaleUp(value, units){
  $clinit_MeasurementUnits();
  if (!units || ($clinit_MeasurementUnits$Family() , RELATIVE_0) != units.family) {
    return value;
  }
  return scaleUp_0(value, units.scale_0);
}

function calculateOffset_0(first, second){
  $clinit_MeasurementUnits$Scale();
  var higher, lower, movingScale, results;
  if (first.type_0 != second.type_0) {
    return null;
  }
  if (!first.comparisonScale && !second.comparisonScale) {
    return new Double_0(1);
  }
  if (!first.comparisonScale) {
    higher = second;
    lower = first;
  }
   else if (!second.comparisonScale) {
    higher = first;
    lower = second;
  }
   else {
    if (first.comparisonScale.ordinal > second.comparisonScale.ordinal) {
      higher = first;
      lower = second;
    }
     else if (first.comparisonScale.ordinal < second.comparisonScale.ordinal) {
      higher = second;
      lower = first;
    }
     else {
      return new Double_0(1);
    }
  }
  results = 1;
  movingScale = higher;
  while (movingScale != lower && !!movingScale.comparisonScale) {
    results *= movingScale.offset;
    movingScale = movingScale.comparisonScale;
  }
  if (first == lower) {
    return new Double_0(1 / results);
  }
  return new Double_0(results);
}

function scaleDown_0(value, scale){
  $clinit_MeasurementUnits$Scale();
  if (!scale) {
    return new Double_0(0);
  }
  return new Double_0(value.value_0 / scale.offset);
}

function scaleUp_0(value, scale){
  $clinit_MeasurementUnits$Scale();
  if (!scale) {
    return new Double_0(0);
  }
  return new Double_0(value.value_0 * scale.offset);
}

function CallTimeDataComposite_0(){
}

defineSeed(1302, 1, makeCastMap([Q$Serializable, Q$CallTimeDataComposite]), CallTimeDataComposite_0);
_.toString$ = function toString_139(){
  return $substring(Lorg_rhq_core_domain_measurement_calltime_CallTimeDataComposite_2_classLit.typeName, Lorg_rhq_core_domain_measurement_calltime_CallTimeDataComposite_2_classLit.typeName.lastIndexOf('.') + 1) + '[callDestination=' + this.callDestination + ', minimum=' + this.minimum + ', maximum=' + this.maximum + ', total=' + this.total + ', count=' + this.total + ', average=' + this.average + ']';
}
;
_.average = 0;
_.callDestination = null;
_.count = P0_longLit;
_.maximum = 0;
_.minimum = 0;
_.total = 0;
function deserialize_304(streamReader, instance){
  setAverage(instance, $readDouble(streamReader));
  instance.callDestination = $getString(streamReader, $readInt(streamReader));
  setCount(instance, $readLong(streamReader));
  setMaximum_1(instance, $readDouble(streamReader));
  setMinimum_1(instance, $readDouble(streamReader));
  setTotal(instance, $readDouble(streamReader));
}

function instantiate_296(streamReader){
  return new CallTimeDataComposite_0;
}

function setAverage(instance, value){
  instance.average = value;
}

function setCount(instance, value){
  instance.count = value;
}

function setMaximum_1(instance, value){
  instance.maximum = value;
}

function setMinimum_1(instance, value){
  instance.minimum = value;
}

function setTotal(instance, value){
  instance.total = value;
}

function MeasurementDataNumericHighLowComposite_0(){
}

defineSeed(1304, 1, makeCastMap([Q$Serializable, Q$MeasurementDataNumericHighLowComposite]), MeasurementDataNumericHighLowComposite_0);
_.toString$ = function toString_140(){
  return 'MeasurementDataNumericHighLowComposite[value=' + this.value_0 + ', lowValue=' + this.lowValue + ', highValue=' + this.highValue + ']';
}
;
_.highValue = 0;
_.lowValue = 0;
_.timestamp = P0_longLit;
_.value_0 = 0;
function deserialize_305(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_297(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_measurement_composite_MeasurementDataNumericHighLowComposite_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$MeasurementDataNumericHighLowComposite, size, 0);
}

function deserialize_306(streamReader, instance){
  setHighValue(instance, $readDouble(streamReader));
  setLowValue(instance, $readDouble(streamReader));
  setTimestamp_2(instance, $readLong(streamReader));
  setValue_19(instance, $readDouble(streamReader));
}

function instantiate_298(streamReader){
  return new MeasurementDataNumericHighLowComposite_0;
}

function setHighValue(instance, value){
  instance.highValue = value;
}

function setLowValue(instance, value){
  instance.lowValue = value;
}

function setTimestamp_2(instance, value){
  instance.timestamp = value;
}

function setValue_19(instance, value){
  instance.value_0 = value;
}

function $clinit_MeasurementNumericValueAndUnits(){
  $clinit_MeasurementNumericValueAndUnits = nullMethod;
  new MeasurementNumericValueAndUnits_0(new Double_0(0), ($clinit_MeasurementUnits() , NONE_8));
}

function MeasurementNumericValueAndUnits_0(value, units){
  $clinit_MeasurementNumericValueAndUnits();
  this.value_0 = value;
  this.units = units;
}

defineSeed(1307, 1, {}, MeasurementNumericValueAndUnits_0);
_.toString$ = function toString_141(){
  return this.value_0 + ' ' + this.units;
}
;
_.units = null;
_.value_0 = null;
function $setFormattedOutlier(this$static, formattedOutlier){
  this$static.formattedOutlier = formattedOutlier;
}

function MeasurementOOBComposite_0(){
}

defineSeed(1308, 1, makeCastMap([Q$Serializable, Q$MeasurementOOBComposite]), MeasurementOOBComposite_0);
_.toString$ = function toString_142(){
  var sb;
  sb = new StringBuilder_0;
  $append_1(sb.data_0, 'MeasurementOOBComposite');
  $append_7($append_12(($append_1(sb.data_0, "{resourceName='") , sb), this.resourceName), 39);
  $append_9(($append_1(sb.data_0, ', resourceId=') , sb), this.resourceId);
  $append_7($append_12(($append_1(sb.data_0, ", scheduleName='") , sb), this.scheduleName), 39);
  $append_9(($append_1(sb.data_0, ', scheduleId=') , sb), this.scheduleId);
  $append_10(($append_1(sb.data_0, ', timestamp=') , sb), this.timestamp);
  $append_9(($append_1(sb.data_0, ', definitionId=') , sb), this.definitionId);
  $append_9(($append_1(sb.data_0, ', factor=') , sb), this.factor);
  $append_8(($append_1(sb.data_0, ', blMin=') , sb), this.blMin);
  $append_8(($append_1(sb.data_0, ', blMax=') , sb), this.blMax);
  $append_8(($append_1(sb.data_0, ', dataMin=') , sb), this.dataMin);
  $append_8(($append_1(sb.data_0, ', dataMax=') , sb), this.dataMax);
  $append_8(($append_1(sb.data_0, ', outlier=') , sb), this.outlier);
  $append_11(($append_1(sb.data_0, ', units=') , sb), this.units);
  $append_7($append_12(($append_1(sb.data_0, ", parentName='") , sb), this.parentName), 39);
  $append_11(($append_1(sb.data_0, ', parentId=') , sb), this.parentId);
  $appendNonNull(sb.data_0, '}');
  return $toString_1(sb.data_0);
}
;
_.blMax = 0;
_.blMin = 0;
_.dataMax = 0;
_.dataMin = 0;
_.definitionId = 0;
_.factor = 0;
_.formattedBaseband = null;
_.formattedOutlier = null;
_.outlier = 0;
_.parentId = null;
_.parentName = null;
_.resourceAncestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
_.scheduleId = 0;
_.scheduleName = null;
_.timestamp = P0_longLit;
_.units = null;
function deserialize_307(streamReader, instance){
  setBlMax(instance, $readDouble(streamReader));
  setBlMin(instance, $readDouble(streamReader));
  setDataMax(instance, $readDouble(streamReader));
  setDataMin(instance, $readDouble(streamReader));
  setDefinitionId(instance, $readInt(streamReader));
  setFactor(instance, $readInt(streamReader));
  setFormattedBaseband(instance, $getString(streamReader, $readInt(streamReader)));
  setFormattedOutlier(instance, $getString(streamReader, $readInt(streamReader)));
  setOutlier(instance, $readDouble(streamReader));
  setParentId_0(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setParentName(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceAncestry_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_3(instance, $readInt(streamReader));
  setResourceName_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_1(instance, $readInt(streamReader));
  setScheduleId_0(instance, $readInt(streamReader));
  setScheduleName(instance, $getString(streamReader, $readInt(streamReader)));
  setTimestamp_3(instance, $readLong(streamReader));
  setUnits_1(instance, dynamicCast($readObject(streamReader), Q$MeasurementUnits));
}

function instantiate_299(streamReader){
  return new MeasurementOOBComposite_0;
}

function setBlMax(instance, value){
  instance.blMax = value;
}

function setBlMin(instance, value){
  instance.blMin = value;
}

function setDataMax(instance, value){
  instance.dataMax = value;
}

function setDataMin(instance, value){
  instance.dataMin = value;
}

function setDefinitionId(instance, value){
  instance.definitionId = value;
}

function setFactor(instance, value){
  instance.factor = value;
}

function setFormattedBaseband(instance, value){
  instance.formattedBaseband = value;
}

function setFormattedOutlier(instance, value){
  instance.formattedOutlier = value;
}

function setOutlier(instance, value){
  instance.outlier = value;
}

function setParentId_0(instance, value){
  instance.parentId = value;
}

function setParentName(instance, value){
  instance.parentName = value;
}

function setResourceAncestry_0(instance, value){
  instance.resourceAncestry = value;
}

function setResourceId_3(instance, value){
  instance.resourceId = value;
}

function setResourceName_0(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_1(instance, value){
  instance.resourceTypeId = value;
}

function setScheduleId_0(instance, value){
  instance.scheduleId = value;
}

function setScheduleName(instance, value){
  instance.scheduleName = value;
}

function setTimestamp_3(instance, value){
  instance.timestamp = value;
}

function setUnits_1(instance, value){
  instance.units = value;
}

function MeasurementScheduleComposite_0(){
}

defineSeed(1310, 1, makeCastMap([Q$Serializable, Q$MeasurementScheduleComposite]), MeasurementScheduleComposite_0);
_.toString$ = function toString_143(){
  return 'MeasurementScheduleComposite[measurementDefinition=' + this.measurementDefinition + ', collectionEnabled=' + this.collectionEnabled + ', collectionInterval=' + toString_8(this.collectionInterval) + ']';
}
;
_.collectionEnabled = null;
_.collectionInterval = P0_longLit;
_.measurementDefinition = null;
function deserialize_308(streamReader, instance){
  setCollectionEnabled(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setCollectionInterval(instance, $readLong(streamReader));
  setMeasurementDefinition_0(instance, dynamicCast($readObject(streamReader), Q$MeasurementDefinition));
}

function instantiate_300(streamReader){
  return new MeasurementScheduleComposite_0;
}

function setCollectionEnabled(instance, value){
  instance.collectionEnabled = value;
}

function setCollectionInterval(instance, value){
  instance.collectionInterval = value;
}

function setMeasurementDefinition_0(instance, value){
  instance.measurementDefinition = value;
}

defineSeed(1313, 1, makeCastMap([Q$Serializable]));
_.toString$ = function toString_144(){
  var sb;
  sb = new StringBuffer_2(Lorg_rhq_core_domain_measurement_ui_MeasurementSummary_2_classLit.typeName);
  $append_4(($append_1(sb.data_0, '(availUp=') , sb), this.availUp);
  $append_4(($append_1(sb.data_0, ',availDown=') , sb), this.availDown);
  $append_4(($append_1(sb.data_0, ',availUnknown=') , sb), this.availUnknown);
  $append_1(sb.data_0, ')');
  return $toString_1(sb.data_0);
}
;
_.availDown = null;
_.availUnknown = null;
_.availUp = null;
function $clinit_BaseMetricDisplay(){
  $clinit_BaseMetricDisplay = nullMethod;
  new Arrays$ArrayList_0(($clinit_MetricDisplayConstants() , attrKey));
}

function $getAvgMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'average');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: average');
  }
  return mdv;
}

function $getLastMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'last');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: last');
  }
  return mdv;
}

function $getMaxMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'max');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: max');
  }
  return mdv;
}

function $getMetric(this$static, key){
  if (key == null) {
    throw new IllegalArgumentException_1("'null' is not a valid metric key");
  }
  return dynamicCast(this$static.metrics.get_2(key), Q$MetricDisplayValue);
}

function $getMetricKeys(this$static){
  var ent, ent$iterator, i, key, key$iterator, keys, rv;
  keys = new ArrayList_0;
  for (ent$iterator = this$static.metrics.entrySet().iterator(); ent$iterator.hasNext();) {
    ent = dynamicCast(ent$iterator.next_0(), Q$Map$Entry);
    ent.getKey_0() != null && ent.getValue_1() != null && $add_3(keys, dynamicCast(ent.getKey_0(), Q$String));
  }
  i = 0;
  rv = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, keys.size_0, 0);
  for (key$iterator = new AbstractList$IteratorImpl_0(keys); key$iterator.i < key$iterator.this$0_0.size_1();) {
    key = dynamicCast($next_0(key$iterator), Q$String);
    rv[i] = key;
    ++i;
  }
  return rv;
}

function $getMetricValueDoubles(this$static){
  var ent, ent$iterator, i, rv, v, v$iterator, values;
  values = new ArrayList_0;
  for (ent$iterator = this$static.metrics.entrySet().iterator(); ent$iterator.hasNext();) {
    ent = dynamicCast(ent$iterator.next_0(), Q$Map$Entry);
    ent.getKey_0() != null && ent.getValue_1() != null && $add_3(values, dynamicCast(ent.getValue_1(), Q$MetricDisplayValue).value_0);
  }
  i = 0;
  rv = initDim(_3D_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, values.size_0, 1);
  for (v$iterator = new AbstractList$IteratorImpl_0(values); v$iterator.i < v$iterator.this$0_0.size_1();) {
    v = dynamicCast($next_0(v$iterator), Q$Double);
    rv[i] = v.value_0;
    ++i;
  }
  return rv;
}

function $getMinMetric(this$static){
  var mdv;
  mdv = $getMetric(this$static, 'min');
  if (!mdv) {
    throw new IllegalArgumentException_1('No valid metric key: min');
  }
  return mdv;
}

function $setUnits(this$static, units){
  this$static.units = units;
}

function $toString_11(this$static){
  var anAttrKey, anAttrKey$array, anAttrKey$index, anAttrKey$max, sb;
  sb = new StringBuffer_2(Lorg_rhq_core_domain_measurement_ui_BaseMetricDisplay_2_classLit.typeName);
  $append_5(($append_1(sb.data_0, '(label=') , sb), this$static.label);
  $append_4(($append_1(sb.data_0, ',beginTimeFrame=') , sb), this$static.beginTimeFrame);
  $append_4(($append_1(sb.data_0, ',endTimeFrame=') , sb), this$static.endTimeFrame);
  $append_5(($append_1(sb.data_0, ',units=') , sb), this$static.units);
  $append_4(($append_1(sb.data_0, ',collectionType=') , sb), this$static.collectionType);
  $append_5(($append_1(sb.data_0, ',metricSource=') , sb), this$static.metricSource);
  $append_4(($append_1(sb.data_0, ',scheduleId=') , sb), this$static.scheduleId);
  $append_4(($append_1(sb.data_0, ',showNumberCollecting=') , sb), this$static.showNumberCollecting);
  $append_1(sb.data_0, 'metrics[');
  for (anAttrKey$array = ($clinit_MetricDisplayConstants() , attrKey) , anAttrKey$index = 0 , anAttrKey$max = anAttrKey$array.length; anAttrKey$index < anAttrKey$max; ++anAttrKey$index) {
    anAttrKey = anAttrKey$array[anAttrKey$index];
    $append_4($append_5($append_5(($append_1(sb.data_0, '\n') , sb), anAttrKey), '='), this$static.metrics.get_2(anAttrKey));
  }
  $append_1(sb.data_0, ']\n)');
  return $toString_1(sb.data_0);
}

defineSeed(1312, 1313, makeCastMap([Q$Serializable, Q$Comparable, Q$BaseMetricDisplay]));
_.compareTo$ = function compareTo_14(arg0){
  var to;
  if (instanceOf(arg0, Q$BaseMetricDisplay)) {
    to = dynamicCast(arg0, Q$BaseMetricDisplay);
    return compareTo_11(this.label, to.label);
  }
  throw new IllegalArgumentException_1('Cannot compare to non-BaseMetricDisplay object: ' + arg0);
}
;
_.toString$ = function toString_145(){
  return $toString_11(this);
}
;
_.beginTimeFrame = null;
_.collectionType = null;
_.definitionId = null;
_.description = null;
_.endTimeFrame = null;
_.label = null;
_.metricName = null;
_.metricSource = null;
_.metricSourceId = 0;
_.metrics = null;
_.numberCollecting = -1;
_.scheduleId = null;
_.showNumberCollecting = null;
_.units = null;
function setBeginTimeFrame(instance, value){
  instance.beginTimeFrame = value;
}

function setCollectionType(instance, value){
  instance.collectionType = value;
}

function setDefinitionId_0(instance, value){
  instance.definitionId = value;
}

function setDescription_24(instance, value){
  instance.description = value;
}

function setEndTimeFrame(instance, value){
  instance.endTimeFrame = value;
}

function setLabel_0(instance, value){
  instance.label = value;
}

function setMetricName(instance, value){
  instance.metricName = value;
}

function setMetricSource(instance, value){
  instance.metricSource = value;
}

function setMetricSourceId(instance, value){
  instance.metricSourceId = value;
}

function setMetrics(instance, value){
  instance.metrics = value;
}

function setNumberCollecting(instance, value){
  instance.numberCollecting = value;
}

function setScheduleId_1(instance, value){
  instance.scheduleId = value;
}

function setShowNumberCollecting(instance, value){
  instance.showNumberCollecting = value;
}

function setUnits_2(instance, value){
  instance.units = value;
}

function setAvailDown(instance, value){
  instance.availDown = value;
}

function setAvailUnknown(instance, value){
  instance.availUnknown = value;
}

function setAvailUp(instance, value){
  instance.availUp = value;
}

function $clinit_MetricDisplayConstants(){
  $clinit_MetricDisplayConstants = nullMethod;
  attrKey = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, ['max', 'min', 'average', 'last', 'baseline', 'high', 'low', 'summary']);
}

var attrKey;
function MetricDisplaySummary_0(){
  $clinit_BaseMetricDisplay();
  this.metrics = new HashMap_0;
}

defineSeed(1317, 1312, makeCastMap([Q$Serializable, Q$Comparable, Q$BaseMetricDisplay, Q$MetricDisplaySummary]), MetricDisplaySummary_0);
_.toString$ = function toString_146(){
  return 'token=' + this.metricToken + ',' + Lorg_rhq_core_domain_measurement_ui_MetricDisplaySummary_2_classLit.typeName + ',group=' + this.groupId + ',super(' + $toString_11(this) + ')';
}
;
_.alertCount = 0;
_.childTypeId = -1;
_.groupId = -1;
_.isTrait = false;
_.metricToken = null;
_.parent_0 = null;
_.parentId = -1;
_.resource = null;
_.timestamp = P0_longLit;
_.value_0 = null;
_.valuesPresent = true;
function deserialize_309(streamReader, instance){
  setAlertCount(instance, $readInt(streamReader));
  setChildTypeId(instance, $readInt(streamReader));
  setGroupId(instance, $readInt(streamReader));
  setIsTrait(instance, $readBoolean(streamReader));
  setMetricToken(instance, $getString(streamReader, $readInt(streamReader)));
  setParent(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setParentId_1(instance, $readInt(streamReader));
  setResource_15(instance, dynamicCast($readObject(streamReader), Q$Resource));
  $readInt(streamReader);
  setTimestamp_4(instance, $readLong(streamReader));
  setValue_20(instance, $getString(streamReader, $readInt(streamReader)));
  setValuesPresent(instance, $readBoolean(streamReader));
  setBeginTimeFrame(instance, dynamicCast($readObject(streamReader), Q$Long));
  setCollectionType(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setDefinitionId_0(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setDescription_24(instance, $getString(streamReader, $readInt(streamReader)));
  setEndTimeFrame(instance, dynamicCast($readObject(streamReader), Q$Long));
  setLabel_0(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricName(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricSource(instance, $getString(streamReader, $readInt(streamReader)));
  setMetricSourceId(instance, $readInt(streamReader));
  setMetrics(instance, dynamicCast($readObject(streamReader), Q$Map));
  setNumberCollecting(instance, $readInt(streamReader));
  setScheduleId_1(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setShowNumberCollecting(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setUnits_2(instance, $getString(streamReader, $readInt(streamReader)));
  setAvailDown(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setAvailUnknown(instance, dynamicCast($readObject(streamReader), Q$Integer));
  setAvailUp(instance, dynamicCast($readObject(streamReader), Q$Integer));
}

function instantiate_301(streamReader){
  return new MetricDisplaySummary_0;
}

function setAlertCount(instance, value){
  instance.alertCount = value;
}

function setChildTypeId(instance, value){
  instance.childTypeId = value;
}

function setGroupId(instance, value){
  instance.groupId = value;
}

function setIsTrait(instance, value){
  instance.isTrait = value;
}

function setMetricToken(instance, value){
  instance.metricToken = value;
}

function setParent(instance, value){
  instance.parent_0 = value;
}

function setParentId_1(instance, value){
  instance.parentId = value;
}

function setResource_15(instance, value){
  instance.resource = value;
}

function setTimestamp_4(instance, value){
  instance.timestamp = value;
}

function setValue_20(instance, value){
  instance.value_0 = value;
}

function setValuesPresent(instance, value){
  instance.valuesPresent = value;
}

function $setValueFmt(this$static, aValueFmt){
  this$static.valueFmt = aValueFmt;
}

function $toString_12(this$static){
  if (this$static.valueFmt != null) {
    return this$static.valueFmt;
  }
  return '' + this$static.value_0.value_0;
}

function MetricDisplayValue_0(){
}

defineSeed(1319, 1, makeCastMap([Q$Serializable, Q$MetricDisplayValue]), MetricDisplayValue_0);
_.toString$ = function toString_147(){
  return $toString_12(this);
}
;
_.highlighted = null;
_.value_0 = null;
_.valueFmt = null;
function deserialize_310(streamReader, instance){
  setHighlighted(instance, dynamicCast($readObject(streamReader), Q$Boolean));
  setValue_21(instance, dynamicCast($readObject(streamReader), Q$Double));
  setValueFmt(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_302(streamReader){
  return new MetricDisplayValue_0;
}

function setHighlighted(instance, value){
  instance.highlighted = value;
}

function setValue_21(instance, value){
  instance.value_0 = value;
}

function setValueFmt(instance, value){
  instance.valueFmt = value;
}

function MeasurementConversionException_0(message){
  RuntimeException_1.call(this, message);
}

defineSeed(1321, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable]), MeasurementConversionException_0);
function $setId_2(this$static, id){
  this$static.id = id;
}

function $setStartedTime(this$static){
  if (neq(this$static.startedTime, P0_longLit)) {
    throw new IllegalArgumentException_1('Can only start an operation once');
  }
  this$static.startedTime = fromDouble(currentTimeMillis0());
}

function OperationHistory_0(subjectName, operationDefinition, parameters){
  $$init_14(this);
  this.jobName = null;
  this.jobGroup = null;
  this.subjectName = subjectName;
  this.operationDefinition = operationDefinition;
  this.parameters = parameters;
  this.status_0 = ($clinit_OperationRequestStatus() , INPROGRESS_1);
}

function GroupOperationHistory_1(){
  OperationHistory_0.call(this, null, null, null);
  $$init_15(this);
  this.group = null;
  $setStartedTime(this);
}

defineSeed(1322, 1323, makeCastMap([Q$Serializable, Q$GroupOperationHistory, Q$OperationHistory]), GroupOperationHistory_1);
function JobId_0(){
}

defineSeed(1327, 1, makeCastMap([Q$Serializable, Q$JobId]), JobId_0);
function deserialize_313(streamReader, instance){
  setJobGroup(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_305(streamReader){
  return new JobId_0;
}

function setJobGroup(instance, value){
  instance.jobGroup = value;
}

function setJobName(instance, value){
  instance.jobName = value;
}

function serialize_281(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function ResourceOperationHistory_1(subjectName, operationDefinition, parameters, resource){
  OperationHistory_0.call(this, subjectName, operationDefinition, parameters);
  this.resource = resource;
  this.groupOperationHistory = null;
  !!this.groupOperationHistory && null.resourceOperationHistories.add(this);
}

defineSeed(1336, 1323, makeCastMap([Q$Serializable, Q$OperationHistory, Q$ResourceOperationHistory]), ResourceOperationHistory_1);
function ScheduleJobId_0(){
  JobId_1.call(this, '', '');
}

defineSeed(1339, 1327, makeCastMap([Q$Serializable, Q$JobId]), ScheduleJobId_0);
function deserialize_319(streamReader, instance){
  setJobGroup(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_310(streamReader){
  return new ScheduleJobId_0;
}

function $getOperationDisplayName(this$static){
  if (this$static.operationDisplayName == null || $equals_6(this$static.operationDisplayName, '')) {
    return this$static.operationName;
  }
  return this$static.operationDisplayName;
}

function $setDescription_2(this$static, description){
  this$static.description = description;
}

function $setId_3(this$static, id){
  this$static.id = id;
}

function $setJobGroup(this$static, jobGroup){
  this$static.jobGroup = jobGroup;
}

function $setJobName(this$static, jobName){
  this$static.jobName = jobName;
}

function $setJobTrigger(this$static, jobTrigger){
  this$static.jobTrigger = jobTrigger;
}

function $setNextFireTime(this$static, nextFireTime){
  this$static.nextFireTime = nextFireTime;
}

function $setOperationDisplayName(this$static, operationDisplayName){
  this$static.operationDisplayName = operationDisplayName;
}

function $setOperationName(this$static, operationName){
  this$static.operationName = operationName;
}

function $setSubject(this$static, subject){
  if (!subject) {
    throw new NullPointerException_1('Cannot schedule an operation without a user associated with it');
  }
  this$static.subject = subject;
}

function $toString_16(this$static){
  var str;
  str = new StringBuilder_0;
  $append_12(str, 'job-name=[' + this$static.jobName);
  $append_12(str, '], job-group=[' + this$static.jobGroup);
  $append_12(str, '], operation-name=[' + this$static.operationName);
  $append_12(str, '], subject=[' + this$static.subject);
  $append_12(str, '], description=[' + this$static.description);
  $append_1(str.data_0, ']');
  return $toString_1(str.data_0);
}

defineSeed(1342, 1, makeCastMap([Q$Serializable, Q$OperationSchedule]));
_.toString$ = function toString_155(){
  return $toString_16(this);
}
;
_.description = null;
_.id = 0;
_.jobGroup = null;
_.jobName = null;
_.jobTrigger = null;
_.nextFireTime = null;
_.operationDisplayName = null;
_.operationName = null;
_.parameters = null;
_.subject = null;
function $setGroup_0(this$static, group){
  this$static.group = group;
}

function $setHaltOnFailure(this$static, haltOnFailure){
  this$static.haltOnFailure = haltOnFailure;
}

function GroupOperationSchedule_0(){
}

defineSeed(1341, 1342, makeCastMap([Q$Serializable, Q$GroupOperationSchedule, Q$OperationSchedule]), GroupOperationSchedule_0);
_.toString$ = function toString_156(){
  var str;
  str = new StringBuilder_1('GroupOperationSchedule: ');
  $append_12(str, 'group=[' + this.group);
  $append_12(str, '], execution-order=[' + this.executionOrder);
  $append_12(str, '], halt-on-failure=[' + this.haltOnFailure);
  $append_1(str.data_0, '],');
  $append_12(str, $toString_16(this));
  return $toString_1(str.data_0);
}
;
_.executionOrder = null;
_.group = null;
_.haltOnFailure = false;
function deserialize_320(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_311(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_operation_bean_GroupOperationSchedule_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$GroupOperationSchedule, size, 0);
}

function deserialize_321(streamReader, instance){
  setExecutionOrder(instance, dynamicCast($readObject(streamReader), Q$List));
  setGroup_4(instance, dynamicCast($readObject(streamReader), Q$ResourceGroup));
  setHaltOnFailure(instance, $readBoolean(streamReader));
  deserialize_322(streamReader, instance);
}

function instantiate_312(streamReader){
  return new GroupOperationSchedule_0;
}

function serialize_285(streamWriter, instance){
  $writeObject(streamWriter, instance.executionOrder);
  $writeObject(streamWriter, instance.group);
  $writeBoolean(streamWriter, instance.haltOnFailure);
  serialize_286(streamWriter, instance);
}

function setExecutionOrder(instance, value){
  instance.executionOrder = value;
}

function setGroup_4(instance, value){
  instance.group = value;
}

function setHaltOnFailure(instance, value){
  instance.haltOnFailure = value;
}

function deserialize_322(streamReader, instance){
  setDescription_26(instance, $getString(streamReader, $readInt(streamReader)));
  setId_77(instance, $readInt(streamReader));
  setJobGroup_1(instance, $getString(streamReader, $readInt(streamReader)));
  setJobName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setJobTrigger(instance, dynamicCast($readObject(streamReader), Q$JobTrigger));
  setNextFireTime(instance, dynamicCast($readObject(streamReader), Q$Date));
  setOperationDisplayName(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationName(instance, $getString(streamReader, $readInt(streamReader)));
  setParameters_0(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setSubject(instance, dynamicCast($readObject(streamReader), Q$Subject));
}

function serialize_286(streamWriter, instance){
  $writeString(streamWriter, instance.description);
  $writeInt(streamWriter, instance.id);
  $writeString(streamWriter, instance.jobGroup);
  $writeString(streamWriter, instance.jobName);
  $writeObject(streamWriter, instance.jobTrigger);
  $writeObject(streamWriter, instance.nextFireTime);
  $writeString(streamWriter, instance.operationDisplayName);
  $writeString(streamWriter, instance.operationName);
  $writeObject(streamWriter, instance.parameters);
  $writeObject(streamWriter, instance.subject);
}

function setDescription_26(instance, value){
  instance.description = value;
}

function setId_77(instance, value){
  instance.id = value;
}

function setJobGroup_1(instance, value){
  instance.jobGroup = value;
}

function setJobName_1(instance, value){
  instance.jobName = value;
}

function setJobTrigger(instance, value){
  instance.jobTrigger = value;
}

function setNextFireTime(instance, value){
  instance.nextFireTime = value;
}

function setOperationDisplayName(instance, value){
  instance.operationDisplayName = value;
}

function setOperationName(instance, value){
  instance.operationName = value;
}

function setParameters_0(instance, value){
  instance.parameters = value;
}

function setSubject(instance, value){
  instance.subject = value;
}

function $setResource_0(this$static, resource){
  this$static.resource = resource;
}

function ResourceOperationSchedule_0(){
}

defineSeed(1346, 1342, makeCastMap([Q$Serializable, Q$OperationSchedule, Q$ResourceOperationSchedule]), ResourceOperationSchedule_0);
_.toString$ = function toString_157(){
  var str;
  str = new StringBuilder_1('ResourceOperationSchedule: ');
  $append_12(str, 'resource=[' + this.resource);
  $append_1(str.data_0, '],');
  $append_12(str, $toString_16(this));
  return $toString_1(str.data_0);
}
;
_.resource = null;
function deserialize_323(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_313(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_operation_bean_ResourceOperationSchedule_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ResourceOperationSchedule, size, 0);
}

function deserialize_324(streamReader, instance){
  setResource_17(instance, dynamicCast($readObject(streamReader), Q$Resource));
  deserialize_322(streamReader, instance);
}

function instantiate_314(streamReader){
  return new ResourceOperationSchedule_0;
}

function serialize_287(streamWriter, instance){
  $writeObject(streamWriter, instance.resource);
  serialize_286(streamWriter, instance);
}

function setResource_17(instance, value){
  instance.resource = value;
}

function $toString_17(this$static){
  var str;
  str = new StringBuilder_0;
  $append_12(str, 'operation-job-id=[' + this$static.id);
  $append_12(str, '], operation-name=[' + this$static.operationName);
  $append_12(str, '], operation-next-fire-time=[' + new Date_2(this$static.operationNextFireTime));
  $append_1(str.data_0, ']');
  return $toString_1(str.data_0);
}

function OperationScheduleComposite_0(){
  this.operationNextFireTime = N1_longLit;
  this.id = 0;
  this.operationName = '(uninitialized)';
}

defineSeed(1350, 1, makeCastMap([Q$Serializable, Q$OperationScheduleComposite]));
_.toString$ = function toString_158(){
  return $toString_17(this);
}
;
_.id = 0;
_.jobId = null;
_.operationName = null;
_.operationNextFireTime = P0_longLit;
function GroupOperationScheduleComposite_0(){
  OperationScheduleComposite_0.call(this);
}

defineSeed(1349, 1350, makeCastMap([Q$Serializable, Q$GroupOperationScheduleComposite, Q$OperationScheduleComposite]), GroupOperationScheduleComposite_0);
_.toString$ = function toString_159(){
  var str;
  str = new StringBuilder_1('GroupOperationScheduleComposite: ' + $toString_17(this));
  $append_12(str, ', group-id=[' + this.groupId);
  $append_12(str, '], group-name=[' + this.groupName);
  $append_12(str, '], group-resource-type-name=[' + this.groupResourceTypeName);
  $append_1(str.data_0, ']');
  return $toString_1(str.data_0);
}
;
_.groupId = 0;
_.groupName = null;
_.groupResourceTypeName = null;
function deserialize_325(streamReader, instance){
  setGroupId_0(instance, $readInt(streamReader));
  setGroupName(instance, $getString(streamReader, $readInt(streamReader)));
  setGroupResourceTypeName(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_326(streamReader, instance);
}

function instantiate_315(streamReader){
  return new GroupOperationScheduleComposite_0;
}

function setGroupId_0(instance, value){
  instance.groupId = value;
}

function setGroupName(instance, value){
  instance.groupName = value;
}

function setGroupResourceTypeName(instance, value){
  instance.groupResourceTypeName = value;
}

defineSeed(1352, 1, makeCastMap([Q$Serializable]));
_.operationHistoryId = 0;
_.operationName = null;
_.operationStartTime = P0_longLit;
_.operationStatus = null;
function setOperationHistoryId(instance, value){
  instance.operationHistoryId = value;
}

function setOperationName_0(instance, value){
  instance.operationName = value;
}

function setOperationStartTime(instance, value){
  instance.operationStartTime = value;
}

function setOperationStatus(instance, value){
  instance.operationStatus = value;
}

function deserialize_326(streamReader, instance){
  setId_78(instance, $readInt(streamReader));
  setJobId(instance, dynamicCast($readObject(streamReader), Q$JobId));
  setOperationName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationNextFireTime(instance, $readLong(streamReader));
}

function setId_78(instance, value){
  instance.id = value;
}

function setJobId(instance, value){
  instance.jobId = value;
}

function setOperationName_1(instance, value){
  instance.operationName = value;
}

function setOperationNextFireTime(instance, value){
  instance.operationNextFireTime = value;
}

function ResourceOperationLastCompletedComposite_0(){
  this.operationHistoryId = 0;
  this.operationName = '(uninitialized)';
  this.operationStartTime = N1_longLit;
  this.operationStatus = ($clinit_OperationRequestStatus() , FAILURE_6);
  this.resourceId = 0;
  this.resourceTypeId = 0;
  this.resourceName = '(uninitialized)';
  this.ancestry = '(uninitialized)';
}

defineSeed(1355, 1352, makeCastMap([Q$Serializable]), ResourceOperationLastCompletedComposite_0);
_.ancestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
function deserialize_327(streamReader, instance){
  setAncestry(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_4(instance, $readInt(streamReader));
  setResourceName_1(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_2(instance, $readInt(streamReader));
  setOperationHistoryId(instance, $readInt(streamReader));
  setOperationName_0(instance, $getString(streamReader, $readInt(streamReader)));
  setOperationStartTime(instance, $readLong(streamReader));
  setOperationStatus(instance, dynamicCast($readObject(streamReader), Q$OperationRequestStatus));
}

function instantiate_316(streamReader){
  return new ResourceOperationLastCompletedComposite_0;
}

function setAncestry(instance, value){
  instance.ancestry = value;
}

function setResourceId_4(instance, value){
  instance.resourceId = value;
}

function setResourceName_1(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_2(instance, value){
  instance.resourceTypeId = value;
}

function ResourceOperationScheduleComposite_0(){
  OperationScheduleComposite_0.call(this);
  this.resourceId = 0;
  this.resourceTypeId = 0;
  this.resourceName = '(uninitialized)';
  this.ancestry = '(uninitialized)';
}

defineSeed(1357, 1350, makeCastMap([Q$Serializable, Q$OperationScheduleComposite, Q$ResourceOperationScheduleComposite]), ResourceOperationScheduleComposite_0);
_.toString$ = function toString_160(){
  var str;
  str = new StringBuilder_1('ResourceOperationScheduleComposite: ' + $toString_17(this));
  $append_12(str, ', resource-id=[' + this.resourceId);
  $append_12(str, '], resource-name=[' + this.resourceName);
  $append_12(str, '], resource-type-id=[' + this.resourceTypeId);
  $append_1(str.data_0, ']');
  return $toString_1(str.data_0);
}
;
_.ancestry = null;
_.resourceId = 0;
_.resourceName = null;
_.resourceTypeId = 0;
function deserialize_328(streamReader, instance){
  setAncestry_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceId_5(instance, $readInt(streamReader));
  setResourceName_2(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_3(instance, $readInt(streamReader));
  deserialize_326(streamReader, instance);
}

function instantiate_317(streamReader){
  return new ResourceOperationScheduleComposite_0;
}

function setAncestry_0(instance, value){
  instance.ancestry = value;
}

function setResourceId_5(instance, value){
  instance.resourceId = value;
}

function setResourceName_2(instance, value){
  instance.resourceName = value;
}

function setResourceTypeId_3(instance, value){
  instance.resourceTypeId = value;
}

function $equals_37(this$static, obj_0){
  var that;
  if (this$static === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$AbstractPlugin)) {
    return false;
  }
  that = dynamicCast(obj_0, Q$AbstractPlugin);
  return $equals_6(this$static.name_0, that.name_0);
}

function AbstractPlugin_0(){
  this.status_0 = ($clinit_PluginStatusType() , INSTALLED_1);
}

defineSeed(1359, 1, makeCastMap([Q$Serializable, Q$AbstractPlugin]));
_.equals$ = function equals_97(obj_0){
  return $equals_37(this, obj_0);
}
;
_.hashCode$ = function hashCode_97(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_161(){
  return '[id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
_.ampsVersion = null;
_.content_0 = null;
_.ctime = P0_longLit;
_.deployment = null;
_.description = null;
_.displayName = null;
_.enabled = true;
_.help = null;
_.helpContentType = null;
_.id = 0;
_.md5 = null;
_.mtime = P0_longLit;
_.name_0 = null;
_.path = null;
_.version_0 = null;
function deserialize_329(streamReader, instance){
  setNative(instance, 'server-enhanced-data-1', $getString(streamReader, $readInt(streamReader)));
  setAmpsVersion(instance, $getString(streamReader, $readInt(streamReader)));
  setContent(instance, dynamicCast($readObject(streamReader), Q$byte_$1));
  setCtime_19(instance, $readLong(streamReader));
  setDeployment(instance, dynamicCast($readObject(streamReader), Q$PluginDeploymentType));
  setDescription_27(instance, $getString(streamReader, $readInt(streamReader)));
  setDisplayName_7(instance, $getString(streamReader, $readInt(streamReader)));
  setEnabled_4(instance, $readBoolean(streamReader));
  setHelp(instance, $getString(streamReader, $readInt(streamReader)));
  setHelpContentType(instance, $getString(streamReader, $readInt(streamReader)));
  setId_79(instance, $readInt(streamReader));
  setMd5_0(instance, $getString(streamReader, $readInt(streamReader)));
  setMtime_7(instance, $readLong(streamReader));
  setName_36(instance, $getString(streamReader, $readInt(streamReader)));
  setPath_3(instance, $getString(streamReader, $readInt(streamReader)));
  setStatus_7(instance, dynamicCast($readObject(streamReader), Q$PluginStatusType));
  setVersion_10(instance, $getString(streamReader, $readInt(streamReader)));
}

function setAmpsVersion(instance, value){
  instance.ampsVersion = value;
}

function setContent(instance, value){
  instance.content_0 = value;
}

function setCtime_19(instance, value){
  instance.ctime = value;
}

function setDeployment(instance, value){
  instance.deployment = value;
}

function setDescription_27(instance, value){
  instance.description = value;
}

function setDisplayName_7(instance, value){
  instance.displayName = value;
}

function setEnabled_4(instance, value){
  instance.enabled = value;
}

function setHelp(instance, value){
  instance.help = value;
}

function setHelpContentType(instance, value){
  instance.helpContentType = value;
}

function setId_79(instance, value){
  instance.id = value;
}

function setMd5_0(instance, value){
  instance.md5 = value;
}

function setMtime_7(instance, value){
  instance.mtime = value;
}

function setName_36(instance, value){
  instance.name_0 = value;
}

function setPath_3(instance, value){
  instance.path = value;
}

function setStatus_7(instance, value){
  instance.status_0 = value;
}

function setVersion_10(instance, value){
  instance.version_0 = value;
}

function $setDeployment(this$static, deployment){
  if (deployment != ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('Plugin can only ever have deployment type of AGENT: ' + deployment);
  }
  this$static.deployment = deployment;
}

function Plugin_1(){
  AbstractPlugin_0.call(this);
  $setDeployment(this, ($clinit_PluginDeploymentType() , AGENT));
}

defineSeed(1361, 1359, makeCastMap([Q$Serializable, Q$AbstractPlugin, Q$Plugin]), Plugin_1);
_.equals$ = function equals_98(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$Plugin)) {
    return false;
  }
  return $equals_37(this, obj_0);
}
;
_.hashCode$ = function hashCode_98(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_162(){
  return 'AgentPlugin [id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
function $clinit_PluginDeploymentType(){
  $clinit_PluginDeploymentType = nullMethod;
  AGENT = new PluginDeploymentType_0('AGENT', 0);
  SERVER = new PluginDeploymentType_0('SERVER', 1);
  $VALUES_97 = initValues(_3Lorg_rhq_core_domain_plugin_PluginDeploymentType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PluginDeploymentType, [AGENT, SERVER]);
}

function PluginDeploymentType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_106(name_0){
  $clinit_PluginDeploymentType();
  return valueOf(($clinit_PluginDeploymentType$Map() , $MAP_97), name_0);
}

function values_100(){
  $clinit_PluginDeploymentType();
  return $VALUES_97;
}

defineSeed(1362, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PluginDeploymentType]), PluginDeploymentType_0);
var $VALUES_97, AGENT, SERVER;
function $clinit_PluginDeploymentType$Map(){
  $clinit_PluginDeploymentType$Map = nullMethod;
  $MAP_97 = createValueOfMap(($clinit_PluginDeploymentType() , $VALUES_97));
}

var $MAP_97;
function deserialize_330(streamReader, instance){
}

function instantiate_318(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PluginDeploymentType() , $clinit_PluginDeploymentType() , $VALUES_97);
  return values[ordinal];
}

function serialize_288(streamWriter, instance){
  $writeInt(streamWriter, instance.ordinal);
}

function PluginKey_0(deployment, pluginType, pluginName){
  if (!deployment) {
    throw new IllegalArgumentException_1('deployment==null');
  }
  if (pluginType == null && deployment != ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('only agent plugins can have null type');
  }
  if (pluginType != null && deployment == ($clinit_PluginDeploymentType() , AGENT)) {
    throw new IllegalArgumentException_1('agent plugins must have null type');
  }
  if (pluginName == null || pluginName.length == 0) {
    throw new IllegalArgumentException_1('invalid pluginName: ' + pluginName);
  }
  this.deployment = deployment;
  this.pluginType = pluginType;
  this.pluginName = pluginName;
}

function createServerPluginKey(pluginType, pluginName){
  if (pluginType == null || pluginType.length == 0) {
    throw new IllegalArgumentException_1('invalid pluginType: ' + pluginType);
  }
  return new PluginKey_0(($clinit_PluginDeploymentType() , SERVER), pluginType, pluginName);
}

defineSeed(1365, 1, makeCastMap([Q$Serializable, Q$PluginKey]), PluginKey_0);
_.equals$ = function equals_99(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$PluginKey)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$PluginKey);
  if (!$equals_6(this.pluginName, other.pluginName)) {
    return false;
  }
  if (this.pluginType == null) {
    if (other.pluginType != null) {
      return false;
    }
  }
   else if (!$equals_6(this.pluginType, other.pluginType)) {
    return false;
  }
  if (this.deployment != other.deployment) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_99(){
  var result;
  result = 31 + getHashCode(this.deployment);
  result = 31 * result + (this.pluginType == null?0:getHashCode_0(this.pluginType));
  result = 31 * result + getHashCode_0(this.pluginName);
  return result;
}
;
_.toString$ = function toString_163(){
  var builder;
  builder = new StringBuilder_0;
  $append_12($append_12($append_12($append_12($append_12($append_11(($append_1(builder.data_0, 'PluginKey [deployment=') , builder), this.deployment), ', pluginType='), this.pluginType), ', pluginName='), this.pluginName), ']');
  return $toString_1(builder.data_0);
}
;
_.deployment = null;
_.pluginName = null;
_.pluginType = null;
function serialize_289(streamWriter, instance){
  $writeObject(streamWriter, instance.deployment);
  $writeString(streamWriter, instance.pluginName);
  $writeString(streamWriter, instance.pluginType);
}

function $clinit_PluginStatusType(){
  $clinit_PluginStatusType = nullMethod;
  INSTALLED_1 = new PluginStatusType_0('INSTALLED', 0);
  DELETED_0 = new PluginStatusType_0('DELETED', 1);
  $VALUES_98 = initValues(_3Lorg_rhq_core_domain_plugin_PluginStatusType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PluginStatusType, [INSTALLED_1, DELETED_0]);
}

function PluginStatusType_0(enum$name, enum$ordinal){
  Enum_0.call(this, enum$name, enum$ordinal);
}

function valueOf_107(name_0){
  $clinit_PluginStatusType();
  return valueOf(($clinit_PluginStatusType$Map() , $MAP_98), name_0);
}

function values_101(){
  $clinit_PluginStatusType();
  return $VALUES_98;
}

defineSeed(1367, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PluginStatusType]), PluginStatusType_0);
var $VALUES_98, DELETED_0, INSTALLED_1;
function $clinit_PluginStatusType$Map(){
  $clinit_PluginStatusType$Map = nullMethod;
  $MAP_98 = createValueOfMap(($clinit_PluginStatusType() , $VALUES_98));
}

var $MAP_98;
function deserialize_331(streamReader, instance){
}

function instantiate_319(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_PluginStatusType() , $clinit_PluginStatusType() , $VALUES_98);
  return values[ordinal];
}

function deserialize_332(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  deserialize_329(streamReader, instance);
}

function instantiate_320(streamReader){
  return new Plugin_1;
}

function $setDeployment_0(this$static, deployment){
  if (deployment != ($clinit_PluginDeploymentType() , SERVER)) {
    throw new IllegalArgumentException_1('ServerPlugin can only ever have deployment type of SERVER: ' + deployment);
  }
  this$static.deployment = deployment;
}

function ServerPlugin_0(){
  AbstractPlugin_0.call(this);
  $setDeployment_0(this, ($clinit_PluginDeploymentType() , SERVER));
}

defineSeed(1371, 1359, makeCastMap([Q$Serializable, Q$AbstractPlugin, Q$ServerPlugin]), ServerPlugin_0);
_.equals$ = function equals_100(obj_0){
  if (this === obj_0) {
    return true;
  }
  if (obj_0 == null || !instanceOf(obj_0, Q$ServerPlugin)) {
    return false;
  }
  return $equals_37(this, obj_0);
}
;
_.hashCode$ = function hashCode_100(){
  return getHashCode_0(this.name_0);
}
;
_.toString$ = function toString_164(){
  return 'ServerPlugin [id=' + this.id + ', name=' + this.name_0 + ', md5=' + this.md5 + ']';
}
;
_.pluginConfiguration = null;
_.scheduledJobsConfiguration = null;
_.type_0 = null;
function ServerPluginControlDefinition_0(){
}

defineSeed(1372, 1, makeCastMap([Q$Serializable, Q$ServerPluginControlDefinition]), ServerPluginControlDefinition_0);
_.toString$ = function toString_165(){
  var builder;
  builder = new StringBuilder_0;
  $append_12($append_12(($append_1(builder.data_0, 'ControlDefinition name=[') , builder), this.name_0), ']');
  $append_12($append_12(($append_1(builder.data_0, ', description=[') , builder), this.description), ']');
  return $toString_1(builder.data_0);
}
;
_.description = null;
_.displayName = null;
_.name_0 = null;
_.parameters = null;
_.results = null;
function deserialize_333(streamReader, instance){
  setDescription_28(instance, $getString(streamReader, $readInt(streamReader)));
  setDisplayName_8(instance, $getString(streamReader, $readInt(streamReader)));
  setName_37(instance, $getString(streamReader, $readInt(streamReader)));
  setParameters_1(instance, dynamicCast($readObject(streamReader), Q$ConfigurationDefinition));
  setResults_2(instance, dynamicCast($readObject(streamReader), Q$ConfigurationDefinition));
}

function instantiate_321(streamReader){
  return new ServerPluginControlDefinition_0;
}

function setDescription_28(instance, value){
  instance.description = value;
}

function setDisplayName_8(instance, value){
  instance.displayName = value;
}

function setName_37(instance, value){
  instance.name_0 = value;
}

function setParameters_1(instance, value){
  instance.parameters = value;
}

function setResults_2(instance, value){
  instance.results = value;
}

function ServerPluginControlResults_0(){
  this.complexResults = new Configuration_0;
}

defineSeed(1374, 1, makeCastMap([Q$Serializable, Q$ServerPluginControlResults]), ServerPluginControlResults_0);
_.toString$ = function toString_166(){
  var str;
  str = new StringBuilder_1('ServerPluginControlResults');
  this.errorMessage_0 != null && $append_12($append_12(($append_1(str.data_0, ' error=[') , str), this.errorMessage_0), '];');
  $append_12($append_11(($append_1(str.data_0, ' results=[') , str), this.complexResults), ']');
  return $toString_1(str.data_0);
}
;
_.errorMessage_0 = null;
function deserialize_334(streamReader, instance){
  setComplexResults(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setErrorMessage_4(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_322(streamReader){
  return new ServerPluginControlResults_0;
}

function setComplexResults(instance, value){
  instance.complexResults = value;
}

function setErrorMessage_4(instance, value){
  instance.errorMessage_0 = value;
}

function deserialize_335(streamReader, instance){
  setNative(instance, 'server-enhanced-data-2', $getString(streamReader, $readInt(streamReader)));
  setPluginConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setScheduledJobsConfiguration(instance, dynamicCast($readObject(streamReader), Q$Configuration));
  setType_1(instance, $getString(streamReader, $readInt(streamReader)));
  deserialize_329(streamReader, instance);
}

function instantiate_323(streamReader){
  return new ServerPlugin_0;
}

function setPluginConfiguration(instance, value){
  instance.pluginConfiguration = value;
}

function setScheduledJobsConfiguration(instance, value){
  instance.scheduledJobsConfiguration = value;
}

function setType_1(instance, value){
  instance.type_0 = value;
}

function InventorySummary_0(){
}

defineSeed(1401, 1, makeCastMap([Q$Serializable, Q$InventorySummary]), InventorySummary_0);
_.compatibleGroupCount = 0;
_.groupDefinitionCount = 0;
_.mixedGroupCount = 0;
_.platformCount = 0;
_.scheduledMeasurementsPerMinute = 0;
_.serverCount = 0;
_.serviceCount = 0;
_.softwareProductCount = 0;
_.softwareUpdateCount = 0;
function deserialize_347(streamReader, instance){
  setCompatibleGroupCount(instance, $readInt(streamReader));
  setGroupDefinitionCount(instance, $readInt(streamReader));
  setMixedGroupCount(instance, $readInt(streamReader));
  setPlatformCount(instance, $readInt(streamReader));
  setScheduledMeasurementsPerMinute(instance, $readInt(streamReader));
  setServerCount_0(instance, $readInt(streamReader));
  setServiceCount(instance, $readInt(streamReader));
  setSoftwareProductCount(instance, $readInt(streamReader));
  setSoftwareUpdateCount(instance, $readInt(streamReader));
}

function instantiate_335(streamReader){
  return new InventorySummary_0;
}

function setCompatibleGroupCount(instance, value){
  instance.compatibleGroupCount = value;
}

function setGroupDefinitionCount(instance, value){
  instance.groupDefinitionCount = value;
}

function setMixedGroupCount(instance, value){
  instance.mixedGroupCount = value;
}

function setPlatformCount(instance, value){
  instance.platformCount = value;
}

function setScheduledMeasurementsPerMinute(instance, value){
  instance.scheduledMeasurementsPerMinute = value;
}

function setServerCount_0(instance, value){
  instance.serverCount = value;
}

function setServiceCount(instance, value){
  instance.serviceCount = value;
}

function setSoftwareProductCount(instance, value){
  instance.softwareProductCount = value;
}

function setSoftwareUpdateCount(instance, value){
  instance.softwareUpdateCount = value;
}

function $getAlertDefinitions(this$static){
  !this$static.alertDefinitions && (this$static.alertDefinitions = new LinkedHashSet_0);
  return this$static.alertDefinitions;
}

function $setAncestry(this$static, ancestry){
  this$static.ancestry = ancestry;
}

function $setDescription_3(this$static, description){
  this$static.description = description;
}

function $setId_4(this$static, id){
  this$static.id = id;
}

function $setLocation(this$static, location_0){
  this$static.location_0 = location_0;
}

function $setName_8(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setResourceType_0(this$static, resourceType){
  this$static.resourceType = resourceType;
}

function $setTags(this$static, tags){
  this$static.tags = tags;
}

function $setUuid(this$static, uuid){
  var i, spacesNeeded;
  if (uuid != null && uuid.length != 36) {
    if (uuid.length > 36) {
      throw new IllegalArgumentException_1('UUIDs must not be longer than [36]');
    }
     else {
      spacesNeeded = 36 - uuid.length;
      for (i = 0; i < spacesNeeded; ++i) {
        uuid = uuid + ' ';
      }
    }
  }
  this$static.uuid = uuid;
}

function $updateAncestryForResource(this$static){
  var ancestry, parentAncestry, parentResource;
  parentResource = this$static.parentResource;
  if (!parentResource || parentResource.id <= 0 || !parentResource.resourceType) {
    return null;
  }
  ancestry = new StringBuilder_0;
  $append_9(ancestry, parentResource.resourceType.id);
  $append_1(ancestry.data_0, '_:_');
  $append_9(ancestry, parentResource.id);
  $append_1(ancestry.data_0, '_:_');
  $append_12(ancestry, parentResource.name_0);
  parentAncestry = parentResource.ancestry;
  if (null != parentAncestry) {
    $append_1(ancestry.data_0, '_::_');
    $append_1(ancestry.data_0, parentAncestry);
  }
  $toString_1(ancestry.data_0).length < 4000 && $setAncestry(this$static, $toString_1(ancestry.data_0));
  return this$static.ancestry;
}

function Resource_2(id){
  Resource_1.call(this);
  this.id = id;
}

defineSeed(1407, 1, makeCastMap([Q$Serializable, Q$Comparable, Q$Resource]), Resource_2);
function $addDriftDefinitionTemplate(this$static, template){
  !this$static.driftDefinitionTemplates && (this$static.driftDefinitionTemplates = new HashSet_0);
  template.resourceType = this$static;
  this$static.driftDefinitionTemplates.add(template);
}

function $getResourceTypeBundleConfiguration(this$static){
  return !this$static.bundleConfiguration?null:new ResourceTypeBundleConfiguration_1(this$static.bundleConfiguration);
}

function $isDeletable(this$static){
  return this$static.createDeletePolicy == ($clinit_CreateDeletePolicy() , BOTH_1) || this$static.createDeletePolicy == DELETE_ONLY;
}

function $setIgnored(this$static, ignored){
  this$static.ignored = ignored;
}

function PlatformMetricsSummary_0(){
}

defineSeed(1434, 1, makeCastMap([Q$Serializable, Q$PlatformMetricsSummary]), PlatformMetricsSummary_0);
_.actualFreeMemory = null;
_.actualUsedMemory = null;
_.freeMemory = null;
_.freeSwap = null;
_.idleCPU = null;
_.metricsAvailable = true;
_.resource = null;
_.systemCPU = null;
_.totalMemory = null;
_.totalSwap = null;
_.usedMemory = null;
_.usedSwap = null;
_.userCPU = null;
_.waitCPU = null;
function $clinit_PlatformMetricsSummary$CPUMetric(){
  $clinit_PlatformMetricsSummary$CPUMetric = nullMethod;
  Idle = new PlatformMetricsSummary$CPUMetric_0('Idle', 0, 'CpuPerc.idle');
  System = new PlatformMetricsSummary$CPUMetric_0('System', 1, 'CpuPerc.sys');
  User = new PlatformMetricsSummary$CPUMetric_0('User', 2, 'CpuPerc.user');
  Wait = new PlatformMetricsSummary$CPUMetric_0('Wait', 3, 'CpuPerc.wait');
  $VALUES_108 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$CPUMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$CPUMetric, [Idle, System, User, Wait]);
}

function PlatformMetricsSummary$CPUMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_117(name_0){
  $clinit_PlatformMetricsSummary$CPUMetric();
  return valueOf(($clinit_PlatformMetricsSummary$CPUMetric$Map() , $MAP_108), name_0);
}

function values_111(){
  $clinit_PlatformMetricsSummary$CPUMetric();
  return $VALUES_108;
}

defineSeed(1435, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$CPUMetric]), PlatformMetricsSummary$CPUMetric_0);
_.property = null;
var $VALUES_108, Idle, System, User, Wait;
function $clinit_PlatformMetricsSummary$CPUMetric$Map(){
  $clinit_PlatformMetricsSummary$CPUMetric$Map = nullMethod;
  $MAP_108 = createValueOfMap(($clinit_PlatformMetricsSummary$CPUMetric() , $VALUES_108));
}

var $MAP_108;
function $clinit_PlatformMetricsSummary$MemoryMetric(){
  $clinit_PlatformMetricsSummary$MemoryMetric = nullMethod;
  ActualUsed = new PlatformMetricsSummary$MemoryMetric_0('ActualUsed', 0, 'Native.MemoryInfo.actualUsed');
  Used = new PlatformMetricsSummary$MemoryMetric_0('Used', 1, 'Native.MemoryInfo.used');
  ActualFree = new PlatformMetricsSummary$MemoryMetric_0('ActualFree', 2, 'Native.MemoryInfo.actualFree');
  Free = new PlatformMetricsSummary$MemoryMetric_0('Free', 3, 'Native.MemoryInfo.free');
  Total = new PlatformMetricsSummary$MemoryMetric_0('Total', 4, 'Native.MemoryInfo.total');
  $VALUES_109 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$MemoryMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$MemoryMetric, [ActualUsed, Used, ActualFree, Free, Total]);
}

function PlatformMetricsSummary$MemoryMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_118(name_0){
  $clinit_PlatformMetricsSummary$MemoryMetric();
  return valueOf(($clinit_PlatformMetricsSummary$MemoryMetric$Map() , $MAP_109), name_0);
}

function values_112(){
  $clinit_PlatformMetricsSummary$MemoryMetric();
  return $VALUES_109;
}

defineSeed(1437, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$MemoryMetric]), PlatformMetricsSummary$MemoryMetric_0);
_.property = null;
var $VALUES_109, ActualFree, ActualUsed, Free, Total, Used;
function $clinit_PlatformMetricsSummary$MemoryMetric$Map(){
  $clinit_PlatformMetricsSummary$MemoryMetric$Map = nullMethod;
  $MAP_109 = createValueOfMap(($clinit_PlatformMetricsSummary$MemoryMetric() , $VALUES_109));
}

var $MAP_109;
function $clinit_PlatformMetricsSummary$SwapMetric(){
  $clinit_PlatformMetricsSummary$SwapMetric = nullMethod;
  Used_0 = new PlatformMetricsSummary$SwapMetric_0('Used', 0, 'Native.SwapInfo.used');
  Free_0 = new PlatformMetricsSummary$SwapMetric_0('Free', 1, 'Native.SwapInfo.free');
  Total_0 = new PlatformMetricsSummary$SwapMetric_0('Total', 2, 'Native.SwapInfo.total');
  $VALUES_110 = initValues(_3Lorg_rhq_core_domain_resource_composite_PlatformMetricsSummary$SwapMetric_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$PlatformMetricsSummary$SwapMetric, [Used_0, Free_0, Total_0]);
}

function PlatformMetricsSummary$SwapMetric_0(enum$name, enum$ordinal, property){
  Enum_0.call(this, enum$name, enum$ordinal);
  this.property = property;
}

function valueOf_119(name_0){
  $clinit_PlatformMetricsSummary$SwapMetric();
  return valueOf(($clinit_PlatformMetricsSummary$SwapMetric$Map() , $MAP_110), name_0);
}

function values_113(){
  $clinit_PlatformMetricsSummary$SwapMetric();
  return $VALUES_110;
}

defineSeed(1439, 49, makeCastMap([Q$Serializable, Q$Comparable, Q$Enum, Q$PlatformMetricsSummary$SwapMetric]), PlatformMetricsSummary$SwapMetric_0);
_.property = null;
var $VALUES_110, Free_0, Total_0, Used_0;
function $clinit_PlatformMetricsSummary$SwapMetric$Map(){
  $clinit_PlatformMetricsSummary$SwapMetric$Map = nullMethod;
  $MAP_110 = createValueOfMap(($clinit_PlatformMetricsSummary$SwapMetric() , $VALUES_110));
}

var $MAP_110;
function deserialize_361(streamReader, instance){
  setActualFreeMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setActualUsedMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setFreeMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setFreeSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setIdleCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setMetricsAvailable(instance, $readBoolean(streamReader));
  setResource_20(instance, dynamicCast($readObject(streamReader), Q$Resource));
  setSystemCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setTotalMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setTotalSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUsedMemory(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUsedSwap(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setUserCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
  setWaitCPU(instance, dynamicCast($readObject(streamReader), Q$MeasurementData));
}

function instantiate_349(streamReader){
  return new PlatformMetricsSummary_0;
}

function setActualFreeMemory(instance, value){
  instance.actualFreeMemory = value;
}

function setActualUsedMemory(instance, value){
  instance.actualUsedMemory = value;
}

function setFreeMemory(instance, value){
  instance.freeMemory = value;
}

function setFreeSwap(instance, value){
  instance.freeSwap = value;
}

function setIdleCPU(instance, value){
  instance.idleCPU = value;
}

function setMetricsAvailable(instance, value){
  instance.metricsAvailable = value;
}

function setResource_20(instance, value){
  instance.resource = value;
}

function setSystemCPU(instance, value){
  instance.systemCPU = value;
}

function setTotalMemory(instance, value){
  instance.totalMemory = value;
}

function setTotalSwap(instance, value){
  instance.totalSwap = value;
}

function setUsedMemory(instance, value){
  instance.usedMemory = value;
}

function setUsedSwap(instance, value){
  instance.usedSwap = value;
}

function setUserCPU(instance, value){
  instance.userCPU = value;
}

function setWaitCPU(instance, value){
  instance.waitCPU = value;
}

function $getMTBF(this$static){
  if (this$static.failures <= 1) {
    return P0_longLit;
  }
  return this$static.current == ($clinit_AvailabilityType() , UP)?div(sub(this$static.upTime, sub(this$static.now, this$static.lastChange)), fromInt(this$static.failures - 1)):div(this$static.upTime, fromInt(this$static.failures - 1));
}

function $getMTTR(this$static){
  if (this$static.failures <= 0) {
    return P0_longLit;
  }
  return this$static.current == ($clinit_AvailabilityType() , DOWN_0)?this$static.failures > 1?div(sub(this$static.downTime, sub(this$static.now, this$static.lastChange)), fromInt(this$static.failures - 1)):P0_longLit:div(this$static.downTime, fromInt(this$static.failures));
}

function ResourceComposite_1(resource, availability){
  ResourceComposite_2.call(this, resource, availability, new ResourcePermission_0);
}

function ResourceComposite_2(resource, availability, resourcePermission){
  this.resource = resource;
  this.parent_0 = null;
  this.availability = availability;
  this.resourcePermission = resourcePermission;
}

defineSeed(1449, 1, makeCastMap([Q$Serializable, Q$ResourceComposite]), ResourceComposite_1);
function $getKey(this$static){
  var b, node, node$iterator;
  if (null == this$static.key) {
    b = new StringBuilder_0;
    $append_9(b, this$static.clusterGroupId);
    for (node$iterator = new AbstractList$IteratorImpl_0(this$static.hierarchy); node$iterator.i < node$iterator.this$0_0.size_1();) {
      node = dynamicCast($next_0(node$iterator), Q$ClusterKey$Node);
      $append_1(b.data_0, '::');
      $append_12(b, node.resourceTypeId + ':' + node.resourceKey);
    }
    this$static.key = $toString_1(b.data_0);
  }
  return this$static.key;
}

function ClusterKey_0(clusterResourceGroupId){
  this.clusterGroupId = clusterResourceGroupId;
  this.hierarchy = new ArrayList_0;
}

function ClusterKey_1(parentKey, childResourceTypeId, childResourceKey){
  var rootClusterNodes;
  rootClusterNodes = parentKey.hierarchy;
  this.clusterGroupId = parentKey.clusterGroupId;
  this.hierarchy = new ArrayList_2(rootClusterNodes);
  $add_3(this.hierarchy, new ClusterKey$Node_0(childResourceTypeId, childResourceKey));
}

defineSeed(1463, 1, makeCastMap([Q$Serializable, Q$ClusterKey]), ClusterKey_0, ClusterKey_1);
_.equals$ = function equals_111(o){
  var that;
  if (this === o)
    return true;
  if (!instanceOf(o, Q$ClusterKey))
    return false;
  that = dynamicCast(o, Q$ClusterKey);
  if (!$equals_6($getKey(this), $getKey(that)))
    return false;
  return true;
}
;
_.hashCode$ = function hashCode_111(){
  return getHashCode_0($getKey(this));
}
;
_.toString$ = function toString_181(){
  return $getKey(this);
}
;
_.clusterGroupId = 0;
_.hierarchy = null;
_.key = null;
function ClusterKey$Node_0(resourceTypeId, resourceKey){
  this.resourceTypeId = resourceTypeId;
  this.resourceKey = $replace_1(resourceKey, ':', '%3a');
}

defineSeed(1464, 1, makeCastMap([Q$Serializable, Q$ClusterKey$Node]), ClusterKey$Node_0);
_.toString$ = function toString_182(){
  return this.resourceTypeId + ':' + this.resourceKey;
}
;
_.resourceKey = null;
_.resourceTypeId = 0;
function serialize_315(streamWriter, instance){
  $writeInt(streamWriter, instance.clusterGroupId);
  $writeObject(streamWriter, instance.hierarchy);
  $writeString(streamWriter, instance.key);
}

function serialize_316(streamWriter, instance){
  serialize_10(streamWriter, instance);
}

function serialize_317(streamWriter, instance){
  $writeString(streamWriter, instance.resourceKey);
  $writeInt(streamWriter, instance.resourceTypeId);
}

function $setDescription_4(this$static, description){
  this$static.description = description;
}

function $setName_9(this$static, name_0){
  this$static.name_0 = name_0;
}

function $getNextCalculationTime(this$static){
  var mt, ri;
  ri = valueOf_45(this$static.recalculationInterval);
  if (!ri || eq(ri.value_0, P0_longLit)) {
    return valueOf_45(P0_longLit);
  }
   else {
    if (this$static.lastCalculationTime) {
      return valueOf_45(add(this$static.lastCalculationTime.value_0, ri.value_0));
    }
     else {
      mt = this$static.modifiedTime;
      return valueOf_45(add(mt?mt.value_0:fromDouble(currentTimeMillis0()), ri.value_0));
    }
  }
}

function $setDescription_5(this$static, description){
  this$static.description = description;
}

function $setExpression(this$static, expression){
  this$static.expression = expression;
}

function $setId_5(this$static, id){
  this$static.id = id;
}

function $setName_10(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setRecalculationInterval(this$static, recalculationInterval){
  this$static.recalculationInterval = recalculationInterval.value_0;
}

function $setRecursive(this$static, recursive){
  this$static.recursive = recursive;
}

function $setDescription_6(this$static, description){
  this$static.description = description;
}

function $setId_6(this$static, id){
  this$static.id = id;
}

function $setName_11(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setAutoGroupParentResource(this$static, autoGroupParentResource){
  this$static.autoGroupParentResource = autoGroupParentResource;
}

function $setGroupCategory(this$static, groupCategory){
  this$static.groupCategory = groupCategory;
}

function $setId_7(this$static, id){
  this$static.id = id;
}

function $setRecursive_0(this$static, recursive){
  this$static.recursive = recursive;
}

function $setResourceType_1(this$static, resourceType){
  this$static.resourceType = resourceType;
  !resourceType?$setGroupCategory(this$static, ($clinit_GroupCategory() , MIXED_0)):$setGroupCategory(this$static, ($clinit_GroupCategory() , COMPATIBLE));
}

function $setTags_0(this$static, tags){
  this$static.tags = tags;
}

function ResourceGroup_2(name_0){
  this.name_0 = name_0;
  $$init_16(this);
  this.resourceType = null;
  $setGroupCategory(this, ($clinit_GroupCategory() , MIXED_0));
}

defineSeed(1481, 1471, makeCastMap([Q$Serializable, Q$Group, Q$ResourceGroup]), ResourceGroup_2);
function ClusterFlyweight_0(){
  this.children_0 = new ArrayList_1(0);
}

defineSeed(1484, 1, makeCastMap([Q$Serializable, Q$ClusterFlyweight]), ClusterFlyweight_0);
_.equals$ = function equals_115(obj_0){
  var other;
  if (this === obj_0) {
    return true;
  }
  if (!instanceOf(obj_0, Q$ClusterFlyweight)) {
    return false;
  }
  other = dynamicCast(obj_0, Q$ClusterFlyweight);
  if (this.groupId != other.groupId) {
    return false;
  }
  if (!this.clusterKey) {
    if (other.clusterKey) {
      return false;
    }
  }
   else if (!$equals_42(this.clusterKey, other.clusterKey)) {
    return false;
  }
  return true;
}
;
_.hashCode$ = function hashCode_115(){
  var result;
  result = 31 + this.groupId;
  result = 31 * result + (!this.clusterKey?0:$hashCode_27(this.clusterKey));
  return result;
}
;
_.toString$ = function toString_187(){
  var builder;
  builder = new StringBuilder_0;
  $append_12($append_11($append_12($append_12(($append_1(builder.data_0, 'ClusterFlyweight [name=') , builder), this.name_0), ', clusterKey='), this.clusterKey), ']');
  return $toString_1(builder.data_0);
}
;
_.clusterKey = null;
_.clusterSize = 0;
_.groupId = 0;
_.members_0 = 0;
_.name_0 = null;
function deserialize_381(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_369(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_resource_group_composite_ClusterFlyweight_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ClusterFlyweight, size, 0);
}

function deserialize_382(streamReader, instance){
  setChildren_0(instance, dynamicCast($readObject(streamReader), Q$List));
  setClusterKey_0(instance, dynamicCast($readObject(streamReader), Q$ClusterKeyFlyweight));
  setClusterSize(instance, $readInt(streamReader));
  setGroupId_1(instance, $readInt(streamReader));
  setMembers(instance, $readInt(streamReader));
  setName_47(instance, $getString(streamReader, $readInt(streamReader)));
}

function instantiate_370(streamReader){
  return new ClusterFlyweight_0;
}

function setChildren_0(instance, value){
  instance.children_0 = value;
}

function setClusterKey_0(instance, value){
  instance.clusterKey = value;
}

function setClusterSize(instance, value){
  instance.clusterSize = value;
}

function setGroupId_1(instance, value){
  instance.groupId = value;
}

function setMembers(instance, value){
  instance.members_0 = value;
}

function setName_47(instance, value){
  instance.name_0 = value;
}

function $equals_42(this$static, o){
  var node;
  if (this$static === o) {
    return true;
  }
  if (!instanceOf(o, Q$ClusterKeyFlyweight)) {
    return false;
  }
  node = dynamicCast(o, Q$ClusterKeyFlyweight);
  if (this$static.resourceTypeId != node.resourceTypeId) {
    return false;
  }
  if (this$static.resourceKey != null?!$equals_6(this$static.resourceKey, node.resourceKey):node.resourceKey != null) {
    return false;
  }
  return true;
}

function $hashCode_27(this$static){
  var result;
  result = this$static.resourceTypeId;
  result = 31 * result + (this$static.resourceKey != null?getHashCode_0(this$static.resourceKey):0);
  return result;
}

function ClusterKeyFlyweight_0(){
}

defineSeed(1487, 1, makeCastMap([Q$Serializable, Q$ClusterKeyFlyweight]), ClusterKeyFlyweight_0);
_.equals$ = function equals_116(o){
  return $equals_42(this, o);
}
;
_.hashCode$ = function hashCode_116(){
  return $hashCode_27(this);
}
;
_.toString$ = function toString_188(){
  return 'ClusterKeyFlyweight[type=' + this.resourceTypeId + ',key=' + this.resourceKey + ']';
}
;
_.resourceKey = null;
_.resourceTypeId = 0;
function deserialize_383(streamReader, instance){
  setResourceKey_0(instance, $getString(streamReader, $readInt(streamReader)));
  setResourceTypeId_6(instance, $readInt(streamReader));
}

function instantiate_371(streamReader){
  return new ClusterKeyFlyweight_0;
}

function setResourceKey_0(instance, value){
  instance.resourceKey = value;
}

function setResourceTypeId_6(instance, value){
  instance.resourceTypeId = value;
}

function ResourceGroupAvailability_0(){
}

defineSeed(1489, 1, makeCastMap([Q$Serializable, Q$ResourceGroupAvailability]), ResourceGroupAvailability_0);
_.endTime = null;
_.groupAvailabilityType = null;
_.resourceGroupId = 0;
_.startTime = null;
function deserialize_384(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_372(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_resource_group_composite_ResourceGroupAvailability_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ResourceGroupAvailability, size, 0);
}

function deserialize_385(streamReader, instance){
  setEndTime_2(instance, dynamicCast($readObject(streamReader), Q$Long));
  setGroupAvailabilityType(instance, dynamicCast($readObject(streamReader), Q$ResourceGroupComposite$GroupAvailabilityType));
  setResourceGroupId(instance, $readInt(streamReader));
  setStartTime_2(instance, dynamicCast($readObject(streamReader), Q$Long));
}

function instantiate_373(streamReader){
  return new ResourceGroupAvailability_0;
}

function setEndTime_2(instance, value){
  instance.endTime = value;
}

function setGroupAvailabilityType(instance, value){
  instance.groupAvailabilityType = value;
}

function setResourceGroupId(instance, value){
  instance.resourceGroupId = value;
}

function setStartTime_2(instance, value){
  instance.startTime = value;
}

function ResourceGroupComposite_1(explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup){
  ResourceGroupComposite_2.call(this, explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup, new ResourcePermission_0);
}

function ResourceGroupComposite_2(explicitCount, explicitDown, explicitUnknown, explicitDisabled, implicitCount, implicitDown, implicitUnknown, implicitDisabled, resourceGroup, permissions){
  this.implicitCount = implicitCount.value_0;
  this.implicitDown = implicitDown.value_0;
  this.implicitUnknown = implicitUnknown.value_0;
  this.implicitDisabled = implicitDisabled.value_0;
  this.explicitCount = explicitCount.value_0;
  this.explicitDown = explicitDown.value_0;
  this.explicitUnknown = explicitUnknown.value_0;
  this.explicitDisabled = explicitDisabled.value_0;
  this.resourceGroup = resourceGroup;
  if (this.resourceGroup.groupCategory == ($clinit_GroupCategory() , COMPATIBLE)) {
    this.category = COMPATIBLE;
  }
   else if (this.resourceGroup.groupCategory == MIXED_0) {
    this.category = MIXED_0;
  }
   else {
    throw new IllegalArgumentException_1('Unknown category [' + this.resourceGroup.groupCategory + '] for ResourceGroup [' + this.resourceGroup.name_0 + ']');
  }
  this.resourceFacets = null;
  this.resourcePermission = permissions;
}

defineSeed(1492, 1, makeCastMap([Q$Serializable, Q$ResourceGroupComposite]), ResourceGroupComposite_1);
function deserialize_387(streamReader, instance){
}

function instantiate_375(streamReader){
  var ordinal, values;
  ordinal = $readInt(streamReader);
  values = ($clinit_ResourceGroupComposite$GroupAvailabilityType() , $clinit_ResourceGroupComposite$GroupAvailabilityType() , $VALUES_112);
  return values[ordinal];
}

function $setName_12(this$static, name_0){
  this$static.name_0 = name_0;
}

function $setNamespace(this$static, namespace){
  this$static.namespace = namespace;
}

function $setSemantic(this$static, semantic){
  this$static.semantic = semantic;
}

function Tag_1(tag){
  if (tag.indexOf(':') != -1) {
    this.namespace = $split(tag, ':', 0)[0];
    tag = $split(tag, ':', 0)[1];
  }
  if (tag.indexOf('=') != -1) {
    this.semantic = $split(tag, '=', 0)[0];
    tag = $split(tag, '=', 0)[1];
  }
  this.name_0 = tag;
}

defineSeed(1509, 1, makeCastMap([Q$Serializable, Q$Tag]), Tag_1);
function $setMajor(this$static, major){
  this$static.major = major;
}

function $setMicro(this$static, micro){
  this$static.micro = micro;
}

function $setMinor(this$static, minor){
  this$static.minor = minor;
}

function OrderingField_1(field, ordering){
  this.field = field;
  this.ordering = ordering?ordering:($clinit_PageOrdering() , ASC);
}

defineSeed(1516, 1, makeCastMap([Q$Serializable, Q$OrderingField]), OrderingField_1);
function $addDefaultOrderingField(this$static, defaultField, defaultPageOrdering){
  var ordering, ordering$iterator;
  if (this$static.orderingFields.size_0 >= 3) {
    return;
  }
  for (ordering$iterator = $listIterator(this$static.orderingFields, 0); ordering$iterator.currentNode != ordering$iterator.this$0.header;) {
    ordering = dynamicCast($next_5(ordering$iterator), Q$OrderingField);
    if ($equals_6(ordering.field, defaultField)) {
      return;
    }
  }
  $add_7(this$static.orderingFields, new OrderingField_1(defaultField, defaultPageOrdering));
}

function $initDefaultOrderingField(this$static, defaultField, defaultPageOrdering){
  if (this$static.orderingFields.size_0 > 0) {
    return;
  }
  $addDefaultOrderingField(this$static, defaultField, defaultPageOrdering);
}

function $removeOrderingField(this$static, doomedField){
  var field, i;
  for (i = $listIterator(this$static.orderingFields, 0); i.currentNode != i.this$0.header;) {
    field = dynamicCast($next_5(i), Q$OrderingField);
    if ($equals_6(field.field, doomedField)) {
      $remove_13(i);
      break;
    }
  }
}

function getExplicitPageControl(firstRecord, recordCount){
  var pc;
  pc = new PageControl_1(-1, recordCount);
  pc.firstRecord = valueOf_44(firstRecord);
  return pc;
}

defineSeed(1518, 1, makeCastMap([Q$Serializable, Q$Cloneable, Q$PageControl]));
_.setPageSize = function setPageSize(pageSize){
  this.pageNumber = pageSize != 0 && pageSize != -1?~~((this.firstRecord?this.firstRecord.value_0:this.pageNumber * this.pageSize) / pageSize):0;
  this.pageSize = pageSize;
}
;
function $getTotalSize(this$static){
  return max_1(this$static.size_0, this$static.totalSize);
}

function $setPageControl_0(this$static, pageControl){
  this$static.pageControl = pageControl;
}

function $setTotalSize(this$static, totalSize){
  this$static.isUnbounded = false;
  this$static.totalSize = totalSize;
}

function $setUnbounded(this$static, isUnbounded){
  this$static.isUnbounded = isUnbounded;
}

function PageList_1(collection, pageControl){
  ArrayList_2.call(this, collection);
  this.isUnbounded = true;
  this.pageControl = pageControl;
}

function PageList_2(pageControl){
  $$init(this);
  this.isUnbounded = true;
  this.pageControl = pageControl;
}

defineSeed(1520, 293, makeCastMap([Q$Serializable, Q$Cloneable, Q$Iterable, Q$AbstractCollection, Q$AbstractList, Q$ArrayList, Q$Collection, Q$List, Q$RandomAccess, Q$PageList]), PageList_1, PageList_2);
function deserialize_398(streamReader, instance){
  deserialize_32(streamReader, instance);
}

function instantiate_386(streamReader){
  var size;
  size = $readInt(streamReader);
  return initDim(_3Lorg_rhq_core_domain_util_PageList_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$PageList, size, 0);
}

function useForwardSlash(path){
  $clinit_StringUtils();
  return null != path?$replace_0(path, 92, 47):null;
}

defineSeed(1527, 1518, makeCastMap([Q$Serializable, Q$Cloneable, Q$PageControl]));
_.setPageSize = function setPageSize_1(pageSize){
  throw new UnsupportedOperationException_1('page size cannot be changed from -1 for an UnlimitedPageControl.');
}
;
function unwrapArray(input){
  var i, output;
  if (input == null) {
    return null;
  }
  output = initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, input.length, 1);
  for (i = 0; i < input.length; ++i) {
    output[i] = input[i].value_0;
  }
  return output;
}

function unwrapCollection(input){
  var intermediate;
  if (!input) {
    return null;
  }
  intermediate = dynamicCast($toArray(input, initDim(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, input.map_0.size_1(), 0)), Q$Integer_$1);
  return unwrapArray(intermediate);
}

function $createContent(this$static, viewName){
  var canvas, logoutView;
  if ($equals_6(viewName, ($clinit_DashboardsView() , VIEW_ID_16).name_0)) {
    canvas = new DashboardsView_0;
  }
   else if ($equals_6(viewName, ($clinit_InventoryView() , VIEW_ID_21).name_0)) {
    canvas = new InventoryView_0;
  }
   else if ($equals_6(viewName, ($clinit_ResourceTopView() , VIEW_ID_24).name_0)) {
    canvas = new ResourceTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_ResourceGroupTopView() , VIEW_ID_22).name_0)) {
    canvas = new ResourceGroupTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_ReportTopView() , VIEW_ID_27).name_0)) {
    canvas = new ReportTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_BundleTopView() , VIEW_ID_15).name_0)) {
    canvas = new BundleTopView_0;
  }
   else if ($equals_6(viewName, ($clinit_AdministrationView() , VIEW_ID).name_0)) {
    canvas = new AdministrationView_0;
  }
   else if ($equals_6(viewName, ($clinit_HelpView() , VIEW_ID_20).name_0)) {
    canvas = new HelpView_0;
  }
   else if ($equals_6(viewName, 'LogOut')) {
    logout();
    $hide(this$static.rootCanvas);
    logoutView = new LoginView_0;
    canvas = logoutView;
    $showLoginDialog(logoutView);
  }
   else 
    $equals_6(viewName, ($clinit_TaggedView() , VIEW_ID_31).name_0)?(canvas = new TaggedView_0):$equals_6(viewName, 'Subsystems')?(canvas = new AlertHistoryView_0):$equals_6(viewName, ($clinit_TestTopView() , VIEW_ID_32).name_0)?(canvas = new TestTopView_0):(canvas = null);
  return canvas;
}

defineSeed(1538, 1, makeCastMap([Q$RunAsyncCallback]));
_.onSuccess = function onSuccess_0(){
  this.this$1.currentCanvas = $createContent(this.this$1.this$0, this.this$1.currentViewId.path);
  !!this.this$1.currentCanvas && $addChild(this.val$contentCanvas, this.this$1.currentCanvas);
  this.val$contentCanvas.markForRedraw_0();
  $render(this.this$1, this.val$viewPath);
  info_0('Time to Load first codesplit fragment: ' + toString_8(sub(fromDouble(currentTimeMillis0()), this.val$startTime)) + ' ms.');
}
;
function $setupWindow(this$static, title, item){
  $isCreated_1(this$static)?$setProperty_3(this$static, 'title', title):(this$static.config_0['title'] = title , undefined);
  $setShowMinimizeButton(this$static, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setShowMaximizeButton(this$static, TRUE);
  $setIsModal(this$static, TRUE);
  $setShowModalMask(this$static, TRUE);
  $setAutoSize(this$static, TRUE);
  $setAutoCenter(this$static, TRUE);
  $setShowResizer(this$static, TRUE);
  $setCanDragResize_0(this$static, TRUE);
  $centerInPage(this$static);
  $addCloseClickHandler(this$static, new ErrorMessageWindow$1_0(this$static));
  $addItem(this$static, item);
}

function ErrorMessageWindow_0(title, item){
  Window_1.call(this);
  $setupWindow(this, title, item);
}

function ErrorMessageWindow_1(title, message){
  $clinit_BaseWidget();
  var htmlPane;
  Window_1.call(this);
  htmlPane = new HTMLPane_0;
  $setMargin(htmlPane, valueOf_44(10));
  $isCreated_1(htmlPane)?$setProperty_0(htmlPane, 'defaultWidth', 500):(htmlPane.config_0['defaultWidth'] = 500 , undefined);
  $isCreated_1(htmlPane)?$setProperty_0(htmlPane, 'defaultHeight', 400):(htmlPane.config_0['defaultHeight'] = 400 , undefined);
  $isCreated_1(htmlPane)?$setProperty_3(htmlPane, 'contents', message):(htmlPane.config_0['contents'] = message , undefined);
  $setupWindow(this, title, htmlPane);
}

defineSeed(1540, 448, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), ErrorMessageWindow_0, ErrorMessageWindow_1);
function ErrorMessageWindow$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1541, 1, makeCastMap([Q$EventHandler, Q$CloseClickHandler]), ErrorMessageWindow$1_0);
_.onCloseClick_0 = function onCloseClick(event_0){
  $markForDestroy(this.this$0);
}
;
_.this$0 = null;
function getAlertNotificationResultIcon(status_0){
  !status_0 && (status_0 = ($clinit_ResultState() , UNKNOWN));
  switch (status_0.ordinal) {
    case 0:
      return getAvailabilityIcon(($clinit_Boolean() , $clinit_Boolean() , TRUE));
    case 2:
      return getAvailabilityIcon(($clinit_Boolean() , $clinit_Boolean() , FALSE));
    case 1:
      return 'subsystems/availability/availability_yellow_16.png';
    case 3:
      return '[skin]/actions/redo.png';
    case 4:
    default:return getAvailabilityIcon(null);
  }
}

function getAvailabilityGroupLargeIcon(groupAvailType){
  switch (groupAvailType.ordinal) {
    case 0:
      return 'subsystems/availability/availability_grey_24.png';
    case 2:
      return 'subsystems/availability/availability_red_24.png';
    case 3:
      return 'subsystems/availability/availability_yellow_24.png';
    case 4:
      return 'subsystems/availability/availability_orange_24.png';
    default:return 'subsystems/availability/availability_green_24.png';
  }
}

function getAvailabilityIcon(status_0){
  var availType;
  availType = !status_0?($clinit_AvailabilityType() , UNKNOWN_0):($clinit_Boolean() , TRUE) == status_0?($clinit_AvailabilityType() , UP):($clinit_AvailabilityType() , DOWN_0);
  return getAvailabilityIconFromAvailTypeAndSize(availType, false);
}

function getAvailabilityIconFromAvailTypeAndSize(availType, isLarge){
  var color;
  !availType && (availType = ($clinit_AvailabilityType() , UNKNOWN_0));
  color = null;
  switch (availType.ordinal) {
    case 1:
      color = 'green';
      break;
    case 0:
      color = 'red';
      break;
    case 3:
      color = 'orange';
      break;
    case 2:
      color = 'grey';
  }
  return 'subsystems/availability/availability_' + color + '_' + (isLarge?'24':'16') + '.png';
}

function getAvailabilityLargeIcon(status_0){
  var availType;
  availType = !status_0?($clinit_AvailabilityType() , UNKNOWN_0):($clinit_Boolean() , TRUE) == status_0?($clinit_AvailabilityType() , UP):($clinit_AvailabilityType() , DOWN_0);
  return getAvailabilityIconFromAvailTypeAndSize(availType, true);
}

function getClusteredResourceIcon(category){
  var categoryName;
  categoryName = null;
  switch (category.ordinal) {
    case 0:
      {
        categoryName = 'Platform';
        break;
      }

    case 1:
      {
        categoryName = 'Server';
        break;
      }

    case 2:
      {
        categoryName = 'Service';
        break;
      }

  }
  return 'resources/' + categoryName + '_Group_16.png';
}

function getDriftCategoryIcon(category){
  if (!category) {
    return 'subsystems/drift/Drift_new_16.png';
  }
  switch (category.ordinal) {
    case 0:
      return 'subsystems/drift/Drift_add_16.png';
    case 1:
      return 'subsystems/drift/Drift_change_16.png';
    case 2:
      return 'subsystems/drift/Drift_remove_16.png';
  }
  return null;
}

function getEventSeverityIcon(severity){
  var icon;
  icon = '';
  if (severity) {
    switch (severity.ordinal) {
      case 0:
        icon = '_debug';
        break;
      case 1:
        icon = '_info';
        break;
      case 2:
        icon = '_warning';
        break;
      case 3:
        icon = '_error';
        break;
      case 4:
        icon = '_fatal';
    }
  }
  return 'subsystems/event/Events' + icon + '_16.png';
}

function getGroupIcon(groupType){
  var category;
  category = groupType == ($clinit_GroupCategory() , COMPATIBLE)?'Cluster':'Group';
  return 'types/' + category + '_up_16.png';
}

function getGroupLargeIcon(groupType){
  var category;
  category = groupType == ($clinit_GroupCategory() , COMPATIBLE)?'Cluster':'Group';
  return 'types/' + category + '_up_24.png';
}

function getOperationResultsIcon(status_0){
  var icon;
  icon = '';
  if (status_0) {
    switch (status_0.ordinal) {
      case 0:
        icon = '_inprogress';
        break;
      case 1:
        icon = '_ok';
        break;
      case 2:
        icon = '_failed';
        break;
      case 3:
        icon = '_cancel';
    }
  }
  return 'subsystems/control/Operation' + icon + '_16.png';
}

function getPluginConfigurationIcon(updateStatus){
  if (updateStatus) {
    switch (updateStatus.ordinal) {
      case 1:
        {
          return 'subsystems/inventory/Connection_ok_16.png';
        }

      case 2:
        {
          return 'subsystems/inventory/Connection_failed_16.png';
        }

      case 0:
        {
          return 'subsystems/inventory/Connection_inprogress_16.png';
        }

      case 3:
        return 'subsystems/inventory/Connection_16.png';
    }
  }
  return 'subsystems/inventory/Connection_16.png';
}

function getResourceConfigurationIcon(updateStatus){
  if (updateStatus) {
    switch (updateStatus.ordinal) {
      case 1:
        {
          return 'subsystems/configure/Configure_ok_16.png';
        }

      case 2:
        {
          return 'subsystems/configure/Configure_failed_16.png';
        }

      case 0:
        {
          return 'subsystems/configure/Configure_inprogress_16.png';
        }

      case 3:
        return 'subsystems/configure/Configure_16.png';
    }
  }
  return 'subsystems/configure/Configure_16.png';
}

function getAlertDetailLink(entityContext, alertId){
  var baseLink, link;
  baseLink = getEntityTabLink(entityContext, 'Alerts', 'History');
  link = baseLink + '/' + alertId;
  return link;
}

function getAutoClusterTabLink(autoClusterGroupId, tabName, subTabName){
  return '#ResourceGroup/AutoCluster/' + autoClusterGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getAutoGroupTabLink(autoGroupId, tabName, subTabName){
  return '#Resource/AutoGroup/' + autoGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getBundleDestinationLink(bundleId, bundleDestinationId){
  return '#Bundles/Bundle/' + bundleId + '/destinations' + (bundleDestinationId == 0?'':'/' + bundleDestinationId);
}

function getBundleVersionLink(bundleId, bundleVersionId){
  return '#Bundles/Bundle/' + bundleId + '/versions' + (bundleVersionId == 0?'':'/' + bundleVersionId);
}

function getDriftCarouselDriftLink(resourceId, driftDefId, driftId){
  driftId.indexOf('0id_') == 0 || (driftId = '0id_' + driftId);
  return '#Resource/' + resourceId + '/Drift/Definitions/' + driftDefId + '/Drift/' + driftId;
}

function getEntityTabLink(entityContext, tabName, subTabName){
  var link;
  switch (entityContext.type_0.ordinal) {
    case 0:
      link = getResourceTabLink(entityContext.resourceId, tabName, subTabName);
      break;
    case 2:
      ($clinit_EntityContext$Type() , ResourceGroup) == entityContext.type_0 && entityContext.isAutoGroup?(link = getAutoGroupTabLink(entityContext.groupId, tabName, subTabName)):ResourceGroup == entityContext.type_0 && entityContext.isAutoCluster?(link = getAutoClusterTabLink(entityContext.groupId, tabName, subTabName)):(link = getResourceGroupTabLink(entityContext.groupId, tabName, subTabName));
      break;
    case 4:
      if ($equals_6(tabName, 'Alerts') && $equals_6(subTabName, 'Definitions')) {
        link = '#Reports/Subsystems/AlertDefinitions';
      }
       else if ($equals_6(tabName, 'Alerts') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/RecentAlerts';
      }
       else if ($equals_6(tabName, 'Operations') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/RecentOperations';
      }
       else if ($equals_6(tabName, 'Configuration') && $equals_6(subTabName, 'History')) {
        link = '#Reports/Subsystems/ConfigurationHistoryView';
      }
       else {
        throw new IllegalArgumentException_1('Subsystem link not supported for tab ' + tabName + '>' + subTabName + '.');
      }

      break;
    default:throw new IllegalArgumentException_1('Unsupported entity context type: ' + entityContext.type_0);
  }
  return link;
}

function getGroupOperationHistoryLink(group, groupOperationHistoryId){
  return getEntityTabLink(forGroup_0(group), 'Operations', 'History') + '/' + groupOperationHistoryId;
}

function getGroupPluginConfigurationUpdateHistoryLink(group, groupUpdateHistoryId){
  return groupUpdateHistoryId?getEntityTabLink(group, 'Inventory', 'ConnectionSettingsHistory') + '/' + groupUpdateHistoryId:getEntityTabLink(group, 'Inventory', 'ConnectionSettingsHistory');
}

function getGroupResourceConfigurationUpdateHistoryLink(group, groupUpdateHistoryId){
  return groupUpdateHistoryId?getEntityTabLink(group, 'Configuration', 'History') + '/' + groupUpdateHistoryId:getEntityTabLink(group, 'Configuration', 'History');
}

function getHref(url, value){
  var result;
  result = '<a href="' + url + '">' + value + '<\/a>';
  return result;
}

function getResourceGroupTabLink(resourceGroupId, tabName, subTabName){
  return '#ResourceGroup/' + resourceGroupId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getResourceTabLink(resourceId, tabName, subTabName){
  return '#Resource/' + resourceId + '/' + tabName + (null == subTabName?'':'/' + subTabName);
}

function getSubsystemAlertDefinitionLink(resourceId, alertDefinitionId){
  var link;
  link = '#Resource/' + resourceId + '/Alerts/Definitions/' + alertDefinitionId;
  return link;
}

function getTagLink(tag){
  return tag == null?'#Reports/Subsystems/Tags':'#Reports/Subsystems/Tags/' + tag;
}

function $getString_0(this$static, arg0){
  var target;
  target = dynamicCast(this$static.cache.get_2(arg0), Q$String);
  if (target != null) {
    return target;
  }
  if ($equals_6(arg0, 'view_help_section_1_item_count')) {
    this$static.cache.put('view_help_section_1_item_count', '3');
    return '3';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_1')) {
    this$static.cache.put('view_help_section_1_propTitle_1', 'Frequently Asked Questions (FAQ) ');
    return 'Frequently Asked Questions (FAQ) ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_2')) {
    this$static.cache.put('view_help_section_1_propTitle_2', 'Documentation Set ');
    return 'Documentation Set ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propTitle_3')) {
    this$static.cache.put('view_help_section_1_propTitle_3', 'API Javadoc ');
    return 'API Javadoc ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_1')) {
    this$static.cache.put('view_help_section_1_propUrl_1', 'https://docs.jboss.org/author/display/RHQ/FAQ');
    return 'https://docs.jboss.org/author/display/RHQ/FAQ';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_2')) {
    this$static.cache.put('view_help_section_1_propUrl_2', 'https://docs.jboss.org/author/display/RHQ/User+Documentation');
    return 'https://docs.jboss.org/author/display/RHQ/User+Documentation';
  }
  if ($equals_6(arg0, 'view_help_section_1_propUrl_3')) {
    this$static.cache.put('view_help_section_1_propUrl_3', 'https://docs.jboss.org/author/display/RHQ/API+Documentation');
    return 'https://docs.jboss.org/author/display/RHQ/API+Documentation';
  }
  if ($equals_6(arg0, 'view_help_section_1_title')) {
    this$static.cache.put('view_help_section_1_title', 'Documentation');
    return 'Documentation';
  }
  if ($equals_6(arg0, 'view_help_section_2_item_count')) {
    this$static.cache.put('view_help_section_2_item_count', '4');
    return '4';
  }
  if ($equals_6(arg0, 'view_help_section_2_propIcon_3')) {
    this$static.cache.put('view_help_section_2_propIcon_3', '[SKIN]/../actions/help.png');
    return '[SKIN]/../actions/help.png';
  }
  if ($equals_6(arg0, 'view_help_section_2_propIcon_4')) {
    this$static.cache.put('view_help_section_2_propIcon_4', '[SKIN]/../actions/help.png');
    return '[SKIN]/../actions/help.png';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_1')) {
    this$static.cache.put('view_help_section_2_propTitle_1', 'Demo: All Demos ');
    return 'Demo: All Demos ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_2')) {
    this$static.cache.put('view_help_section_2_propTitle_2', 'Demo: Bundle Provisioning ');
    return 'Demo: Bundle Provisioning ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_3')) {
    this$static.cache.put('view_help_section_2_propTitle_3', 'How to build Group Definitions ');
    return 'How to build Group Definitions ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propTitle_4')) {
    this$static.cache.put('view_help_section_2_propTitle_4', 'How to use the Search Bar ');
    return 'How to use the Search Bar ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_1')) {
    this$static.cache.put('view_help_section_2_propUrl_1', 'https://docs.jboss.org/author/display/RHQ/Demos');
    return 'https://docs.jboss.org/author/display/RHQ/Demos';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_2')) {
    this$static.cache.put('view_help_section_2_propUrl_2', 'http://management-platform.blogspot.com/2011/01/bundle-provisioning-via-rhq.html ');
    return 'http://management-platform.blogspot.com/2011/01/bundle-provisioning-via-rhq.html ';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_3')) {
    this$static.cache.put('view_help_section_2_propUrl_3', 'https://docs.jboss.org/author/display/RHQ/Group+Definitions');
    return 'https://docs.jboss.org/author/display/RHQ/Group+Definitions';
  }
  if ($equals_6(arg0, 'view_help_section_2_propUrl_4')) {
    this$static.cache.put('view_help_section_2_propUrl_4', 'https://docs.jboss.org/author/display/RHQ/Search');
    return 'https://docs.jboss.org/author/display/RHQ/Search';
  }
  if ($equals_6(arg0, 'view_help_section_2_title')) {
    this$static.cache.put('view_help_section_2_title', 'Tutorial');
    return 'Tutorial';
  }
  if ($equals_6(arg0, 'view_help_section_count')) {
    this$static.cache.put('view_help_section_count', '2');
    return '2';
  }
  throw new MissingResourceException_0("Cannot find constant '" + arg0 + "'; expecting a method name");
}

function $view_adminRoles_permissions_illegalDeselectionDueToCorrespondingWritePermSelection(arg0){
  return arg0 + ' read permission cannot be deselected, unless the ' + arg0 + ' write permission, which implies the read permission, is deselected first.';
}

function $view_admin_downloads_connectors_help(arg0){
  return 'Connectors are software that is needed in order for some products to be manageable by ' + arg0 + '. You install connectors into some managed products so ' + arg0 + ' agents can talk to them. See the documentation for more information.';
}

function $view_admin_landing(arg0){
  return 'From this section, the ' + arg0 + ' global settings can be administered. This includes configuring security, setting up plugins, and managing ' + arg0 + ' Servers and Agents.';
}

function $clinit_PermissionsLoader(){
  $clinit_PermissionsLoader = nullMethod;
  $clinit_CoreGUI();
}

function $loadExplicitGlobalPermissions(callback){
  $getExplicitGlobalPermissions(dynamicCast(secure(getInstance_34(), -1), Q$AuthorizationGWTServiceAsync), new PermissionsLoader$1_0(callback));
}

function $processFailure(msg, caught){
  var options, severity;
  options = of(($clinit_Message$Option() , BackgroundJobResult));
  severity = ($clinit_Message$Severity() , Error_2);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_5(msg, caught, severity, options));
}

function $onSuccess_2(this$static, result){
  this$static.val$callback.onPermissionsLoaded(result);
}

function PermissionsLoader$1_0(val$callback){
  this.val$callback = val$callback;
}

defineSeed(1562, 1, {}, PermissionsLoader$1_0);
_.onFailure = function onFailure_3(caught){
  $processFailure(($clinit_PermissionsLoader() , 'Nepoda\u0159ilo se na\u010D\xEDst Va\u0161e glob\xE1ln\xED povolen\xED - p\u0159\xEDstup nepovolen.'), caught);
  this.val$callback.onPermissionsLoaded(null);
}
;
_.onSuccess_0 = function onSuccess_3(result){
  $onSuccess_2(this, dynamicCast(result, Q$Set));
}
;
_.val$callback = null;
function PopupWindow_0(canvas){
  $clinit_BaseWidget();
  Window_1.call(this);
  $setTitle(this, ($clinit_CoreGUI() , 'Detaily'));
  $setShowMinimizeButton(this, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setShowMaximizeButton(this, TRUE);
  $setIsModal(this, TRUE);
  $setShowModalMask(this, TRUE);
  $isCreated_1(this)?$setProperty_0(this, 'width', 600):(this.config_0['width'] = 600 , undefined);
  $isCreated_1(this)?$setProperty_0(this, 'height', 400):(this.config_0['height'] = 400 , undefined);
  $setAutoCenter(this, TRUE);
  $setShowResizer(this, TRUE);
  $setCanDragResize_0(this, TRUE);
  $centerInPage(this);
  $addCloseClickHandler(this, new PopupWindow$1_0(this));
  !!canvas && $addItem(this, canvas);
}

defineSeed(1563, 448, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout]), PopupWindow_0);
function PopupWindow$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1564, 1, makeCastMap([Q$EventHandler, Q$CloseClickHandler]), PopupWindow$1_0);
_.onCloseClick_0 = function onCloseClick_0(event_0){
  $markForDestroy(this.this$0);
}
;
_.this$0 = null;
function ViewChangedException_1(obsoleteView){
  $fillInStackTrace(this);
  this.obsoleteView = obsoleteView != null?obsoleteView:'?';
}

defineSeed(1580, 6, makeCastMap([Q$Serializable, Q$Exception, Q$RuntimeException, Q$Throwable, Q$ViewChangedException]), ViewChangedException_1);
function $getCurrent(this$static){
  return this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId);
}

function $getCurrentAsInt(this$static){
  return __parseAndValidateInt((this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId)).path);
}

function $getNext(this$static){
  return dynamicCast($get_0(this$static.viewPath, this$static.index_0 + 1), Q$ViewId);
}

function $getParentViewPath(this$static){
  return $getPathToIndex(this$static, this$static.index_0 - 1);
}

function $getPathToCurrent(this$static){
  return $getPathToIndex(this$static, this$static.index_0);
}

function $getPathToIndex(this$static, endIndex){
  var i, path;
  path = '';
  for (i = 0; i < endIndex; ++i) {
    i > 0 && (path += '/');
    path += dynamicCast($get_0(this$static.viewPath, i), Q$ViewId).path;
  }
  return path;
}

function $getViewForIndex(this$static, index){
  return dynamicCast($get_0(this$static.viewPath, index), Q$ViewId);
}

function $isCurrent(this$static, providedViewId){
  return !(this$static.viewPath.size_0 <= this$static.index_0 || !providedViewId || !$equals_43(this$static.index_0 >= this$static.viewPath.size_0?null:dynamicCast($get_0(this$static.viewPath, this$static.index_0), Q$ViewId), providedViewId));
}

function $isEnd(this$static){
  return this$static.viewPath.size_0 <= this$static.index_0;
}

function $isNext(this$static, providedViewId){
  return this$static.index_0 + 1 < this$static.viewPath.size_0 && !!providedViewId && $equals_43(dynamicCast($get_0(this$static.viewPath, this$static.index_0 + 1), Q$ViewId), providedViewId);
}

function $addSection_0(this$static, treeGrid){
  var section, sectionName, sectionTitle;
  sectionName = $getAttributeAsString(getOrCreateRef_14($getAttributeAsJavaScriptObject_2(getOrCreateRef_13($getAttributeAsJavaScriptObject_1(treeGrid, 'data')))), 'name');
  sectionTitle = $getAttributeAsString(getOrCreateRef_14($getAttributeAsJavaScriptObject_2(getOrCreateRef_13($getAttributeAsJavaScriptObject_1(treeGrid, 'data')))), 'title');
  $put_1(this$static.treeGrids, sectionName, treeGrid);
  $addCellClickHandler(treeGrid, new AbstractSectionedLeftNavigationView$2_0(this$static, treeGrid, sectionName));
  section = new SectionStackSection_1(sectionTitle);
  $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $addItemJS(section, $getOrCreateJsObj_0(treeGrid));
  $addSection(this$static.sectionStack, section);
}

function $buildTreeGridForSection(navigationSection){
  var i, item, navigationItems, navigationItemsSize, rootNode, tree, treeGrid, treeNode, treeNodes;
  treeGrid = new TreeGrid_0;
  $setLeaveScrollbarGap(treeGrid, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setShowHeader_0(treeGrid, FALSE);
  $setAttribute_24(treeGrid, 'selectionType', ($clinit_SelectionStyle() , SINGLE).value_0, true);
  navigationItems = navigationSection.navigationItems;
  treeNodes = initDim(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, navigationItems.array.length, 0);
  for (i = 0 , navigationItemsSize = navigationItems.array.length; i < navigationItemsSize; ++i) {
    item = dynamicCast((checkIndex(i, navigationItems.array.length) , navigationItems.array[i]), Q$NavigationItem);
    treeNode = new EnhancedTreeNode_1(item.viewName.name_0, item.viewName.title_0, initValues(_3Lcom_smartgwt_client_widgets_tree_TreeNode_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$TreeNode_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$TreeNode, []));
    $setAttribute_13(treeNode, 'icon', item.icon_0);
    $setAttribute_8(treeNode, 'enabled', item.enabled?TRUE:FALSE);
    setCheck(treeNodes, i, treeNode);
  }
  rootNode = new EnhancedTreeNode_1(navigationSection.viewName.name_0, navigationSection.viewName.title_0, treeNodes);
  tree = new Tree_0;
  $setAttribute(tree, rootNode.jsObj);
  $setAttribute_20(treeGrid, 'data', !tree?null:$getOrCreateJsObj(tree), true);
  return treeGrid;
}

function $decorateWithTitleBar(viewName, pageBody){
  var iconPath, vLayout;
  vLayout = new EnhancedVLayout_0;
  $isCreated_1(vLayout)?$setProperty_3(vLayout, 'width', '100%'):(vLayout.config_0['width'] = '100%' , undefined);
  $isCreated_1(vLayout)?$setProperty_3(vLayout, 'height', '100%'):(vLayout.config_0['height'] = '100%' , undefined);
  iconPath = viewName.icon_0.icon24x24Path != null?viewName.icon_0.icon24x24Path:viewName.icon_0.icon16x16Path;
  $addMember(vLayout, new TitleBar_1(viewName.title_0, iconPath));
  $addMember(vLayout, pageBody);
  return vLayout;
}

function $destroyCurrentContent(this$static){
  var children;
  if (this$static.contentCanvas) {
    while ((children = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static.contentCanvas, 'children'))).length > 0) {
      children[0].destroy_0();
    }
  }
}

function $initSectionPageTreeGrids(this$static){
  var name_0, name$iterator, treeGrid;
  for (name$iterator = $iterator($keySet(this$static.treeGrids)); name$iterator.val$outerIter.hasNext();) {
    name_0 = dynamicCast($next_1(name$iterator), Q$String);
    treeGrid = dynamicCast($get_4(this$static.treeGrids, name_0), Q$TreeGrid);
    $deselectAllRecords(treeGrid);
    this$static.currentSectionViewId = null;
    this$static.currentPageViewId = null;
  }
}

function $onInit_0(this$static){
  $onInit(this$static);
  $onInit_Layout(this$static);
  $isCreated_1(this$static)?$setProperty_3(this$static, 'width', '100%'):(this$static.config_0['width'] = '100%' , undefined);
  $isCreated_1(this$static)?$setProperty_3(this$static, 'height', '100%'):(this$static.config_0['height'] = '100%' , undefined);
  this$static.contentCanvas = new Canvas_1;
  $setWidth_0(this$static.contentCanvas, '*');
  $setAttribute_24(this$static.contentCanvas, 'height', '100%', true);
  this$static.sectionStack = new SectionStack_0;
  $setShowResizeBar(this$static.sectionStack, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setAttribute_24(this$static.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setWidth(this$static.sectionStack, 250);
  $setAttribute_24(this$static.sectionStack, 'height', '100%', true);
  $loadExplicitGlobalPermissions(($clinit_PermissionsLoader() , new AbstractSectionedLeftNavigationView$1_0(this$static)));
}

function $renderContentView(this$static, viewPath){
  var content_0, item, pageName, section, sectionName, viewFactory;
  this$static.currentSectionViewId = viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId);
  this$static.currentPageViewId = dynamicCast($get_0(viewPath.viewPath, viewPath.index_0 + 1), Q$ViewId);
  sectionName = this$static.currentSectionViewId.path;
  pageName = this$static.currentPageViewId.path;
  section = dynamicCast(this$static.sectionsByName.get_2(sectionName), Q$NavigationSection);
  if (!section) {
    throw new IllegalStateException_1('Invalid section: ' + sectionName);
  }
  item = dynamicCast($get_4(section.navigationItemsByName, pageName), Q$NavigationItem);
  if (!item) {
    throw new IllegalStateException_1('Invalid page: ' + pageName);
  }
  item.refreshRequired && (this$static.currentPageViewId = null);
  $selectSectionPageTreeGridNode(this$static, sectionName, pageName);
  viewFactory = item.viewFactory;
  if (viewFactory) {
    $destroyCurrentContent(this$static);
    content_0 = viewFactory.createView();
    if (content_0) {
      $setContent(this$static, content_0);
      instanceOf(content_0, Q$BookmarkableView) && dynamicCast(content_0, Q$BookmarkableView).renderView($next_6((++viewPath.index_0 , viewPath)));
    }
  }
}

function $selectSectionPageTreeGridNode(this$static, sectionName, pageName){
  var name_0, name$iterator, node, tree, treeGrid, self_0, nodeJS, self_1;
  for (name$iterator = $iterator($keySet(this$static.treeGrids)); name$iterator.val$outerIter.hasNext();) {
    name_0 = dynamicCast($next_1(name$iterator), Q$String);
    treeGrid = dynamicCast($get_4(this$static.treeGrids, name_0), Q$TreeGrid);
    if ($equals_6(name_0, sectionName)) {
      tree = getOrCreateRef_13($getAttributeAsJavaScriptObject_1(treeGrid, 'data'));
      node = (self_0 = tree.getOrCreateJsObj() , nodeJS = self_0.find(sectionName + '/' + pageName) , nodeJS == null?null:getOrCreateRef_14(nodeJS));
      node?(self_1 = treeGrid.getOrCreateJsObj() , self_1.selectSingleRecord(node.getJsObj()) , undefined):$handleError_0(($clinit_CoreGUI() , 'Nezn\xE1m\xE9 jm\xE9no str\xE1nky [' + ($clinit_Enhanced() , pageName) + '] pro sekci [' + sectionName + '] - URL je neplatn\xE9.'), null);
    }
     else {
      $deselectAllRecords(treeGrid);
    }
  }
}

function $setContent(this$static, newContent){
  var decoratedContent;
  if (instanceOf(newContent, Q$HasViewName)) {
    decoratedContent = $decorateWithTitleBar(dynamicCast(newContent, Q$HasViewName).getViewName(), newContent);
    $addChild(this$static.contentCanvas, decoratedContent);
  }
   else {
    $addChild(this$static.contentCanvas, newContent);
  }
  this$static.contentCanvas.markForRedraw_0();
  this$static.currentContent = newContent;
}

function AbstractSectionedLeftNavigationView_0(viewId){
  $clinit_BaseWidget();
  EnhancedHLayout_0.call(this);
  this.treeGrids = new LinkedHashMap_0;
  this.globalPermissions_0 = noneOf(Lorg_rhq_core_domain_authz_Permission_2_classLit);
  this.viewId = viewId;
}

defineSeed(1585, 1543, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$Enhanced, Q$EnhancedHLayout]));
_.isInitialized_0 = function isInitialized(){
  return this.initialized;
}
;
_.onInit = function onInit_7(){
  $onInit_0(this);
}
;
_.renderView = function renderView_0(viewPath){
  if (!$isCurrent(viewPath, this.currentSectionViewId) || !$isNext(viewPath, this.currentPageViewId)) {
    if (viewPath.viewPath.size_0 <= viewPath.index_0) {
      $destroyCurrentContent(this);
      $setContent(this, this.defaultView());
      $initSectionPageTreeGrids(this);
    }
     else {
      $renderContentView(this, viewPath);
    }
  }
   else {
    if (instanceOf(this.currentContent, Q$BookmarkableView)) {
      dynamicCast(this.currentContent, Q$BookmarkableView).renderView($next_6((++viewPath.index_0 , viewPath)));
    }
     else if (instanceOf(this.currentContent, Q$RefreshableView) && $isDrawn(this.currentContent).value_0) {
      debug('Refreshing data for [' + this.currentContent.___clazz$.typeName + ']...');
      dynamicCast(this.currentContent, Q$RefreshableView).refresh_0();
    }
  }
}
;
_.contentCanvas = null;
_.currentContent = null;
_.currentPageViewId = null;
_.currentSectionViewId = null;
_.initialized = false;
_.sectionStack = null;
_.sectionsByName = null;
_.viewId = null;
function AdministrationView_0(){
  $clinit_AdministrationView();
  AbstractSectionedLeftNavigationView_0.call(this, VIEW_ID.name_0);
}

defineSeed(1584, 1585, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$Enhanced, Q$EnhancedHLayout]), AdministrationView_0);
_.defaultView = function defaultView(){
  var vLayout, titleBar, productInfo, label;
  return vLayout = new EnhancedVLayout_0 , $isCreated_1(vLayout)?$setProperty_3(vLayout, 'width', '100%'):(vLayout.config_0['width'] = '100%' , undefined) , titleBar = new TitleBar_1(($clinit_Enhanced() , 'Administrace'), ($clinit_IconEnum() , ADMIN).icon24x24Path) , $addMember(vLayout, titleBar) , productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , label = new Label_4($view_admin_landing(productInfo.shortName)) , $setPadding(label, valueOf_44(10)) , $addMember(vLayout, label) , vLayout;
}
;
_.getNavigationSections = function getNavigationSections(){
  var configurationSection, contentSection, sections, securitySection, topologySection, usersItem, rolesItem, productInfo, isRHQ, remoteAgentInstallItem, serversItem, agentsItem, affinityGroupsItem, partitionEventsItem, navigationItems, systemSettingsItem, alertTemplatesItem, driftTemplatesItem, metricTemplatesItem, ignoreResourceTypesItem, downloadsItem, agentPluginsItem, serverPluginsItem, contentSourcesItem, reposItem;
  sections = new ArrayList_0;
  securitySection = (usersItem = new NavigationItem_2(($clinit_UsersView() , VIEW_ID_14), new AdministrationView$1_0(this)) , rolesItem = new NavigationItem_2(($clinit_RolesView() , VIEW_ID_5), new AdministrationView$2_0(this)) , new NavigationSection_0(SECTION_SECURITY_VIEW_ID, initValues(_3Lorg_rhq_enterprise_gui_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [usersItem, rolesItem])));
  setCheck(sections.array, sections.size_0++, securitySection);
  topologySection = (productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , isRHQ = !!productInfo && $equals_6('RHQ', productInfo.shortName) , remoteAgentInstallItem = new NavigationItem_3(($clinit_RemoteAgentInstallView() , VIEW_ID_4), new AdministrationView$3_0, this.globalPermissions_0.contains_0(($clinit_Permission() , MANAGE_SETTINGS))) , serversItem = new NavigationItem_3(($clinit_ServerTableView() , VIEW_ID_13), new AdministrationView$4_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , agentsItem = new NavigationItem_3(($clinit_AgentTableView() , VIEW_ID_11), new AdministrationView$5_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , affinityGroupsItem = new NavigationItem_3(($clinit_AffinityGroupTableView() , VIEW_ID_10), new AdministrationView$6_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , partitionEventsItem = new NavigationItem_3(($clinit_PartitionEventTableView() , VIEW_ID_12), new AdministrationView$7_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , navigationItems = new ArrayList_2(new Arrays$ArrayList_0(initValues(_3Lorg_rhq_enterprise_gui_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [serversItem, agentsItem, affinityGroupsItem, partitionEventsItem]))) , isRHQ && (setCheck(navigationItems.array, navigationItems.size_0++, remoteAgentInstallItem) , true) , new NavigationSection_0(SECTION_TOPOLOGY_VIEW_ID, dynamicCast($toArray_1(navigationItems, initValues(_3Lorg_rhq_enterprise_gui_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [])), Q$NavigationItem_$1)));
  setCheck(sections.array, sections.size_0++, topologySection);
  configurationSection = (systemSettingsItem = new NavigationItem_3(($clinit_SystemSettingsView() , VIEW_ID_3), new AdministrationView$8_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , systemSettingsItem.refreshRequired = true , alertTemplatesItem = new NavigationItem_2(($clinit_AlertDefinitionTemplateTypeView() , VIEW_ID_6), new AdministrationView$9_0) , alertTemplatesItem.refreshRequired = true , driftTemplatesItem = new NavigationItem_2(($clinit_DriftDefinitionTemplateTypeView() , VIEW_ID_7), new AdministrationView$10_0) , driftTemplatesItem.refreshRequired = true , metricTemplatesItem = new NavigationItem_2(($clinit_MetricTemplateTypeView() , VIEW_ID_9), new AdministrationView$11_0) , metricTemplatesItem.refreshRequired = true , ignoreResourceTypesItem = new NavigationItem_2(($clinit_IgnoreResourceTypesView() , VIEW_ID_8), new AdministrationView$12_0) , ignoreResourceTypesItem.refreshRequired = true , downloadsItem = new NavigationItem_2(($clinit_DownloadsView() , VIEW_ID_1), new AdministrationView$13_0) , agentPluginsItem = new NavigationItem_3(($clinit_AgentPluginTableView() , VIEW_ID_0), new AdministrationView$14_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , serverPluginsItem = new NavigationItem_3(($clinit_ServerPluginTableView() , VIEW_ID_2), new AdministrationView$15_0, this.globalPermissions_0.contains_0(MANAGE_SETTINGS)) , new NavigationSection_0(SECTION_CONFIGURATION_VIEW_ID, initValues(_3Lorg_rhq_enterprise_gui_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [systemSettingsItem, alertTemplatesItem, driftTemplatesItem, metricTemplatesItem, ignoreResourceTypesItem, downloadsItem, agentPluginsItem, serverPluginsItem])));
  setCheck(sections.array, sections.size_0++, configurationSection);
  contentSection = (contentSourcesItem = new NavigationItem_3(PAGE_CONTENT_SOURCES_VIEW_ID, new AdministrationView$16_0, this.globalPermissions_0.contains_0(MANAGE_REPOSITORIES)) , reposItem = new NavigationItem_2(PAGE_REPOS_VIEW_ID, new AdministrationView$17_0) , new NavigationSection_0(SECTION_CONTENT_VIEW_ID, initValues(_3Lorg_rhq_enterprise_gui_coregui_client_components_view_NavigationItem_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$NavigationItem_$1]), Q$NavigationItem, [contentSourcesItem, reposItem])));
  setCheck(sections.array, sections.size_0++, contentSection);
  return sections;
}
;
function AdministrationView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1586, 1, {}, AdministrationView$1_0);
_.createView = function createView(){
  return new UsersView_0(this.this$0.globalPermissions_0.contains_0(($clinit_Permission() , MANAGE_SECURITY)));
}
;
_.this$0 = null;
function AdministrationView$10_0(){
}

defineSeed(1587, 1, {}, AdministrationView$10_0);
_.createView = function createView_0(){
  return new DriftDefinitionTemplateTypeView_0;
}
;
function AdministrationView$11_0(){
}

defineSeed(1588, 1, {}, AdministrationView$11_0);
_.createView = function createView_1(){
  return new MetricTemplateTypeView_0;
}
;
function AdministrationView$12_0(){
}

defineSeed(1589, 1, {}, AdministrationView$12_0);
_.createView = function createView_2(){
  return new IgnoreResourceTypesView_0;
}
;
function AdministrationView$13_0(){
}

defineSeed(1590, 1, {}, AdministrationView$13_0);
_.createView = function createView_3(){
  return new DownloadsView_0;
}
;
function AdministrationView$14_0(){
}

defineSeed(1591, 1, {}, AdministrationView$14_0);
_.createView = function createView_4(){
  return new AgentPluginTableView_0;
}
;
function AdministrationView$15_0(){
}

defineSeed(1592, 1, {}, AdministrationView$15_0);
_.createView = function createView_5(){
  return new ServerPluginTableView_0;
}
;
function AdministrationView$16_0(){
}

defineSeed(1593, 1, {}, AdministrationView$16_0);
_.createView = function createView_6(){
  return new FullHTMLPane_0('/rhq/content/listContentProviders-plain.xhtml');
}
;
function AdministrationView$17_0(){
}

defineSeed(1594, 1, {}, AdministrationView$17_0);
_.createView = function createView_7(){
  return new FullHTMLPane_0('/rhq/content/listRepos-plain.xhtml');
}
;
function AdministrationView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1595, 1, {}, AdministrationView$2_0);
_.createView = function createView_8(){
  return new RolesView_0(this.this$0.globalPermissions_0.contains_0(($clinit_Permission() , MANAGE_SECURITY)));
}
;
_.this$0 = null;
function AdministrationView$3_0(){
}

defineSeed(1596, 1, {}, AdministrationView$3_0);
_.createView = function createView_9(){
  return new RemoteAgentInstallView_0;
}
;
function AdministrationView$4_0(){
}

defineSeed(1597, 1, {}, AdministrationView$4_0);
_.createView = function createView_10(){
  return new ServerTableView_0(null, false);
}
;
function AdministrationView$5_0(){
}

defineSeed(1598, 1, {}, AdministrationView$5_0);
_.createView = function createView_11(){
  return new AgentTableView_0(null, false);
}
;
function AdministrationView$6_0(){
}

defineSeed(1599, 1, {}, AdministrationView$6_0);
_.createView = function createView_12(){
  return new AffinityGroupTableView_0;
}
;
function AdministrationView$7_0(){
}

defineSeed(1600, 1, {}, AdministrationView$7_0);
_.createView = function createView_13(){
  return new PartitionEventTableView_0(($clinit_PartitionEventTableView() , VIEW_ID_12).title_0);
}
;
function AdministrationView$8_0(){
}

defineSeed(1601, 1, {}, AdministrationView$8_0);
_.createView = function createView_14(){
  return new SystemSettingsView_0;
}
;
function AdministrationView$9_0(){
}

defineSeed(1602, 1, {}, AdministrationView$9_0);
_.createView = function createView_15(){
  return new AlertDefinitionTemplateTypeView_0;
}
;
function EnhancedVLayout_1(){
  $clinit_BaseWidget();
  VLayout_1.call(this, 10);
}

defineSeed(1604, 449, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), EnhancedVLayout_1);
function $prepareDetailsSection(stack, plugin){
  var ampsItem, descItem, displayNameItem, enabledItem, form, img, kindItem, md5Item, mtimeItem, nameItem, pathItem, section, versionItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  $setWrapItemTitles(form, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_1(form)?$setProperty_0(form, 'numCols', 4):(form.config_0['numCols'] = 4 , undefined);
  nameItem = new StaticTextItem_2('name', ($clinit_Enhanced() , 'Jm\xE9no'));
  $setValue_7(nameItem, plugin.name_0);
  displayNameItem = new StaticTextItem_2('displayName', 'Jm\xE9no displeje');
  $setValue_7(displayNameItem, plugin.displayName);
  versionItem = new StaticTextItem_2('version', 'Verze');
  $setValue_7(versionItem, plugin.version_0);
  md5Item = new StaticTextItem_2('MD5', 'MD5');
  $setValue_7(md5Item, plugin.md5);
  pathItem = new StaticTextItem_2('path', 'Cesta');
  $setValue_7(pathItem, plugin.path);
  ampsItem = new StaticTextItem_2('ampsVersion', 'AMPS Verze');
  $setValue_7(ampsItem, plugin.ampsVersion);
  descItem = new StaticTextItem_2('desc', 'Popis');
  $setValue_7(descItem, plugin.description);
  mtimeItem = new StaticTextItem_2('mtime', 'Naposledy modifikov\xE1no');
  $setValue_7(mtimeItem, format_30(valueOf_45(plugin.mtime), ($clinit_TimestampCellFormatter() , DATE_TIME_FORMAT_MEDIUM)));
  kindItem = new StaticTextItem_2('kind', 'Druh');
  switch (plugin.deployment.ordinal) {
    case 0:
      $setValue_7(kindItem, 'Agent');
      break;
    case 1:
      $setValue_7(kindItem, 'Server');
  }
  enabledItem = new CanvasItem_2('enabled', 'Povoleno?');
  img = new Img_2(getAvailabilityIcon(plugin.enabled?TRUE:FALSE), 16, 16);
  $setAttribute_28(enabledItem, 'canvas', !img?null:$getOrCreateJsObj_0(img));
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [displayNameItem, nameItem, versionItem, ampsItem, md5Item, kindItem, descItem, pathItem, mtimeItem, enabledItem]));
  section = new SectionStackSection_1('Detaily');
  $setExpanded(section, TRUE);
  $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $addSection(stack, section);
  return;
}

function $prepareHelpSection(stack, plugin){
  var help, section;
  if (plugin.help != null && plugin.help.length > 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , 'N\xE1pov\u011Bda'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    help = new Label_4(plugin.help);
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [help]));
    $addSection(stack, section);
  }
  return;
}

function AgentPluginDetailView_0(pluginId){
  $clinit_BaseWidget();
  EnhancedVLayout_0.call(this);
  this.pluginManager = dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync);
  this.pluginId = pluginId;
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
}

defineSeed(1603, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), AgentPluginDetailView_0);
_.onDraw_0 = function onDraw_2(){
  var sectionStack;
  sectionStack = new SectionStack_0;
  $setAttribute_24(sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $isCreated_1(sectionStack)?$setProperty_3(sectionStack, 'width', '100%'):(sectionStack.config_0['width'] = '100%' , undefined);
  $isCreated_1(sectionStack)?$setProperty_3(sectionStack, 'height', '100%'):(sectionStack.config_0['height'] = '100%' , undefined);
  $setAttribute_24(sectionStack, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
  $getAgentPlugin(this.pluginManager, this.pluginId, new AgentPluginDetailView$1_0(sectionStack));
  $addMember(this, sectionStack);
}
;
_.pluginId = 0;
function $onSuccess_10(this$static, plugin){
  $prepareDetailsSection(this$static.val$sectionStack, plugin);
  $prepareHelpSection(this$static.val$sectionStack, plugin);
}

function AgentPluginDetailView$1_0(val$sectionStack){
  this.val$sectionStack = val$sectionStack;
}

defineSeed(1605, 1, {}, AgentPluginDetailView$1_0);
_.onFailure = function onFailure_10(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_10(plugin){
  $onSuccess_10(this, dynamicCast(plugin, Q$Plugin));
}
;
_.val$sectionStack = null;
function $addExtraWidget(this$static, widget, aboveFooter){
  aboveFooter?$add_3(this$static.extraWidgetsAboveFooter, widget):$add_3(this$static.extraWidgetsInMainFooter, widget);
}

function $deleteSelectedRecords(this$static){
  var deletedRecordNames, listGrid, selectedRecordCount;
  listGrid = this$static.listGrid;
  selectedRecordCount = $getSelectedRecords(listGrid).length;
  deletedRecordNames = new ArrayList_1(selectedRecordCount);
  $removeSelectedData(listGrid, new Table$8_0(this$static, deletedRecordNames, selectedRecordCount), null);
}

function $getDeletedMessage(numDeleted){
  var num, thing;
  num = '' + numDeleted;
  thing = 1 == numDeleted?($clinit_Enhanced() , 'polo\u017Eka'):($clinit_Enhanced() , 'polo\u017Eky');
  return ($clinit_Enhanced() , num) + ' ' + thing + ' smaz\xE1no.';
}

function $setDataSource(this$static, dataSource){
  this$static.dataSource_1 = dataSource;
}

function $setHeaderIcon(this$static, headerIcon){
  this$static.headerIcons.size_0 > 0 && $clear_2(this$static.headerIcons);
  $add_3(this$static.headerIcons, headerIcon);
}

function $setListGridFields(this$static, forceIdField, fields){
  var dataSourceField, dataSourceFieldName, dataSourceFieldName$iterator, dataSourceFieldNames, dataSourceFieldNamesSet, dataSourceIdField, datasourceFieldTitle, destIndex, hideIdField, listGridField, listGridField$index, listGridField$max, listGridFieldTitle, listGridFieldsMap, listGridIdField, newFields;
  if (!this$static.getDataSource_0()) {
    throw new IllegalStateException_1('setListGridFields() called on ' + this$static.___clazz$.typeName + ', which is not a DataSource-backed Table.');
  }
  dataSourceFieldNames = $getFieldNames(this$static.getDataSource_0(), false);
  dataSourceFieldNamesSet = new LinkedHashSet_0;
  dataSourceFieldNamesSet.addAll(new Arrays$ArrayList_0(dataSourceFieldNames));
  listGridFieldsMap = new LinkedHashMap_0;
  for (listGridField$index = 0 , listGridField$max = fields.length; listGridField$index < listGridField$max; ++listGridField$index) {
    listGridField = fields[listGridField$index];
    $put_1(listGridFieldsMap, getAttribute(listGridField.jsObj, 'name'), listGridField);
  }
  $removeAll_0(dataSourceFieldNamesSet, $keySet(listGridFieldsMap));
  dataSourceIdField = $getField(this$static.getDataSource_0(), 'id');
  hideIdField = ($clinit_CoreGUI() , true) && !forceIdField;
  !!dataSourceIdField && hideIdField && $hideField(this$static.listGrid, 'id');
  listGridIdField = dynamicCast($get_4(listGridFieldsMap, 'id'), Q$ListGridField);
  !!listGridIdField && (listGridIdField.jsObj['showIf'] = hideIdField?'false':'true' , undefined);
  if (dataSourceFieldNamesSet.map_0.size_1() == 0) {
    $setAttribute_25(this$static.listGrid, 'fields', fields, true);
  }
   else {
    newFields = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.length + dataSourceFieldNamesSet.map_0.size_1(), 0);
    destIndex = 0;
    if (dataSourceFieldNamesSet.map_0.containsKey('id')) {
      datasourceFieldTitle = $getAttributeAsString($getField(this$static.getDataSource_0(), 'id'), 'title');
      listGridFieldTitle = datasourceFieldTitle != null?datasourceFieldTitle:($clinit_Enhanced() , 'ID');
      listGridIdField = new ListGridField_4('id', listGridFieldTitle, 55);
      $setAttribute_13(listGridIdField, 'type', ($clinit_ListGridFieldType() , INTEGER_0).value_0);
      $setAttribute_8(listGridIdField, 'canEdit', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
      listGridIdField.jsObj['showIf'] = hideIdField?'false':'true';
      setCheck(newFields, destIndex++, listGridIdField);
      dataSourceFieldNamesSet.map_0.remove_3('id') != null;
    }
    arraycopy(fields, 0, newFields, destIndex, fields.length);
    destIndex += fields.length;
    for (dataSourceFieldName$iterator = $iterator($keySet(dataSourceFieldNamesSet.map_0)); dataSourceFieldName$iterator.val$outerIter.hasNext();) {
      dataSourceFieldName = dynamicCast($next_1(dataSourceFieldName$iterator), Q$String);
      dataSourceField = $getField(this$static.getDataSource_0(), dataSourceFieldName);
      listGridField = new ListGridField_1(getAttribute(dataSourceField.jsObj, 'name'));
      $hideField(this$static.listGrid, dataSourceFieldName);
      listGridField.jsObj['showIf'] = 'false';
      setCheck(newFields, destIndex++, listGridField);
    }
    $setAttribute_25(this$static.listGrid, 'fields', newFields, true);
  }
}

function $setTableActionDisableOverride(this$static, disabled){
  this$static.tableActionDisableOverride = disabled;
  this$static.refreshTableInfo();
}

function $setTitleString(this$static, titleString){
  this$static.titleString = titleString;
  !!this$static.titleCanvas && $markForRedraw(this$static.titleCanvas);
}

function $updateTableAction(this$static, title, valueMap, tableAction){
  var info, info$iterator;
  if (title == null) {
    return;
  }
  for (info$iterator = new AbstractList$IteratorImpl_0(this$static.tableActions); info$iterator.i < info$iterator.this$0_0.size_1();) {
    info = dynamicCast($next_0(info$iterator), Q$Table$TableActionInfo);
    if ($equals_6(title, info.title_0)) {
      !!valueMap && (info.valueMap = valueMap);
      !!tableAction && (info.action = tableAction);
      this$static.initialized_0 && this$static.initialized && $drawFooter(this$static);
      break;
    }
  }
}

function Table_1(){
  $clinit_BaseWidget();
  Table_6.call(this, null, null, null, null, true);
}

function Table_2(tableTitle){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, null, null, true);
}

function Table_3(tableTitle, criteria){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, criteria, null, null, !criteria);
}

function Table_4(tableTitle, criteria, icon){
  Table_6.call(this, tableTitle, criteria, null, null, !criteria);
  this.titleIcon = icon;
}

function Table_5(tableTitle, criteria, sortSpecifiers, excludedFieldNames){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, criteria, sortSpecifiers, excludedFieldNames, !criteria);
}

function Table_7(tableTitle, autoFetchData){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, null, null, autoFetchData);
}

function Table_8(tableTitle, sortSpecifiers){
  $clinit_BaseWidget();
  Table_6.call(this, tableTitle, null, sortSpecifiers, null, true);
}

defineSeed(1609, 1543, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), Table_2);
_.getTitleFieldName = function getTitleFieldName(){
  return 'name';
}
;
function $buildDetailsView(this$static){
  var backButton, isEditable, verticalSpacer;
  $setAttribute_24(this$static.detailsView_0, 'width', '100%', true);
  $setAttribute_24(this$static.detailsView_0, 'height', '100%', true);
  isEditable = instanceOf(this$static.detailsView_0, Q$DetailsView) && dynamicCast(this$static.detailsView_0, Q$DetailsView).isEditable_0();
  if (!isEditable) {
    backButton = new BackButton_0(($clinit_Enhanced() , 'Zp\u011Bt na seznam'), this$static.basePath);
    $addMember(this$static.detailsHolder, backButton);
    verticalSpacer = new EnhancedVLayout_0;
    $isCreated_1(verticalSpacer)?$setProperty_0(verticalSpacer, 'height', 8):(verticalSpacer.config_0['height'] = 8 , undefined);
    $addMember(this$static.detailsHolder, verticalSpacer);
  }
  $addMember(this$static.detailsHolder, this$static.detailsView_0);
  $animateShow(this$static.detailsHolder, ($clinit_AnimationEffect() , WIPE));
}

function $configureTable(this$static){
  var field, grid;
  if (this$static.isDetailsEnabled()) {
    grid = this$static.listGrid;
    field = grid?$getField_1(grid, this$static.getDetailsLinkColumnName()):null;
    !!field && $setCellFormatter_0(field, this$static.getDetailsLinkColumnCellFormatter());
    $setListGridDoubleClickHandler(this$static, new AbstractTableSection$1_0(this$static));
  }
}

function $isInitialized(this$static){
  return this$static.initialized_0 && this$static.initialized;
}

function $newDetails(this$static){
  $clinit_CoreGUI();
  goToView(this$static.basePath + '/0', null, false);
}

function $onInit_2(this$static){
  $onInit_1(this$static);
  this$static.initialDisplay = true;
  this$static.detailsHolder = new EnhancedVLayout_0;
  $setAttribute_24(this$static.detailsHolder, 'align', ($clinit_VerticalAlignment() , TOP_2).value_0, true);
  $setMargin(this$static.detailsHolder, valueOf_44(4));
  this$static.detailsHolder.hide_0();
  $addMember(this$static, this$static.detailsHolder);
  !!this$static.detailsView_0 && $switchToDetailsView(this$static);
  this$static.initialized = true;
}

function $renderView_0(this$static, viewPath){
  var id;
  this$static.basePath = $getPathToIndex(viewPath, viewPath.index_0);
  if (viewPath.viewPath.size_0 <= viewPath.index_0) {
    $switchToTableView(this$static);
  }
   else {
    id = this$static.convertCurrentViewPathToID((viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId)).path);
    this$static.detailsView_0 = this$static.getDetailsView(id);
    instanceOf(this$static.detailsView_0, Q$BookmarkableView) && dynamicCast(this$static.detailsView_0, Q$BookmarkableView).renderView(viewPath);
    $switchToDetailsView(this$static);
  }
}

function $switchToDetailsView(this$static){
  var contents;
  contents = this$static.contents_0;
  if (contents) {
    if ($isVisible(contents)) {
      $animateHide_0(contents, ($clinit_AnimationEffect() , WIPE), new AbstractTableSection$3_0(this$static));
    }
     else {
      contents.hide_0();
      destroyMembers(this$static.detailsHolder);
      $buildDetailsView(this$static);
    }
  }
}

function $switchToTableView(this$static){
  var contents;
  contents = this$static.contents_0;
  if (contents) {
    if (this$static.initialDisplay) {
      this$static.initialDisplay = false;
    }
     else {
      debug('Refreshing data for Table [' + this$static.___clazz$.typeName + ']...');
      this$static.refresh_0();
    }
    if (!!this$static.detailsHolder && $isVisible(this$static.detailsHolder)) {
      $animateHide_0(this$static.detailsHolder, ($clinit_AnimationEffect() , WIPE), new AbstractTableSection$4_0(this$static, contents));
    }
     else {
      !!this$static.detailsHolder && destroyMembers(this$static.detailsHolder);
      $animateShow(contents, ($clinit_AnimationEffect() , WIPE));
    }
  }
}

function AbstractTableSection_0(tableTitle, criteria, sortSpecifiers){
  Table_6.call(this, tableTitle, criteria, sortSpecifiers, null, !criteria);
}

defineSeed(1608, 1609, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]));
_.configureTable = function configureTable_0(){
  $configureTable(this);
}
;
_.destroy_0 = function destroy_3(){
  this.initialized = false;
  $destroy_2(this);
}
;
_.getBasePath = function getBasePath(){
  return this.basePath;
}
;
_.getDetailsLinkColumnCellFormatter = function getDetailsLinkColumnCellFormatter(){
  return new AbstractTableSection$2_0(this);
}
;
_.getDetailsLinkColumnName = function getDetailsLinkColumnName(){
  return 'name';
}
;
_.isDetailsEnabled = function isDetailsEnabled(){
  return true;
}
;
_.isInitialized_0 = function isInitialized_1(){
  return this.initialized_0 && this.initialized;
}
;
_.onInit = function onInit_9(){
  $onInit_2(this);
}
;
_.renderView = function renderView_1(viewPath){
  $renderView_0(this, viewPath);
}
;
_.showDetails = function showDetails(record){
  var id;
  if (!record) {
    throw new IllegalArgumentException_1("'record' parameter is null.");
  }
  id = this.getId_0(record);
  this.showDetails_0(id);
}
;
_.basePath = null;
_.detailsHolder = null;
_.detailsView_0 = null;
_.escapeHtmlInDetailsLinkColumn = false;
_.initialDisplay = false;
_.initialized = false;
function $convertIDToCurrentViewPath(id){
  if (!id) {
    return '0';
  }
  return '' + id.value_0;
}

function $getId(this$static, record){
  var id, msg;
  id = valueOf_44(record?getAttributeAsInt(record.jsObj, 'id').value_0:0);
  if (!id) {
    msg = 'Z\xE1znam tabulky [' + ($clinit_Enhanced() , $toString_5(this$static.___clazz$)) + '] nem\xE1 atribut id. Pros\xEDm nahlaste tuto chybu.';
    $handleError_0(($clinit_CoreGUI() , msg), null);
    throw new IllegalStateException_1(msg);
  }
  return id;
}

function $showDetails(this$static, id){
  var msg;
  if (!!id && id.value_0 > 0) {
    $clinit_CoreGUI();
    goToView(this$static.getBasePath() + '/' + id, null, false);
  }
   else {
    msg = 'Nelze zobrazit detail pro [' + ($clinit_Enhanced() , $toString_5(this$static.___clazz$)) + ']. Neplatn\xE9 id: [' + (!id?'null':'' + id.value_0) + ']. Pros\xEDm nahlaste tuto chybu.';
    $handleError_0(($clinit_CoreGUI() , msg), null);
    throw new IllegalArgumentException_1(msg);
  }
}

function TableSection_0(tableTitle){
  $clinit_BaseWidget();
  Table_2.call(this, tableTitle);
}

function TableSection_1(tableTitle, criteria){
  Table_3.call(this, tableTitle, criteria);
}

function TableSection_2(tableTitle, criteria, sortSpecifiers){
  $clinit_BaseWidget();
  AbstractTableSection_0.call(this, tableTitle, criteria, sortSpecifiers);
}

function TableSection_3(tableTitle, criteria, sortSpecifiers, excludedFieldNames){
  $clinit_BaseWidget();
  Table_5.call(this, tableTitle, criteria, sortSpecifiers, excludedFieldNames);
}

defineSeed(1607, 1608, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]));
_.convertCurrentViewPathToID = function convertCurrentViewPathToID(path){
  return valueOf_44(__parseAndValidateInt(path));
}
;
_.convertIDToCurrentViewPath = function convertIDToCurrentViewPath(id){
  return $convertIDToCurrentViewPath(dynamicCast(id, Q$Integer));
}
;
_.getDetailsView = function getDetailsView(id){
  return this.getDetailsView_0(dynamicCast(id, Q$Integer));
}
;
_.getId_0 = function getId_3(record){
  return $getId(this, record);
}
;
_.showDetails_0 = function showDetails_0(id){
  $showDetails(this, dynamicCast(id, Q$Integer));
}
;
function $clinit_AgentPluginTableView(){
  $clinit_AgentPluginTableView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_0 = new ViewName_2('AgentPlugins', ($clinit_Enhanced() , 'Z\xE1suvn\xE9 moduly agent\u016F'), ($clinit_IconEnum() , PLUGIN_0));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_0;
}

function $getSelectedIds(selections){
  var i, ids, selection, selection$index, selection$max;
  if (selections == null) {
    return initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, 0, 1);
  }
  ids = initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, selections.length, 1);
  i = 0;
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids[i++] = getAttributeAsInt(selection.jsObj, 'id').value_0;
  }
  return ids;
}

function $getSelectedNames(selections){
  var ids, selection, selection$index, selection$max;
  if (selections == null) {
    return new ArrayList_1(0);
  }
  ids = new ArrayList_1(selections.length);
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    $add_3(ids, getAttribute(selection.jsObj, 'name'));
  }
  return ids;
}

function AgentPluginTableView_0(){
  $clinit_AgentPluginTableView();
  TableSection_0.call(this, null);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setDataSource(this, new AgentPluginTableView$AgentPluginDataSource_0(this));
}

defineSeed(1606, 1607, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), AgentPluginTableView_0);
_.configureTable = function configureTable_1(){
  var fields, listGrid, pluginUploadForm, scanForUpdatesButton, showDeletedButton;
  fields = $getListGridFields(dynamicCast(this.dataSource_1, Q$AgentPluginTableView$AgentPluginDataSource));
  listGrid = this.listGrid;
  $setFields_1(listGrid, dynamicCast($toArray_1(fields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.size_0, 0)), Q$ListGridField_$1));
  $sort(listGrid, 'name', ($clinit_SortDirection() , ASCENDING));
  $addTableAction(this, ($clinit_Enhanced() , 'Povolit'), 'Jste si jist\xED?', null, new AgentPluginTableView$1_0(this, this, ($clinit_TableActionEnablement() , ANY_1), initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , MANAGE_SETTINGS)])));
  $addTableAction(this, 'Zak\xE1zat', null, null, new AgentPluginTableView$2_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, 'Smazat', null, null, new AgentPluginTableView$3_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, 'Smazat', 'Jste si jist\xED?', null, new AgentPluginTableView$4_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  scanForUpdatesButton = new EnhancedIButton_1('Zah\xE1jit sken aktualizac\xED');
  $addClickHandler(scanForUpdatesButton, new AgentPluginTableView$5_0(this));
  showDeletedButton = new EnhancedIButton_1('Zobrazit smazan\xE9');
  $addClickHandler(showDeletedButton, new AgentPluginTableView$6_0(this, showDeletedButton));
  pluginUploadForm = new PluginFileUploadForm_0('Nahr\xE1t z\xE1suvn\xFD modul');
  $add_3(this.extraWidgetsAboveFooter, scanForUpdatesButton);
  $add_3(this.extraWidgetsAboveFooter, showDeletedButton);
  $add_3(this.extraWidgetsAboveFooter, pluginUploadForm);
  $configureTable(this);
}
;
_.getDetailsView_0 = function getDetailsView_0(id){
  return new AgentPluginDetailView_0(id.value_0);
}
;
_.showDeleted = false;
var VIEW_ID_0;
function $enableIfRecordsExist(listGrid){
  return !!listGrid && $getTotalRows(listGrid) != 0;
}

function AbstractTableAction_0(){
  AbstractTableAction_1.call(this, ($clinit_TableActionEnablement() , ALWAYS));
}

function $isEnabled_0(this$static, selection){
  if (!$isEnabled(this$static, selection)) {
    return false;
  }
  if (!this$static.isGlobalAuthorized) {
    $loadExplicitGlobalPermissions(($clinit_PermissionsLoader() , new AuthorizedTableAction$1_0(this$static)));
    return false;
  }
  return this$static.isGlobalAuthorized.value_0;
}

function AuthorizedTableAction_0(table, enablement, permissions){
  var p, p$index, p$max;
  this.enablement = enablement;
  this.globalPermissions = new HashSet_0;
  this.table = table;
  for (p$index = 0 , p$max = permissions.length; p$index < p$max; ++p$index) {
    p = permissions[p$index];
    switch (p.target_0.ordinal) {
      case 0:
        $add_6(this.globalPermissions, p);
        break;
      case 1:
        throw new IllegalArgumentException_1('Does not support Resource permissions');
    }
  }
  this.globalPermissions.map_0.size_1() == 0 && (this.isGlobalAuthorized = ($clinit_Boolean() , $clinit_Boolean() , TRUE));
}

defineSeed(1611, 1612, {});
_.isEnabled_0 = function isEnabled_1(selection){
  return $isEnabled_0(this, selection);
}
;
_.isGlobalAuthorized = null;
_.table = null;
function AgentPluginTableView$1_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1610, 1611, {}, AgentPluginTableView$1_0);
_.executeAction = function executeAction(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds(selections);
  $enableAgentPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$1$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_11(this$static, result){
  var msg;
  msg = new Message_7('Povolen\xE9 z\xE1suvn\xE9 moduly agenta: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1613, 1, {}, AgentPluginTableView$1$1_0);
_.onFailure = function onFailure_11(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se povolit z\xE1suvn\xE9 moduly agenta.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_11(result){
  $onSuccess_11(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function AgentPluginTableView$2_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1614, 1611, {}, AgentPluginTableView$2_0);
_.executeAction = function executeAction_0(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames(selections);
  message = '<b>Varov\xE1n\xED!<\/b><br/>\nN\xE1sleduj\xEDc\xED z\xE1suvn\xE9 moduly do agenta budou zneplatn\u011Bny:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\nJste si jisti, \u017Ee je chcete zneplatnit?';
  ask(message, new AgentPluginTableView$2$1_0(this, selections));
}
;
_.this$0 = null;
function AgentPluginTableView$2$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1615, 1, {}, AgentPluginTableView$2$1_0);
_.execute_3 = function execute_11(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds(this.val$selections);
    $disableAgentPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$2$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_12(this$static, result){
  var msg;
  msg = new Message_7('Zneplatn\u011Bn\xE9 z\xE1suvn\xE9 moduly agenta: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function AgentPluginTableView$2$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1616, 1, {}, AgentPluginTableView$2$1$1_0);
_.onFailure = function onFailure_12(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se zneplatnit z\xE1suvn\xE9 moduly agenta.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_12(result){
  $onSuccess_12(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function AgentPluginTableView$3_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1617, 1611, {}, AgentPluginTableView$3_0);
_.executeAction = function executeAction_1(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames(selections);
  message = '<b>Varov\xE1n\xED!<\/b><br/>\nN\xE1sleduj\xEDc\xED z\xE1suvn\xE9 moduly do agenta budou smaz\xE1ny:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\nJste si jisti, \u017Ee je chcete smazat?';
  ask(message, new AgentPluginTableView$3$1_0(this, selections));
}
;
_.this$0 = null;
function AgentPluginTableView$3$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1618, 1, {}, AgentPluginTableView$3$1_0);
_.execute_3 = function execute_12(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds(this.val$selections);
    $deleteAgentPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$3$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_13(this$static, result){
  var msg;
  msg = new Message_7('Smaz\xE1ny z\xE1suvn\xE9 moduly agenta: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function AgentPluginTableView$3$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1619, 1, {}, AgentPluginTableView$3$1$1_0);
_.onFailure = function onFailure_13(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se smazat z\xE1suvn\xE9 moduly agenta.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_13(result){
  $onSuccess_13(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function AgentPluginTableView$4_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1620, 1611, {}, AgentPluginTableView$4_0);
_.executeAction = function executeAction_2(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds(selections);
  $purgeAgentPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new AgentPluginTableView$4$1_0(this));
}
;
_.isEnabled_0 = function isEnabled_2(selection){
  return this.this$0.showDeleted && $isEnabled_0(this, selection);
}
;
_.this$0 = null;
function $onSuccess_14(this$static, result){
  var msg;
  msg = new Message_7('Preparing to purge agent plugins ' + ($clinit_Enhanced() , result.toString$()) + '. This may take a few minutes since all type definitions from the plugins must first be purged from the system. The plugins will still be visible on this page until they have been purged. Please note that you must not re-install the plugin while the purge is running, otherwise failures will occur. Therefore, please wait before attempting to re-install the plugin into the system until this purge is complete.', ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$4$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1621, 1, {}, AgentPluginTableView$4$1_0);
_.onFailure = function onFailure_14(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nezda\u0159ilo se smazat z\xE1suvn\xE9 moduly agenta.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_14(result){
  $onSuccess_14(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function AgentPluginTableView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1622, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), AgentPluginTableView$5_0);
_.onClick = function onClick_3(event_0){
  $scanAndRegister(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), new AgentPluginTableView$5$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_15(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , 'Sken aktualizac\xED dokon\u010Den'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function AgentPluginTableView$5$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1623, 1, {}, AgentPluginTableView$5$1_0);
_.onFailure = function onFailure_15(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Sken aktualizac\xED zhavaroval.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_15(result){
  $onSuccess_15(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function AgentPluginTableView$6_0(this$0, val$showDeletedButton){
  this.this$0 = this$0;
  this.val$showDeletedButton = val$showDeletedButton;
}

defineSeed(1624, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), AgentPluginTableView$6_0);
_.onClick = function onClick_4(event_0){
  this.this$0.showDeleted = !this.this$0.showDeleted;
  if (this.this$0.showDeleted) {
    $setTitle_0(this.val$showDeletedButton, ($clinit_Enhanced() , 'Skr\xFDt smazan\xE9'));
    $showField(this.this$0.listGrid, 'deployed');
  }
   else {
    $setTitle_0(this.val$showDeletedButton, ($clinit_Enhanced() , 'Zobrazit smazan\xE9'));
    $hideField(this.this$0.listGrid, 'deployed');
  }
  $refresh(this.this$0, false);
}
;
_.this$0 = null;
_.val$showDeletedButton = null;
function $clinit_RPCDataSource(){
  $clinit_RPCDataSource = nullMethod;
  $clinit_CoreGUI();
}

function $addFields(this$static, fields){
  var field, field$iterator;
  for (field$iterator = new AbstractList$IteratorImpl_0(fields); field$iterator.i < field$iterator.this$0_0.size_1();) {
    field = dynamicCast($next_0(field$iterator), Q$DataSourceField);
    $addField(this$static, field);
  }
}

function $buildDataObjects(this$static, records){
  var record, record$index, record$max, results;
  if (records == null) {
    return null;
  }
  results = new LinkedHashSet_1(records.length);
  for (record$index = 0 , record$max = records.length; record$index < record$max; ++record$index) {
    record = records[record$index];
    $add_6(results, this$static.copyValues(record));
  }
  return results;
}

function $buildRecords(this$static, dataObjects, cascade){
  var i, item, item$iterator, records;
  if (!dataObjects) {
    return null;
  }
  records = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, dataObjects.size_1(), 0);
  i = 0;
  for (item$iterator = dataObjects.iterator(); item$iterator.hasNext();) {
    item = item$iterator.next_0();
    setCheck(records, i++, this$static.copyValues_1(item, cascade));
  }
  return records;
}

function $getPageControl(this$static, request){
  var endRow, pageControl, startRow;
  if (!!this$static.previousCriteria && !equals_129($getCriteria(request), this$static.previousCriteria)) {
    debug('Resetting paging on ' + this$static.___clazz$.typeName + '...');
    $setAttribute_11(request, 'startRow', valueOf_44(0));
    $setAttribute_11(request, 'endRow', this$static.dataPageSize);
  }
  this$static.previousCriteria = $getCriteria(request)?$getCriteria(request):new Criteria_0;
  if (!getAttributeAsInt(request.jsObj, 'endRow')) {
    pageControl = getExplicitPageControl(0, this$static.dataPageSize.value_0);
  }
   else {
    startRow = getAttributeAsInt(request.jsObj, 'startRow')?getAttributeAsInt(request.jsObj, 'startRow').value_0:0;
    endRow = getAttributeAsInt(request.jsObj, 'endRow').value_0;
    pageControl = getExplicitPageControl(startRow, endRow - startRow);
  }
  $initializeSorting(this$static, pageControl, request);
  return pageControl;
}

function $highlightFilterMatches(this$static, request, records){
  var criteriaMap, decoratedData, filterName, filterName$iterator, filterValue, nextRecord, nextRecord$index, nextRecord$max, originalData;
  criteriaMap = convertToMap($getCriteria(request).jsObj);
  for (filterName$iterator = new AbstractList$IteratorImpl_0(this$static.hightlightingFieldNames); filterName$iterator.i < filterName$iterator.this$0_0.size_1();) {
    filterName = dynamicCast($next_0(filterName$iterator), Q$String);
    filterValue = dynamicCast(criteriaMap.get_2(filterName), Q$String);
    for (nextRecord$index = 0 , nextRecord$max = records.length; nextRecord$index < nextRecord$max; ++nextRecord$index) {
      nextRecord = records[nextRecord$index];
      originalData = getAttribute(nextRecord.jsObj, filterName);
      decoratedData = filterValue != null?highlight_0(originalData, filterValue):originalData;
      nextRecord.jsObj[filterName + '-highlight'] = decoratedData;
    }
  }
}

function $initializeSorting(this$static, pageControl, request){
  var columnName, ordering, sortField, sortSpecifier, sortSpecifier$index, sortSpecifier$max, sortSpecifiers;
  sortSpecifiers = $getSortBy(request);
  if (sortSpecifiers != null) {
    for (sortSpecifier$index = 0 , sortSpecifier$max = sortSpecifiers.length; sortSpecifier$index < sortSpecifier$max; ++sortSpecifier$index) {
      sortSpecifier = sortSpecifiers[sortSpecifier$index];
      ordering = dynamicCast(getEnum(($clinit_SortDirection() , $clinit_SortDirection() , $VALUES_33), getAttribute(sortSpecifier.jsObj, 'direction')), Q$SortDirection) == ASCENDING?($clinit_PageOrdering() , ASC):($clinit_PageOrdering() , DESC);
      columnName = getAttribute(sortSpecifier.jsObj, 'property');
      sortField = this$static.getSortFieldForColumn(columnName);
      sortField != null?$addDefaultOrderingField(pageControl, sortField, ordering):warn_0('Field [' + columnName + '] in [' + this$static.___clazz$.typeName + '] could not be mapped to a PageControl ordering field.');
    }
  }
}

function $processResponse_0(this$static, requestId, responseProperties){
  $processResponse(this$static, requestId, responseProperties);
  record_1(requestId, responseProperties);
}

function $sendFailureResponse(this$static, request, response, message, caught){
  $handleError_0(($clinit_CoreGUI() , message), caught);
  response.jsObj['status'] = -1;
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $sendSuccessResponse(this$static, request, response, record, message){
  response.jsObj['status'] = 0;
  $setAttribute_17(response, 'data', initValues(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, [record]));
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
  !!message && $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
}

function $sendSuccessResponse_0(this$static, request, response, dataObject, message){
  var record;
  record = this$static.copyValues_0(dataObject);
  $sendSuccessResponse(this$static, request, response, record, message);
}

function $sendSuccessResponse_1(this$static, request, response, dataObjects){
  var records, recordsPageList;
  records = this$static.buildRecords(dataObjects);
  recordsPageList = new PageList_2(dataObjects.pageControl);
  $setTotalSize(recordsPageList, max_1(dataObjects.size_0, dataObjects.totalSize));
  $setUnbounded(recordsPageList, dataObjects.isUnbounded);
  $addAll_0(recordsPageList, new Arrays$ArrayList_0(records));
  this$static.sendSuccessResponseRecords(request, response, recordsPageList);
}

function $sendSuccessResponseRecords(this$static, request, response, records){
  var recordsArray;
  response.jsObj['status'] = 0;
  recordsArray = dynamicCast($toArray_1(records, initDim(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, records.size_0, 0)), Q$Record_$1);
  $setAttribute_17(response, 'data', recordsArray);
  $setPagingInfo(response, records);
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $sendValidationErrorResponse(this$static, request, response, errorMessages){
  response.jsObj['status'] = -4;
  setAttribute_10(response.jsObj, 'errors', errorMessages);
  $processResponse_0(this$static, getAttribute(request.jsObj, 'requestId'), response);
}

function $setDataPageSize(this$static, dataPageSize){
  if (dataPageSize.value_0 <= 0) {
    throw new IllegalArgumentException_1('Page size must be greater than 0.');
  }
  this$static.dataPageSize = dataPageSize;
}

function $setPagingInfo(response, pageList){
  var totalRows;
  totalRows = pageList.isUnbounded?pageList.size_0:max_1(pageList.size_0, pageList.totalSize);
  $setAttribute_11(response, 'totalRows', valueOf_44(totalRows));
}

function RPCDataSource_0(){
  $clinit_RPCDataSource();
  DataSource_0.call(this);
  this.hightlightingFieldNames = new ArrayList_0;
  $setAttribute_0(this, 'clientOnly', ($clinit_Boolean() , $clinit_Boolean() , FALSE), false);
  $setAttribute_0(this, 'autoCacheAllData', FALSE, true);
  $setAttribute_0(this, 'cacheAllData', FALSE, true);
  $setAttribute_1(this, 'dataProtocol', ($clinit_DSProtocol() , CLIENTCUSTOM).value_0);
  $setAttribute_1(this, 'dataFormat', ($clinit_DSDataFormat() , CUSTOM).value_0);
  $setDataPageSize(this, valueOf_44(50));
}

function convertTimestampToDate(timestamp){
  if (!timestamp) {
    return null;
  }
  return neq(timestamp.value_0, P0_longLit)?new Date_2(timestamp.value_0):null;
}

function createBooleanField(name_0, title, required){
  var textField, valueMap;
  textField = new DataSourceTextField_1(name_0, title);
  $setAttribute_11(textField, 'length', valueOf_44((($clinit_Boolean() , FALSE).value_0?'true':'false').length));
  setAttribute_5(textField.jsObj, 'required', required);
  valueMap = new LinkedHashMap_0;
  $put_1(valueMap, TRUE.value_0?'true':'false', 'ano');
  $put_1(valueMap, FALSE.value_0?'true':'false', 'ne');
  setAttribute_10(textField.jsObj, 'valueMap', valueMap);
  return textField;
}

function createIntegerField(minValue, required){
  var integerRangeValidator, textField;
  textField = new DataSourceIntegerField_1('timeout', 'Timeout (v sekund\xE1ch)');
  setAttribute_5(textField.jsObj, 'required', required);
  if (minValue) {
    integerRangeValidator = new IntegerRangeValidator_0;
    minValue?$setAttribute_3(integerRangeValidator, 'min', minValue.value_0):(integerRangeValidator.jsObj['min'] = -2147483648 , undefined);
    integerRangeValidator.jsObj['max'] = 2147483647;
    textField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [integerRangeValidator]));
  }
  return textField;
}

function createTextField(name_0, title, minLength, maxLength, required){
  var lengthRangeValidator, textField;
  textField = new DataSourceTextField_1(name_0, title);
  setAttribute_8(textField.jsObj, 'length', maxLength);
  setAttribute_5(textField.jsObj, 'required', required);
  if (!!minLength || !!maxLength) {
    lengthRangeValidator = new LengthRangeValidator_0;
    setAttribute_8(lengthRangeValidator.jsObj, 'min', minLength);
    setAttribute_8(lengthRangeValidator.jsObj, 'max', maxLength);
    textField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [lengthRangeValidator]));
  }
  return textField;
}

function getArrayFilter(criteria, paramName, type){
  $clinit_RPCDataSource();
  var buffer, criteriaMap, index, intermediates, next, next$index, next$max, resultArray, value;
  criteriaMap = convertToMap(criteria.jsObj);
  value = criteriaMap.get_2(paramName);
  if (value == null) {
    resultArray = null;
  }
   else if (type == Ljava_lang_Integer_2_classLit) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsIntArray(criteria.jsObj, paramName)):(intermediates = initValues(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, [getAttributeAsInt(criteria.jsObj, paramName).value_0]));
    resultArray = initDim(_3Ljava_lang_Integer_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Integer_$1, Q$Object_$1]), Q$Integer, intermediates.length, 0);
    index = 0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      setCheck(resultArray, index++, valueOf_44(next));
    }
  }
   else if (type == Ljava_lang_String_2_classLit) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsStringArray(criteria.jsObj, paramName)):(intermediates = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, [getAttribute(criteria.jsObj, paramName)]));
    resultArray = initDim(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, intermediates.length, 0);
    index = 0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      setCheck(resultArray, index++, next);
    }
  }
   else if ((type.modifiers & 8) != 0) {
    (getClass__devirtual$(value).modifiers & 4) != 0 || getClass__devirtual$(value) == Ljava_util_ArrayList_2_classLit?(intermediates = getAttributeAsStringArray(criteria.jsObj, paramName)):(intermediates = initValues(_3Ljava_lang_String_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1, Q$String_$1]), Q$String, [getAttribute(criteria.jsObj, paramName)]));
    buffer = new ArrayList_0;
    for (next$index = 0 , next$max = intermediates.length; next$index < next$max; ++next$index) {
      next = intermediates[next$index];
      $add_3(buffer, valueOf_0(type, next));
    }
    resultArray = $toArray_1(buffer, getEnumArray(type, buffer.size_0));
  }
   else {
    throw new IllegalArgumentException_1('Chyb\xED podpora pro p\u0159ed\xE1v\xE1n\xED pol\xED filtr\u016F typu ' + type.typeName + '.');
  }
  ($clinit_Log() , $isLoggable_0(logger_0, ($clinit_Level() , FINE))) && resultArray != null && debug('Array filter: ' + paramName + '=[' + toString_31(resultArray) + ']');
  return resultArray;
}

function getArrayFilter_0(request, paramName, type){
  $clinit_RPCDataSource();
  return getArrayFilter($getCriteria(request), paramName, type);
}

function getDataObject(request){
  var data, newRecord;
  data = getAttributeAsJavaScriptObject(request.jsObj, 'data');
  newRecord = new ListGridRecord_1(data);
  return newRecord;
}

function getEnumArray(genericEnumType, size){
  if (genericEnumType == Lorg_rhq_core_domain_alert_AlertPriority_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_alert_AlertPriority_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$AlertPriority_$1]), Q$AlertPriority, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_event_EventSeverity_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_event_EventSeverity_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$EventSeverity_$1]), Q$EventSeverity, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_operation_OperationRequestStatus_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_operation_OperationRequestStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$OperationRequestStatus_$1]), Q$OperationRequestStatus, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_resource_ResourceCategory_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_resource_ResourceCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$ResourceCategory_$1]), Q$ResourceCategory, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_drift_DriftCategory_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_drift_DriftCategory_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$DriftCategory_$1]), Q$DriftCategory, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEvent$ExecutionStatus_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEvent$ExecutionStatus_$1]), Q$PartitionEvent$ExecutionStatus, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_PartitionEventType_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$PartitionEventType_$1]), Q$PartitionEventType, size, 0);
  }
   else if (genericEnumType == Lorg_rhq_core_domain_cloud_Server$OperationMode_2_classLit) {
    return initDim(_3Lorg_rhq_core_domain_cloud_Server$OperationMode_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1, Q$Server$OperationMode_$1]), Q$Server$OperationMode, size, 0);
  }
   else {
    throw new IllegalArgumentException_1('Pros\xEDm, p\u0159idejte p\u0159\xEDslu\u0161n\xFD k\xF3d pro v\xFD\u010Det ' + genericEnumType.typeName + ' do t\u0159\xEDdy RPCDataSource.getEnumArray(Class)');
  }
}

function getFilter(criteria, paramName, type){
  $clinit_RPCDataSource();
  var criteriaMap, result, strValue, value;
  criteriaMap = criteria?convertToMap(criteria.jsObj):($clinit_Collections() , $clinit_Collections() , EMPTY_MAP);
  value = criteriaMap.get_2(paramName);
  if (value == null || $equals_6(toString__devirtual$(value), '')) {
    result = null;
  }
   else {
    strValue = toString__devirtual$(value);
    type == Ljava_lang_String_2_classLit?(result = strValue):type == Ljava_lang_Integer_2_classLit?(result = valueOf_44(__parseAndValidateInt(strValue))):type == Ljava_lang_Long_2_classLit?(result = new Long_0(__parseAndValidateLong(strValue))):(type.modifiers & 8) != 0?(result = valueOf_0(type, strValue)):(result = value);
  }
  $clinit_Log();
  $fine_0(logger_0, 'Filter: ' + paramName + '=[' + result + ']');
  return result;
}

function getFilter_0(request, paramName, type){
  $clinit_RPCDataSource();
  return getFilter($getCriteria(request), paramName, type);
}

function printRequestCriteria(request){
  var criteria, criteriaMap, nextEntry, nextEntry$iterator;
  criteria = $getCriteria(request);
  criteriaMap = convertToMap(criteria.jsObj);
  for (nextEntry$iterator = criteriaMap.entrySet().iterator(); nextEntry$iterator.hasNext();) {
    nextEntry = dynamicCast(nextEntry$iterator.next_0(), Q$Map$Entry);
    debug('Request Criteria: ' + dynamicCast(nextEntry.getKey_0(), Q$String) + ':' + nextEntry.getValue_1());
  }
}

defineSeed(1626, 341, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]));
_.addField = function addField_0(field){
  $addField(this, field);
}
;
_.buildRecords = function buildRecords(dataObjects){
  return $buildRecords(this, dataObjects, true);
}
;
_.copyValues_1 = function copyValues(from, cascade){
  return this.copyValues_0(from);
}
;
_.executeAdd = function executeAdd(recordToAdd, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support additions.');
}
;
_.executeRemove = function executeRemove(recordToRemove, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support removals.');
}
;
_.executeUpdate = function executeUpdate(editedRecord, oldRecord, request, response){
  throw new UnsupportedOperationException_1('This dataSource does not support updates.');
}
;
_.getPageControl = function getPageControl(request){
  return $getPageControl(this, request);
}
;
_.getSortFieldForColumn = function getSortFieldForColumn(columnName){
  return columnName;
}
;
_.sendSuccessResponseRecords = function sendSuccessResponseRecords(request, response, records){
  $sendSuccessResponseRecords(this, request, response, records);
}
;
_.setDataPageSize = function setDataPageSize(dataPageSize){
  $setDataPageSize(this, dataPageSize);
}
;
_.transformRequest_0 = function transformRequest_0(request){
  var $e0, criteria, deletedRecord, newRecord, oldRecord, response, t, updatedRecord, data;
  try {
    response = new DSResponse_0;
    $setAttribute_12(response, 'clientContext', getAttributeAsObject(request.jsObj, 'clientContext'));
    response.jsObj['status'] = 0;
    switch (dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_9), getAttribute(request.jsObj, 'operationType')), Q$DSOperationType).ordinal) {
      case 0:
        criteria = this.getFetchCriteria(request);
        if (criteria) {
          !criteria.getPageControlOverrides() && criteria.setPageControl(this.getPageControl(request));
          ($clinit_Log() , $isLoggable_0(logger_0, ($clinit_Level() , FINE))) && debug(this.___clazz$.typeName + ' using [' + criteria.getPageControlOverrides() + '] for fetch request.');
        }
         else {
          warn_0(this.___clazz$.typeName + '.getFetchCriteria() returned null - no paging of results will be done.');
        }

        this.executeFetch(request, response, criteria);
        break;
      case 1:
        newRecord = getDataObject(request);
        this.executeAdd(newRecord, request, response);
        break;
      case 2:
        oldRecord = getOrCreateRef_1(getAttributeAsJavaScriptObject(request.jsObj, 'oldValues'));
        updatedRecord = (data = getAttributeAsJavaScriptObject(request.jsObj, 'data') , apply_0(data, oldRecord.jsObj) , new ListGridRecord_1(data));
        this.executeUpdate(updatedRecord, oldRecord, request, response);
        break;
      case 3:
        deletedRecord = getDataObject(request);
        this.executeRemove(deletedRecord, request, response);
        break;
      default:$transformRequest(this, request);
    }
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$Throwable)) {
      t = $e0;
      $handleError_0(($clinit_CoreGUI() , 'Chyba v datov\xE9m zdroji (GWT) p\u0159i zpracov\xE1n\xED ' + dynamicCast(getEnum(($clinit_DSOperationType() , $clinit_DSOperationType() , $VALUES_9), getAttribute(request.jsObj, 'operationType')), Q$DSOperationType).name_0 + ' po\u017Eadavk\u016F.'), t);
      return null;
    }
     else 
      throw $e0;
  }
  return getAttributeAsJavaScriptObject(request.jsObj, 'data');
}
;
_.dataPageSize = null;
_.previousCriteria = null;
function $copyValues(from){
  var record;
  record = new ListGridRecord_0;
  $setAttribute_3(record, 'id', from.id);
  $setAttribute_13(record, 'name', from.displayName);
  $setAttribute_13(record, 'description', from.description);
  $setAttribute_14(record, 'lastUpdate', new Date_2(from.mtime));
  $setAttribute_13(record, 'enabled', getAvailabilityIcon(($clinit_Boolean() , from.enabled?TRUE:FALSE)));
  $setAttribute_13(record, 'deployed', getAvailabilityIcon(from.status_0 == ($clinit_PluginStatusType() , INSTALLED_1)?TRUE:FALSE));
  $setAttribute_13(record, 'version', from.version_0);
  return record;
}

function $executeFetch(this$static, request, response){
  $getAgentPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), this$static.this$0.showDeleted, new AgentPluginTableView$AgentPluginDataSource$1_0(this$static, response, request));
}

function $getListGridFields(){
  var deployedField, descriptionField, enabledField, fields, idField, lastUpdateField, nameField, versionField;
  fields = new ArrayList_0;
  idField = new ListGridField_3('id', 'ID');
  idField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, idField);
  nameField = new ListGridField_3('name', 'Jm\xE9no');
  setCheck(fields.array, fields.size_0++, nameField);
  descriptionField = new ListGridField_3('description', 'Popis');
  setCheck(fields.array, fields.size_0++, descriptionField);
  lastUpdateField = new ListGridField_3('lastUpdate', 'Naposledy modifikov\xE1no');
  $clinit_TimestampCellFormatter();
  prepareDateField(lastUpdateField, getAttribute(lastUpdateField.jsObj, 'name'));
  setCheck(fields.array, fields.size_0++, lastUpdateField);
  enabledField = new ListGridField_3('enabled', 'Povoleno?');
  $setAttribute_13(enabledField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  $setAttribute_13(enabledField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  setCheck(fields.array, fields.size_0++, enabledField);
  deployedField = new ListGridField_3('deployed', 'Nasazeno?');
  $setAttribute_13(deployedField, 'type', IMAGE_0.value_0);
  $setAttribute_13(deployedField, 'align', CENTER_0.value_0);
  deployedField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, deployedField);
  versionField = new ListGridField_3('version', 'Verze');
  versionField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, versionField);
  idField.jsObj['width'] = 100;
  nameField.jsObj['width'] = '30%';
  descriptionField.jsObj['width'] = '*';
  lastUpdateField.jsObj['width'] = '20%';
  enabledField.jsObj['width'] = 65;
  deployedField.jsObj['width'] = 75;
  versionField.jsObj['width'] = 100;
  return fields;
}

function AgentPluginTableView$AgentPluginDataSource_0(this$0){
  var fields_0, idField;
  $clinit_RPCDataSource();
  var fields;
  this.this$0 = this$0;
  RPCDataSource_0.call(this);
  fields = (fields_0 = new ArrayList_0 , idField = new DataSourceIntegerField_2('id', 'ID', 50) , $setAttribute_8(idField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idField, 'hidden', TRUE) , setCheck(fields_0.array, fields_0.size_0++, idField) , fields_0);
  $addFields(this, fields);
}

defineSeed(1625, 1626, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource, Q$AgentPluginTableView$AgentPluginDataSource]), AgentPluginTableView$AgentPluginDataSource_0);
_.copyValues = function copyValues_0(from){
  return null;
}
;
_.copyValues_0 = function copyValues_1(from){
  return $copyValues(dynamicCast(from, Q$Plugin));
}
;
_.executeFetch = function executeFetch(request, response, criteria){
  $executeFetch(this, request, response, dynamicCast(criteria, Q$Criteria));
}
;
_.getFetchCriteria = function getFetchCriteria(request){
  return null;
}
;
_.this$0 = null;
function $onSuccess_16(this$static, result){
  $setAttribute_17(this$static.val$response, 'data', $buildRecords(this$static.this$1, result, true));
  $setTotalRows(this$static.val$response, valueOf_44(result.size_0));
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function AgentPluginTableView$AgentPluginDataSource$1_0(this$1, val$response, val$request){
  this.this$1 = this$1;
  this.val$response = val$response;
  this.val$request = val$request;
}

defineSeed(1627, 1, {}, AgentPluginTableView$AgentPluginDataSource$1_0);
_.onFailure = function onFailure_16(t){
  $handleError_0(($clinit_CoreGUI() , $clinit_RPCDataSource() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), t);
  this.val$response.jsObj['status'] = -1;
  $processResponse_0(this.this$1, $getAttributeAsString(this.val$request, 'requestId'), this.val$response);
}
;
_.onSuccess_0 = function onSuccess_16(result){
  $onSuccess_16(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
_.val$request = null;
_.val$response = null;
function $clinit_DownloadsView(){
  $clinit_DownloadsView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_1 = new ViewName_2('Downloads', ($clinit_Enhanced() , 'Sta\u017Eeno'), ($clinit_IconEnum() , DOWNLOAD));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_1;
}

function DownloadsView_0(){
  $clinit_DownloadsView();
  EnhancedVLayout_0.call(this);
  this.systemManager = dynamicCast(secure(getInstance_55(), -1), Q$SystemGWTServiceAsync);
  this.productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo;
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  this.sectionStack = new SectionStack_0;
  $setShowResizeBar(this.sectionStack, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setAttribute_24(this.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setAttribute_24(this.sectionStack, 'width', '100%', true);
  $setAttribute_24(this.sectionStack, 'height', '100%', true);
  $setAttribute_24(this.sectionStack, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
  this.agentSection = new SectionStackSection_1(($clinit_Enhanced() , 'St\xE1hnout agenta'));
  this.cliSection = new SectionStackSection_1('St\xE1hnout klienta pro p\u0159\xEDkazovou \u0159\xE1dku');
  this.bundleSection = new SectionStackSection_1('St\xE1hnut\xED nasazovac\xEDho bal\xEDku');
  this.connectorsSection = new SectionStackSection_1('Sta\u017Een\xED konektor\u016F');
  this.cliAlertScriptsSection = new SectionStackSection_1('St\xE1hnout CLI agent skripty');
  this.scriptModulesSection = new SectionStackSection_1('Script Modules Download');
  $setExpanded(this.agentSection, FALSE);
  $setExpanded(this.cliSection, FALSE);
  $setExpanded(this.bundleSection, FALSE);
  $setExpanded(this.connectorsSection, FALSE);
  $setExpanded(this.cliAlertScriptsSection, FALSE);
  $setExpanded(this.scriptModulesSection, FALSE);
  $addSection(this.sectionStack, this.agentSection);
  $addSection(this.sectionStack, this.cliSection);
  $addSection(this.sectionStack, this.bundleSection);
  $addSection(this.sectionStack, this.connectorsSection);
  $addSection(this.sectionStack, this.cliAlertScriptsSection);
  $addSection(this.sectionStack, this.scriptModulesSection);
  $addMember(this, this.sectionStack);
}

defineSeed(1628, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), DownloadsView_0);
_.onDraw_0 = function onDraw_4(){
  $getAgentVersionProperties(this.systemManager, new DownloadsView$1_0(this));
  $getClientVersionProperties(this.systemManager, new DownloadsView$2_0(this));
  $getBundleDeployerDownload(this.systemManager, new DownloadsView$3_0(this));
  $getConnectorDownloads(this.systemManager, new DownloadsView$4_0(this));
  $getCliAlertScriptDownloads(this.systemManager, new DownloadsView$5_0(this));
  $getScriptModulesDownloads(this.systemManager, new DownloadsView$6_0(this));
}
;
_.agentSection = null;
_.bundleSection = null;
_.cliAlertScriptsSection = null;
_.cliSection = null;
_.connectorsSection = null;
_.productInfo = null;
_.scriptModulesSection = null;
_.sectionStack = null;
var VIEW_ID_1;
function $onSuccess_17(this$static, result){
  var build, buildItem, form, helpItem, linkItem, md5, md5Item, spacerItem, version, versionItem;
  version = dynamicCast(result.get_2('rhq-agent.latest.version'), Q$String);
  build = dynamicCast(result.get_2('rhq-agent.latest.build-number'), Q$String);
  md5 = dynamicCast(result.get_2('rhq-agent.latest.md5'), Q$String);
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  versionItem = new StaticTextItem_2('agentVersion', ($clinit_Enhanced() , 'Verze agenta'));
  $setValue_7(versionItem, version);
  $setWrapTitle(versionItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  buildItem = new StaticTextItem_2('agentBuild', 'Sestaven\xED agenta');
  $setValue_7(buildItem, build);
  $setWrapTitle(buildItem, FALSE);
  md5Item = new StaticTextItem_2('agentMd5', 'Agent MD5');
  $setValue_7(md5Item, md5);
  $setWrapTitle(md5Item, FALSE);
  linkItem = new StaticTextItem_1('agentLink');
  $setTitle_1(linkItem, 'Odkaz');
  $setValue_7(linkItem, '<a href="/agentupdate/download">St\xE1hnout agenta ' + version + ' (' + build + ')<\/a>');
  spacerItem = new SpacerItem_1('agentSpacer');
  $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 10):(spacerItem.jsObj['height'] = 10 , undefined);
  helpItem = new StaticTextItem_1('agentHelp');
  $isCreated_2(helpItem)?$setProperty_6(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, FALSE);
  $setValue_7(helpItem, '<p> This is the ' + this$static.this$0.productInfo.shortName + ' Agent Update Binary jar file.  The purpose of this jar file is to allow you to install a fresh agent on a machine where an agent does not yet exist and to allow you to update an agent that is already installed on a machine. For more details, run this agent download jar with the --help command line option:<br/> <b>java -jar &lt;agent-download.jar&gt; --help<\/b> <\/p> <h3>Agent Install<\/h3> <p> <b>java -jar &lt;agent-download.jar&gt; --install[=&lt;new agent directory&gt;]<\/b><br/> This command will install a new agent. If you do not specify the new agent directory, the default will be "." <\/p> <h3>Agent Update<\/h3> <p> <b>java -jar &lt;agent-download.jar&gt; --update[=&lt;old agent home&gt;]<\/b><br/> This will update an existing agent that was already installed. If you do not specify the directory where the old, existing agent was installed, it will assumed to be "rhq-agent". <\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [versionItem, buildItem, md5Item, linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.agentSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.agentSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1629, 1, {}, DownloadsView$1_0);
_.onFailure = function onFailure_17(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nelze z\xEDskat informace o verzi agenta'), caught);
}
;
_.onSuccess_0 = function onSuccess_17(result){
  $onSuccess_17(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_18(this$static, result){
  var build, buildItem, form, helpItem, linkItem, md5, md5Item, spacerItem, version, versionItem;
  version = dynamicCast(result.get_2('rhq-server.version'), Q$String);
  build = dynamicCast(result.get_2('rhq-server.build-number'), Q$String);
  md5 = dynamicCast(result.get_2('rhq-client.md5'), Q$String);
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  versionItem = new StaticTextItem_2('cliVersion', ($clinit_Enhanced() , 'CLI verze'));
  $setValue_7(versionItem, version);
  $setWrapTitle(versionItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  buildItem = new StaticTextItem_2('cliBuild', 'CLI \u010D\xEDslo sestaven\xED');
  $setValue_7(buildItem, build);
  $setWrapTitle(buildItem, FALSE);
  md5Item = new StaticTextItem_2('cliMd5', 'CLI MD5');
  $setValue_7(md5Item, md5);
  $setWrapTitle(md5Item, FALSE);
  linkItem = new StaticTextItem_1('cliLink');
  $setTitle_1(linkItem, 'Odkaz');
  $setValue_7(linkItem, '<a href="/client/download">St\xE1hnout CLI ' + version + ' (' + build + ')<\/a>');
  spacerItem = new SpacerItem_1('clientSpacer');
  $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 1):(spacerItem.jsObj['height'] = 1 , undefined);
  helpItem = new StaticTextItem_1('clientHelp');
  $isCreated_2(helpItem)?$setProperty_6(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, FALSE);
  $setValue_7(helpItem, '<p> This is the Command Line Client tool, otherwise known as the CLI. It is a standalone tool that runs from within a console and provides a command line interface to the ' + this$static.this$0.productInfo.shortName + ' Server. You can invoke commands via the CLI as well as run scripts to perform automated tasks. See the documentation for more information on how to install and use the CLI. <\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [versionItem, buildItem, md5Item, linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.cliSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.cliSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1630, 1, {}, DownloadsView$2_0);
_.onFailure = function onFailure_18(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nelze z\xEDskat informace o verzi CLI'), caught);
}
;
_.onSuccess_0 = function onSuccess_18(result){
  $onSuccess_18(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_19(this$static, result){
  var form, helpItem, linkItem, name_0, spacerItem, url;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  name_0 = dynamicCast($next_1($iterator($keySet(result))), Q$String);
  url = dynamicCast($next_2($iterator_0($values(result))), Q$String);
  linkItem = new StaticTextItem_1('bundleLink');
  $setTitle_1(linkItem, ($clinit_Enhanced() , 'Odkaz'));
  $setValue_7(linkItem, '<a href="' + url + '">St\xE1hnout nasazova\u010De bal\xEDk\u016F ' + name_0 + '<\/a>');
  spacerItem = new SpacerItem_1('bundleSpacer');
  $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 1):(spacerItem.jsObj['height'] = 1 , undefined);
  helpItem = new StaticTextItem_1('bundleHelp');
  $isCreated_2(helpItem)?$setProperty_6(helpItem, 'colSpan', 2):(helpItem.jsObj['colSpan'] = 2 , undefined);
  $setShowTitle_0(helpItem, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setValue_7(helpItem, '<p> This is the Bundle Deployer tool. It is for use by developers and packagers of ' + this$static.this$0.productInfo.shortName + ' bundles. This standalone tool allows you to test your bundles and their recipes from a console. <\/p>');
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [linkItem, spacerItem, helpItem]));
  $setItems(this$static.this$0.bundleSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.bundleSection, TRUE);
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1631, 1, {}, DownloadsView$3_0);
_.onFailure = function onFailure_19(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nelze z\xEDskat informace nasazova\u010De bal\xEDk\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_19(result){
  $onSuccess_19(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_20(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , 'Odkaz'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('connectorHelp');
    $isCreated_2(helpText)?$setProperty_6(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, $view_admin_downloads_connectors_help(($clinit_Enhanced() , this$static.this$0.productInfo.shortName)));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noConnectors');
    $isCreated_2(item)?$setProperty_6(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , '\u017D\xE1dn\xE9 konektory nejsou dostupn\xE9 pro sta\u017Een\xED'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.connectorsSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.connectorsSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$4_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1632, 1, {}, DownloadsView$4_0);
_.onFailure = function onFailure_20(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nelze z\xEDskat informace o konektorech'), caught);
}
;
_.onSuccess_0 = function onSuccess_20(result){
  $onSuccess_20(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_21(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , 'Odkaz'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('cliAlertScriptsHelp');
    $isCreated_2(helpText)?$setProperty_6(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, ($clinit_Enhanced() , 'CLI vystrahov\xE9 skripty jsou p\u0159edp\u0159ipraven\xE9 skripty, kter\xE9 m\u016F\u017Eou b\xFDt pou\u017Eity pro vytv\xE1\u0159en\xED upozorn\u011Bn\xED na v\xFDstrahu. Tyto skripty obvykle vy\u017Eaduj\xED \xFApravu p\u0159ed re\xE1ln\xFDm pou\u017Eit\xEDm jako notifikace pro konkr\xE9tn\xED definici v\xFDstrahy.'));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noCliAlertScripts');
    $isCreated_2(item)?$setProperty_6(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , '\u017D\xE1dn\xE9 CLI v\xFDstrahov\xE9 skripty nejsou dostupn\xE9 pro sta\u017Een\xED'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.cliAlertScriptsSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.cliAlertScriptsSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1633, 1, {}, DownloadsView$5_0);
_.onFailure = function onFailure_21(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nelze z\xEDskat informace o dostupn\xFDch CLI v\xFDstrahov\xFDch skriptech ke sta\u017Een\xED'), caught);
}
;
_.onSuccess_0 = function onSuccess_21(result){
  $onSuccess_21(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function $onSuccess_22(this$static, result){
  var entry, entry$iterator, form, helpText, i, item, items, linkItem, spacerItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  if (!!result && result.size_1() != 0) {
    i = 0;
    items = initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, result.size_1() + 2, 0);
    for (entry$iterator = result.entrySet().iterator(); entry$iterator.hasNext();) {
      entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
      linkItem = new StaticTextItem_1('link' + i);
      $setTitle_1(linkItem, ($clinit_Enhanced() , 'Odkaz'));
      $setValue_7(linkItem, '<a href="' + dynamicCast(entry.getValue_1(), Q$String) + '">' + dynamicCast(entry.getKey_0(), Q$String) + '<\/a>');
      setCheck(items, i++, linkItem);
    }
    spacerItem = new SpacerItem_1('spacer');
    $isCreated_2(spacerItem)?$setProperty_6(spacerItem, 'height', 5):(spacerItem.jsObj['height'] = 5 , undefined);
    setCheck(items, i++, spacerItem);
    helpText = new StaticTextItem_1('scriptModulesHelp');
    $isCreated_2(helpText)?$setProperty_6(helpText, 'colSpan', 2):(helpText.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(helpText, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(helpText, ($clinit_Enhanced() , '<p> Script modules are reusable components provided by RHQ to be used in your scripts (either alert scripts or CLI scripts). You can access them by using the "rhq://downloads/&lt;module-name-without-file-extension&gt;" URI in your scripting language of choice (i.e. in javascript, you would use the "require" function).<\/p>'));
    setCheck(items, i++, helpText);
    form.setItems(items);
  }
   else {
    item = new StaticTextItem_1('noScriptModules');
    $isCreated_2(item)?$setProperty_6(item, 'colSpan', 2):(item.jsObj['colSpan'] = 2 , undefined);
    $setShowTitle_0(item, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setValue_7(item, ($clinit_Enhanced() , 'No script modules are available for download'));
    form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [item]));
  }
  $setItems(this$static.this$0.scriptModulesSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  $setExpanded(this$static.this$0.scriptModulesSection, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $markForRedraw(this$static.this$0.sectionStack);
}

function DownloadsView$6_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1634, 1, {}, DownloadsView$6_0);
_.onFailure = function onFailure_22(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Cannot load the list of available script modules'), caught);
}
;
_.onSuccess_0 = function onSuccess_22(result){
  $onSuccess_22(this, dynamicCast(result, Q$HashMap));
}
;
_.this$0 = null;
function EnhancedVStack_0(){
  $clinit_BaseWidget();
  VStack_0.call(this);
}

function EnhancedVStack_1(){
  Layout_0.call(this);
  $isCreated_1(this)?$setProperty_0(this, 'membersMargin', 6):(this.config_0['membersMargin'] = 6 , undefined);
  this.scClassName = 'VStack';
}

defineSeed(1636, 563, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced]), EnhancedVStack_1);
_.destroy_0 = function destroy_4(){
  destroyMembers(this);
  $destroy(this);
}
;
function $getControlDefinition(this$static, controlName){
  var def, def$iterator;
  for (def$iterator = new AbstractList$IteratorImpl_0(this$static.controlDefinitions); def$iterator.i < def$iterator.this$0_0.size_1();) {
    def = dynamicCast($next_0(def$iterator), Q$ServerPluginControlDefinition);
    if ($equals_6(def.name_0, controlName)) {
      return def;
    }
  }
  return null;
}

function $getParameters(this$static){
  if (this$static.selectedParamsDef) {
    if (!$validate_1(this$static.selectedParamsEditor.topLevelPropertiesValuesManager).value_0) {
      throw new IllegalStateException_0;
    }
    return this$static.selectedParamsEditor.configuration;
  }
  return null;
}

function $showParameters(this$static){
  var config, paramsCanvas, paramsForm;
  destroyMembers(this$static.paramsLayout);
  if (this$static.selectedParamsDef) {
    $setAttribute_24(this$static.paramsLayout, 'visibility', ($clinit_Visibility() , INHERIT).value_0, true);
    config = new Configuration_0;
    this$static.selectedParamsEditor = new ConfigurationEditor_1(this$static.selectedParamsDef, config);
    $setAutoHeight(this$static.selectedParamsEditor);
    paramsForm = new DynamicForm_0;
    $isCreated_1(paramsForm)?$setProperty_3(paramsForm, 'width', '100%'):(paramsForm.config_0['width'] = '100%' , undefined);
    $setIsGroup(paramsForm, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    $setGroupTitle(paramsForm, ($clinit_Enhanced() , 'Parametry'));
    paramsCanvas = new CanvasItem_1('paramsCanvas');
    paramsCanvas.setShowTitle(FALSE);
    $isCreated_2(paramsCanvas)?$setProperty_6(paramsCanvas, 'colSpan', 2):(paramsCanvas.jsObj['colSpan'] = 2 , undefined);
    $setCanvas(paramsCanvas, this$static.selectedParamsEditor);
    paramsForm.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [paramsCanvas]));
    $addMember(this$static.paramsLayout, paramsForm);
  }
   else {
    $setAttribute_24(this$static.paramsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  }
  return;
}

function $showResults(this$static, results){
  var editor, formItems, paramsCanvas, resultsForm, statusItem;
  destroyMembers(this$static.resultsLayout);
  resultsForm = new DynamicForm_0;
  $isCreated_1(resultsForm)?$setProperty_3(resultsForm, 'width', '100%'):(resultsForm.config_0['width'] = '100%' , undefined);
  $setIsGroup(resultsForm, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setGroupTitle(resultsForm, ($clinit_Enhanced() , 'V\xFDsledky'));
  formItems = new ArrayList_1(3);
  statusItem = new StaticTextItem_2('status', 'Stav');
  $setValue_7(statusItem, imgHTML(getAvailabilityIcon(results.errorMessage_0 == null?TRUE:FALSE)));
  setCheck(formItems.array, formItems.size_0++, statusItem);
  if (results.errorMessage_0 != null) {
    $setPrompt_1(statusItem, 'Klikn\u011Bte pro zobrazen\xED chybov\xE9 zpr\xE1vy');
    statusItem.addClickHandler(new ServerPluginControlView$3_0(results));
  }
  if (!!this$static.selectedResultsDef && !!results.complexResults) {
    editor = new ConfigurationEditor_1(this$static.selectedResultsDef, results.complexResults);
    editor.readOnly = true;
    $isCreated_1(editor)?$setProperty_0(editor, 'height', 1):(editor.config_0['height'] = 1 , undefined);
    paramsCanvas = new CanvasItem_1('resultsCanvas');
    paramsCanvas.setShowTitle(FALSE);
    $isCreated_2(paramsCanvas)?$setProperty_6(paramsCanvas, 'colSpan', 2):(paramsCanvas.jsObj['colSpan'] = 2 , undefined);
    $setAttribute_28(paramsCanvas, 'canvas', !editor?null:$getOrCreateJsObj_0(editor));
    setCheck(formItems.array, formItems.size_0++, paramsCanvas);
  }
  resultsForm.setItems(dynamicCast($toArray_1(formItems, initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, 0, 0)), Q$FormItem_$1));
  $addMember(this$static.resultsLayout, resultsForm);
  $setAttribute_24(this$static.resultsLayout, 'visibility', ($clinit_Visibility() , INHERIT).value_0, true);
  return;
}

function ServerPluginControlView_0(plugin, controlDefs){
  $clinit_BaseWidget();
  EnhancedVStack_0.call(this);
  this.plugin = plugin;
  this.controlDefinitions = controlDefs;
  $isCreated_1(this)?$setProperty_0(this, 'height', 1):(this.config_0['height'] = 1 , undefined);
  $setMargin(this, valueOf_44(5));
}

defineSeed(1635, 1636, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced]), ServerPluginControlView_0);
_.onDraw_0 = function onDraw_5(){
  var controlNames, controlNamesItem, def, def$iterator, executeButton, form, retStr;
  form = new DynamicForm_0;
  $addMember(this, form);
  this.paramsLayout = new EnhancedVLayout_0;
  $setAttribute_24(this.paramsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  $addMember(this, this.paramsLayout);
  this.resultsLayout = new EnhancedVLayout_0;
  $setAttribute_24(this.resultsLayout, 'visibility', HIDDEN_0.value_0, true);
  $addMember(this, this.resultsLayout);
  executeButton = new FormItemIcon_0;
  executeButton.jsObj['name'] = 'execute';
  executeButton.jsObj['src'] = 'subsystems/control/Operation_16.png';
  $setAttribute_13(executeButton, 'prompt', ($clinit_Enhanced() , 'Spustit'));
  controlNamesItem = new SortedSelectItem_2('controlMenu', 'Control');
  controlNames = new LinkedHashMap_0;
  for (def$iterator = new AbstractList$IteratorImpl_0(this.controlDefinitions); def$iterator.i < def$iterator.this$0_0.size_1();) {
    def = dynamicCast($next_0(def$iterator), Q$ServerPluginControlDefinition);
    $put_1(controlNames, def.name_0, (retStr = def.displayName , retStr == null && (retStr = deCamelCase(def.name_0)) , retStr));
  }
  $setValueMap_1(controlNamesItem, controlNames);
  $isCreated_2(controlNamesItem)?$setProperty_6(controlNamesItem, 'width', 300):(controlNamesItem.jsObj['width'] = 300 , undefined);
  $addChangedHandler(controlNamesItem, new ServerPluginControlView$1_0(this, controlNamesItem, executeButton));
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [controlNamesItem]));
  $addFormItemClickHandler(executeButton, new ServerPluginControlView$2_0(this));
}
;
_.controlDefinitions = null;
_.paramsLayout = null;
_.plugin = null;
_.resultsLayout = null;
_.selectedControlName = null;
_.selectedParamsDef = null;
_.selectedParamsEditor = null;
_.selectedResultsDef = null;
function ServerPluginControlView$1_0(this$0, val$controlNamesItem, val$executeButton){
  this.this$0 = this$0;
  this.val$controlNamesItem = val$controlNamesItem;
  this.val$executeButton = val$executeButton;
}

defineSeed(1637, 1, makeCastMap([Q$EventHandler, Q$ChangedHandler]), ServerPluginControlView$1_0);
_.onChanged = function onChanged(event_0){
  var def;
  this.this$0.selectedControlName = dynamicCast($getValue_2(event_0), Q$String);
  def = $getControlDefinition(this.this$0, this.this$0.selectedControlName);
  this.this$0.selectedParamsDef = def.parameters;
  this.this$0.selectedResultsDef = def.results;
  destroyMembers(this.this$0.resultsLayout);
  $setAttribute_24(this.this$0.resultsLayout, 'visibility', ($clinit_Visibility() , HIDDEN_0).value_0, true);
  $showParameters(this.this$0);
  !$getIcon(this.val$controlNamesItem, $getAttributeAsString(this.val$executeButton, 'name')) && $setIcons(this.val$controlNamesItem, initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItemIcon_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItemIcon, [this.val$executeButton]));
}
;
_.this$0 = null;
_.val$controlNamesItem = null;
_.val$executeButton = null;
function ServerPluginControlView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1638, 1, makeCastMap([Q$EventHandler, Q$FormItemClickHandler]), ServerPluginControlView$2_0);
_.onFormItemClick = function onFormItemClick(event_0){
  var $e0, msg, params, pluginKey, pm;
  try {
    params = $getParameters(this.this$0);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$IllegalStateException)) {
      msg = new Message_8(($clinit_Enhanced() , 'Pros\xEDm, vlo\u017Ete platn\xE9 parametry'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
      $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
      return;
    }
     else 
      throw $e0;
  }
  pm = dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync);
  pluginKey = createServerPluginKey(this.this$0.plugin.type_0, this.this$0.plugin.name_0);
  $invokeServerPluginControl(pm, pluginKey, this.this$0.selectedControlName, params, new ServerPluginControlView$2$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_23(this$static, results){
  $showResults(this$static.this$1.this$0, results);
}

function ServerPluginControlView$2$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1639, 1, {}, ServerPluginControlView$2$1_0);
_.onFailure = function onFailure_23(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se spustit kontrolu'), caught);
}
;
_.onSuccess_0 = function onSuccess_23(results){
  $onSuccess_23(this, dynamicCast(results, Q$ServerPluginControlResults));
}
;
_.this$1 = null;
function ServerPluginControlView$3_0(val$results){
  this.val$results = val$results;
}

defineSeed(1640, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), ServerPluginControlView$3_0);
_.onClick_0 = function onClick_5(event_0){
  var win;
  win = new ErrorMessageWindow_1(($clinit_Enhanced() , 'Chyba'), this.val$results.errorMessage_0);
  $show(win);
}
;
_.val$results = null;
function $prepareControlsSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginControlDefinitions(this$static.pluginManager, pluginKey, new ServerPluginDetailView$3_0(this$static, plugin));
}

function $prepareDetailsSection_0(this$static, plugin){
  var ampsItem, descItem, displayNameItem, enabledItem, form, img, kindItem, md5Item, mtimeItem, nameItem, pathItem, section, typeItem, versionItem;
  form = new DynamicForm_0;
  $setMargin(form, valueOf_44(10));
  $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined);
  $setWrapItemTitles(form, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_1(form)?$setProperty_0(form, 'numCols', 4):(form.config_0['numCols'] = 4 , undefined);
  nameItem = new StaticTextItem_2('name', ($clinit_Enhanced() , 'Jm\xE9no'));
  $setValue_7(nameItem, plugin.name_0);
  displayNameItem = new StaticTextItem_2('displayName', 'Jm\xE9no displeje');
  $setValue_7(displayNameItem, plugin.displayName);
  versionItem = new StaticTextItem_2('version', 'Verze');
  $setValue_7(versionItem, plugin.version_0);
  md5Item = new StaticTextItem_2('MD5', 'MD5');
  $setValue_7(md5Item, plugin.md5);
  pathItem = new StaticTextItem_2('path', 'Cesta');
  $setValue_7(pathItem, plugin.path);
  ampsItem = new StaticTextItem_2('ampsVersion', 'AMPS Verze');
  $setValue_7(ampsItem, plugin.ampsVersion);
  descItem = new StaticTextItem_2('desc', 'Popis');
  $setValue_7(descItem, plugin.description);
  mtimeItem = new StaticTextItem_2('mtime', 'Naposledy modifikov\xE1no');
  $setValue_7(mtimeItem, format_30(valueOf_45(plugin.mtime), ($clinit_TimestampCellFormatter() , DATE_TIME_FORMAT_MEDIUM)));
  kindItem = new StaticTextItem_2('kind', 'Druh');
  switch (plugin.deployment.ordinal) {
    case 0:
      $setValue_7(kindItem, 'Agent');
      break;
    case 1:
      $setValue_7(kindItem, 'Server');
  }
  enabledItem = new CanvasItem_2('enabled', 'Povoleno?');
  img = new Img_2(getAvailabilityIcon(plugin.enabled?TRUE:FALSE), 16, 16);
  $setAttribute_28(enabledItem, 'canvas', !img?null:$getOrCreateJsObj_0(img));
  typeItem = new StaticTextItem_2('type', 'Typ');
  $setValue_7(typeItem, plugin.type_0);
  form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [displayNameItem, nameItem, versionItem, ampsItem, md5Item, kindItem, descItem, pathItem, mtimeItem, enabledItem, typeItem]));
  section = new SectionStackSection_1('Detaily');
  $setExpanded(section, TRUE);
  $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [form]));
  this$static.detailsSection = section;
  ++this$static.initSectionCount;
  return;
}

function $prepareHelpSection_0(this$static, plugin){
  var help, section;
  if (plugin.help != null && plugin.help.length > 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , 'N\xE1pov\u011Bda'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    help = new Label_4(plugin.help);
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [help]));
    this$static.helpSection = section;
  }
  ++this$static.initSectionCount;
  return;
}

function $preparePluginConfigurationSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginConfigurationDefinition(this$static.pluginManager, pluginKey, new ServerPluginDetailView$4_0(this$static, plugin, pluginKey));
  return;
}

function $prepareScheduledJobsSection(this$static, plugin){
  var pluginKey;
  pluginKey = createServerPluginKey(plugin.type_0, plugin.name_0);
  $getServerPluginScheduledJobsDefinition(this$static.pluginManager, pluginKey, new ServerPluginDetailView$5_0(this$static, plugin, pluginKey));
  return;
}

function ServerPluginDetailView_0(pluginId){
  $clinit_BaseWidget();
  EnhancedVLayout_0.call(this);
  this.pluginManager = dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync);
  this.pluginId = pluginId;
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setAttribute_24(this, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
  this.sectionStack = new SectionStack_0;
  $setAttribute_24(this.sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
  $setAttribute_24(this.sectionStack, 'width', '100%', true);
  $setAttribute_24(this.sectionStack, 'height', '100%', true);
  $setMargin(this.sectionStack, valueOf_44(5));
  $setAttribute_24(this.sectionStack, 'overflow', VISIBLE.value_0, false);
}

defineSeed(1641, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), ServerPluginDetailView_0);
_.onDraw_0 = function onDraw_6(){
  $run_0(new ServerPluginDetailView$2_0(this));
}
;
_.onInit = function onInit_10(){
  $onInit(this);
  $onInit_Layout(this);
  $getServerPlugin(this.pluginManager, this.pluginId, new ServerPluginDetailView$1_0(this));
}
;
_.controlsSection = null;
_.detailsSection = null;
_.helpSection = null;
_.initSectionCount = 0;
_.pluginConfigSection = null;
_.pluginId = 0;
_.scheduledJobsSection = null;
_.sectionStack = null;
function $onSuccess_24(this$static, plugin){
  $prepareDetailsSection_0(this$static.this$0, plugin);
  $prepareHelpSection_0(this$static.this$0, plugin);
  $prepareControlsSection(this$static.this$0, plugin);
  $preparePluginConfigurationSection(this$static.this$0, plugin);
  $prepareScheduledJobsSection(this$static.this$0, plugin);
}

function ServerPluginDetailView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1642, 1, {}, ServerPluginDetailView$1_0);
_.onFailure = function onFailure_24(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_24(plugin){
  $onSuccess_24(this, dynamicCast(plugin, Q$ServerPlugin));
}
;
_.this$0 = null;
function $run_0(this$static){
  var elapsedMillis;
  if (this$static.this$0.initSectionCount >= 5) {
    !!this$static.this$0.detailsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.detailsSection);
    !!this$static.this$0.helpSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.helpSection);
    !!this$static.this$0.controlsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.controlsSection);
    !!this$static.this$0.pluginConfigSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.pluginConfigSection);
    !!this$static.this$0.scheduledJobsSection && $addSection(this$static.this$0.sectionStack, this$static.this$0.scheduledJobsSection);
    $addMember(this$static.this$0, this$static.this$0.sectionStack);
    $markForRedraw(this$static.this$0);
  }
   else {
    elapsedMillis = sub(fromDouble(currentTimeMillis0()), this$static.startTime);
    gt(elapsedMillis, P4e20_longLit) && (this$static.this$0.initSectionCount = 5);
    $schedule(this$static, 100);
  }
}

function ServerPluginDetailView$2_0(this$0){
  $clinit_Timer();
  this.this$0 = this$0;
  this.startTime = fromDouble(currentTimeMillis0());
}

defineSeed(1643, 74, makeCastMap([Q$Timer]), ServerPluginDetailView$2_0);
_.run = function run_4(){
  $run_0(this);
}
;
_.this$0 = null;
function $onSuccess_25(this$static, result){
  var section;
  if (!!result && result.size_0 != 0) {
    section = new SectionStackSection_1(($clinit_Enhanced() , 'Ovl\xE1d\xE1n\xED'));
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $addItemJS(section, $getOrCreateJsObj_0(new ServerPluginControlView_0(this$static.val$plugin, result)));
    this$static.this$0.controlsSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$3_0(this$0, val$plugin){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
}

defineSeed(1644, 1, {}, ServerPluginDetailView$3_0);
_.onFailure = function onFailure_25(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_25(result){
  $onSuccess_25(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$0 = null;
_.val$plugin = null;
function $onSuccess_26(this$static, def){
  var buttons, config, editorPC, layout, resetButtonPC, saveButtonPC, section;
  if (def) {
    layout = new EnhancedVLayout_0;
    buttons = new ToolStrip_0;
    $isCreated_1(buttons)?$setProperty_3(buttons, 'width', '100%'):(buttons.config_0['width'] = '100%' , undefined);
    $isCreated_1(buttons)?undefined:(buttons.config_0['extraSpace'] = 10 , undefined);
    $isCreated_1(buttons)?$setProperty_0(buttons, 'membersMargin', 5):(buttons.config_0['membersMargin'] = 5 , undefined);
    $setLayoutMargin(buttons, valueOf_44(5));
    saveButtonPC = new EnhancedIButton_1(($clinit_Enhanced() , 'Ulo\u017Eit'));
    resetButtonPC = new EnhancedIButton_1('Reset');
    config = this$static.val$plugin.pluginConfiguration;
    editorPC = new ConfigurationEditor_1(def, config);
    $setAttribute_24(editorPC, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
    $addPropertyValueChangeListener(editorPC, new ServerPluginDetailView$4$1_0(saveButtonPC));
    $addClickHandler(resetButtonPC, new ServerPluginDetailView$4$2_0(editorPC));
    $addClickHandler(saveButtonPC, new ServerPluginDetailView$4$3_0(this$static, editorPC, this$static.val$pluginKey));
    $addMember(buttons, saveButtonPC);
    $addMember(buttons, resetButtonPC);
    $addMember(layout, buttons);
    $addMember(layout, editorPC);
    section = new SectionStackSection_1('Konfigurace z\xE1suvn\xFDch modul\u016F');
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [layout]));
    this$static.this$0.pluginConfigSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$4_0(this$0, val$plugin, val$pluginKey){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1645, 1, {}, ServerPluginDetailView$4_0);
_.onFailure = function onFailure_26(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_26(def){
  $onSuccess_26(this, dynamicCast(def, Q$ConfigurationDefinition));
}
;
_.this$0 = null;
_.val$plugin = null;
_.val$pluginKey = null;
function ServerPluginDetailView$4$1_0(val$saveButtonPC){
  this.val$saveButtonPC = val$saveButtonPC;
}

defineSeed(1646, 1, makeCastMap([Q$PropertyValueChangeListener]), ServerPluginDetailView$4$1_0);
_.propertyValueChanged = function propertyValueChanged(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.val$saveButtonPC):$disable(this.val$saveButtonPC);
  }
}
;
_.val$saveButtonPC = null;
function ServerPluginDetailView$4$2_0(val$editorPC){
  this.val$editorPC = val$editorPC;
}

defineSeed(1647, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$4$2_0);
_.onClick = function onClick_6(event_0){
  $reset_2(this.val$editorPC);
}
;
_.val$editorPC = null;
function ServerPluginDetailView$4$3_0(this$1, val$editorPC, val$pluginKey){
  this.this$1 = this$1;
  this.val$editorPC = val$editorPC;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1648, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$4$3_0);
_.onClick = function onClick_7(event_0){
  var msg;
  if (!$validate_1(this.val$editorPC.topLevelPropertiesValuesManager).value_0) {
    msg = new Message_8(($clinit_Enhanced() , 'Pros\xEDm, vlo\u017Ete platn\xE1 nastaven\xED'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
    return;
  }
  $updateServerPluginConfiguration(this.this$1.this$0.pluginManager, this.val$pluginKey, this.val$editorPC.configuration, new ServerPluginDetailView$4$3$1_0);
}
;
_.this$1 = null;
_.val$editorPC = null;
_.val$pluginKey = null;
function $onSuccess_27(){
  var m_0;
  m_0 = new Message_0(($clinit_Enhanced() , 'Nastaven\xED bylo ulo\u017Eeno.'));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), m_0);
}

function ServerPluginDetailView$4$3$1_0(){
}

defineSeed(1649, 1, {}, ServerPluginDetailView$4$3$1_0);
_.onFailure = function onFailure_27(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se ulo\u017Eit nastaven\xED'), caught);
}
;
_.onSuccess_0 = function onSuccess_27(result){
  $onSuccess_27(throwClassCastExceptionUnlessNull(result));
}
;
function $onSuccess_28(this$static, def){
  var buttons, config, editorSJ, layout, resetButtonSJ, saveButtonSJ, section;
  if (def) {
    layout = new EnhancedVLayout_0;
    buttons = new ToolStrip_0;
    $isCreated_1(buttons)?$setProperty_3(buttons, 'width', '100%'):(buttons.config_0['width'] = '100%' , undefined);
    $isCreated_1(buttons)?undefined:(buttons.config_0['extraSpace'] = 10 , undefined);
    $isCreated_1(buttons)?$setProperty_0(buttons, 'membersMargin', 5):(buttons.config_0['membersMargin'] = 5 , undefined);
    $setLayoutMargin(buttons, valueOf_44(5));
    saveButtonSJ = new EnhancedIButton_1(($clinit_Enhanced() , 'Ulo\u017Eit'));
    $addMember(buttons, saveButtonSJ);
    resetButtonSJ = new EnhancedIButton_1('Reset');
    $addMember(buttons, resetButtonSJ);
    config = this$static.val$plugin.scheduledJobsConfiguration;
    editorSJ = new ConfigurationEditor_1(def, config);
    $setAttribute_24(editorSJ, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
    $addPropertyValueChangeListener(editorSJ, new ServerPluginDetailView$5$1_0(saveButtonSJ));
    $addClickHandler(resetButtonSJ, new ServerPluginDetailView$5$2_0(editorSJ));
    $addClickHandler(saveButtonSJ, new ServerPluginDetailView$5$3_0(this$static, editorSJ, this$static.val$pluginKey));
    $addMember(layout, buttons);
    $addMember(layout, editorSJ);
    section = new SectionStackSection_1('Napl\xE1novan\xE9 \xFAkoly');
    $setExpanded(section, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
    $setItems(section, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [layout]));
    this$static.this$0.scheduledJobsSection = section;
  }
  ++this$static.this$0.initSectionCount;
}

function ServerPluginDetailView$5_0(this$0, val$plugin, val$pluginKey){
  this.this$0 = this$0;
  this.val$plugin = val$plugin;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1650, 1, {}, ServerPluginDetailView$5_0);
_.onFailure = function onFailure_28(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), caught);
}
;
_.onSuccess_0 = function onSuccess_28(def){
  $onSuccess_28(this, dynamicCast(def, Q$ConfigurationDefinition));
}
;
_.this$0 = null;
_.val$plugin = null;
_.val$pluginKey = null;
function ServerPluginDetailView$5$1_0(val$saveButtonSJ){
  this.val$saveButtonSJ = val$saveButtonSJ;
}

defineSeed(1651, 1, makeCastMap([Q$PropertyValueChangeListener]), ServerPluginDetailView$5$1_0);
_.propertyValueChanged = function propertyValueChanged_0(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.val$saveButtonSJ):$disable(this.val$saveButtonSJ);
  }
}
;
_.val$saveButtonSJ = null;
function ServerPluginDetailView$5$2_0(val$editorSJ){
  this.val$editorSJ = val$editorSJ;
}

defineSeed(1652, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$5$2_0);
_.onClick = function onClick_8(event_0){
  $reset_2(this.val$editorSJ);
}
;
_.val$editorSJ = null;
function ServerPluginDetailView$5$3_0(this$1, val$editorSJ, val$pluginKey){
  this.this$1 = this$1;
  this.val$editorSJ = val$editorSJ;
  this.val$pluginKey = val$pluginKey;
}

defineSeed(1653, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginDetailView$5$3_0);
_.onClick = function onClick_9(event_0){
  var msg;
  if (!$validate_1(this.val$editorSJ.topLevelPropertiesValuesManager).value_0) {
    msg = new Message_8(($clinit_Enhanced() , 'Pros\xEDm, vlo\u017Ete platn\xE1 nastaven\xED'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
    return;
  }
  $updateServerPluginScheduledJobs(this.this$1.this$0.pluginManager, this.val$pluginKey, this.val$editorSJ.configuration, new ServerPluginDetailView$5$3$1_0);
}
;
_.this$1 = null;
_.val$editorSJ = null;
_.val$pluginKey = null;
function $onSuccess_29(){
  var m_0;
  m_0 = new Message_0(($clinit_Enhanced() , 'Nastaven\xED bylo ulo\u017Eeno.'));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), m_0);
}

function ServerPluginDetailView$5$3$1_0(){
}

defineSeed(1654, 1, {}, ServerPluginDetailView$5$3$1_0);
_.onFailure = function onFailure_29(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se ulo\u017Eit nastaven\xED'), caught);
}
;
_.onSuccess_0 = function onSuccess_29(result){
  $onSuccess_29(throwClassCastExceptionUnlessNull(result));
}
;
function $clinit_ServerPluginTableView(){
  $clinit_ServerPluginTableView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_2 = new ViewName_2('ServerPlugins', ($clinit_Enhanced() , 'Z\xE1suvn\xE9 moduly serveru'), ($clinit_IconEnum() , PLUGIN_0));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_2;
}

function $getSelectedIds_0(selections){
  var i, ids, selection, selection$index, selection$max;
  if (selections == null) {
    return initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, 0, 1);
  }
  ids = initDim(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, selections.length, 1);
  i = 0;
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    ids[i++] = getAttributeAsInt(selection.jsObj, 'id').value_0;
  }
  return ids;
}

function $getSelectedNames_0(selections){
  var ids, selection, selection$index, selection$max;
  if (selections == null) {
    return new ArrayList_1(0);
  }
  ids = new ArrayList_1(selections.length);
  for (selection$index = 0 , selection$max = selections.length; selection$index < selection$max; ++selection$index) {
    selection = selections[selection$index];
    $add_3(ids, getAttribute(selection.jsObj, 'name'));
  }
  return ids;
}

function ServerPluginTableView_0(){
  $clinit_ServerPluginTableView();
  TableSection_0.call(this, null);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setDataSource(this, new ServerPluginTableView$ServerPluginDataSource_0(this));
}

defineSeed(1655, 1607, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$Enhanced, Q$EnhancedHLayout]), ServerPluginTableView_0);
_.configureTable = function configureTable_2(){
  var fields, listGrid, pluginUploadForm, restartMasterPCButton, scanForUpdatesButton, showUndeployedButton;
  fields = $getListGridFields_0(dynamicCast(this.dataSource_1, Q$ServerPluginTableView$ServerPluginDataSource));
  listGrid = this.listGrid;
  $setFields_1(listGrid, dynamicCast($toArray_1(fields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.size_0, 0)), Q$ListGridField_$1));
  $sort(listGrid, 'name', ($clinit_SortDirection() , ASCENDING));
  $addTableAction(this, ($clinit_Enhanced() , 'Povolit'), 'Jste si jist\xED?', null, new ServerPluginTableView$1_0(this, this, ($clinit_TableActionEnablement() , ANY_1), initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [($clinit_Permission() , MANAGE_SETTINGS)])));
  $addTableAction(this, 'Zak\xE1zat', null, null, new ServerPluginTableView$2_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, 'Sesadit (undeploy)', null, null, new ServerPluginTableView$3_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  $addTableAction(this, 'Smazat', 'Jste si jist\xED?', null, new ServerPluginTableView$4_0(this, this, ANY_1, initValues(_3Lorg_rhq_core_domain_authz_Permission_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Enum_$1, Q$Object_$1]), Q$Permission, [MANAGE_SETTINGS])));
  scanForUpdatesButton = new EnhancedIButton_1('Zah\xE1jit sken aktualizac\xED');
  $addClickHandler(scanForUpdatesButton, new ServerPluginTableView$5_0(this));
  restartMasterPCButton = new EnhancedIButton_1('Restartovat master konteiner z\xE1suvn\xFDch modul\u016F');
  $addClickHandler(restartMasterPCButton, new ServerPluginTableView$6_0(this));
  showUndeployedButton = new EnhancedIButton_1('Zobrazit sesazen\xE9 (undeployed)');
  $addClickHandler(showUndeployedButton, new ServerPluginTableView$7_0(this, showUndeployedButton));
  pluginUploadForm = new PluginFileUploadForm_0('Nahr\xE1t z\xE1suvn\xFD modul');
  $add_3(this.extraWidgetsAboveFooter, scanForUpdatesButton);
  $add_3(this.extraWidgetsAboveFooter, restartMasterPCButton);
  $add_3(this.extraWidgetsAboveFooter, showUndeployedButton);
  $add_3(this.extraWidgetsAboveFooter, pluginUploadForm);
  $configureTable(this);
}
;
_.getDetailsView_0 = function getDetailsView_1(id){
  return new ServerPluginDetailView_0(id.value_0);
}
;
_.showUndeployed = false;
var VIEW_ID_2;
function ServerPluginTableView$1_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1656, 1611, {}, ServerPluginTableView$1_0);
_.executeAction = function executeAction_3(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds_0(selections);
  $enableServerPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$1$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_30(this$static, result){
  var msg;
  msg = new Message_7('Povolen\xE9 z\xE1suvn\xE9 moduly serveru: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1657, 1, {}, ServerPluginTableView$1$1_0);
_.onFailure = function onFailure_30(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se povolit z\xE1suvn\xE9 moduly serveru.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_30(result){
  $onSuccess_30(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function ServerPluginTableView$2_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1658, 1611, {}, ServerPluginTableView$2_0);
_.executeAction = function executeAction_4(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames_0(selections);
  message = '<b>Varov\xE1n\xED!<\/b><br/>\nN\xE1sleduj\xEDc\xED z\xE1suvn\xE9 moduly do serveru budou zneplatn\u011Bny:<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\nJste si jisti, \u017Ee je chcete zneplatnit?';
  ask(message, new ServerPluginTableView$2$1_0(this, selections));
}
;
_.this$0 = null;
function ServerPluginTableView$2$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1659, 1, {}, ServerPluginTableView$2$1_0);
_.execute_3 = function execute_13(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds_0(this.val$selections);
    $disableServerPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$2$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_31(this$static, result){
  var msg;
  msg = new Message_7('Zneplatn\u011Bn\xE9 z\xE1suvn\xE9 moduly serveru: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function ServerPluginTableView$2$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1660, 1, {}, ServerPluginTableView$2$1$1_0);
_.onFailure = function onFailure_31(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se zneplatnit z\xE1suvn\xE9 moduly serveru.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_31(result){
  $onSuccess_31(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function ServerPluginTableView$3_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1661, 1611, {}, ServerPluginTableView$3_0);
_.executeAction = function executeAction_5(selections, actionValue){
  var message, selectedNames;
  selectedNames = $getSelectedNames_0(selections);
  message = '<b>Varov\xE1n\xED!<\/b><br/>\nN\xE1sleduj\xEDc\xED z\xE1suvn\xE9 moduly do serveru budou sesazeny (undeployed):<br/>\n' + ($clinit_Enhanced() , selectedNames.toString$()) + '<br/>\nJste si jisti, \u017Ee je chcete sesadit?';
  ask(message, new ServerPluginTableView$3$1_0(this, selections));
}
;
_.this$0 = null;
function ServerPluginTableView$3$1_0(this$1, val$selections){
  this.this$1 = this$1;
  this.val$selections = val$selections;
}

defineSeed(1662, 1, {}, ServerPluginTableView$3$1_0);
_.execute_3 = function execute_14(confirmed){
  var selectedIds;
  if (confirmed.value_0) {
    selectedIds = $getSelectedIds_0(this.val$selections);
    $undeployServerPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$3$1$1_0(this));
  }
   else {
    $refreshTableInfo(this.this$1.this$0);
  }
}
;
_.this$1 = null;
_.val$selections = null;
function $onSuccess_32(this$static, result){
  var msg;
  msg = new Message_7('Sesazen\xE9 z\xE1suvn\xE9 moduly serveru: ' + ($clinit_Enhanced() , result.toString$()), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$2.this$1.this$0, false);
}

function ServerPluginTableView$3$1$1_0(this$2){
  this.this$2 = this$2;
}

defineSeed(1663, 1, {}, ServerPluginTableView$3$1$1_0);
_.onFailure = function onFailure_32(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nepoda\u0159ilo se sesadit z\xE1suvn\xE9 moduly serveru.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$2.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_32(result){
  $onSuccess_32(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$2 = null;
function ServerPluginTableView$4_0(this$0, $anonymous0, $anonymous1, $anonymous2){
  this.this$0 = this$0;
  AuthorizedTableAction_0.call(this, $anonymous0, $anonymous1, $anonymous2);
}

defineSeed(1664, 1611, {}, ServerPluginTableView$4_0);
_.executeAction = function executeAction_6(selections, actionValue){
  var selectedIds;
  selectedIds = $getSelectedIds_0(selections);
  $purgeServerPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), selectedIds, new ServerPluginTableView$4$1_0(this));
}
;
_.isEnabled_0 = function isEnabled_3(selection){
  return this.this$0.showUndeployed && $isEnabled_0(this, selection);
}
;
_.this$0 = null;
function $onSuccess_33(this$static, result){
  var msg;
  msg = new Message_7('Smazan\xE9 z\xE1suvn\xE9 moduly serveru: ' + ($clinit_Enhanced() , result.toString$()) + '.', ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$4$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1665, 1, {}, ServerPluginTableView$4$1_0);
_.onFailure = function onFailure_33(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nezda\u0159ilo se smazat z\xE1suvn\xE9 moduly serveru.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_33(result){
  $onSuccess_33(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
function ServerPluginTableView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1666, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$5_0);
_.onClick = function onClick_10(event_0){
  $scanAndRegister(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), new ServerPluginTableView$5$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_34(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , 'Sken aktualizac\xED dokon\u010Den'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$5$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1667, 1, {}, ServerPluginTableView$5$1_0);
_.onFailure = function onFailure_34(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Sken aktualizac\xED zhavaroval.') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_34(result){
  $onSuccess_34(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function ServerPluginTableView$6_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1668, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$6_0);
_.onClick = function onClick_11(event_0){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , 'Restartuji master konteiner z\xE1suvn\xFDch modul\u016F...'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $restartMasterPluginContainer(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), new ServerPluginTableView$6$1_0(this));
}
;
_.this$0 = null;
function $onSuccess_35(this$static){
  var msg;
  msg = new Message_7(($clinit_Enhanced() , 'Master konteiner z\xE1suvn\xFDch modul\u016F byl restartov\xE1n.'), ($clinit_Message$Severity() , Info));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), msg);
  $refresh(this$static.this$1.this$0, false);
}

function ServerPluginTableView$6$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1669, 1, {}, ServerPluginTableView$6$1_0);
_.onFailure = function onFailure_35(caught){
  $handleError_0(($clinit_CoreGUI() , ($clinit_Enhanced() , 'Nezda\u0159ilo se restartovat master konteiner z\xE1suvn\xFDch modul\u016F') + ' ' + caught.getMessage()), caught);
  $refreshTableInfo(this.this$1.this$0);
}
;
_.onSuccess_0 = function onSuccess_35(result){
  $onSuccess_35(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$1 = null;
function ServerPluginTableView$7_0(this$0, val$showUndeployedButton){
  this.this$0 = this$0;
  this.val$showUndeployedButton = val$showUndeployedButton;
}

defineSeed(1670, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), ServerPluginTableView$7_0);
_.onClick = function onClick_12(event_0){
  this.this$0.showUndeployed = !this.this$0.showUndeployed;
  if (this.this$0.showUndeployed) {
    $setTitle_0(this.val$showUndeployedButton, ($clinit_Enhanced() , 'Skr\xFDt nenasazen\xE9'));
    $showField(this.this$0.listGrid, 'deployed');
  }
   else {
    $setTitle_0(this.val$showUndeployedButton, ($clinit_Enhanced() , 'Zobrazit sesazen\xE9 (undeployed)'));
    $hideField(this.this$0.listGrid, 'deployed');
  }
  $refresh(this.this$0, false);
}
;
_.this$0 = null;
_.val$showUndeployedButton = null;
function $copyValues_0(from){
  var record;
  record = new ListGridRecord_0;
  $setAttribute_3(record, 'id', from.id);
  $setAttribute_13(record, 'name', from.displayName);
  $setAttribute_13(record, 'description', from.description);
  $setAttribute_14(record, 'lastUpdate', new Date_2(from.mtime));
  $setAttribute_13(record, 'enabled', getAvailabilityIcon(($clinit_Boolean() , from.enabled?TRUE:FALSE)));
  $setAttribute_13(record, 'deployed', getAvailabilityIcon(from.status_0 == ($clinit_PluginStatusType() , INSTALLED_1)?TRUE:FALSE));
  $setAttribute_13(record, 'version', from.version_0);
  return record;
}

function $executeFetch_0(this$static, request, response){
  $getServerPlugins(dynamicCast(secure(getInstance_47(), -1), Q$PluginGWTServiceAsync), this$static.this$0.showUndeployed, new ServerPluginTableView$ServerPluginDataSource$1_0(this$static, response, request));
}

function $getListGridFields_0(){
  var deployedField, descriptionField, enabledField, fields, idField, lastUpdateField, nameField, versionField;
  fields = new ArrayList_0;
  idField = new ListGridField_3('id', 'ID');
  idField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, idField);
  nameField = new ListGridField_3('name', 'Jm\xE9no');
  setCheck(fields.array, fields.size_0++, nameField);
  descriptionField = new ListGridField_3('description', 'Popis');
  setCheck(fields.array, fields.size_0++, descriptionField);
  lastUpdateField = new ListGridField_3('lastUpdate', 'Naposledy modifikov\xE1no');
  $clinit_TimestampCellFormatter();
  prepareDateField(lastUpdateField, getAttribute(lastUpdateField.jsObj, 'name'));
  setCheck(fields.array, fields.size_0++, lastUpdateField);
  enabledField = new ListGridField_3('enabled', 'Povoleno?');
  $setAttribute_13(enabledField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  $setAttribute_13(enabledField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  setCheck(fields.array, fields.size_0++, enabledField);
  deployedField = new ListGridField_3('deployed', 'Nasazeno?');
  $setAttribute_13(deployedField, 'type', IMAGE_0.value_0);
  $setAttribute_13(deployedField, 'align', CENTER_0.value_0);
  deployedField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, deployedField);
  versionField = new ListGridField_3('version', 'Verze');
  versionField.jsObj['showIf'] = 'false';
  setCheck(fields.array, fields.size_0++, versionField);
  idField.jsObj['width'] = 100;
  nameField.jsObj['width'] = '30%';
  descriptionField.jsObj['width'] = '*';
  lastUpdateField.jsObj['width'] = '20%';
  enabledField.jsObj['width'] = 65;
  deployedField.jsObj['width'] = 75;
  versionField.jsObj['width'] = 100;
  return fields;
}

function ServerPluginTableView$ServerPluginDataSource_0(this$0){
  var fields_0, idField;
  $clinit_RPCDataSource();
  var fields;
  this.this$0 = this$0;
  RPCDataSource_0.call(this);
  fields = (fields_0 = new ArrayList_0 , idField = new DataSourceIntegerField_2('id', 'ID', 50) , $setAttribute_8(idField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idField, 'hidden', TRUE) , setCheck(fields_0.array, fields_0.size_0++, idField) , fields_0);
  $addFields(this, fields);
}

defineSeed(1671, 1626, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource, Q$ServerPluginTableView$ServerPluginDataSource]), ServerPluginTableView$ServerPluginDataSource_0);
_.copyValues = function copyValues_2(from){
  return null;
}
;
_.copyValues_0 = function copyValues_3(from){
  return $copyValues_0(dynamicCast(from, Q$ServerPlugin));
}
;
_.executeFetch = function executeFetch_0(request, response, criteria){
  $executeFetch_0(this, request, response, dynamicCast(criteria, Q$Criteria));
}
;
_.getFetchCriteria = function getFetchCriteria_0(request){
  return null;
}
;
_.this$0 = null;
function $onFailure(this$static, t){
  $handleError_0(($clinit_CoreGUI() , $clinit_RPCDataSource() , 'Nepoda\u0159ilo se na\u010D\xEDst data z\xE1suvn\xFDch modul\u016F'), t);
  this$static.val$response.jsObj['status'] = -1;
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function $onSuccess_36(this$static, result){
  $setAttribute_17(this$static.val$response, 'data', $buildRecords(this$static.this$1, result, true));
  $setTotalRows(this$static.val$response, valueOf_44(result.size_0));
  $processResponse_0(this$static.this$1, $getAttributeAsString(this$static.val$request, 'requestId'), this$static.val$response);
}

function ServerPluginTableView$ServerPluginDataSource$1_0(this$1, val$response, val$request){
  this.this$1 = this$1;
  this.val$response = val$response;
  this.val$request = val$request;
}

defineSeed(1672, 1, {}, ServerPluginTableView$ServerPluginDataSource$1_0);
_.onFailure = function onFailure_36(t){
  $onFailure(this, t);
}
;
_.onSuccess_0 = function onSuccess_36(result){
  $onSuccess_36(this, dynamicCast(result, Q$ArrayList));
}
;
_.this$1 = null;
_.val$request = null;
_.val$response = null;
function $clinit_SystemSettingsView(){
  $clinit_SystemSettingsView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_3 = new ViewName_2('SystemSettings', ($clinit_Enhanced() , 'Syst\xE9mov\xE1 nastaven\xED'), ($clinit_IconEnum() , CONFIGURE));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/' + VIEW_ID_3;
}

function $convertMillisToDays(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), P5265c00_longLit));
}

function $convertMillisToHours(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), P36ee80_longLit));
}

function $convertMillisToMinutes(num){
  return num == null?'0':'' + toString_8(div(__parseAndValidateLong(num), Pea60_longLit));
}

function $getSystemSettingsDefinition(config, driftPlugins){
  var allDefinitions, baselineGroup, dataManagerGroup, def, defEntry, defEntry$iterator, driftGroup, entry, entry$iterator, generalGroup, ldapGroup, options, pd, prop, prop$array, prop$index, prop$max, propertyDef, propertyName;
  def = new ConfigurationDefinition_1('sysset', ($clinit_Enhanced() , 'Syst\xE9mov\xE1 nastaven\xED'));
  generalGroup = new PropertyGroupDefinition_1('general');
  generalGroup.displayName = 'Obecn\xE1 konfigurace';
  generalGroup.defaultHidden = false;
  generalGroup.order = 0;
  dataManagerGroup = new PropertyGroupDefinition_1('datamanager');
  dataManagerGroup.displayName = 'Konfigurace datov\xE9ho spr\xE1vce';
  dataManagerGroup.defaultHidden = false;
  dataManagerGroup.order = 1;
  baselineGroup = new PropertyGroupDefinition_1('baseline');
  baselineGroup.displayName = 'Konfigurace automatick\xE9 baseline';
  baselineGroup.defaultHidden = false;
  baselineGroup.order = 2;
  ldapGroup = new PropertyGroupDefinition_1('ldap');
  ldapGroup.displayName = 'Konfigurace LDAP';
  $setDefaultHidden(ldapGroup, ($clinit_Boolean() , !$equalsIgnoreCase('true', $getSimpleValue(config, ($clinit_SystemSetting() , LDAP_BASED_JAAS_PROVIDER).internalName, 'false'))));
  ldapGroup.order = 3;
  driftGroup = new PropertyGroupDefinition_1('drift');
  driftGroup.displayName = 'Konfigurace driftu';
  driftGroup.order = 4;
  driftGroup.defaultHidden = false;
  for (prop$array = $VALUES_63 , prop$index = 0 , prop$max = prop$array.length; prop$index < prop$max; ++prop$index) {
    prop = prop$array[prop$index];
    if (prop.readOnly) {
      continue;
    }
    pd = new PropertyDefinitionSimple_1(prop.internalName, null, prop.requiringValue, prop.type_0);
    $put_6(def, pd);
    switch (prop.ordinal) {
      case 0:
        pd.description = 'URL ke GUI serveru. Pou\u017E\xEDv\xE1 se hlavn\u011B u emailov\xFDch upozorn\u011Bn\xED v\xFDstrah.';
        pd.displayName = 'GUI Konzole URL';
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'http://localhost:7080';
        break;
      case 1:
        pd.description = 'Pokud ub\u011Bhne tato doba ani\u017E by dal o sob\u011B agent v\u011Bd\u011Bt, je pova\u017Eov\xE1n jako nedostupn\xFD (DOWN). \xDAdaj je v minut\xE1ch.';
        pd.displayName = 'Agent max doba neodpov\xEDd\xE1n\xED';
        pd.propertyGroupDefinition = generalGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P3_longLit), null)]));
        pd.defaultValue = '5';
        break;
      case 34:
        pd.description = 'Pokud uplyne tato doba a u\u017Eivatel mezit\xEDm nezadal \u017E\xE1dn\xFD p\u0159\xEDkaz ve webov\xE9m rozhran\xED RHQ, sezen\xED t\xEDmto vypr\u0161\xED a u\u017Eivatel je po\u017E\xE1d\xE1n o nov\xE9 p\u0159ihl\xE1\u0161en\xED. Tato doba je specifikov\xE1na v hodin\xE1ch.';
        pd.displayName = 'Web UI doba sezen\xED';
        pd.propertyGroupDefinition = generalGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '1';
        break;
      case 2:
        pd.description = 'Ur\u010Duje zda server dovol\xED agent\u016Fm auto aktualizace. Pokud tato volba nen\xED povolena, nebude mo\u017Eno stahovat distribuci agenta ze serveru.';
        pd.displayName = 'Povolit auto aktualizaci agenta';
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'true';
        break;
      case 3:
        pd.description = 'Pokud je povoleno, server b\u011B\u017E\xED v lad\xEDc\xEDm m\xF3du.';
        pd.displayName = 'Povolit lad\xEDc\xED m\xF3d';
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'false';
        break;
      case 4:
        pd.description = 'Pokud je povoleno, experiment\xE1ln\xED vlastnosti aktu\xE1ln\xED verze produktu budou dostupn\xE9 u\u017Eivateli.';
        pd.displayName = 'Povolit experiment\xE1ln\xED vlastnosti';
        pd.propertyGroupDefinition = generalGroup;
        pd.defaultValue = 'false';
        break;
      case 5:
        pd.description = 'Jak \u010Dasto je prov\xE1d\u011Bna \xFAdr\u017Eba datab\xE1ze (nap\u0159. maz\xE1n\xED tabulek v db Postgres). V hodin\xE1ch.';
        pd.displayName = 'Periodicita \xFAdr\u017Eby datab\xE1ze';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '1';
        break;
      case 6:
        pd.description = 'Jak star\xE9 mus\xED b\xFDt polo\u017Eky o dostupnosti v historii aby se vymazaly z datab\xE1ze. \xDAdaj je ve dnech.';
        pd.displayName = 'Smazat \xFAdaje o dostupnosti star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '365';
        break;
      case 7:
        pd.description = 'Jak star\xE9 mus\xED b\xFDt v\xFDstrahy v historii aby se vymazaly z datab\xE1ze. \xDAdaj je ve dnech.';
        pd.displayName = 'Smazat v\xFDstrahy star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 8:
        pd.description = 'Jak star\xE9 mus\xED b\xFDt \u010Dasy, aby se vymazaly z datab\xE1ze. \xDAdaj je ve dnech.';
        pd.displayName = 'Smazat vlastnosti m\u011B\u0159en\xED star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '365';
        break;
      case 9:
        pd.description = 'Jak star\xE9 mus\xED b\xFDt \u010Dasy odezvy, aby se vymazaly z datab\xE1ze. \xDAdaj je ve dnech.';
        pd.displayName = 'Smazat doby odezvy star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 10:
        pd.description = 'How old event data must be before being purged from the database. This is specified in days.';
        pd.displayName = 'Smazat ud\xE1losti star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '14';
        break;
      case 11:
        pd.description = 'Jak dlouho nepou\u017Eit\xFD mus\xED b\xFDt drift soubor, aby se vymazaly z backend ulo\u017Ei\u0161t\u011B. \xDAdaj je ve dnech.';
        pd.displayName = 'Smazat nepou\u017Eit\xE9 drift soubory star\u0161\xED ne\u017E';
        pd.propertyGroupDefinition = dataManagerGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), null)]));
        pd.defaultValue = '31';
        break;
      case 12:
        pd.description = 'Pokud je povoleno, ur\u010Dit\xE9 tabulky v db budou periodicky reindexov\xE1ny.';
        pd.displayName = 'Reindexovat tabulky v noci';
        pd.propertyGroupDefinition = dataManagerGroup;
        pd.defaultValue = 'true';
        break;
      case 13:
        pd.description = 'Frekvence s jakou je automatiky po\u010D\xEDt\xE1na "baseline". Pokud je to 0, auto. v\xFDpo\u010Det je zak\xE1z\xE1n. \xDAdaj je veden ve dnech a maxim\xE1ln\xED hodnota je rovna Baseline Dataset.';
        pd.displayName = 'Frekvence po\u010D\xEDt\xE1n\xED baseline';
        pd.propertyGroupDefinition = baselineGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P0_longLit), null)]));
        pd.defaultValue = '3';
        break;
      case 14:
        pd.description = 'Po\u010Det dn\u016F pot\u0159ebn\xFD k ur\u010Den\xED tzv. "baseline"';
        pd.displayName = 'Baseline Dataset';
        pd.propertyGroupDefinition = baselineGroup;
        $addConstraints(pd, initValues(_3Lorg_rhq_core_domain_configuration_definition_constraint_Constraint_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Constraint, [new IntegerRangeConstraint_1(valueOf_45(P1_longLit), valueOf_45(Pe_longLit))]));
        pd.defaultValue = '7';
        break;
      case 15:
        pd.description = 'M\u011Bl by b\xFDt LDAP pou\u017Eit k ur\u010Den\xED u\u017Eivatelovi identity?';
        pd.displayName = 'Povolit LDAP';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 16:
        pd.description = 'URL k LDAP serveru';
        pd.displayName = 'LDAP URL';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'ldap://localhost';
        break;
      case 17:
        pd.description = 'M\xE1 b\xFDt koumunikace s LDAP p\u0159es SSL?';
        pd.displayName = 'SSL';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 18:
        pd.description = 'LDAP vlastnost obsahuj\xEDc\xED u\u017Eivatelsk\xE9 jm\xE9no. V\xFDchoz\xED nastaven\xED je "cn".';
        pd.displayName = 'Login';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'cn';
        break;
      case 19:
        pd.description = 'Jak\xE9koli p\u0159\xEDdavn\xE9 filry, kter\xE9 budou aplikov\xE1ny na v\xFDsledky hled\xE1n\xED LDAPu. M\u016F\u017Ee b\xFDt pou\u017Eito nap\u0159. s tzv. LDAP vlastnost\xED pro restrikci v\xFDsledk\u016F nap\u0159. RHQUser=true';
        pd.displayName = 'Filtr hled\xE1n\xED';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 20:
        pd.description = 'LDAP filtr, kter\xFD mus\xED vr\xE1tit v\u0161echny skupiny dostupn\xE9 k autorizaci. Pou\u017E\xEDv\xE1 se pro LDAP autorizaci v\u016F\u010Di skupin\u011B.';
        pd.displayName = 'Skupinov\xFD filtr hled\xE1n\xED';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'objectclass=groupOfNames';
        break;
      case 21:
        pd.description = 'Pou\u017E\xEDv\xE1 se pro LDAP autorizaci v\u016F\u010Di skupin\u011B. Tento filtr pak bude pou\u017Eit v konjunkci se skupinov\xFDm filtrem hled\xE1n\xED.';
        pd.displayName = 'Filtr \u010Dlena skupiny';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'member';
        break;
      case 26:
        pd.description = 'Defines whether to use PosixGroup symantics for group membership check. With PosixGroups the Group Member Filter is usually set to memberUid and the Group Filter to objectclass=posixGroup.';
        pd.displayName = 'Je to PosixGroup';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'false';
        break;
      case 22:
        pd.description = 'B\xE1ze adres\xE1\u0159ov\xE9ho stromu ur\u010Den\xE9ho ke hled\xE1n\xED u\u017Eivatel\u016F a jejich hesel p\u0159i autentizaci, nap\u0159. ou=People,dc=redhat,dc=com';
        pd.displayName = 'B\xE1ze pro hled\xE1n\xED';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = 'o=RedHat,c=US';
        break;
      case 23:
        pd.description = 'U\u017Eivatelsk\xE9 jm\xE9no, pod kter\xFDm se p\u0159ipojovat k LDAP serveru. Typicky se jedn\xE1 o pln\u011B ur\u010Den\xE9 jm\xE9no (DN) spr\xE1vce nap\u0159. cn=Manager,dc=redhat,dc=com';
        pd.displayName = 'U\u017Eivatelsk\xE9 jm\xE9no';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 24:
        pd.description = 'P\u0159ihla\u0161ovac\xED \xFAdaje u\u017Eivatele, kter\xFD pot\xE9 dotazuje LDAP server.';
        pd.displayName = 'Heslo';
        pd.propertyGroupDefinition = ldapGroup;
        pd.defaultValue = '';
        break;
      case 27:
        pd.description = 'Serverov\xFD z\xE1suvn\xFD modul pro detekci driftu staraj\xEDc\xED se tak\xE9 o persistenci entit souvisej\xEDc\xEDch s drift problematikou.';
        pd.displayName = 'Zapne z\xE1suvn\xFD modul serveru pro detekci driftu';
        pd.propertyGroupDefinition = driftGroup;
        options = new ArrayList_0;
        for (entry$iterator = driftPlugins.entrySet().iterator(); entry$iterator.hasNext();) {
          entry = dynamicCast(entry$iterator.next_0(), Q$Map$Entry);
          $add_3(options, new PropertyDefinitionEnumeration_1(dynamicCast(entry.getValue_1(), Q$String), dynamicCast(entry.getKey_0(), Q$String)));
        }

        $setEnumeratedValues(pd, options);
    }
  }
  allDefinitions = (!def.propertyDefinitions && (def.propertyDefinitions = new LinkedHashMap_0) , def.propertyDefinitions);
  for (defEntry$iterator = allDefinitions.entrySet().iterator(); defEntry$iterator.hasNext();) {
    defEntry = dynamicCast(defEntry$iterator.next_0(), Q$Map$Entry);
    propertyName = dynamicCast(defEntry.getKey_0(), Q$String);
    propertyDef = dynamicCast(defEntry.getValue_1(), Q$PropertyDefinition);
    !dynamicCast(config.properties.get_2(propertyName), Q$Property) && instanceOf(propertyDef, Q$PropertyDefinitionSimple) && dynamicCast(propertyDef, Q$PropertyDefinitionSimple).defaultValue != null && $put_4(config, new PropertySimple_1(propertyName, dynamicCast(propertyDef, Q$PropertyDefinitionSimple).defaultValue));
  }
  return def;
}

function $save(this$static){
  var props, settings, simple, simple$iterator, simpleProperties, value;
  if ($validate_1(this$static.editor.topLevelPropertiesValuesManager).value_0) {
    simpleProperties = $getSimpleProperties(this$static.editor.configuration);
    props = new HashMap_0;
    for (simple$iterator = $iterator_0($values(simpleProperties)); simple$iterator.val$outerIter.hasNext();) {
      simple = dynamicCast($next_2(simple$iterator), Q$PropertySimple);
      value = simple.stringValue != null?simple.stringValue:'';
      $equals_6(($clinit_SystemSetting() , AGENT_MAX_QUIET_TIME_ALLOWED).internalName, simple.name_0)?(value = value == null?'0':'' + toString_8(mul(mul(__parseAndValidateLong(value), P3c_longLit), P3e8_longLit))):$equals_6(DATA_MAINTENANCE_PERIOD.internalName, simple.name_0) || $equals_6(RHQ_SESSION_TIMEOUT.internalName, simple.name_0)?(value = value == null?'0':'' + toString_8(mul(mul(mul(__parseAndValidateLong(value), P3c_longLit), P3c_longLit), P3e8_longLit))):($equals_6(AVAILABILITY_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(ALERT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(TRAIT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(RT_DATA_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(EVENT_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(DRIFT_FILE_PURGE_PERIOD.internalName, simple.name_0) || $equals_6(BASE_LINE_FREQUENCY.internalName, simple.name_0) || $equals_6(BASE_LINE_DATASET.internalName, simple.name_0)) && (value = value == null?'0':'' + toString_8(mul(mul(mul(mul(__parseAndValidateLong(value), P18_longLit), P3c_longLit), P3c_longLit), P3e8_longLit)));
      props.put(simple.name_0, value);
    }
    settings = fromMap(props);
    $setSystemSettings(dynamicCast(secure(getInstance_55(), -1), Q$SystemGWTServiceAsync), settings, new SystemSettingsView$2_0);
  }
   else {
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_8(($clinit_Enhanced() , 'Pros\xEDm, opravte chybn\xE9 hodnoty p\u0159ed ulo\u017Een\xEDm'), ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient))));
  }
}

function SystemSettingsView_0(){
  $clinit_SystemSettingsView();
  EnhancedVLayout_0.call(this);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  this.canvas_0 = new EnhancedVLayout_0;
  $setAttribute_24(this.canvas_0, 'height', '100%', true);
  $setAttribute_24(this.canvas_0, 'width', '100%', true);
  $setMargin(this.canvas_0, valueOf_44(15));
  $addMember(this, this.canvas_0);
}

defineSeed(1673, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$PropertyValueChangeListener, Q$Enhanced]), SystemSettingsView_0);
_.onDraw_0 = function onDraw_7(){
  $getSystemSettings(dynamicCast(secure(getInstance_55(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$1_0(this));
}
;
_.propertyValueChanged = function propertyValueChanged_1(event_0){
  var invalidPropertyNames;
  if (event_0.invalidPropertySetChanged) {
    invalidPropertyNames = event_0.invalidPropertyNames;
    invalidPropertyNames.size_1() == 0?$enable(this.saveButton):$disable(this.saveButton);
  }
}
;
_.canvas_0 = null;
_.dumpToLogButton = null;
_.editor = null;
_.saveButton = null;
var VIEW_ID_3;
function $onSuccess_37(this$static, result){
  var config, prop, toolStrip, form, productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion, currentMeasRawTable, nextMeasTableRotation;
  $addMember(this$static.this$0.canvas_0, (form = new DynamicForm_0 , $isCreated_1(form)?$setProperty_3(form, 'width', '100%'):(form.config_0['width'] = '100%' , undefined) , $isCreated_1(form)?undefined:(form.config_0['extraSpace'] = 15 , undefined) , $setIsGroup(form, ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setGroupTitle(form, ($clinit_Enhanced() , 'Detaily serveru')) , productName = new StaticTextItem_2('productname', 'Product Name') , productVersion = new StaticTextItem_2('productversion', 'Verze') , productBuildNumber = new StaticTextItem_2('productbuild', '\u010C\xEDslo sestaven\xED') , serverName = new StaticTextItem_2('servername', 'Server Name') , serverTimezone = new StaticTextItem_2('timezone', '\u010Casov\xE1 z\xF3na serveru') , serverTime = new StaticTextItem_2('localtime', 'Lok\xE1ln\xED \u010Das serveru') , serverInstallDir = new StaticTextItem_2('installdir', 'Instala\u010Dn\xED adres\xE1\u0159 serveru') , dbUrl = new StaticTextItem_2('dbUrl', 'URL pro p\u0159ipojen\xED do datab\xE1ze') , dbProductName = new StaticTextItem_2('dbProductName', 'Jm\xE9no datab\xE1ze') , dbProductVersion = new StaticTextItem_2('dbProductVersion', 'Verze datab\xE1ze') , dbDriverName = new StaticTextItem_2('dbDriverName', 'Jm\xE9no ovlada\u010De k datab\xE1zi') , dbDriverVersion = new StaticTextItem_2('dbDriverVersion', 'Verze ovlada\u010De k datab\xE1zi') , currentMeasRawTable = new StaticTextItem_2('currentMeasRawTable', 'Surov\xE1 tabulka aktu\xE1ln\xEDho m\u011B\u0159en\xED') , nextMeasTableRotation = new StaticTextItem_2('nextMeasTableRotation', 'P\u0159\xED\u0161t\xED rotace tabulky m\u011B\u0159en\xED') , $setWrapTitle(productName, FALSE) , $setWrapTitle(productVersion, FALSE) , $setWrapTitle(productBuildNumber, FALSE) , $setWrapTitle(serverName, FALSE) , $setWrapTitle(serverTimezone, FALSE) , $setWrapTitle(serverTime, FALSE) , $setWrapTitle(serverInstallDir, FALSE) , $setWrapTitle(dbUrl, FALSE) , $setWrapTitle(dbProductName, FALSE) , $setWrapTitle(dbProductVersion, FALSE) , $setWrapTitle(dbDriverName, FALSE) , $setWrapTitle(dbDriverVersion, FALSE) , $setWrapTitle(currentMeasRawTable, FALSE) , $setWrapTitle(nextMeasTableRotation, FALSE) , form.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion, currentMeasRawTable, nextMeasTableRotation])) , $getServerDetails(dynamicCast(secure(getInstance_55(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$4_0(form, productName, productVersion, productBuildNumber, serverName, serverTimezone, serverTime, serverInstallDir, dbUrl, dbProductName, dbProductVersion, dbDriverName, dbDriverVersion, currentMeasRawTable, nextMeasTableRotation)) , form));
  config = $toConfiguration(result);
  prop = $getSimple(config, ($clinit_SystemSetting() , AGENT_MAX_QUIET_TIME_ALLOWED).internalName);
  $setValue_12(prop, $convertMillisToMinutes(prop.stringValue));
  prop = $getSimple(config, RHQ_SESSION_TIMEOUT.internalName);
  $setValue_12(prop, $convertMillisToHours(prop.stringValue));
  prop = $getSimple(config, DATA_MAINTENANCE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToHours(prop.stringValue));
  prop = $getSimple(config, AVAILABILITY_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, ALERT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, TRAIT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, RT_DATA_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, EVENT_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, DRIFT_FILE_PURGE_PERIOD.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, BASE_LINE_FREQUENCY.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  prop = $getSimple(config, BASE_LINE_DATASET.internalName);
  $setValue_12(prop, $convertMillisToDays(prop.stringValue));
  this$static.this$0.editor = new ConfigurationEditor_1($getSystemSettingsDefinition(config, result.driftPlugins), config);
  $addPropertyValueChangeListener(this$static.this$0.editor, this$static.this$0);
  $addMember(this$static.this$0.canvas_0, this$static.this$0.editor);
  toolStrip = new ToolStrip_0;
  $isCreated_1(toolStrip)?$setProperty_3(toolStrip, 'width', '100%'):(toolStrip.config_0['width'] = '100%' , undefined);
  $isCreated_1(toolStrip)?$setProperty_0(toolStrip, 'membersMargin', 5):(toolStrip.config_0['membersMargin'] = 5 , undefined);
  $setLayoutMargin(toolStrip, valueOf_44(5));
  this$static.this$0.saveButton = new EnhancedIButton_1('Ulo\u017Eit');
  $addClickHandler(this$static.this$0.saveButton, new SystemSettingsView$1$1_0(this$static));
  $addMember(toolStrip, this$static.this$0.saveButton);
  this$static.this$0.dumpToLogButton = new EnhancedIButton_1('Vypsat syst\xE9mov\xE9 info');
  $addClickHandler(this$static.this$0.dumpToLogButton, new SystemSettingsView$1$2_0);
  $addMember(toolStrip, this$static.this$0.dumpToLogButton);
  $addMember(this$static.this$0.canvas_0, toolStrip);
}

function SystemSettingsView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1674, 1, {}, SystemSettingsView$1_0);
_.onFailure = function onFailure_37(t){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst aktu\xE1ln\xED syst\xE9mov\xE9 nastaven\xED'), t);
}
;
_.onSuccess_0 = function onSuccess_37(result){
  $onSuccess_37(this, dynamicCast(result, Q$SystemSettings));
}
;
_.this$0 = null;
function SystemSettingsView$1$1_0(this$1){
  this.this$1 = this$1;
}

defineSeed(1675, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), SystemSettingsView$1$1_0);
_.onClick = function onClick_13(clickEvent){
  $save(this.this$1.this$0);
}
;
_.this$1 = null;
function SystemSettingsView$1$2_0(){
}

defineSeed(1676, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), SystemSettingsView$1$2_0);
_.onClick = function onClick_14(clickEvent){
  $dumpToLog(dynamicCast(secure(getInstance_55(), -1), Q$SystemGWTServiceAsync), new SystemSettingsView$3_0);
}
;
function SystemSettingsView$2_0(){
}

defineSeed(1677, 1, {}, SystemSettingsView$2_0);
_.onFailure = function onFailure_38(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se ulo\u017Eit syst\xE9mov\xE9 nastaven\xED'), caught);
}
;
_.onSuccess_0 = function onSuccess_38(result){
  throwClassCastExceptionUnlessNull(result);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , 'Syst\xE9mov\xE9 nastaven\xED bylo \xFAsp\u011B\u0161n\u011B zaps\xE1no do logu serveru'), ($clinit_Message$Severity() , Info)));
}
;
function SystemSettingsView$3_0(){
}

defineSeed(1678, 1, {}, SystemSettingsView$3_0);
_.onFailure = function onFailure_39(throwable){
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , 'Zapisov\xE1n\xED informac\xED do logu serveru se nezda\u0159ilo'), ($clinit_Message$Severity() , Warning)));
}
;
_.onSuccess_0 = function onSuccess_39(aVoid){
  throwClassCastExceptionUnlessNull(aVoid);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , 'Syst\xE9mov\xE9 informace byly \xFAsp\u011B\u0161n\u011B zaps\xE1ny do logu serveru'), ($clinit_Message$Severity() , Info)));
}
;
function $onSuccess_38(this$static, result){
  var details, productInfo;
  productInfo = result.productInfo;
  $setValue_0(this$static.val$form, $getName(this$static.val$productName), productInfo.name_0);
  $setValue_0(this$static.val$form, $getName(this$static.val$productVersion), productInfo.version_0);
  $setValue_0(this$static.val$form, $getName(this$static.val$productBuildNumber), productInfo.buildNumber);
  details = result.details;
  $setValue_0(this$static.val$form, $getName(this$static.val$serverName), dynamicCast(details.get_2(($clinit_ServerDetails$Detail() , SERVER_IDENTITY)), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverTimezone), dynamicCast(details.get_2(SERVER_TIMEZONE), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverTime), dynamicCast(details.get_2(SERVER_LOCAL_TIME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$serverInstallDir), dynamicCast(details.get_2(SERVER_INSTALL_DIR), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbUrl), dynamicCast(details.get_2(DATABASE_CONNECTION_URL), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbProductName), dynamicCast(details.get_2(DATABASE_PRODUCT_NAME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbProductVersion), dynamicCast(details.get_2(DATABASE_PRODUCT_VERSION), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbDriverName), dynamicCast(details.get_2(DATABASE_DRIVER_NAME), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$dbDriverVersion), dynamicCast(details.get_2(DATABASE_DRIVER_VERSION), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$currentMeasRawTable), dynamicCast(details.get_2(CURRENT_MEASUREMENT_TABLE), Q$String));
  $setValue_0(this$static.val$form, $getName(this$static.val$nextMeasTableRotation), dynamicCast(details.get_2(NEXT_MEASUREMENT_TABLE_ROTATION), Q$String));
}

function SystemSettingsView$4_0(val$form, val$productName, val$productVersion, val$productBuildNumber, val$serverName, val$serverTimezone, val$serverTime, val$serverInstallDir, val$dbUrl, val$dbProductName, val$dbProductVersion, val$dbDriverName, val$dbDriverVersion, val$currentMeasRawTable, val$nextMeasTableRotation){
  this.val$form = val$form;
  this.val$productName = val$productName;
  this.val$productVersion = val$productVersion;
  this.val$productBuildNumber = val$productBuildNumber;
  this.val$serverName = val$serverName;
  this.val$serverTimezone = val$serverTimezone;
  this.val$serverTime = val$serverTime;
  this.val$serverInstallDir = val$serverInstallDir;
  this.val$dbUrl = val$dbUrl;
  this.val$dbProductName = val$dbProductName;
  this.val$dbProductVersion = val$dbProductVersion;
  this.val$dbDriverName = val$dbDriverName;
  this.val$dbDriverVersion = val$dbDriverVersion;
  this.val$currentMeasRawTable = val$currentMeasRawTable;
  this.val$nextMeasTableRotation = val$nextMeasTableRotation;
}

defineSeed(1679, 1, {}, SystemSettingsView$4_0);
_.onFailure = function onFailure_40(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se na\u010D\xEDst detaily ze serveru'), caught);
}
;
_.onSuccess_0 = function onSuccess_40(result){
  $onSuccess_38(this, dynamicCast(result, Q$ServerDetails));
}
;
_.val$currentMeasRawTable = null;
_.val$dbDriverName = null;
_.val$dbDriverVersion = null;
_.val$dbProductName = null;
_.val$dbProductVersion = null;
_.val$dbUrl = null;
_.val$form = null;
_.val$nextMeasTableRotation = null;
_.val$productBuildNumber = null;
_.val$productName = null;
_.val$productVersion = null;
_.val$serverInstallDir = null;
_.val$serverName = null;
_.val$serverTime = null;
_.val$serverTimezone = null;
function $clinit_RemoteAgentInstallView(){
  $clinit_RemoteAgentInstallView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_4 = new ViewName_2('RemoteAgentInstall', ($clinit_Enhanced() , 'Nainstalovat vzd\xE1len\u011B agenta'), ($clinit_IconEnum() , AGENT_0));
}

function $agentStatusCheck(this$static){
  $disableButtons(this$static, true);
  $agentStatus(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$7_0(this$static));
}

function $buildInstallInfoCanvas(installInfo, info){
  var config, duration, infoForm, infoHeader, listCanvas, listGrid, listLayout, owner, path, result, resultCode, step, version, buf;
  infoForm = new DynamicForm_0;
  $setMargin(infoForm, valueOf_44(20));
  $isCreated_1(infoForm)?$setProperty_3(infoForm, 'width', '100%'):(infoForm.config_0['width'] = '100%' , undefined);
  $isCreated_1(infoForm)?$setProperty_3(infoForm, 'height', '100%'):(infoForm.config_0['height'] = '100%' , undefined);
  infoHeader = new HeaderItem_0;
  $setValue_7(infoHeader, ($clinit_Enhanced() , 'Informace o instalaci agenta'));
  version = new StaticTextItem_2('version', 'Verze');
  $setValue_7(version, info.version_0);
  path = new StaticTextItem_2('path', 'Cesta');
  $setValue_7(path, info.path);
  owner = new StaticTextItem_2('owner', 'Vlastn\xEDk');
  $setValue_7(owner, info.owner);
  config = new StaticTextItem_2('config', 'Konfigurace');
  $setValue_7(config, (buf = new StringBuilder_0 , $append_12($append_12($append_12(($append_1(buf.data_0, '-D') , buf), 'rhq.agent.server.bind-address'), '='), info.serverAddress) , $append_1(buf.data_0, ' ') , $append_12($append_12($append_12(($append_1(buf.data_0, '-D') , buf), 'rhq.communications.connector.bind-address'), '='), info.agentAddress) , $append_1(buf.data_0, ' ') , $append_12($append_12($append_12(($append_1(buf.data_0, '-D') , buf), 'rhq.agent.configuration-setup-flag'), '='), 'true') , $append_1(buf.data_0, ' ') , $append_1(buf.data_0, '--daemon ') , $toString_1(buf.data_0)));
  listCanvas = new CanvasItem_0;
  listCanvas.setShowTitle(($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $isCreated_2(listCanvas)?$setProperty_6(listCanvas, 'colSpan', 2):(listCanvas.jsObj['colSpan'] = 2 , undefined);
  listLayout = new VLayout_1(0);
  $isCreated_1(listLayout)?$setProperty_3(listLayout, 'width', '100%'):(listLayout.config_0['width'] = '100%' , undefined);
  $isCreated_1(listLayout)?$setProperty_3(listLayout, 'height', '100%'):(listLayout.config_0['height'] = '100%' , undefined);
  listGrid = new RemoteAgentInstallView$11_0;
  $isCreated_1(listGrid)?$setProperty_3(listGrid, 'width', '100%'):(listGrid.config_0['width'] = '100%' , undefined);
  $isCreated_1(listGrid)?$setProperty_3(listGrid, 'height', '100%'):(listGrid.config_0['height'] = '100%' , undefined);
  $setCanExpandRecords(listGrid, TRUE);
  $setAttribute_24(listGrid, 'expansionMode', ($clinit_ExpansionMode() , DETAIL_FIELD).value_0, true);
  $isCreated_1(listGrid)?$setProperty_3(listGrid, 'detailField', 'result'):(listGrid.config_0['detailField'] = 'result' , undefined);
  step = new ListGridField_3('description', 'Krok');
  result = new ListGridField_3('result', 'V\xFDsledek');
  resultCode = new ListGridField_4('resultCode', 'V\xFDsledn\xFDK\xF3d', 90);
  duration = new ListGridField_4('duration', 'Trv\xE1n\xED', 90);
  $isCreated_1(listGrid)?$setProperty_2(listGrid, 'fields', convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [step, result, resultCode, duration]))):(listGrid.config_0['fields'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [step, result, resultCode, duration])) , undefined);
  $setData(listGrid, $getStepRecords(info));
  listLayout.addMember_0(listGrid);
  $setAttribute_28(listCanvas, 'canvas', !listLayout?null:$getOrCreateJsObj_0(listLayout));
  infoForm.setFields(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [infoHeader, version, path, owner, config, listCanvas]));
  installInfo.addMember_0(infoForm);
  return;
}

function $disableButtons(this$static, disabled){
  $setDisabled(this$static.installButton, disabled);
  $setDisabled(this$static.startButton, disabled);
  $setDisabled(this$static.stopButton, disabled);
  $setDisabled(this$static.buttonsForm, disabled);
  $setDisabled_2(this$static.findAgentInstallPathButton, ($clinit_Boolean() , disabled?TRUE:FALSE));
  $setDisabled_2(this$static.statusCheckButton, disabled?TRUE:FALSE);
}

function $findAgentInstallPath(this$static){
  var errors, parentPath;
  errors = new HashMap_1(2);
  ($getValueAsString(this$static.connectionForm, 'host') == null || !$trim($getValueAsString(this$static.connectionForm, 'host')).length) && errors.put('host', ($clinit_CoreGUI() , 'Pole je vy\u017Eadov\xE1no'));
  ($getValueAsString(this$static.connectionForm, 'username') == null || !$trim($getValueAsString(this$static.connectionForm, 'username')).length) && errors.put('username', ($clinit_CoreGUI() , 'Pole je vy\u017Eadov\xE1no'));
  $setErrors(this$static.connectionForm, errors, true);
  if (errors.size_1() == 0) {
    $disableButtons(this$static, true);
    parentPath = $getValueAsString(this$static.connectionForm, 'agentInstallPath');
    $findAgentInstallPath_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), parentPath, new RemoteAgentInstallView$6_0(this$static, parentPath));
  }
}

function $getConnectionForm(this$static){
  var agentInstallPath, agentStatus, host, password, port, username;
  this$static.connectionForm = new DynamicForm_0;
  $setNumCols(this$static.connectionForm, 4);
  $setWrapItemTitles(this$static.connectionForm, ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setColWidths(this$static.connectionForm, initValues(_3Ljava_lang_Object_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Object, ['130', '450', '110']));
  host = new TextItem_3('host', ($clinit_Enhanced() , 'Host'));
  $setRequired(host, TRUE);
  $isCreated_2(host)?$setProperty_6(host, 'width', 440):(host.jsObj['width'] = 440 , undefined);
  $setPrompt_1(host, 'Hostitel, kde je, nebo kam bude, agent nainstalov\xE1n');
  $setHoverWidth_0(host, valueOf_44(300));
  $setEndRow_0(host, TRUE);
  port = new TextItem_3('port', 'Port');
  $setRequired(port, FALSE);
  $isCreated_2(port)?$setProperty_6(port, 'width', 440):(port.jsObj['width'] = 440 , undefined);
  $setPrompt_1(port, 'Port na n\u011Bm\u017E naslouch\xE1 SSH. Pokud nen\xED specifikov\xE1no pou\u017Eije se 22');
  $setHoverWidth_0(port, valueOf_44(300));
  $setEndRow_0(port, TRUE);
  username = new TextItem_3('username', 'U\u017Eivatel');
  $setRequired(username, TRUE);
  $isCreated_2(username)?$setProperty_6(username, 'width', 440):(username.jsObj['width'] = 440 , undefined);
  $setPrompt_1(username, 'Jm\xE9no u\u017Eivatele jeho\u017E p\u0159ihla\u0161ovac\xED \xFAdaje jsou p\u0159ed\xE1ny hostiteli p\u0159es SSH');
  $setHoverWidth_0(username, valueOf_44(300));
  $setEndRow_0(username, TRUE);
  password = new PasswordItem_2('Heslo');
  $setRequired(password, FALSE);
  $isCreated_2(password)?$setProperty_6(password, 'width', 440):(password.jsObj['width'] = 440 , undefined);
  $setPrompt_1(password, 'P\u0159ihla\u0161ovac\xED \xFAdaje pou\u017Eit\xE9 pro autentizaci u\u017Eivatele p\u0159es SSH');
  $setHoverWidth_0(password, valueOf_44(300));
  $setEndRow_0(password, TRUE);
  agentInstallPath = new TextItem_3('agentInstallPath', 'Instala\u010Dn\xED cesta k agentovi');
  $isCreated_2(agentInstallPath)?$setProperty_6(agentInstallPath, 'width', 440):(agentInstallPath.jsObj['width'] = 440 , undefined);
  $setPrompt_1(agentInstallPath, "Where the agent is or will be installed. If you aren't sure where an agent is installed, enter a parent directory and click the 'Find Agent' button to scan that directory and below. If you enter an empty path, common locations are searched on the host for an agent install.");
  $setHoverWidth_0(agentInstallPath, valueOf_44(300));
  $setStartRow_0(agentInstallPath, TRUE);
  $setEndRow_0(agentInstallPath, FALSE);
  this$static.findAgentInstallPathButton = new ButtonItem_1('findAgentInstallPathButton', 'Naj\xEDt agenta');
  $setStartRow_1(this$static.findAgentInstallPathButton, FALSE);
  $setEndRow_1(this$static.findAgentInstallPathButton, TRUE);
  this$static.findAgentInstallPathButton.getTitle().length < 15 && $setWidth_1(this$static.findAgentInstallPathButton, 100);
  $addClickHandler_1(this$static.findAgentInstallPathButton, new RemoteAgentInstallView$1_0(this$static));
  agentStatus = new StaticTextItem_2('agentStatus', 'Status agenta');
  $setDefaultValue_1(agentStatus, '-Zm\xE1\u010Dkn\u011Bte tla\u010D\xEDtko Obnovit stav-');
  $isCreated_2(agentStatus)?$setProperty_9(agentStatus, 'redrawOnChange', true):(agentStatus.jsObj['redrawOnChange'] = true , undefined);
  $isCreated_2(agentStatus)?$setProperty_9(agentStatus, 'redrawOnChange', true):(agentStatus.jsObj['redrawOnChange'] = true , undefined);
  $setStartRow_0(agentStatus, TRUE);
  $setEndRow_0(agentStatus, FALSE);
  this$static.statusCheckButton = new ButtonItem_1('updateStatus', 'Obnovit stav');
  $setStartRow_1(this$static.statusCheckButton, FALSE);
  $setEndRow_1(this$static.statusCheckButton, TRUE);
  this$static.findAgentInstallPathButton.getTitle().length < 15 && $setWidth_1(this$static.statusCheckButton, 100);
  $addClickHandler_1(this$static.statusCheckButton, new RemoteAgentInstallView$2_0(this$static));
  this$static.connectionForm.setFields(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [host, port, username, password, agentInstallPath, this$static.findAgentInstallPathButton, agentStatus, this$static.statusCheckButton]));
  $setExtraSpace(this$static.connectionForm, 15);
  return this$static.connectionForm;
}

function $getRemoteAccessInfo(this$static){
  var $e0, host, info, password, port, portInt, username;
  host = $getValueAsString(this$static.connectionForm, 'host');
  port = $getValueAsString(this$static.connectionForm, 'port');
  username = $getValueAsString(this$static.connectionForm, 'username');
  password = $getValueAsString(this$static.connectionForm, 'password');
  try {
    portInt = __parseAndValidateInt(port);
  }
   catch ($e0) {
    $e0 = caught_0($e0);
    if (instanceOf($e0, Q$NumberFormatException)) {
      portInt = 22;
    }
     else 
      throw $e0;
  }
  $setValue(this$static.connectionForm, 'port', portInt);
  info = new RemoteAccessInfo_0(host, portInt, username, password);
  return info;
}

function $getStepRecords(info){
  var rec, result, step, step$iterator, steps;
  steps = new ArrayList_0;
  for (step$iterator = info.steps.iterator(); step$iterator.hasNext();) {
    step = dynamicCast(step$iterator.next_0(), Q$AgentInstallStep);
    rec = new ListGridRecord_0;
    $setAttribute_13(rec, 'description', step.description);
    result = step.result;
    (result == null || $trim(result).length == 0) && (result = ($clinit_Enhanced() , 'V\xFDsledn\xFDK\xF3d') + '=' + step.resultCode);
    rec.jsObj['result'] = result;
    $setAttribute_13(rec, 'resultCode', '' + step.resultCode);
    $setAttribute_13(rec, 'duration', ($clinit_MeasurementConverterClient() , format_91(new Double_0(toDouble(step.duration_0)), ($clinit_MeasurementUnits() , MILLISECONDS))));
    setCheck(steps.array, steps.size_0++, rec);
  }
  return dynamicCast($toArray_1(steps, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, steps.size_0, 0)), Q$ListGridRecord_$1);
}

function $installAgent(this$static){
  $disableButtons(this$static, true);
  $installAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$8_0(this$static));
}

function $startAgent(this$static){
  $disableButtons(this$static, true);
  $startAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$9_0(this$static));
}

function $stopAgent(this$static){
  $disableButtons(this$static, true);
  $stopAgent_0(this$static.remoteInstallService, $getRemoteAccessInfo(this$static), (($getValueAsString(this$static.connectionForm, 'agentInstallPath') == null || !$trim($getValueAsString(this$static.connectionForm, 'agentInstallPath')).length) && $findAgentInstallPath(this$static) , $getValueAsString(this$static.connectionForm, 'agentInstallPath')), new RemoteAgentInstallView$10_0(this$static));
}

function RemoteAgentInstallView_0(){
  $clinit_RemoteAgentInstallView();
  EnhancedVLayout_0.call(this);
  this.remoteInstallService = dynamicCast(secure(getInstance_48(), 600000), Q$RemoteInstallGWTServiceAsync);
  $isCreated_1(this)?$setProperty_0(this, 'membersMargin', 1):(this.config_0['membersMargin'] = 1 , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
}

defineSeed(1680, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), RemoteAgentInstallView_0);
_.onInit = function onInit_11(){
  var header, layout;
  $onInit(this);
  $onInit_Layout(this);
  layout = new VLayout_0;
  $setPadding(layout, valueOf_44(10));
  header = new HTMLFlow_1(($clinit_Enhanced() , 'Informace o spojen\xED'));
  $isCreated_1(header)?$setProperty_3(header, 'styleName', 'headerItem'):(header.config_0['styleName'] = 'headerItem' , undefined);
  $isCreated_1(header)?undefined:(header.config_0['extraSpace'] = 5 , undefined);
  layout.addMember_0(header);
  layout.addMember_0($getConnectionForm(this));
  header = new HTMLFlow_1('Operace');
  $isCreated_1(header)?$setProperty_3(header, 'styleName', 'headerItem'):(header.config_0['styleName'] = 'headerItem' , undefined);
  $isCreated_1(header)?undefined:(header.config_0['extraSpace'] = 5 , undefined);
  layout.addMember_0(header);
  layout.addMember_0((this.buttonsForm = new HLayout_0 , this.installButton = new EnhancedIButton_1('Instalovat agenta') , $setExtraSpace(this.installButton, 10) , $addClickHandler(this.installButton, new RemoteAgentInstallView$3_0(this)) , this.startButton = new EnhancedIButton_1('Start Agent') , $setExtraSpace(this.startButton, 10) , $addClickHandler(this.startButton, new RemoteAgentInstallView$4_0(this)) , this.stopButton = new EnhancedIButton_1('Stop Agent') , $setExtraSpace(this.stopButton, 10) , $addClickHandler(this.stopButton, new RemoteAgentInstallView$5_0(this)) , $setMembers(this.buttonsForm, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [this.installButton, this.startButton, this.stopButton])) , this.buttonsForm));
  this.agentInfoLayout = new VLayout_0;
  $setAttribute_24(this.agentInfoLayout, 'width', '100%', true);
  $setAttribute_24(this.agentInfoLayout, 'height', '100%', true);
  $setMembersMargin(this.agentInfoLayout, 1);
  layout.addMember_0(this.agentInfoLayout);
  $addMember(this, layout);
}
;
_.agentInfoLayout = null;
_.buttonsForm = null;
_.connectionForm = null;
_.findAgentInstallPathButton = null;
_.installButton = null;
_.startButton = null;
_.statusCheckButton = null;
_.stopButton = null;
var VIEW_ID_4;
function RemoteAgentInstallView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1681, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), RemoteAgentInstallView$1_0);
_.onClick_0 = function onClick_15(clickEvent){
  $findAgentInstallPath(this.this$0);
}
;
_.this$0 = null;
function $onSuccess_39(this$static, result){
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7('Agent stop v\xFDsledky: [' + ($clinit_Enhanced() , result) + ']', ($clinit_Message$Severity() , Info)));
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$10_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1682, 1, {}, RemoteAgentInstallView$10_0);
_.onFailure = function onFailure_41(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se zastavit agenta'), caught);
}
;
_.onSuccess_0 = function onSuccess_41(result){
  $onSuccess_39(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function RemoteAgentInstallView$11_0(){
  $clinit_BaseWidget();
  ListGrid_0.call(this);
}

defineSeed(1683, 542, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$ListGrid, Q$HasCellSavedHandlers, Q$HasEditorEnterHandlers, Q$HasEditorExitHandlers, Q$HasRecordClickHandlers]), RemoteAgentInstallView$11_0);
_.getExpansionComponent_0 = function getExpansionComponent_0(record){
  var canvas;
  canvas = $getExpansionComponent(this, record);
  $setPadding(canvas, valueOf_44(5));
  return canvas;
}
;
function RemoteAgentInstallView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1684, 1, makeCastMap([Q$EventHandler, Q$ClickHandler_0]), RemoteAgentInstallView$2_0);
_.onClick_0 = function onClick_16(clickEvent){
  this.this$0.connectionForm.validate_0() && $agentStatusCheck(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1685, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$3_0);
_.onClick = function onClick_17(clickEvent){
  this.this$0.connectionForm.validate_0() && $installAgent(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$4_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1686, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$4_0);
_.onClick = function onClick_18(clickEvent){
  this.this$0.connectionForm.validate_0() && $startAgent(this.this$0);
}
;
_.this$0 = null;
function RemoteAgentInstallView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1687, 1, makeCastMap([Q$EventHandler, Q$ClickHandler]), RemoteAgentInstallView$5_0);
_.onClick = function onClick_19(clickEvent){
  this.this$0.connectionForm.validate_0() && $stopAgent(this.this$0);
}
;
_.this$0 = null;
function $onSuccess_40(this$static, result){
  var err;
  $disableButtons(this$static.this$0, false);
  if (result != null) {
    $setValue_0(this$static.this$0.connectionForm, 'agentInstallPath', result);
  }
   else {
    this$static.val$parentPath == null || this$static.val$parentPath.length == 0?(err = ($clinit_Enhanced() , 'Nepoda\u0159ilo se nal\xE9zt agenta d\xEDvaj\xEDc se do v\xFDchoz\xEDch lokac\xED')):(err = 'Nepoda\u0159ilo se nal\xE9zt agenta nainstalovan\xE9ho v [' + ($clinit_Enhanced() , this$static.val$parentPath) + ']');
    $handleError_0(($clinit_CoreGUI() , err), null);
  }
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$6_0(this$0, val$parentPath){
  this.this$0 = this$0;
  this.val$parentPath = val$parentPath;
}

defineSeed(1688, 1, {}, RemoteAgentInstallView$6_0);
_.onFailure = function onFailure_42(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Stala se chyba p\u0159i zji\u0161\u0165ov\xE1n\xED instala\u010Dn\xED cesty agenta'), caught);
}
;
_.onSuccess_0 = function onSuccess_42(result){
  $onSuccess_40(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
_.val$parentPath = null;
function $onSuccess_41(this$static, result){
  $disableButtons(this$static.this$0, false);
  $setValue_0(this$static.this$0.connectionForm, 'agentStatus', result);
}

function RemoteAgentInstallView$7_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1689, 1, {}, RemoteAgentInstallView$7_0);
_.onFailure = function onFailure_43(caught){
  $disableButtons(this.this$0, false);
  $setValue_0(this.this$0.connectionForm, 'agentStatus', caught.getMessage());
}
;
_.onSuccess_0 = function onSuccess_43(result){
  $onSuccess_41(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function $onSuccess_42(this$static, result){
  var child, child$array, child$index, child$max;
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7(($clinit_Enhanced() , 'Instalace agenta prob\u011Bhla \xFAsp\u011B\u0161n\u011B'), ($clinit_Message$Severity() , Info)));
  for (child$array = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static.this$0.agentInfoLayout, 'children')) , child$index = 0 , child$max = child$array.length; child$index < child$max; ++child$index) {
    child = child$array[child$index];
    child.destroy_0();
  }
  $buildInstallInfoCanvas(this$static.this$0.agentInfoLayout, result);
  this$static.this$0.agentInfoLayout.markForRedraw_0();
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$8_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1690, 1, {}, RemoteAgentInstallView$8_0);
_.onFailure = function onFailure_44(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se nainstalovat agenta'), caught);
}
;
_.onSuccess_0 = function onSuccess_44(result){
  $onSuccess_42(this, dynamicCast(result, Q$AgentInstallInfo));
}
;
_.this$0 = null;
function $onSuccess_43(this$static, result){
  $disableButtons(this$static.this$0, false);
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), new Message_7('Agent start v\xFDsledky: [' + ($clinit_Enhanced() , result) + ']', ($clinit_Message$Severity() , Info)));
  $agentStatusCheck(this$static.this$0);
}

function RemoteAgentInstallView$9_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1691, 1, {}, RemoteAgentInstallView$9_0);
_.onFailure = function onFailure_45(caught){
  $disableButtons(this.this$0, false);
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se spustit agenta'), caught);
}
;
_.onSuccess_0 = function onSuccess_45(result){
  $onSuccess_43(this, dynamicCast(result, Q$String));
}
;
_.this$0 = null;
function $clinit_PermissionsEditor(){
  $clinit_PermissionsEditor = nullMethod;
  $clinit_BaseWidget();
  $clinit_CoreGUI();
}

function $createAuthorizedField(this$static, name_0, title, nameField, grid, readOnlyColumn){
  var authorizedField, editor, recordBeingEdited, valueMap;
  authorizedField = new ListGridField_4(name_0, title, 65);
  $setAttribute_13(authorizedField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  authorizedField.jsObj['imageSize'] = 11;
  valueMap = new LinkedHashMap_1(2);
  if (readOnlyColumn) {
    $put_1(valueMap, ($clinit_Boolean() , TRUE).value_0?'true':'false', 'global/permission_checked_disabled_11.png');
    $put_1(valueMap, FALSE.value_0?'true':'false', 'global/permission_disabled_11.png');
  }
   else {
    $put_1(valueMap, ($clinit_Boolean() , TRUE).value_0?'true':'false', 'global/permission_enabled_11.png');
    $put_1(valueMap, FALSE.value_0?'true':'false', 'global/permission_disabled_11.png');
  }
  setAttribute_10(authorizedField.jsObj, 'valueMap', valueMap);
  $setAttribute_8(authorizedField, 'canEdit', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  editor = new CheckboxItem_0;
  $setEditorType(authorizedField, editor);
  if (!this$static.isReadOnly) {
    $setAttribute_24(grid, 'editEvent', ($clinit_ListGridEditEvent() , CLICK).value_0, true);
    recordBeingEdited = initValues(_3Lcom_smartgwt_client_data_Record_2_classLit, makeCastMap([Q$Record_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Record, [null]);
    $addRecordClickHandler_0(authorizedField, new PermissionsEditor$1_0(recordBeingEdited));
    $addChangedHandler_0(authorizedField, new PermissionsEditor$2_0(this$static, grid, nameField));
  }
  return authorizedField;
}

function $createGlobalPermissionRecord(this$static, displayName, icon, globalPermission, description){
  var record;
  record = new ListGridRecord_0;
  record.jsObj['displayName'] = displayName;
  record.jsObj['icon'] = icon;
  $setAttribute_13(record, 'name', globalPermission.name_0);
  record.jsObj['description'] = description;
  $setAttribute_16(record, 'authorized', this$static.selectedPermissions.contains_0(globalPermission));
  return record;
}

function $createIconField(){
  var iconField;
  iconField = new ListGridField_4('icon', '&nbsp;', 28);
  $setAttribute_8(iconField, 'showDefaultContextMenu', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setAttribute_8(iconField, 'canSort', FALSE);
  $setAttribute_13(iconField, 'align', ($clinit_Alignment() , CENTER_0).value_0);
  $setAttribute_13(iconField, 'type', ($clinit_ListGridFieldType() , IMAGE_0).value_0);
  iconField.jsObj['imageURLSuffix'] = '_16.png';
  iconField.jsObj['imageWidth'] = 16;
  iconField.jsObj['imageHeight'] = 16;
  return iconField;
}

function $createPermissionsGrid(){
  var grid;
  grid = new ListGrid_0;
  $setAttribute_24(grid, 'autoFitData', ($clinit_Autofit() , BOTH_0).value_0, true);
  $setWrapCells(grid, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setFixedRecordHeights(grid, FALSE);
  return grid;
}

function $createResourcePermissionRecord(this$static, displayName, icon, readPermission, readDescription, writePermission, writeDescription){
  var record;
  record = new ListGridRecord_0;
  record.jsObj['displayName'] = displayName;
  record.jsObj['icon'] = icon;
  $setAttribute_13(record, 'readName', readPermission.name_0);
  $setAttribute_16(record, 'readAuthorized', this$static.selectedPermissions.contains_0(readPermission));
  record.jsObj['description'] = '<b>\u010C\xEDst:<\/b> ' + readDescription + '<br/><b>Z\xE1pis:<\/b> ' + writeDescription;
  $setAttribute_13(record, 'writeName', writePermission.name_0);
  $setAttribute_16(record, 'writeAuthorized', this$static.selectedPermissions.contains_0(writePermission));
  return record;
}

function $createVerticalSpacer(){
  var spacer;
  spacer = new VLayout_0;
  $isCreated_1(spacer)?$setProperty_0(spacer, 'height', 13):(spacer.config_0['height'] = 13 , undefined);
  return spacer;
}

function $redraw_1(this$static){
  var globalPermissionRecords, permission, permissionName, readPermission, readPermissionName, record, record$index, record$max, resourcePermissionRecords, writePermission, writePermissionName, nativeArray, permissionRecords;
  this$static.selectedPermissions = (nativeArray = $getValue(this$static.roleEditView.form_0, 'permissions') , this$static.originalValue == null && (this$static.originalValue = nativeArray) , permissionRecords = convertToListGridRecordArray_0(dynamicCastJso(nativeArray)) , toPermissionSet(permissionRecords));
  globalPermissionRecords = this$static.globalPermissionsGrid.getRecords();
  for (record$index = 0 , record$max = globalPermissionRecords.length; record$index < record$max; ++record$index) {
    record = globalPermissionRecords[record$index];
    permissionName = getAttribute(record.jsObj, 'name');
    permission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_49), permissionName), Q$Permission));
    $setAttribute_16(record, 'authorized', this$static.selectedPermissions.contains_0(permission));
  }
  resourcePermissionRecords = this$static.resourcePermissionsGrid.getRecords();
  for (record$index = 0 , record$max = resourcePermissionRecords.length; record$index < record$max; ++record$index) {
    record = resourcePermissionRecords[record$index];
    readPermissionName = getAttribute(record.jsObj, 'readName');
    readPermission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_49), readPermissionName), Q$Permission));
    $setAttribute_16(record, 'readAuthorized', this$static.selectedPermissions.contains_0(readPermission));
    writePermissionName = getAttribute(record.jsObj, 'writeName');
    writePermission = dynamicCast(valueOf($MAP_49, writePermissionName), Q$Permission);
    $setAttribute_16(record, 'writeAuthorized', this$static.selectedPermissions.contains_0(writePermission));
  }
  $markForRedraw(this$static);
}

function $updatePermissions(this$static, authorized, permission){
  var message, messageString, permissionRecords, redrawRequired;
  messageString = null;
  redrawRequired = false;
  if (authorized.value_0) {
    this$static.selectedPermissions.add(permission);
    if (permission == ($clinit_Permission() , MANAGE_SECURITY)) {
      if (this$static.selectedPermissions.addAll(allOf(Lorg_rhq_core_domain_authz_Permission_2_classLit))) {
        messageString = 'Automaticky ozna\u010Deny neozna\u010Den\xE1 povolen\xED, proto\u017Ee MANAGE_SECURITY implikuje povolen\xED na v\u0161ech pr\xE1v...';
        redrawRequired = true;
      }
    }
     else if (permission == MANAGE_INVENTORY) {
      if (this$static.selectedPermissions.addAll(RESOURCE_ALL)) {
        messageString = 'Automaticky ozna\u010Deny neozna\u010Den\xE9 zdroje, proto\u017Ee MANAGE_INVENTORY implikuje povolen\xED na v\u0161ech zdroj\xEDch...';
        redrawRequired = true;
      }
    }
     else if (permission == CONFIGURE_WRITE) {
      if (this$static.selectedPermissions.add(CONFIGURE_READ)) {
        messageString = 'Automaticky ozna\u010Deno CONFIGURE_READ povolen\xED, proto\u017Ee CONFIGURE_WRITE jej implikuje...';
        redrawRequired = true;
      }
    }
  }
   else {
    this$static.selectedPermissions.remove_0(permission);
  }
  permissionRecords = toRecordArray(this$static.selectedPermissions);
  $setValue_2(this$static.roleEditView.form_0, 'permissions', permissionRecords);
  redrawRequired && $redraw_1(this$static);
  if (messageString != null) {
    message = new Message_6(messageString, of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
  }
}

function PermissionsEditor_0(roleEditView, isReadOnly){
  var productInfo, grid, iconField, displayNameField, descriptionField, authorizedField, records, record, grid_0, iconField_0, displayNameField_0, descriptionField_0, readField, writeField, records_0, record_0;
  $clinit_PermissionsEditor();
  var globalPermissionsHeader, resourcePermissionsHeader, spacer;
  EnhancedVStack_0.call(this);
  this.roleEditView = roleEditView;
  this.isReadOnly = isReadOnly;
  this.selectedPermissions = of(($clinit_Permission() , VIEW_RESOURCE));
  $isCreated_1(this)?$setProperty_3(this, 'width', '95%'):(this.config_0['width'] = '95%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
  spacer = $createVerticalSpacer();
  $addMember(this, spacer);
  globalPermissionsHeader = new Label_4('<h4>Glob\xE1ln\xED povolen\xED<\/h4>');
  $isCreated_1(globalPermissionsHeader)?$setProperty_0(globalPermissionsHeader, 'height', 17):(globalPermissionsHeader.config_0['height'] = 17 , undefined);
  $addMember(this, globalPermissionsHeader);
  this.globalPermissionsGrid = (productInfo = ($clinit_CoreGUI() , $clinit_CoreGUI() , coreGUI).productInfo , grid = $createPermissionsGrid() , iconField = $createIconField() , displayNameField = new ListGridField_4('displayName', 'Jm\xE9no', 130) , descriptionField = new ListGridField_3('description', 'Popis') , descriptionField.jsObj['wrap'] = true , authorizedField = $createAuthorizedField(this, 'authorized', 'Autorizov\xE1n?', 'name', grid, false) , $isCreated_1(grid)?$setProperty_2(grid, 'fields', convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField, displayNameField, authorizedField, descriptionField]))):(grid.config_0['fields'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField, displayNameField, authorizedField, descriptionField])) , undefined) , records = new ArrayList_0 , record = $createGlobalPermissionRecord(this, 'Spravovat bezpe\u010Dnost', 'global/Locked', MANAGE_SECURITY, 'm\u016F\u017Ee vytv\xE1\u0159et, m\u011Bnit, mazat u\u017Eivatele a role - implikuje v\u0161echna ostatn\xED povolen\xED') , setCheck(records.array, records.size_0++, record) , record = $createGlobalPermissionRecord(this, 'Spravovat invent\xE1\u0159', 'subsystems/inventory/Inventory', MANAGE_INVENTORY, 'm\xE1 v\u0161echna pr\xE1va zdroje: m\u016F\u017Ee vytv\xE1\u0159et, m\u011Bnit, mazat skupiny, m\u016F\u017Ee importovat automaticky nebo manu\xE1ln\u011B nalezen\xE9 zdroje') , setCheck(records.array, records.size_0++, record) , record = $createGlobalPermissionRecord(this, 'Spravovat nastaven\xED', 'subsystems/configure/Configure', MANAGE_SETTINGS, 'm\u016F\u017Ee modifikovat ' + productInfo.shortName + ' serverovou konfiguraci a provozovat jak\xE9koli operace souvisej\xEDc\xED se serverem') , setCheck(records.array, records.size_0++, record) , record = $createGlobalPermissionRecord(this, 'Spravovat bal\xEDky', 'subsystems/bundle/Bundle', MANAGE_BUNDLE, 'm\u016F\u017Ee vytv\xE1\u0159et, m\u011Bnit, mazat bal\xEDky (zobrazovat m\u016F\u017Ee kdokoli)') , setCheck(records.array, records.size_0++, record) , record = $createGlobalPermissionRecord(this, 'Spravovat repozit\xE1\u0159e', 'subsystems/content/Content', MANAGE_REPOSITORIES, 'm\u016F\u017Ee vytv\xE1\u0159et, m\u011Bnit, mazat repozit\xE1\u0159e jak\xFDchkoli u\u017Eivatel\u016F (ka\u017Ed\xFD m\u016F\u017Ee vytv\xE1\u0159et sv\xE9 repozit\xE1\u0159e), m\u016F\u017Ee asociovat zdroje obsah\u016F s repozit\xE1\u0159i') , setCheck(records.array, records.size_0++, record) , record = $createGlobalPermissionRecord(this, 'Zobrazit u\u017Eivatel\xE9', 'global/User', VIEW_USERS, 'm\u016F\u017Ee zobrazovat ostatn\xED u\u017Eivatele s v\xFDjimkou jejich p\u0159i\u0159azen\xFDch rol\xED') , setCheck(records.array, records.size_0++, record) , $setData(grid, dynamicCast($toArray_1(records, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, records.size_0, 0)), Q$ListGridRecord_$1)) , grid);
  $addMember(this, this.globalPermissionsGrid);
  spacer = $createVerticalSpacer();
  $addMember(this, spacer);
  resourcePermissionsHeader = new Label_4('<h4>Opr\xE1vn\u011Bn\xED zdroje<\/h4>');
  $isCreated_1(resourcePermissionsHeader)?$setProperty_0(resourcePermissionsHeader, 'height', 17):(resourcePermissionsHeader.config_0['height'] = 17 , undefined);
  $addMember(this, resourcePermissionsHeader);
  this.resourcePermissionsGrid = (grid_0 = $createPermissionsGrid() , iconField_0 = $createIconField() , displayNameField_0 = new ListGridField_4('displayName', 'Jm\xE9no', 130) , descriptionField_0 = new ListGridField_3('description', 'Popis') , descriptionField_0.jsObj['wrap'] = true , readField = $createAuthorizedField(this, 'readAuthorized', '\u010Cten\xED?', 'readName', grid_0, true) , writeField = $createAuthorizedField(this, 'writeAuthorized', 'Z\xE1pis?', 'writeName', grid_0, false) , $isCreated_1(grid_0)?$setProperty_2(grid_0, 'fields', convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField_0, displayNameField_0, readField, writeField, descriptionField_0]))):(grid_0.config_0['fields'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, [iconField_0, displayNameField_0, readField, writeField, descriptionField_0])) , undefined) , records_0 = new ArrayList_0 , record_0 = $createResourcePermissionRecord(this, 'Inventarizovat', 'subsystems/inventory/Inventory', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED vlastnosti zdroje (jm\xE9no, popis, verze, atd.), nastaven\xED p\u0159ipojen\xED a historii nastaven\xED p\u0159ipojen\xED', MODIFY_RESOURCE, 'm\u011Bnit jm\xE9no zdroje, verzi, popis a nastaven\xED p\u0159ipojen\xED, historie') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Spravovat m\u011B\u0159en\xED', 'subsystems/monitor/Monitor', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED sb\xEDran\xE1 data v\u010Detn\u011B rozvrh\u016F sb\u011Br\u016F dat', MANAGE_MEASUREMENTS, 'm\u011Bnit rozvrhy sb\u011Bru metrik') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Spravovat v\xFDstrahy', 'subsystems/alert/Alerts', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED definice v\xFDstrah a jejich historii', MANAGE_ALERTS, 'vytvo\u0159it, m\u011Bnit a mazat definice v\xFDstrah, historie') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Konfigurovat', 'subsystems/configure/Configure', CONFIGURE_READ, 'zobraz\xED konfiguraci zdroje a historii konfigurace zdroje', CONFIGURE_WRITE, 'zm\u011Bn\xED konfiguraci zdroje; sma\u017Ee historii zm\u011Bn konfigurace zdroje') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Ovl\xE1d\xE1n\xED', 'subsystems/control/Operation', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED dostupn\xE9 operace a historii spou\u0161t\u011Bn\xED operac\xED', CONTROL_0, 'spou\u011Bt\u011Bn\xED operac\xED, maz\xE1n\xED historie spu\u0161t\u011Bn\xFDch operac\xED') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Spravovat ud\xE1losti', 'subsystems/event/Events', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED ud\xE1losti', MANAGE_EVENTS, 'mazat ud\xE1losti') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Spravovat obsah', 'subsystems/content/Content', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED nainstalovan\xE9 a dostupn\xE9 bal\xEDky, historie', MANAGE_CONTENT, 'p\u0159ihl\xE1sit se k odb\u011Bru obsahu, instalovat a odinstalovat bal\xEDky') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Vytv\xE1\u0159et potomky zdroj\u016F', 'subsystems/inventory/CreateChild', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED historii potomk\u016F zdroje', CREATE_CHILD_RESOURCES, 'vytv\xE1\u0159et nov\xE9 potomky zdroje (pokud to umo\u017E\u0148uje typ zdroje)') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Vytv\xE1\u0159et potomky zdroj\u016F', 'subsystems/inventory/DeleteChild', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED historii maz\xE1n\xED zdroje', DELETE_RESOURCE, 'vy\u0159adit zdroje z invent\xE1\u0159e, mazat zdroje (pokud to typ zdroje umo\u017E\u0148uje)') , setCheck(records_0.array, records_0.size_0++, record_0) , record_0 = $createResourcePermissionRecord(this, 'Spravovat drift', 'subsystems/drift/Drift', VIEW_RESOURCE, '(V\xDDCHOZ\xCD) zobraz\xED definice drift\u016F, historie', MANAGE_DRIFT, 'vytvo\u0159it, zm\u011Bnit a smazat definici driftu') , setCheck(records_0.array, records_0.size_0++, record_0) , $setData(grid_0, dynamicCast($toArray_1(records_0, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, records_0.size_0, 0)), Q$ListGridRecord_$1)) , grid_0);
  $addMember(this, this.resourcePermissionsGrid);
}

function convertToListGridRecordArray_0(jsObject){
  var i, jsArray, jsArrayItem, record, records;
  if (!jsObject) {
    return initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, 0, 0);
  }
  jsArray = toArray_3(jsObject);
  records = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, jsArray.length, 0);
  for (i = 0; i < jsArray.length; ++i) {
    jsArrayItem = jsArray[i];
    record = dynamicCast(getRef(jsArrayItem), Q$ListGridRecord);
    !record && (record = new ListGridRecord_1(jsArrayItem));
    setCheck(records, i, record);
  }
  return records;
}

function handleIllegalPermissionSelection(event_0, messageString){
  var jsObj;
  $clinit_PermissionsEditor();
  var message;
  (jsObj = event_0.jsObj , getOrCreateRef_6(jsObj.item)).setValue_6(true);
  message = new Message_8(messageString, ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
  $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
}

defineSeed(1692, 1636, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$Enhanced]), PermissionsEditor_0);
_.redraw_0 = function redraw_0(){
  $redraw_1(this);
}
;
_.globalPermissionsGrid = null;
_.isReadOnly = false;
_.originalValue = null;
_.resourcePermissionsGrid = null;
_.roleEditView = null;
_.selectedPermissions = null;
function PermissionsEditor$1_0(val$recordBeingEdited){
  this.val$recordBeingEdited = val$recordBeingEdited;
}

defineSeed(1693, 1, makeCastMap([Q$EventHandler, Q$RecordClickHandler]), PermissionsEditor$1_0);
_.onRecordClick = function onRecordClick(event_0){
  setCheck(this.val$recordBeingEdited, 0, $getRecord_0(event_0));
}
;
_.val$recordBeingEdited = null;
function PermissionsEditor$2_0(this$0, val$grid, val$nameField){
  this.this$0 = this$0;
  this.val$grid = val$grid;
  this.val$nameField = val$nameField;
}

defineSeed(1694, 1, makeCastMap([Q$EventHandler, Q$ChangedHandler_0]), PermissionsEditor$2_0);
_.onChanged_0 = function onChanged_0(event_0){
  var authorized, messageString, permission, permissionDisplayName, permissionName, record, recordNum;
  authorized = dynamicCast($getValue_4(event_0), Q$Boolean);
  recordNum = $getRowNum_0(event_0);
  record = this.val$grid.getRecord_0(recordNum);
  permissionName = $getAttribute(record, this.val$nameField);
  permission = ($clinit_Permission() , dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_49), permissionName), Q$Permission));
  permissionDisplayName = getAttribute(record.jsObj, 'displayName');
  if (permission == VIEW_RESOURCE) {
    messageString = 'P\u0159\xEDstup pro \u010Dten\xED pro ' + ($clinit_PermissionsEditor() , permissionDisplayName) + ' je v\xFDchoz\xED a nem\u016F\u017Ee b\xFDt zak\xE1z\xE1n.';
    handleIllegalPermissionSelection(event_0, messageString);
  }
   else if (!authorized.value_0 && this.this$0.selectedPermissions.contains_0(MANAGE_SECURITY) && permission != MANAGE_SECURITY) {
    messageString = ($clinit_PermissionsEditor() , permissionDisplayName) + ' permission cannot be deselected, unless the Manage Security permission, which implies all other permissions, is deselected first.';
    handleIllegalPermissionSelection(event_0, messageString);
  }
   else if (!authorized.value_0 && this.this$0.selectedPermissions.contains_0(MANAGE_INVENTORY) && permission.target_0 == ($clinit_Permission$Target() , RESOURCE)) {
    messageString = ($clinit_PermissionsEditor() , permissionDisplayName) + ' permission cannot be deselected, unless Manage Inventory, which implies all Resource permissions, is deselected first.';
    handleIllegalPermissionSelection(event_0, messageString);
  }
   else if (!authorized.value_0 && this.this$0.selectedPermissions.contains_0(CONFIGURE_WRITE) && permission == CONFIGURE_READ) {
    messageString = $view_adminRoles_permissions_illegalDeselectionDueToCorrespondingWritePermSelection(($clinit_PermissionsEditor() , permissionDisplayName));
    handleIllegalPermissionSelection(event_0, messageString);
  }
   else {
    $updatePermissions(this.this$0, authorized, permission);
    $onItemChanged(this.this$0.roleEditView);
  }
}
;
_.this$0 = null;
_.val$grid = null;
_.val$nameField = null;
function $clinit_AbstractRecordEditor(){
  $clinit_AbstractRecordEditor = nullMethod;
  $clinit_BaseWidget();
  LOADING_LABEL = new Label_4(($clinit_Enhanced() , 'Nahr\xE1v\xE1m...'));
}

function $buildButtonBar(this$static){
  if (this$static.isReadOnly) {
    return null;
  }
  return new AbstractRecordEditor$ButtonBar_0(this$static);
}

function $buildContentPane(this$static){
  var contentPane;
  contentPane = new EnhancedVLayout_0;
  $isCreated_1(contentPane)?$setProperty_3(contentPane, 'width', '100%'):(contentPane.config_0['width'] = '100%' , undefined);
  $isCreated_1(contentPane)?$setProperty_3(contentPane, 'height', '100%'):(contentPane.config_0['height'] = '100%' , undefined);
  $setAttribute_24(contentPane, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
  this$static.form_0 = this$static.buildForm();
  $addMember(contentPane, this$static.form_0);
  return contentPane;
}

function $buildForm(this$static){
  var form, isNewRecord, items;
  isNewRecord = this$static.recordId == 0;
  form = new EnhancedDynamicForm_2(this$static.isFormReadOnly(), isNewRecord);
  $setAttribute_20(form, 'dataSource', $getOrCreateJsObj(this$static.dataSource), true);
  items = this$static.createFormItems(form);
  $setFields_3(form, dynamicCast($toArray_1(items, initDim(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, items.size_0, 0)), Q$FormItem_$1));
  $addItemChangedHandler(form, new AbstractRecordEditor$1_0(this$static));
  return form;
}

function $displayForm(this$static){
  var member, member$array, member$index, member$max;
  $removeMember(this$static, LOADING_LABEL);
  $destroy(LOADING_LABEL);
  for (member$array = convertToCanvasArray($getAttributeAsJavaScriptObject_1(this$static, 'members')) , member$index = 0 , member$max = member$array.length; member$index < member$max; ++member$index) {
    member = member$array[member$index];
    member.show_0();
  }
  $markForRedraw(this$static);
}

function $editExistingRecord(this$static, record){
  var recordName, title;
  recordName = $getAttribute(record, this$static.getTitleFieldName());
  title = this$static.isReadOnly?'Zobrazit ' + ($clinit_Enhanced() , this$static.dataTypeName) + ' [' + recordName + ']':'Editovat ' + ($clinit_Enhanced() , this$static.dataTypeName) + ' [' + recordName + ']';
  $setTitle_3(this$static.titleBar, title);
  $editRecord(this$static.form_0, record);
  $validate(this$static.form_0);
  this$static.editRecord_0(record);
}

function $editNewRecord(this$static){
  var idItem, record;
  $setTitle_3(this$static.titleBar, 'Vytvo\u0159it nov\xFD ' + ($clinit_Enhanced() , this$static.dataTypeName));
  record = this$static.createNewRecord();
  $editRecord(this$static.form_0, record);
  $setAttribute_24(this$static.form_0, 'saveOperationType', ($clinit_DSOperationType() , ADD).value_0, true);
  idItem = $getField_0(this$static.form_0, 'id');
  if (idItem) {
    idItem.setDefaultValue(valueOf_44(0));
    $hide_0(idItem);
  }
  this$static.editRecord_0(record);
}

function $fetchExistingRecord(this$static, recordId){
  var criteria;
  criteria = new Criteria_0;
  $addCriteria_1(criteria, 'id', valueOf_44(recordId));
  $fetchData_1(this$static.form_0, criteria, new AbstractRecordEditor$3_0(this$static));
}

function $init_1(this$static, isReadOnly){
  var message;
  if (this$static.recordId == 0 && isReadOnly) {
    message = new Message_7('[' + ($clinit_Enhanced() , this$static.dataTypeName) + '] nemohl b\xFDt vytvo\u0159en, Nem\xE1te po\u017Eadovan\xE1 opr\xE1vn\u011Bn\xED.', ($clinit_Message$Severity() , Error_2));
    $clinit_CoreGUI();
    goToView(this$static.getListViewPath(), message, false);
  }
   else {
    this$static.isReadOnly = isReadOnly;
    this$static.contentPane = this$static.buildContentPane();
    this$static.contentPane.hide_0();
    $addMember(this$static, this$static.contentPane);
    this$static.buttonBar = this$static.buildButtonBar();
    if (this$static.buttonBar) {
      $hide(this$static.buttonBar);
      $addMember(this$static, this$static.buttonBar);
    }
    if (this$static.recordId == 0) {
      $editNewRecord(this$static);
      $displayForm(this$static);
    }
     else {
      $fetchExistingRecord(this$static, this$static.recordId);
    }
  }
}

function $onItemChanged(this$static){
  var resetButton, saveButton;
  if (!this$static.isReadOnly) {
    saveButton = this$static.buttonBar.saveButton;
    $isDisabled(saveButton).value_0 && $setAttribute_22(saveButton, 'disabled', ($clinit_Boolean() , $clinit_Boolean() , FALSE), true);
    resetButton = this$static.buttonBar.resetButton;
    $isDisabled(resetButton).value_0 && $setAttribute_22(resetButton, 'disabled', ($clinit_Boolean() , $clinit_Boolean() , FALSE), true);
  }
}

function $renderView_1(this$static, viewPath){
  var parentViewPath;
  ++viewPath.index_0;
  parentViewPath = $getPathToIndex(viewPath, viewPath.index_0 - 1);
  this$static.listViewPath = parentViewPath;
}

function $save_0(this$static, requestProperties){
  var message;
  if (!$validate(this$static.form_0)) {
    message = new Message_8('Jeden nebo v\xEDce pol\xED m\xE1 neplatn\xE9 hodnoty. [' + ($clinit_Enhanced() , this$static.dataTypeName) + '] nem\u016F\u017Ee b\xFDt ulo\u017Een dokud nebudou hodnoty v po\u0159\xE1dku.', ($clinit_Message$Severity() , Warning), of(($clinit_Message$Option() , Transient)));
    $notify(($clinit_CoreGUI() , $clinit_CoreGUI() , messageCenter_0), message);
    return;
  }
  $saveData_0(this$static.form_0, new AbstractRecordEditor$2_0(this$static), requestProperties);
}

function AbstractRecordEditor_0(dataSource, recordId, dataTypeName, headerIcon){
  EnhancedVLayout_0.call(this);
  this.dataSource = dataSource;
  this.recordId = recordId;
  this.dataTypeName = charToString(toUpperCase(dataTypeName.charCodeAt(0))) + $substring(dataTypeName, 1);
  $setLayoutMargin(this, valueOf_44(0));
  $isCreated_1(this)?$setProperty_0(this, 'membersMargin', 16):(this.config_0['membersMargin'] = 16 , undefined);
  $addMember(this, LOADING_LABEL);
  this.titleBar = new TitleBar_1(null, headerIcon);
  $hide(this.titleBar);
  $addMember(this, this.titleBar);
}

function toListGridRecordArray(roleRecords){
  var i, roleListGridRecords, roleRecord, roleRecordsLength;
  roleListGridRecords = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, roleRecords.length, 0);
  for (i = 0 , roleRecordsLength = roleRecords.length; i < roleRecordsLength; ++i) {
    roleRecord = roleRecords[i];
    setCheck(roleListGridRecords, i, dynamicCast(roleRecord, Q$ListGridRecord));
  }
  return roleListGridRecords;
}

defineSeed(1696, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$BookmarkableView, Q$DetailsView, Q$Enhanced]));
_.buildButtonBar = function buildButtonBar(){
  return $buildButtonBar(this);
}
;
_.buildContentPane = function buildContentPane(){
  return $buildContentPane(this);
}
;
_.buildForm = function buildForm(){
  return $buildForm(this);
}
;
_.createNewRecord = function createNewRecord(){
  return new ListGridRecord_0;
}
;
_.editExistingRecord = function editExistingRecord(record){
  $editExistingRecord(this, record);
}
;
_.editRecord_0 = function editRecord(record){
}
;
_.getListViewPath = function getListViewPath(){
  return this.listViewPath;
}
;
_.getTitleFieldName = function getTitleFieldName_0(){
  return 'name';
}
;
_.isEditable_0 = function isEditable_0(){
  return !this.isReadOnly;
}
;
_.isFormReadOnly = function isFormReadOnly(){
  return this.isReadOnly;
}
;
_.renderView = function renderView_2(viewPath){
  $renderView_1(this, viewPath);
}
;
_.reset_1 = function reset_0(){
  $resetValues(this.form_0);
}
;
_.save = function save_0(requestProperties){
  $save_0(this, requestProperties);
}
;
_.buttonBar = null;
_.contentPane = null;
_.dataSource = null;
_.dataTypeName = null;
_.form_0 = null;
_.isReadOnly = false;
_.listViewPath = null;
_.postFetchHandlerExecutedAlready = false;
_.recordId = 0;
_.titleBar = null;
var LOADING_LABEL;
function $checkIfLdapConfigured(this$static){
  $checkLdapConfiguredStatus(dynamicCast(secure(getInstance_44(), -1), Q$LdapGWTServiceAsync), new RoleEditView$2_0(this$static));
}

function $init_2(this$static){
  var isReadOnly;
  isReadOnly = !this$static.hasManageSecurityPermission;
  $init_1(this$static, isReadOnly);
}

function RoleEditView_0(roleId){
  $clinit_AbstractRecordEditor();
  AbstractRecordEditor_0.call(this, new RolesDataSource_0, roleId, ($clinit_Enhanced() , 'role'), 'global/Role_24.png');
}

function updateTab(tab, content_0){
  if (!tab) {
    throw new IllegalStateException_1('A null tab was specified.');
  }
  $updateTab(tab.tabSet, tab, content_0);
}

defineSeed(1695, 1696, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$BookmarkableView, Q$DetailsView, Q$Enhanced]), RoleEditView_0);
_.buildContentPane = function buildContentPane_0(){
  var contentPane, form, tabSet, topPane;
  contentPane = new EnhancedVLayout_0;
  $isCreated_1(contentPane)?$setProperty_3(contentPane, 'width', '100%'):(contentPane.config_0['width'] = '100%' , undefined);
  $isCreated_1(contentPane)?$setProperty_3(contentPane, 'height', '100%'):(contentPane.config_0['height'] = '100%' , undefined);
  $setAttribute_24(contentPane, 'overflow', ($clinit_Overflow() , AUTO).value_0, false);
  form = $buildForm(this);
  this.form_0 = form;
  topPane = new EnhancedVLayout_0;
  $isCreated_1(topPane)?$setProperty_3(topPane, 'width', '100%'):(topPane.config_0['width'] = '100%' , undefined);
  $isCreated_1(topPane)?$setProperty_0(topPane, 'height', 80):(topPane.config_0['height'] = 80 , undefined);
  $addMember(topPane, form);
  $addMember(contentPane, topPane);
  tabSet = new TabSet_0;
  $isCreated_1(tabSet)?$setProperty_3(tabSet, 'width', '100%'):(tabSet.config_0['width'] = '100%' , undefined);
  $isCreated_1(tabSet)?$setProperty_3(tabSet, 'height', '100%'):(tabSet.config_0['height'] = '100%' , undefined);
  if (this.hasManageSecurityPermission) {
    this.permissionsTab = new Tab_2(($clinit_Enhanced() , 'Povolen\xED'), 'global/Locked_16.png');
    $addTab(tabSet, this.permissionsTab);
    if (!this.isSystemRole) {
      this.resourceGroupsTab = new Tab_2('Skupiny zdroj\u016F', getGroupIcon(($clinit_GroupCategory() , MIXED_0)));
      $addTab(tabSet, this.resourceGroupsTab);
    }
    this.subjectsTab = new Tab_2('U\u017Eivatel\xE9', 'global/User_16.png');
    $addTab(tabSet, this.subjectsTab);
    this.ldapGroupsTab = new Tab_2('LDAP skupiny', 'global/Role_16.png');
    $addTab(tabSet, this.ldapGroupsTab);
  }
  $addMember(contentPane, tabSet);
  return contentPane;
}
;
_.createFormItems = function createFormItems(form){
  var descriptionItem, items, nameItem;
  items = new ArrayList_0;
  nameItem = new TextItem_2('name');
  $setShowTitle_0(nameItem, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  $setSelectOnFocus(nameItem, TRUE);
  $setTabIndex(nameItem, valueOf_44(1));
  $isCreated_2(nameItem)?$setProperty_9(nameItem, 'outputAsHTML', true):(nameItem.jsObj['outputAsHTML'] = true , undefined);
  setCheck(items.array, items.size_0++, nameItem);
  descriptionItem = new TextItem_2('description');
  $setShowTitle_0(descriptionItem, TRUE);
  $setTabIndex(descriptionItem, valueOf_44(5));
  $setColSpan(descriptionItem, $getAttributeAsInt_0(form, 'numCols').value_0);
  $isCreated_2(descriptionItem)?$setProperty_9(descriptionItem, 'outputAsHTML', true):(descriptionItem.jsObj['outputAsHTML'] = true , undefined);
  setCheck(items.array, items.size_0++, descriptionItem);
  return items;
}
;
_.createNewRecord = function createNewRecord_0(){
  var role, roleRecord;
  role = new Role_0;
  $addPermission(role, ($clinit_Permission() , VIEW_USERS));
  roleRecord = $copyValues_5(($clinit_RPCDataSource() , !INSTANCE_2 && (INSTANCE_2 = new RolesDataSource_0) , $clinit_RPCDataSource() , role), true);
  return roleRecord;
}
;
_.editRecord_0 = function editRecord_0(record){
  var filteredSubjectRecords, groupListGridRecords, groupRecords, isMemberOfRole, label, ldapGroupListGridRecords, ldapGroupRecords, sessionSubject, sessionSubjectId, subjectId, subjectListGridRecord, subjectListGridRecord$index, subjectListGridRecord$max, subjectListGridRecords, subjectRecord, subjectRecord$index, subjectRecord$max, subjectRecords;
  sessionSubject = ($clinit_UserSessionManager() , $clinit_UserSessionManager() , sessionSubject_0);
  sessionSubjectId = sessionSubject.id;
  subjectRecords = convertToRecordArray(getAttributeAsJavaScriptObject(record.jsObj, 'subjects'));
  isMemberOfRole = false;
  for (subjectRecord$index = 0 , subjectRecord$max = subjectRecords.length; subjectRecord$index < subjectRecord$max; ++subjectRecord$index) {
    subjectRecord = subjectRecords[subjectRecord$index];
    subjectId = getAttributeAsInt(subjectRecord.jsObj, 'id').value_0;
    subjectId == sessionSubjectId && (isMemberOfRole = true);
  }
  if (this.hasManageSecurityPermission || isMemberOfRole) {
    this.permissionsEditor = new PermissionsEditor_0(this, !this.hasManageSecurityPermission || this.isSystemRole);
    updateTab(this.permissionsTab, this.permissionsEditor);
    if (!this.isSystemRole) {
      groupRecords = convertToRecordArray(getAttributeAsJavaScriptObject(record.jsObj, 'resourceGroups'));
      groupListGridRecords = toListGridRecordArray(groupRecords);
      this.resourceGroupSelector = new RoleResourceGroupSelector_0(groupListGridRecords, !this.hasManageSecurityPermission);
      $addAssignedItemsChangedHandler(this.resourceGroupSelector, new RoleEditView$3_0(this));
      updateTab(this.resourceGroupsTab, this.resourceGroupSelector);
    }
    subjectListGridRecords = toListGridRecordArray(subjectRecords);
    if (this.recordId == 1) {
      filteredSubjectRecords = new ArrayList_0;
      for (subjectListGridRecord$index = 0 , subjectListGridRecord$max = subjectListGridRecords.length; subjectListGridRecord$index < subjectListGridRecord$max; ++subjectListGridRecord$index) {
        subjectListGridRecord = subjectListGridRecords[subjectListGridRecord$index];
        subjectId = getAttributeAsInt(subjectListGridRecord.jsObj, 'id').value_0;
        subjectId == 2 && subjectListGridRecord.setEnabled(($clinit_Boolean() , $clinit_Boolean() , FALSE));
        subjectId != 1 && (setCheck(filteredSubjectRecords.array, filteredSubjectRecords.size_0++, subjectListGridRecord) , true);
      }
      subjectListGridRecords = dynamicCast($toArray_1(filteredSubjectRecords, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, filteredSubjectRecords.size_0, 0)), Q$ListGridRecord_$1);
    }
    this.subjectSelector = new RoleSubjectSelector_0(subjectListGridRecords, !this.hasManageSecurityPermission);
    $addAssignedItemsChangedHandler(this.subjectSelector, new RoleEditView$4_0(this));
    updateTab(this.subjectsTab, this.subjectSelector);
    if (this.isLdapConfigured) {
      ldapGroupRecords = convertToRecordArray(getAttributeAsJavaScriptObject(record.jsObj, 'ldapGroups'));
      ldapGroupListGridRecords = toListGridRecordArray(ldapGroupRecords);
      this.ldapGroupSelector = new RoleLdapGroupSelector_0(ldapGroupListGridRecords, !this.hasManageSecurityPermission);
      $addAssignedItemsChangedHandler(this.ldapGroupSelector, new RoleEditView$5_0(this));
      updateTab(this.ldapGroupsTab, this.ldapGroupSelector);
    }
     else {
      label = new Label_4('<b>' + ($clinit_Enhanced() , 'POZN\xC1MKA:') + "<\/b> Integrace LDAP nen\xED nakonfigurov\xE1na. K nastaven\xED \u0159\xEDzen\xED bezpe\u010Dnosti p\u0159es LDAP pros\xEDm nav\u0161tivte <a href='#Administration/Configuration/SystemSettings'>Syst\xE9mov\xE1 nastaven\xED<\/a>.");
      $isCreated_1(label)?$setProperty_3(label, 'width', '100%'):(label.config_0['width'] = '100%' , undefined);
      $isCreated_1(label)?$setProperty_0(label, 'height', 20):(label.config_0['height'] = 20 , undefined);
      $setPadding(label, valueOf_44(10));
      updateTab(this.ldapGroupsTab, label);
    }
  }
  $redraw_1(this.permissionsEditor);
}
;
_.isFormReadOnly = function isFormReadOnly_0(){
  return this.isReadOnly || this.isSystemRole;
}
;
_.renderView = function renderView_3(viewPath){
  $renderView_1(this, viewPath);
  this.isSystemRole = ($clinit_RPCDataSource() , this.recordId == 1);
  $loadExplicitGlobalPermissions(($clinit_PermissionsLoader() , new RoleEditView$1_0(this)));
}
;
_.reset_1 = function reset_1(){
  $resetValues(this.form_0);
  !!this.permissionsEditor && $redraw_1(this.permissionsEditor);
  !!this.resourceGroupSelector && $reset_1(this.resourceGroupSelector);
  !!this.subjectSelector && $reset_1(this.subjectSelector);
  !!this.ldapGroupSelector && $reset_1(this.ldapGroupSelector);
}
;
_.save = function save_1(requestProperties){
  var ldapGroupRecords, resourceGroupRecords, subjectRecords;
  if (this.resourceGroupSelector) {
    resourceGroupRecords = this.resourceGroupSelector.assignedGrid.getRecords();
    $setValue_2(this.form_0, 'resourceGroups', resourceGroupRecords);
  }
  if (this.subjectSelector) {
    subjectRecords = this.subjectSelector.assignedGrid.getRecords();
    $setValue_2(this.form_0, 'subjects', subjectRecords);
  }
  if (this.ldapGroupSelector) {
    ldapGroupRecords = this.ldapGroupSelector.assignedGrid.getRecords();
    $setValue_2(this.form_0, 'ldapGroups', ldapGroupRecords);
  }
  $save_0(this, requestProperties);
}
;
_.hasManageSecurityPermission = false;
_.isLdapConfigured = false;
_.isSystemRole = false;
_.ldapGroupSelector = null;
_.ldapGroupsTab = null;
_.permissionsEditor = null;
_.permissionsTab = null;
_.resourceGroupSelector = null;
_.resourceGroupsTab = null;
_.subjectSelector = null;
_.subjectsTab = null;
function RoleEditView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1697, 1, {}, RoleEditView$1_0);
_.onPermissionsLoaded = function onPermissionsLoaded(perms){
  if (!perms) {
    $handleError_0(($clinit_CoreGUI() , 'Failed to load global permissions for current user. Perhaps the Server is down.'), null);
    return;
  }
  this.this$0.hasManageSecurityPermission = perms.contains_0(($clinit_Permission() , MANAGE_SECURITY));
  $checkIfLdapConfigured(this.this$0);
}
;
_.this$0 = null;
function $onSuccess_44(this$static, isLdapConfigured){
  this$static.this$0.isLdapConfigured = isLdapConfigured.value_0;
  $init_2(this$static.this$0);
}

function RoleEditView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1698, 1, {}, RoleEditView$2_0);
_.onFailure = function onFailure_46(caught){
  $handleError_0(($clinit_CoreGUI() , $clinit_Enhanced() , 'Nepoda\u0159ilo se ur\u010Dit je-li LDAP nastaven - p\u0159edpokl\xE1d\xE1m, \u017Ee LDAP nen\xED p\u0159\xEDtomen.'), caught);
}
;
_.onSuccess_0 = function onSuccess_46(isLdapConfigured){
  $onSuccess_44(this, dynamicCast(isLdapConfigured, Q$Boolean));
}
;
_.this$0 = null;
function RoleEditView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1699, 1, makeCastMap([Q$EventHandler, Q$AssignedItemsChangedHandler]), RoleEditView$3_0);
_.onSelectionChanged_0 = function onSelectionChanged(event_0){
  $onItemChanged(this.this$0);
}
;
_.this$0 = null;
function RoleEditView$4_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1700, 1, makeCastMap([Q$EventHandler, Q$AssignedItemsChangedHandler]), RoleEditView$4_0);
_.onSelectionChanged_0 = function onSelectionChanged_0(event_0){
  $onItemChanged(this.this$0);
}
;
_.this$0 = null;
function RoleEditView$5_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1701, 1, makeCastMap([Q$EventHandler, Q$AssignedItemsChangedHandler]), RoleEditView$5_0);
_.onSelectionChanged_0 = function onSelectionChanged_1(event_0){
  $onItemChanged(this.this$0);
}
;
_.this$0 = null;
function $addAssignedItemsChangedHandler(this$static, handler){
  $add_6(this$static.assignedItemsChangedHandlers, handler);
  return new AbstractSelector$14_0;
}

function $addSelectedRows(this$static){
  $moveSelectedData(this$static.availableGrid, this$static.assignedGrid);
  $notifyAssignedItemsChangedHandlers(this$static);
  this$static.updateButtonEnablement();
}

function $buildAssignedItemsStack(this$static){
  var assignedFields, assignedSection, assignedSectionStack, iconField, itemIcon, nameField, itemTitle;
  assignedSectionStack = new SectionStack_0;
  $isCreated_1(assignedSectionStack)?$setProperty_3(assignedSectionStack, 'width', '*'):(assignedSectionStack.config_0['width'] = '*' , undefined);
  $isCreated_1(assignedSectionStack)?$setProperty_3(assignedSectionStack, 'height', '100%'):(assignedSectionStack.config_0['height'] = '100%' , undefined);
  $setAttribute_24(assignedSectionStack, 'align', ($clinit_Alignment() , LEFT_0).value_0, true);
  assignedSection = new SectionStackSection_1((itemTitle = this$static.getItemTitle() , 'P\u0159id\u011Blen\xE9 ' + ($clinit_Enhanced() , itemTitle)));
  $setAttribute_8(assignedSection, 'canCollapse', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setExpanded(assignedSection, TRUE);
  this$static.assignedGrid.setCanReorderRecords(TRUE);
  this$static.assignedGrid.setCanDragRecordsOut(TRUE);
  $setAttribute_24(this$static.assignedGrid, 'dragDataAction', ($clinit_DragDataAction() , MOVE).value_0, true);
  if (this$static.getItemIcon() != null) {
    $setAttribute_24(this$static.assignedGrid, 'dragTrackerMode', ($clinit_DragTrackerMode() , ICON).value_0, false);
    $setAttribute_20(this$static.assignedGrid, 'trackerImage', (new ImgProperties_0(this$static.getItemIcon())).jsObj, true);
  }
  this$static.assignedGrid.setCanAcceptDroppedRecords(TRUE);
  $setLoadingMessage(this$static.assignedGrid, 'Nahr\xE1v\xE1m...');
  this$static.assignedGrid.setEmptyMessage('\u017D\xE1dn\xE9 polo\u017Eky k zobrazen\xED');
  assignedFields = new ArrayList_0;
  itemIcon = this$static.getItemIcon();
  if (itemIcon != null) {
    iconField = new ListGridField_2('icon', 25);
    $setAttribute_13(iconField, 'type', ($clinit_ListGridFieldType() , ICON_0).value_0);
    iconField.jsObj['cellIcon'] = itemIcon;
    $setAttribute_8(iconField, 'showDefaultContextMenu', FALSE);
    setCheck(assignedFields.array, assignedFields.size_0++, iconField);
  }
  nameField = new ListGridField_3('name', 'Jm\xE9no');
  if (this$static.supportsNameHoverCustomizer()) {
    $setAttribute_8(nameField, 'showHover', TRUE);
    $setHoverCustomizer_0(nameField, this$static.getNameHoverCustomizer());
  }
  setCheck(assignedFields.array, assignedFields.size_0++, nameField);
  $setFields_1(this$static.assignedGrid, dynamicCast($toArray_1(assignedFields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, assignedFields.size_0, 0)), Q$ListGridField_$1));
  $setItems(assignedSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [this$static.assignedGrid]));
  $addSection(assignedSectionStack, assignedSection);
  this$static.initialSelection != null && $setData(this$static.assignedGrid, this$static.initialSelection);
  if (this$static.isReadOnly) {
    $setDisabled(this$static.assignedGrid, true);
  }
   else {
    $addSelectionChangedHandler(this$static.assignedGrid, new AbstractSelector$10_0(this$static));
    $addDoubleClickHandler(this$static.assignedGrid, new AbstractSelector$11_0(this$static));
    $addKeyPressHandler(this$static.assignedGrid, new AbstractSelector$12_0(this$static));
    this$static.assignedGrid.addRecordDropHandler(new AbstractSelector$13_0(this$static));
  }
  return assignedSectionStack;
}

function $buildAvailableItemsStack(this$static){
  var availableFields, availableSection, availableSectionStack, iconField, itemIcon, nameField, itemTitle;
  availableSectionStack = new SectionStack_0;
  $isCreated_1(availableSectionStack)?$setProperty_3(availableSectionStack, 'width', '*'):(availableSectionStack.config_0['width'] = '*' , undefined);
  $isCreated_1(availableSectionStack)?$setProperty_3(availableSectionStack, 'height', '100%'):(availableSectionStack.config_0['height'] = '100%' , undefined);
  availableSection = new SectionStackSection_1((itemTitle = this$static.getItemTitle() , 'Dostupn\xE9 ' + ($clinit_Enhanced() , itemTitle)));
  $setAttribute_8(availableSection, 'canCollapse', ($clinit_Boolean() , $clinit_Boolean() , FALSE));
  $setExpanded(availableSection, TRUE);
  this$static.availableGrid.setCanReorderRecords(TRUE);
  this$static.availableGrid.setCanDragRecordsOut(TRUE);
  $setAttribute_24(this$static.availableGrid, 'dragDataAction', ($clinit_DragDataAction() , MOVE).value_0, true);
  if (this$static.getItemIcon() != null) {
    $setAttribute_24(this$static.availableGrid, 'dragTrackerMode', ($clinit_DragTrackerMode() , ICON).value_0, false);
    $setAttribute_20(this$static.availableGrid, 'trackerImage', (new ImgProperties_0(this$static.getItemIcon())).jsObj, true);
  }
  this$static.availableGrid.setCanAcceptDroppedRecords(TRUE);
  $setLoadingMessage(this$static.availableGrid, 'Nahr\xE1v\xE1m...');
  this$static.availableGrid.setEmptyMessage('\u017D\xE1dn\xE9 polo\u017Eky k zobrazen\xED');
  availableFields = new ArrayList_0;
  itemIcon = this$static.getItemIcon();
  if (itemIcon != null) {
    iconField = new ListGridField_2('icon', 25);
    $setAttribute_13(iconField, 'type', ($clinit_ListGridFieldType() , ICON_0).value_0);
    iconField.jsObj['cellIcon'] = itemIcon;
    $setAttribute_8(iconField, 'showDefaultContextMenu', FALSE);
    setCheck(availableFields.array, availableFields.size_0++, iconField);
  }
  nameField = new ListGridField_3('name', 'Jm\xE9no');
  if (this$static.supportsNameHoverCustomizer()) {
    $setAttribute_8(nameField, 'showHover', TRUE);
    $setHoverCustomizer_0(nameField, this$static.getNameHoverCustomizer());
  }
  setCheck(availableFields.array, availableFields.size_0++, nameField);
  $setFields_1(this$static.availableGrid, dynamicCast($toArray_1(availableFields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, availableFields.size_0, 0)), Q$ListGridField_$1));
  $setItems(availableSection, initValues(_3Lcom_smartgwt_client_widgets_Canvas_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Canvas, [this$static.availableGrid]));
  $addSection(availableSectionStack, availableSection);
  this$static.datasource = this$static.getDataSource_0();
  $setDataPageSize(this$static.datasource, valueOf_44(this$static.getMaxAvailableRecords()));
  if (this$static.availableFilterForm) {
    this$static.latestCriteria = this$static.getLatestCriteria(this$static.availableFilterForm);
    $addItemChangedHandler(this$static.availableFilterForm, new AbstractSelector$1_0(this$static));
  }
  $populateAvailableGrid(this$static, !this$static.latestCriteria?new Criteria_0:this$static.latestCriteria);
  $addSelectionChangedHandler(this$static.availableGrid, new AbstractSelector$2_0(this$static));
  $addDoubleClickHandler(this$static.availableGrid, new AbstractSelector$3_0(this$static));
  this$static.availableGrid.addRecordDropHandler(new AbstractSelector$4_0(this$static));
  return availableSectionStack;
}

function $getSelectedItems(this$static){
  var selectedRecords;
  selectedRecords = this$static.assignedGrid.getRecords();
  return $buildDataObjects(new ResourceGroupSelector$SelectedResourceGroupsDataSource_0, selectedRecords);
}

function $getSelection(this$static){
  var id, ids, selectedRecord, selectedRecord$index, selectedRecord$max, selectedRecords;
  selectedRecords = this$static.assignedGrid.getRecords();
  ids = new HashSet_1(selectedRecords.length);
  for (selectedRecord$index = 0 , selectedRecord$max = selectedRecords.length; selectedRecord$index < selectedRecord$max; ++selectedRecord$index) {
    selectedRecord = selectedRecords[selectedRecord$index];
    id = $getAttributeAsInt(selectedRecord, this$static.getSelectorKey());
    $add_6(ids, id);
  }
  return ids;
}

function $moveSelectedData(sourceGrid, targetGrid){
  var self_0, self_1;
  self_0 = targetGrid.getOrCreateJsObj();
  self_0.transferSelectedData(sourceGrid.getOrCreateJsObj());
  self_1 = sourceGrid.getOrCreateJsObj();
  self_1.removeSelectedData();
}

function $notifyAssignedItemsChangedHandlers(this$static){
  var handler, handler$iterator;
  for (handler$iterator = $iterator($keySet(this$static.assignedItemsChangedHandlers.map_0)); handler$iterator.val$outerIter.hasNext();) {
    handler = dynamicCast($next_1(handler$iterator), Q$AssignedItemsChangedHandler);
    handler.onSelectionChanged_0(new AssignedItemsChangedEvent_0($getSelectedRecords(this$static.assignedGrid)));
  }
}

function $onInit_3(this$static){
  var assignedItemsStack, availableItemsStack, moveButtonStack, spacer, moveButtonStack_0;
  $onInit(this$static);
  $onInit_Layout(this$static);
  $setAttribute_24(this$static.hlayout, 'align', ($clinit_Alignment() , LEFT_0).value_0, true);
  if (!this$static.isReadOnly) {
    this$static.messageLayout = new Label_3;
    $setMargin(this$static.messageLayout, valueOf_44(3));
    $setAutoHeight(this$static.messageLayout);
    $addMember(this$static, this$static.messageLayout);
    this$static.availableFilterForm = this$static.getAvailableFilterForm();
    if (this$static.availableFilterForm) {
      $addMember(this$static, this$static.availableFilterForm);
      spacer = new LayoutSpacer_0;
      $isCreated_1(spacer)?$setProperty_0(spacer, 'height', 10):(spacer.config_0['height'] = 10 , undefined);
      $addMember(this$static, spacer);
    }
    availableItemsStack = $buildAvailableItemsStack(this$static);
    $addMember(this$static.hlayout, availableItemsStack);
    moveButtonStack = (moveButtonStack_0 = new EnhancedVStack_1 , $isCreated_1(moveButtonStack_0)?$setProperty_0(moveButtonStack_0, 'width', 42):(moveButtonStack_0.config_0['width'] = 42 , undefined) , $isCreated_1(moveButtonStack_0)?$setProperty_0(moveButtonStack_0, 'height', 250):(moveButtonStack_0.config_0['height'] = 250 , undefined) , $setAttribute_24(moveButtonStack_0, 'align', ($clinit_VerticalAlignment() , CENTER_2).value_0, true) , this$static.addButton = new TransferImgButton_0(($clinit_TransferImgButton() , RIGHT_4)) , $addClickHandler(this$static.addButton, new AbstractSelector$6_0(this$static)) , $addMember(moveButtonStack_0, this$static.addButton) , this$static.removeButton = new TransferImgButton_0(LEFT_4) , $addClickHandler(this$static.removeButton, new AbstractSelector$7_0(this$static)) , $addMember(moveButtonStack_0, this$static.removeButton) , this$static.addAllButton = new TransferImgButton_0(RIGHT_ALL) , $addClickHandler(this$static.addAllButton, new AbstractSelector$8_0(this$static)) , $addMember(moveButtonStack_0, this$static.addAllButton) , this$static.removeAllButton = new TransferImgButton_0(LEFT_ALL) , $addClickHandler(this$static.removeAllButton, new AbstractSelector$9_0(this$static)) , $addMember(moveButtonStack_0, this$static.removeAllButton) , moveButtonStack_0);
    $addMember(this$static.hlayout, moveButtonStack);
  }
  assignedItemsStack = $buildAssignedItemsStack(this$static);
  $addMember(this$static.hlayout, assignedItemsStack);
  this$static.updateButtonEnablement();
  $addMember(this$static, this$static.hlayout);
}

function $populateAvailableGrid(this$static, criteria){
  var requestProperties;
  $invalidateCache(this$static.datasource);
  requestProperties = new DSRequest_0;
  $setStartRow(requestProperties, valueOf_44(0));
  $setEndRow(requestProperties, valueOf_44(this$static.getMaxAvailableRecords()));
  $fetchData_0(this$static.datasource, criteria, new AbstractSelector$5_0(this$static), requestProperties);
}

function $removeSelectedRows(this$static){
  $moveSelectedData(this$static.assignedGrid, this$static.availableGrid);
  $notifyAssignedItemsChangedHandlers(this$static);
  this$static.updateButtonEnablement();
}

function $reset_1(this$static){
  $setData(this$static.assignedGrid, this$static.initialSelection);
  $populateAvailableGrid(this$static, this$static.getLatestCriteria(this$static.getAvailableFilterForm()));
}

function $setAssigned(this$static, assignedRecords){
  this$static.initialSelection = assignedRecords;
}

function AbstractSelector_0(){
  AbstractSelector_1.call(this, false);
}

function AbstractSelector_1(isReadOnly){
  $clinit_BaseWidget();
  EnhancedVLayout_0.call(this);
  this.assignedItemsChangedHandlers = new HashSet_0;
  this.isReadOnly = isReadOnly;
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $setMargin(this, valueOf_44(7));
  this.hlayout = new HLayout_0;
  this.assignedGrid = new ListGrid_0;
  this.isReadOnly?$setAttribute_24(this.assignedGrid, 'selectionType', ($clinit_SelectionStyle() , NONE_4).value_0, true):(this.availableGrid = new ListGrid_0);
}

function containsAtLeastOneEnabledRecord(grid){
  var assignedRecord, assignedRecord$index, assignedRecord$max, assignedRecords, result;
  result = false;
  assignedRecords = grid.getRecords();
  for (assignedRecord$index = 0 , assignedRecord$max = assignedRecords.length; assignedRecord$index < assignedRecord$max; ++assignedRecord$index) {
    assignedRecord = assignedRecords[assignedRecord$index];
    if (getAttribute(assignedRecord.jsObj, 'enabled') == null || assignedRecord.getEnabled().value_0) {
      result = true;
      break;
    }
  }
  return result;
}

defineSeed(1703, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]));
_.addSelectedRows = function addSelectedRows(){
  $addSelectedRows(this);
}
;
_.destroy_0 = function destroy_5(){
  destroyMembers(this.hlayout);
  destroyMembers(this);
  $destroy(this);
  if (this.availableGrid) {
    $removeFromParent(this.availableGrid);
    $destroy(this.availableGrid);
  }
  if (this.assignedGrid) {
    $removeFromParent(this.assignedGrid);
    $destroy(this.assignedGrid);
  }
  if (this.addButton) {
    $removeFromParent(this.addButton);
    $destroy(this.addButton);
  }
  if (this.addAllButton) {
    $removeFromParent(this.addAllButton);
    $destroy(this.addAllButton);
  }
  if (this.removeButton) {
    $removeFromParent(this.removeButton);
    $destroy(this.removeButton);
  }
  if (this.removeAllButton) {
    $removeFromParent(this.removeAllButton);
    $destroy(this.removeAllButton);
  }
}
;
_.getItemIcon = function getItemIcon(){
  return null;
}
;
_.getMaxAvailableRecords = function getMaxAvailableRecords(){
  return 100;
}
;
_.getNameHoverCustomizer = function getNameHoverCustomizer(){
  return null;
}
;
_.getSelectorKey = function getSelectorKey(){
  return 'id';
}
;
_.onInit = function onInit_12(){
  $onInit_3(this);
}
;
_.supportsNameHoverCustomizer = function supportsNameHoverCustomizer(){
  return false;
}
;
_.updateButtonEnablement = function updateButtonEnablement(){
  if (!this.isReadOnly) {
    $setDisabled_1(this.addButton, !$anySelected(this.availableGrid).value_0);
    $setDisabled_1(this.removeButton, !$anySelected(this.assignedGrid).value_0);
    $setDisabled_1(this.addAllButton, !containsAtLeastOneEnabledRecord(this.availableGrid));
    $setDisabled_1(this.removeAllButton, !containsAtLeastOneEnabledRecord(this.assignedGrid));
  }
}
;
_.addAllButton = null;
_.addButton = null;
_.assignedGrid = null;
_.availableFilterForm = null;
_.availableGrid = null;
_.availableRecords = null;
_.datasource = null;
_.hlayout = null;
_.initialSelection = null;
_.isReadOnly = false;
_.latestCriteria = null;
_.messageLayout = null;
_.removeAllButton = null;
_.removeButton = null;
function RoleLdapGroupSelector_0(assignedRecords, isReadOnly){
  $clinit_BaseWidget();
  AbstractSelector_1.call(this, isReadOnly);
  this.initialSelection = assignedRecords;
}

function convertToPageList(locatedGroupMaps){
  $clinit_BaseWidget();
  var converted, group, locatedGroupMap, locatedGroupMap$iterator;
  converted = new PageList_0;
  $setPageControl_0(converted, new PageControl_1(0, -1));
  if (locatedGroupMaps) {
    for (locatedGroupMap$iterator = locatedGroupMaps.iterator(); locatedGroupMap$iterator.hasNext();) {
      locatedGroupMap = dynamicCast(locatedGroupMap$iterator.next_0(), Q$Map);
      group = new LdapGroup_0;
      $setDescription_6(group, dynamicCast(locatedGroupMap.get_2('description'), Q$String));
      $setName_11(group, dynamicCast(locatedGroupMap.get_2('name'), Q$String));
      setCheck(converted.array, converted.size_0++, group);
    }
  }
  return converted;
}

defineSeed(1702, 1703, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), RoleLdapGroupSelector_0);
_.getAvailableFilterForm = function getAvailableFilterForm(){
  var availableFilterForm, search;
  availableFilterForm = new DynamicForm_0;
  $isCreated_1(availableFilterForm)?$setProperty_3(availableFilterForm, 'width', '100%'):(availableFilterForm.config_0['width'] = '100%' , undefined);
  $isCreated_1(availableFilterForm)?$setProperty_0(availableFilterForm, 'numCols', 2):(availableFilterForm.config_0['numCols'] = 2 , undefined);
  search = new TextItem_3('search', ($clinit_Enhanced() , 'Prohledat'));
  availableFilterForm.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [search, new SpacerItem_0]));
  return availableFilterForm;
}
;
_.getDataSource_0 = function getDataSource_0(){
  return new RoleLdapGroupSelector$LdapGroupsDataSource_0;
}
;
_.getItemTitle = function getItemTitle(){
  return $clinit_Enhanced() , 'LDAP skupiny';
}
;
_.getLatestCriteria = function getLatestCriteria(availableFilterForm){
  var criteria, search;
  search = dynamicCast($getValue(availableFilterForm, 'search'), Q$String);
  criteria = new Criteria_0;
  null != search && (criteria.jsObj['name'] = search , undefined);
  return criteria;
}
;
_.getSelectorKey = function getSelectorKey_0(){
  return 'name';
}
;
function $copyValues_1(from){
  var to;
  to = new ListGridRecord_0;
  $setAttribute_3(to, 'id', from.id);
  $setAttribute_13(to, 'name', from.name_0);
  $setAttribute_13(to, 'description', from.description);
  return to;
}

function $executeFetch_1(this$static, request, response){
  var ldapGroups;
  if (!this$static.cachedLdapGroupsAvailable) {
    $findAvailableGroups(dynamicCast(secure(getInstance_44(), -1), Q$LdapGWTServiceAsync), new RoleLdapGroupSelector$LdapGroupsDataSource$1_0(this$static, request, response));
  }
   else {
    ldapGroups = $filterCachedLdapGroups(this$static, request);
    $sendSuccessResponse_1(this$static, request, response, ldapGroups);
  }
}

function $filterCachedLdapGroups(this$static, request){
  var criteria, id, key, key$iterator, keySet, ldapGroups, locatedGroupMaps, map, map$iterator, nameFilter;
  if (!this$static.cachedNameKeyedMap) {
    this$static.cachedNameKeyedMap = new HashMap_0;
    for (map$iterator = this$static.cachedLdapGroupsAvailable.iterator(); map$iterator.hasNext();) {
      map = dynamicCast(map$iterator.next_0(), Q$Map);
      id = dynamicCast(map.get_2('name'), Q$String);
      this$static.cachedNameKeyedMap.put(id, map);
    }
  }
  criteria = $getCriteria(request);
  nameFilter = dynamicCast(convertToMap(criteria.jsObj).get_2('name'), Q$String);
  if (nameFilter != null && !!$trim(nameFilter).length) {
    locatedGroupMaps = new HashSet_0;
    keySet = $keySet(this$static.cachedNameKeyedMap);
    for (key$iterator = $iterator(keySet); key$iterator.val$outerIter.hasNext();) {
      key = dynamicCast($next_1(key$iterator), Q$String);
      $indexOf_2(key.toLowerCase(), $trim(nameFilter).toLowerCase()) != -1 && locatedGroupMaps.add(dynamicCast(this$static.cachedNameKeyedMap.get_2(key), Q$Map));
    }
  }
   else {
    locatedGroupMaps = this$static.cachedLdapGroupsAvailable;
  }
  ldapGroups = convertToPageList(locatedGroupMaps);
  return ldapGroups;
}

function RoleLdapGroupSelector$LdapGroupsDataSource_0(){
  $clinit_RPCDataSource();
  var descriptionField, nameField;
  RPCDataSource_0.call(this);
  nameField = new DataSourceTextField_1('name', 'name');
  $setAttribute_8(nameField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  descriptionField = new DataSourceTextField_1('description', 'description');
  $setFields(this, initValues(_3Lcom_smartgwt_client_data_DataSourceField_2_classLit, makeCastMap([Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$DataSourceField, [nameField, descriptionField]));
}

defineSeed(1704, 1626, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]), RoleLdapGroupSelector$LdapGroupsDataSource_0);
_.copyValues = function copyValues_4(from){
  var to;
  return to = new LdapGroup_0 , $setId_6(to, getAttributeAsInt(from.jsObj, 'id').value_0) , $setName_11(to, getAttribute(from.jsObj, 'name')) , $setDescription_6(to, getAttribute(from.jsObj, 'description')) , to;
}
;
_.copyValues_0 = function copyValues_5(from){
  return $copyValues_1(dynamicCast(from, Q$LdapGroup));
}
;
_.executeFetch = function executeFetch_1(request, response, unused){
  $executeFetch_1(this, request, response, dynamicCast(unused, Q$Criteria));
}
;
_.getFetchCriteria = function getFetchCriteria_1(request){
  return null;
}
;
_.cachedLdapGroupsAvailable = null;
_.cachedNameKeyedMap = null;
function $onSuccess_45(this$static, locatedGroupMaps){
  var ldapGroups;
  debug('Successfully located ' + locatedGroupMaps.size_1() + ' available LDAP groups.');
  this$static.this$1.cachedLdapGroupsAvailable = locatedGroupMaps;
  ldapGroups = convertToPageList(locatedGroupMaps);
  $sendSuccessResponse_1(this$static.this$1, this$static.val$request, this$static.val$response, ldapGroups);
}

function RoleLdapGroupSelector$LdapGroupsDataSource$1_0(this$1, val$request, val$response){
  this.this$1 = this$1;
  this.val$request = val$request;
  this.val$response = val$response;
}

defineSeed(1705, 1, {}, RoleLdapGroupSelector$LdapGroupsDataSource$1_0);
_.onFailure = function onFailure_47(throwable){
  $handleError_0(($clinit_CoreGUI() , $clinit_RPCDataSource() , 'Nepoda\u0159ilo se z\xEDskat informace o LDAP skupin\xE1ch pro roli.'), throwable);
}
;
_.onSuccess_0 = function onSuccess_47(locatedGroupMaps){
  $onSuccess_45(this, dynamicCast(locatedGroupMaps, Q$Set));
}
;
_.this$1 = null;
_.val$request = null;
_.val$response = null;
function $clinit_ResourceGroupSelector(){
  $clinit_ResourceGroupSelector = nullMethod;
  $clinit_BaseWidget();
  CATEGORY_VALUE_MAP = new LinkedHashMap_0;
  $put_1(CATEGORY_VALUE_MAP, ($clinit_GroupCategory() , COMPATIBLE).name_0, ($clinit_Enhanced() , 'Kompatibiln\xED'));
  $put_1(CATEGORY_VALUE_MAP, MIXED_0.name_0, 'Sm\xED\u0161en\xE9');
}

function ResourceGroupSelector_0(categoryFilter, isReadOnly){
  AbstractSelector_1.call(this, isReadOnly);
  this.categoryFilter = categoryFilter;
}

function ResourceGroupSelector_1(isReadOnly){
  ResourceGroupSelector_0.call(this, null, isReadOnly);
}

defineSeed(1707, 1703, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]));
_.getAvailableFilterForm = function getAvailableFilterForm_0(){
  var availableFilterForm, groupCategorySelect, search;
  availableFilterForm = new DynamicForm_0;
  $isCreated_1(availableFilterForm)?$setProperty_3(availableFilterForm, 'width', '100%'):(availableFilterForm.config_0['width'] = '100%' , undefined);
  $isCreated_1(availableFilterForm)?$setProperty_0(availableFilterForm, 'numCols', 4):(availableFilterForm.config_0['numCols'] = 4 , undefined);
  search = new TextItem_3('search', ($clinit_Enhanced() , 'Prohledat'));
  groupCategorySelect = new SelectItem_2('groupCategory', 'Kategorie skupiny');
  groupCategorySelect.setValueMap_0(CATEGORY_VALUE_MAP);
  if (!this.categoryFilter) {
    $setAllowEmptyValue(groupCategorySelect, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  }
   else {
    switch (this.categoryFilter.ordinal) {
      case 0:
        $setValue_7(groupCategorySelect, ($clinit_GroupCategory() , COMPATIBLE).name_0);
        break;
      case 1:
        $setValue_7(groupCategorySelect, ($clinit_GroupCategory() , MIXED_0).name_0);
    }
    $setDisabled_2(groupCategorySelect, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
  }
  availableFilterForm.setItems(initValues(_3Lcom_smartgwt_client_widgets_form_fields_FormItem_2_classLit, makeCastMap([Q$FormItem_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$FormItem, [search, groupCategorySelect, new SpacerItem_0]));
  return availableFilterForm;
}
;
_.getDataSource_0 = function getDataSource_1(){
  return new ResourceGroupSelector$SelectedResourceGroupsDataSource_0;
}
;
_.getItemTitle = function getItemTitle_0(){
  return $clinit_Enhanced() , 'Skupiny zdroj\u016F';
}
;
_.getLatestCriteria = function getLatestCriteria_0(availableFilterForm){
  var category, criteria, search;
  search = dynamicCast($getValue(availableFilterForm, 'search'), Q$String);
  category = dynamicCast($getValue(availableFilterForm, 'groupCategory'), Q$String);
  criteria = new Criteria_0;
  null != search && $addCriteria_2(criteria, ($clinit_ResourceGroupDataSourceField() , NAME_30).propertyName, search);
  null != category && $addCriteria_2(criteria, ($clinit_ResourceGroupDataSourceField() , CATEGORY).propertyName, category);
  return criteria;
}
;
_.categoryFilter = null;
var CATEGORY_VALUE_MAP;
function RoleResourceGroupSelector_0(groupRecords, isReadOnly){
  $clinit_ResourceGroupSelector();
  ResourceGroupSelector_1.call(this, isReadOnly);
  this.initialSelection = groupRecords;
}

defineSeed(1706, 1707, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), RoleResourceGroupSelector_0);
function RoleSubjectSelector_0(subjectRecords, isReadOnly){
  $clinit_BaseWidget();
  AbstractSelector_1.call(this, isReadOnly);
  this.initialSelection = subjectRecords;
}

defineSeed(1708, 1703, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$Enhanced]), RoleSubjectSelector_0);
_.getAvailableFilterForm = function getAvailableFilterForm_1(){
  return null;
}
;
_.getDataSource_0 = function getDataSource_2(){
  return new RoleSubjectSelector$RoleUsersDataSource_0;
}
;
_.getItemIcon = function getItemIcon_0(){
  return 'global/User_16.png';
}
;
_.getItemTitle = function getItemTitle_1(){
  return $clinit_Enhanced() , 'U\u017Eivatel\xE9';
}
;
_.getLatestCriteria = function getLatestCriteria_1(availableFilterForm){
  return null;
}
;
_.getMaxAvailableRecords = function getMaxAvailableRecords_0(){
  return 500;
}
;
function $copyUserValues(subject, isLdap){
  var targetRecord;
  targetRecord = $copyValues_3(subject, true);
  targetRecord.jsObj['ldap'] = isLdap;
  if (subject.name_0 != null) {
    targetRecord.jsObj['password'] = 'XXXXXXXX';
    targetRecord.jsObj['passwordVerify'] = 'XXXXXXXX';
  }
  return targetRecord;
}

function $copyValues_2(from){
  var roleRecords, to;
  to = new Subject_0;
  $setId_0(to, getAttributeAsInt(from.jsObj, 'id').value_0);
  $setName_3(to, getAttribute(from.jsObj, 'name'));
  $setFirstName(to, getAttribute(from.jsObj, 'firstName'));
  $setLastName(to, getAttribute(from.jsObj, 'lastName'));
  $setFactive(to, ($clinit_Boolean() , $equalsIgnoreCase('true', getAttribute(from.jsObj, 'factive'))?TRUE:FALSE).value_0);
  $setFsystem(to, ($equalsIgnoreCase('true', getAttribute(from.jsObj, 'fsystem'))?TRUE:FALSE).value_0);
  $setDepartment(to, getAttribute(from.jsObj, 'department'));
  $setPhoneNumber(to, getAttribute(from.jsObj, 'phoneNumber'));
  $setEmailAddress(to, getAttribute(from.jsObj, 'emailAddress'));
  roleRecords = convertToRecordArray(getAttributeAsJavaScriptObject(from.jsObj, 'roles'));
  $setRoles(to, $buildDataObjects((!INSTANCE_2 && (INSTANCE_2 = new RolesDataSource_0) , INSTANCE_2), roleRecords));
  return to;
}

function $copyValues_3(from, cascade){
  var roleRecords, to;
  to = new ListGridRecord_0;
  $setAttribute_3(to, 'id', from.id);
  $setAttribute_13(to, 'name', from.name_0);
  $setAttribute_13(to, 'firstName', from.firstName);
  $setAttribute_13(to, 'lastName', from.lastName);
  $setAttribute_16(to, 'factive', from.factive);
  $setAttribute_16(to, 'fsystem', from.fsystem);
  $setAttribute_13(to, 'department', from.department);
  $setAttribute_13(to, 'phoneNumber', from.phoneNumber);
  $setAttribute_13(to, 'emailAddress', from.emailAddress);
  if (cascade) {
    roleRecords = $buildRecords((!INSTANCE_2 && (INSTANCE_2 = new RolesDataSource_0) , INSTANCE_2), (!from.roles && (from.roles = new HashSet_0) , from.roles), false);
    to.jsObj['roles'] = convertToJavaScriptArray(roleRecords);
  }
  return to;
}

function $executeFetch_2(this$static, request, response, criteria){
  $findSubjectsByCriteria(this$static.subjectService, criteria, new UsersDataSource$1_0(this$static, request, response));
}

function UsersDataSource_0(){
  var fields_0, idDataField, usernameField, regExpValidator, ldapField, passwordField, passwordValidator, passwordVerifyField, passwordsEqualValidator, firstNameField, lastNameField, emailAddressField, emailAddressValidator, phoneNumberField, departmentField, enabledField, rolesField;
  $clinit_RPCDataSource();
  var fields;
  RPCDataSource_0.call(this);
  this.subjectService = dynamicCast(secure(getInstance_54(), -1), Q$SubjectGWTServiceAsync);
  fields = (fields_0 = new ArrayList_0 , idDataField = new DataSourceIntegerField_1('id', 'ID') , $setAttribute_8(idDataField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idDataField, 'canEdit', FALSE) , setCheck(fields_0.array, fields_0.size_0++, idDataField) , usernameField = createTextField('name', 'U\u017Eivatelsk\xE9 jm\xE9no', valueOf_44(3), valueOf_44(100), TRUE) , regExpValidator = new RegExpValidator_1('[^&<]*') , usernameField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [regExpValidator])) , setCheck(fields_0.array, fields_0.size_0++, usernameField) , ldapField = createBooleanField('ldap', 'LDAP Login?', TRUE) , $setAttribute_8(ldapField, 'canEdit', FALSE) , setCheck(fields_0.array, fields_0.size_0++, ldapField) , passwordField = new DataSourcePasswordField_0('password', 'Heslo') , passwordValidator = new LengthRangeValidator_0 , $setAttribute_11(passwordValidator, 'min', valueOf_44(6)) , $setAttribute_11(passwordValidator, 'max', valueOf_44(100)) , passwordField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [passwordValidator])) , setCheck(fields_0.array, fields_0.size_0++, passwordField) , passwordVerifyField = new DataSourcePasswordField_0('passwordVerify', 'Potvr\u010Fte heslo') , passwordsEqualValidator = new MatchesFieldValidator_0 , passwordsEqualValidator.jsObj['otherField'] = 'password' , passwordsEqualValidator.jsObj['errorMessage'] = 'Heslo nen\xED stejn\xE9.' , passwordVerifyField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [passwordsEqualValidator])) , setCheck(fields_0.array, fields_0.size_0++, passwordVerifyField) , firstNameField = createTextField('firstName', 'K\u0159estn\xED jm\xE9no', null, valueOf_44(100), TRUE) , setCheck(fields_0.array, fields_0.size_0++, firstNameField) , lastNameField = createTextField('lastName', 'P\u0159\xEDjm\u011Bn\xED', null, valueOf_44(100), TRUE) , setCheck(fields_0.array, fields_0.size_0++, lastNameField) , emailAddressField = createTextField('emailAddress', 'Email', null, valueOf_44(100), TRUE) , setCheck(fields_0.array, fields_0.size_0++, emailAddressField) , emailAddressValidator = new RegExpValidator_1('^([a-zA-Z0-9_.\\-+])+@([a-zA-Z0-9\\-])+(\\.([a-zA-Z0-9\\-])+)*$') , emailAddressValidator.jsObj['errorMessage'] = 'Neplatn\xE1 emailov\xE1 adresa.' , emailAddressField.jsObj['validators'] = convertToJavaScriptArray(initValues(_3Lcom_smartgwt_client_widgets_form_validator_Validator_2_classLit, makeCastMap([Q$Validator_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$Validator, [emailAddressValidator])) , phoneNumberField = createTextField('phoneNumber', 'Telefonn\xED \u010D\xEDslo', null, valueOf_44(100), FALSE) , setCheck(fields_0.array, fields_0.size_0++, phoneNumberField) , departmentField = createTextField('department', 'Odd\u011Blen\xED', null, valueOf_44(100), FALSE) , setCheck(fields_0.array, fields_0.size_0++, departmentField) , enabledField = createBooleanField('factive', 'Login povolen?', TRUE) , setCheck(fields_0.array, fields_0.size_0++, enabledField) , rolesField = new DataSourceField_2('roles', ($clinit_FieldType() , ANY), 'Roles') , setCheck(fields_0.array, fields_0.size_0++, rolesField) , fields_0);
  $addFields(this, fields);
}

defineSeed(1710, 1626, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]), UsersDataSource_0);
_.copyValues = function copyValues_6(from){
  return $copyValues_2(from);
}
;
_.copyValues_0 = function copyValues_7(from){
  return $copyValues_3(dynamicCast(from, Q$Subject), true);
}
;
_.copyValues_1 = function copyValues_8(from, cascade){
  return $copyValues_3(dynamicCast(from, Q$Subject), cascade);
}
;
_.executeAdd = function executeAdd_0(recordToAdd, request, response){
  var newSubject, password;
  newSubject = $copyValues_2(recordToAdd);
  password = getAttribute(recordToAdd.jsObj, 'password');
  $createSubject(this.subjectService, newSubject, password, new UsersDataSource$2_0(this, newSubject, request, response));
}
;
_.executeFetch = function executeFetch_2(request, response, criteria){
  $executeFetch_2(this, request, response, dynamicCast(criteria, Q$SubjectCriteria));
}
;
_.executeUpdate = function executeUpdate_0(editedUserRecord, oldUserRecord, request, response){
  var editedPassword, editedSubject, newPassword, passwordWasEdited, username;
  editedSubject = $copyValues_2(editedUserRecord);
  username = editedSubject.name_0;
  editedPassword = getAttribute(editedUserRecord.jsObj, 'password');
  passwordWasEdited = !$equals_6('XXXXXXXX', editedPassword);
  newPassword = passwordWasEdited?editedPassword:null;
  $updateSubject(this.subjectService, editedSubject, newPassword, new UsersDataSource$3_0(this, username, request, response, editedUserRecord));
}
;
_.getFetchCriteria = function getFetchCriteria_2(request){
  var criteria, subjectId;
  return criteria = new SubjectCriteria_0 , subjectId = dynamicCast(getFilter($getCriteria(request), 'id', Ljava_lang_Integer_2_classLit), Q$Integer) , criteria.filterId = subjectId , $addFilterFsystem(criteria, ($clinit_Boolean() , $clinit_Boolean() , FALSE)) , !!subjectId && (criteria.fetchRoles = true) , criteria;
}
;
_.getSortFieldForColumn = function getSortFieldForColumn_0(columnName){
  if ($equals_6('ldap', columnName)) {
    return null;
  }
  return columnName;
}
;
var INSTANCE_1 = null;
function RoleSubjectSelector$RoleUsersDataSource_0(){
  $clinit_RPCDataSource();
  UsersDataSource_0.call(this);
}

defineSeed(1709, 1710, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]), RoleSubjectSelector$RoleUsersDataSource_0);
_.sendSuccessResponseRecords = function sendSuccessResponseRecords_0(request, response, records){
  var id, record, record$iterator, rhqAdminRecord;
  rhqAdminRecord = null;
  for (record$iterator = new AbstractList$IteratorImpl_0(records); record$iterator.i < record$iterator.this$0_0.size_1();) {
    record = dynamicCast($next_0(record$iterator), Q$Record);
    id = getAttributeAsInt(record.jsObj, 'id');
    if ($equals_4(id, valueOf_44(2))) {
      rhqAdminRecord = record;
      break;
    }
  }
  if (rhqAdminRecord) {
    $setTotalSize(records, max_1(records.size_0, records.totalSize) - 1);
    $remove_4(records, rhqAdminRecord);
  }
  $sendSuccessResponseRecords(this, request, response, records);
}
;
function $copyValues_4(from){
  var ldapGroupRecords, ldapGroups, permissionRecords, permissions, resourceGroupRecords, resourceGroups, subjectRecords, subjects, to;
  to = new Role_0;
  $setId_1(to, getAttributeAsInt(from.jsObj, 'id').value_0);
  $setName_4(to, getAttribute(from.jsObj, 'name'));
  $setDescription_0(to, getAttribute(from.jsObj, 'description'));
  permissionRecords = convertToRecordArray(getAttributeAsJavaScriptObject(from.jsObj, 'permissions'));
  permissions = toPermissionSet(permissionRecords);
  to.permissions.clear_0();
  !!permissions && to.permissions.addAll(permissions);
  resourceGroupRecords = convertToRecordArray(getAttributeAsJavaScriptObject(from.jsObj, 'resourceGroups'));
  resourceGroups = $buildDataObjects((!INSTANCE_4 && (INSTANCE_4 = new ResourceGroupsDataSource_0) , INSTANCE_4), resourceGroupRecords);
  $setResourceGroups(to, resourceGroups);
  subjectRecords = convertToRecordArray(getAttributeAsJavaScriptObject(from.jsObj, 'subjects'));
  subjects = $buildDataObjects((!INSTANCE_1 && (INSTANCE_1 = new UsersDataSource_0) , INSTANCE_1), subjectRecords);
  $setSubjects(to, subjects);
  ldapGroupRecords = convertToRecordArray(getAttributeAsJavaScriptObject(from.jsObj, 'ldapGroups'));
  ldapGroups = $buildDataObjects(new RoleLdapGroupSelector$LdapGroupsDataSource_0, ldapGroupRecords);
  to.ldapGroups = ldapGroups;
  return to;
}

function $copyValues_5(sourceRole, cascade){
  var ldapGroupRecords, ldapGroups, permissionRecords, permissions, resourceGroupRecords, resourceGroups, subjectRecords, subjects, targetRecord;
  targetRecord = new ListGridRecord_0;
  $setAttribute_3(targetRecord, 'id', sourceRole.id);
  $setAttribute_13(targetRecord, 'name', sourceRole.name_0);
  $setAttribute_13(targetRecord, 'description', sourceRole.description);
  permissions = sourceRole.permissions;
  permissionRecords = toRecordArray(permissions);
  targetRecord.jsObj['permissions'] = convertToJavaScriptArray(permissionRecords);
  if (cascade) {
    resourceGroups = sourceRole.resourceGroups;
    resourceGroupRecords = $buildRecords((!INSTANCE_4 && (INSTANCE_4 = new ResourceGroupsDataSource_0) , INSTANCE_4), resourceGroups, false);
    targetRecord.jsObj['resourceGroups'] = convertToJavaScriptArray(resourceGroupRecords);
    subjects = sourceRole.subjects;
    subjectRecords = $buildRecords((!INSTANCE_1 && (INSTANCE_1 = new UsersDataSource_0) , INSTANCE_1), subjects, false);
    targetRecord.jsObj['subjects'] = convertToJavaScriptArray(subjectRecords);
    ldapGroups = (!sourceRole.ldapGroups && (sourceRole.ldapGroups = new HashSet_0) , sourceRole.ldapGroups);
    ldapGroupRecords = $buildRecords(new RoleLdapGroupSelector$LdapGroupsDataSource_0, ldapGroups, true);
    targetRecord.jsObj['ldapGroups'] = convertToJavaScriptArray(ldapGroupRecords);
  }
  return targetRecord;
}

function $executeFetch_3(this$static, request, response, criteria){
  $findRolesByCriteria(this$static.roleService, criteria, new RolesDataSource$1_0(this$static, request, response));
}

function $getFetchCriteria(request){
  var criteria, id, subjectId;
  criteria = new RoleCriteria_0;
  id = dynamicCast(getFilter($getCriteria(request), 'id', Ljava_lang_Integer_2_classLit), Q$Integer);
  criteria.filterId = id;
  subjectId = dynamicCast(getFilter($getCriteria(request), 'subjectId', Ljava_lang_Integer_2_classLit), Q$Integer);
  !!subjectId && (criteria.filterSubjectId = subjectId);
  criteria.fetchPermissions = true;
  if (id) {
    criteria.fetchSubjects = true;
    criteria.fetchResourceGroups = true;
    criteria.fetchLdapGroups = true;
  }
  return criteria;
}

function RolesDataSource_0(){
  var fields_0, idDataField, nameField, descriptionField, resourceGroupsField, permissionsField, subjectsField, ldapGroupsField;
  $clinit_RPCDataSource();
  var fields;
  RPCDataSource_0.call(this);
  this.roleService = dynamicCast(secure(getInstance_52(), -1), Q$RoleGWTServiceAsync);
  fields = (fields_0 = new ArrayList_0 , idDataField = new DataSourceIntegerField_1('id', 'ID') , $setAttribute_8(idDataField, 'primaryKey', ($clinit_Boolean() , $clinit_Boolean() , TRUE)) , $setAttribute_8(idDataField, 'canEdit', FALSE) , setCheck(fields_0.array, fields_0.size_0++, idDataField) , nameField = createTextField('name', 'Jm\xE9no', valueOf_44(3), valueOf_44(100), TRUE) , setCheck(fields_0.array, fields_0.size_0++, nameField) , descriptionField = createTextField('description', 'Popis', null, valueOf_44(100), FALSE) , setCheck(fields_0.array, fields_0.size_0++, descriptionField) , resourceGroupsField = new DataSourceField_2('resourceGroups', ($clinit_FieldType() , ANY), 'Skupiny zdroj\u016F') , setCheck(fields_0.array, fields_0.size_0++, resourceGroupsField) , permissionsField = new DataSourceField_2('permissions', ANY, 'Povolen\xED') , setCheck(fields_0.array, fields_0.size_0++, permissionsField) , subjectsField = new DataSourceField_2('subjects', ANY, 'Subjekty') , setCheck(fields_0.array, fields_0.size_0++, subjectsField) , ldapGroupsField = new DataSourceField_2('ldapGroups', ANY, 'LDAP skupiny') , setCheck(fields_0.array, fields_0.size_0++, ldapGroupsField) , fields_0);
  $addFields(this, fields);
}

function toPermissionSet(permissionRecords){
  $clinit_RPCDataSource();
  var permission, permissionName, permissionRecord, permissionRecord$index, permissionRecord$max, permissions;
  permissions = new HashSet_0;
  $add_6(permissions, ($clinit_Permission() , VIEW_RESOURCE));
  for (permissionRecord$index = 0 , permissionRecord$max = permissionRecords.length; permissionRecord$index < permissionRecord$max; ++permissionRecord$index) {
    permissionRecord = permissionRecords[permissionRecord$index];
    permissionName = getAttribute(permissionRecord.jsObj, 'name');
    permission = dynamicCast(valueOf(($clinit_Permission$Map() , $MAP_49), permissionName), Q$Permission);
    $add_6(permissions, permission);
  }
  return permissions;
}

function toRecordArray(permissions){
  $clinit_RPCDataSource();
  var index, permission, permission$iterator, permissionRecord, permissionRecords;
  permissionRecords = initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridRecord_2_classLit, makeCastMap([Q$Record_$1, Q$ListGridRecord_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridRecord, permissions.size_1(), 0);
  index = 0;
  for (permission$iterator = permissions.iterator(); permission$iterator.hasNext();) {
    permission = dynamicCast(permission$iterator.next_0(), Q$Permission);
    permissionRecord = new ListGridRecord_0;
    $setAttribute_13(permissionRecord, 'name', permission.name_0);
    setCheck(permissionRecords, index++, permissionRecord);
  }
  return permissionRecords;
}

defineSeed(1711, 1626, makeCastMap([Q$HasHandlers, Q$BaseClass, Q$DataSource]), RolesDataSource_0);
_.copyValues = function copyValues_9(from){
  return $copyValues_4(from);
}
;
_.copyValues_0 = function copyValues_10(sourceRole){
  return $copyValues_5(dynamicCast(sourceRole, Q$Role), true);
}
;
_.copyValues_1 = function copyValues_11(sourceRole, cascade){
  return $copyValues_5(dynamicCast(sourceRole, Q$Role), cascade);
}
;
_.executeAdd = function executeAdd_1(recordToAdd, request, response){
  var roleToAdd;
  roleToAdd = $copyValues_4(recordToAdd);
  $createRole(this.roleService, roleToAdd, new RolesDataSource$2_0(this, roleToAdd, request, response));
}
;
_.executeFetch = function executeFetch_3(request, response, criteria){
  $executeFetch_3(this, request, response, dynamicCast(criteria, Q$RoleCriteria));
}
;
_.executeRemove = function executeRemove_0(recordToRemove, request, response){
  var roleToRemove, rolename;
  roleToRemove = $copyValues_4(recordToRemove);
  rolename = roleToRemove.name_0;
  $removeRoles(this.roleService, initValues(_3I_classLit, makeCastMap([Q$Serializable, Q$Cloneable]), -1, [roleToRemove.id]), new RolesDataSource$4_0(this, request, response, rolename, roleToRemove));
}
;
_.executeUpdate = function executeUpdate_1(recordToUpdate, oldRecord, request, response){
  var roleToUpdate, rolename;
  roleToUpdate = $copyValues_4(recordToUpdate);
  rolename = roleToUpdate.name_0;
  $updateRole(this.roleService, roleToUpdate, new RolesDataSource$3_0(this, request, response, rolename));
}
;
_.getFetchCriteria = function getFetchCriteria_3(request){
  return $getFetchCriteria(request);
}
;
var INSTANCE_2 = null;
function $onSuccess_46(this$static, result){
  $sendSuccessResponse_1(this$static.this$0, this$static.val$request, this$static.val$response, result);
}

function RolesDataSource$1_0(this$0, val$request, val$response){
  this.this$0 = this$0;
  this.val$request = val$request;
  this.val$response = val$response;
}

defineSeed(1712, 1, {}, RolesDataSource$1_0);
_.onFailure = function onFailure_48(caught){
  $sendFailureResponse(this.this$0, this.val$request, this.val$response, ($clinit_RPCDataSource() , 'Nepoda\u0159ilo se z\xEDskat role.'), caught);
}
;
_.onSuccess_0 = function onSuccess_48(result){
  $onSuccess_46(this, dynamicCast(result, Q$PageList));
}
;
_.this$0 = null;
_.val$request = null;
_.val$response = null;
function $onFailure_0(this$static, caught){
  var errorMessages;
  if (caught.getMessage() != null && caught.getMessage().indexOf('javax.persistence.EntityExistsException') != -1) {
    errorMessages = new HashMap_0;
    errorMessages.put('name', 'Nepoda\u0159ilo se vytvo\u0159it roli s existuj\xEDc\xEDm jm\xE9nem [' + ($clinit_RPCDataSource() , this$static.val$roleToAdd.name_0) + ']. Pou\u017E\xEDjte pros\xEDm jin\xE9 jm\xE9no.');
    $sendValidationErrorResponse(this$static.this$0, this$static.val$request, this$static.val$response, errorMessages);
  }
   else {
    throw new RuntimeException_3(caught);
  }
}

function $onSuccess_47(this$static, addedRole){
  $sendSuccessResponse_0(this$static.this$0, this$static.val$request, this$static.val$response, addedRole, null);
}

function RolesDataSource$2_0(this$0, val$roleToAdd, val$request, val$response){
  this.this$0 = this$0;
  this.val$roleToAdd = val$roleToAdd;
  this.val$request = val$request;
  this.val$response = val$response;
}

defineSeed(1713, 1, {}, RolesDataSource$2_0);
_.onFailure = function onFailure_49(caught){
  $onFailure_0(this, caught);
}
;
_.onSuccess_0 = function onSuccess_49(addedRole){
  $onSuccess_47(this, dynamicCast(addedRole, Q$Role));
}
;
_.this$0 = null;
_.val$request = null;
_.val$response = null;
_.val$roleToAdd = null;
function $onSuccess_48(this$static, updatedRole){
  $sendSuccessResponse_0(this$static.this$0, this$static.val$request, this$static.val$response, updatedRole, null);
}

function RolesDataSource$3_0(this$0, val$request, val$response, val$rolename){
  this.this$0 = this$0;
  this.val$request = val$request;
  this.val$response = val$response;
  this.val$rolename = val$rolename;
}

defineSeed(1714, 1, {}, RolesDataSource$3_0);
_.onFailure = function onFailure_50(caught){
  $sendFailureResponse(this.this$0, this.val$request, this.val$response, 'Nepoda\u0159ilo se zm\u011Bnit roli [' + ($clinit_RPCDataSource() , this.val$rolename) + '].', caught);
}
;
_.onSuccess_0 = function onSuccess_50(updatedRole){
  $onSuccess_48(this, dynamicCast(updatedRole, Q$Role));
}
;
_.this$0 = null;
_.val$request = null;
_.val$response = null;
_.val$rolename = null;
function $onSuccess_49(this$static){
  $sendSuccessResponse_0(this$static.this$0, this$static.val$request, this$static.val$response, this$static.val$roleToRemove, new Message_0('Role [' + ($clinit_RPCDataSource() , this$static.val$rolename) + '] smaz\xE1na.'));
}

function RolesDataSource$4_0(this$0, val$request, val$response, val$rolename, val$roleToRemove){
  this.this$0 = this$0;
  this.val$request = val$request;
  this.val$response = val$response;
  this.val$rolename = val$rolename;
  this.val$roleToRemove = val$roleToRemove;
}

defineSeed(1715, 1, {}, RolesDataSource$4_0);
_.onFailure = function onFailure_51(caught){
  $sendFailureResponse(this.this$0, this.val$request, this.val$response, 'Nepoda\u0159ilo se smazat roli [' + ($clinit_RPCDataSource() , this.val$rolename) + '].', caught);
}
;
_.onSuccess_0 = function onSuccess_51(result){
  $onSuccess_49(this, throwClassCastExceptionUnlessNull(result));
}
;
_.this$0 = null;
_.val$request = null;
_.val$response = null;
_.val$roleToRemove = null;
_.val$rolename = null;
function $clinit_RolesView(){
  $clinit_RolesView = nullMethod;
  $clinit_BaseWidget();
  VIEW_ID_5 = new ViewName_2('Roles', ($clinit_Enhanced() , 'Role'), ($clinit_IconEnum() , ROLES));
  ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_SECURITY_VIEW_ID + '/' + VIEW_ID_5;
}

function $updateSelectionStyle(this$static){
  var selectionStyle;
  this$static.hasManageSecurity || $deselectAllRecords(this$static.listGrid);
  selectionStyle = this$static.hasManageSecurity?($clinit_SelectionStyle() , MULTIPLE):($clinit_SelectionStyle() , NONE_4);
  $setAttribute_24(this$static.listGrid, 'selectionType', selectionStyle.value_0, true);
}

function RolesView_0(hasManageSecurity){
  $clinit_RolesView();
  var datasource;
  TableSection_0.call(this, null);
  datasource = ($clinit_RPCDataSource() , !INSTANCE_2 && (INSTANCE_2 = new RolesDataSource_0) , $clinit_RPCDataSource() , INSTANCE_2);
  this.dataSource_1 = datasource;
  this.escapeHtmlInDetailsLinkColumn = true;
  this.hasManageSecurity = hasManageSecurity;
}

defineSeed(1716, 1607, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$BookmarkableView, Q$InitializableView, Q$RefreshableView, Q$Table, Q$HasViewName, Q$Enhanced, Q$EnhancedHLayout]), RolesView_0);
_.configureTable = function configureTable_3(){
  var fields, fields_0, nameField, descriptionField;
  $updateSelectionStyle(this);
  $addCellClickHandler(this.listGrid, new RolesView$1_0(this));
  fields = (fields_0 = new ArrayList_0 , nameField = new ListGridField_2('name', 150) , setCheck(fields_0.array, fields_0.size_0++, nameField) , descriptionField = new ListGridField_1('description') , $setCellFormatter_0(descriptionField, new EscapedHtmlCellFormatter_0) , setCheck(fields_0.array, fields_0.size_0++, descriptionField) , fields_0);
  $setListGridFields(this, false, dynamicCast($toArray_1(fields, initDim(_3Lcom_smartgwt_client_widgets_grid_ListGridField_2_classLit, makeCastMap([Q$ListGridField_$1, Q$Serializable, Q$Cloneable, Q$Object_$1]), Q$ListGridField, fields.size_0, 0)), Q$ListGridField_$1));
  $addTableAction(this, ($clinit_Enhanced() , 'Nov\xFD'), null, null, new RolesView$2_0(this));
  $addTableAction(this, 'Smazat', 'Jste si jist\xED, \u017Ee chcete smazat # vybran\xFDch role?', null, new RolesView$3_0(this));
  $configureTable(this);
}
;
_.getDetailsView_0 = function getDetailsView_2(roleId){
  return new RoleEditView_0(roleId.value_0);
}
;
_.getViewName = function getViewName(){
  return VIEW_ID_5;
}
;
_.isDetailsEnabled = function isDetailsEnabled_0(){
  return this.hasManageSecurity;
}
;
_.refresh_0 = function refresh_2(){
  $refresh(this, false);
  $updateSelectionStyle(this);
}
;
_.hasManageSecurity = false;
var VIEW_ID_5;
function RolesView$1_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1717, 1, makeCastMap([Q$EventHandler, Q$CellClickHandler]), RolesView$1_0);
_.onCellClick = function onCellClick(event_0){
  $updateSelectionStyle(this.this$0);
}
;
_.this$0 = null;
function RolesView$2_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1718, 1, {}, RolesView$2_0);
_.executeAction = function executeAction_7(selection, actionValue){
  $newDetails(this.this$0);
}
;
_.isEnabled_0 = function isEnabled_4(selection){
  return this.this$0.hasManageSecurity;
}
;
_.this$0 = null;
function RolesView$3_0(this$0){
  this.this$0 = this$0;
}

defineSeed(1719, 1, {}, RolesView$3_0);
_.executeAction = function executeAction_8(selection, actionValue){
  $deleteSelectedRecords(this.this$0);
}
;
_.isEnabled_0 = function isEnabled_5(selection){
  var count, record, record$index, record$max, roleId;
  if (!this.this$0.hasManageSecurity) {
    return false;
  }
  count = selection.length;
  if (count == 0) {
    return false;
  }
  for (record$index = 0 , record$max = selection.length; record$index < record$max; ++record$index) {
    record = selection[record$index];
    roleId = getAttributeAsInt(record.jsObj, 'id').value_0;
    $clinit_RPCDataSource();
    if (roleId == 1) {
      return false;
    }
  }
  return true;
}
;
_.this$0 = null;
function $clinit_ResourceTypeTreeView(){
  $clinit_ResourceTypeTreeView = nullMethod;
  $clinit_BaseWidget();
  VIEW_PATH = ($clinit_AdministrationView() , VIEW_ID) + '/' + SECTION_CONFIGURATION_VIEW_ID + '/';
}

function $getGridCanvas(this$static){
  var layout, platformServices, platformServicesList, platforms, platformsList, sectionStack, servers, serversTreeGrid, titleBar;
  if (!this$static.gridCanvas) {
    layout = new EnhancedVLayout_0;
    titleBar = this$static.getTitleBar();
    $isCreated_1(titleBar)?undefined:(titleBar.config_0['extraSpace'] = 10 , undefined);
    $addMember(layout, titleBar);
    sectionStack = new SectionStack_0;
    $setAttribute_24(sectionStack, 'visibilityMode', ($clinit_VisibilityMode() , MULTIPLE_0).value_0, true);
    platformsList = new ResourceTypeTreeView$CustomResourceTypeListGrid_0(this$static);
    platforms = new SectionStackSection_1(($clinit_Enhanced() , 'Platformy'));
    $setExpanded(platforms, ($clinit_Boolean() , $clinit_Boolean() , TRUE));
    $addItemJS(platforms, $getOrCreateJsObj_0(platformsList));
    platformServicesList = new ResourceTypeTreeView$CustomResourceTypeListGrid_0(this$static);
    platformServices = new SectionStackSection_1('Slu\u017Eby platformy');
    $setExpanded(platformServices, TRUE);
    $addItemJS(platformServices, $getOrCreateJsObj_0(platformServicesList));
    serversTreeGrid = new ResourceTypeTreeView$CustomResourceTypeTreeGrid_0(this$static);
    servers = new SectionStackSection_1('Servery');
    $setExpanded(servers, TRUE);
    $addItemJS(servers, $getOrCreateJsObj_0(serversTreeGrid));
    $addSection(sectionStack, platforms);
    $addSection(sectionStack, platformServices);
    $addSection(sectionStack, servers);
    $addMember(layout, sectionStack);
    this$static.gridCanvas = layout;
    this$static.getNodeBuilderInstance(platformsList, platformServicesList, serversTreeGrid);
  }
  return this$static.gridCanvas;
}

function $prepareSubCanvas(this$static, parentCanvas, canvasToShow, showBackButton){
  var backButton, backLink;
  destroyMembers(parentCanvas);
  if (showBackButton) {
    backLink = $substring(this$static.getEditLink(null), 1);
    backButton = new BackButton_0(($clinit_Enhanced() , 'Zp\u011Bt na seznam'), backLink);
    $addMember(parentCanvas, backButton);
  }
  $addMember(parentCanvas, canvasToShow);
  parentCanvas.markForRedraw_0();
}

function $switchToCanvas(parentCanvas, canvasToShow){
  destroyMembers(parentCanvas);
  $addMember(parentCanvas, canvasToShow);
  $markForRedraw(parentCanvas);
}

function ResourceTypeTreeView_0(){
  $clinit_ResourceTypeTreeView();
  EnhancedVLayout_0.call(this);
  $isCreated_1(this)?$setProperty_3(this, 'width', '100%'):(this.config_0['width'] = '100%' , undefined);
  $isCreated_1(this)?$setProperty_3(this, 'height', '100%'):(this.config_0['height'] = '100%' , undefined);
}

defineSeed(1721, 1604, makeCastMap([Q$HasAttachHandlers, Q$HasHandlers, Q$EventListener, Q$HasVisibility, Q$IsWidget, Q$UIObject, Q$Widget, Q$BaseWidget, Q$Canvas, Q$HasClickHandlers, Q$HasDoubleClickHandlers, Q$HasDragMoveHandlers, Q$HasDragRepositionMoveHandlers, Q$HasDragRepositionStartHandlers, Q$HasDragRepositionStopHandlers, Q$HasDragResizeMoveHandlers, Q$HasDragResizeStartHandlers, Q$HasDragResizeStopHandlers, Q$HasDragStartHandlers, Q$HasDragStopHandlers, Q$HasDropHandlers, Q$HasDropMoveHandlers, Q$HasDropOutHandlers, Q$HasDropOverHandlers, Q$HasFocusChangedHandlers, Q$HasHoverHandlers, Q$HasHoverHiddenHandlers, Q$HasKeyDownHandlers, Q$HasKeyPressHandlers, Q$HasMouseDownHandlers, Q$HasMouseMoveHandlers, Q$HasMouseOutHandlers, Q$HasMouseOverHandlers, Q$HasMouseStillDownHandlers, Q$HasMouseUpHandlers, Q$HasMouseWheelHandlers, Q$HasMovedHandlers, Q$HasParentMovedHandlers, Q$HasResizedHandlers, Q$HasRightMouseDownHandlers, Q$HasScrolledHandlers, Q$HasShowContextMenuHandlers, Q$HasVisibilityChangedHandlers, Q$Layout, Q$VLayout, Q$BookmarkableView, Q$Enhanced]));
_.editTemplates = function editTemplates(type, event_0){
  return;
}
;
_.editTemplates_0 = function editTemplates_0(type, viewPath){
  return;
}
;
_.getEditColumnTitle = function getEditColumnTitle(){
  return $clinit_Enhanced() , 'Editovat?';
}
;
_.getTypeMetadataTypes = function getTypeMetadataTypes(){
  return noneOf(Lorg_rhq_enterprise_gui_coregui_client_inventory_resource_type_ResourceTypeRepository$MetadataType_2_classLit);
}
;
_.renderView = function renderView_4(viewPath){
  var $e0, resourceTypeId;
  if (viewPath.viewPath.size_0 <= viewPath.index_0) {
    $switchToCanvas(this, $getGridCanvas(this));
  }
   else {
    try {
      resourceTypeId = __parseAndValidateInt((viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId)).path);
    }
     catch ($e0) {
      $e0 = caught_0($e0);
      if (instanceOf($e0, Q$Exception)) {
        $handleError_0(($clinit_CoreGUI() , 'Neplatn\xE9 URL. \u0160patn\xFD typ zdroje ID: [' + ($clinit_Enhanced() , (viewPath.index_0 >= viewPath.viewPath.size_0?null:dynamicCast($get_0(viewPath.viewPath, viewPath.index_0), Q$ViewId)).path) + ']'), null);
        return;
      }
       else 
        throw $e0;
    }
    $getResourceTypes(($clinit_ResourceTypeRepository$Cache() , $clinit_ResourceTypeRepository$Cache() , ourInstance), valueOf_44(resourceTypeId), this.getTypeMetadataTypes(), new ResourceTypeTreeView$1_0(this, viewPath));
  }
}
;
_.gridCanvas = null;
var VIEW_PATH;
function $clinit_AlertDefinitionTemplateTypeView(){
  $clinit_AlertDefinitionTemplateTypeView = nullMethod;
  $clinit_ResourceTypeTreeView();
  VIEW_ID_6 = new ViewName_2('AlertDefTemplates', ($clinit_Enhanced() , '\u0160ablony pro definice v\xFDstrah'), ($clinit_IconEnum() , ALERT_FLAG_BLUE));
}

function $getCanvas(this$static){
  var layout;
  if (!this$static.canvas_0) {
    layout = new EnhancedVLayout_0;
    $isCreated_1(layout)?$setProperty_3(layout, 'height', '100%'):(layout.config_0['height'] = '100%' , undefined);
    $isCreated_1(layout)?$setProperty_3(layout, 'width', '100%'):(layout.config_0['width'] = '100%' , undefined);
    $setMargin(layout, valueOf_44(5));
    this$static.canvas_0 = layout;
  }
  retur