/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.installer;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class ServerProperties {
    public static final String PROP_FILENAME = "rhq-server.properties";
    public static final String PROP_DATABASE_TYPE = "rhq.server.database.type-mapping";
    public static final String PROP_DATABASE_CONNECTION_URL = "rhq.server.database.connection-url";
    public static final String PROP_DATABASE_USERNAME = "rhq.server.database.user-name";
    public static final String PROP_DATABASE_PASSWORD = "rhq.server.database.password";
    public static final String PROP_DATABASE_SERVER_NAME = "rhq.server.database.server-name";
    public static final String PROP_DATABASE_PORT = "rhq.server.database.port";
    public static final String PROP_DATABASE_DB_NAME = "rhq.server.database.db-name";
    public static final String PROP_DATABASE_HIBERNATE_DIALECT = "hibernate.dialect";
    public static final String PROP_QUARTZ_DRIVER_DELEGATE_CLASS = "rhq.server.quartz.driverDelegateClass";
    public static final String PROP_QUARTZ_SELECT_WITH_LOCK_SQL = "rhq.server.quartz.selectWithLockSQL";
    public static final String PROP_QUARTZ_LOCK_HANDLER_CLASS = "rhq.server.quartz.lockHandlerClass";
    public static final String PROP_WEB_HTTP_PORT = "rhq.server.socket.binding.port.http";
    public static final String PROP_WEB_HTTPS_PORT = "rhq.server.socket.binding.port.https";
    public static final String PROP_EMAIL_SMTP_HOST = "rhq.server.email.smtp-host";
    public static final String PROP_EMAIL_SMTP_PORT = "rhq.server.email.smtp-port";
    public static final String PROP_EMAIL_FROM_ADDRESS = "rhq.server.email.from-address";
    public static final String PROP_AUTOINSTALL_ENABLE = "rhq.autoinstall.enabled";
    public static final String PROP_AUTOINSTALL_DATABASE = "rhq.autoinstall.database";
    public static final String PROP_AUTOINSTALL_PUBLIC_ADDR = "rhq.autoinstall.public-endpoint-address";
    public static final String PROP_TOMCAT_SECURITY_CLIENT_AUTH_MOD = "rhq.server.tomcat.security.client-auth-mode";
    public static final String PROP_TOMCAT_SECURITY_SSL_PROTOCOL = "rhq.server.tomcat.security.secure-socket-protocol";
    public static final String PROP_TOMCAT_SECURITY_ALGORITHM = "rhq.server.tomcat.security.algorithm";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_ALIAS = "rhq.server.tomcat.security.keystore.alias";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_FILENAME = "rhq.server.tomcat.security.keystore.file";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_PASSWORD = "rhq.server.tomcat.security.keystore.password";
    public static final String PROP_TOMCAT_SECURITY_KEYSTORE_TYPE = "rhq.server.tomcat.security.keystore.type";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_FILENAME = "rhq.server.tomcat.security.truststore.file";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_PASSWORD = "rhq.server.tomcat.security.truststore.password";
    public static final String PROP_TOMCAT_SECURITY_TRUSTSTORE_TYPE = "rhq.server.tomcat.security.truststore.type";
    public static final String PROP_CONNECTOR_TRANSPORT = "rhq.communications.connector.transport";
    public static final String PROP_CONNECTOR_BIND_ADDRESS = "rhq.communications.connector.bind-address";
    public static final String PROP_CONNECTOR_BIND_PORT = "rhq.communications.connector.bind-port";
    public static final String PROP_CONNECTOR_TRANSPORT_PARAMS = "rhq.communications.connector.transport-params";
    public static final String PROP_SECURITY_SERVER_SECURE_SOCKET_PROTOCOL = "rhq.communications.connector.security.secure-socket-protocol";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_FILE = "rhq.communications.connector.security.keystore.file";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_ALGORITHM = "rhq.communications.connector.security.keystore.algorithm";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_TYPE = "rhq.communications.connector.security.keystore.type";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_PASSWORD = "rhq.communications.connector.security.keystore.password";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_KEY_PASSWORD = "rhq.communications.connector.security.keystore.key-password";
    public static final String PROP_SECURITY_SERVER_KEYSTORE_ALIAS = "rhq.communications.connector.security.keystore.alias";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_FILE = "rhq.communications.connector.security.truststore.file";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_ALGORITHM = "rhq.communications.connector.security.truststore.algorithm";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_TYPE = "rhq.communications.connector.security.truststore.type";
    public static final String PROP_SECURITY_SERVER_TRUSTSTORE_PASSWORD = "rhq.communications.connector.security.truststore.password";
    public static final String PROP_SECURITY_SERVER_CLIENT_AUTH_MODE = "rhq.communications.connector.security.client-auth-mode";
    public static final String PROP_SECURITY_CLIENT_SECURE_SOCKET_PROTOCOL = "rhq.server.client.security.secure-socket-protocol";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_FILE = "rhq.server.client.security.keystore.file";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_ALGORITHM = "rhq.server.client.security.keystore.algorithm";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_TYPE = "rhq.server.client.security.keystore.type";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_PASSWORD = "rhq.server.client.security.keystore.password";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_KEY_PASSWORD = "rhq.server.client.security.keystore.key-password";
    public static final String PROP_SECURITY_CLIENT_KEYSTORE_ALIAS = "rhq.server.client.security.keystore.alias";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_FILE = "rhq.server.client.security.truststore.file";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_ALGORITHM = "rhq.server.client.security.truststore.algorithm";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_TYPE = "rhq.server.client.security.truststore.type";
    public static final String PROP_SECURITY_CLIENT_TRUSTSTORE_PASSWORD = "rhq.server.client.security.truststore.password";
    public static final String PROP_SECURITY_CLIENT_SERVER_AUTH_MODE_ENABLED = "rhq.server.client.security.server-auth-mode-enabled";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_ENABLED = "rhq.communications.multicast-detector.enabled";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_BIND_ADDRESS = "rhq.communications.multicast-detector.bind-address";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_MULTICAST_ADDRESS = "rhq.communications.multicast-detector.multicast-address";
    public static final String PROP_AGENT_MULTICAST_DETECTOR_PORT = "rhq.communications.multicast-detector.port";
    public static final String PROP_CONCURRENCY_LIMIT_WEBCONNS = "rhq.server.startup.web.max-connections";
    public static final String PROP_CONCURRENCY_LIMIT_GLOBAL = "rhq.communications.global-concurrency-limit";
    public static final String PROP_CONCURRENCY_LIMIT_INV_REPORT = "rhq.server.concurrency-limit.inventory-report";
    public static final String PROP_CONCURRENCY_LIMIT_AVAIL_REPORT = "rhq.server.concurrency-limit.availability-report";
    public static final String PROP_CONCURRENCY_LIMIT_INV_SYNC = "rhq.server.concurrency-limit.inventory-sync";
    public static final String PROP_CONCURRENCY_LIMIT_CONTENT_REPORT = "rhq.server.concurrency-limit.content-report";
    public static final String PROP_CONCURRENCY_LIMIT_CONTENT_DOWNLOAD = "rhq.server.concurrency-limit.content-download";
    public static final String PROP_CONCURRENCY_LIMIT_MEAS_REPORT = "rhq.server.concurrency-limit.measurement-report";
    public static final String PROP_CONCURRENCY_LIMIT_MEASSCHED_REQ = "rhq.server.concurrency-limit.measurement-schedule-request";
    public static final String PROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String PROP_HIGH_AVAILABILITY_NAME = "rhq.server.high-availability.name";
    public static final String PROP_MM_AT_START = "rhq.server.maintenance-mode-at-startup";
    public static final String PROP_OPERATION_TIMEOUT = "rhq.server.operation-timeout";
    public static final String PROP_LOG_LEVEL = "rhq.server.log-level";
    public static final String PROP_MGMT_USER_PASSWORD = "rhq.server.management.password";
    public static final String PROP_STORAGE_USERNAME = "rhq.storage.username";
    public static final String PROP_STORAGE_PASSWORD = "rhq.storage.password";
    public static final String PROP_STORAGE_NODES = "rhq.storage.nodes";
    public static final String PROP_STORAGE_CQL_PORT = "rhq.storage.cql-port";
    public static final String PROP_STORAGE_GOSSIP_PORT = "rhq.storage.gossip-port";
    private static final Set<String> BOOLEAN_PROPERTIES = new HashSet<String>();
    private static final Set<String> INTEGER_PROPERTIES;
    private static final Set<String> STRING_PROPERTIES;
    private static final Set<String> OBFUSCATED_PROPERTIES;
    private static final Set<String> OPTIONAL_PROPERTIES;
    private static final Set<String> OPTIONAL_PROPERTIES_ORACLE;
    public static final Set<String> CLIENT_AUTH_MODES;
    public static final Set<String> TOMCAT_CLIENT_AUTH_MODES;
    public static final Set<String> IBM_ALGOROTHM_SETTINGS;

    public static void validate(File serverPropertiesFile) throws Exception {
        ServerProperties.validate(serverPropertiesFile, null);
    }

    public static void validate(File serverPropertiesFile, Set<String> additionalProperties) throws Exception {
        if (!serverPropertiesFile.isFile()) {
            throw new Exception("Properties file not found: [" + serverPropertiesFile.getAbsolutePath() + "]");
        }
        PropertiesFileUpdate pfu = new PropertiesFileUpdate(serverPropertiesFile);
        Properties props = pfu.loadExistingProperties();
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Object property : props.keySet()) {
            map.put(property.toString(), props.getProperty(property.toString()));
        }
        ServerProperties.validate(map, additionalProperties);
    }

    public static void validate(Map<String, String> serverProperties) throws Exception {
        ServerProperties.validate(serverProperties, null);
    }

    public static void validate(Map<String, String> serverProperties, Set<String> additionalProperties) throws Exception {
        String val;
        StringBuilder dataErrors = new StringBuilder();
        for (String name : BOOLEAN_PROPERTIES) {
            if (ServerProperties.isOptional(serverProperties, name, val = serverProperties.get(name)) || "true".equals(val) || "false".equals(val)) continue;
            dataErrors.append("[" + name + "] must exist and be set 'true' or 'false' : [" + val + "]\n");
        }
        for (String name : INTEGER_PROPERTIES) {
            if (ServerProperties.isOptional(serverProperties, name, val = serverProperties.get(name))) continue;
            try {
                Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                dataErrors.append("[" + name + "] must exist and be set to a number : [" + val + "]\n");
            }
        }
        HashSet<String> requiredStringProperties = new HashSet<String>();
        requiredStringProperties.addAll(STRING_PROPERTIES);
        if (null != additionalProperties) {
            requiredStringProperties.addAll(additionalProperties);
        }
        for (String name : requiredStringProperties) {
            String val2;
            if (ServerProperties.isOptional(serverProperties, name, val2 = serverProperties.get(name))) continue;
            if (StringUtil.isBlank((String)val2)) {
                dataErrors.append("[" + name + "] must exist and be set to a valid string value\n");
                continue;
            }
            if (!OBFUSCATED_PROPERTIES.contains(name)) continue;
            try {
                PicketBoxObfuscator.decode((String)val2);
            }
            catch (Throwable e) {
                dataErrors.append("[" + name + "] must be encoded for security reasons. The value is not valid, perhaps it is set to a plain text value?  : [" + val2 + "]\n");
            }
        }
        if (dataErrors.length() > 0) {
            throw new Exception("Validation errors:\n" + dataErrors.toString());
        }
    }

    private static boolean isOracle(Map<String, String> serverProperties) {
        String dialect = serverProperties.get(PROP_DATABASE_HIBERNATE_DIALECT);
        return null != dialect && dialect.toLowerCase().contains("oracle");
    }

    private static boolean isOptional(Map<String, String> serverProperties, String name, String val) {
        if (StringUtil.isBlank((String)val) && OPTIONAL_PROPERTIES.contains(name)) {
            return true;
        }
        return (StringUtil.isBlank((String)val) || "unused".equals(val)) && ServerProperties.isOracle(serverProperties) && OPTIONAL_PROPERTIES_ORACLE.contains(name);
    }

    static {
        BOOLEAN_PROPERTIES.add(PROP_AGENT_MULTICAST_DETECTOR_ENABLED);
        BOOLEAN_PROPERTIES.add(PROP_AUTOINSTALL_ENABLE);
        BOOLEAN_PROPERTIES.add(PROP_MM_AT_START);
        BOOLEAN_PROPERTIES.add(PROP_SECURITY_CLIENT_SERVER_AUTH_MODE_ENABLED);
        INTEGER_PROPERTIES = new HashSet<String>();
        INTEGER_PROPERTIES.add(PROP_AGENT_MULTICAST_DETECTOR_PORT);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_AVAIL_REPORT);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_CONTENT_DOWNLOAD);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_CONTENT_REPORT);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_GLOBAL);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_INV_REPORT);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_INV_SYNC);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_MEAS_REPORT);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_MEASSCHED_REQ);
        INTEGER_PROPERTIES.add(PROP_CONCURRENCY_LIMIT_WEBCONNS);
        INTEGER_PROPERTIES.add(PROP_CONNECTOR_BIND_PORT);
        INTEGER_PROPERTIES.add(PROP_DATABASE_PORT);
        INTEGER_PROPERTIES.add(PROP_EMAIL_SMTP_PORT);
        INTEGER_PROPERTIES.add(PROP_OPERATION_TIMEOUT);
        INTEGER_PROPERTIES.add(PROP_STORAGE_CQL_PORT);
        INTEGER_PROPERTIES.add(PROP_STORAGE_GOSSIP_PORT);
        INTEGER_PROPERTIES.add(PROP_WEB_HTTP_PORT);
        INTEGER_PROPERTIES.add(PROP_WEB_HTTPS_PORT);
        STRING_PROPERTIES = new HashSet<String>();
        STRING_PROPERTIES.add(PROP_AUTOINSTALL_DATABASE);
        STRING_PROPERTIES.add(PROP_DATABASE_TYPE);
        STRING_PROPERTIES.add(PROP_DATABASE_CONNECTION_URL);
        STRING_PROPERTIES.add(PROP_DATABASE_PASSWORD);
        STRING_PROPERTIES.add(PROP_DATABASE_USERNAME);
        STRING_PROPERTIES.add(PROP_DATABASE_SERVER_NAME);
        STRING_PROPERTIES.add(PROP_DATABASE_DB_NAME);
        STRING_PROPERTIES.add(PROP_DATABASE_HIBERNATE_DIALECT);
        STRING_PROPERTIES.add(PROP_EMAIL_FROM_ADDRESS);
        STRING_PROPERTIES.add(PROP_EMAIL_SMTP_HOST);
        STRING_PROPERTIES.add(PROP_JBOSS_BIND_ADDRESS);
        STRING_PROPERTIES.add(PROP_QUARTZ_DRIVER_DELEGATE_CLASS);
        STRING_PROPERTIES.add(PROP_QUARTZ_LOCK_HANDLER_CLASS);
        STRING_PROPERTIES.add(PROP_QUARTZ_SELECT_WITH_LOCK_SQL);
        OBFUSCATED_PROPERTIES = new HashSet<String>();
        OBFUSCATED_PROPERTIES.add(PROP_DATABASE_PASSWORD);
        OBFUSCATED_PROPERTIES.add(PROP_MGMT_USER_PASSWORD);
        OBFUSCATED_PROPERTIES.add(PROP_STORAGE_PASSWORD);
        OPTIONAL_PROPERTIES = new HashSet<String>();
        OPTIONAL_PROPERTIES.add(PROP_CONNECTOR_BIND_PORT);
        OPTIONAL_PROPERTIES_ORACLE = new HashSet<String>();
        OPTIONAL_PROPERTIES_ORACLE.add(PROP_DATABASE_DB_NAME);
        OPTIONAL_PROPERTIES_ORACLE.add(PROP_DATABASE_PORT);
        OPTIONAL_PROPERTIES_ORACLE.add(PROP_DATABASE_SERVER_NAME);
        CLIENT_AUTH_MODES = new HashSet<String>();
        CLIENT_AUTH_MODES.add("none");
        CLIENT_AUTH_MODES.add("want");
        CLIENT_AUTH_MODES.add("need");
        TOMCAT_CLIENT_AUTH_MODES = new HashSet<String>();
        TOMCAT_CLIENT_AUTH_MODES.add("false");
        TOMCAT_CLIENT_AUTH_MODES.add("want");
        TOMCAT_CLIENT_AUTH_MODES.add("true");
        IBM_ALGOROTHM_SETTINGS = new HashSet<String>();
        IBM_ALGOROTHM_SETTINGS.add(PROP_TOMCAT_SECURITY_ALGORITHM);
        IBM_ALGOROTHM_SETTINGS.add(PROP_SECURITY_SERVER_KEYSTORE_ALGORITHM);
        IBM_ALGOROTHM_SETTINGS.add(PROP_SECURITY_SERVER_TRUSTSTORE_ALGORITHM);
        IBM_ALGOROTHM_SETTINGS.add(PROP_SECURITY_CLIENT_KEYSTORE_ALGORITHM);
        IBM_ALGOROTHM_SETTINGS.add(PROP_SECURITY_CLIENT_TRUSTSTORE_ALGORITHM);
    }
}

