/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mazz.i18n.Logger;
import org.jboss.remoting.InvalidConfigurationException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.security.SSLServerSocketFactoryService;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.coyote.ssl.RemotingSSLImplementation;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.communications.GlobalConcurrencyLimitCommandListener;
import org.rhq.enterprise.communications.ServiceContainerConfiguration;
import org.rhq.enterprise.communications.ServiceContainerConfigurationUpgrade;
import org.rhq.enterprise.communications.ServiceContainerMetrics;
import org.rhq.enterprise.communications.ServiceContainerMetricsMBean;
import org.rhq.enterprise.communications.ServiceContainerNetworkNotificationListener;
import org.rhq.enterprise.communications.ServiceContainerSenderCreationListener;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.JBossRemotingRemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.remotepojo.server.RemotePojoInvocationCommandService;
import org.rhq.enterprise.communications.command.impl.stream.server.RemoteInputStreamCommandService;
import org.rhq.enterprise.communications.command.impl.stream.server.RemoteOutputStreamCommandService;
import org.rhq.enterprise.communications.command.server.CommandAuthenticator;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.command.server.CommandProcessor;
import org.rhq.enterprise.communications.command.server.CommandService;
import org.rhq.enterprise.communications.command.server.CommandServiceDirectory;
import org.rhq.enterprise.communications.command.server.CommandServiceId;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryListener;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.ConcurrencyManager;
import org.rhq.enterprise.communications.util.SecurityUtil;

public class ServiceContainer {
    public static final String JMX_DOMAIN = "rhq.remoting";
    public static final ObjectName OBJECTNAME_CMDSERVICE_DIRECTORY = ObjectNameFactory.create((String)"rhq.remoting:type=directory");
    public static final ObjectName OBJECTNAME_NETWORK_REGISTRY = ObjectNameFactory.create((String)"rhq.remoting:type=networkregistry");
    public static final ObjectName OBJECTNAME_MULTICAST_DETECTOR = ObjectNameFactory.create((String)"rhq.remoting:type=detector,transport=multicast");
    public static final ObjectName OBJECTNAME_CONNECTOR = ObjectNameFactory.create((String)"rhq.remoting:type=connector");
    public static final ObjectName OBJECTNAME_SSL_SERVERSOCKET_FACTORY = ObjectNameFactory.create((String)"rhq.remoting:type=sslserversocketfactory");
    private static final String SUBSYSTEM = "RHQ";
    private static final ObjectName OBJECTNAME_CMDSERVICE_INSTANCE = ObjectNameFactory.create((String)"rhq.remoting:type=command,subsystem=RHQ");
    private static final Logger LOG = CommI18NFactory.getLogger(ServiceContainer.class);
    private MBeanServer m_mbs;
    private boolean m_mbsCreated;
    private ServiceContainerConfiguration m_configuration;
    private NetworkRegistry m_registry;
    private MulticastDetector m_detector;
    private CommandServiceDirectory m_commandServiceDirectory;
    private RemotePojoInvocationCommandService m_remotePojoCommandService;
    private RemoteInputStreamCommandService m_remoteInputStreamCommandService;
    private RemoteOutputStreamCommandService m_remoteOutputStreamCommandService;
    private Connector m_connector;
    private SSLServerSocketFactoryService m_sslServerSocketFactoryService;
    private ServiceContainerNetworkNotificationListener m_discoveryListener = new ServiceContainerNetworkNotificationListener();
    private ClientCommandSenderConfiguration m_clientConfiguration;
    private AtomicLong m_servicesIndex;
    private final List<CommandListener> m_commandListeners;
    private final List<ServiceContainerSenderCreationListener> m_senderCreationListeners = new Vector<ServiceContainerSenderCreationListener>();
    private ConcurrencyManager m_concurrencyManager;
    private Map<String, Object> m_customData;

    public ServiceContainer() {
        this.m_commandListeners = new ArrayList<CommandListener>();
        this.m_customData = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustomData(String key) {
        if (key == null) {
            return null;
        }
        Map<String, Object> map = this.m_customData;
        synchronized (map) {
            return this.m_customData.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomData(String key, Object data) {
        if (key == null) {
            return;
        }
        Map<String, Object> map = this.m_customData;
        synchronized (map) {
            if (data != null) {
                this.m_customData.put(key, data);
            } else {
                this.m_customData.remove(key);
            }
        }
    }

    public ServiceContainerConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public MBeanServer getMBeanServer() {
        return this.m_mbs;
    }

    public String getServerEndpoint() {
        String locator = null;
        if (this.m_connector != null) {
            try {
                locator = this.m_connector.getInvokerLocator();
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(e);
                throw re;
            }
        }
        return locator;
    }

    public ClientCommandSenderConfiguration getClientConfiguration() {
        return this.m_clientConfiguration.copy();
    }

    public ConcurrencyManager getConcurrencyManager() {
        return this.m_concurrencyManager;
    }

    public void setConcurrencyManager(ConcurrencyManager concurrencyManager) {
        this.m_concurrencyManager = concurrencyManager;
    }

    public ClientCommandSender createClientCommandSenderWithSecurity(String server_endpoint, ClientCommandSenderConfiguration client_config) {
        HashMap<String, String> ssl_config = new HashMap<String, String>();
        ssl_config.put("org.jboss.remoting.keyStore", client_config.securityKeystoreFile);
        ssl_config.put("org.jboss.remoting.keyStoreAlgorithm", client_config.securityKeystoreAlgorithm);
        ssl_config.put("org.jboss.remoting.keyStoreType", client_config.securityKeystoreType);
        ssl_config.put("org.jboss.remoting.keyStorePassword", client_config.securityKeystorePassword);
        ssl_config.put("org.jboss.remoting.keyPassword", client_config.securityKeystoreKeyPassword);
        ssl_config.put("org.jboss.remoting.trustStore", client_config.securityTruststoreFile);
        ssl_config.put("org.jboss.remoting.trustStoreAlgorithm", client_config.securityTruststoreAlgorithm);
        ssl_config.put("org.jboss.remoting.trustStoreType", client_config.securityTruststoreType);
        ssl_config.put("org.jboss.remoting.trustStorePassword", client_config.securityTruststorePassword);
        ssl_config.put("org.jboss.remoting.sslProtocol", client_config.securitySecureSocketProtocol);
        ssl_config.put("org.jboss.remoting.keyAlias", client_config.securityKeystoreAlias);
        ssl_config.put("org.jboss.remoting.serverAuthMode", Boolean.toString(client_config.securityServerAuthMode));
        ssl_config.put("org.jboss.remoting.socket.useClientMode", "true");
        try {
            JBossRemotingRemoteCommunicator remote_comm = new JBossRemotingRemoteCommunicator(server_endpoint, ssl_config);
            for (ServiceContainerSenderCreationListener listener : this.m_senderCreationListeners) {
                listener.preCreate(this, remote_comm, client_config);
            }
            ClientCommandSender sender = new ClientCommandSender(remote_comm, client_config);
            for (ServiceContainerSenderCreationListener listener : this.m_senderCreationListeners) {
                listener.postCreate(this, sender);
            }
            return sender;
        }
        catch (Exception e) {
            throw new RuntimeException(LOG.getMsgString("ServiceContainer.failed-to-create-sender", new Object[]{server_endpoint}), e);
        }
    }

    public ClientCommandSender createClientCommandSender(String server_endpoint, ClientCommandSenderConfiguration client_config) {
        HashMap<String, String> ssl_config = null;
        if (SecurityUtil.isTransportSecure(server_endpoint)) {
            ssl_config = new HashMap<String, String>();
            ssl_config.put("org.jboss.remoting.keyStore", client_config.securityKeystoreFile);
            ssl_config.put("org.jboss.remoting.keyStoreAlgorithm", client_config.securityKeystoreAlgorithm);
            ssl_config.put("org.jboss.remoting.keyStoreType", client_config.securityKeystoreType);
            ssl_config.put("org.jboss.remoting.keyStorePassword", client_config.securityKeystorePassword);
            ssl_config.put("org.jboss.remoting.keyPassword", client_config.securityKeystoreKeyPassword);
            ssl_config.put("org.jboss.remoting.trustStore", client_config.securityTruststoreFile);
            ssl_config.put("org.jboss.remoting.trustStoreAlgorithm", client_config.securityTruststoreAlgorithm);
            ssl_config.put("org.jboss.remoting.trustStoreType", client_config.securityTruststoreType);
            ssl_config.put("org.jboss.remoting.trustStorePassword", client_config.securityTruststorePassword);
            ssl_config.put("org.jboss.remoting.sslProtocol", client_config.securitySecureSocketProtocol);
            ssl_config.put("org.jboss.remoting.keyAlias", client_config.securityKeystoreAlias);
            ssl_config.put("org.jboss.remoting.serverAuthMode", Boolean.toString(client_config.securityServerAuthMode));
            ssl_config.put("org.jboss.remoting.socket.useClientMode", "true");
        }
        try {
            JBossRemotingRemoteCommunicator remote_comm = new JBossRemotingRemoteCommunicator(server_endpoint, ssl_config);
            for (ServiceContainerSenderCreationListener listener : this.m_senderCreationListeners) {
                listener.preCreate(this, remote_comm, client_config);
            }
            ClientCommandSender sender = new ClientCommandSender(remote_comm, client_config);
            for (ServiceContainerSenderCreationListener listener : this.m_senderCreationListeners) {
                listener.postCreate(this, sender);
            }
            return sender;
        }
        catch (Exception e) {
            throw new RuntimeException(LOG.getMsgString("ServiceContainer.failed-to-create-sender", new Object[]{server_endpoint}), e);
        }
    }

    public void start(Preferences configuration, ClientCommandSenderConfiguration client_configuration) throws Exception {
        this.start(configuration, client_configuration, null);
    }

    public void start(Preferences configuration, ClientCommandSenderConfiguration client_configuration, MBeanServer mbs) throws Exception {
        Integer globalConcurrencyLimit;
        this.m_configuration = new ServiceContainerConfiguration(configuration);
        ServiceContainerConfigurationUpgrade.upgradeToLatest(this.m_configuration.getPreferences());
        if (this.m_concurrencyManager == null) {
            this.m_concurrencyManager = new ConcurrencyManager(null);
        }
        if ((globalConcurrencyLimit = Integer.valueOf(this.m_configuration.getGlobalConcurrencyLimit())) > 0) {
            Map<String, Integer> limits = this.m_concurrencyManager.getAllConfiguredNumberOfPermitsAllowed();
            limits.put("rhq.communications.global-concurrency-limit-semaphore", globalConcurrencyLimit);
            this.m_concurrencyManager = new ConcurrencyManager(limits);
            this.addCommandListener(new GlobalConcurrencyLimitCommandListener(this));
            LOG.info("ServiceContainer.global-concurrency-limit-set", new Object[]{globalConcurrencyLimit});
        } else {
            LOG.info("ServiceContainer.global-concurrency-limit-disabled", new Object[0]);
        }
        boolean disabled = this.m_configuration.isCommunicationsDisabled();
        if (!disabled) {
            this.m_clientConfiguration = client_configuration.copy();
            File jboss_identity_dir = this.m_configuration.getDataDirectory();
            if (jboss_identity_dir != null) {
                System.setProperty("jboss.identity.dir", jboss_identity_dir.getAbsolutePath());
            }
            if (mbs == null) {
                this.findOrCreateMBeanServer(this.m_configuration.getMBeanServerName());
            } else {
                this.m_mbs = mbs;
                this.m_mbsCreated = false;
            }
            this.m_servicesIndex = new AtomicLong(0L);
            this.setupDetector();
            this.setupCommandServices();
            this.setupServerConnector();
            LOG.info("ServiceContainer.started", new Object[0]);
        } else {
            LOG.info("ServiceContainer.disabled", new Object[0]);
        }
    }

    public void shutdown() {
        LOG.info("ServiceContainer.shutting-down", new Object[0]);
        try {
            if (this.m_connector != null) {
                this.m_connector.stop();
                this.m_connector.destroy();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-connector-failure", new Object[0]);
        }
        try {
            if (this.m_detector != null) {
                this.m_detector.stop();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-detector-failure", new Object[0]);
        }
        try {
            if (this.m_registry != null) {
                this.m_registry.removeNotificationListener((NotificationListener)this.m_discoveryListener);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.unregister-listener-failure", new Object[0]);
        }
        try {
            if (this.m_sslServerSocketFactoryService != null) {
                this.m_sslServerSocketFactoryService.stop();
                this.m_sslServerSocketFactoryService.destroy();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-ssl-factory-service-failure", new Object[0]);
        }
        try {
            if (this.m_remotePojoCommandService != null) {
                this.m_remotePojoCommandService.stopService();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-remote-pojo-service-failure", new Object[0]);
        }
        try {
            if (this.m_remoteInputStreamCommandService != null) {
                this.m_remoteInputStreamCommandService.stopService();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-remote-instream-service-failure", new Object[0]);
        }
        try {
            if (this.m_remoteOutputStreamCommandService != null) {
                this.m_remoteOutputStreamCommandService.stopService();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ServiceContainer.shutdown-remote-outstream-service-failure", new Object[0]);
        }
        if (this.m_mbs != null) {
            try {
                if (this.m_mbsCreated) {
                    MBeanServerFactory.releaseMBeanServer(this.m_mbs);
                } else {
                    Set<ObjectName> obj_names = this.m_mbs.queryNames(new ObjectName("rhq.remoting:*"), null);
                    Iterator<ObjectName> iter = obj_names.iterator();
                    while (iter.hasNext()) {
                        try {
                            ObjectName obj_name = iter.next();
                            this.m_mbs.unregisterMBean(obj_name);
                        }
                        catch (Exception e) {
                            LOG.warn((Throwable)e, "ServiceContainer.shutdown-mbs-failure", new Object[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "ServiceContainer.shutdown-mbs-failure", new Object[0]);
            }
        }
        this.m_mbs = null;
        this.m_mbsCreated = false;
        this.m_configuration = null;
        this.m_registry = null;
        this.m_detector = null;
        this.m_connector = null;
        this.m_sslServerSocketFactoryService = null;
        this.m_remotePojoCommandService = null;
        this.m_remoteInputStreamCommandService = null;
        this.m_remoteOutputStreamCommandService = null;
        this.m_clientConfiguration = null;
        this.m_servicesIndex = null;
        this.m_concurrencyManager = null;
        this.m_discoveryListener.removeAll();
        this.m_commandListeners.clear();
        this.m_senderCreationListeners.clear();
        this.m_customData.clear();
        LOG.info("ServiceContainer.shutdown", new Object[0]);
    }

    public void addDiscoveryListener(AutoDiscoveryListener listener) {
        this.m_discoveryListener.add(listener);
    }

    public void removeDiscoveryListener(AutoDiscoveryListener listener) {
        this.m_discoveryListener.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandListener(CommandListener listener) {
        List<CommandListener> list = this.m_commandListeners;
        synchronized (list) {
            ServerInvocationHandler[] handlers;
            this.m_commandListeners.add(listener);
            Connector connector = this.m_connector;
            if (connector != null && (handlers = connector.getInvocationHandlers()) != null) {
                for (ServerInvocationHandler handler : handlers) {
                    if (!(handler instanceof CommandProcessor)) continue;
                    ((CommandProcessor)handler).addCommandListener(listener);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandListener(CommandListener listener) {
        List<CommandListener> list = this.m_commandListeners;
        synchronized (list) {
            ServerInvocationHandler[] handlers;
            this.m_commandListeners.remove(listener);
            Connector connector = this.m_connector;
            if (connector != null && (handlers = connector.getInvocationHandlers()) != null) {
                for (ServerInvocationHandler handler : handlers) {
                    if (!(handler instanceof CommandProcessor)) continue;
                    ((CommandProcessor)handler).removeCommandListener(listener);
                    return;
                }
            }
        }
    }

    public void addServiceContainerSenderCreationListener(ServiceContainerSenderCreationListener listener) {
        this.m_senderCreationListeners.add(listener);
    }

    public void removeServiceContainerSenderCreationListener(ServiceContainerSenderCreationListener listener) {
        this.m_senderCreationListeners.remove(listener);
    }

    public CommandServiceId addCommandService(CommandService command_service) throws Exception {
        long next_index = this.m_servicesIndex.incrementAndGet();
        ObjectName new_name = ObjectNameFactory.create((String)(OBJECTNAME_CMDSERVICE_INSTANCE + "," + "id" + "=" + next_index));
        command_service.setServiceContainer(this);
        this.m_mbs.registerMBean(command_service, new_name);
        CommandServiceId id = new CommandServiceId(Long.toString(next_index));
        LOG.debug("ServiceContainer.added-command-service", new Object[]{command_service.getClass().getName(), id});
        return id;
    }

    public CommandServiceId addCommandService(String command_service_class_name) throws Exception {
        CommandService commandService = (CommandService)Class.forName(command_service_class_name).newInstance();
        return this.addCommandService(commandService);
    }

    public void removeCommandService(CommandServiceId id) {
        ObjectName name = ObjectNameFactory.create((String)(OBJECTNAME_CMDSERVICE_INSTANCE + "," + "id" + "=" + id));
        try {
            this.m_mbs.unregisterMBean(name);
            LOG.debug("ServiceContainer.removed-command-service", new Object[]{id, name});
        }
        catch (InstanceNotFoundException e) {
            LOG.debug("ServiceContainer.cannot-remove-unregistered-command-service", new Object[]{id, name, e});
        }
        catch (MBeanRegistrationException e) {
            LOG.warn("ServiceContainer.cannot-remove-command-service", new Object[]{id, name, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemotePojo(Object pojo, String interface_name) throws Exception {
        ServiceContainer serviceContainer = this;
        synchronized (serviceContainer) {
            if (this.m_remotePojoCommandService == null) {
                this.m_remotePojoCommandService = new RemotePojoInvocationCommandService();
                this.addCommandService(this.m_remotePojoCommandService);
            }
        }
        this.m_remotePojoCommandService.addPojo(pojo, interface_name);
        LOG.debug("ServiceContainer.added-remote-pojo", new Object[]{pojo.getClass().getName(), interface_name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addRemotePojo(T pojo, Class<T> pojo_interface) throws Exception {
        ServiceContainer serviceContainer = this;
        synchronized (serviceContainer) {
            if (this.m_remotePojoCommandService == null) {
                this.m_remotePojoCommandService = new RemotePojoInvocationCommandService();
                this.addCommandService(this.m_remotePojoCommandService);
            }
        }
        this.m_remotePojoCommandService.addPojo(pojo, pojo_interface);
        LOG.debug("ServiceContainer.added-remote-pojo", new Object[]{pojo.getClass().getName(), pojo_interface});
    }

    public void removeRemotePojo(String interface_name) {
        this.m_remotePojoCommandService.removePojo(interface_name);
        LOG.debug("ServiceContainer.removed-remote-pojo", new Object[]{interface_name});
    }

    public void removeRemotePojo(Class remote_interface) {
        this.m_remotePojoCommandService.removePojo(remote_interface);
        LOG.debug("ServiceContainer.removed-remote-pojo", new Object[]{remote_interface});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addRemoteInputStream(InputStream in) throws Exception {
        ServiceContainer serviceContainer = this;
        synchronized (serviceContainer) {
            if (this.m_remoteInputStreamCommandService == null) {
                this.m_remoteInputStreamCommandService = new RemoteInputStreamCommandService();
                this.addCommandService(this.m_remoteInputStreamCommandService);
            }
        }
        Long stream_id = this.m_remoteInputStreamCommandService.addInputStream(in);
        return stream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addRemoteOutputStream(OutputStream out) throws Exception {
        ServiceContainer serviceContainer = this;
        synchronized (serviceContainer) {
            if (this.m_remoteOutputStreamCommandService == null) {
                this.m_remoteOutputStreamCommandService = new RemoteOutputStreamCommandService();
                this.addCommandService(this.m_remoteOutputStreamCommandService);
            }
        }
        Long stream_id = this.m_remoteOutputStreamCommandService.addOutputStream(out);
        return stream_id;
    }

    public boolean removeRemoteInputStream(Long stream_id) {
        return this.m_remoteInputStreamCommandService.removeInputStream(stream_id);
    }

    public boolean removeRemoteOutputStream(Long stream_id) {
        return this.m_remoteOutputStreamCommandService.removeOutputStream(stream_id);
    }

    public void addInvocationHandler(String subsystem, ServerInvocationHandler handler) throws Exception {
        if (this.m_connector == null) {
            throw new IllegalStateException("m_connector==null");
        }
        this.m_connector.addInvocationHandler(subsystem, handler);
    }

    public void removeInvocationHandler(String subsystem) throws Exception {
        if (this.m_connector == null) {
            throw new IllegalStateException("m_connector==null");
        }
        this.m_connector.removeInvocationHandler(subsystem);
    }

    private void findOrCreateMBeanServer(String mbs_name) {
        MBeanServer mbs = null;
        if (mbs_name != null) {
            ArrayList<MBeanServer> all_mbs = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer cur_mbs : all_mbs) {
                if (cur_mbs == null || !mbs_name.equals(cur_mbs.getDefaultDomain())) continue;
                LOG.debug("ServiceContainer.using-existing-mbs", new Object[]{mbs_name});
                mbs = cur_mbs;
                this.m_mbsCreated = false;
                break;
            }
            if (mbs == null) {
                LOG.debug("ServiceContainer.creating-mbs", new Object[]{mbs_name});
                mbs = MBeanServerFactory.createMBeanServer(mbs_name);
                this.m_mbsCreated = true;
            }
        } else {
            mbs = ManagementFactory.getPlatformMBeanServer();
            LOG.debug("ServiceContainer.using-existing-mbs", new Object[]{mbs.getDefaultDomain()});
            this.m_mbsCreated = false;
        }
        this.m_mbs = mbs;
    }

    private void setupDetector() throws Exception {
        this.m_registry = new NetworkRegistry();
        try {
            Identity.get((MBeanServer)this.m_mbs);
        }
        catch (Exception e) {
            LOG.debug("ServiceContainer.identity-failure", new Object[]{e});
            System.setProperty("jboss.identity", Identity.createUniqueID());
        }
        try {
            this.m_mbs.registerMBean(this.m_registry, OBJECTNAME_NETWORK_REGISTRY);
        }
        catch (Exception e) {
            LOG.warn("ServiceContainer.network-registry-failure", new Object[]{e});
            this.m_registry = null;
            return;
        }
        this.m_registry.addNotificationListener((NotificationListener)this.m_discoveryListener, null, null);
        LOG.debug("ServiceContainer.registry-created", new Object[]{OBJECTNAME_NETWORK_REGISTRY});
        if (this.m_configuration.isMulticastDetectorEnabled()) {
            try {
                this.m_detector = new MulticastDetector();
                String address = this.m_configuration.getMulticastDetectorMulticastAddress();
                String bind_address = this.m_configuration.getMulticastDetectorBindAddress();
                long default_delay = this.m_configuration.getMulticastDetectorDefaultTimeDelay();
                long heartbeat_delay = this.m_configuration.getMulticastDetectorHeartbeatTimeDelay();
                int port = this.m_configuration.getMulticastDetectorPort();
                if (address != null) {
                    InetAddress inet_addr = InetAddress.getByName(address);
                    this.m_detector.setAddress(inet_addr);
                    this.m_detector.setDefaultIP(inet_addr.getHostAddress());
                }
                if (bind_address != null) {
                    this.m_detector.setBindAddress(InetAddress.getByName(bind_address));
                }
                if (default_delay != Long.MIN_VALUE) {
                    this.m_detector.setDefaultTimeDelay(default_delay);
                }
                if (heartbeat_delay != Long.MIN_VALUE) {
                    this.m_detector.setHeartbeatTimeDelay(heartbeat_delay);
                }
                if (port != Integer.MIN_VALUE) {
                    this.m_detector.setPort(port);
                }
                LOG.debug("ServiceContainer.multicast-detector-config", new Object[]{this.m_detector.getAddress(), this.m_detector.getPort(), this.m_detector.getBindAddress(), this.m_detector.getDefaultIP(), this.m_detector.getDefaultTimeDelay(), this.m_detector.getHeartbeatTimeDelay()});
                this.m_mbs.registerMBean(this.m_detector, OBJECTNAME_MULTICAST_DETECTOR);
                this.m_detector.start();
                LOG.debug("ServiceContainer.multicast-detector-created", new Object[]{OBJECTNAME_MULTICAST_DETECTOR});
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "ServiceContainer.multicast-detector-start-error", new Object[]{e});
            }
        } else {
            LOG.debug("ServiceContainer.multicast-detector-disabled", new Object[0]);
        }
    }

    private void setupServerConnector() throws Exception {
        String locator_uri = this.m_configuration.getConnectorRemoteEndpoint();
        InvokerLocator locator = new InvokerLocator(locator_uri);
        LOG.debug("ServiceContainer.connector-uri", new Object[]{locator});
        String transport = this.m_configuration.getConnectorTransport();
        HashMap<String, String> connector_config = new HashMap<String, String>();
        if (SecurityUtil.isTransportSecure(transport)) {
            LOG.debug("ServiceContainer.needs-security-services", new Object[]{transport});
            this.initializeSecurityServices();
            connector_config.put("serverSocketFactory", OBJECTNAME_SSL_SERVERSOCKET_FACTORY.toString());
            if (transport.equals("https")) {
                connector_config.put("SSLImplementation", RemotingSSLImplementation.class.getName());
            }
        }
        this.m_connector = new Connector(connector_config);
        this.m_connector.setInvokerLocator(locator.getLocatorURI());
        long lease_period = this.m_configuration.getConnectorLeasePeriod();
        if (lease_period != Long.MIN_VALUE) {
            this.m_connector.setLeasePeriod(lease_period);
        }
        LOG.debug("ServiceContainer.connector-lease-period", new Object[]{this.m_connector.getLeasePeriod()});
        this.m_mbs.registerMBean(this.m_connector, OBJECTNAME_CONNECTOR);
        this.m_connector.create();
        CommandProcessor handler = new CommandProcessor();
        for (CommandListener listener : this.m_commandListeners) {
            handler.addCommandListener(listener);
        }
        CommandAuthenticator commandAuthenticator = this.m_configuration.getCommandAuthenticator();
        if (commandAuthenticator != null) {
            commandAuthenticator.setServiceContainer(this);
            handler.setCommandAuthenticator(commandAuthenticator);
        }
        this.m_connector.addInvocationHandler(SUBSYSTEM, (ServerInvocationHandler)handler);
        this.m_connector.start();
        ServiceContainerMetrics metrics_mbean = new ServiceContainerMetrics(this, handler);
        this.m_mbs.registerMBean(metrics_mbean, ServiceContainerMetricsMBean.OBJECTNAME_METRICS);
        LOG.debug("ServiceContainer.processor-ready", new Object[0]);
    }

    private void setupCommandServices() throws Exception {
        boolean dynamic_discovery = this.m_configuration.isCommandServiceDirectoryDynamicDiscoveryEnabled();
        if (!dynamic_discovery) {
            this.m_remotePojoCommandService = new RemotePojoInvocationCommandService();
            this.addCommandService(this.m_remotePojoCommandService);
            this.m_remoteInputStreamCommandService = new RemoteInputStreamCommandService();
            this.addCommandService(this.m_remoteInputStreamCommandService);
            this.m_remoteOutputStreamCommandService = new RemoteOutputStreamCommandService();
            this.addCommandService(this.m_remoteOutputStreamCommandService);
        }
        String cmdServicesPropStr = this.m_configuration.getStartupCommandServices();
        String[] cmdServicesClassNames = cmdServicesPropStr.split("\\s*,\\s*");
        for (int i = 0; i < cmdServicesClassNames.length; ++i) {
            String cmdServiceClassName = cmdServicesClassNames[i].trim();
            this.addCommandService(cmdServiceClassName);
        }
        String remotePojosPropStr = this.m_configuration.getStartupRemotePojos();
        String[] remotePojosDefs = remotePojosPropStr.split("\\s*,\\s*");
        for (int i = 0; i < remotePojosDefs.length; ++i) {
            String[] classAndInterfaceNames = remotePojosDefs[i].split("\\s*:\\s*");
            if (classAndInterfaceNames.length != 2) {
                throw new InvalidConfigurationException(LOG.getMsgString("ServiceContainer.remote-pojo-config-invalid", new Object[]{"rhq.communications.remote-pojos", remotePojosDefs[i], remotePojosPropStr}));
            }
            String pojo_class_name = classAndInterfaceNames[0];
            String remote_interface_name = classAndInterfaceNames[1];
            Object pojo_instance = Class.forName(pojo_class_name).newInstance();
            this.addRemotePojo(pojo_instance, remote_interface_name);
        }
        this.m_commandServiceDirectory = new CommandServiceDirectory();
        this.m_commandServiceDirectory.setAllowDynamicDiscovery(dynamic_discovery);
        this.m_mbs.registerMBean(this.m_commandServiceDirectory, OBJECTNAME_CMDSERVICE_DIRECTORY);
        LOG.debug("ServiceContainer.directory-created", new Object[]{OBJECTNAME_CMDSERVICE_DIRECTORY});
    }

    private void initializeSecurityServices() throws Exception {
        SSLSocketBuilder socket_builder;
        block4: {
            socket_builder = new SSLSocketBuilder();
            socket_builder.setUseSSLServerSocketFactory(false);
            socket_builder.setSecureSocketProtocol(this.m_configuration.getConnectorSecuritySocketProtocol());
            socket_builder.setKeyStoreAlgorithm(this.m_configuration.getConnectorSecurityKeystoreAlgorithm());
            socket_builder.setKeyStoreType(this.m_configuration.getConnectorSecurityKeystoreType());
            socket_builder.setKeyStorePassword(this.m_configuration.getConnectorSecurityKeystorePassword());
            socket_builder.setKeyPassword(this.m_configuration.getConnectorSecurityKeystoreKeyPassword());
            socket_builder.setTrustStoreAlgorithm(this.m_configuration.getConnectorSecurityTruststoreAlgorithm());
            socket_builder.setTrustStoreType(this.m_configuration.getConnectorSecurityTruststoreType());
            socket_builder.setTrustStorePassword(this.m_configuration.getConnectorSecurityTruststorePassword());
            socket_builder.setClientAuthMode(this.m_configuration.getConnectorSecurityClientAuthMode());
            socket_builder.setServerSocketUseClientMode(false);
            try {
                socket_builder.setKeyStoreURL(this.m_configuration.getConnectorSecurityKeystoreFile());
            }
            catch (Exception e) {
                this.createKeyStore();
                socket_builder.setKeyStoreURL(this.m_configuration.getConnectorSecurityKeystoreFile());
            }
            try {
                socket_builder.setTrustStoreURL(this.m_configuration.getConnectorSecurityTruststoreFile());
            }
            catch (Exception e) {
                if (this.m_configuration.getConnectorSecurityClientAuthMode().equals("none")) break block4;
                LOG.debug("ServiceContainer.truststore-failure", new Object[0]);
            }
        }
        this.m_sslServerSocketFactoryService = new SSLServerSocketFactoryService();
        this.m_sslServerSocketFactoryService.setSSLSocketBuilder((SSLSocketBuilderMBean)socket_builder);
        this.m_sslServerSocketFactoryService.create();
        this.m_sslServerSocketFactoryService.start();
        this.m_mbs.registerMBean(this.m_sslServerSocketFactoryService, OBJECTNAME_SSL_SERVERSOCKET_FACTORY);
        LOG.debug("ServiceContainer.ssl-socket-factory-created", new Object[]{OBJECTNAME_SSL_SERVERSOCKET_FACTORY});
    }

    private void createKeyStore() {
        SecurityUtil.createKeyStore(this.m_configuration.getConnectorSecurityKeystoreFile(), this.m_configuration.getConnectorSecurityKeystoreAlias(), "CN=RHQ, OU=RHQ, O=rhq-project.org, C=US", this.m_configuration.getConnectorSecurityKeystorePassword(), this.m_configuration.getConnectorSecurityKeystoreKeyPassword(), "DSA", 36500);
    }
}

