/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.param.InvalidParameterDefinitionException;
import org.rhq.enterprise.communications.command.param.ParameterRenderingInformation;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class OptionListRenderingInformation
extends ParameterRenderingInformation
implements Serializable {
    private static final long serialVersionUID = -8125953068553352997L;
    private static final Logger LOG = CommI18NFactory.getLogger(OptionListRenderingInformation.class);
    private final List optionLabelKeys;
    private List<String> optionLabels;

    public OptionListRenderingInformation() {
        this(null, null, null);
    }

    public OptionListRenderingInformation(String labelKey, String descriptionKey, List optionLabelKeys) {
        super(labelKey, descriptionKey);
        this.optionLabelKeys = optionLabelKeys;
    }

    public List getOptionLabelKeys() {
        return this.optionLabelKeys;
    }

    public List getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(List<String> optionLabels) {
        this.optionLabels = optionLabels;
    }

    @Override
    public void applyResourceBundle(ResourceBundle resourceBundle) throws MissingResourceException {
        super.applyResourceBundle(resourceBundle);
        if (resourceBundle != null) {
            if (this.optionLabelKeys != null) {
                String optionLabelKey2 = null;
                this.optionLabels = new ArrayList<String>();
                for (String optionLabelKey2 : this.optionLabelKeys) {
                    String optionLabel = resourceBundle.getString(optionLabelKey2);
                    this.optionLabels.add(optionLabel);
                }
            } else {
                LOG.trace("OptionListRenderingInformation.not-using-option-labels-key", new Object[0]);
            }
        } else if (this.optionLabelKeys != null && !this.optionLabelKeys.isEmpty()) {
            throw new InvalidParameterDefinitionException("OptionListRenderingInformation.no-resource-bundle");
        }
    }
}

