/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_AddColumn
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table;
    private String column;
    private String columnType;
    private String precision;

    public void setTable(String t) {
        this.table = t;
    }

    public void setColumn(String c) {
        this.column = c;
    }

    public void setColumnType(String ct) {
        this.columnType = ct;
    }

    public void setPrecision(String p) {
        this.precision = p;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (!this.isDBTargeted()) {
            return;
        }
        try {
            DatabaseType db_type = this.getDatabaseType();
            Connection conn = this.getConnection();
            this.log(MSG.getMsg("SchemaSpecTask.addcolumn.executing", new Object[]{this.table, this.column, this.columnType, this.precision}));
            db_type.addColumn(conn, this.table, this.column, this.columnType, this.precision);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.addcolumn.error", new Object[]{e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AddColumn", "table"}));
        }
        if (this.column == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AddColumn", "column"}));
        }
        if (this.columnType == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AddColumn", "columnType"}));
        }
    }
}

