/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_DirectSQL
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private List<Statement> statements;

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        Connection conn = this.getConnection();
        DatabaseType db_type = this.getDatabaseType();
        if (this.statements != null) {
            for (Statement statement : this.statements) {
                statement.init(conn, db_type);
                statement.execute();
            }
        }
    }

    public Statement createStatement() {
        Statement statement = new Statement();
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statement);
        return statement;
    }

    private void validateAttributes() throws BuildException {
        if (this.statements == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-child-element", new Object[]{"DirectSQL", "statement"}));
        }
    }

    public class Statement
    extends Task {
        private Connection databaseConnection = null;
        private DatabaseType databaseType = null;
        private String sqlStatment = null;
        private String sqlDescription = null;
        private String targetDBVendor = null;
        private String targetDBVersion = null;

        public void init(Connection conn, DatabaseType db_type) {
            this.databaseConnection = conn;
            this.databaseType = db_type;
        }

        public void setDesc(String s) {
            this.sqlDescription = s;
        }

        public void setTargetDBVendor(String vendor) {
            this.targetDBVendor = vendor;
        }

        public void setTargetDBVersion(String version) {
            this.targetDBVersion = version;
        }

        public void addText(String sql) {
            this.sqlStatment = sql;
        }

        public void execute() throws BuildException {
            if (this.sqlStatment == null) {
                return;
            }
            if (this.targetDBVersion != null && this.targetDBVendor == null) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.invalid-target-db", new Object[]{this.getTaskName(), this.targetDBVersion}));
            }
            if (this.targetDBVendor != null) {
                if (!this.targetDBVendor.equalsIgnoreCase(this.databaseType.getVendor())) {
                    this.log(MSG.getMsg("SchemaSpecTask.vendor-mismatch", new Object[]{this.targetDBVendor, this.databaseType.getVendor()}));
                    return;
                }
                if (this.targetDBVersion != null && !this.targetDBVersion.equalsIgnoreCase(this.databaseType.getVersion())) {
                    this.log(MSG.getMsg("SchemaSpecTask.version-mismatch", new Object[]{this.targetDBVendor, this.targetDBVersion, this.databaseType.getVersion()}));
                    return;
                }
            }
            try {
                this.log(MSG.getMsg("SchemaSpecTask.directsql.executing", new Object[]{this.sqlDescription, this.sqlStatment}));
                this.databaseType.executeSql(this.databaseConnection, this.sqlStatment);
            }
            catch (Exception e) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.failure", new Object[]{"DirectSQL", e}), (Throwable)e);
            }
        }
    }
}

