/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.db.setup.Data;

abstract class DataSet {
    private DBSetup m_parent;
    private String m_strTableName;

    protected DataSet(String tableName, DBSetup dbsetup) {
        this.m_strTableName = tableName;
        this.m_parent = dbsetup;
    }

    protected int create() throws SQLException {
        int rowcnt = 0;
        try {
            this.executePreCreateCommands();
            while (this.next()) {
                String strCmd = this.getCreateCommand();
                this.doSQL(strCmd);
                ++rowcnt;
            }
            this.executePostCreateCommands();
        }
        catch (SQLException e) {
            try {
                this.m_parent.getConnection().rollback();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw e;
        }
        return rowcnt;
    }

    protected void doSQL(String sql) throws SQLException {
        this.m_parent.doSQL(sql);
    }

    protected void executePreCreateCommands() throws SQLException {
    }

    protected void executePostCreateCommands() throws SQLException {
    }

    protected String getCreateCommand() throws SQLException {
        String cmd = this.keyColumnsExist() ? this.getUpdateCommand() : this.getInsertCommand();
        return cmd;
    }

    protected String getInsertCommand() throws SQLException {
        int i;
        int iCols = this.getNumberColumns();
        StringBuilder strCmd = new StringBuilder("INSERT INTO ");
        strCmd.append(this.getTableName());
        strCmd.append(" (");
        for (i = 0; i < iCols; ++i) {
            Data data = this.getData(i);
            if (i > 0) {
                strCmd.append(',');
            }
            strCmd.append(data.getColumnName());
        }
        strCmd.append(") VALUES (");
        for (i = 0; i < iCols; ++i) {
            String strValue;
            if (i > 0) {
                strCmd.append(',');
            }
            if ((strValue = this.getData(i).getValue()) != null) {
                if (DatabaseTypeFactory.isOracle(this.m_parent.getDatabaseType()) || DatabaseTypeFactory.isSQLServer(this.m_parent.getDatabaseType())) {
                    if (strValue.equalsIgnoreCase("TRUE")) {
                        strValue = "1";
                    } else if (strValue.equalsIgnoreCase("FALSE")) {
                        strValue = "0";
                    }
                }
                strCmd.append('\'');
                strCmd.append(strValue);
                strCmd.append('\'');
                continue;
            }
            strCmd.append("NULL");
        }
        strCmd.append(')');
        return strCmd.toString();
    }

    protected String getUpdateCommand() throws SQLException {
        int iCols = this.getNumberColumns();
        StringBuilder strCmd = new StringBuilder("UPDATE ");
        strCmd.append(this.getTableName());
        strCmd.append(" SET ");
        boolean need_comma = false;
        for (int i = 0; i < iCols; ++i) {
            Data data = this.getData(i);
            if (data.isKeyColumn()) continue;
            if (need_comma) {
                strCmd.append(',');
            }
            need_comma = true;
            strCmd.append(data.getColumnName());
            strCmd.append(" = ");
            String strValue = data.getValue();
            if (strValue != null) {
                if (DatabaseTypeFactory.isOracle(this.m_parent.getDatabaseType()) || DatabaseTypeFactory.isSQLServer(this.m_parent.getDatabaseType())) {
                    if (strValue.equalsIgnoreCase("TRUE")) {
                        strValue = "1";
                    } else if (strValue.equalsIgnoreCase("FALSE")) {
                        strValue = "0";
                    }
                }
                strCmd.append('\'');
                strCmd.append(strValue);
                strCmd.append('\'');
                continue;
            }
            strCmd.append("NULL");
        }
        strCmd.append(" WHERE ");
        boolean need_AND_keyword = false;
        List<Data> keys = this.getKeyColumns();
        for (Data data : keys) {
            if (need_AND_keyword) {
                strCmd.append(" AND ");
            }
            need_AND_keyword = true;
            strCmd.append(data.getActualColumnName()).append(" = ");
            String key_value = data.getValue();
            if (key_value != null) {
                if (DatabaseTypeFactory.isOracle(this.m_parent.getDatabaseType()) || DatabaseTypeFactory.isSQLServer(this.m_parent.getDatabaseType())) {
                    if (key_value.equalsIgnoreCase("TRUE")) {
                        key_value = "1";
                    } else if (key_value.equalsIgnoreCase("FALSE")) {
                        key_value = "0";
                    }
                }
                strCmd.append('\'');
                strCmd.append(key_value);
                strCmd.append('\'');
                continue;
            }
            strCmd.append("NULL");
        }
        return strCmd.toString();
    }

    protected int getNumberColumns() {
        return 0;
    }

    protected String getTableName() {
        return this.m_strTableName;
    }

    protected boolean keyColumnsExist() {
        int num_col = this.getNumberColumns();
        for (int i = 0; i < num_col; ++i) {
            Data data = this.getData(i);
            if (data == null) {
                System.err.println("Data at column index for table " + this.m_strTableName + " is null");
                continue;
            }
            if (!data.isKeyColumn()) continue;
            return true;
        }
        return false;
    }

    protected List<Data> getKeyColumns() {
        ArrayList<Data> keys = new ArrayList<Data>();
        int num_col = this.getNumberColumns();
        for (int i = 0; i < num_col; ++i) {
            Data data = this.getData(i);
            if (data == null) {
                System.err.println("Data at column index for table " + this.m_strTableName + " is null");
                continue;
            }
            if (!data.isKeyColumn()) continue;
            keys.add(data);
        }
        return keys;
    }

    protected abstract Data getData(int var1);

    protected abstract boolean next();
}

