/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import mazz.i18n.Msg;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.db.setup.OracleIndex;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Index {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String m_strName;
    private Collection<String> m_collFields;
    private Table m_table;
    private boolean m_isUnique;
    private DBSetup m_parent;
    private String m_tableSpace;
    private String m_condition;

    protected Index(Node node, Table table, DatabaseType dbtype) throws SAXException {
        this.m_parent = table.getDBSetup();
        if (!Index.isIndex(node)) {
            throw new SAXException("node is not an INDEX.");
        }
        NamedNodeMap map = node.getAttributes();
        for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
            Node nodeMap = map.item(iAttr);
            String strName = nodeMap.getNodeName();
            String strValue = nodeMap.getNodeValue();
            if (strName.equalsIgnoreCase("name")) {
                this.m_strName = strValue;
            }
            if (strName.equalsIgnoreCase("unique")) {
                if (strValue.equalsIgnoreCase("true")) {
                    this.m_isUnique = true;
                } else if (strValue.equalsIgnoreCase("false")) {
                    this.m_isUnique = false;
                } else {
                    throw new SAXException("value of unique attribute on INDEX element must be 'true' or 'false' (was '" + strValue + "')");
                }
            }
            if (strName.equalsIgnoreCase("tablespace")) {
                this.m_tableSpace = strValue;
            }
            if (!strName.equalsIgnoreCase("condition")) continue;
            if (DatabaseTypeFactory.isPostgres(dbtype)) {
                this.m_condition = strValue;
                continue;
            }
            System.out.println(MSG.getMsg("DBUpgrader.index-condition-not-supported", new Object[]{dbtype.getName()}));
        }
        this.m_collFields = new ArrayList<String>();
        NodeList listFields = node.getChildNodes();
        for (int iField = 0; iField < listFields.getLength(); ++iField) {
            node = listFields.item(iField);
            if (!Index.isField(node)) continue;
            map = node.getAttributes();
            for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                Node nodeMap = map.item(iAttr);
                String strName = nodeMap.getNodeName();
                String strValue = nodeMap.getNodeValue();
                if (!strName.equalsIgnoreCase("name") && !strName.equalsIgnoreCase("ref")) continue;
                this.m_collFields.add(strValue);
            }
        }
        this.m_table = table;
    }

    protected void create() throws SQLException {
        String strCmd = this.getCreateString();
        this.m_parent.doSQL(strCmd);
    }

    protected String getCreateString() {
        String strCmd = this.m_isUnique ? "CREATE UNIQUE INDEX " + this.getName() + " ON " + this.getTable().getName() + " (" : "CREATE INDEX " + this.getName() + " ON " + this.getTable().getName() + " (";
        Iterator iter = this.getFields().iterator();
        boolean bFirst = true;
        while (iter.hasNext()) {
            if (bFirst) {
                bFirst = false;
            } else {
                strCmd = strCmd + ", ";
            }
            String strField = (String)iter.next();
            strCmd = strCmd + strField;
        }
        strCmd = strCmd + ')';
        strCmd = strCmd + this.getTableSpaceClause();
        strCmd = strCmd + this.m_table.getStorageClause();
        if (this.m_condition != null) {
            strCmd = strCmd + " WHERE " + this.m_condition;
        }
        return strCmd;
    }

    protected Collection getFields() {
        return this.m_collFields;
    }

    protected String getName() {
        return this.m_strName.toUpperCase();
    }

    protected Table getTable() {
        return this.m_table;
    }

    protected static Collection<Index> getIndexes(Table table, Node nodeTable, DatabaseType dbtype) {
        String strTableName = nodeTable.getNodeName();
        NodeList listIdx = nodeTable.getChildNodes();
        Vector<Index> colResult = new Vector<Index>();
        for (int i = 0; i < listIdx.getLength(); ++i) {
            Node node = listIdx.item(i);
            if (!Index.isIndex(node)) continue;
            try {
                if (DatabaseTypeFactory.isOracle(dbtype)) {
                    colResult.add(new OracleIndex(node, table, dbtype));
                    continue;
                }
                colResult.add(new Index(node, table, dbtype));
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected String getTableSpaceClause() {
        if (this.m_tableSpace != null && !this.m_tableSpace.equals("DEFAULT") && !this.getTableSpaceSyntax().equals("")) {
            return this.getTableSpaceSyntax() + this.m_tableSpace;
        }
        return "";
    }

    protected String getTableSpaceSyntax() {
        return "";
    }

    protected static boolean isField(Node node) {
        return node.getNodeName().equalsIgnoreCase("field");
    }

    protected static boolean isIndex(Node node) {
        return node.getNodeName().equalsIgnoreCase("index");
    }
}

