/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;
import org.rhq.core.db.upgrade.StorageNodeAddressUpgradeTask;

public class SubcategoryUpgradeTask
implements DatabaseUpgradeTask {
    private final Logger log = DbUtilsI18NFactory.getLogger(StorageNodeAddressUpgradeTask.class);

    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        String sql = "SELECT RHQ_RESOURCE_TYPE.id, RHQ_RESOURCE_SUBCAT.name FROM RHQ_RESOURCE_TYPE  LEFT JOIN RHQ_RESOURCE_SUBCAT  ON RHQ_RESOURCE_TYPE.subcategory_id = RHQ_RESOURCE_SUBCAT.id";
        this.log.debug("DatabaseType.executing-sql", new Object[]{sql});
        List<Object[]> results = databaseType.executeSelectSql(connection, sql);
        for (Object[] row : results) {
            Integer rowId = databaseType.getInteger(row[0]);
            String subcategoryName = (String)row[1];
            if (subcategoryName == null || subcategoryName.isEmpty()) continue;
            this.log.debug("DatabaseType.generic-message", new Object[]{"Updating resource [id= " + rowId + "] to have subcategory " + subcategoryName});
            String update = "UPDATE RHQ_RESOURCE_TYPE SET SUBCATEGORY = '" + subcategoryName + "' WHERE id = " + rowId;
            this.log.debug("DatabaseType.executing-sql", new Object[]{update});
            databaseType.executeSql(connection, update);
        }
    }
}

