/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.AuthenticationException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.SessionManager;
import org.rhq.cassandra.schema.Step;
import org.rhq.cassandra.schema.UpdateFile;
import org.rhq.cassandra.schema.UpdateFolder;

abstract class AbstractManager {
    private static final String MANAGEMENT_BASE_FOLDER = "management";
    protected static final String DEFAULT_CASSANDRA_USER = "cassandra";
    protected static final String DEFAULT_CASSANDRA_PASSWORD = "-1e4662ac0d7ddef155fd5fac8f894a49";
    private final Log log = LogFactory.getLog(AbstractManager.class);
    private SessionManager sessionManager;
    private final String username;
    private final String password;
    private final int cqlPort;
    private final String[] nodes;
    private final UpdateFile managementTasks;

    protected AbstractManager(String username, String password, String[] nodes, int cqlPort, SessionManager sessionManager) {
        this.username = username;
        this.password = password;
        this.cqlPort = cqlPort;
        this.nodes = nodes;
        this.sessionManager = sessionManager;
        try {
            UpdateFolder managementFolder = new UpdateFolder(MANAGEMENT_BASE_FOLDER);
            this.managementTasks = managementFolder.getUpdateFiles().get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable create storage node session.", e);
        }
    }

    protected void initClusterSession() {
        this.initClusterSession(this.username, this.password);
    }

    protected void initClusterSession(String username, String password) {
        this.sessionManager.initSession(username, password, this.cqlPort, this.nodes);
    }

    protected void shutdownClusterConnection() {
        this.log.info((Object)"Shutting down existing cluster connections");
        this.sessionManager.shutdownCluster();
    }

    protected int getActualClusterSize() {
        return this.sessionManager.getSession().getCluster().getMetadata().getAllHosts().size();
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    protected int getCqlPort() {
        return this.cqlPort;
    }

    protected boolean userExists() {
        try {
            ResultSet resultSet = this.execute("SELECT * FROM system_auth.users WHERE name = '" + this.username + "'");
            return !resultSet.all().isEmpty();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean schemaExists() {
        try {
            ResultSet resultSet = this.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name = 'rhq'");
            if (!resultSet.all().isEmpty()) {
                resultSet = this.execute("SELECT * FROM system.schema_columnfamilies WHERE keyspace_name='rhq' AND columnfamily_name='schema_version'");
                return !resultSet.all().isEmpty();
            }
            return false;
        }
        catch (AuthenticationException exp) {
            throw exp;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected int getInstalledSchemaVersion() {
        int maxVersion = 0;
        try {
            ResultSet resultSet = this.execute("SELECT version FROM rhq.schema_version");
            for (Row row : resultSet.all()) {
                if (maxVersion >= row.getInt(0)) continue;
                maxVersion = row.getInt(0);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        return maxVersion;
    }

    protected int calculateNewReplicationFactor() {
        int actualClusterSize = this.getActualClusterSize();
        int replicationFactor = actualClusterSize < 3 ? actualClusterSize : (actualClusterSize < 4 ? 2 : 3);
        return replicationFactor;
    }

    protected int queryReplicationFactor() {
        int replicationFactor = 1;
        try {
            ResultSet resultSet = this.execute("SELECT strategy_options FROM system.schema_keyspaces where keyspace_name='rhq'");
            Row row = resultSet.one();
            String replicationFactorString = "replication_factor\"";
            String resultString = row.getString(0);
            resultString = resultString.substring(resultString.indexOf(replicationFactorString) + replicationFactorString.length());
            resultString = resultString.substring(resultString.indexOf(34) + 1);
            resultString = resultString.substring(0, resultString.indexOf(34));
            replicationFactor = Integer.parseInt(resultString);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return replicationFactor;
    }

    protected void execute(UpdateFile updateFile) {
        this.execute(updateFile, null);
    }

    protected void execute(UpdateFile updateFile, String propertyName, String propertyValue) {
        Properties properties = new Properties();
        properties.put(propertyName, propertyValue);
        this.execute(updateFile, properties);
    }

    protected void execute(UpdateFile updateFile, Properties properties) {
        this.log.info((Object)("Applying update file: " + updateFile));
        for (Step step : updateFile.getOrderedSteps()) {
            this.log.debug((Object)step);
            step.bind(properties);
            step.setSession(this.sessionManager.getSession());
            step.execute();
        }
        this.log.info((Object)("Applied update file: " + updateFile));
    }

    protected ResultSet execute(String query) {
        return this.sessionManager.getSession().execute(query);
    }

    static enum Query {
        USER_EXISTS,
        SCHEMA_EXISTS,
        VERSION_COLUMNFAMILY_EXISTS,
        VERSION,
        REPLICATION_FACTOR,
        INSERT_SCHEMA_VERSION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

