/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.util.ClusterBuilder;

public class SessionManager {
    private final Log log = LogFactory.getLog(SessionManager.class);
    private Cluster cluster;
    private Session session;

    public void initSession(String username, String password, int cqlPort, String ... nodes) {
        if (this.session == null) {
            this.log.debug((Object)("Initializing session for [username: " + username + ", cqlPort: " + cqlPort + ", nodes: " + Arrays.toString(nodes) + "]"));
            this.cluster = new ClusterBuilder().addContactPoints(nodes).withCredentialsObfuscated(username, password).withPort(cqlPort).withCompression(ProtocolOptions.Compression.NONE).build();
            this.session = this.cluster.connect("system");
        }
    }

    public void shutdownCluster() {
        this.log.debug((Object)"Shutting down storage cluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
            this.session = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Set<String> getNodeAdresses() {
        TreeSet<String> nodes = new TreeSet<String>();
        for (Host host : this.cluster.getMetadata().getAllHosts()) {
            nodes.add(host.getAddress().getHostName());
        }
        return nodes;
    }
}

