/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import java.util.Arrays;
import org.jboss.dmr.ModelNode;

public class Address
implements Cloneable {
    private ModelNode addressNode = new ModelNode();

    public static Address root() {
        return new Address();
    }

    public Address() {
    }

    public Address(String ... addressParts) {
        this();
        this.add(addressParts);
    }

    public ModelNode getAddressNode() {
        return this.addressNode;
    }

    public Address add(String ... addressParts) {
        if (addressParts != null) {
            if (addressParts.length % 2 != 0) {
                throw new IllegalArgumentException("address is incomplete: " + Arrays.toString(addressParts));
            }
            if (addressParts.length > 0) {
                for (int i = 0; i < addressParts.length; i += 2) {
                    this.addressNode.add(addressParts[i], addressParts[i + 1]);
                }
            }
        }
        return this;
    }

    public Address add(String type, String name) {
        this.addressNode.add(type, name);
        return this;
    }

    public Address clone() {
        Address clone = new Address();
        clone.addressNode = this.addressNode.clone();
        return clone;
    }

    public String toString() {
        return this.addressNode.asString();
    }

    public int hashCode() {
        return this.addressNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        return this.addressNode.equals(((Address)obj).addressNode);
    }
}

