/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.rhq.core.util.stream.StreamUtil;

public class FileReverter {
    private final File file;
    private final byte[] originalContent;

    public FileReverter(File file) {
        this.file = file;
        try {
            this.originalContent = StreamUtil.slurp(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve content from file: " + file);
        }
    }

    public void revert() {
        try {
            StreamUtil.copy(new ByteArrayInputStream(this.originalContent), new FileOutputStream(this.file));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to revert file: " + this.file);
        }
    }
}

