/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.util;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class ClusterBuilder {
    private Cluster.Builder builder = Cluster.builder();
    private ProtocolOptions.Compression compression;

    public ClusterBuilder addContactPoints(String ... addresses) {
        this.builder.addContactPoints(addresses);
        return this;
    }

    public PoolingOptions poolingOptions() {
        return this.builder.poolingOptions();
    }

    public ClusterBuilder withCredentials(String username, String password) {
        this.builder.withCredentials(username, password);
        return this;
    }

    public ClusterBuilder withCredentialsObfuscated(String username, String obfuscatedPassword) {
        this.builder.withCredentials(username, PicketBoxObfuscator.decode((String)obfuscatedPassword));
        return this;
    }

    public ClusterBuilder withCompression(ProtocolOptions.Compression compression) {
        if (this.isIBMJRE() && compression == ProtocolOptions.Compression.SNAPPY) {
            throw new IllegalArgumentException(compression.name() + " compression cannot be used with an IBM JRE. " + "See https://bugzilla.redhat.com/show_bug.cgi?id=907485 for details.");
        }
        this.compression = compression;
        this.builder.withCompression(compression);
        return this;
    }

    public ClusterBuilder withPort(int port) {
        this.builder.withPort(port);
        return this;
    }

    public ClusterBuilder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
        this.builder.withLoadBalancingPolicy(policy);
        return this;
    }

    public ClusterBuilder withRetryPolicy(RetryPolicy policy) {
        this.builder.withRetryPolicy(policy);
        return this;
    }

    public Cluster build() {
        this.builder.withoutMetrics();
        this.builder.withCompression(ProtocolOptions.Compression.NONE);
        return this.builder.build();
    }

    private boolean isIBMJRE() {
        return System.getProperty("java.vm.vendor").startsWith("IBM");
    }
}

