/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.ByteArrayOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.FileHashcodeMap;

public class InMemoryZipFileVisitor
implements ZipUtil.ZipEntryVisitor {
    private final FileHashcodeMap fileHashcodeMap = new FileHashcodeMap();
    private final Pattern filesToRealizeRegex;
    private final TemplateEngine templateEngine;
    private final MessageDigestGenerator hashcodeGenerator;

    public InMemoryZipFileVisitor(Pattern filesToRealizeRegex, TemplateEngine templateEngine) {
        if (filesToRealizeRegex == null || templateEngine == null) {
            filesToRealizeRegex = null;
            templateEngine = null;
        }
        this.filesToRealizeRegex = filesToRealizeRegex;
        this.templateEngine = templateEngine;
        this.hashcodeGenerator = new MessageDigestGenerator();
    }

    public FileHashcodeMap getFileHashcodeMap() {
        return this.fileHashcodeMap;
    }

    @Override
    public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
        String hashcode;
        if (entry.isDirectory()) {
            return true;
        }
        String pathname = entry.getName();
        if (this.filesToRealizeRegex != null && this.filesToRealizeRegex.matcher(pathname).matches()) {
            int contentSize = (int)entry.getSize();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(contentSize > 0 ? contentSize : 32768);
            StreamUtil.copy(stream, baos, false);
            String content = this.templateEngine.replaceTokens(baos.toString());
            baos = null;
            hashcode = this.hashcodeGenerator.calcDigestString(content);
        } else {
            hashcode = this.hashcodeGenerator.calcDigestString(stream);
        }
        this.fileHashcodeMap.put(pathname, hashcode);
        return true;
    }
}

