/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.param.InvalidParameterDefinitionException;
import org.rhq.enterprise.communications.command.param.InvalidParameterValueException;
import org.rhq.enterprise.communications.command.param.NoParameterDefinitionsException;
import org.rhq.enterprise.communications.command.param.OptionalParameterDefinitionIterator;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;
import org.rhq.enterprise.communications.command.param.RequiredParameterDefinitionIterator;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public abstract class AbstractCommand
implements Command {
    private static final Logger LOG = CommI18NFactory.getLogger(AbstractCommand.class);
    private CommandType m_commandType;
    private Map<String, ParameterDefinition> m_parameterDefinitions;
    private Map<String, Object> m_commandParameters;
    private boolean m_commandInResponse;
    private Properties m_config;
    private static final long serialVersionUID = 1L;

    public AbstractCommand() throws IllegalArgumentException, InvalidParameterDefinitionException {
        this((Map<String, Object>)null);
    }

    public AbstractCommand(Map<String, Object> commandParameters) throws IllegalArgumentException, InvalidParameterDefinitionException {
        this.initializeMetadata();
        this.m_commandParameters = commandParameters;
        this.m_commandInResponse = false;
        this.m_config = new Properties();
    }

    public AbstractCommand(Command commandToTransform) throws InvalidParameterValueException {
        this.initializeMetadata();
        this.m_commandInResponse = commandToTransform.isCommandInResponse();
        Map<String, Object> parameterValues = commandToTransform.getParameterValues();
        if (parameterValues != null && parameterValues.size() > 0) {
            this.m_commandParameters = new HashMap<String, Object>();
            this.m_commandParameters.putAll(parameterValues);
        }
        if (commandToTransform.allowAnyParameter() && !this.allowAnyParameter()) {
            this.checkParameterValidity(true);
        }
        this.m_config = new Properties();
        if (commandToTransform.getConfiguration() != null) {
            this.m_config.putAll((Map<?, ?>)commandToTransform.getConfiguration());
        }
    }

    @Override
    public CommandType getCommandType() {
        return this.m_commandType;
    }

    @Override
    public boolean isCommandInResponse() {
        return this.m_commandInResponse;
    }

    @Override
    public void setCommandInResponse(boolean flag) {
        this.m_commandInResponse = flag;
    }

    @Override
    public boolean allowAnyParameter() {
        return this.m_parameterDefinitions == null;
    }

    @Override
    public ParameterDefinition getParameterDefinition(String paramName) throws IllegalArgumentException, NoParameterDefinitionsException {
        if (this.m_parameterDefinitions == null) {
            throw new NoParameterDefinitionsException(LOG.getMsgString("AbstractCommand.no-param-def-accepts-all", new Object[0]));
        }
        if (paramName == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-param-name", new Object[0]));
        }
        return this.m_parameterDefinitions.get(paramName);
    }

    @Override
    public ParameterDefinition[] getParameterDefinitions() throws NoParameterDefinitionsException {
        if (this.m_parameterDefinitions == null) {
            throw new NoParameterDefinitionsException(LOG.getMsgString("AbstractCommand.no-param-def-accepts-all", new Object[0]));
        }
        Collection<ParameterDefinition> paramDefs = this.m_parameterDefinitions.values();
        return paramDefs.toArray(new ParameterDefinition[paramDefs.size()]);
    }

    @Override
    public boolean hasParameterValue(String paramName) throws IllegalArgumentException {
        if (paramName == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-param-name", new Object[0]));
        }
        boolean hasValue = false;
        if (this.m_commandParameters != null) {
            hasValue = this.m_commandParameters.containsKey(paramName);
        }
        return hasValue;
    }

    @Override
    public Map<String, Object> getParameterValues() throws IllegalArgumentException {
        HashMap<String, Object> retValues = new HashMap<String, Object>();
        if (this.m_commandParameters != null) {
            retValues.putAll(this.m_commandParameters);
        }
        return retValues;
    }

    @Override
    public Object getParameterValue(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-param-name", new Object[0]));
        }
        Object retValue = null;
        if (this.m_commandParameters != null) {
            retValue = this.m_commandParameters.get(paramName);
        }
        return retValue;
    }

    @Override
    public void setParameterValue(String paramName, Object paramValue) throws IllegalArgumentException {
        if (paramName == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-param-name-set", new Object[0]));
        }
        if (this.m_commandParameters == null) {
            this.m_commandParameters = new HashMap<String, Object>();
        }
        this.m_commandParameters.put(paramName, paramValue);
    }

    @Override
    public void removeParameterValue(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-param-name-remove", new Object[0]));
        }
        if (this.m_commandParameters != null) {
            this.m_commandParameters.remove(paramName);
            if (this.m_commandParameters.isEmpty()) {
                this.m_commandParameters = null;
            }
        }
    }

    @Override
    public void removeParameterValues() {
        if (this.m_commandParameters != null) {
            this.m_commandParameters.clear();
            this.m_commandParameters = null;
        }
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeParameters, boolean includeParameterDefs) {
        StringBuffer strBuf = new StringBuffer("Command: type=[");
        strBuf.append(this.getCommandType());
        strBuf.append("]; cmd-in-response=[");
        strBuf.append(this.m_commandInResponse);
        strBuf.append("]; config=[");
        strBuf.append(this.m_config);
        if (includeParameters) {
            strBuf.append("]; params=[");
            strBuf.append(this.m_commandParameters);
        }
        if (includeParameterDefs) {
            strBuf.append("]; param-defs=[");
            strBuf.append(this.m_parameterDefinitions);
        }
        strBuf.append("]");
        return strBuf.toString();
    }

    @Override
    public void checkParameterValidity(boolean convertIfNecessary) throws InvalidParameterValueException {
        boolean valid;
        Object paramValue;
        ParameterDefinition paramDef;
        if (this.allowAnyParameter()) {
            return;
        }
        Set<String> existingParamNames = this.m_commandParameters != null ? this.m_commandParameters.keySet() : new HashSet<String>();
        Iterator iter = new RequiredParameterDefinitionIterator(this.m_parameterDefinitions.values());
        while (iter.hasNext()) {
            paramDef = (ParameterDefinition)iter.next();
            if (!existingParamNames.contains(paramDef.getName())) {
                throw new InvalidParameterValueException(LOG.getMsgString("AbstractCommand.missing-required-field", new Object[]{paramDef.getName(), this}));
            }
            paramValue = this.getParameterValue(paramDef.getName());
            if (paramDef.isValidValue(paramValue)) continue;
            valid = false;
            if (convertIfNecessary) {
                paramValue = paramDef.convertObject(paramValue);
                valid = true;
                this.m_commandParameters.put(paramDef.getName(), paramValue);
            }
            if (valid) continue;
            throw new InvalidParameterValueException(LOG.getMsgString("AbstractCommand.bad-required-param-type", new Object[]{paramDef.getName(), paramDef.getType(), paramDef.isNullable(), paramValue == null ? "<null>" : paramValue.getClass().toString(), this}));
        }
        iter = new OptionalParameterDefinitionIterator(this.m_parameterDefinitions.values());
        while (iter.hasNext()) {
            paramDef = (ParameterDefinition)iter.next();
            if (!existingParamNames.contains(paramDef.getName()) || paramDef.isValidValue(paramValue = this.getParameterValue(paramDef.getName()))) continue;
            valid = false;
            if (convertIfNecessary) {
                paramValue = paramDef.convertObject(paramValue);
                valid = true;
                this.m_commandParameters.put(paramDef.getName(), paramValue);
            }
            if (valid) continue;
            throw new InvalidParameterValueException(LOG.getMsgString("AbstractCommand.bad-optional-param-type", new Object[]{paramDef.getName(), paramDef.getType(), paramDef.isNullable(), paramValue == null ? "<null>" : paramValue.getClass().toString(), this}));
        }
        for (String paramName : existingParamNames) {
            if (this.m_parameterDefinitions.containsKey(paramName)) continue;
            throw new InvalidParameterValueException(LOG.getMsgString("AbstractCommand.unexpected-param", new Object[]{paramName, this}));
        }
    }

    @Override
    public void convertParameters() {
        if (this.allowAnyParameter() || this.m_commandParameters == null) {
            return;
        }
        HashMap<String, Object> convertedParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.m_commandParameters.entrySet()) {
            String paramName = entry.getKey();
            Object paramValue = entry.getValue();
            try {
                Object convertedParamValue;
                ParameterDefinition def = this.getParameterDefinition(paramName);
                if (def == null || (convertedParamValue = def.convertObject(paramValue)) == paramValue) continue;
                convertedParameters.put(paramName, convertedParamValue);
            }
            catch (NoParameterDefinitionsException ignore) {
                throw new IllegalStateException(LOG.getMsgString("AbstractCommand.should-not-occur", new Object[0]));
            }
        }
        this.m_commandParameters.putAll(convertedParameters);
    }

    @Override
    public Properties getConfiguration() {
        return this.m_config;
    }

    protected Map getParameterValuesInternalMap() {
        return this.m_commandParameters;
    }

    protected void setParameterValuesInternalMap(Map<String, Object> commandParameters) {
        this.m_commandParameters = commandParameters;
    }

    protected void initializeMetadata() throws IllegalArgumentException, InvalidParameterDefinitionException {
        CommandType commandType = this.buildCommandType();
        ParameterDefinition[] parameterDefinitions = this.buildParameterDefinitions();
        if (commandType == null) {
            throw new IllegalArgumentException(LOG.getMsgString("AbstractCommand.null-command-type", new Object[0]));
        }
        this.m_commandType = commandType;
        if (parameterDefinitions != null) {
            this.m_parameterDefinitions = new HashMap<String, ParameterDefinition>();
            for (int i = 0; i < parameterDefinitions.length; ++i) {
                ParameterDefinition paramDef = parameterDefinitions[i];
                String paramName = paramDef.getName();
                if (null == this.m_parameterDefinitions.put(paramName, paramDef)) continue;
                throw new InvalidParameterDefinitionException(LOG.getMsgString("AbstractCommand.dup-defs", new Object[]{paramName}));
            }
        } else {
            this.m_parameterDefinitions = null;
        }
    }

    protected abstract CommandType buildCommandType();

    protected abstract ParameterDefinition[] buildParameterDefinitions();
}

